<?PHP
    @session_start(); 
    include("lib/Sistema.php");  
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ""
    // Creación: 27/10/2022		última modificación: 06/12/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Ventana principal del formulario
    // Última modificación: Almacenamiento del motivo del cambio del periodo anterior
    //                      05/01/2023
    //                      Validación que el texto del motivo sea claro 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "")
    {        
        $origen = $_GET['origen'];

	    // Control de Permisos
	    if(($_SESSION['USERNAME'] == "LFLOREZ") || ($_SESSION['USERNAME'] == "SAIDRODRIGUEZ") || ($_SESSION['USERNAME'] == "DROPOS.NOMINA") || ($_SESSION["SUPERUSUARIO"] == "CHECKED")) 
        {
            // Almaceno el motivo de la edición
            $motivo = $_POST['motivo'];
            $origen = $_POST['origen'];

            if(strlen($origen) == 0)
                $origen = $_GET['origen'];

            // Obtengo el periodo anterior
            if($origen=="superusu")
                $periodoid = $_POST['periodoid'];
            else
            {
                $vsql = "SELECT periodoid 
                           FROM periodosnomina 
                          WHERE periodoid = (SELECT MAX(periodoid) FROM periodosnomina WHERE cerrado = 'CHECKED')";
                $periodoid = $clase->SeleccionarUno($vsql);
            }

            if((strlen($motivo) == 0))
            {
                $clase->Aviso(3,"Debe ingresar el motivo del cambio");

                if($origen=="actdatos")
                    header("Location: calculoliquidados.php?opcion=ventanaliquidados");

                if($origen=="superusu")
                    header("Location: periodosnominaadm.php");

                if($origen=="ajusteext")
                    header("Location: calculoliquidados.php?opcion=ventanaactdatos");
            }
            else
            {
                if(strlen(trim($motivo)) <= 15)
                {
                    $clase->Aviso(3,"Debe ingresar un texto que explique claramente el motivo del cambio a realizar");
                    
                    if($origen=="actdatos")
                        header("Location: calculoliquidados.php?opcion=ventanaliquidados");

                    if($origen=="superusu")
                        header("Location: periodosnominaadm.php");

                    if($origen=="ajusteext")
                        header("Location: calculoliquidados.php?opcion=ventanaactdatos");
                }
                else
                {
                    $vsql = "INSERT INTO logcambiosnomina(tabla,campo,valor,motivo,creador,momento) 
                                    VALUES ('hisdetallenomina','periodoid',".$periodoid.",'".$motivo."','".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";
                    $clase->EjecutarSQL($vsql);
        
                    $params = ' class="Texto11" ';

                    // botón de cancelar
                    if($origen=="actdatos")
                        $hrefcancelar = '<a href="calculoliquidados.php?opcion=ventanaliquidados">';                        
        
                    if($origen=="superusu")
                        $hrefcancelar = '<a href="periodosnominaadm.php">';                        
        
                    if($origen=="ajusteext")
                        $hrefcancelar = '<a href="calculoliquidados.php?opcion=ventanaactdatos">';
            
                    // nombre del periodo
                    $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');        
            
                    // Combo de empleados
                    $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE basico > 0 ORDER BY primernombre";

                    // combo de periodos
                    $vsql = "SELECT periodoid
                              FROM periodosnomina 
                             WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
                    $periodoidact = $clase->SeleccionarUno($vsql);

                    $segundaq = ($periodoidact - 1);
                    $primeraq = ($periodoidact - 2);

                    // $vsqlcomboperiodos = "SELECT periodoid, descripcion FROM periodosnomina WHERE periodoid IN ($primeraq,$segundaq) AND transmitido <> 'CHECKED'";
                    $yearactual = strval(date("Y"));
                    $vsqlcomboperiodos = "SELECT periodoid, descripcion FROM periodosnomina WHERE SUBSTRING(descripcion,-4) = '".$yearactual."' AND periodoid <= ".$periodoidact."";
                    $comboperiodos = $clase->CrearComboBuscar("periodoid",$vsqlcomboperiodos,"descripcion","periodoid",$periodoid,"N",$params,350);
            
                    $cont = $clase->Header("S","W");
                    $cont.='<form action="?opcion=validaempleado" method="POST" name="x">
                            <input type="hidden" name="periodoid" value="'.$periodoid.'">
                            <input type="hidden" name="origen" value="'.$origen.'">
                            <table width="100%">
                             <tr class="CabezoteTabla"> 
                              <td width="10"> &nbsp; </td>
                              <td width="37"> <img src="images/iconos/calculando.png" width="32" height="32" border="0"> </td>
                              <td width="700"> <b>Ajuste extemporáneo </b> <font color="blue"> <br>Sólo para administradores <br> del sistema </font> </td>
                              <td width="10"> &nbsp; </td>
                              <td width="212"> &nbsp; </td>                  
                              <td width="10"> 
                               <a href="?opcion=macroperanterior&periodoid='.$periodoid.'" title="generar macro" target="_blank"> 
                                <img src="images/iconos/exportarexcel2.png" border="0"> 
                               </a> 
                              </td>
                              <td width="10"> &nbsp; </td>
                             </tr>
                             <tr class="CabezoteTabla"> 
                              <td width="10"> &nbsp; </td>
                              <td width="37"> &nbsp; </td>
                              <td width="700"> Periodo: &nbsp;&nbsp; '.$comboperiodos.' </td>
                              <td width="212"> &nbsp; </td> 
                              <td width="10"> &nbsp; </td>
                              <td width="10"> &nbsp; </td>
                             </tr>
                             <tr class="CabezoteTabla"> 
                              <td width="10"> &nbsp; </td>
                              <td width="37"> &nbsp; </td>
                              <td width="700"> Empleado: '.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","N",$params,460).' </td>
                              <td width="212"> &nbsp; </td> 
                              <td width="10"> &nbsp; </td>
                              <td width="10"> &nbsp; </td>
                             </tr>
                            </table>';
            
                    $cont.='<table width="100%">
                             <tr class="CabezoteTabla">
                              <td align="center">                    
                               <input type="submit" value="aceptar" class="button blue">
                               </form>
                               '.$hrefcancelar.'<input type="button" value="CANCELAR" class="button red"></a>
                              </td>
                             </tr>
                            </table>';
    
                    // Pie de página
                    $cont.='<table width="100%"> 
                             <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                            </table>';
                }
            }
        }
        else
        {
            $clase->Aviso(2,"Acceso No Permitido"); 
            // header("Location: calculoliquidados.php?opcion=ventanaliquidados"); 

            if($origen=="actdatos")
                header("Location: calculoliquidados.php?opcion=ventanaliquidados");

            if($origen=="superusu")
                header("Location: periodosnominaadm.php");

            if($origen=="ajusteext")
                header("Location: calculoliquidados.php?opcion=ventanaactdatos");
        }        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: validaempleado
    // Creación: 27/10/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que valida la selección del empleado y del periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "validaempleado")
    {
        $terid = $_POST['terid'];
        $periodoid = $_POST['periodoid'];
        $origen = $_POST['origen'];

        // Nombre del empleado
        $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombre FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql);

        // nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');        

        $vsql = "SELECT COUNT(*) AS regemp FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $regemp = $clase->SeleccionarUno($vsql);        

        // Valido que el empleado haya trabajado en el periodo
        if($regemp == 0)
        {
            $clase->Aviso(3,"$nombreemp no laboró en el periodo $descripcion");
            header("Location: ajusteextemporaneo.php?opcion=editarextnomina&periodoid=$periodoid");
        }
        else
        {
            $lb_reportado = false;
            $consecutivone = "";

            $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
            $diadesde = substr($fecdesde, -2);
            
            if($diadesde=="16")
                $consecutivone = $clase->BDLockup($periodoid,'periodosnomina','periodoid','consecutivone');                

            if(strlen($consecutivone)>0)        $lb_reportado = true;

            // // Valido que el periodo a modificar no esté reportado
            // if($lb_reportado)
            // {                
            //     $clase->Aviso(3,"El periodo $descripcion ya ha sido reportado en nómina electrónica");
            //     header("Location: ajusteextemporaneo.php");
            // }
            // else            
                header("Location: ajusteextemporaneo.php?opcion=ventanaajusteext&periodoid=$periodoid&terid=$terid&origen=$origen");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ventanaajusteext
    // Creación: 27/10/2022		última modificación: 11/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana donde se captarán los datos que serán 
    //              recalculados
    // Última modificación: Impresión de la condición de extralegal en caso de tenerla 
    //                      (30/12/2022)
    //                      Impresión de la posible condición de extralegal al lado de la 
    //                      sección (19/01/2023)
    //                      Inclusión del botón para editar devengado y saldo del sueldo
    //                      (24/08/2023)
    //                      No aplicar el descuento a la incapacidad superior a 180 días
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaajusteext")
    {
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];
        $origen2 = $_GET['origen'];

        // Nombre del empleado
        $vsql = "SELECT nombre FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $nombreemp = $clase->SeleccionarUno($vsql);

        $vsql = "SELECT dni FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $dni = $clase->SeleccionarUno($vsql);        

        // nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // días trabajados
        $vsqldatos = "SELECT valor AS diastrab FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid=1";
        $diastrab = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // sueldo
        $vsqldatos = "SELECT devengados AS sueldo FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid=1";
        $sueldo = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // auxilio de transporte
        $vsqldatos = "SELECT devengados AS auxtransporte FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid=3";
        $auxtransporte = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // pensión
        $vsqldatos = "SELECT descuentos AS pension FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid=4";
        $pension = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // salud
        $vsqldatos = "SELECT descuentos AS salud FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid=5";
        $salud = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Salario básico
        $vsqldatos = "SELECT basico FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $basico = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // La sección
        $vsqldatos = "SELECT s.descripcionsec 
                        FROM periodoterceros t
                             INNER JOIN seccion s ON (t.seccionid = s.seccionid) 
                       WHERE t.terid = ".$terid."
                             AND t.pernominaid = ".$periodoid;
        $seccion = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // El cargo
        $vsqldatos = "SELECT c.descripcioncargo 
                        FROM periodoterceros t
                             INNER JOIN cargos c ON (t.cargoid = c.cargoid) 
                       WHERE t.terid = ".$terid."
                             AND t.pernominaid = ".$periodoid;
        $cargo = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Posible condición de extralegal
        $vsql = "SELECT extralegal FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $extralegal = $clase->SeleccionarUno($vsql);
         
        if($extralegal == "CHECKED")
            $condicionextralegal = "(EXTRALEGAL)";
        else
            $condicionextralegal = "";

        // Validación del usuario para el redireccionamiento
        if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED")) 
        {
            $origen = "ajusteext";
            $href = '<a href="calculoliquidados.php?opcion=ventanaactdatos">';
        }
        else
            $href = '<a href="ajusteextemporaneo.php?opcion=editarextnomina&periodoid='.$periodoid.'">';

        if($origen2 == "superusu")
            $href = '<a href="periodosnominaadm.php">';

        if($origen2 == "actdatos")
            $href = '<a href="calculoliquidados.php?opcion=ventanaliquidados">';

        // pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/calculando.png" width="32" height="32" border="0"> </td>
                  <td width="844"> <b>Ajuste extemporáneo </b> <font color="blue"> <br> '.$descripcion.' </font> </td>                  
                  <td width="10"> &nbsp; </td>
                  <td width="24"> 
                   <a href="?opcion=editdevsaldo&terid='.$terid.'&periodoid='.$periodoid.'" title="editar devengado y saldo" rel="facebox"> 
                    <img src="images/iconos/configuracion.png" border="0" width="32" height="32">  
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="24"> 
                   <a href="?opcion=editarbasico&terid='.$terid.'&periodoid='.$periodoid.'" title="editar salario básico" rel="facebox"> 
                    <img src="images/iconos/aspectos.png" border="0" width="32" height="32">  
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="24"> 
                   <a href="?opcion=editarlicencia&terid='.$terid.'&periodoid='.$periodoid.'" target="_blank">
                    <img src="images/iconos/gastos.png" title="licencias" border="0" width="32" height="32">
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="24"> 
                   <a href="?opcion=editarconcepto&terid='.$terid.'&periodoid='.$periodoid.'" target="_blank">
                    <img src="images/iconos/egresos.png" title="descuentos ocasionales" border="0" width="32" height="32">
                   </a>
                  </td>                   
                  <td width="10"> &nbsp; </td>                  
                  <td width="24"> 
                   <a href="?opcion=editarlibyperm&terid='.$terid.'&periodoid='.$periodoid.'" target="_blank">
                    <img src="images/iconos/cotizar.png" title="libranzas y descuentos permanentes" border="0" width="32" height="32">
                   </a>
                  </td>                   
                  <td width="10"> &nbsp; </td>
                  <td width="24"> 
                   <a href="?opcion=incluirrecargos&terid='.$terid.'&periodoid='.$periodoid.'" rel="facebox">
                    <img src="images/iconos/park.png" title="incluir recargo" border="0" width="32" height="32">
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="24"> 
                   <a href="?opcion=ventanaelimconp&terid='.$terid.'&periodoid='.$periodoid.'" target="_blank">
                    <img src="images/iconos/eliminardoc.png" title="eliminar concepto" border="0" width="32" height="32">
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="24"> 
                   <a href="?opcion=ventanaelimempl&terid='.$terid.'&periodoid='.$periodoid.'" rel="facebox">
                    <img src="images/iconos/anulardoc.png" title="eliminar empleado" border="0" width="32" height="32">
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>                  
                  <td width="24">
                   <a href="recibodepago.php?opcion=reciboindividual&terid='.$terid.'&periodoid='.$periodoid.'" target="_blank">
                    <img src="images/iconos/pdf.png" title="Recibo" border="0" width="32" height="32">
                   </a>
                  </td>                   
                  <td width="10"> &nbsp; </td>
                  <td width="24"> '.$href.' <input type="button" value="<<" class="button blue"></a> </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<form action="?opcion=recalcularemp" name="y" method="POST">
                <input type="hidden" name="basico" value="'.$basico.'">
                <input type="hidden" name="terid" value="'.$terid.'">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="10">&nbsp;  </td>
                  <td width="37">&nbsp;  </td>
                  <td width="413"><label class="Texto12">Documento:</label> '.$dni.'</td>
                  <td width="227">&nbsp;</td>                  
                  <td width="359">&nbsp;</td>                  
                 </tr>                
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="10">&nbsp;  </td>
                  <td width="37">&nbsp;  </td>
                  <td width="413"><label class="Texto12">Empleado(a):</label> '.$nombreemp.'</td>
                  <td width="227">&nbsp;</td>                  
                  <td width="359">&nbsp;</td>                  
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="10">&nbsp;  </td>
                  <td width="37">&nbsp;  </td>
                  <td width="413"><label class="Texto12">Secci&oacute;n:</label> '.$seccion.' '.$condicionextralegal.'</td>
                  <td width="227">&nbsp;</td>                  
                  <td width="359">&nbsp;</td>                  
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="10">&nbsp;  </td>
                  <td width="37">&nbsp;  </td>
                  <td width="413"><label class="Texto12">Cargo:</label> '.$cargo.'</td>
                  <td width="227">&nbsp;</td>                  
                  <td width="359">&nbsp;</td>                  
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="10">&nbsp;  </td>
                  <td width="37">&nbsp;  </td>
                  <td width="413"><label class="Texto12"> Salario b&aacute;sico:</label> '.number_format($basico).'</td>
                  <td width="227">&nbsp;</td>
                  <td width="359">&nbsp;</td>                  
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="10">&nbsp;  </td>
                  <td width="37">&nbsp;  </td>
                  <td width="413"><label class="Texto12">D&iacute;as trabajados:</label>
                   <input type="number" name="diastrab" min="0" max="15" class="Texto11New" size="2" style="width:100px;height:25px;" autocomplete="off" title="d&iacute;as trabajados" value="'.$diastrab.'">                  
                  </td>
                  <td width="227"><label class="Texto12">Sueldo: </label>'.number_format($sueldo).'</td>                  
                  <td width="359"><label class="Texto12">Transporte:</label> '.number_format($auxtransporte).'</td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="10">&nbsp;  </td>
                  <td width="37">&nbsp;  </td>
                  <td width="413"><label class="Texto12">Pensi&oacute;n:</label> '.number_format($pension).'</td>
                  <td width="227"><label class="Texto12">Salud:</label> '.number_format($salud).'</td>
                  <td width="359">&nbsp;</td>
                 </tr>
                </table>';        

        $cont.='<table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <center>
                  <td width="657" align="center">                    
                   <input type="submit" value="recalcular" class="button blue">
                   </form>
                  </td>
                  </center>
                 </tr>
                </table>';

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="12">&nbsp;  </td>
                   <td width="290"> Concepto </td>
                   <td width="320" align="right"> Devengados </td>			
                   <td width="23" align="right">&nbsp;</td>
                   <td width="320" align="right">Descuentos </td>
                   <td width="60">&nbsp;</td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:150px; overflow-Y:scroll">';        

        // Consulta con los demás conceptos del empleado en el periodo
        $vsql = "SELECT c.nomconcepto, d.devengados, d.descuentos, c.tipodc, d.conceptoid 
                   FROM hisdetallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.pernominaid = ".$periodoid."
                        AND d.terid = ".$terid."
                        AND d.conceptoid NOT IN (1,3,4,5)
               ORDER BY c.tipodc, c.codconcepto";               

        // Conexión a la base de datos
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);

        // Inicialización de variables
        $totdevengado = 0;
        $totdescuento = 0;
        $netoapagar = 0;

        // Validación de la ejecución del ciclo        
        if($cant>0)
        {            
            $i = 0;
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
    
                $cont.=' <td width="12">&nbsp;  </td>
                         <td width="290"> '.$row['nomconcepto'].' </td>';

                // Impresión del monto si es un devengado
                if($row['tipodc']=="C")
                {
                    $cont.=' <td width="320" align="right">'.number_format($row['devengados']).' </td>
                             <td width="23" align="right"> &nbsp; </td>
                             <td width="320" align="right"> &nbsp; </td>
                             <td width="60"> &nbsp; </td>
                            </tr>';

                    $totdevengado += $row['devengados'];
                }

                // Impresión del monto si es un descuento
                if($row['tipodc']=="D")
                {
                    $cont.=' <td width="320" align="right"> &nbsp; </td>
                             <td width="23" align="right"> &nbsp; </td>
                             <td width="320" align="right">'.number_format($row['descuentos']).' </td>
                             <td width="60"> &nbsp; </td>
                            </tr>';
                                                                                                  
                    if(($row['conceptoid']!=6)&&($row['conceptoid']!=9)&&($row['conceptoid']!=43)&&($row['conceptoid']!=58))
                        $totdescuento += $row['descuentos'];
                }
            }
        }

        $cont.=' </tbody>
                </table>';            

        // Cálculo de los totales
        $totdevengado += ($sueldo + $auxtransporte);
        $totdescuento += ($pension + $salud);
        $netoapagar = $totdevengado - $totdescuento;

        // Impresión de los totales
        $cont.='<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="261"> &nbsp; </td>
                  <td width="375" align="right"> <font color="WHITE"> <b> Total devengado: </b> '.number_format($totdevengado).' </font> </td>
                  <td width="375" align="right"> <font color="WHITE"> <b> Total descuentos: </b> '.number_format($totdescuento).' </font> </td>
                  <td width="375" align="right"> <font color="WHITE"> <b> Neto a pagar: </b> '.number_format($netoapagar).' </font> </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: recalcularemp
    // Creación: 27/10/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que realiza los recálculos del empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "recalcularemp")
    {
        $diastrab = $_POST['diastrab'];
        $basico = $_POST['basico'];
        $terid = $_POST['terid'];
        $periodoid = $_POST['periodoid'];
        
        // Validación de la cantidad de días trabajados
        if($diastrab > 15)
        {
            $clase->Aviso(3,"La cantidad de días trabajados no puede ser mayor a 15");
            header("Location: ajusteextemporaneo.php?opcion=ventanaajusteext&periodoid=$periodoid&terid=$terid");
        }
        else
        {
            // Obtengo el salario mínimo legal vigente
            $smlv = $_SESSION['N_SALMIN2020'];

            // Obtengo la formula del sueldo
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
            $formulabasico = $clase->SeleccionarUno($vsql);

            // Calculo el sueldo básico
            eval("\$sueldo = $formulabasico;");
            $sueldo = round($sueldo,0);
         
            // ------------------------------------------------------------------------------------------------------------------------------------------- //
            // Sueldo en detallenomina

            // ID  del sueldo
            $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
            $idsueldo = $clase->SeleccionarUno($vsql);

            // Grabo el sueldo y los días trabajados
            if($idsueldo!="")
            {
                $vsql = "UPDATE detallenomina SET 
                                devengados = ".$sueldo.",
                                valor = ".$diastrab."
                          WHERE detalleid = ".$idsueldo."";
                $clase->EjecutarSQL($vsql);
            }
            else
            {
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",1,".$periodoid.",".$sueldo.",0,".$diastrab.",$basico)";
                $clase->EjecutarSQL($vsql);
            }

            // ------------------------------------------------------------------------------------------------------------------------------------------- //
            // Sueldo en hisdetallenomina

            // ID  del sueldo
            $vsql = "SELECT detalleid AS idtransporte FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
            $idsueldoh = $clase->SeleccionarUno($vsql);

            // Grabo el sueldo y los días trabajados
            if($idsueldoh!="")
            {
                $vsql = "UPDATE hisdetallenomina SET 
                                devengados = ".$sueldo.",
                                valor = ".$diastrab."
                          WHERE detalleid = ".$idsueldoh;
                $clase->EjecutarSQL($vsql);
            }
            else
            {
                $vsql = "SELECT max(detalleid) FROM hisdetallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO hisdetallenomina VALUES ($numreg+1,".$terid.",1,".$periodoid.",".$sueldo.",0,".$diastrab.",$basico)";
                $clase->EjecutarSQL($vsql);
            }

            if($diastrab > 0)
            {
                // Recalculo el subsidio de transporte
                $valsubtrasp = $smlv * 2;       // Variable para la validación del auxilio de transporte
    
                // Obtengo la formula para el subsidio de transporte
                $auxtrans = $_SESSION['N_AUXTRANS2020'];
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                $formulatransporte = $clase->SeleccionarUno($vsql);
    
                // ------------------------------------------------------------------------------------------------------------------------------------ //            
                // Obtengo el cargo del empleado
                $vsqldatos = "SELECT cargoid FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
                $cargoid = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";
    
                $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');           // Obtengo el control del cálculo de subsidio de transporte
    
                if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                {
                    // Calculo el subsidio de transporte
                    eval("\$subsidiotransporte = $formulatransporte;");
                    $subsidiotransporte = round($subsidiotransporte,0);
                }
                else
                    $subsidiotransporte = 0;
            }
            else
                $subsidiotransporte = 0;

            // // ------------------------------------------------------------ //
            // // Le coloco subsidio de transporte en cero a 
            // // quienes devengan un básico de 750.000 pesos
            // if($basico==750000)
            //     $subsidiotransporte = 0;
            // // ------------------------------------------------------------ //

            // transporte en detallenomina

            // ID transporte
            $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
            $idtransporte = $clase->SeleccionarUno($vsql);

            // Grabo el subsidio de transporte
            if(strlen($idtransporte)>0)
                $vsql = "UPDATE detallenomina SET 
                                devengados = ".$subsidiotransporte.",
                                valor = ".$diastrab."
                          WHERE detalleid = ".$idtransporte;
            else
            {
                // Obtengo el valor del subsidio de transporte
                $valsubtransporte = $_SESSION['N_AUXTRANS2020'];

                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
            }
            $clase->EjecutarSQL($vsql);

            // transporte en hisdetallenomina

            // ID transporte
            $vsql = "SELECT detalleid AS idtransporte FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
            $idtransporteh = $clase->SeleccionarUno($vsql);

            // Grabo el subsidio de transporte
            if(strlen($idtransporteh)>0)
                $vsql = "UPDATE hisdetallenomina SET 
                                devengados = ".$subsidiotransporte.",
                                valor = ".$diastrab."
                          WHERE detalleid = ".$idtransporteh;
            else
            {
                // Obtengo el valor del subsidio de transporte
                $valsubtransporte = $_SESSION['N_AUXTRANS2020'];

                $vsql = "SELECT max(detalleid) FROM hisdetallenomina";
                $numregh = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO hisdetallenomina VALUES ($numregh+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
            }
            $clase->EjecutarSQL($vsql);

            // Determino si es extralegal
            $vsqldatos = "SELECT extralegal FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
            $extralegal = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // Determino la eps
            $vsqldatos = "SELECT epsid FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
            $epsid = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // Fondo de pensiones
            $vsqldatos = "SELECT pensionesid FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
            $pensionesid = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
            
            if($epsid==NULL)                $epsid=0;
            if($pensionesid==NULL)          $pensionesid=0;

            $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                       FROM hisdetallenomina d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
            $totnovedades = $clase->SeleccionarUno($vsql);

            $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                       FROM detallenomina d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
            $totrecargos = $clase->SeleccionarUno($vsql);

            $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

            // ---------------------------------------------------------------------------------------------------------------------------------------------------- //
            $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
            $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud

            if($extralegal=="CHECKED")
            {
                $pension = 0;
                $salud = 0;
            }
            else
            {
                // Recalculo pensión y salud
                if(($pensionesid==5)||($aplicapension!="CHECKED"))
                    $pension = 0;
                else
                {
                    // Obtengo la formula para el descuento por pensión
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                    $formulapension = $clase->SeleccionarUno($vsql);

                    // Calculo la pensión
                    eval("\$pension = $formulapension;");
                    $pension = round($pension,0);
                }

                if(($epsid==37)||($aplicasalud!="CHECKED"))
                    $salud = 0;
                else
                {
                    // Obtengo la formula para el descuento de salud
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                    $formulasalud = $clase->SeleccionarUno($vsql);
                    
                    // Calculo la salud
                    eval("\$salud = $formulasalud;");
                    $salud = round($salud,0);
                }
            }
            // ---------------------------------------------------------------------------------------------------------------------------------------------------- //

            // pensión en detallenomina

            //  ID pensión
            $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
            $idpension = $clase->SeleccionarUno($vsql);

            // Grabo la pensión
            if($idpension!="")
                $vsql = "UPDATE detallenomina SET 
                                descuentos = ".$pension.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idpension;
            else
            {
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
            }
            $clase->EjecutarSQL($vsql);

            // pensión en hisdetallenomina

            //  ID pensión
            $vsql = "SELECT detalleid AS idpension FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
            $idpension = $clase->SeleccionarUno($vsql);

            // Grabo la pensión
            if($idpension!="")
                $vsql = "UPDATE hisdetallenomina SET 
                                descuentos = ".$pension.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idpension;
            else
            {
                $vsql = "SELECT max(detalleid) FROM hisdetallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO hisdetallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
            }
            $clase->EjecutarSQL($vsql);

            // salud en detallenomina

            // ID salud
            $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
            $idsalud = $clase->SeleccionarUno($vsql);

            // Grabo la salud
            if($idsalud!="")
                $vsql = "UPDATE detallenomina SET 
                                descuentos = ".$salud.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idsalud;
            else
            {
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
            }
            $clase->EjecutarSQL($vsql);

            // salud en hisdetallenomina

            // ID salud
            $vsql = "SELECT detalleid AS idsalud FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
            $idsalud = $clase->SeleccionarUno($vsql);

            // Grabo la salud
            if($idsalud!="")
                $vsql = "UPDATE hisdetallenomina SET 
                                descuentos = ".$salud.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idsalud;
            else
            {
                $vsql = "SELECT max(detalleid) FROM hisdetallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO hisdetallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
            }
            $clase->EjecutarSQL($vsql);

            // valido el cálculo de libranzas y descuentos permanentes
            $cal_libranza = $_SESSION['G_CAL_LIBRANZA'];
            if($cal_libranza=="CHECKED")
            {
                // ---------------------------------------------------------------------------------------------------------------------------------------------- //
                // Elimino las libranzas y los descuentos permanentes para volverlos a ingresar
                // en detallenomina
                $vsql8 = "SELECT d.detalleid  
                            FROM detallenomina d
                                 INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)     
                           WHERE d.terid = ".$terid." 
                                 AND d.pernominaid = ".$periodoid."  
                                 AND (c.eslibranza = 'CHECKED' OR c.montopermanente='CHECKED')";

                $conex   = $clase->Conectar();
                $result8 = mysql_query($vsql8,$conex);
                $cant8   = mysql_num_rows($result8);
                if($cant8>0)
                {
                    while($row8 = mysql_fetch_array($result8))
                    {
                        $detalleelim = $row8['detalleid'];
                        $vsql = "DELETE FROM detallenomina WHERE detalleid = ".$detalleelim;
                        $clase->EjecutarSQL($vsql);
                    }
                }

                // en hisdetallenomina
                $vsql80 = "SELECT d.detalleid  
                            FROM hisdetallenomina d
                                 INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)     
                           WHERE d.terid = ".$terid." 
                                 AND d.pernominaid = ".$periodoid."  
                                 AND (c.eslibranza = 'CHECKED' OR c.montopermanente='CHECKED')";

                $conex   = $clase->Conectar();
                $result80 = mysql_query($vsql80,$conex);
                $cant80   = mysql_num_rows($result80);
                if($cant80>0)
                {
                    while($row80 = mysql_fetch_array($result80))
                    {
                        $detalleelim = $row80['detalleid'];
                        $vsql = "DELETE FROM hisdetallenomina WHERE detalleid = ".$detalleelim;
                        $clase->EjecutarSQL($vsql);
                    }
                }

                // ---------------------------------------------------------------------------------------------------------------------------------------------- //
                // Nuevo proceso para las libranzas utilizando la nueva tabla “libranzas”
                $vsql2 = "SELECT conceptoid, monto, tipoquincena
                            FROM libranzas 
                           WHERE terid = ".$terid."
                                 AND (cuotaspagadas < totalcuotas)";
    
                $conex  = $clase->Conectar();
                $result2 = mysql_query($vsql2,$conex);
                $cant   = mysql_num_rows($result2);
                if($cant>0)
                {
                    while($row2 = mysql_fetch_array($result2))
                    {
                        // en detallenomina
                        // Calculo el nuevo ID
                        $vsql3 = "SELECT max(detalleid) FROM detallenomina";
                        $numid = $clase->SeleccionarUno($vsql3);
                        $numid++;
    
                        // Obtengo el monto a descontar por concepto de esta libranza
                        $monto = $row2['monto'];
                        $conceptoid = $row2['conceptoid'];
                        $tipoquincena = $row2['tipoquincena'];
    
                        // Verifico si el concepto ya está incluido para este empleado
                        $vsql5 = "SELECT COUNT(detalleid) AS repetido FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = ".$conceptoid."";
                        $repetido = $clase->SeleccionarUno($vsql5);
    
                        if($repetido==0)
                        {
                            // Valido si la libranza se puede descontar en esta quincena
                            if($tipoquincena=="ambas")
                            {
                                // Almaceno el nuevo concepto por libranza
                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                $clase->EjecutarSQL($vsql);
                            }
                            else
                            {
                                $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                                $diadesde = substr($fecdesde, -2);
        
                                if(($tipoquincena=="primera")&&($diadesde=="01"))
                                {
                                    // Almaceno el nuevo concepto por libranza
                                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                    $clase->EjecutarSQL($vsql);
                                }
        
                                if(($tipoquincena=="segunda")&&($diadesde=="16"))
                                {
                                    // Almaceno el nuevo concepto por libranza
                                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                    $clase->EjecutarSQL($vsql);
                                }
                            }
                        }

                        // en hisdetallenomina

                        // Calculo el nuevo ID
                        $vsql30 = "SELECT max(detalleid) FROM hisdetallenomina";
                        $numid = $clase->SeleccionarUno($vsql30);
                        $numid++;
    
                        // Verifico si el concepto ya está incluido para este empleado
                        $vsql50 = "SELECT COUNT(detalleid) AS repetido FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = ".$conceptoid."";
                        $repetido = $clase->SeleccionarUno($vsql50);
    
                        if($repetido==0)
                        {
                            // Valido si la libranza se puede descontar en esta quincena
                            if($tipoquincena=="ambas")
                            {
                                // Almaceno el nuevo concepto por libranza
                                $vsql = "INSERT INTO hisdetallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                $clase->EjecutarSQL($vsql);
                            }
                            else
                            {
                                $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                                $diadesde = substr($fecdesde, -2);
        
                                if(($tipoquincena=="primera")&&($diadesde=="01"))
                                {
                                    // Almaceno el nuevo concepto por libranza
                                    $vsql = "INSERT INTO hisdetallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                    $clase->EjecutarSQL($vsql);
                                }
        
                                if(($tipoquincena=="segunda")&&($diadesde=="16"))
                                {
                                    // Almaceno el nuevo concepto por libranza
                                    $vsql = "INSERT INTO hisdetallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                    $clase->EjecutarSQL($vsql);
                                }
                            }
                        }
                    }
                }
            }

            // Verifico si tiene conceptos permanentes
            $cal_permanente = $_SESSION['G_CAL_PERMANENTE'];
            if($cal_permanente=="CHECKED")
            {
                $vsql6 = "SELECT conceptoid, monto, tipoquincena 
                            FROM descuentospermanente 
                           WHERE terid = ".$terid."";
    
                $conex  = $clase->Conectar();
                $result6 = mysql_query($vsql6,$conex);
                $cant   = mysql_num_rows($result6);
                if($cant>0)
                {
                    while($row6 = mysql_fetch_array($result6))
                    {
                        // en detallenomina
                        // Calculo el nuevo ID
                        $vsql7 = "SELECT max(detalleid) FROM detallenomina";
                        $numid = $clase->SeleccionarUno($vsql7);
                        $numid++;
    
                        // Obtengo el monto a descontar por concepto de este concepto
                        $monto = $row6['monto'];
                        $conceptoid = $row6['conceptoid'];
                        $tipoquincena = $row6['tipoquincena'];
    
                        // Valido si el concepto se puede descontar en esta quincena
                        if($tipoquincena=="ambas")
                        {
                            // Almaceno el nuevo concepto permanente
                            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                        VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                            $clase->EjecutarSQL($vsql);
                        }
                        else
                        {
                            $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                            $diadesde = substr($fecdesde, -2);
    
                            if(($tipoquincena=="primera")&&($diadesde=="01"))
                            {
                                // Almaceno el nuevo concepto permanente
                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                $clase->EjecutarSQL($vsql);
                            }
    
                            if(($tipoquincena=="segunda")&&($diadesde=="16"))
                            {
                                // Almaceno el nuevo concepto permanente
                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                $clase->EjecutarSQL($vsql);
                            }
                        }

                        // en hisdetallenomina
                        
                        // Calculo el nuevo ID
                        $vsql70 = "SELECT max(detalleid) FROM hisdetallenomina";
                        $numid = $clase->SeleccionarUno($vsql70);
                        $numid++;
    
                        // Valido si el concepto se puede descontar en esta quincena
                        if($tipoquincena=="ambas")
                        {
                            // Almaceno el nuevo concepto permanente
                            $vsql = "INSERT INTO hisdetallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                        VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                            $clase->EjecutarSQL($vsql);
                        }
                        else
                        {
                            $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                            $diadesde = substr($fecdesde, -2);
    
                            if(($tipoquincena=="primera")&&($diadesde=="01"))
                            {
                                // Almaceno el nuevo concepto permanente
                                $vsql = "INSERT INTO hisdetallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                $clase->EjecutarSQL($vsql);
                            }
    
                            if(($tipoquincena=="segunda")&&($diadesde=="16"))
                            {
                                // Almaceno el nuevo concepto permanente
                                $vsql = "INSERT INTO hisdetallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                $clase->EjecutarSQL($vsql);
                            }
                        }
                    }
                }
            }

            // Aquí depuro los conceptos que estén en cero
            $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid = ".$periodoid." AND terid = ".$terid."";
            $clase->EjecutarSQL($vsql);

            $vsql = "DELETE FROM hisdetallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid = ".$periodoid." AND terid = ".$terid."";
            $clase->EjecutarSQL($vsql);

            // Redirecciono a la ventana de ajustes
            $clase->Aviso(2,"Proceso de recalculo culminado satisfactoriamente");
            header("Location: ajusteextemporaneo.php?opcion=ventanaajusteext&periodoid=$periodoid&terid=$terid");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: editarbasico
    // Creación: 28/10/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana que captará el nuevo salario básico
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarbasico")
    {
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];        

        // Salario básico
        $vsqldatos = "SELECT basico FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $basico = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // id de periodoterceros
        $vsqldatos = "SELECT idperter FROM periodoterceros WHERE pernominaid = ".$periodoid." AND terid = ".$terid;
        $idperter = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";        

        // Variable para el nombre de empleado
        $vsqldatos = "SELECT nombre FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Variable para el nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Pintamos la ventana        
        $cont.='<table width="400">
                 <tr class="CabezoteTabla">
                  <td align="center"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td align="center"> <b>Edici&oacute;n del salario b&aacute;sico del empleado </b><br><font color="BLUE">'.$nombreemp.'</font> <br> <b>periodo </b><br><font color="BLUE">'.$descripcion.'</font> </td>
                 </tr> 
                </table>                
                <form action="?opcion=guardarbasico" name="y" method="POST">
                <input type="hidden" name="idperter" value="'.$idperter.'">                
                <input type="hidden" name="terid" value="'.$terid.'">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <table width="400">
                 <tr class="CabezoteTabla">
                  <td align="center"><label class="Texto12">B&aacute;sico:</label>
                   <input type="number" name="basico" min="0" class="Texto11New" size="2" autocomplete="off" title="basico" value="'.$basico.'">                  
                  </td>                  
                 </tr>
                </table>
                <table width="400">
                 <tr class="CabezoteTabla">
                  <td align="center">                    
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardarbasico
    // Creación: 28/10/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción guarda el nuevo salario básico
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarbasico")
    {
        $terid = $_POST['terid'];
        $periodoid = $_POST['periodoid'];
        $idperter = $_POST['idperter'];
        $basico = $_POST['basico'];

        // Almaceno los cambios
        $vsql = "UPDATE periodoterceros SET 
                        basico = ".$basico."
                  WHERE idperter = ".$idperter;
        $clase->EjecutarSQL($vsql);

        // Envío el mensaje correspondiente
        if(mysql_affected_rows() < 1)
            $clase->Aviso(3,"No se guardó el salario básico");
        else
            $clase->Aviso(1,"Salario básico guardado satisfactoriamente");

        // Redirecciono a la ventana de ajustes
        header("Location: ajusteextemporaneo.php?opcion=ventanaajusteext&periodoid=$periodoid&terid=$terid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: editarlicencia
    // Creación: 28/10/2022		última modificación: 26/06/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana donde se captará la nueva licencia
    // Última modificación: Validación de uso de la fecha según configuración establecida
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "editarlicencia")
    {
        $periodoid = $_GET['periodoid'];
        $terid = $_GET['terid'];

        // Nombre del periodo
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Variable para el nombre de empleado
        $vsqldatos = "SELECT nombre FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Combo de licencias
        $vsqlcombolic = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) FROM conceptosnomina WHERE eslicencia='CHECKED' ORDER BY conceptoid";

        // Configuración
        $params = ' class="Texto11" ';
        $dias = 1;

        // Fechas del periodo
        $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
        $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');        
        
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/calculando.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Ajuste extemporáneo </b><br> Novedades  <font color="blue"> <br> '.$descripcion.' </font> </td>                  
                  <td width="24"> &nbsp; </td>
                  <td width="24"> 
                   <a href="ajusteextemporaneo.php?opcion=ventanaajusteext&periodoid='.$periodoid.'&terid='.$terid.'"> <input type="button" value="<<" class="button"></a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<center>
                <form action="?opcion=almlicencias" method="POST">
                 <input type="hidden" name="periodoid" value="'.$periodoid.'">
                 <input type="hidden" name="terid" value="'.$terid.'">
                  <fieldset style="width: 530px; height: 325px;" class="grupos">
                  <legend class="titgrupos"> Datos </legend>
                  <table width="350">
                   <tr height="55">
                    <td> 
                     <label class="Texto12"> <b>Empleado: </b></label><br>
                     <label class="Texto12"> '.$nombreemp.' </label>
                    </td>                   
                   </tr>                    
                   <tr height="55">
                    <td> <label class="Texto12"> <b>Licencia:</b></label><br>'.$clase->CrearComboBuscar("conceptoid",$vsqlcombolic,"nombres","conceptoid","","N",$params,420).' </td>                   
                   </tr>
                   <tr height="55">
                    <td> ';

        $variab = 'G_NOFECHALIC';
        $nofechalic = $clase->BDLockup($variab,'configuraciones','variab','contenido');

        if($nofechalic == "CHECKED")
            $cont.=' <label class="Texto12"> <b><font color="gray">Fecha desde:</label></b></label><br> 
                        <input type="date" name="fecdesde" class="Texto12New" autocomplete="off" value = "'.$fecdesde.'" disabled>';
        else
            $cont.=' <label class="Texto12"> <b>Fecha desde:</b></label><br>
                        <input type="date" name="fecdesde" class="Texto12New" autocomplete="off" min="'.$fecdesde.'" max = "'.$fechasta.'">';

        $cont.='     </td>                   
                   </tr>
                   <tr height="55">
                    <td> <label class="Texto12"> <b>D&iacute;as:</b></label><br>
                     <input type="number" name="dias" min="1" max="180" class="Texto12New" size="12" autocomplete="off" title="días de la licencia" value="'.$dias.'"> 
                    </td>                   
                   </tr>
                   <tr height="55">
                    <td align="center"><br><br> 
                     <input type="submit" value="guardar" class="button blue"> 
                    </td>
                   </tr>
                  </table>
                 </form>
                 <br><br>
                 </fieldset>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: almlicencias
    // Creación: 28/10/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena la licencia
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "almlicencias")
    {
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];
        $dias = $_POST['dias'];
        $conceptoid = $_POST['conceptoid'];
        $fecdesde = $_POST['fecdesde'];

        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Inicialización de variables
        $valorperiodo = 0;
        $valorconcepto = 0;
        $diff = 0;
        $difendias = 0;
        $diaspendiente = 0;

        $lbpendiente = false;
        $periodoapagar = 0;
        $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');

        // Calculo la diferencia en días
        $fecha1= new DateTime($fecdesde);
        $fecha2= new DateTime($fechasta);
        $diff = $fecha1->diff($fecha2);
        
        $difendias = $diff->days;
        $difendias += 1;

        // ---------------------------------------------------------------------- //
        $suma = "+".strval($dias-1)." day";
        $date_fin = strtotime(".$suma.", strtotime($fecdesde));
        $date_fin = date('Y-m-d', $date_fin);
        
        if($date_fin > $fechasta)
        {
            // ---------------------------------------------------------------------- //
            // Aquí guardo en la tabla correspondiente el exceso en días
            // para ser calculado en próximos periodos
            $diaspendiente = $dias - $difendias;

            // --------------------------------------------------------------------------------------------------------- //
            $feciniper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
            $diadesde = substr($feciniper, -2);

            if($diadesde=="16")
            {
                $fecfinper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
                $fechaEntera = strtotime($fecfinper);
                $valdias = date("d", $fechaEntera);

                if($valdias=="28")
                    $diaspendiente -= 2;

                if($valdias=="29")
                    $diaspendiente -= 1;

                if($valdias=="31")
                    $diaspendiente += 1;
            }
            // --------------------------------------------------------------------------------------------------------- //

            $dias -= $diaspendiente;

            $procesado = "";
            $vsql = "SELECT periodoid 
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE periodoid > $periodoid)";
            $periodoapagar = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO licenciaspendiente (terid,conceptoid,dias,periodoapagar,procesado) 
                                             VALUES (".$terid.",".$conceptoid.",".$diaspendiente.",".$periodoapagar.",'".$procesado."')";
            $clase->EjecutarSQL($vsql);
            $lbpendiente = true;
        }

        // Inicializo las variables
        $basico = 0;                            $formulabasico = "";                            $diastrab = 0;
        $detalleid = 0;                         $sueldo = 0;                                    $numid = 0;
        $licencianorem = 0;                     $formulatransporte = "";                        $subsidiotransporte = 0;
        $lbpaso = false;                        $formulasuspencion = "";                        $suspension = 0;
        $formulaincapacidad = "";               $incapacidad = 0;                               $formulapaternidad = "";
        $paternidad = 0;                        $totnovedades = 0;                              $sueldostr = "";
        $centenas = "";                         $centenasnum = 0;                               $sueldodeducciones = 0;
        $formulapension = "";                   $pension = 0;                                   $detalleid = 0;
        $formulasalud = "";                     $salud = 0;

        // Obtengo el salario básico del empleado
        $vsqldatos = "SELECT basico FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $basico = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Obtengo la formula del sueldo
        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
        $formulabasico = $clase->SeleccionarUno($vsql);

        // en detallenomina

        // Obtengo los días trabajados en el periodo
        $vsql = "SELECT valor
                   FROM detallenomina 
                  WHERE conceptoid = 1  
                        AND pernominaid = ".$periodoid."
                        AND terid = ".$terid."";
        $diastrab = $clase->SeleccionarUno($vsql);

        // Obtengo el ID del registro que se modificará
        $vsql = "SELECT detalleid
                   FROM detallenomina 
                  WHERE conceptoid = 1  
                        AND pernominaid = ".$periodoid."
                        AND terid = ".$terid."";
        $detalleid = $clase->SeleccionarUno($vsql);
        
        $diastrab -= $dias;

        eval("\$sueldo = $formulabasico;");
        $sueldo = round($sueldo,0);

        // Almaceno en nuevo sueldo
        $vsql = "UPDATE detallenomina SET 
                        devengados = ".$sueldo.", 
                        valor = ".$diastrab."
                  WHERE detalleid = ".$detalleid."";
        $clase->EjecutarSQL($vsql);

        // en hisdetallenomina

        // Obtengo los días trabajados en el periodo
        $vsql = "SELECT valor
                   FROM hisdetallenomina 
                  WHERE conceptoid = 1  
                        AND pernominaid = ".$periodoid."
                        AND terid = ".$terid."";
        $diastrab = $clase->SeleccionarUno($vsql);

        // Obtengo el ID del registro que se modificará
        $vsql = "SELECT detalleid
                   FROM hisdetallenomina 
                  WHERE conceptoid = 1  
                        AND pernominaid = ".$periodoid."
                        AND terid = ".$terid."";
        $detalleidh = $clase->SeleccionarUno($vsql);
        
        $diastrab -= $dias;

        eval("\$sueldo = $formulabasico;");
        $sueldo = round($sueldo,0);

        // Almaceno en nuevo sueldo
        $vsql = "UPDATE hisdetallenomina SET 
                        devengados = ".$sueldo.", 
                        valor = ".$diastrab."
                  WHERE detalleid = ".$detalleidh."";
        $clase->EjecutarSQL($vsql);

        // // Valido que se almacene el nuevo sueldo para poder continuar con el proceso
        // if(mysql_affected_rows() < 1)
        //     $clase->Aviso(3,"No se procesó correctamente la licencia, comuníquese con el administrador del sistema ERROR 1520");
        // else
        // {
            // Calculo el nuevo ID
            $vsql = "SELECT max(detalleid) FROM detallenomina";
            $numid = $clase->SeleccionarUno($vsql);
            $numid++;

            // Inserto la nueva licencia

            // Obtengo la formula de la licencia
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
            $formulalice = $clase->SeleccionarUno($vsql);

            // Calculo la licencia
            if($conceptoid!=10)
            {
                eval("\$montolicencia = $formulalice;");
                $montolicencia = round($montolicencia,0);
            }
            else
            {
                // Calculo la incapacidad

                // Obtengo el salario mínimo legal vigente
                $smlv = $_SESSION['N_SALMIN2020'];

                // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                if($basico<=$smlv)
                {
                    $montolicencia = ($smlv*$dias)/30;
                    $montolicencia = round($montolicencia,0);
                }
                else
                {
                    $porcbasico = ($basico*66.67)/100;
                    $porcbasico = round($porcbasico,0);

                    // Calculo la incapacidad si el básico sea mayor al mínimo
                    if($porcbasico>$smlv)
                    {
                        $montolicencia = ($porcbasico*$dias)/30;
                        $montolicencia = round($montolicencia,0);
                    }
                    else
                    {
                        if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                        if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;

                        $montolicencia = round($montolicencia,0);
                    }
                }
            }

            // ------------------------------------------------------------------------------------------------------------------- //
            // Obtengo el tipo de licencia
            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

            // en detallenomina

            // ------------------------------------------------------------------------------------------------------------------- //
            // Determino si el registro existe para modificarlo o incluirlo
            $vsql = "SELECT COUNT(*) AS repetida 
                        FROM detallenomina
                        WHERE pernominaid = ".$periodoid."
                            AND conceptoid = ".$conceptoid."
                            AND terid = ".$terid."";
            $repetida = $clase->SeleccionarUno($vsql);

            // ------------------------------------------------------------------------------------------------------------------- //
            if($repetida==0)
            {
                if($tipodc=="C")
                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$montolicencia.",0,".$dias.",".$basico.")";
                else
                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$montolicencia.",".$dias.",".$basico.")";
            }
            else
            {
                // Determino el id del registro
                $vsql = "SELECT detalleid AS detalleid 
                           FROM detallenomina
                          WHERE pernominaid = ".$periodoid."
                                AND conceptoid = ".$conceptoid."
                                AND terid = ".$terid."";
                $detalleid = $clase->SeleccionarUno($vsql);

                $valor = $clase->BDLockup($detalleid,'detallenomina','detalleid','valor');
                $valor += $dias;

                // Actualizo la licencia
                if($tipodc=="C")
                {
                    $devengados = $clase->BDLockup($detalleid,'detallenomina','detalleid','devengados');
                    $devengados += $montolicencia;
                    
                    $vsql = "UPDATE detallenomina SET 
                                    devengados = ".$devengados.", 
                                    valor = ".$valor."
                              WHERE detalleid = ".$detalleid."";
                }
                else
                {
                    $descuentos = $clase->BDLockup($detalleid,'detallenomina','detalleid','descuentos');
                    $descuentos += $montolicencia;

                    $vsql = "UPDATE detallenomina SET 
                                    descuentos = ".$descuentos.", 
                                    valor = ".$valor."
                              WHERE detalleid = ".$detalleid."";
                }
            }
            $clase->EjecutarSQL($vsql);

            // en hisdetallenomina

            // Calculo el nuevo ID
            $vsql = "SELECT max(detalleid) FROM hisdetallenomina";
            $numidh = $clase->SeleccionarUno($vsql);
            $numidh++;

            // ------------------------------------------------------------------------------------------------------------------- //
            // Determino si el registro existe para modificarlo o incluirlo
            $vsql = "SELECT COUNT(*) AS repetida 
                       FROM hisdetallenomina
                      WHERE pernominaid = ".$periodoid."
                            AND conceptoid = ".$conceptoid."
                            AND terid = ".$terid."";
            $repetidah = $clase->SeleccionarUno($vsql);

            // ------------------------------------------------------------------------------------------------------------------- //
            if($repetidah==0)
            {
                if($tipodc=="C")
                    $vsql = "INSERT INTO hisdetallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                   VALUES ($numidh,".$terid.",".$conceptoid.",".$periodoid.",".$montolicencia.",0,".$dias.",".$basico.")";
                else
                    $vsql = "INSERT INTO hisdetallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                   VALUES ($numidh,".$terid.",".$conceptoid.",".$periodoid.",0,".$montolicencia.",".$dias.",".$basico.")";
            }
            else
            {
                // Determino el id del registro
                $vsql = "SELECT detalleid AS detalleid 
                           FROM hisdetallenomina
                          WHERE pernominaid = ".$periodoid."
                                AND conceptoid = ".$conceptoid."
                                AND terid = ".$terid;
                $detalleidh = $clase->SeleccionarUno($vsql);

                $valor = $clase->BDLockup($detalleidh,'hisdetallenomina','detalleid','valor');
                $valor += $dias;

                // Actualizo la licencia
                if($tipodc=="C")
                {
                    $devengados = $clase->BDLockup($detalleidh,'hisdetallenomina','detalleid','devengados');
                    $devengados += $montolicencia;
                    
                    $vsql = "UPDATE hisdetallenomina SET 
                                    devengados = ".$devengados.", 
                                    valor = ".$valor."
                              WHERE detalleid = ".$detalleidh;
                }
                else
                {
                    $descuentos = $clase->BDLockup($detalleidh,'hisdetallenomina','detalleid','descuentos');
                    $descuentos += $montolicencia;

                    $vsql = "UPDATE hisdetallenomina SET 
                                    descuentos = ".$descuentos.", 
                                    valor = ".$valor."
                              WHERE detalleid = ".$detalleidh;
                }
            }
            $clase->EjecutarSQL($vsql);

            if(mysql_affected_rows() >= 1)
            {
                $clase->Aviso(1,"Licencia procesada exitosamente");
                $lbpaso = true;
            }
            else
                $clase->Aviso(3,"No se procesó correctamente la licencia");
        // }

        // ---------------------------------------------------------------------------------------------------------- //
        // Recalculo el subsidio de transporte siempre y cuando el básico no exceda de dos salarios mínimos

        // Obtengo el salario mínimo legal vigente
        $smlv = $_SESSION['N_SALMIN2020'];

        // Obtengo el cargo del empleado
        $vsqldatos = "SELECT cargoid FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $cargoid = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Obtengo el control del cálculo de subsidio de transporte
        $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');

        // Variable para la validación del auxilio de transporte
        $valsubtrasp = $smlv * 2;

        // en detallenomina

        if(($lbpaso == true)&&($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
        {
            // Obtengo el ID del registro que se modificará
            $vsql = "SELECT detalleid
                       FROM detallenomina 
                      WHERE conceptoid = 3  
                            AND pernominaid = ".$periodoid."
                            AND terid = ".$terid."";
            $detalleid = $clase->SeleccionarUno($vsql);

            // Obtengo la formula del subsidio de transporte
            $auxtrans = $_SESSION['N_AUXTRANS2020'];
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
            $formulatransporte = $clase->SeleccionarUno($vsql);

            eval("\$subsidiotransporte = $formulatransporte;");
            $subsidiotransporte = round($subsidiotransporte,0);
        }
        else
            $subsidiotransporte = 0;

        // ID transporte
        $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
        $idtransporte = $clase->SeleccionarUno($vsql);

        // Grabo el subsidio de transporte
        if($idtransporte!="")
            $vsql = "UPDATE detallenomina SET 
                            devengados = ".$subsidiotransporte.",
                            valor = ".$diastrab."
                      WHERE detalleid = ".$idtransporte."";
        else
        {
            $vsql = "SELECT max(detalleid) FROM detallenomina";
            $numreg = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$auxtrans)";
        }
        $clase->EjecutarSQL($vsql);

        // en hisdetallenomina

        if(($lbpaso == true)&&($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
        {
            // Obtengo la formula del subsidio de transporte
            $auxtrans = $_SESSION['N_AUXTRANS2020'];
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
            $formulatransporte = $clase->SeleccionarUno($vsql);

            eval("\$subsidiotransporte = $formulatransporte;");
            $subsidiotransporte = round($subsidiotransporte,0);
        }
        else
            $subsidiotransporte = 0;

        // ID transporte
        $vsql = "SELECT detalleid AS idtransporte FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
        $idtransporteh = $clase->SeleccionarUno($vsql);

        // Grabo el subsidio de transporte
        if($idtransporte!="")
            $vsql = "UPDATE hisdetallenomina SET 
                            devengados = ".$subsidiotransporte.",
                            valor = ".$diastrab."
                      WHERE detalleid = ".$idtransporteh;
        else
        {
            $vsql = "SELECT max(detalleid) FROM hisdetallenomina";
            $numregh = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO hisdetallenomina VALUES ($numregh+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$auxtrans)";
        }
        $clase->EjecutarSQL($vsql);

        // en detallenomina
        
        // Obtengo el total devengado por novedades
        $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                   FROM detallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND d.pernominaid = ".$periodoid." 
                        AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
        $totnovedades = $clase->SeleccionarUno($vsql);

        $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                   FROM detallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND d.pernominaid = ".$periodoid." 
                        AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
        $totrecargos = $clase->SeleccionarUno($vsql);

        // Actualizo el sueldo
        $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

        // Determino si es extralegal
        $vsqldatos = "SELECT extralegal FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $extralegal = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Determino la eps
        $vsqldatos = "SELECT epsid FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $epsid = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Fondo de pensiones
        $vsqldatos = "SELECT pensionesid FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $pensionesid = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";
        
        if($epsid==NULL)                $epsid=0;
        if($pensionesid==NULL)          $pensionesid=0;

        $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
        $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud

        if($extralegal=="CHECKED")
        {
            $pension = 0;
            $salud = 0;
        }
        else
        {
            // Recalculo pensión y salud
            if(($pensionesid==5)||($aplicapension!="CHECKED"))
                $pension = 0;
            else
            {
                // Obtengo la formula para el descuento por pensión
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                $formulapension = $clase->SeleccionarUno($vsql);

                // Calculo la pensión
                eval("\$pension = $formulapension;");
                $pension = round($pension,0);
            }

            if(($epsid==37)||($aplicasalud!="CHECKED"))
                $salud = 0;
            else
            {
                // Obtengo la formula para el descuento de salud
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                $formulasalud = $clase->SeleccionarUno($vsql);
                
                // Calculo la salud
                eval("\$salud = $formulasalud;");
                $salud = round($salud,0);
            }
        }

        //  ID pensión
        $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
        $idpension = $clase->SeleccionarUno($vsql);

        // Grabo la pensión
        if($idpension!="")
            $vsql = "UPDATE detallenomina SET 
                            descuentos = ".$pension.",
                            saldo = ".$sueldodeducciones."
                      WHERE detalleid = ".$idpension."";
        else
        {
            $vsql = "SELECT max(detalleid) FROM detallenomina";
            $numreg = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
        }
        $clase->EjecutarSQL($vsql);

        // ID salud
        $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
        $idsalud = $clase->SeleccionarUno($vsql);

        // Grabo la salud
        if($idsalud!="")
            $vsql = "UPDATE detallenomina SET 
                            descuentos = ".$salud.",
                            saldo = ".$sueldodeducciones."
                      WHERE detalleid = ".$idsalud."";
        else
        {
            $vsql = "SELECT max(detalleid) FROM detallenomina";
            $numreg = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
        }
        $clase->EjecutarSQL($vsql);

        // en hisdetallenomina
        
        // Obtengo el total devengado por novedades
        $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                   FROM hisdetallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND d.pernominaid = ".$periodoid." 
                        AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
        $totnovedades = $clase->SeleccionarUno($vsql);

        $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                   FROM detallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND d.pernominaid = ".$periodoid." 
                        AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
        $totrecargos = $clase->SeleccionarUno($vsql);

        // Actualizo el sueldo
        $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

        // Determino si es extralegal
        $vsqldatos = "SELECT extralegal FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $extralegal = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Determino la eps
        $vsqldatos = "SELECT epsid FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $epsid = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Fondo de pensiones
        $vsqldatos = "SELECT pensionesid FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $pensionesid = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";
        
        if($epsid==NULL)                $epsid=0;
        if($pensionesid==NULL)          $pensionesid=0;

        $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
        $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud

        if($extralegal=="CHECKED")
        {
            $pension = 0;
            $salud = 0;
        }
        else
        {
            // Recalculo pensión y salud
            if(($pensionesid==5)||($aplicapension!="CHECKED"))
                $pension = 0;
            else
            {
                // Obtengo la formula para el descuento por pensión
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                $formulapension = $clase->SeleccionarUno($vsql);

                // Calculo la pensión
                eval("\$pension = $formulapension;");
                $pension = round($pension,0);
            }

            if(($epsid==37)||($aplicasalud!="CHECKED"))
                $salud = 0;
            else
            {
                // Obtengo la formula para el descuento de salud
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                $formulasalud = $clase->SeleccionarUno($vsql);
                
                // Calculo la salud
                eval("\$salud = $formulasalud;");
                $salud = round($salud,0);
            }
        }

        //  ID pensión
        $vsql = "SELECT detalleid AS idpension FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
        $idpensionh = $clase->SeleccionarUno($vsql);

        // Grabo la pensión
        if($idpensionh!="")
            $vsql = "UPDATE hisdetallenomina SET 
                            descuentos = ".$pension.",
                            saldo = ".$sueldodeducciones."
                      WHERE detalleid = ".$idpensionh;
        else
        {
            $vsql = "SELECT max(detalleid) FROM hisdetallenomina";
            $numregh = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO hisdetallenomina VALUES ($numregh+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
        }
        $clase->EjecutarSQL($vsql);

        // ID salud
        $vsql = "SELECT detalleid AS idsalud FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
        $idsaludh = $clase->SeleccionarUno($vsql);

        // Grabo la salud
        if($idsalud!="")
            $vsql = "UPDATE hisdetallenomina SET 
                            descuentos = ".$salud.",
                            saldo = ".$sueldodeducciones."
                      WHERE detalleid = ".$idsaludh;
        else
        {
            $vsql = "SELECT max(detalleid) FROM hisdetallenomina";
            $numregh = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO hisdetallenomina VALUES ($numregh+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
        }
        $clase->EjecutarSQL($vsql);

        // ----------------------------------------------------------------------------------------------------------- //
        // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
        $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid;
        $clase->EjecutarSQL($vsql);

        $vsql = "DELETE FROM hisdetallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid;
        $clase->EjecutarSQL($vsql);

        // Redirecciono el formulario
        header("Location: ajusteextemporaneo.php?opcion=ventanaajusteext&periodoid=$periodoid&terid=$terid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: editarconcepto
    // Creación: 28/10/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana donde se captará el descuento ocasional
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarconcepto")
    {
        $periodoid = $_GET['periodoid'];
        $terid = $_GET['terid'];       
        
        // Nombre del periodo
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Variable para el nombre de empleado
        $vsqldatos = "SELECT nombre FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Combo de ocasionales
        $vsqlcombooca = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) FROM conceptosnomina WHERE montoocasional='CHECKED' ORDER BY conceptoid";

        // Configuración
        $params = ' class="Texto11" ';
        $monto = 1;
        
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/calculando.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Ajuste extemporáneo </b><br> Descuentos ocasionales <font color="blue"> <br> '.$descripcion.' </font> </td>                  
                  <td width="24"> &nbsp; </td>
                  <td width="24"> 
                   <a href="ajusteextemporaneo.php?opcion=ventanaajusteext&periodoid='.$periodoid.'&terid='.$terid.'"> <input type="button" value="<<" class="button"></a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<center>
                <form action="?opcion=almocasionales" method="POST">
                 <input type="hidden" name="periodoid" value="'.$periodoid.'">
                 <input type="hidden" name="terid" value="'.$terid.'">
                  <fieldset style="width: 530px; height: 280px;" class="grupos">
                  <legend class="titgrupos"> Datos </legend>
                  <table width="350">
                   <tr height="55">
                    <td> 
                     <label class="Texto12"> <b>Empleado: </b></label><br>
                     <label class="Texto12"> '.$nombreemp.' </label>
                    </td>                   
                   </tr>                    
                   <tr height="55">
                    <td> <label class="Texto12"> <b>Licencia:</b></label><br>';

        $cont.= $clase->CrearComboBuscar("conceptoid",$vsqlcombooca,"nombres","conceptoid","","N",$params,420);

        $cont.='    </td>                   
                   </tr>
                   <tr height="55">
                    <td> <label class="Texto12"> <b>Monto:</b></label><br>
                     <input type="number" name="monto" min="1" class="Texto12New" size="20" autocomplete="off" title="monto a descontar" value="'.$monto.'"> 
                    </td>                   
                   </tr>                    
                   <tr height="55">
                    <td align="center"><br><br> 
                     <input type="submit" value="guardar" class="button blue"> 
                    </td>
                   </tr>
                  </table>
                 </form>
                 <br><br>
                 </fieldset>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: almocasionales
    // Creación: 28/10/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena el descuento ocasional
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "almocasionales")
    {
        $periodoid = $_POST['periodoid'];
        $conceptoid = $_POST['conceptoid'];
        $terid = $_POST['terid'];
        $monto = $_POST['monto'];

        // en detallenomina

        // Obtengo el número de registros de la tabla detallenomina
        $vsql = "SELECT MAX(detalleid) FROM detallenomina";
        $numeroid = $clase->SeleccionarUno($vsql);

        // Incremento el ID
        $numeroid++;

        // Obtengo el tipo de concepto
        $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

        // Almaceno en la tabla el concepto de compras a crédito para el trabajador
        if($tipodc=="C")
            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                        VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",".$monto.",0,0,0)";
        else
            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                        VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";

        $clase->EjecutarSQL($vsql);

        // en hisdetallenomina

        // Obtengo el número de registros de la tabla detallenomina
        $vsql = "SELECT MAX(detalleid) FROM hisdetallenomina";
        $numeroid = $clase->SeleccionarUno($vsql);

        // Incremento el ID
        $numeroid++;

        // Obtengo el tipo de concepto
        $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

        // Almaceno en la tabla el concepto de compras a crédito para el trabajador
        if($tipodc=="C")
            $vsql = "INSERT INTO hisdetallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                        VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",".$monto.",0,0,0)";
        else
            $vsql = "INSERT INTO hisdetallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                        VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";

        $clase->EjecutarSQL($vsql);        

        // Envío el mensaje correspondiente
        if(mysql_affected_rows() < 1)
            $clase->Aviso(3,"No se procesó el descuento ocasional, verifique por favor");
        else
            $clase->Aviso(1,"Descuento ocasional procesado exitosamente");

        // Redirecciono el formulario
        header("Location: ajusteextemporaneo.php?opcion=ventanaajusteext&periodoid=$periodoid&terid=$terid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ventanaelimconp
    // Creación: 28/10/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar el concepto que se eliminará
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaelimconp")
    {
        $periodoid = $_GET['periodoid'];
        $terid = $_GET['terid'];       
        
        // Nombre del periodo
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Variable para el nombre de empleado
        $vsqldatos = "SELECT nombre FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Consulta para los conceptos
        $vsqlcombocon = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) 
                           FROM conceptosnomina 
                          WHERE eslicencia='CHECKED' 
                                OR eslibranza ='CHECKED' 
                                OR montoocasional ='CHECKED' 
                                OR montopermanente ='CHECKED' 
                                OR recargo ='CHECKED'
                       ORDER BY conceptoid";

        // Configuración
        $params = ' class="Texto11" ';
        $dias = 1;
        
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/calculando.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Ajuste extemporáneo </b><br> Eliminar concepto <font color="blue"> <br> '.$descripcion.' </font> </td> 
                  <td width="24"> &nbsp; </td>
                  <td width="24"> 
                   <a href="ajusteextemporaneo.php?opcion=ventanaajusteext&periodoid='.$periodoid.'&terid='.$terid.'"> <input type="button" value="<<" class="button"></a> 
                  </td>
                  <td width="10"> &nbsp; </td>                  
                 </tr>
                </table>';

        $cont.='<center>
                <form action="?opcion=eliminaconpemp" method="POST">
                 <input type="hidden" name="periodoid" value="'.$periodoid.'">
                 <input type="hidden" name="terid" value="'.$terid.'">
                  <fieldset style="width: 530px; height: 240px;" class="grupos">
                  <legend class="titgrupos"> Datos </legend>
                  <table width="350">
                   <tr height="55">
                    <td> 
                     <label class="Texto12"> <b>Empleado: </b></label><br>
                     <label class="Texto12"> '.$nombreemp.' </label>
                    </td>                   
                  </tr>                    
                  <tr height="55">
                   <td> <label class="Texto12"> <b>Concepto:</b></label><br>';

        $cont.= $clase->CrearComboBuscar("conceptoid",$vsqlcombocon,"nombres","conceptoid","","N",$params,420);

        $cont.='   </td>                   
                  </tr>
                  <tr height="55">
                   <td align="center"><br><br> 
                    <input type="submit" value="aceptar" class="button blue"> 
                   </td>
                  </tr>
                 </table>
                </form>
                <br><br>
                </fieldset>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ventanaelimconp
    // Creación: 29/10/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina un concepto y recalcula todo a un empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminaconpemp")
    {
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];
        $conceptoid = $_POST['conceptoid'];        

        // Inicializo las variables
        $diasconcepto = 0;                          $diastrab = 0;                      $detalleid = 0;
        $formulabasico = "";                        $sueldo = 0;                        $basico = 0;
        $smlv = 0;                                  $valsubtrasp = 0;                   $auxtrans = 0;
        $formulatransporte = "";                    $subsidiotransporte = 0;            $lb_grabosueldo = false;
        $numlicpendientes = 0;

        // Variable para el nombre de empleado
        $vsqldatos = "SELECT nombre FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Nombre del concepto
        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');

        // en detallenomina

        // Obtengo los días del concepto que se eliminará
        $vsql = "SELECT SUM(valor) AS diasconcepto FROM detallenomina WHERE terid = ".$terid." AND conceptoid = ".$conceptoid." AND pernominaid = ".$periodoid;
        $diasconcepto = $clase->SeleccionarUno($vsql);

        $vsql = "DELETE FROM detallenomina WHERE terid = ".$terid." AND conceptoid = ".$conceptoid." AND pernominaid = ".$periodoid;
        $clase->EjecutarSQL($vsql);

        // en hisdetallenomina

        // Obtengo los días del concepto que se eliminará
        $vsql = "SELECT SUM(valor) AS diasconcepto FROM hisdetallenomina WHERE terid = ".$terid." AND conceptoid = ".$conceptoid." AND pernominaid = ".$periodoid;
        $diasconcepto = $clase->SeleccionarUno($vsql);

        $vsql = "DELETE FROM hisdetallenomina WHERE terid = ".$terid." AND conceptoid = ".$conceptoid." AND pernominaid = ".$periodoid;
        $clase->EjecutarSQL($vsql);        

        if(mysql_affected_rows() < 1)
            $clase->Aviso(3,"No se eliminó el concepto $nomconcepto al empleado $nombreemp");
        else
        {
            // Determino el ámbito del concepto
            $eslicencia = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','eslicencia');
            $recargo = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','recargo');

            // Valido si es una libranza o licencia para recalcular lo correspondiente a ese caso
            if(($eslicencia == "CHECKED") || ($recargo == "CHECKED"))
            {
                // Obtengo el salario básico del empleado
                $vsqldatos = "SELECT basico FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
                $basico = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                // en detallenomina
    
                // Obtengo los días trabajados en el periodo
                $vsql = "SELECT valor
                           FROM detallenomina 
                          WHERE conceptoid = 1  
                                AND pernominaid = ".$periodoid."
                                AND terid = ".$terid."";
                $diastrab = $clase->SeleccionarUno($vsql);
    
                // Obtengo el ID del registro que se modificará
                $vsql = "SELECT detalleid
                           FROM detallenomina 
                          WHERE conceptoid = 1  
                                AND pernominaid = ".$periodoid."
                                AND terid = ".$terid."";
                $detalleid = $clase->SeleccionarUno($vsql);
    
                // Obtengo la formula del sueldo
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                $formulabasico = $clase->SeleccionarUno($vsql);
    
                // Recalculo el sueldo del periodo
                $diastrab = $diastrab + $diasconcepto;
                eval("\$sueldo = $formulabasico;");
                $sueldo = round($sueldo,0);
    
                // Almaceno en nuevo sueldo
                $vsql = "UPDATE detallenomina SET 
                                devengados = ".$sueldo.", 
                                valor = ".$diastrab."
                          WHERE detalleid = ".$detalleid."";
                $clase->EjecutarSQL($vsql);

                // en hisdetallenomina
    
                // Obtengo los días trabajados en el periodo
                $vsql = "SELECT valor
                           FROM hisdetallenomina 
                          WHERE conceptoid = 1  
                                AND pernominaid = ".$periodoid."
                                AND terid = ".$terid."";
                $diastrab = $clase->SeleccionarUno($vsql);
    
                // Obtengo el ID del registro que se modificará
                $vsql = "SELECT detalleid
                           FROM hisdetallenomina 
                          WHERE conceptoid = 1  
                                AND pernominaid = ".$periodoid."
                                AND terid = ".$terid."";
                $detalleid = $clase->SeleccionarUno($vsql);
    
                // Obtengo la formula del sueldo
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                $formulabasico = $clase->SeleccionarUno($vsql);
    
                // Recalculo el sueldo del periodo
                $diastrab = $diastrab + $diasconcepto;
                eval("\$sueldo = $formulabasico;");
                $sueldo = round($sueldo,0);
    
                // Almaceno en nuevo sueldo
                $vsql = "UPDATE hisdetallenomina SET 
                                devengados = ".$sueldo.", 
                                valor = ".$diastrab."
                          WHERE detalleid = ".$detalleid."";
                $clase->EjecutarSQL($vsql);                
    
                // Valido que se almacene el nuevo sueldo para poder continuar con el proceso
                if(mysql_affected_rows() < 1)
                    $clase->Aviso(3,"No se procesó correctamente la eliminación del concepto, comuníquese con el administrador del sistema ERROR 1541");
                else
                {
                    // Ahora voy a recalcular el subsidio de transporte si es necesario
                    $lb_grabosueldo=true;       // Variable que controla el mensaje correspondiente
        
                    // Obtengo el salario mínimo legal vigente
                    $smlv = $_SESSION['N_SALMIN2020'];
        
                    // Variable para la validación del auxilio de transporte
                    $valsubtrasp = $smlv * 2;

                    // Obtengo el cargo del empleado
                    $vsqldatos = "SELECT cargoid FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
                    $cargoid = $clase->SeleccionarUno($vsqldatos);
                    $vsqldatos = "";

                    // Obtengo el control del cálculo de subsidio de transporte
                    $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');

                    if(($basico <= $valsubtrasp) && ($aplicatransporte=="CHECKED"))
                    {        
                        // Obtengo la formula del subsidio de transporte
                        $auxtrans = $_SESSION['N_AUXTRANS2020'];
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                        $formulatransporte = $clase->SeleccionarUno($vsql);
        
                        eval("\$subsidiotransporte = $formulatransporte;");
                        $subsidiotransporte = round($subsidiotransporte,0);
                    }
                    else
                        $subsidiotransporte = 0;
            
                    // en detallenomina

                    // ID transporte
                    $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                    $idtransporte = $clase->SeleccionarUno($vsql);
            
                    if($idtransporte!="")
                        // Grabo el subsidio de transporte
                        $vsql = "UPDATE detallenomina SET 
                                        devengados = ".$subsidiotransporte.",
                                        valor = ".$diastrab."
                                  WHERE detalleid = ".$idtransporte."";
                    else
                    {
                        // Obtengo el valor del subsidio de transporte
                        $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
            
                        $vsql = "SELECT max(detalleid) FROM detallenomina";
                        $numreg = $clase->SeleccionarUno($vsql);
            
                        $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                    }
                    $clase->EjecutarSQL($vsql);

                    // en hisdetallenomina

                    // ID transporte
                    $vsql = "SELECT detalleid AS idtransporte FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                    $idtransporte = $clase->SeleccionarUno($vsql);
            
                    if($idtransporte!="")
                        // Grabo el subsidio de transporte
                        $vsql = "UPDATE hisdetallenomina SET 
                                        devengados = ".$subsidiotransporte.",
                                        valor = ".$diastrab."
                                  WHERE detalleid = ".$idtransporte."";
                    else
                    {
                        // Obtengo el valor del subsidio de transporte
                        $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
            
                        $vsql = "SELECT max(detalleid) FROM hisdetallenomina";
                        $numreg = $clase->SeleccionarUno($vsql);
            
                        $vsql = "INSERT INTO hisdetallenomina VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                    }
                    $clase->EjecutarSQL($vsql);                    

                    // ----------------------------- //
                    // Recalculo la pensión y la salud

                    // ------------------------------------------------------------------------------------------------------------- //
                    // Obtengo la formula para el descuento por pensión
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                    $formulapension = $clase->SeleccionarUno($vsql);

                    // Obtengo la formula para el descuento de salud
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                    $formulasalud = $clase->SeleccionarUno($vsql);

                    // Determino si es extralegal
                    $vsqldatos = "SELECT extralegal FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
                    $extralegal = $clase->SeleccionarUno($vsqldatos);
                    $vsqldatos = "";

                    // Determino la eps
                    $vsqldatos = "SELECT epsid FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
                    $epsid = $clase->SeleccionarUno($vsqldatos);
                    $vsqldatos = "";

                    // Fondo de pensiones
                    $vsqldatos = "SELECT pensionesid FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
                    $pensionesid = $clase->SeleccionarUno($vsqldatos);
                    $vsqldatos = "";
                    
                    if($epsid==NULL)                    $epsid=0;
                    if($pensionesid==NULL)              $pensionesid=0;

                    // ----------------------------------------------------------------------------------------------------------- //
                    $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                    $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud

                    // en detallenomina

                    $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                    $totnovedades = $clase->SeleccionarUno($vsql);

                    $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                    $totrecargos = $clase->SeleccionarUno($vsql);
            
                    // Actualizo el sueldo
                    // $sueldo += $totnovedades;

                    $sueldo = $sueldo + $totnovedades + $totrecargos;
                    $sueldodeducciones = $sueldo;
        
                    if($extralegal=="CHECKED")
                    {
                        $pension = 0;
                        $salud = 0;
                    }
                    else
                    {
                        // Recalculo pensión y salud
                        if(($pensionesid==5)||($aplicapension!="CHECKED"))
                            $pension = 0;
                        else
                        {
                            // Obtengo la formula para el descuento por pensión
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                            $formulapension = $clase->SeleccionarUno($vsql);
        
                            // Calculo la pensión
                            eval("\$pension = $formulapension;");
                            $pension = round($pension,0);
                        }
        
                        if(($epsid==37)||($aplicasalud!="CHECKED"))
                            $salud = 0;
                        else
                        {
                            // Obtengo la formula para el descuento de salud
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                            $formulasalud = $clase->SeleccionarUno($vsql);
                            
                            // Calculo la salud
                            eval("\$salud = $formulasalud;");
                            $salud = round($salud,0);
                        }
                    }                    
        
                    //  ID pensión
                    $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                    $idpension = $clase->SeleccionarUno($vsql);
        
                    // Grabo la pensión
                    if($idpension!="")
                        $vsql = "UPDATE detallenomina SET 
                                        descuentos = ".$pension.",
                                        saldo = ".$sueldodeducciones."
                                  WHERE detalleid = ".$idpension."";
                    else
                    {
                        $vsql = "SELECT max(detalleid) FROM detallenomina";
                        $numreg = $clase->SeleccionarUno($vsql);
        
                        $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                    }        
                    $clase->EjecutarSQL($vsql);
        
                    // ID salud
                    $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                    $idsalud = $clase->SeleccionarUno($vsql);
        
                    // Grabo la salud
                    if($idsalud!="")
                        $vsql = "UPDATE detallenomina SET 
                                        descuentos = ".$salud.",
                                        saldo = ".$sueldodeducciones."
                                  WHERE detalleid = ".$idsalud."";
                    else
                    {
                        $vsql = "SELECT max(detalleid) FROM detallenomina";
                        $numreg = $clase->SeleccionarUno($vsql);
        
                        $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                    }
                    $clase->EjecutarSQL($vsql);
                    // ----------------------------------------------------------------------------------------------------------- //                    

                    // en hisdetallenomina

                    $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                               FROM hisdetallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                    $totnovedades = $clase->SeleccionarUno($vsql);

                    $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                    $totrecargos = $clase->SeleccionarUno($vsql);

                    // Actualizo el sueldo
                    // $sueldo += $totnovedades;
                    $sueldo = $sueldo + $totnovedades + $totrecargos;
                    $sueldodeducciones = $sueldo;
        
                    if($extralegal=="CHECKED")
                    {
                        $pension = 0;
                        $salud = 0;
                    }
                    else
                    {
                        // Recalculo pensión y salud
                        if(($pensionesid==5)||($aplicapension!="CHECKED"))
                            $pension = 0;
                        else
                        {
                            // Obtengo la formula para el descuento por pensión
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                            $formulapension = $clase->SeleccionarUno($vsql);
        
                            // Calculo la pensión
                            eval("\$pension = $formulapension;");
                            $pension = round($pension,0);
                        }
        
                        if(($epsid==37)||($aplicasalud!="CHECKED"))
                            $salud = 0;
                        else
                        {
                            // Obtengo la formula para el descuento de salud
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                            $formulasalud = $clase->SeleccionarUno($vsql);
                            
                            // Calculo la salud
                            eval("\$salud = $formulasalud;");
                            $salud = round($salud,0);
                        }
                    }                    
        
                    //  ID pensión
                    $vsql = "SELECT detalleid AS idpension FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                    $idpension = $clase->SeleccionarUno($vsql);
        
                    // Grabo la pensión
                    if($idpension!="")
                        $vsql = "UPDATE hisdetallenomina SET 
                                        descuentos = ".$pension.",
                                        saldo = ".$sueldodeducciones."
                                  WHERE detalleid = ".$idpension."";
                    else
                    {
                        $vsql = "SELECT max(detalleid) FROM hisdetallenomina";
                        $numreg = $clase->SeleccionarUno($vsql);
        
                        $vsql = "INSERT INTO hisdetallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                    }        
                    $clase->EjecutarSQL($vsql);
        
                    // ID salud
                    $vsql = "SELECT detalleid AS idsalud FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                    $idsalud = $clase->SeleccionarUno($vsql);
        
                    // Grabo la salud
                    if($idsalud!="")
                        $vsql = "UPDATE hisdetallenomina SET 
                                        descuentos = ".$salud.",
                                        saldo = ".$sueldodeducciones."
                                  WHERE detalleid = ".$idsalud."";
                    else
                    {
                        $vsql = "SELECT max(detalleid) FROM hisdetallenomina";
                        $numreg = $clase->SeleccionarUno($vsql);
        
                        $vsql = "INSERT INTO hisdetallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                    }
                    $clase->EjecutarSQL($vsql);

                    // ------------------------------------------------------------------------------------------------------------- //
                    // Obtengo el id del pendiente
                    $vsql3 = "SELECT MAX(pendienteid) AS pendienteid 
                                FROM licenciaspendiente 
                               WHERE terid = ".$terid."
                                     AND conceptoid = ".$conceptoid."";
                    $pendienteid = $clase->SeleccionarUno($vsql3);

                    $vsql = "DELETE FROM licenciaspendiente WHERE pendienteid = ".$pendienteid."";
                    $clase->EjecutarSQL($vsql);
                }
                $lb_grabosueldo=true;
            }
            else
            {
                $vsql = "DELETE FROM detallenomina WHERE pernominaid = ".$periodoid." AND terid = ".$terid." AND conceptoid = ".$conceptoid."";
                $clase->EjecutarSQL($vsql);

                $vsql = "DELETE FROM hisdetallenomina WHERE pernominaid = ".$periodoid." AND terid = ".$terid." AND conceptoid = ".$conceptoid."";
                $clase->EjecutarSQL($vsql);                

                $lb_grabosueldo=true;
            }
        }

        // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
        $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid." AND terid = ".$terid."";
        $clase->EjecutarSQL($vsql);

        $vsql = "DELETE FROM hisdetallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid." AND terid = ".$terid."";
        $clase->EjecutarSQL($vsql);        

        if($lb_grabosueldo==true)
            $clase->Aviso(1,"Se eliminó exitosamente el concepto $nomconcepto al empleado $nombreemp");

        header("Location: ajusteextemporaneo.php?opcion=ventanaajusteext&periodoid=$periodoid&terid=$terid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: editarlibyperm
    // Creación: 31/10/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana donde se captarán los datos para incluir 
    //              una nueva libranza o descuento permanente
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarlibyperm")
    {
        $periodoid = $_GET['periodoid'];
        $terid = $_GET['terid'];

        // Nombre del periodo
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Variable para el nombre de empleado
        $vsqldatos = "SELECT nombre FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Combo de ocasionales
        $vsqlcombooca = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) FROM conceptosnomina WHERE eslibranza = 'CHECKED' OR montopermanente = 'CHECKED' ORDER BY conceptoid";

        // Configuración
        $params = ' class="Texto11" ';
        $monto = 1;
        
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/calculando.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Ajuste extemporáneo </b><br> Libranzas y descuentos permanentes <font color="blue"> <br> '.$descripcion.' </font> </td>                  
                  <td width="24"> &nbsp; </td>
                  <td width="24"> 
                   <a href="ajusteextemporaneo.php?opcion=ventanaajusteext&periodoid='.$periodoid.'&terid='.$terid.'"> <input type="button" value="<<" class="button"></a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<center>
                <form action="?opcion=almolibydescperm" method="POST">
                 <input type="hidden" name="periodoid" value="'.$periodoid.'">
                 <input type="hidden" name="terid" value="'.$terid.'">
                  <fieldset style="width: 530px; height: 280px;" class="grupos">
                  <legend class="titgrupos"> Datos </legend>
                  <table width="350">
                   <tr height="55">
                    <td> 
                     <label class="Texto12"> <b>Empleado: </b></label><br>
                     <label class="Texto12"> '.$nombreemp.' </label>
                    </td>                   
                   </tr>                    
                   <tr height="55">
                    <td> <label class="Texto12"> <b>Licencia:</b></label><br>';

        $cont.= $clase->CrearComboBuscar("conceptoid",$vsqlcombooca,"nombres","conceptoid","","N",$params,420);

        $cont.='    </td>                   
                   </tr>
                   <tr height="55">
                    <td> <label class="Texto12"> <b>Monto:</b></label><br>
                     <input type="number" name="monto" min="1" class="Texto12New" size="20" autocomplete="off" title="monto a descontar" value="'.$monto.'"> 
                    </td>                   
                   </tr>                    
                   <tr height="55">
                    <td align="center"><br><br> 
                     <input type="submit" value="guardar" class="button blue"> 
                    </td>
                   </tr>
                  </table>
                 </form>
                 <br><br>
                 </fieldset>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: almolibydescperm
    // Creación: 31/10/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena la nueva libranza o descuento permanente
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "almolibydescperm")
    {
        $periodoid = $_POST['periodoid'];
        $conceptoid = $_POST['conceptoid'];
        $terid = $_POST['terid'];
        $monto = $_POST['monto'];

        // en detallenomina

        // Obtengo el número de registros de la tabla detallenomina
        $vsql = "SELECT MAX(detalleid) FROM detallenomina";
        $numeroid = $clase->SeleccionarUno($vsql);

        // Incremento el ID
        $numeroid++;

        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                    VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
        $clase->EjecutarSQL($vsql);

        // en hisdetallenomina

        // Obtengo el número de registros de la tabla detallenomina
        $vsql = "SELECT MAX(detalleid) FROM hisdetallenomina";
        $numeroidh = $clase->SeleccionarUno($vsql);

        // Incremento el ID
        $numeroidh++;

        $vsql = "INSERT INTO hisdetallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                       VALUES ($numeroidh,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
        $clase->EjecutarSQL($vsql);

        // Envío el mensaje correspondiente
        if(mysql_affected_rows() == 0)
            $clase->Aviso(3,"No se procesó la libranza o el descuento permanente, verifique por favor");
        else
            $clase->Aviso(1,"Libranza o descuento permanente procesado satisfactoriamente");

        // Redirecciono el formulario
        header("Location: ajusteextemporaneo.php?opcion=ventanaajusteext&periodoid=$periodoid&terid=$terid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ventanaelimempl
    // Creación: 31/10/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana de conformación de la eliminación del 
    //              empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaelimempl")
    {
        $periodoid = $_GET['periodoid'];
        $terid = $_GET['terid'];

        // Variable para el nombre de empleado
        $vsqldatos = "SELECT nombre FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Variable para el nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Pintamos la ventana        
        $cont='<table width="500">
                <tr class="CabezoteTabla"> 
                 <td align="center"><br><b>Eliminar empleado</b><br><br></td> 
                </tr> 
               </table>
               <table width="500">
                <tr class="TablaDocsImPar">       
                 <td width="400" align="center">¿Confirma que desea eliminar al empledo <br> <b>'.$nombreemp.'</b> 
                  <br> del periodo <br> <b>'.$descripcion.'?</b>
                 </td>
                </tr>
                <tr class="TablaDocsImPar">       
                 <td width="400" align="center"><br><br>                  
                  <form action="?opcion=elimaempper&periodoid='.$periodoid.'&terid='.$terid.'" method="POST">
                   <input type="hidden" name="periodoid" value="'.$periodoid.'">
                   <input type="hidden" name="terid" value="'.$terid.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                  </form>
                  <br>
                 </td>        
                </tr>
               </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: elimaempper
    // Creación: 31/10/2022		última modificación: 07/12/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que elimina un empleado de un periodo
    // Última modificación: Eliminación del registro en la tabla periodoterceros
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "elimaempper")
    {
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];
        
        // Variable para el nombre de empleado
        $vsqldatos = "SELECT nombre FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Variable para el nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // elimino de detallenomina
        $vsql = "DELETE FROM detallenomina WHERE pernominaid = ".$periodoid." AND terid = ".$terid;
        $clase->EjecutarSQL($vsql);

        // elimino de hisdetallenomina
        $vsql = "DELETE FROM hisdetallenomina WHERE pernominaid = ".$periodoid." AND terid = ".$terid;
        $clase->EjecutarSQL($vsql);

        // elimino de periodoterceros
        $vsql = "DELETE FROM periodoterceros WHERE pernominaid = ".$periodoid." AND terid = ".$terid;
        $clase->EjecutarSQL($vsql);        

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"$nombreemp eliminado satisfactoriamente del periodo $descripcion");
        else
            $clase->Aviso(3,"No se eliminó a $nombreemp del periodo $descripcion");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=ventanaliquidados");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: seldatosext
    // Creación: 25/11/2022		última modificación: 15/08/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para la selección de periodo y del empleado 
    //              que se editará
    // Última modificación: Incorporación del pie de página
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "seldatosext")
    {
	    // Control de Permisos
	    if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED")) 
        {
            $params = ' class="Texto11" ';
    
            // Combo de empleados
            $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE basico > 0 ORDER BY primernombre";
    
            // combo de periodos
            $vsqlcomboperiodo  = "SELECT codigo, CONCAT(codigo,' - ',descripcion) 
                                    FROM periodosnomina 
                                   WHERE cerrado ='CHECKED' 
                                ORDER BY periodoid ASC";
    
            $cont = $clase->Header("S","W");
            $cont.='<form action="?opcion=valempleadoper" method="POST" name="x">
                    <table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/agenda.png" width="32" height="32" border="0"> </td>
                      <td width="908" > <b>Editar datos periodos anteriores </b> </td>
                      <td width="24"> 
                       <a href="calculoliquidados.php?opcion=ventanaactdatos">
                        <input type="button" value="<<" class="button">
                       </a> 
                      </td>
                      <td width="10"> &nbsp; </td>
                     </tr>
                    </table>
                    <table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>
                      <td width="40"> Empleado: </td>
                      <td width="410" align="left"> '.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","N",$params,460).' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="420" align="left"> &nbsp; </td>                  
                      <td width="24"> &nbsp; </td>
                     </tr>
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>
                      <td width="40"> Periodo: </td>
                      <td width="410" align="left"> '.$clase->CrearComboBuscar("codigo",$vsqlcomboperiodo,"descripcion","codigo","","N",$params,400).' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="420" align="left"> &nbsp; </td>                  
                      <td width="24"> &nbsp; </td>
                     </tr>
                    </table>';
    
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla">
                      <td align="center">                    
                       <input type="submit" value="aceptar" class="button blue">
                       </form>
                      </td>
                     </tr>
                    </table>';

            // Pie de página
            $cont.='<table width="100%"> 
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                    </table>';
        }
        else
        {
            $clase->Aviso(2,"Acceso No Permitido"); 
            header("Location: calculoliquidados.php?opcion=ventanaliquidados"); 
        }        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: valempleadoper
    // Creación: 25/11/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que valida si el empleado laboró en el periodo indicado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "valempleadoper")
    {
        $terid = $_POST['terid'];
        $codigo = $_POST['codigo'];
        
        // id del periodo
        $periodoid = $clase->BDLockup($codigo,'periodosnomina','codigo','periodoid');

        // Valido que el empleado haya trabajado en el periodo
        $vsql = "SELECT COUNT(*) AS regemp FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $regemp = $clase->SeleccionarUno($vsql);

        if($regemp == 0)
        {
            // Nombre del empleado
            $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombre FROM terceros WHERE terid = ".$terid;
            $nombreemp = $clase->SeleccionarUno($vsql);

            // nombre del periodo
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

            $clase->Aviso(3,"$nombreemp no laboró en el periodo $descripcion");
            header("Location: ajusteextemporaneo.php?opcion=seldatosext");
        }
        else
            header("Location: ajusteextemporaneo.php?opcion=editardatosext&periodoid=$periodoid&terid=$terid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: editardatosext
    // Creación: 25/11/2022		última modificación: 27/12/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción donde se editan los datos del empleado
    // Última modificación: Validación de la edición de datos ya transmitidos a la dian
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "editardatosext")
    {
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];

        // Nombre del empleado
        $vsql = "SELECT nombre FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $nombreemp = $clase->SeleccionarUno($vsql);
        
        // nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // idperter
        $vsql = "SELECT idperter FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $idperter = $clase->SeleccionarUno($vsql);

        // documento
        $vsql = "SELECT dni FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $dni = $clase->SeleccionarUno($vsql);

        // área
        $vsql = "SELECT areaid FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $areaidemp = $clase->SeleccionarUno($vsql);
        $vsqlcomboarea = "SELECT areaid, descripcionarea FROM areanomina ORDER BY areaid ASC";
        $comboarea = $clase->CrearComboBuscar("areaid",$vsqlcomboarea,"descripcioncargo","areaid",$areaidemp,"N",$params,200);

        // sección
        $vsql = "SELECT seccionid FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $seccionidemp = $clase->SeleccionarUno($vsql);
        $vsqlcombosec = "SELECT seccionid, descripcionsec FROM seccion ORDER BY seccionid ASC";
        $comboseccion = $clase->CrearComboBuscar("seccionid",$vsqlcombosec,"descripcionsec","seccionid",$seccionidemp,"N",$params);

        // cargo
        $vsql = "SELECT cargoid FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $cargoidemp = $clase->SeleccionarUno($vsql);
        $vsqlcombocargo = "SELECT cargoid, descripcioncargo FROM cargos ORDER BY cargoid ASC";
        $combocargo = $clase->CrearComboBuscar("cargoid",$vsqlcombocargo,"descripcioncargo","cargoid",$cargoidemp,"N",$params,240);

        // banco
        $vsql = "SELECT bancoid FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $bancoidemp = $clase->SeleccionarUno($vsql);
        $vsqlcombobanco = "SELECT bancoid, descripcion FROM bancos ORDER BY bancoid ASC";
        $combobanco = $clase->CrearComboBuscar("bancoid",$vsqlcombobanco,"descripcion","bancoid",$bancoidemp,"N",$params);

        // número de cuenta
        $vsql = "SELECT numcuenta FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $numcuenta = $clase->SeleccionarUno($vsql);

        // fecha de ingreso
        $vsql = "SELECT fecingreso FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $fecingreso = $clase->SeleccionarUno($vsql);

        // código de vendedor
        $vsql = "SELECT codvende FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $codvende = $clase->SeleccionarUno($vsql);
        
        // documento
        $vsql = "SELECT dni FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $dni = $clase->SeleccionarUno($vsql);

        // nombre del empleado
        $vsql = "SELECT nombre FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $nombre = $clase->SeleccionarUno($vsql);

        // eps
        $vsql = "SELECT epsid FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $epsidemp = $clase->SeleccionarUno($vsql);
        $vsqlcomboeps = "SELECT epsid, descripcioneps FROM eps ORDER BY epsid ASC";
        $comboeps  = $clase->CrearComboBuscar("epsid",$vsqlcomboeps,"descripcioneps","epsid",$epsidemp,"N",$params);

        // fondos de pensiones
        $vsql = "SELECT pensionesid FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $pensionesidemp = $clase->SeleccionarUno($vsql);
        $vsqlcomboafp = "SELECT pensionesid, descripcionafp FROM pensiones ORDER BY pensionesid ASC";
        $comboafp  = $clase->CrearComboBuscar("pensionesid",$vsqlcomboafp,"descripcionafp","pensionesid",$pensionesidemp,"N",$params);

        // extralegal
        $vsql = "SELECT extralegal FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $extralegal = $clase->SeleccionarUno($vsql);

        // campo transmitido
        $transmitido = $clase->BDLockup($periodoid,'periodosnomina','periodoid','transmitido');
        
        // Validación de la edición
        if($transmitido == "CHECKED")
        {
            $titulotransmitido = '<br> <font color="red"> Periodo transmitido a la dian </font>';

            $dnivista = '<font color="gray"> <label class="Texto11">C&eacute;dula:</label> '.$dni.' </font>';

            $nombreempvista = '<font color="gray"> <label class="Texto11">Nombre:</label> '.$nombreemp.' </font>';

            $fecingreso2  = substr($fecingreso,8,2)."/".substr($fecingreso,5,2)."/".substr($fecingreso,0,4);
            $fecingresovista = '<font color="gray"> <label class="Texto11">Fecha de ingreso:</label> '.$fecingreso2.' </font>';

            $descripcionbanco = $clase->BDLockup($bancoidemp,'bancos','bancoid','descripcion');
            $descripcionbanco = str_replace('BANCO','',$descripcionbanco);
            $bancovista = '<font color="gray"><label class="Texto11">Banco: '.$descripcionbanco.' </label> </font>';

            $numcuentavista = '<font color="gray"> <label class="Texto11"> N&uacute;mero de cuenta:</label> '.$numcuenta.'</font>';

            $extralegalvista = '<input type="checkbox" value="CHECKED" name="extralegal" class="Texto11" '.$extralegal.' disabled> <font color="gray"> Extralegal </font>';
        }
        else
        {
            $titulotransmitido = '';

            $dnivista = '<label class="Texto11">C&eacute;dula:</label>
                         <input type="text" name="dni" style="width:160px;height:25px" class="Texto11New" size="20" autocomplete="off" title="documento de identidad" value="'.$dni.'">';

            $nombreempvista = '<label class="Texto11">Nombre:</label>
                               <input type="text" name="nombreemp" style="width:270px;height:25px" class="Texto11New" size="20" autocomplete="off" title="Nombre del empleado" value="'.$nombreemp.'">';

            $fecingresovista = '<label class="Texto11">Fecha de ingreso:</label>
                                <input type="date" class="Texto11New" name="fecingreso" style="width:100px;height:25px" size="10" maxlenght="10" value="'.substr($fecingreso,0,10).'">';

            $bancovista = '<label class="Texto11">Banco:</label> '.$combobanco.' ';

            $numcuentavista = '<label class="Texto11">N&uacute;mero de cuenta:</label>
                               <input type="text" name="numcuenta" style="width:180px;height:25px" class="Texto11New" size="20" autocomplete="off" title="ingreso solo números" value="'.$numcuenta.'">';

            $extralegalvista = '<input type="checkbox" value="CHECKED" name="extralegal" class="Texto11" '.$extralegal.'> Extralegal';
        }

        // Pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/agenda.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Editar terceros del periodo <font color="BLUE">'.$descripcion.'</font></b> '.$titulotransmitido.' </td>
                  <td width="24"> &nbsp; </td>
                  <td width="24">
                   <a href="recibodepago.php?opcion=reciboindividual&terid='.$terid.'&periodoid='.$periodoid.'" target="_blank">
                    <img src="images/iconos/pdf.png" title="recibo de pago" border="0">
                   </a>
                  </td>                   
                  <td width="10"> &nbsp; </td>
                  <td width="24">
                   <a href="ajusteextemporaneo.php?opcion=seldatosext"> 
                    <input type="button" value="<<" class="button">
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                 </tr> 
                </table>';

        $cont.='<form action="?opcion=guardardatosant" name="y" method="POST">
                <input type="hidden" name="terid" value="'.$terid.'">
                <input type="hidden" name="idperter" value="'.$idperter.'">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <input type="hidden" name="nombreemp" value="'.$nombreemp.'">
                <input type="hidden" name="dni" value="'.$dni.'">
                <input type="hidden" name="bancoid" value="'.$bancoidemp.'">
                <input type="hidden" name="fecingreso" value="'.$fecingreso.'">
                <input type="hidden" name="numcuenta" value="'.$numcuenta.'">
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323"><label class="Texto12">Empleado(a):</label> <br>'.$nombreemp.'</td>
                  <td width="317"> &nbsp; </td>                  
                  <td width="359"> &nbsp; </td>                  
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323" align="left">
                   '.$dnivista.'
                  </td>
                  <td width="317" align="left">                   
                   <label class="Texto11">C&oacute;digo Vendedor:</label>
                   <input type="number" name="codvende" style="width:90px;height:25px" class="Texto11New" size="4" autocomplete="off" value="'.$codvende.'">  
                  </td>
                  <td width="359" align="left">
                   '.$nombreempvista.'                   
                  </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323" align="left">
                   '.$fecingresovista.'
                  </td>
                  <td width="317" align="left">
                   <label class="Texto11">&Aacute;rea:</label>
                   '.$comboarea.' 
                  </td>
                  <td width="359" align="left">
                   <label class="Texto11">Secci&oacute;n:</label>
                   '.$comboseccion.'
                  </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323" align="left">
                   <label class="Texto11">Cargo:</label>
                   '.$combocargo.'
                  </td>
                  <td width="317" align="left">
                   <label class="Texto11">E.P.S:</label>
                   '.$comboeps.'
                  </td>
                  <td width="359" align="left">
                   <label class="Texto11">A.F.P:</label>
                   '.$comboafp.' 
                  </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323" align="left">                   
                   '.$bancovista.'
                  </td>
                  <td width="317" align="left">
                   '.$numcuentavista.'
                  </td>
                  <td width="359" align="left">  
                   '.$extralegalvista.'
                  </td>
                 </tr>
                </table>';

        $cont.='<table width="100%">
                <tr class="CabezoteTabla"> 
                 <center>
                 <td width="657" align="center">                    
                  <input type="submit" value="aceptar" class="button blue">
                  </form>
                 </td>
                 </center>
                </tr>
               </table>';

        // Pie de página
        $cont.='<table width="100%"> 
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardardatosant
    // Creación: 25/11/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para almacenar los datos en la tabla periodoterceros
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardardatosant")
    {
        $idperter = $_POST['idperter'];                         $terid = $_POST['terid'];                               $periodoid = $_POST['periodoid'];
        $nombreemp = $_POST['nombreemp'];                       $dni = $_POST['dni'];                                   $fecingreso = $_POST['fecingreso'];
        $epsid = $_POST['epsid'];                               $pensionesid = $_POST['pensionesid'];                   $areaid = $_POST['areaid'];
        $seccionid = $_POST['seccionid'];                       $cargoid = $_POST['cargoid'];                           $bancoid = $_POST['bancoid'];
        $numcuenta = $_POST['numcuenta'];                       $extralegal = $_POST['extralegal'];                     $codvende = $_POST['codvende'];
                   
        // Almaceno la información en la tabla periodoterceros
        $vsql = "UPDATE periodoterceros SET 
                        pernominaid = ".$periodoid.",
                        terid = ".$terid.",
                        nombre = '".$nombreemp."',
                        extralegal = '".$extralegal."',
                        areaid = ".$areaid.",
                        seccionid = ".$seccionid.",
                        cargoid = ".$cargoid.",
                        bancoid = ".$bancoid.",
                        numcuenta = '".$numcuenta."',
                        fecingreso = '".$fecingreso."',
                        codvende = '".$codvende."',
                        dni = '".$dni."',
                        epsid = ".$epsid.",
                        pensionesid = ".$pensionesid."
                  WHERE idperter = ".$idperter;
        $clase->EjecutarSQL($vsql);

        // valido que se almacenen los datos para emitir el mensaje correspondiente
        if(mysql_affected_rows() < 1)
            $clase->Aviso(3,"No se modificaron los datos de $nombreemp");
        else
            $clase->Aviso(1,"Los datos de $nombreemp fueron modificados satisfactoriamente");

        // Redirecciono el formulario
        header("Location: ajusteextemporaneo.php?opcion=editardatosext&periodoid=$periodoid&terid=$terid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: seldatospriter
    // Creación: 23/12/2022		última modificación: 15/08/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana donde selecciono los datos que se editarán 
    //              en la tabla primasterceros
    // Última modificación: Incorporación del pie de página
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "seldatospriter")
    {
	    // Control de Permisos
	    if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED")) 
        {
            $params = ' class="Texto11" ';
    
            // Combo de empleados
            $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE basico > 0 ORDER BY primernombre";
    
            // combo de periodos
            $vsqlcomboperiodo  = "SELECT codperiodo, desperiodo FROM periodos WHERE anoperiodo >= 2021 AND orden >= 97 ORDER BY orden";
    
            $cont = $clase->Header("S","W");
            $cont.='<form action="?opcion=valempleadoprimter" method="POST" name="x">
                    <table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/clientesgenerales.png" width="32" height="32" border="0"> </td>
                      <td width="908" > <b>Editar datos de la tabla primasterceros </b> </td>
                      <td width="24"> 
                       <a href="calculoliquidados.php?opcion=ventanaactdatos">
                        <input type="button" value="<<" class="button">
                       </a> 
                      </td>
                      <td width="10"> &nbsp; </td>
                     </tr>
                    </table>
                    <table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>
                      <td width="40"> Empleado: </td>
                      <td width="410" align="left"> '.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","N",$params,460).' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="420" align="left"> &nbsp; </td>                  
                      <td width="24"> &nbsp; </td>
                     </tr>
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>
                      <td width="40"> Periodo: </td>
                      <td width="410" align="left"> '.$clase->CrearComboBuscar("codperiodo",$vsqlcomboperiodo,"desperiodo","codperiodo","","N",$params,400).' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="420" align="left"> &nbsp; </td>                  
                      <td width="24"> &nbsp; </td>
                     </tr>
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>
                      <td width="40"> Tipo: </td>
                      <td width="410" align="left"> 
                       <select name="tipo" id="tipo" style="width:120px;height:25px">
                        <option value="vacaciones" selected> Vacaciones </option> 
                        <option value="cesantias"> Cesant&iacute;as </option>
                        <option value="primas"> Primas </option>
                        <option value="indemnizacion"> Indemnizaci&oacute;n </option>                  
                       </select>
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="420" align="left"> &nbsp; </td>                  
                      <td width="24"> &nbsp; </td>
                     </tr>
                    </table>';
    
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla">
                      <td align="center">                    
                       <input type="submit" value="aceptar" class="button blue">
                       </form>
                      </td>
                     </tr>
                    </table>';

            // Pie de página
            $cont.='<table width="100%"> 
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                    </table>';
        }
        else
        {
            $clase->Aviso(2,"Acceso No Permitido"); 
            header("Location: calculoliquidados.php?opcion=ventanaliquidados"); 
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: valempleadoprimter
    // Creación: 23/12/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que valida los datos del empleado que se editará en la tabla 
    //              primasterceros
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "valempleadoprimter")
    {
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];
        $tipo = $_POST['tipo'];

        // Nombre del empleado
        $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombre FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql);

        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // Valido que el empleado tenga datos en la tabla
        $vsql2 = "SELECT COUNT(*) AS valreg FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = '".$tipo."' ";
        $valreg = $clase->SeleccionarUno($vsql2);
        
        switch(true)
        {
            case($valreg == 0):
                $clase->Aviso(3,"$nombreemp no tiene $tipo en el periodo $desperiodo");
                header("Location: ajusteextemporaneo.php?opcion=seldatospriter");                
                break;
            case($valreg > 1):
                $clase->Aviso(3,"$nombreemp tiene más de un registro de tipo $tipo en el periodo $desperiodo");
                header("Location: ajusteextemporaneo.php?opcion=seldatospriter");
                break;
            case($valreg == 1):
                header("Location: ajusteextemporaneo.php?opcion=editardatospriter&codperiodo=$codperiodo&terid=$terid&tipo=$tipo");
                break;
            default:
                break;
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editardatospriter
    // Creación: 23/12/2022		última modificación: 27/12/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción donde se editan los datos de un empleado en la tabla  
    //              primasterceros
    // Última modificación: Validación de la edición de datos ya transmitidos a la dian
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editardatospriter")
    {
        $terid = $_GET['terid'];
        $codperiodo = $_GET['codperiodo'];
        $tipo = $_GET['tipo'];

        $valperiodo = 0;

        $params = ' class="Texto11" ';

        // idpriter
        $vsql = "SELECT idpriter FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = '".$tipo."' ";
        $idpriter = $clase->SeleccionarUno($vsql);

        // Nombre del empleado
        $vsql = "SELECT nombre FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = '".$tipo."' ";
        $nombreemp = $clase->SeleccionarUno($vsql);
        
        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
        
        // extralegal
        $vsql = "SELECT extralegal FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = '".$tipo."' ";
        $extralegal = $clase->SeleccionarUno($vsql);
        
        // área
        $vsql = "SELECT areaid FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = '".$tipo."' ";
        $areaidemp = $clase->SeleccionarUno($vsql);
        $vsqlcomboarea = "SELECT areaid, descripcionarea FROM areanomina ORDER BY areaid ASC";
        $comboarea = $clase->CrearComboBuscar("areaid",$vsqlcomboarea,"descripcioncargo","areaid",$areaidemp,"N",$params,200);
        
        // sección
        $vsql = "SELECT seccionid FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = '".$tipo."' ";
        $seccionidemp = $clase->SeleccionarUno($vsql);
        $vsqlcombosec = "SELECT seccionid, descripcionsec FROM seccion ORDER BY seccionid ASC";
        $comboseccion = $clase->CrearComboBuscar("seccionid",$vsqlcombosec,"descripcionsec","seccionid",$seccionidemp,"N",$params);

        // cargo
        $vsql = "SELECT cargoid FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = '".$tipo."' ";
        $cargoidemp = $clase->SeleccionarUno($vsql);
        $vsqlcombocargo = "SELECT cargoid, descripcioncargo FROM cargos ORDER BY cargoid ASC";
        $combocargo = $clase->CrearComboBuscar("cargoid",$vsqlcombocargo,"descripcioncargo","cargoid",$cargoidemp,"N",$params,240);

        // banco
        $vsql = "SELECT bancoid FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = '".$tipo."' ";
        $bancoidemp = $clase->SeleccionarUno($vsql);
        $vsqlcombobanco = "SELECT bancoid, descripcion FROM bancos ORDER BY bancoid ASC";
        $combobanco = $clase->CrearComboBuscar("bancoid",$vsqlcombobanco,"descripcion","bancoid",$bancoidemp,"N",$params);
        
        // número de cuenta
        $vsql = "SELECT numcuenta FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = '".$tipo."' ";
        $numcuenta = $clase->SeleccionarUno($vsql);

        // fecha de ingreso
        $vsql = "SELECT fecingreso FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = '".$tipo."' ";
        $fecingreso = $clase->SeleccionarUno($vsql);
        
        // salario básico
        $vsql = "SELECT basico FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = '".$tipo."' ";
        $basico = $clase->SeleccionarUno($vsql);

        // Código de vendedor
        $vsql = "SELECT codvende FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = '".$tipo."' ";
        $codvende = $clase->SeleccionarUno($vsql);

        // documento
        $vsql = "SELECT dni FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = '".$tipo."' ";
        $dni = $clase->SeleccionarUno($vsql);

        // eps
        $vsql = "SELECT epsid FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = '".$tipo."' ";
        $epsidemp = $clase->SeleccionarUno($vsql);
        $vsqlcomboeps = "SELECT epsid, descripcioneps FROM eps ORDER BY epsid ASC";
        $comboeps  = $clase->CrearComboBuscar("epsid",$vsqlcomboeps,"descripcioneps","epsid",$epsidemp,"N",$params);

        // fondos de pensiones
        $vsql = "SELECT pensionesid FFROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = '".$tipo."' ";
        $pensionesidemp = $clase->SeleccionarUno($vsql);
        $vsqlcomboafp = "SELECT pensionesid, descripcionafp FROM pensiones ORDER BY pensionesid ASC";
        $comboafp  = $clase->CrearComboBuscar("pensionesid",$vsqlcomboafp,"descripcionafp","pensionesid",$pensionesidemp,"N",$params);

        // Validación de la edición de algunos datos
        $vsql4 = "SELECT COUNT(*) valperiodo FROM periododian WHERE periodonomina = '".$codperiodo."'";
        $valperiodo = $clase->SeleccionarUno($vsql4);

        if($valperiodo > 0)
        {
            $titulotransmitido = '<br> <font color="red"> Periodo transmitido a la dian </font>';

            $dnivista = '<font color="gray"> <label class="Texto11">C&eacute;dula:</label> '.$dni.' </font>';

            $nombreempvista = '<font color="gray"> <label class="Texto11">Nombre:</label> '.$nombreemp.' </font>';

            $fecingreso2  = substr($fecingreso,8,2)."/".substr($fecingreso,5,2)."/".substr($fecingreso,0,4);
            $fecingresovista = '<font color="gray"> <label class="Texto11">Fecha de ingreso:</label> '.$fecingreso2.' </font>';

            $descripcionbanco = $clase->BDLockup($bancoidemp,'bancos','bancoid','descripcion');
            $descripcionbanco = str_replace('BANCO','',$descripcionbanco);
            $bancovista = '<font color="gray"><label class="Texto11">Banco: '.$descripcionbanco.' </label> </font>';

            $numcuentavista = '<font color="gray"> <label class="Texto11"> N&uacute;mero de cuenta:</label> '.$numcuenta.'</font>';

            $extralegalvista = '<input type="checkbox" value="CHECKED" name="extralegal" class="Texto11" '.$extralegal.' disabled> <font color="gray"> Extralegal </font>';
        }
        else
        {
            $titulotransmitido = '';

            $dnivista = '<label class="Texto11">C&eacute;dula:</label>
                         <input type="text" name="dni" style="width:160px;height:25px" class="Texto11New" size="20" autocomplete="off" title="documento de identidad" value="'.$dni.'">';

            $nombreempvista = '<label class="Texto11">Nombre:</label>
                               <input type="text" name="nombreemp" style="width:270px;height:25px" class="Texto11New" size="20" autocomplete="off" title="Nombre del empleado" value="'.$nombreemp.'">';

            $fecingresovista = '<label class="Texto11">Fecha de ingreso:</label>
                                <input type="date" class="Texto11New" name="fecingreso" style="width:100px;height:25px" size="10" maxlenght="10" value="'.substr($fecingreso,0,10).'">';

            $bancovista = '<label class="Texto11">Banco:</label> '.$combobanco.' ';

            $numcuentavista = '<label class="Texto11">N&uacute;mero de cuenta:</label>
                               <input type="text" name="numcuenta" style="width:180px;height:25px" class="Texto11New" size="20" autocomplete="off" title="ingreso solo números" value="'.$numcuenta.'">';

            $extralegalvista = '<input type="checkbox" value="CHECKED" name="extralegal" class="Texto11" '.$extralegal.'> Extralegal';
        }

        // Pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/clientesgenerales.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Editar datos de la tabla primasterceros</b> '.$titulotransmitido.' </td>
                  <td width="24"> &nbsp; </td>
                  <td width="24"> &nbsp; </td>                   
                  <td width="10"> &nbsp; </td>
                  <td width="24">
                   <a href="ajusteextemporaneo.php?opcion=seldatospriter"> 
                    <input type="button" value="<<" class="button">
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                 </tr> 
                </table>';

        $cont.='<form action="?opcion=guardardatospriter" name="y" method="POST">
                <input type="hidden" name="terid" value="'.$terid.'">
                <input type="hidden" name="idpriter" value="'.$idpriter.'">
                <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                <input type="hidden" name="tipo" value="'.$tipo.'">
                <input type="hidden" name="nombreemp" value="'.$nombreemp.'">
                <input type="hidden" name="dni" value="'.$dni.'">
                <input type="hidden" name="bancoid" value="'.$bancoidemp.'">
                <input type="hidden" name="fecingreso" value="'.$fecingreso.'">
                <input type="hidden" name="numcuenta" value="'.$numcuenta.'">
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323"> <label class="Texto12"> Empleado(a): <br>'.$nombreemp.' </label> </td>
                  <td width="317"> <label class="Texto12"> Periodo: <br>'.$desperiodo.' </label> </td>
                  <td width="359"> <label class="Texto12"> Tipo: <br>'.strtoupper($tipo).' </label> </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323" align="left">
                   '.$dnivista.'
                  </td>
                  <td width="317" align="left">
                   <label class="Texto11">C&oacute;digo Vendedor:</label>
                   <input type="number" name="codvende" style="width:90px;height:25px" class="Texto11New" size="4" autocomplete="off" value="'.$codvende.'">  
                  </td>
                  <td width="359" align="left">
                   '.$nombreempvista.'
                  </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323" align="left">
                   '.$fecingresovista.'
                  </td>
                  <td width="317" align="left">
                   <label class="Texto11">&Aacute;rea:</label>
                   '.$comboarea.' 
                  </td>
                  <td width="359" align="left">
                   <label class="Texto11">Secci&oacute;n:</label>
                   '.$comboseccion.'
                  </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323" align="left">
                   <label class="Texto11">Cargo:</label>
                   '.$combocargo.'
                  </td>
                  <td width="317" align="left">
                   <label class="Texto11">E.P.S:</label>
                   '.$comboeps.'
                  </td>
                  <td width="359" align="left">
                   <label class="Texto11">A.F.P:</label>
                   '.$comboafp.' 
                  </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323" align="left">                   
                   '.$bancovista.'                    
                  </td>
                  <td width="317" align="left">
                   '.$numcuentavista.'
                  </td>
                  <td width="359" align="left">  
                  '.$extralegalvista.'
                  </td>
                 </tr>
                </table>';

        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <center>
                  <td width="657" align="center">                    
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                  </center>
                 </tr>
                </table>';

        // Pie de página
        $cont.='<table width="100%"> 
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardardatospriter
    // Creación: 23/12/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena los datos editados en la tabla primasterceros
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardardatospriter")
    {
        $idpriter = $_POST['idpriter'];                         $terid = $_POST['terid'];                               $codperiodo = $_POST['codperiodo'];
        $nombreemp = $_POST['nombreemp'];                       $dni = $_POST['dni'];                                   $fecingreso = $_POST['fecingreso'];
        $epsid = $_POST['epsid'];                               $pensionesid = $_POST['pensionesid'];                   $areaid = $_POST['areaid'];
        $seccionid = $_POST['seccionid'];                       $cargoid = $_POST['cargoid'];                           $bancoid = $_POST['bancoid'];
        $numcuenta = $_POST['numcuenta'];                       $extralegal = $_POST['extralegal'];                     $codvende = $_POST['codvende'];
        $tipo = $_POST['tipo'];

        $vsql = "UPDATE primasterceros SET                        
                        extralegal = '".$extralegal."',
                        areaid = ".$areaid.",
                        seccionid = ".$seccionid.",
                        cargoid = ".$cargoid.",
                        bancoid = ".$bancoid.",
                        numcuenta = '".$numcuenta."',
                        fecingreso = '".$fecingreso."',                        
                        codvende = '".$codvende."',
                        dni = '".$dni."',
                        nombre = '".$nombreemp."',
                        epsid = ".$epsid.",
                        pensionesid = ".$pensionesid."
                  WHERE idpriter = ".$idpriter;
        $clase->EjecutarSQL($vsql);

        // valido que se almacenen los datos para emitir el mensaje correspondiente
        if(mysql_affected_rows() < 1)
            $clase->Aviso(3,"No se modificaron los datos de $nombreemp en la tabla primasterceros");
        else
            $clase->Aviso(1,"Los datos de $nombreemp fueron modificados satisfactoriamente en la tabla primasterceros");

        // Redirecciono el formulario
        header("Location: ajusteextemporaneo.php?opcion=editardatospriter&codperiodo=$codperiodo&terid=$terid&tipo=$tipo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: macroperanterior
    // Creación: 02/01/2023		última modificación: 11/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que emite la macro del periodo anterior
    // Última modificación: No aplicar el descuento a la incapacidad superior a 180 días
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "macroperanterior")
    {
        $periodoid  = $_GET['periodoid'];
        
        // Preparación del entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Consulta de los empleados a los cuales se les consignará
        $vsql = "SELECT '2' AS tipo, t.dni AS cedula, t.terid,          
                        '51' AS codbanco, 'CA' AS tiposer, t.numcuenta AS cuenta, 
                        (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS consignar 
                   FROM periodoterceros t          
                        INNER JOIN hisdetallenomina d ON (t.terid = d.terid AND d.pernominaid = t.pernominaid)          
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                  WHERE d.pernominaid = ".$periodoid."
                        AND (t.esempleadoactivo='CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                        AND (t.numcuenta <> '' AND t.numcuenta IS NOT NULL)
               GROUP BY t.terid";

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("macro - DROPOS")
                                     ->setSubject("macro - DROPOS")
                                     ->setDescription("macro - DROPOS")
                                     ->setKeywords("macro - DROPOS")
                                     ->setCategory("Categoria General");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'TIPO')
                    ->setCellValue('B1', 'CEDULA')
                    ->setCellValue('C1', 'NOMBRES')
                    ->setCellValue('D1', 'APELLIDOS')
                    ->setCellValue('E1', 'CODBANCO')
                    ->setCellValue('F1', 'TIPOSER')
                    ->setCellValue('G1', 'CUENTA')
                    ->setCellValue('H1', 'CONSIGNAR');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                         $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                         $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);                         $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);                         $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);

        $primernombre = "";             $segundonombre = "";                $primerapellido = "";                   $segundoapellido = "";

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);
        $i=2;
        while($row = mysql_fetch_array($result))
        {
            // Obtengo los nombres y los apellidos
            $terid = $row['terid'];

            $primernombre = $clase->BDLockup($terid,'terceros','terid','primernombre');
            $segundonombre = $clase->BDLockup($terid,'terceros','terid','segundonombre');
            $primerapellido = $clase->BDLockup($terid,'terceros','terid','primerapellido');
            $segundoapellido = $clase->BDLockup($terid,'terceros','terid','segundoapellido');

            $nombres = $primernombre." ".$segundonombre;
            $apellidos = $primerapellido." ".$segundoapellido;

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['tipo'])
                        ->setCellValue('B'.$i, $row['cedula'])
                        ->setCellValue('C'.$i, $nombres)
                        ->setCellValue('D'.$i, $apellidos)
                        ->setCellValue('E'.$i, $row['codbanco'])
                        ->setCellValue('F'.$i, $row['tiposer'])
                        ->setCellValue('G'.$i, strval($row['cuenta']))
                        ->setCellValue('H'.$i, $row['consignar']);
            $i++;
            $cant++;
        }

        $rangoEncabezado = 'A4:G4';
        $rangoCeldas     = 'A4:G'.($cant+1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //        
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(20);

        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('macro');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $nombrearchivo = strtolower($descripcion).".xls";
        header('Content-Disposition: attachment;filename="'.$nombrearchivo.'"');
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editarextnomina
    // Creación: 02/01/2023		última modificación: 06/12/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para seleccionar el empleado para su edición 
    //              en el periodo anterior en caso de ser editado por un usuario no 
    //              administrador 
    // Última modificación: Optimización de la ventana redistribuyendo los datos 
    //                      verticalmente (05/01/2023)
    //                      Validación que el texto del motivo sea claro 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "editarextnomina")
    {
        $periodoid = $_POST['periodoid'];
        $origen = $_POST['origen'];
        
        $lbvienedeajustar = false;
        if(strlen($periodoid)==0)
        {
            $periodoid  = $_GET['periodoid'];
            $lbvienedeajustar = true;
        }

        $motivo = $_POST['motivo'];
        $motivo = trim($motivo);        

        if((strlen($motivo) == 0)&&!$lbvienedeajustar)
        {
            $clase->Aviso(3,"Debe ingresar el motivo del cambio"); 
            header("Location: calculoliquidados.php?opcion=ventanaliquidados"); 
        }
        else
        {
            if(strlen(trim($motivo)) <= 15)
            {
                $clase->Aviso(3,"Debe ingresar un texto que explique claramente el motivo del cambio a realizar"); 
                header("Location: calculoliquidados.php?opcion=ventanaactdatos"); 
            }
            else
            {
                if(!$lbvienedeajustar)
                {
                    // Almaceno el motivo de la edición            
                    $vsql = "INSERT INTO logcambiosnomina(tabla,campo,valor,motivo,creador,momento) 
                                  VALUES ('hisdetallenomina','periodoid',".$periodoid.",'".$motivo."','".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";
                    $clase->EjecutarSQL($vsql);
                }
        
                // nombre del periodo
                $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        
                $params = ' class="Texto11" ';
        
                // Combo de empleados
                $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE basico > 0 ORDER BY primernombre";

                // combo de periodos
                $vsql = "SELECT periodoid
                           FROM periodosnomina 
                          WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
                $periodoidact = $clase->SeleccionarUno($vsql);

                $segundaq = ($periodoidact - 1);
                $primeraq = ($periodoidact - 2);

                // $vsqlcomboperiodos = "SELECT periodoid, descripcion FROM periodosnomina WHERE periodoid IN ($primeraq,$segundaq) AND transmitido <> 'CHECKED'";
                $yearactual = strval(date("Y"));
                $vsqlcomboperiodos = "SELECT periodoid, descripcion FROM periodosnomina WHERE SUBSTRING(descripcion,-4) = '".$yearactual."' AND periodoid <= ".$periodoidact."";
                $comboperiodos = $clase->CrearComboBuscar("periodoid",$vsqlcomboperiodos,"descripcion","periodoid",$periodoid,"N",$params,350);                
        
                $cont = $clase->Header("S","W");
                $cont.='<form action="?opcion=validaempleado" method="POST" name="x">
                        <input type="hidden" name="periodoid" value="'.$periodoid.'">
                        <input type="hidden" name="origen" value="'.$origen.'">
                        <table width="100%">
                         <tr class="CabezoteTabla"> 
                          <td width="10"> &nbsp; </td>
                          <td width="37"> <img src="images/iconos/calculando.png" width="32" height="32" border="0"> </td>
                          <td width="700"> <b>Ajuste extemporáneo </b> <font color="blue"> <br>'.$_SESSION['USERNAME'].' </font> </td>
                          <td width="10"> &nbsp; </td>
                          <td width="212"> &nbsp; </td>                  
                          <td width="10"> 
                           <a href="?opcion=macroperanterior&periodoid='.$periodoid.'" title="generar macro" target="_blank"> 
                            <img src="images/iconos/exportarexcel2.png" border="0"> 
                           </a> 
                          </td>
                          <td width="10"> &nbsp; </td>
                         </tr>
                         <tr class="BarraDocumentos" style="height:50px;Important!">
                          <td width="10"> &nbsp; </td>
                          <td width="37"> &nbsp; </td>
                          <td width="700"> Periodo: &nbsp;&nbsp; '.$comboperiodos.' </td>
                          <td width="10"> &nbsp; </td>
                          <td width="212"> &nbsp; </td> 
                          <td width="10"> &nbsp; </td>
                          <td width="10"> &nbsp; </td>
                         </tr>
                         <tr class="BarraDocumentos" style="height:50px;Important!">
                          <td width="10"> &nbsp; </td>
                          <td width="37"> &nbsp; </td>
                          <td width="700"> Empleado: '.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","N",$params,460).' </td>
                          <td width="10"> &nbsp; </td>
                          <td width="212"> &nbsp; </td> 
                          <td width="10"> &nbsp; </td>
                          <td width="10"> &nbsp; </td>
                         </tr>
                        </table>';            
        
                $cont.='<table width="100%">
                         <tr class="BarraDocumentos" style="height:50px;Important!">
                          <td align="center">
                           <br>
                           <input type="submit" value="aceptar" class="button blue">
                           </form>
                           <a href="calculoliquidados.php?opcion=ventanaliquidados" ><input type="button" value="CANCELAR" class="button red"></a>
                          </td>
                         </tr>
                        </table>';

                // Pie de página
                $cont.='<table width="100%"> 
                         <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                         <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                         <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                         <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                         <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                         <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                         <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                         <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                        </table>';
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: editdevsaldo
    // Creación: 24/08/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para editar los cambios del devengado y el saldo del sueldo    
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editdevsaldo")
    {
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];

        // Variable para el nombre de empleado
        $vsqldatos = "SELECT nombre AS nombreemp FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Variable para el nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // id de detalle
        $vsqldatos = "SELECT detalleid FROM hisdetallenomina WHERE conceptoid = 1 AND pernominaid = ".$periodoid." AND terid = ".$terid;
        $detalleid = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // devengado
        $vsqldatos = "SELECT devengados FROM hisdetallenomina WHERE detalleid = ".$detalleid;
        $devengados = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // saldo
        $vsqldatos = "SELECT saldo FROM hisdetallenomina WHERE detalleid = ".$detalleid;
        $saldo = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Pintamos la ventana        
        $cont.='<table width="400">
                 <tr class="CabezoteTabla">
                  <td align="center"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td align="center"> <b>Edici&oacute;n de devengado y saldo del empleado </b><br><font color="BLUE">'.$nombreemp.'</font> <br> <b>periodo </b><br><font color="BLUE">'.$descripcion.'</font> </td>
                 </tr> 
                </table>                
                <form action="?opcion=guardardevsal" name="y" method="POST">
                <input type="hidden" name="detalleid" value="'.$detalleid.'">
                <input type="hidden" name="terid" value="'.$terid.'">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <table width="400">
                 <tr class="CabezoteTabla">
                  <td align="center"><label class="Texto12">Devengado:</label>
                   <input type="number" name="devengados" min="0" class="Texto11New" size="2" autocomplete="off" title="devengados" value="'.$devengados.'">                  
                  </td>                  
                 </tr>
                 <tr class="CabezoteTabla">
                  <td align="center"><label class="Texto12">Saldo:</label>
                   <input type="number" name="saldo" min="0" class="Texto11New" size="2" autocomplete="off" title="saldo" value="'.$saldo.'">                  
                  </td>
                 </tr>
                </table>
                <table width="400">
                 <tr class="CabezoteTabla">
                  <td align="center">                    
                   <input type="submit" value="aceptar" class="button blue">
                   <a href="ajusteextemporaneo.php?opcion=ventanaajusteext&periodoid='.$periodoid.'&terid='.$terid.'"><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardardevsal
    // Creación: 24/08/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena los cambios realizados en el devengado y el saldo 
    //              del sueldo tanto en la tabla de detalle como en el histórico
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardardevsal")
    {
        $detalleid = $_POST['detalleid'];
        $devengados = $_POST['devengados'];
        $saldo = $_POST['saldo'];
        $terid = $_POST['terid'];
        $periodoid = $_POST['periodoid'];

        // Inicializo las variables
        $vsqldatos = "";
        $detalleidant = 0;

        // Almaceno los cambios
        $vsql = "UPDATE hisdetallenomina SET 
                        devengados = ".$devengados.", 
                        saldo = ".$saldo."
                  WHERE detalleid = ".$detalleid."";
        $clase->EjecutarSQL($vsql);

        // Envío el mensaje correspondiente
        if(mysql_affected_rows() > 0)
            $clase->Aviso(3,"No se editaron los datos");
        else
            $clase->Aviso(1,"Datos editados exitosamente");

        // Corrijo también en la tabla detallenomina

        // id de detalle
        $vsqldatos = "SELECT detalleid FROM detallenomina WHERE conceptoid = 1 AND pernominaid = ".$periodoid." AND terid = ".$terid;
        $detalleidant = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Almaceno los cambios
        $vsql = "UPDATE detallenomina SET 
                        devengados = ".$devengados.", 
                        saldo = ".$saldo."
                  WHERE detalleid = ".$detalleidant."";
        $clase->EjecutarSQL($vsql);

        // Redirecciono el formulario
        header("Location: ajusteextemporaneo.php?opcion=ventanaajusteext&periodoid=$periodoid&terid=$terid");                
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: incluirrecargos
    // Creación: 10/11/2024		última modificación: 21/10/2025
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para captar los datos del nuevo recargo
    // Última modificación: Inclusión del campo monto
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "incluirrecargos")
    {
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];        

        // nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // nombre del empleado
        $nomreemp = "CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido)";
        $nombreempleado = $clase->BDLockup($terid,'terceros','terid',$nomreemp);
        
        // combo de recargos
        $vsqlcomborecargo = "SELECT conceptoid, nomconcepto descripcion FROM conceptosnomina WHERE recargo = 'CHECKED'";
        $comborecargo = $clase->CrearComboBuscar("conceptoid",$vsqlcomborecargo,"descripcion","conceptoid","","S",$params,400);

        // cantidad
        $cantidad = 1;

        // monto en caso de ser editado
        $devengados = 0;
        
        // pinto la ventana
        $cont= '<table width="500">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/park.png" width="32" height="32" border="0"> </td>
                  <td width="450" align="center"> <label class="Texto12"> <b>Inclusi&oacute;n de recargo <br> <font color="blue"> '.$descripcion.' </font> </b> </label> </td>
                 </tr>
                </table>
                <form action="?opcion=guardarrecargo" method="POST">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <input type="hidden" name="terid" value="'.$terid.'">
                <table width="500">
                 <tr class="BarraDocumentos" style="height:60px;Important!"> 
                  <td width="20"> &nbsp; </td>
                  <td width="480" align="left"> <label class="Texto12"> <b> Empleado: </b> <br>'.$nombreempleado.' </label> </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:60px;Important!"> 
                  <td width="20"> &nbsp; </td>
                  <td width="480" align="left"> <label class="Texto12"> <b> Concepto: </b> <br>'.$comborecargo.' </label> </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:60px;Important!"> 
                  <td width="20"> &nbsp; </td>
                  <td width="480" align="left"> 
                   <label class="Texto12"> <b> Cantidad: </b> </label> <br>
                   <input type="number" name="cantidad" min="1" max="180" class="Texto12New" size="12" style="width:80px;height:25px;" autocomplete="off" title="días de recargo" value="'.$cantidad.'"> 
                  </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:60px;Important!"> 
                  <td width="20"> &nbsp; </td>
                  <td width="480" align="left"> 
                   <label class="Texto12"> <b> Monto: </b> </label> <br>
                   <input type="number" name="devengados" min="0" class="Texto12New" size="12" style="width:120px;height:25px;" autocomplete="off" title="días de recargo" value="'.$devengados.'"> 
                  </td>
                 </tr>
                </table>
                <table width="500">
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="480" align="center">
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="ajusteextemporaneo.php?opcion=ventanaajusteext&periodoid='.$periodoid.'&terid='.$terid.'">
                    <input type="button" value="CANCELAR" class="button red">
                   </a>
                   </form>
                  </td>
                 </tr>
                </table>';        

       echo $cont;
       exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardarrecargo
    // Creación: 10/11/2024		última modificación: 21/10/2025
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que almacena el nuevo recargo tanto en la tabla detalle de nómina 
    //              como en el histórico
    // Última modificación: Inclusión de la opción para no calcular el monto tomando el que 
    //                      se editó
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarrecargo")
    {
        $terid = $_POST['terid'];
        $periodoid = $_POST['periodoid'];
        $conceptoid = $_POST['conceptoid'];
        $cantidad = $_POST['cantidad'];
        $devengados = $_POST['devengados'];

        // valido la entrada de los datos
        if((strlen($conceptoid == 0)) || (strlen($cantidad) == 0))
            $clase->Aviso(3,"Debe incluir concepto y cantidad");
        else
        {
            // valido que el concepto ya esté incluido para este empreado en este periodo
            $valconcepto = $clase->SeleccionarUno("SELECT COUNT(*) valconcepto FROM detallenomina WHERE terid = ".$terid." AND conceptoid = ".$conceptoid." AND pernominaid = ".$periodoid."");

            if($valconcepto > 0)
                $clase->Aviso(3,"Concepto ya ha sido incluido");
            else
            {
                // obtengo el salario base
                $basico = $clase->SeleccionarUno("SELECT basico FROM periodoterceros WHERE pernominaid = ".$periodoid." AND terid = ".$terid."");

                if($basico == "")
                    $basico = $clase->BDLockup($terid,"terceros","terid","basico");

                if($devengados > 0)
                    $recargo = $devengados;
                else
                {
                    // Obtengo la formula del recargo
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                    $formularecargo = $clase->SeleccionarUno($vsql);
        
                    // Calculo el recargo
                    eval("\$recargo = $formularecargo;");
                    $recargo = round($recargo,0);                    
                }
    
                // incremento el id
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);
    
                // almaceno el recargo
                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",".$conceptoid.",".$periodoid.",".$recargo.",0,".$cantidad.",$basico)";
                $clase->EjecutarSQL($vsql);
    
                // recalculo salud y pensión
                $vsql = "SELECT IFNULL(devengados,0) FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
                $sueldo = $clase->SeleccionarUno($vsql);        
        
                // recalculo pensión y salud
                $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                           FROM detallenomina d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                          WHERE d.terid = ".$terid."
                                AND d.pernominaid = ".$periodoid." 
                                AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                $totnovedades = $clase->SeleccionarUno($vsql);
        
                $vsql = "SELECT SUM(d.devengados) AS totrecargos 
                           FROM detallenomina d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                          WHERE d.terid = ".$terid."
                                AND d.pernominaid = ".$periodoid." 
                                AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                $totrecargos = $clase->SeleccionarUno($vsql);
        
                $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;
        
                $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');
                $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud
        
                $extralegal = $clase->BDLockup($terid,'terceros','terid','extralegal');
                $epsid = $clase->BDLockup($terid,'terceros','terid','epsid');
                $pensionesid = $clase->BDLockup($terid,'terceros','terid','pensionesid');
                
                if($epsid==NULL)                $epsid=0;
                if($pensionesid==NULL)          $pensionesid=0;        
        
                if($extralegal=="CHECKED")
                {
                    $pension = 0;
                    $salud = 0;
                }
                else
                {
                    // Recalculo pensión y salud
                    if(($pensionesid==5) || ($aplicapension!="CHECKED"))
                        $pension = 0;
                    else
                    {
                        // Obtengo la formula para el descuento por pensión
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                        $formulapension = $clase->SeleccionarUno($vsql);
        
                        // Calculo la pensión
                        eval("\$pension = $formulapension;");
                        $pension = round($pension,0);
                    }
        
                    if(($epsid==37) || ($aplicasalud!="CHECKED"))
                        $salud = 0;
                    else
                    {
                        // Obtengo la formula para el descuento de salud
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                        $formulasalud = $clase->SeleccionarUno($vsql);
                        
                        // Calculo la salud
                        eval("\$salud = $formulasalud;");
                        $salud = round($salud,0);
                    }
                }
        
                //  ID pensión
                $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                $idpension = $clase->SeleccionarUno($vsql);
        
                // Grabo la pensión
                if($idpension!="")
                    $vsql = "UPDATE detallenomina SET 
                                    descuentos = ".$pension.",
                                    saldo = ".$sueldodeducciones."
                              WHERE detalleid = ".$idpension;
                else
                {
                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                    $numreg = $clase->SeleccionarUno($vsql);
        
                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                }
                $clase->EjecutarSQL($vsql);
        
                // ID salud
                $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                $idsalud = $clase->SeleccionarUno($vsql);
        
                // Grabo la salud
                if($idsalud!="")
                    $vsql = "UPDATE detallenomina SET 
                                    descuentos = ".$salud.",
                                    saldo = ".$sueldodeducciones."
                              WHERE detalleid = ".$idsalud;
                else
                {
                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                    $numreg = $clase->SeleccionarUno($vsql);
        
                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                }
                $clase->EjecutarSQL($vsql);
                
                // Aquí depuro los conceptos que estén en cero
                $vsql = "DELETE FROM detallenomina WHERE devengados <= 0 AND descuentos <= 0 AND pernominaid = ".$periodoid." AND terid = ".$terid;
                $clase->EjecutarSQL($vsql);
    
                // -------------------------------------------------------------------------------------------------------------------------- //
                // proceso el histórico 
                $vsql = "INSERT INTO hisdetallenomina VALUES ($numreg+1,".$terid.",".$conceptoid.",".$periodoid.",".$recargo.",0,".$cantidad.",$basico)";
                $clase->EjecutarSQL($vsql);
    
                // recalculo salud y pensión
                $vsql = "SELECT IFNULL(devengados,0) FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
                $sueldo = $clase->SeleccionarUno($vsql);        
        
                // recalculo pensión y salud
                $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                           FROM hisdetallenomina d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                          WHERE d.terid = ".$terid."
                                AND d.pernominaid = ".$periodoid." 
                                AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                $totnovedades = $clase->SeleccionarUno($vsql);
        
                $vsql = "SELECT SUM(d.devengados) AS totrecargos 
                           FROM hisdetallenomina d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                          WHERE d.terid = ".$terid."
                                AND d.pernominaid = ".$periodoid." 
                                AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                $totrecargos = $clase->SeleccionarUno($vsql);
        
                $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;
        
                $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');
                $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud
        
                $extralegal = $clase->BDLockup($terid,'terceros','terid','extralegal');
                $epsid = $clase->BDLockup($terid,'terceros','terid','epsid');
                $pensionesid = $clase->BDLockup($terid,'terceros','terid','pensionesid');
                
                if($epsid==NULL)                $epsid=0;
                if($pensionesid==NULL)          $pensionesid=0;        
        
                if($extralegal=="CHECKED")
                {
                    $pension = 0;
                    $salud = 0;
                }
                else
                {
                    // Recalculo pensión y salud
                    if(($pensionesid==5) || ($aplicapension!="CHECKED"))
                        $pension = 0;
                    else
                    {
                        // Obtengo la formula para el descuento por pensión
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                        $formulapension = $clase->SeleccionarUno($vsql);
        
                        // Calculo la pensión
                        eval("\$pension = $formulapension;");
                        $pension = round($pension,0);
                    }
        
                    if(($epsid==37) || ($aplicasalud!="CHECKED"))
                        $salud = 0;
                    else
                    {
                        // Obtengo la formula para el descuento de salud
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                        $formulasalud = $clase->SeleccionarUno($vsql);
                        
                        // Calculo la salud
                        eval("\$salud = $formulasalud;");
                        $salud = round($salud,0);
                    }
                }
        
                //  ID pensión
                $vsql = "SELECT detalleid AS idpension FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                $idpension = $clase->SeleccionarUno($vsql);
        
                // Grabo la pensión
                if($idpension!="")
                    $vsql = "UPDATE hisdetallenomina SET 
                                    descuentos = ".$pension.",
                                    saldo = ".$sueldodeducciones."
                              WHERE detalleid = ".$idpension;
                else
                {
                    $vsql = "SELECT max(detalleid) FROM hisdetallenomina";
                    $numreg = $clase->SeleccionarUno($vsql);
        
                    $vsql = "INSERT INTO hisdetallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                }
                $clase->EjecutarSQL($vsql);
        
                // ID salud
                $vsql = "SELECT detalleid AS idsalud FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                $idsalud = $clase->SeleccionarUno($vsql);
        
                // Grabo la salud
                if($idsalud!="")
                    $vsql = "UPDATE hisdetallenomina SET 
                                    descuentos = ".$salud.",
                                    saldo = ".$sueldodeducciones."
                              WHERE detalleid = ".$idsalud;
                else
                {
                    $vsql = "SELECT max(detalleid) FROM hisdetallenomina";
                    $numreg = $clase->SeleccionarUno($vsql);
        
                    $vsql = "INSERT INTO hisdetallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                }
                $clase->EjecutarSQL($vsql);
                
                // Aquí depuro los conceptos que estén en cero
                $vsql = "DELETE FROM hisdetallenomina WHERE devengados <= 0 AND descuentos <= 0 AND pernominaid = ".$periodoid." AND terid = ".$terid;
                $clase->EjecutarSQL($vsql);
                // -------------------------------------------------------------------------------------------------------------------------- //
        
                // emito el mensaje correspondiente
                $clase->Aviso(1,"Recargo almacenado satisfactoriamente");
            }
        }

        header("Location: ajusteextemporaneo.php?opcion=ventanaajusteext&periodoid=$periodoid&terid=$terid");
    }


    ////////////////////////////////
    echo $cont.$clase->PiePagina();    
?>