<?PHP
    @session_start(); 
    include("lib/Sistema.php");
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: valopcion
    // Creación: 18/02/2021		última modificación: 24/05/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que valida y redirecciona la opción ventanaajuste
    // Última modificación: Se validó que el periodo no estuviera cerrado y que el empleado
    //                      no sea aprendiz del SENA (20/02/2021)
    //                      Se le permite recalcular al aprendiz SENA (06/04/2021)
    //                      Se modificó para que solo ajustara el periodo actual
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "valopcion")
    {
        $terid = $_POST['terid'];
        $periodoid = $_POST['periodoid'];
        $lonempleado = strlen($terid);

        // Valido que estén introducidos todos los datos
        if($lonempleado==0)
        {
            $clase->Aviso(3,"Debe introducir el empleado");
            header("Location: ajustenomina.php?opcion=ventanaajuste");
        }
        else
        {
            // Variable para el nombre del periodo
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

            // Variable para el nombre de empleado
            $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM tercerosactualactual WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
            $nombreemp = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // Ahora valido que el empleado tenga datos en el periodo
            $vsqldatos = "SELECT COUNT(*) AS teridper FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
            $teridper = $clase->SeleccionarUno($vsqldatos);

            if($teridper==0)
            {
                $clase->Aviso(3,"El(la) empleado(a) $nombreemp no posee datos en el periodo $descripcion");
                header("Location: ajustenomina.php?opcion=ventanaajuste");
            }
            else
                header("Location: ajustenomina.php?opcion=ventanareprocesar&terid=$terid&periodoid=$periodoid"); // Redirecciono a la ventana reprocesar
        }            
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ventanareprocesar
    // Creación: 19/02/2021		última modificación: 30/10/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Ventana donde se procesa y visualiza el recalculo de un empleado en un 
    //              periodo
    // Última modificación: Se reorganizaron los datos en la ventana (02/03/2021)
    //                      Se amplió la celda del nombre y se incluyeron los datos sección 
    //                      y cargo del empleado (18/08/2021)
    //                      Inclusión del botón para aditar el devengado y el saldo del 
    //                      empleado (13/12/2021)
    //                      Habilitación del checkbox de días pendientes de acuerdo a la 
    //                      nueva configuración (19/08/2022)
    //                      Se incluyó el parámetro para indicar el formulario predecesor
    //                      (19/01/2023)
    //                      Exclusión de la incapacidad superior a 180 días para sumar los 
    //                      descuentos (11/01/2024)
    //                      Optimización de los botones superiores, encabezado y tamaño de 
    //                      la caja de días
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "ventanareprocesar")
    {
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];

        // Variable para el nombre de empleado
        $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM tercerosactual WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Variable para el nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // días trabajados
        $vsqldatos = "SELECT valor AS diastrab FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid=1";
        $diastrab = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // sueldo
        $vsqldatos = "SELECT devengados AS sueldo FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid=1";
        $sueldo = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // auxilio de transporte
        $vsqldatos = "SELECT devengados AS auxtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid=3";
        $auxtransporte = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // pensión
        $vsqldatos = "SELECT descuentos AS pension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid=4";
        $pension = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // salud
        $vsqldatos = "SELECT descuentos AS salud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid=5";
        $salud = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Salario básico
        $basico = $clase->BDLockup($terid,'tercerosactual','terid','basico');

        // La sección
        $vsqldatos = "SELECT s.descripcionsec 
                        FROM tercerosactual t
                             INNER JOIN seccion s ON (t.seccionid = s.seccionid) 
                       WHERE t.terid = ".$terid;
        $seccion = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // El cargo
        $vsqldatos = "SELECT c.descripcioncargo 
                        FROM tercerosactual t
                             INNER JOIN cargos c ON (t.cargoid = c.cargoid) 
                       WHERE t.terid = ".$terid;
        $cargo = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        $dni = $clase->BDLockup($terid,'tercerosactual','terid','dni');

        // Posible condición de extralegal
        $vsql = "SELECT extralegal FROM tercerosactual WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
        $extralegal = $clase->SeleccionarUno($vsql);
         
        if($extralegal == "CHECKED")
            $condicionextralegal = "(EXTRALEGAL)";
        else
            $condicionextralegal = "";

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/calculando.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Ajuste de liquidaci&oacute;n de n&oacute;mina periodo <br> <font color="BLUE">'.$descripcion.'</font></b> </td>';

        if($_SESSION['USERNAME'] == "LFLOREZ")
            $cont.=' <td width="24"> 
                      <a href="?opcion=editdevsaldo&terid='.$terid.'&periodoid='.$periodoid.'" title="editar devengado y saldo" rel="facebox"> 
                       <img src="images/iconos/configuracion.png" border="0" width="32" height="32">  
                      </a> 
                     </td>';
        else
            $cont.='<td width="24"> &nbsp; </td>';

        $vienede = "ajustenomina";
        $cont.='  <td width="24"> 
                   <a href="?opcion=actincapacidadarl&terid='.$terid.'&periodoid='.$periodoid.'&diastrab='.$diastrab.'" title="recalcular incapacidad ARL" target="_blank"> 
                    <img src="images/iconos/refrescar.png" border="0" width="32" height="32">  
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="24"> 
                   <a href="tercerosactual.php?opcion=editartercero&terid='.$terid.'&periodoid='.$periodoid.'&vienede='.$vienede.'" title="editar tercero actual" target="_blank"> 
                    <img src="images/iconos/aspectos.png" border="0" width="32" height="32">  
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="24"> 
                   <a href="recibodepago.php?opcion=negativo&periodoid='.$periodoid.'&dni='.$dni.'" target="_blank">
                   <img src="images/iconos/pdf.png" title="Recibo" border="0" width="32" height="32"></a>
                  </td> 
                  <td width="10"> &nbsp; </td>
                  <td width="24"> <a href="ajustenomina.php?opcion=ventanaajuste"> <input type="button" value="<<" class="button blue"> </a> </td>
                  <td width="10"> &nbsp; </td>
                 </tr> 
                </table>';                

        $cont.='<form action="?opcion=recalculos" name="y" method="POST">
                <input type="hidden" name="basico" value="'.$basico.'">
                <input type="hidden" name="terid" value="'.$terid.'">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <table width="100%">
                 <tr class="BarraDocumentos" style="height:45px;Important!">  
                  <td width="10">&nbsp;  </td>
                  <td width="37">&nbsp;  </td>
                  <td width="413"><label class="Texto12">Empleado(a):</label> '.$nombreemp.'</td>
                  <td width="227">&nbsp;</td>                  
                  <td width="359">&nbsp;</td>                  
                 </tr>
                 <tr class="BarraDocumentos" style="height:45px;Important!">  
                  <td width="10">&nbsp;  </td>
                  <td width="37">&nbsp;  </td>
                  <td width="413"><label class="Texto12">Secci&oacute;n:</label> '.$seccion.' '.$condicionextralegal.'</td>
                  <td width="227">&nbsp;</td>                  
                  <td width="359">&nbsp;</td>                  
                 </tr>
                 <tr class="BarraDocumentos" style="height:45px;Important!">  
                  <td width="10">&nbsp;  </td>
                  <td width="37">&nbsp;  </td>
                  <td width="413"><label class="Texto12">Cargo:</label> '.$cargo.'</td>
                  <td width="227">&nbsp;</td>                  
                  <td width="359">&nbsp;</td>                  
                 </tr>
                 <tr class="BarraDocumentos" style="height:45px;Important!">  
                  <td width="10">&nbsp;  </td>
                  <td width="37">&nbsp;  </td>
                  <td width="413"><label class="Texto12"> Salario b&aacute;sico:</label> '.number_format($basico).'</td>
                  <td width="227">&nbsp;</td>
                  <td width="359">&nbsp;</td>                  
                 </tr>
                 <tr class="BarraDocumentos" style="height:45px;Important!">  
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="413"><label class="Texto12">D&iacute;as trabajados:</label>
                   <input type="number" name="diastrab" min="0" max="15" style="width:80px;height:25px;" class="height:25px;Texto11New" size="2" autocomplete="off" title="d&iacute;as trabajados" value="'.$diastrab.'">                  
                  </td>
                  <td width="227"><label class="Texto12">Sueldo: </label>'.number_format($sueldo).'</td>                  
                  <td width="359"><label class="Texto12">Transporte:</label> '.number_format($auxtransporte).'</td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:45px;Important!">  
                  <td width="10">&nbsp;  </td>
                  <td width="37">&nbsp;  </td>
                  <td width="413"><label class="Texto12">Pensi&oacute;n:</label> '.number_format($pension).'</td>
                  <td width="227"><label class="Texto12">Salud:</label> '.number_format($salud).'</td>
                  <td width="359">&nbsp;</td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:45px;Important!">  
                  <td width="10">&nbsp; </td>
                  <td width="37">&nbsp; </td>
                  <td width="413">
                   <input type="checkbox" name="pendiente" id="pendiente" value="CHECKED">
                   <label class="Texto12">Incluir d&iacute;as pendiente</label>
                  </td>
                  <td width="227">&nbsp;</td>
                  <td width="359">&nbsp;</td>
                 </tr>
                </table>';        

        $cont.='<table width="100%">
                 <tr class="BarraDocumentos" style="height:45px;Important!">  
                  <center>
                  <td width="657" align="center">                    
                   <input type="submit" value="recalcular" class="button blue">
                   </form>
                  </td>
                  </center>
                 </tr>
                </table>';

        $cont.='<table width="100%">
                 <tr class="BarraDocumentos" style="height:45px;Important!">  
                  <center>
                  <td width="657" align="center"> <b>Otros conceptos</b> </td>
                  </center>
                 </tr>
                </table>';

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="12">&nbsp;  </td>
                   <td width="290"> Concepto </td>
                   <td width="320" align="right"> Devengados </td>			
                   <td width="23" align="right">&nbsp;</td>
                   <td width="320" align="right">Descuentos </td>
                   <td width="60">&nbsp;</td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:150px; overflow-Y:scroll">';        

        // Consulta con los demás conceptos del empleado en el periodo
        $vsql = "SELECT c.nomconcepto, d.devengados, d.descuentos, c.tipodc, d.conceptoid 
                   FROM detallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.pernominaid = ".$periodoid."
                        AND d.terid = ".$terid."
                        AND d.conceptoid NOT IN (1,3,4,5)
               ORDER BY c.tipodc, c.codconcepto";

        // Conexión a la base de datos
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);

        // Inicialización de variables
        $totdevengado = 0;
        $totdescuento = 0;
        $netoapagar = 0;

        // Validación de la ejecución del ciclo        
        if($cant>0)
        {            
            $i = 0;
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
    
                $cont.=' <td width="12">&nbsp;  </td>
                         <td width="290"> '.$row['nomconcepto'].' </td>';

                // Impresión del monto si es un devengado
                if($row['tipodc']=="C")
                {
                    $cont.=' <td width="320" align="right">'.number_format($row['devengados']).' </td>
                             <td width="23" align="right"> &nbsp; </td>
                             <td width="320" align="right"> &nbsp; </td>
                             <td width="60"> &nbsp; </td>
                            </tr>';

                    $totdevengado += $row['devengados'];
                }

                // Impresión del monto si es un descuento
                if($row['tipodc']=="D")
                {
                    $cont.=' <td width="320" align="right"> &nbsp; </td>
                             <td width="23" align="right"> &nbsp; </td>
                             <td width="320" align="right">'.number_format($row['descuentos']).' </td>
                             <td width="60"> &nbsp; </td>
                            </tr>';
                                                                                                  
                    if(($row['conceptoid']!=6)&&($row['conceptoid']!=9)&&($row['conceptoid']!=43)&&($row['conceptoid']!=58))
                        $totdescuento += $row['descuentos'];
                }
            }
        }

        $cont.=' </tbody>
                </table>';            

        // Cálculo de los totales
        $totdevengado += ($sueldo + $auxtransporte);
        $totdescuento += ($pension + $salud);
        $netoapagar = $totdevengado - $totdescuento;

        // Impresión de los totales
        $cont.='<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="261"> &nbsp; </td>
                  <td width="375" align="right"> <font color="WHITE"> <b> Total devengado: </b> '.number_format($totdevengado).' </font> </td>
                  <td width="375" align="right"> <font color="WHITE"> <b> Total descuentos: </b> '.number_format($totdescuento).' </font> </td>
                  <td width="375" align="right"> <font color="WHITE"> <b> Neto a pagar: </b> '.number_format($netoapagar).' </font> </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: editdevsaldo
    // Creación: 13/12/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para editar los cambios del devengado y el saldo del sueldo    
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editdevsaldo")
    {
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];

        // Variable para el nombre de empleado
        $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM tercerosactual WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Variable para el nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // id de detalle
        $vsqldatos = "SELECT detalleid FROM detallenomina WHERE conceptoid = 1 AND pernominaid = ".$periodoid." AND terid = ".$terid;
        $detalleid = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // devengado
        $vsqldatos = "SELECT devengados FROM detallenomina WHERE detalleid = ".$detalleid;
        $devengados = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // saldo
        $vsqldatos = "SELECT saldo FROM detallenomina WHERE detalleid = ".$detalleid;
        $saldo = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Pintamos la ventana        
        $cont.='<table width="400">
                 <tr class="CabezoteTabla">
                  <td align="center"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td align="center"> <b>Edici&oacute;n de devengado y saldo del empleado </b><br><font color="BLUE">'.$nombreemp.'</font> <br> <b>periodo </b><br><font color="BLUE">'.$descripcion.'</font> </td>
                 </tr> 
                </table>                
                <form action="?opcion=guardardevsal" name="y" method="POST">
                <input type="hidden" name="detalleid" value="'.$detalleid.'">
                <input type="hidden" name="terid" value="'.$terid.'">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <table width="400">
                 <tr class="CabezoteTabla">
                  <td align="center"><label class="Texto12">Devengado:</label>
                   <input type="number" name="devengados" min="0" class="Texto11New" size="2" autocomplete="off" title="devengados" value="'.$devengados.'">                  
                  </td>                  
                 </tr>
                 <tr class="CabezoteTabla">
                  <td align="center"><label class="Texto12">Saldo:</label>
                   <input type="number" name="saldo" min="0" class="Texto11New" size="2" autocomplete="off" title="saldo" value="'.$saldo.'">                  
                  </td>
                 </tr>
                </table>
                <table width="400">
                 <tr class="CabezoteTabla">
                  <td align="center">                    
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();                
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardardevsal
    // Creación: 13/12/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena los cambios realizados en el devengado y el saldo 
    //              del sueldo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardardevsal")
    {
        $detalleid = $_POST['detalleid'];
        $devengados = $_POST['devengados'];
        $saldo = $_POST['saldo'];
        $terid = $_POST['terid'];
        $periodoid = $_POST['periodoid'];

        // Almaceno los cambios
        $vsql = "UPDATE detallenomina SET 
                        devengados = ".$devengados.", 
                        saldo = ".$saldo."
                  WHERE detalleid = ".$detalleid."";
        $clase->EjecutarSQL($vsql);

        // Envío el mensaje correspondiente
        if(mysql_affected_rows() < 1)
            $clase->Aviso(3,"No se editaron los datos");
        else
            $clase->Aviso(1,"Datos editados exitosamente");
        
        // Redirecciono el formulario
        header("Location: ajustenomina.php?opcion=ventanareprocesar&periodoid=$periodoid&terid=$terid");                
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: recalculos
    // Creación: 20/02/2021		última modificación: 30/10/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que recalcula los conceptos básicos: auxilio de transporte, 
    //              pensión y salud.
    // Última modificación: Inclusión del proceso para recalcular las libranzas (01/03/2021)
    //                      Se validó que el número de días trabajados no excediera de 15 y 
    //                      se incluyó la no repetición de una misma libranza (02/03/2021)
    //                      Eliminación de las libranzas y descuentos permanentes e 
    //                      inclusión del proceso para inclusión de los descuentos 
    //                      permanentes (25/03/2021)
    //                      Le asigno al aprendiz del SENA el subsidio de transporte en cero
    //                      (06/04/2021)
    //                      Inclusión del cálculo de la pensión y salud cuando estos no 
    //                      existan (15/04/2021)
    //                      Inclusión de los cálculos de transporte y seguridad social con 
    //                      los nuevos campos de la tabla cargos (18/08/2021)
    //                      Validación del cálculo de las libranzas y los descuentos 
    //                      permanentes de acuerdo a la configuración especificada
    //                      (08/08/2022)
    //                      Corrección del cálculo de salud y pensión obteniendo al cargo 
    //                      del empleado cuando no tiene días trabajados
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "recalculos")
    {
        $diastrab = $_POST['diastrab'];
        $basico = $_POST['basico'];
        $terid = $_POST['terid'];
        $periodoid = $_POST['periodoid'];
        $pendiente = $_POST['pendiente'];

        // Validación de la cantidad de días trabajados
        if($diastrab > 15)
        {
            $clase->Aviso(3,"La cantidad de días trabajados no puede ser mayor a 15");
            header("Location: ajustenomina.php?opcion=ventanareprocesar&periodoid=$periodoid&terid=$terid");
        }
        else
        {
            // ------------------------------------------------------------------------------------------------------------------------------------------- //
            if($pendiente=="CHECKED")
            {
                // Determino si tiene alguna licencia pendiente
                $vsql = "SELECT COUNT(*) AS valpendiente 
                           FROM licenciaspendiente 
                          WHERE terid = ".$terid."
                                AND dias > 0";
                $valpendiente = $clase->SeleccionarUno($vsql);

                if($valpendiente>0)
                {
                    // Obtengo el id de la licencia pendiente
                    $vsql = "SELECT pendienteid 
                               FROM licenciaspendiente 
                              WHERE terid = ".$terid."
                                    AND dias > 0";
                    $pendienteid = $clase->SeleccionarUno($vsql);

                    // Extraigo los días que tiene pendiente 
                    $vsql = "SELECT dias AS diaspendiente 
                               FROM licenciaspendiente 
                              WHERE pendienteid = ".$pendienteid;
                    $diaspendiente = $clase->SeleccionarUno($vsql);

                    // Actualizo los días trabajados y pendientes
                    if($diaspendiente<=15)
                    {
                        $diastrab -= $diaspendiente;
                        $auxpendiente = $diaspendiente;
                        $diaspendiente = 0;
                    }
                    else
                    {
                        $diastrab = 0;
                        $diaspendiente -= 15;
                        $auxpendiente = 15;
                    }

                    $vsql = "UPDATE licenciaspendiente SET                                         
                                    dias = ".$diaspendiente."
                              WHERE pendienteid = ".$pendienteid;
                    $clase->EjecutarSQL($vsql);

                    // Recalculo ahora el valor de la licencia

                    // Código de la licencia
                    $vsql = "SELECT conceptoid AS conceptopendienteid 
                               FROM licenciaspendiente 
                              WHERE pendienteid = ".$pendienteid;
                    $conceptopendienteid = $clase->SeleccionarUno($vsql);

                    // Obtengo la formula de la licencia
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptopendienteid;
                    $formulalice = $clase->SeleccionarUno($vsql);

                    $dias = $auxpendiente;

                    if($conceptopendienteid!=10)
                    {
                        eval("\$montolicencia = $formulalice;");
                        $montolicencia = round($montolicencia,0);
                    }
                    else
                    {
                        // Calculo la incapacidad                        

                        // Obtengo el salario mínimo legal vigente
                        $smlv = $_SESSION['N_SALMIN2020'];

                        // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                        if($basico<=$smlv)
                        {
                            $montolicencia = ($smlv*$dias)/30;
                            $montolicencia = round($montolicencia,0);
                        }
                        else
                        {
                            $porcbasico = ($basico*66.67)/100;
                            $porcbasico = round($porcbasico,0);

                            // Calculo la incapacidad si el básico sea mayor al mínimo 
                            if($porcbasico>$smlv)
                            {
                                $montolicencia = ($porcbasico*$dias)/30;
                                $montolicencia = round($montolicencia,0);
                            }
                            else
                            {
                                // $montolicencia = ($smlv*$dias)/30;
                                // $montolicencia = round($montolicencia,0);

                                if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                                if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;

                                $montolicencia = round($montolicencia,0);
                            }
                        }
                    }
                    
                    // Tipo de licencia
                    $tipodc = $clase->BDLockup($conceptopendienteid,'conceptosnomina','conceptoid','tipodc');

                    // Determino el id del registro
                    $vsql = "SELECT detalleid AS detalleid 
                               FROM detallenomina
                              WHERE pernominaid = ".$periodoid."
                                    AND conceptoid = ".$conceptopendienteid."
                                    AND terid = ".$terid."";
                    $detalleid = $clase->SeleccionarUno($vsql);


                    // Actualizo la licencia
                    if($tipodc=="C")
                    {
                        $vsql = "UPDATE detallenomina SET 
                                        devengados = ".$montolicencia.", 
                                        valor = ".$dias."
                                  WHERE detalleid = ".$detalleid."";
                    }
                    else
                    {
                        $vsql = "UPDATE detallenomina SET 
                                        descuentos = ".$montolicencia.", 
                                        valor = ".$dias."
                                  WHERE detalleid = ".$detalleid."";
                    }
                    $clase->EjecutarSQL($vsql);
                }
            }
            
            // ------------------------------------------------------------------------------------------------------------------------------------------- //
            // Obtengo el salario mínimo legal vigente
            $smlv = $_SESSION['N_SALMIN2020'];

            // Obtengo la formula del sueldo
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
            $formulabasico = $clase->SeleccionarUno($vsql);

            // Calculo el sueldo básico
            eval("\$sueldo = $formulabasico;");
            $sueldo = round($sueldo,0);

            // ID  del sueldo
            $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
            $idsueldo = $clase->SeleccionarUno($vsql);

            if($idsueldo!="")
            {
                // Grabo el sueldo y los días trabajados
                $vsql = "UPDATE detallenomina SET 
                                devengados = ".$sueldo.",
                                valor = ".$diastrab."
                          WHERE detalleid = ".$idsueldo."";
                $clase->EjecutarSQL($vsql);
            }
            else
            {
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",1,".$periodoid.",".$sueldo.",0,".$diastrab.",$basico)";
                $clase->EjecutarSQL($vsql);
            }

            if($diastrab > 0)
            {
                // Recalculo el subsidio de transporte
                $valsubtrasp = $smlv * 2;       // Variable para la validación del auxilio de transporte
    
                // Obtengo la formula para el subsidio de transporte
                $auxtrans = $_SESSION['N_AUXTRANS2020'];
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                $formulatransporte = $clase->SeleccionarUno($vsql);
    
                // ------------------------------------------------------------------------------------------------------------------------------------ //
                $cargoid = $clase->BDLockup($terid,'tercerosactual','terid','cargoid');                       // Obtengo el cargo del empleado
                $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte
    
                if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                {            
                    // Calculo el subsidio de transporte
                    eval("\$subsidiotransporte = $formulatransporte;");
                    $subsidiotransporte = round($subsidiotransporte,0);
                }
                else
                    $subsidiotransporte = 0;
            }
            else
                $subsidiotransporte = 0;

            // ------------------------------------------------------------------------------------------------------------------------------------ //
            // ID transporte
            $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
            $idtransporte = $clase->SeleccionarUno($vsql);

            if($idtransporte!="")
            {
                // Grabo el subsidio de transporte
                $vsql = "UPDATE detallenomina SET 
                                devengados = ".$subsidiotransporte.",
                                valor = ".$diastrab."
                          WHERE detalleid = ".$idtransporte."";
                $clase->EjecutarSQL($vsql);
            }
            else
            {
                // Obtengo el valor del subsidio de transporte
                $valsubtransporte = $_SESSION['N_AUXTRANS2020'];

                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                $clase->EjecutarSQL($vsql);
            }

            // Determino si el empleado es de condición extralegal
            $extralegal = $clase->BDLockup($terid,'tercerosactual','terid','extralegal');
            $epsid = $clase->BDLockup($terid,'tercerosactual','terid','epsid');
            $pensionesid = $clase->BDLockup($terid,'tercerosactual','terid','pensionesid');
            
            if($epsid==NULL)                $epsid=0;
            if($pensionesid==NULL)          $pensionesid=0;

            $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                       FROM detallenomina d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
            $totnovedades = $clase->SeleccionarUno($vsql);

            $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                       FROM detallenomina d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid."                            
                            AND (c.recargo = 'CHECKED' AND c.tipodc = 'C')";
            $totrecargos = $clase->SeleccionarUno($vsql);
            
            $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

            // ---------------------------------------------------------------------------------------------------------------------------------------------------- //
            $cargoid = $clase->BDLockup($terid,'tercerosactual','terid','cargoid');                       // Obtengo el cargo del empleado
            $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');   // Obtengo el control del cálculo de pensión
            $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');   // Obtengo el control del cálculo de salud            

            if($extralegal=="CHECKED")
            {
                $pension = 0;
                $salud = 0;
            }
            else
            {
                // Recalculo pensión y salud
                if(($pensionesid==5)||($aplicapension!="CHECKED"))
                    $pension = 0;
                else
                {
                    // Obtengo la formula para el descuento por pensión
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                    $formulapension = $clase->SeleccionarUno($vsql);

                    // Calculo la pensión
                    eval("\$pension = $formulapension;");
                    $pension = round($pension,0);
                }
                
                if(($epsid==37)||($aplicasalud!="CHECKED"))
                    $salud = 0;
                else
                {   
                    // Obtengo la formula para el descuento de salud
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                    $formulasalud = $clase->SeleccionarUno($vsql);
                    
                    // Calculo la salud
                    eval("\$salud = $formulasalud;");
                    $salud = round($salud,0);
                }                    
            }
            // ---------------------------------------------------------------------------------------------------------------------------------------------------- //

            //  ID pensión
            $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
            $idpension = $clase->SeleccionarUno($vsql);

            if($idpension!="")            
                // Grabo la pensión
                $vsql = "UPDATE detallenomina SET 
                                descuentos = ".$pension.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idpension."";
            else
            {
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
            }

            $clase->EjecutarSQL($vsql);

            // ID salud
            $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
            $idsalud = $clase->SeleccionarUno($vsql);

            if($idsalud!="")
                // Grabo la salud
                $vsql = "UPDATE detallenomina SET 
                                descuentos = ".$salud.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idsalud."";
            else
            {
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
            }

            $clase->EjecutarSQL($vsql);

            // --------------------------------------------------------------------------------------------------------------------------------------------------- //
            // valido el cálculo de libranzas y descuentos permanentes
            $cal_libranza = $_SESSION['G_CAL_LIBRANZA'];
            if($cal_libranza=="CHECKED")
            {
                // ---------------------------------------------------------------------------------------------------------------------------------------------- //
                // Elimino las libranzas y los descuentos permanentes para volverlos a ingresar
                $vsql8 = "SELECT d.detalleid  
                            FROM detallenomina d
                                 INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)     
                           WHERE d.terid = ".$terid." 
                                 AND d.pernominaid = ".$periodoid."  
                                 AND (c.eslibranza = 'CHECKED' OR c.montopermanente='CHECKED')";

                $conex   = $clase->Conectar();
                $result8 = mysql_query($vsql8,$conex);
                $cant8   = mysql_num_rows($result8);
                if($cant8>0)
                {
                    while($row8 = mysql_fetch_array($result8))
                    {
                        $detalleelim = $row8['detalleid'];
                        $vsql = "DELETE FROM detallenomina WHERE detalleid = ".$detalleelim;
                        $clase->EjecutarSQL($vsql);
                    }
                }

                // ---------------------------------------------------------------------------------------------------------------------------------------------- //
                // Nuevo proceso para las libranzas utilizando la nueva tabla “libranzas”
                $vsql2 = "SELECT conceptoid, monto, tipoquincena
                            FROM libranzas 
                           WHERE terid = ".$terid."
                                 AND (cuotaspagadas < totalcuotas)";
    
                $conex  = $clase->Conectar();
                $result2 = mysql_query($vsql2,$conex);
                $cant   = mysql_num_rows($result2);
                if($cant>0)
                {
                    while($row2 = mysql_fetch_array($result2))
                    {
                        // Calculo el nuevo ID
                        $vsql3 = "SELECT max(detalleid) FROM detallenomina";
                        $numid = $clase->SeleccionarUno($vsql3);
                        $numid++;
    
                        // Obtengo el monto a descontar por concepto de esta libranza
                        $monto = $row2['monto'];
                        $conceptoid = $row2['conceptoid'];
                        $tipoquincena = $row2['tipoquincena'];
    
                        // Verifico si el concepto ya está incluido para este empleado
                        $vsql5 = "SELECT COUNT(detalleid) AS repetido FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = ".$conceptoid."";
                        $repetido = $clase->SeleccionarUno($vsql5);
    
                        if($repetido==0)
                        {
                            // Valido si la libranza se puede descontar en esta quincena
                            if($tipoquincena=="ambas")
                            {
                                // Almaceno el nuevo concepto por libranza
                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                $clase->EjecutarSQL($vsql);
                            }
                            else
                            {
                                $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                                $diadesde = substr($fecdesde, -2);
        
                                if(($tipoquincena=="primera")&&($diadesde=="01"))
                                {
                                    // Almaceno el nuevo concepto por libranza
                                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                    $clase->EjecutarSQL($vsql);
                                }
        
                                if(($tipoquincena=="segunda")&&($diadesde=="16"))
                                {
                                    // Almaceno el nuevo concepto por libranza
                                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                    $clase->EjecutarSQL($vsql);
                                }
                            }
                        }
                    }
                }
            }

            // ---------------------------------------------------------------------------------------------------------------------------------------------- //
            // Verifico si tiene conceptos permanentes
            $cal_permanente = $_SESSION['G_CAL_PERMANENTE'];
            if($cal_permanente=="CHECKED")
            {
                $vsql6 = "SELECT conceptoid, monto, tipoquincena 
                            FROM descuentospermanente 
                           WHERE terid = ".$terid."";
    
                $conex  = $clase->Conectar();
                $result6 = mysql_query($vsql6,$conex);
                $cant   = mysql_num_rows($result6);
                if($cant>0)
                {
                    while($row6 = mysql_fetch_array($result6))
                    {
                        // Calculo el nuevo ID
                        $vsql7 = "SELECT max(detalleid) FROM detallenomina";
                        $numid = $clase->SeleccionarUno($vsql7);
                        $numid++;
    
                        // Obtengo el monto a descontar por concepto de este concepto
                        $monto = $row6['monto'];
                        $conceptoid = $row6['conceptoid'];
                        $tipoquincena = $row6['tipoquincena'];
    
                        // Valido si el concepto se puede descontar en esta quincena
                        if($tipoquincena=="ambas")
                        {
                            // Almaceno el nuevo concepto permanente
                            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                        VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                            $clase->EjecutarSQL($vsql);
                        }
                        else
                        {
                            $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                            $diadesde = substr($fecdesde, -2);
    
                            if(($tipoquincena=="primera")&&($diadesde=="01"))
                            {
                                // Almaceno el nuevo concepto permanente
                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                $clase->EjecutarSQL($vsql);
                            }
    
                            if(($tipoquincena=="segunda")&&($diadesde=="16"))
                            {
                                // Almaceno el nuevo concepto permanente
                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                $clase->EjecutarSQL($vsql);
                            }
                        }
                    }
                }
            }
            // ---------------------------------------------------------------------------------------------------------------------------------------------- //

            // Aquí depuro los conceptos que estén en cero
            $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid." AND terid =".$terid."";
            $clase->EjecutarSQL($vsql);

            // Redirecciono a la ventana de ajustes
            $clase->Aviso(2,"Proceso de recalculo culminado satisfactoriamente");
            header("Location: ajustenomina.php?opcion=ventanareprocesar&periodoid=$periodoid&terid=$terid");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ventanaajuste
    // Creación: 18/02/2021		última modificación: 28/08/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana principal de ajustes de cálculo de empleados
    // Última modificación: Se modificó para que solo ajustara el periodo actual (24/05/2021)
    //                      Inclusión del botón de terceros (07/07/2021)
    //                      Se incorporó el campo de empleado activo en la nómina 
    //                      (11/08/2021)
    //                      Validación de la activación del botón de aceptar (03/11/2022)
    //                      Optimización de la ventana 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaajuste")
    {
        // combo de empleados en el periodo
		$vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                           FROM tercerosactual 
                          WHERE esempleadoactivo = 'CHECKED' 
                                AND basico > 0
                                AND (primernombre <> '' AND primerapellido <> '')
                       ORDER BY primernombre";

        // Periodo para ajustar
        $vsql = "SELECT periodoid
                   FROM periodosnomina 
                  WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
        $periodoid = $clase->SeleccionarUno($vsql);

        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Valido que el periodo tenga empleados para ser editados
        $vsql2 = "SELECT COUNT(*) AS numregactual FROM tercerosactual WHERE pernominaid = ".$periodoid;
        $numregactual = $clase->SeleccionarUno($vsql2);
        
        if($numregactual > 0)
            $disabled = '';
        else
            $disabled = 'disabled';
        
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/calculando.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Ajuste de liquidaci&oacute;n de n&oacute;mina del periodo <font color="blue"> '.$descripcion.' </font></b> </td>
                  <td width="20"> 
                   <a href="terceros.php" target="blank">
                    <img src="images/iconos/terceros.png" border="0" width="38" height="38">
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<table width="100%">
                 <tr class="BarraDocumentos"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <form action="?opcion=valopcion" method="POST" name="x">
                  <input type="hidden" name="periodoid" value="'.$periodoid.'">
                  <td width="900"> <label class="Texto12"> Empleado: </label>
                   '.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","S",$params,420).'
                  </td>
                 </tr>
                </table>';

        $cont.='<table width="100%">
                 <tr class="BarraDocumentos">
                  <td align="center">
                   <br>
                   <input type="submit" value="aceptar" class="button blue" '.$disabled.'>
                   </form>
                  </td>
                 </tr>
                </table>';

        // Pie de página
        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: actincapacidadarl
    // Creación: 18/08/2022		última modificación: 20/10/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que corrige el cálculo de una incapacidad por arl
    // Última modificación: Validación de la existencia de incapacidad en el periodo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "actincapacidadarl")
    {
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];
        $diastrab = $_GET['diastrab'];

        $detalleid = 0;            $dias = 0;                      $smlv = 0;
        $basico = 0;               $montolicencia = 0;             $dias = $diastrab;

        // Determino si el empleado tiene una incapacidad para ser recalculada
        $vsql = "SELECT detalleid
                   FROM detallenomina 
                  WHERE conceptoid = 10  
                        AND pernominaid = ".$periodoid."
                        AND terid = ".$terid."";
        $detalleid = $clase->SeleccionarUno($vsql);

        if(strlen($detalleid) == 0)
        {
            $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM tercerosactual WHERE terid = ".$terid;
            $nombreemp = $clase->SeleccionarUno($vsql);

            $clase->Aviso(3,"$nombreemp no tiene incapacidades en este periodo");
        }
        else
        {
            // Obtengo los días de incapacidad
            $vsql2 = "SELECT valor AS dias
                        FROM detallenomina 
                       WHERE detalleid = ".$detalleid;
            $dias = $clase->SeleccionarUno($vsql2);
    
            // Obtengo el salario mínimo legal vigente
            $smlv = $_SESSION['N_SALMIN2020'];
    
            // Obtengo el salario básico del empleado
            $basico = $clase->BDLockup($terid,'tercerosactual','terid','basico');
    
            if($basico>=$smlv)
            {
                $montolicencia = ($basico*$dias)/30;
                $montolicencia = round($montolicencia,0);
            }
    
            // Almaceno la modificación
            $vsql = "UPDATE detallenomina SET 
                            devengados = ".$montolicencia."
                      WHERE detalleid = ".$detalleid;
            $clase->EjecutarSQL($vsql);
    
            // Procedo a recalcular pensión y salud
    
            // Obtengo la formula del sueldo
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
            $formulabasico = $clase->SeleccionarUno($vsql);
    
            // Calculo el sueldo básico
            eval("\$sueldo = $formulabasico;");
            $sueldo = round($sueldo,0);
    
            // Determino si el empleado es de condición extralegal
            $extralegal = $clase->BDLockup($terid,'tercerosactual','terid','extralegal');
            $epsid = $clase->BDLockup($terid,'tercerosactual','terid','epsid');
            $pensionesid = $clase->BDLockup($terid,'tercerosactual','terid','pensionesid');
            $cargoid = $clase->BDLockup($terid,'tercerosactual','terid','cargoid');                       // Obtengo el cargo del empleado
            
            if($epsid==NULL)                $epsid=0;
            if($pensionesid==NULL)          $pensionesid=0;
    
            // Consulta para el total de devengados
            $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                       FROM detallenomina d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
            $totnovedades = $clase->SeleccionarUno($vsql);

            $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                       FROM detallenomina d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
            $totrecargos = $clase->SeleccionarUno($vsql);

            $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;
    
            $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');             // Obtengo el control del cálculo de pensión
            $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');                 // Obtengo el control del cálculo de salud
            
            if($extralegal=="CHECKED")
            {
                $pension = 0;
                $salud = 0;
            }
            else
            {
                // Recalculo pensión y salud
                if(($pensionesid==5)||($aplicapension!="CHECKED"))
                    $pension = 0;
                else
                {
                    // Obtengo la formula para el descuento por pensión
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                    $formulapension = $clase->SeleccionarUno($vsql);
    
                    // Calculo la pensión
                    eval("\$pension = $formulapension;");
                    $pension = round($pension,0);
                }
    
                if(($epsid==37)||($aplicasalud!="CHECKED"))
                    $salud = 0;
                else
                {
                    // Obtengo la formula para el descuento de salud
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                    $formulasalud = $clase->SeleccionarUno($vsql);
                    
                    // Calculo la salud
                    eval("\$salud = $formulasalud;");
                    $salud = round($salud,0);
                }
            }
            // ---------------------------------------------------------------------------------------------------------------------------------------------------- //
            //  ID pensión
            $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
            $idpension = $clase->SeleccionarUno($vsql);
    
            // Grabo la pensión
            if($idpension!="")            
                $vsql = "UPDATE detallenomina SET 
                                descuentos = ".$pension.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idpension."";
            else
            {
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);
    
                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
            }    
            $clase->EjecutarSQL($vsql);
    
            // ID salud
            $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
            $idsalud = $clase->SeleccionarUno($vsql);
    
            // Grabo la salud
            if($idsalud!="")
                $vsql = "UPDATE detallenomina SET 
                                descuentos = ".$salud.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idsalud."";
            else
            {
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);
    
                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
            }    
            $clase->EjecutarSQL($vsql);
    
            // Aquí depuro los conceptos que estén en cero
            $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid." AND terid =".$terid."";
            $clase->EjecutarSQL($vsql);
        }

        // Redirecciono a la ventana reprocesar
        header("Location: ajustenomina.php?opcion=ventanareprocesar&terid=$terid&periodoid=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: prerecalcularperiodo
    // Creación: 23/09/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana que le indica al usuario que se está 
    //              recalculando la nómina
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "prerecalcularperiodo")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
     
        $cont = $clase->Header("S","W");
        $cont.='<form name="x" method="POST" action="ajustenomina.php?opcion=recalcularperiodo&periodoid='.$periodoid.'">
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/infventaspos.png" width="32" height="32" border="0"> </td>
                  <td width="707"> <b> Recalculando  n&oacute;mina </b> </td>
                  <td width="183" align="right"> Por favor espere ... </td>                     
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>
                <br>
                <center>
                <h3> Recalculando el periodo <font color="BLUE">'.$descripcion.'</font> </h3><br>
                Por favor no interrumpa el proceso mientras se realizan <br>todos los rec&aacute;lculos b&aacute;sicos de los empleados<br><br><br>
                <img src="images/basicas/cargando.gif" border="0">
                <script language="Javascript">
                 function redireccionar() {  
                  setTimeout("location.href=\'ajustenomina.php?opcion=recalcularperiodo&periodoid='.$periodoid.'\'", 3000);
                 }
                 redireccionar();
                </script>
                <br><br><br>                   
                <!-- Contador de tiempo -->
                <div style="margin: 0px auto; text-align: center; width: 250px;">
                 <img src="images/basicas/1.gif" border="0">
                 <img src="images/basicas/2.gif" border="0">
                 <img src="images/basicas/3.gif" border="0">
                 <img src="images/basicas/4.gif" border="0">
                 <img src="images/basicas/5.gif" border="0">
                </div>
                </form>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: recalcularperiodo
    // Creación: 23/09/2022		última modificación: 08/04/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para recalcular sueldo, transporte, pensión y salud en caso de 
    //              ser necesaria más de un cálculo de nómina
    // Última modificación: Validación de los días trabajados para el cálculo del subsidio 
    //                      de transporte
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "recalcularperiodo")
    {
        $periodoid = $_GET['periodoid'];

        $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
        $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');       

        // consulta de los empleados del periodo
        $vsql = "SELECT terid, extralegal, cargoid, pensionesid, basico, epsid, fecharetiro, fecingreso 
                   FROM tercerosactual
                  WHERE pernominaid = ".$periodoid;

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);

        // valido que la tabla de terceros actual tenga datos
        if($cant == 0)
        {
            $registrosper = $clase->SeleccionarUno("SELECT COUNT(*) AS registrosper FROM detallenomina WHERE pernominaid = ".$periodoid." AND conceptoid IN (1,3,4,5)");           

            if($registrosper > 0)
            {
                // actualización de datos en la tabla tercerosactual
                $vsqlaux = "INSERT INTO tercerosactual (pernominaid, terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid, 
                                                        cargoid, bancoid, numcuenta, fecingreso, fecharetiro, basico, codvende, tipodoc, dni, primernombre, 
                                                        segundonombre, primerapellido, segundoapellido, idcajacomp, epsid, pensionesid)
                            SELECT ".$periodoid.", terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid,
                                   cargoid, bancoid, numcuenta, fecingreso, fecharetiro, basico, codvende, tipodoc, 
                                   dni, primernombre, segundonombre, primerapellido, segundoapellido,
                                   idcajacomp, epsid, pensionesid
                              FROM terceros 		     
                             WHERE esempleadoactivo = 'CHECKED'
                                   AND basico > 0
                                   AND fecingreso <= '".$fechasta."'
                             UNION ALL
                            SELECT ".$periodoid.", terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid,
                                   cargoid, bancoid, numcuenta, fecingreso, fecharetiro, basico, codvende, tipodoc, 
                                   dni, primernombre, segundonombre, primerapellido, segundoapellido,
                                   idcajacomp, epsid, pensionesid
                              FROM terceros 		     
                             WHERE fecharetiro BETWEEN '".$fecdesde."' AND '".$fechasta."'
                                   AND basico > 0
                                   AND extralegal = 'CHECKED'
                          ORDER BY 1";
                $clase->EjecutarSQL($vsqlaux);

                // actualización del campo calculado
                $clase->EjecutarSQL("UPDATE periodosnomina SET calculado = 'CHECKED' WHERE periodoid = ".$periodoid."");

                // nueva consulta para el recalculo
                $vsql = "SELECT terid, extralegal, cargoid, pensionesid, basico, epsid, fecharetiro, fecingreso 
                           FROM tercerosactual
                          WHERE pernominaid = ".$periodoid;                       
    
                $conex  = $clase->Conectar();
                $result = mysql_query($vsql,$conex);
            }
        }

        while($row = mysql_fetch_array($result))
        {
            // Inicialización de variables
            $terid = $row['terid'];
            $fecretiro = $row['fecharetiro'];
            $fecingreso = $row['fecingreso'];

            $diastrab = 15;
            
            // ------------------------------------------------------- //
            // Cálculo los días trabajados en caso de que el empleado 
            // haya ingresado durante este periodo
            if(($fecingreso>=$fecdesde)&&($fecingreso<=$fechasta))
            {
                // Procedo a calcular los días que trabajó durante el periodo
                $fecha1= new DateTime($fecingreso);
                $fecha2= new DateTime($fechasta);
                $diff = $fecha1->diff($fecha2);
                
                $difendias = $diff->days;
                $diastrab = $difendias + 1;

                $diadesde = substr($fecdesde, -2);
                if($diadesde=="16")
                {
                    $fechaEntera = strtotime($fechasta);
                    $valdias = date("d", $fechaEntera);
                    if($valdias=="28")          $diastrab += 2;
                    if($valdias=="29")          $diastrab += 1;
                    if($valdias=="31")          $diastrab -= 1;
                }
            }

            // ------------------------------------------------------------------------------------ //
            // Valido si la fecha de retiro está dentro del rango de periodo
            if(($fecretiro>=$fecdesde)&&($fecretiro<=$fechasta))
            {
                // Procedo a calcular los días que trabajó durante el periodo
                $fecha1= new DateTime($fecdesde);
                $fecha2= new DateTime($fecretiro);
                $diff = $fecha1->diff($fecha2);
                
                $difendias = $diff->days;
                $diastrab = $difendias + 1;
            }

            // ------------------------------------------------------------------------------------ //
            // valido si el empleado tiene fecha de ingreso y retiro dentro del periodo
            if((($fecingreso>=$fecdesde)&&($fecingreso<=$fechasta)) && (($fecretiro>=$fecdesde)&&($fecretiro<=$fechasta)))
            {
                // Procedo a calcular los días que trabajó durante el periodo
                $fecha1= new DateTime($fecingreso);
                $fecha2= new DateTime($fecretiro);
                $diff = $fecha1->diff($fecha2);
                
                $difendias = $diff->days;
                $diastrab = $difendias + 1;
            }

            // ---------------------------------------------------------------------------- //
            $vsql9 = "SELECT IFNULL(SUM(valor),0) diasnovedades 
                        FROM detallenomina d
                             INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                       WHERE d.terid = ".$terid."
                             AND d.pernominaid = ".$periodoid." 
                             AND c.eslicencia = 'CHECKED'";
            $diasnovedades = $clase->SeleccionarUno($vsql9);

            $diastrab -= $diasnovedades;
            // ---------------------------------------------------------------------------- //

            if($diastrab > 0)
            {
                $basico = $row['basico'];

                // Obtengo la formula del sueldo
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                $formulabasico = $clase->SeleccionarUno($vsql);
    
                // Calculo el sueldo básico
                eval("\$sueldo = $formulabasico;");
                $sueldo = round($sueldo,0);
    
                // ID  del sueldo
                $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
                $idsueldo = $clase->SeleccionarUno($vsql);
    
                // Grabo el sueldo y los días trabajados
                if($idsueldo!="")
                    $vsql = "UPDATE detallenomina SET 
                                    devengados = ".$sueldo.",
                                    valor = ".$diastrab."
                              WHERE detalleid = ".$idsueldo."";
                else
                {
                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                    $numreg = $clase->SeleccionarUno($vsql);
    
                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",1,".$periodoid.",".$sueldo.",0,".$diastrab.",$basico)";
                }
                $clase->EjecutarSQL($vsql);
    
                // Recalculo el subsidio de transporte
                $smlv = $_SESSION['N_SALMIN2020'];
                $valsubtrasp = $smlv * 2;                   // Variable para la validación del auxilio de transporte
    
                // Obtengo la formula para el subsidio de transporte
                $auxtrans = $_SESSION['N_AUXTRANS2020'];
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                $formulatransporte = $clase->SeleccionarUno($vsql);
    
                $cargoid = $row['cargoid'];                                                                     // Obtengo el cargo del empleado
                $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');           // Obtengo el control del cálculo de subsidio de transporte
    
                if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                {
                    // Calculo el subsidio de transporte
                    eval("\$subsidiotransporte = $formulatransporte;");
                    $subsidiotransporte = round($subsidiotransporte,0);
                }
                else
                    $subsidiotransporte = 0;
    
                // ID transporte
                $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                $idtransporte = $clase->SeleccionarUno($vsql);
    
                // Grabo el subsidio de transporte
                if($idtransporte!="")
                    $vsql = "UPDATE detallenomina SET 
                                    devengados = ".$subsidiotransporte.",
                                    valor = ".$diastrab."
                              WHERE detalleid = ".$idtransporte;
                else
                {
                    // Obtengo el valor del subsidio de transporte
                    $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
    
                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                    $numreg = $clase->SeleccionarUno($vsql);
    
                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                }
                $clase->EjecutarSQL($vsql);
            }
            else
            {
                $subsidiotransporte = 0;

                // ID transporte
                $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                $idtransporte = $clase->SeleccionarUno($vsql);

                // Grabo el subsidio de transporte
                if($idtransporte!="")
                {
                    $vsql = "UPDATE detallenomina SET 
                                    devengados = ".$subsidiotransporte.",
                                    valor = ".$diastrab."
                              WHERE detalleid = ".$idtransporte;
                    $clase->EjecutarSQL($vsql);
                }

                // elimino el subsidio de transporte
                $vsql = "DELETE FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                $clase->EjecutarSQL($vsql);

                $sueldo = 0;
            }

            // ----------------------------------------------------------------------------------------------------------------------------------------------------- //
            // Recalculo las incapacidades en caso de existir
            $detalleid = $clase->SeleccionarUno("SELECT detalleid FROM detallenomina WHERE conceptoid = 10 AND pernominaid = ".$periodoid." AND terid = ".$terid."");

            if(strlen($detalleid) > 0)
            {
                $dias = $clase->SeleccionarUno("SELECT valor AS dias FROM detallenomina WHERE detalleid = ".$detalleid."");
                $montoant = $clase->SeleccionarUno("SELECT valor AS montoant FROM detallenomina WHERE detalleid = ".$detalleid."");
                $montoant = round($montoant,0);

                // Obtengo el salario básico del empleado
                $basico = $row['basico'];

                // Obtengo el salario mínimo legal vigente
                $smlv = $_SESSION['N_SALMIN2020'];

                if($basico>=$smlv)
                {
                    $montolicencia = ($basico*$dias)/30;
                    $montolicencia = round($montolicencia,0);

                    // Almaceno la modificación
                    if($montolicencia != $montoant)
                        $clase->EjecutarSQL("UPDATE detallenomina SET devengados = ".$montolicencia." WHERE detalleid = ".$detalleid."");
                }
            }
            // ----------------------------------------------------------------------------------------------------------------------------------------------------- //

            // Determino si el empleado es de condición extralegal
            $extralegal = $row['extralegal'];
            $epsid = $row['epsid'];
            $pensionesid = $row['pensionesid'];
            
            if($epsid==NULL)                $epsid = 0;
            if($pensionesid==NULL)          $pensionesid = 0;

            $totnovedades = 0;
            $sueldodeducciones = 0;

            $vsql69 = "SELECT IFNULL(SUM(d.devengados),0) AS totnovedades 
                         FROM detallenomina d
                              INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                        WHERE d.terid = ".$terid."
                              AND d.pernominaid = ".$periodoid." 
                              AND (c.eslicencia = 'CHECKED' AND c.tipodc = 'C')";
            $totnovedades = $clase->SeleccionarUno($vsql69);

            $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                       FROM detallenomina d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
            $totrecargos = $clase->SeleccionarUno($vsql);

            $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;
            
            $cargoid = $row['cargoid'];                                                             // Obtengo el cargo del empleado
            $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');         // Obtengo el control del cálculo de pensión
            $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');             // Obtengo el control del cálculo de salud

            if($extralegal=="CHECKED")
            {
                $pension = 0;
                $salud = 0;
            }
            else
            {
                // Recalculo pensión y salud
                if(($pensionesid==5)||($aplicapension!="CHECKED"))
                    $pension = 0;
                else
                {
                    // Obtengo la formula para el descuento por pensión
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                    $formulapension = $clase->SeleccionarUno($vsql);

                    // Calculo la pensión
                    eval("\$pension = $formulapension;");
                    $pension = round($pension,0);
                }

                if(($epsid==37)||($aplicasalud!="CHECKED"))
                    $salud = 0;
                else
                {
                    // Obtengo la formula para el descuento de salud
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                    $formulasalud = $clase->SeleccionarUno($vsql);
                    
                    // Calculo la salud
                    eval("\$salud = $formulasalud;");
                    $salud = round($salud,0);
                }
            }

            //  ID pensión
            $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
            $idpension = $clase->SeleccionarUno($vsql);

            // Grabo la pensión
            if($idpension!="")
                $vsql = "UPDATE detallenomina SET 
                                descuentos = ".$pension.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idpension;
            else
            {
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
            }
            $clase->EjecutarSQL($vsql);

            // ID salud
            $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
            $idsalud = $clase->SeleccionarUno($vsql);

            // Grabo la salud
            if($idsalud!="")
                $vsql = "UPDATE detallenomina SET 
                                descuentos = ".$salud.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idsalud;
            else
            {
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
            }
            $clase->EjecutarSQL($vsql);

            // Aquí depuro los conceptos que estén en cero
            $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid." AND terid =".$terid."";
            $clase->EjecutarSQL($vsql);
        }

        // Redirecciono a la ventana de ajustes
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $clase->Aviso(2,"Proceso de recalculo del periodo <b>$descripcion</b> ha culminado satisfactoriamente");
        header("Location: periodosnomina.php");
    }
    ////////////////////////////////
    echo $cont.$clase->PiePagina();
?>