<?php
class Ciudad {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function getAll() {
        $stmt = $this->pdo->query("SELECT * FROM ciudades");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getById($id) {
        $stmt = $this->pdo->prepare("SELECT * FROM ciudades WHERE ciudadid = :id");
        $stmt->execute(['id' => $id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function create($data) {
        $stmt = $this->pdo->prepare("INSERT INTO ciudades (codigo, nombre, departamento, esciudadprincipal, ordentiendavirtual, creador) VALUES (:codigo, :nombre, :departamento, :esciudadprincipal, :ordentiendavirtual, :creador)");
        return $stmt->execute($data);
    }

    public function update($id, $data) {
        $data['id'] = $id;
        $stmt = $this->pdo->prepare("UPDATE ciudades SET codigo = :codigo, nombre = :nombre, departamento = :departamento, esciudadprincipal = :esciudadprincipal, ordentiendavirtual = :ordentiendavirtual, creador = :creador WHERE ciudadid = :id");
        return $stmt->execute($data);
    }

    public function delete($id) {
        $stmt = $this->pdo->prepare("DELETE FROM ciudades WHERE ciudadid = :id");
        return $stmt->execute(['id' => $id]);
    }
}
?>