<?php
header('Content-Type: application/json');
require 'config.php';
require 'GrupoProd.php';

$grupoProd = new GrupoProd($pdo);

$request_method = $_SERVER['REQUEST_METHOD'];
$request_uri = explode('/', trim($_SERVER['REQUEST_URI'], '/'));

switch ($request_method) {
    case 'GET':
        if (isset($request_uri[1])) {
            // Obtener grupo por ID
            $id = intval($request_uri[1]);
            $result = $grupoProd->getById($id);
            echo json_encode($result);
        } else {
            // Obtener todos los grupos
            $result = $grupoProd->getAll();
            echo json_encode($result);
        }
        break;

    case 'POST':
        // Crear nuevo grupo
        $data = json_decode(file_get_contents("php://input"), true);
        $grupoProd->create($data );
        echo json_encode(['message' => 'Grupo creado']);
        break;

    case 'PUT':
        // Actualizar grupo
        $id = intval($request_uri[1]);
        $data = json_decode(file_get_contents("php://input"), true);
        $grupoProd->update($id, $data);
        echo json_encode(['message' => 'Grupo actualizado']);
        break;

    case 'DELETE':
        // Eliminar grupo
        $id = intval($request_uri[1]);
        $grupoProd->delete($id);
        echo json_encode(['message' => 'Grupo eliminado']);
        break;

    default:
        echo json_encode(['message' => 'Método no permitido']);
        break;
}
?>