<?php
require('../../config/functions.php');

$host     = '';
$dbname   = '';
$user     = '';
$password = '';
	
// Configuración de CORS
header('Access-Control-Allow-Origin: *'); // Permite conexiones desde cualquier origen
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Database credentials
loadconectionparams($host,$dbname,$user,$password);		
$pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

if(!APIisactiva($pdo)) 
{ 
  http_response_code(401); // Unauthorized
  echo json_encode(['message' => 'API se encuentra Inactiva en este momento']);	
  exit;
} 

// API Endpoints
if (authenticate()) { // Check authentication before processing requests
    try {        

        // Get Request Method
        $method = $_SERVER['REQUEST_METHOD'];

        switch ($method) {
            case 'GET': // Read (all or single)
                if (isset($_GET['id'])) 
                {
                    $id = $_GET['id'];
                    $stmt = $pdo->prepare('SELECT * FROM motivoexpediente WHERE idmotivo = :id');
                    $stmt->execute(['id' => $id]);
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                } 
                else 
                {
                    $vsql = "SELECT C.cuadroid , C.* , VAC.* , T.* ,  CVA.nombrecargo , BC.descripcion banco , CI.nombre ciudad, CI.departamento , 
                                    T.codvende, CONCAT(T.primernombre,' ',T.segundonombre,' ',T.primerapellido,' ',T.segundoapellido) nombres, T.dni, T.genero, T.fecnaci, CA.descripcioncargo , BC.descripcion banco, 
                                    T.direccion, T.telmovil, T.email, T.basico, B.codbanco,  E.descripcioneps eps, P.descripcionafp pensiones , CS.descripcion cesantias, CP.nombrecaja,  
                                    DATEDIFF(NOW(),T.fecingreso) diasdesdeingres, (DATEDIFF(NOW(),T.fecnaci) / 360) edad, DATEDIFF(NOW(),T.ingresoemp) diastotales, C.sucursalid , SE.descripcionsec seccion,           
                                    CASE
                                        WHEN MONTH(T.fecnaci) = 1 THEN 'ENERO'
                                        WHEN MONTH(T.fecnaci) = 2 THEN 'FEBRERO'
                                        WHEN MONTH(T.fecnaci) = 3 THEN 'MARZO'           
                                        WHEN MONTH(T.fecnaci) = 4 THEN 'ABRIL' 
                                        WHEN MONTH(T.fecnaci) = 5 THEN 'MAYO'
                                        WHEN MONTH(T.fecnaci) = 6 THEN 'JUNIO'         
                                        WHEN MONTH(T.fecnaci) = 7 THEN 'JULIO'
                                        WHEN MONTH(T.fecnaci) = 8 THEN 'AGOSTO'
                                        WHEN MONTH(T.fecnaci) = 9 THEN 'SEPTIEMBRE'
                                        WHEN MONTH(T.fecnaci) = 10 THEN 'OCTUBRE'
                                        WHEN MONTH(T.fecnaci) = 11 THEN 'NOVIEMBRE'
                                        WHEN MONTH(T.fecnaci) = 12 THEN 'DICIEMBRE'
                                    END mescumple                                     
                               FROM cuadropersonal C          
                                    LEFT JOIN seccion SE ON (C.seccionid = SE.seccionid)
                                    LEFT JOIN vacantes VAC ON (VAC.vacanteid = C.vacanteid) 
                                    LEFT JOIN cargosvacantes CVA ON (CVA.cargoid = VAC.cargoid) 
                                    LEFT JOIN terceros T ON (T.terid = C.terid) 
                                    INNER JOIN ciudades CI ON (T.ciudadid = CI.ciudadid) 
                                    LEFT JOIN cargos CA ON (T.cargoid = CA.cargoid)	
                                    LEFT JOIN entidadesbancarias B ON (T.bancoid = B.bancoid) 
                                    LEFT JOIN bancos BC ON (T.bancoid = BC.bancoid)	
                                    LEFT JOIN pensiones P ON (T.pensionesid = P.pensionesid) 
                                    LEFT JOIN eps E ON (T.epsid = E.epsid)	
                                    LEFT JOIN cesantias CS ON (T.cesantiasid = CS.cesantiasid)	
                                    LEFT JOIN cajascompensacion CP ON (T.idcajacomp = CP.idcajacomp) 
                              WHERE T.esempleadoactivo <> 'CHECKED'";

                    $stmt = $pdo->query($vsql);
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                }

                header('Content-Type: application/json');
                echo json_encode($result);
                break;            

            default:
                http_response_code(405); // Method Not Allowed
                echo json_encode(['message' => 'Method not allowed']);
                break;
        }

    } catch (PDOException $e) {
        http_response_code(500); // Internal Server Error
        echo json_encode(['message' => 'Database error: ' . $e->getMessage()]);
		exit;
    }
	
} else {
    http_response_code(401); // Unauthorized
    echo json_encode(['message' => 'Authentication failed']);
	exit;
}

?>