<?php
require('../../config/functions.php');

$host     = '';
$dbname   = '';
$user     = '';
$password = '';
	
// Configuración de CORS
header('Access-Control-Allow-Origin: *'); // Permite conexiones desde cualquier origen
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Database credentials
loadconectionparams($host,$dbname,$user,$password);		
$pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

if(!APIisactiva($pdo)) 
{ 
    http_response_code(401); // Unauthorized
    echo json_encode(['message' => 'API se encuentra Inactiva en este momento']);	
    exit;
} 

// API Endpoints
if (authenticate()) { // Check authentication before processing requests

    try {        

        // Get Request Method
        $method = $_SERVER['REQUEST_METHOD'];

        switch ($method) {
            case 'GET': // Read (all or single)
                if (isset($_GET['id'])) {
                    $id = $_GET['id'];
                    $stmt = $pdo->prepare('SELECT * FROM seleccionvacantes WHERE idvacante = :id');
                    $stmt->execute(['id' => $id]);
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                } else {

                    if (isset($_GET['id'])) {
                        $id = $_GET['id'];
                        $stmt = $pdo->prepare('SELECT * FROM seleccionvacantes WHERE idvacante = :id');
                        $stmt->execute(['idvacante' => $id]);
                        $result = $stmt->fetch(PDO::FETCH_ASSOC);
                    } else {
                        $stmt = $pdo->query("SELECT * FROM seleccionvacantes");
                        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    }
                }

                header('Content-Type: application/json');
                echo json_encode($result);
                break;

            case 'POST': // Create
                $data = json_decode(file_get_contents("php://input"), true);
                // echo $data[0]['idvacante']."+++++"; 
                $i=0;
                while($data[$i]['idvacante'])
                {
                    // echo"***". $data[$i]['idvacante']; exit();

                    // ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- //
                    // $stmt = $pdo->prepare('INSERT INTO seleccionvacantes (idvacante,dni,nombre,hojadevida,documentoentregados,fechaentrevista,fechaaceptado,estado,observacion,codvende,terid) 
                    //                                                VALUES (:idvacante,:dni,:nombre,:hojadevida,:documentoentregados,:fechaentrevista,:fechaaceptado,:estado,:observacion,:codvende,:terid)');
                    
                    // $stmt->execute(['idvacante' =>  $data[$i]['idvacante'], 'dni' =>  $data[$i]['dni'], 'nombre' =>  $data[$i]['nombre'], 'hojadevida' =>  $data[$i]['hojadevida'], 'documentoentregados' =>  
                    //                  $data[$i]['documentoentregados'], 'fechaentrevista' =>  $data[$i]['fechaentrevista'], 'fechaaceptado' =>  $data[$i]['fechaaceptado'], 'estado' =>  $data[$i]['estado'], 
                    //                  'observacion' =>  $data[$i]['observacion'], 'codvende' =>  $data[$i]['codvende'], 'terid' =>  $data[$i]['terid']]);
                    // ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- //
                    $stmt = $pdo->prepare('INSERT INTO seleccionvacantes (idvacante,dni,nombre,hojadevida,documentoentregados,fechaentrevista,fechaaceptado,estado,observacion,codvende,terid,direccion,
                                                                          recomendado,fecnaci,email,telmovil) 
                                                                   VALUES (:idvacante,:dni,:nombre,:hojadevida,:documentoentregados,:fechaentrevista,:fechaaceptado,:estado,:observacion,:codvende,
                                                                           :terid,:direccion,:recomendado,:fecnaci,:email,:telmovil)');
                    
                    $stmt->execute(['idvacante' =>  $data[$i]['idvacante'], 'dni' =>  $data[$i]['dni'], 'nombre' =>  $data[$i]['nombre'], 'hojadevida' =>  $data[$i]['hojadevida'], 'documentoentregados' =>  
                                     $data[$i]['documentoentregados'], 'fechaentrevista' =>  $data[$i]['fechaentrevista'], 'fechaaceptado' =>  $data[$i]['fechaaceptado'], 'estado' =>  $data[$i]['estado'], 
                                     'observacion' =>  $data[$i]['observacion'], 'codvende' =>  $data[$i]['codvende'], 'terid' =>  $data[$i]['terid'], 'direccion' =>  $data[$i]['direccion'], 
                                     'recomendado' =>  $data[$i]['recomendado'], 'fecnaci' =>  $data[$i]['fecnaci'], 'email' =>  $data[$i]['email'], 'telmovil' =>  $data[$i]['telmovil']]);
                    // ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- //
                    $i++;
                }

                // ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ //
                // // almaceno los documentos consignados
                // // $stmt = $pdo->prepare('INSERT INTO detdocnomth (iddoc,dni,entregado) VALUES (1,:dni,:iddoc1),(2,:dni,:iddoc2),(3,:dni,:iddoc3),(4,:dni,:iddoc4),(5,:dni,:iddoc5),(6,:dni,:iddoc6),(7,:dni,:iddoc7),
                // //                                    (8,:dni,:iddoc8),(9,:dni,:iddoc9),(10,:dni,:iddoc10),(11,:dni,:iddoc11),(12,:dni,:iddoc12),(13,:dni,:iddoc13),(14,:dni,:iddoc14),(15,:dni,:iddoc15),
                // //                                    (16,:dni,:iddoc16),(17,:dni,:iddoc17),(18,:dni,:iddoc18),(19,:dni,:iddoc19),(20,:dni,:iddoc20),(21,:dni,:iddoc21),(22,:dni,:iddoc22),(23,:dni,:iddoc23),
                // //                                    (24,:dni,:iddoc24),(25,:dni,:iddoc25),(26,:dni,:iddoc26),(27,:dni,:iddoc27),(28,:dni,:iddoc28);');

                // $vsql = "INSERT INTO detdocnomth (iddoc,dni,entregado) 
                //               VALUES (1,'".$data[$i]['dni']."','".$data[$i]['iddoc1']."'),(2,'".$data[$i]['dni']."','".$data[$i]['iddoc2']."'),(3,'".$data[$i]['dni']."','".$data[$i]['iddoc3']."'),
                //                      (4,'".$data[$i]['dni']."','".$data[$i]['iddoc4']."'),(5,'".$data[$i]['dni']."','".$data[$i]['iddoc5']."'),(6,'".$data[$i]['dni']."','".$data[$i]['iddoc6']."'),
                //                      (7,'".$data[$i]['dni']."','".$data[$i]['iddoc7']."'),(8,'".$data[$i]['dni']."','".$data[$i]['iddoc8']."'),(9,'".$data[$i]['dni']."','".$data[$i]['iddoc9']."'),
                //                      (10,'".$data[$i]['dni']."','".$data[$i]['iddoc10']."'),(11,'".$data[$i]['dni']."','".$data[$i]['iddoc11']."'),(12,'".$data[$i]['dni']."','".$data[$i]['iddoc12']."'),
                //                      (13,'".$data[$i]['dni']."','".$data[$i]['iddoc13']."'),(14,'".$data[$i]['dni']."','".$data[$i]['iddoc14']."'),(15,'".$data[$i]['dni']."','".$data[$i]['iddoc15']."'),
                //                      (16,'".$data[$i]['dni']."','".$data[$i]['iddoc16']."'),(17,'".$data[$i]['dni']."','".$data[$i]['iddoc17']."'),(18,'".$data[$i]['dni']."','".$data[$i]['iddoc18']."'),
                //                      (19,'".$data[$i]['dni']."','".$data[$i]['iddoc19']."'),(20,'".$data[$i]['dni']."','".$data[$i]['iddoc20']."'),(21,'".$data[$i]['dni']."','".$data[$i]['iddoc21']."'),
                //                      (22,'".$data[$i]['dni']."','".$data[$i]['iddoc22']."'),(23,'".$data[$i]['dni']."','".$data[$i]['iddoc23']."'),(24,'".$data[$i]['dni']."','".$data[$i]['iddoc24']."'),
                //                      (25,'".$data[$i]['dni']."','".$data[$i]['iddoc25']."'),(26,'".$data[$i]['dni']."','".$data[$i]['iddoc26']."'),(27,'".$data[$i]['dni']."','".$data[$i]['iddoc27']."'),
                //                      (28,'".$data[$i]['dni']."','".$data[$i]['iddoc28']."')";

                // echo $vsql; exit();

                // $stmt = $pdo->prepare($vsql);

                // $stmt->execute(['iddoc' => 1, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc1'], 'iddoc' => 2, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc2'],  
                //                 'iddoc' => 3, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc3'], 'iddoc' => 4, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc4'], 
                //                 'iddoc' => 5, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc5'], 'iddoc' => 6, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc6'], 
                //                 'iddoc' => 7, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc7'], 'iddoc' => 8, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc8'], 
                //                 'iddoc' => 9, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc9'], 'iddoc' => 10, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc10'], 
                //                 'iddoc' => 11, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc11'], 'iddoc' => 12, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc12'], 
                //                 'iddoc' => 13, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc13'], 'iddoc' => 14, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc14'], 
                //                 'iddoc' => 15, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc15'], 'iddoc' => 16, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc16'], 
                //                 'iddoc' => 17, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc17'], 'iddoc' => 18, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc18'],
                //                 'iddoc' => 19, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc19'], 'iddoc' => 20, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc20'], 
                //                 'iddoc' => 21, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc21'], 'iddoc' => 22, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc22'], 
                //                 'iddoc' => 23, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc23'], 'iddoc' => 24, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc24'], 
                //                 'iddoc' => 25, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc25'], 'iddoc' => 26, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc26'], 
                //                 'iddoc' => 27, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc27'], 'iddoc' => 28, 'dni' =>  $data[$i]['dni'], 'entregado' =>  $data[$i]['iddoc28']]);
                // // ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ //

                header('Content-Type: application/json');
                echo json_encode(['message' => 'Se han Creados '.$i.' Registros  con Exito']);
                break;

            // case 'PUT': // Update
            //     if (isset($_GET['id'])) {
            //         $data = json_decode(file_get_contents("php://input"), true);
            //         //// Validaciones
            //         $stmt = $pdo->prepare('UPDATE seleccionvacantes SET idconceto = :idconceto , descripcion = :descripcion WHERE idmotivo = :idmotivo');
            //         $stmt->execute(['idconceto' => $data['idconceto'], 'descripcion' => $data['descripcion'], 'idmotivo' => $data['idmotivo']]);
            //         header('Content-Type: application/json');
            //         echo json_encode(['message' => 'Record updated']);
            //     } else {
            //         http_response_code(400); // Bad Request
            //         echo json_encode(['message' => 'idmotivo ID is required for update']);
            //     }
            //     break;

            case 'DELETE': // Delete
                if (isset($_GET['id'])) {
                    $stmt = $pdo->prepare('DELETE FROM seleccionvacantes WHERE idseleccion = :id');
                    $stmt->execute(['id' => $_GET['id']]);
                    header('Content-Type: application/json');
                    echo json_encode(['message' => 'Record deleted']);
                } else {
                    http_response_code(400); // Bad Request
                    echo json_encode(['message' => 'idmotivo ID is required for delete']);
                }
                break;

            default:
                http_response_code(405); // Method Not Allowed
                echo json_encode(['message' => 'Method not allowed']);
                break;
        }

    } catch (PDOException $e) {
        http_response_code(500); // Internal Server Error
        echo json_encode(['message' => 'Database error: ' . $e->getMessage()]);
		exit;
    }
	
} else {
    http_response_code(401); // Unauthorized
    echo json_encode(['message' => 'Authentication failed']);
	exit;
}

?>