<?php
require('../../config/functions.php');

$host     = '';
$dbname   = '';
$user     = '';
$password = '';
	
// Configuración de CORS
header('Access-Control-Allow-Origin: *'); // Permite conexiones desde cualquier origen
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Database credentials
loadconectionparams($host,$dbname,$user,$password);		
$pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

if(!APIisactiva($pdo)) 
{ 
  http_response_code(401); // Unauthorized
  echo json_encode(['message' => 'API se encuentra Inactiva en este momento']);	
  exit;
} 
    
// API Endpoints
if (authenticate()) { // Check authentication before processing requests

    try {        

        // Get Request Method
        $method = $_SERVER['REQUEST_METHOD'];

        switch ($method) {
            case 'GET': // Read (all or single)
                if (isset($_GET['id'])) 
                {
                    $id = strtoupper(trim($_GET['id']));

                    $vsql = "SELECT DISTINCT  M.* 
                             FROM menu M  
                             INNER JOIN menuxusuario MU ON (MU.menuid = M.id) 
                             INNER JOIN usuarios U ON (U.usuid = MU.usuarioid)  
                             INNER JOIN usuariosxgrupos UG ON (U.username = UG.nomusuario)
                             WHERE (U.username = '".$id."' OR UG.nomusuario = '".$id."')
                             ORDER BY M.orden ASC";

                    $stmt = $pdo->query($vsql);
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                } 
                else 
                {
                    http_response_code(400); // No Data
                    echo json_encode(['message' => 'ID es Requerido']);
                }

                header('Content-Type: application/json');
                echo json_encode($result);
                break;

            case 'POST': // Create
                http_response_code(405); // Method Not Allowed
                echo json_encode(['message' => 'Method not allowed']);
                break;

            case 'PUT': // Update
                http_response_code(405); // Method Not Allowed
                echo json_encode(['message' => 'Method not allowed']);
                break;

            case 'DELETE': // Delete
                http_response_code(405); // Method Not Allowed
                echo json_encode(['message' => 'Method not allowed']);
                break;

            default:
                http_response_code(405); // Method Not Allowed
                echo json_encode(['message' => 'Method not allowed']);
                break;
        }

    } catch (PDOException $e) {
        http_response_code(500); // Internal Server Error
        echo json_encode(['message' => 'Database error: ' . $e->getMessage()]);
		exit;
    }
	
} else {
    http_response_code(401); // Unauthorized
    echo json_encode(['message' => 'Authentication failed']);
	exit;
}

?>