<?php

// Ejemplo de uso:
$dsn = "DSN-WEB-JE"; // Nombre del DSN configurado en tu servidor
$user = "SYSDBA";
$password = "masterkey";

// Función para conectar a la base de datos ODBC
function conectarODBC($dsn, $user, $password) {
    $conn = odbc_connect($dsn, $user, $password);
    if (!$conn) {
        die("Error al conectar: " . odbc_errormsg());
    }
    return $conn;
}

/// Me conecto
//$conn = conectarODBC($dsn, $user, $password);


// Función para crear un registro
function crearRegistro($conn, $tabla, $datos) {
    $campos = implode(', ', array_keys($datos));
    $valores = "'" . implode("', '", array_values($datos)) . "'";
    $sql = "INSERT INTO $tabla ($campos) VALUES ($valores)";
    //echo $sql;
    $result = odbc_exec($conn, $sql);
    if (!$result) {
        die("Error al insertar registro: " . odbc_errormsg());
    }
    return true;
}

// Función para leer registros
function leerRegistros($conn, $tabla, $condicion = '') {
    $sql = "SELECT * FROM $tabla";
    if (!empty($condicion)) {
        $sql .= " WHERE $condicion";
    }
    $result = odbc_exec($conn, $sql);
    if (!$result) {
        die("Error al leer registros: " . odbc_errormsg());
    }
    $registros = [];
    while ($row = odbc_fetch_array($result)) {
        $registros[] = $row;
    }
    return $registros;
}

// Función para actualizar un registro
function actualizarRegistro($conn, $tabla, $datos, $condicion) {
    $actualizaciones = [];
    foreach ($datos as $campo => $valor) {
        $actualizaciones[] = "$campo = '$valor'";
    }
    $actualizaciones = implode(', ', $actualizaciones);
    $sql = "UPDATE $tabla SET $actualizaciones WHERE $condicion";
    ///echo $sql;
    $result = odbc_exec($conn, $sql);
    if (!$result) {
        die("Error al actualizar registro: " . odbc_errormsg());
    }
    return true;
}

// Función para eliminar un registro
function eliminarRegistro($conn, $tabla, $condicion) {
    $sql = "DELETE FROM $tabla WHERE $condicion";
    $result = odbc_exec($conn, $sql);
    if (!$result) {
        die("Error al eliminar registro: " . odbc_errormsg());
    }
    return true;
}

// Función para leer registros
function datosConsulta($conn, $sql) {
    if (!empty($condicion)) {
        $sql .= " WHERE $condicion";
    }
    $result = odbc_exec($conn, $sql);
    if (!$result) {
        die("Error al leer registros: " . odbc_errormsg());
    }
    $registros = [];
    while ($row = odbc_fetch_array($result)) {
        $registros[] = $row;
    }
    return $registros;
}

///// Funcion para Ejecutar SQL
function ejecutarSQL($conn,$sql)
{
    $result = odbc_exec($conn, $sql);
    if (!$result) {
        return(0);
    }
    else
      return(1);
}


// Ejemplos de uso:
/*
// Crear un registro
$datosCrear = [
    'campo1' => 'valor1',
    'campo2' => 'valor2',
    // Agregar más campos según tu tabla
];
crearRegistro($conn, 'nombre_tabla', $datosCrear);

// Leer registros
$registros = leerRegistros($conn, 'nombre_tabla');
foreach ($registros as $registro) {
    echo "ID: " . $registro['id'] . ", Campo1: " . $registro['campo1'] . ", Campo2: " . $registro['campo2'] . "<br>";
}

// Actualizar un registro
$datosActualizar = [
    'campo1' => 'nuevo_valor1',
    'campo2' => 'nuevo_valor2',
];
actualizarRegistro($conn, 'nombre_tabla', $datosActualizar, "id = 1");

// Eliminar un registro
eliminarRegistro($conn, 'nombre_tabla', "id = 2");
*/

// Cerrar la conexión ODBC al finalizar
//odbc_close($conn);

?>
