<?PHP
    @session_start();
    include("lib/Sistema.php");
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];
    $avisos = "";
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardareditado y guardarnuevo
    // Creación: 17/06/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opciones para incluir y modificar cajas de compensación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if(($opcion == "guardareditado")||($opcion == "guardarnuevo"))
    {
        // Nuevas validaciones para las cuatro variables de los nombres
        require_once("classes/class_validaciones.php");
        $io_validacion=new class_validaciones();
        $lb_valido=false;

        $idcajacomp = $_POST['idcajacomp'];
        $subsistema = strtoupper(trim($_POST['subsistema']));
        $codigo     = strtoupper(trim($_POST['codigo']));
        $nit        = strtoupper(trim($_POST['nit']));
        $nombrecaja = strtoupper(trim($_POST['nombrecaja']));

        // Valido que los campos tengan datos
        if(($codigo == "")||($nombrecaja == ""))
        {
            $clase->Aviso(3,"Los datos código y nombre no pueden estar vacíos &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
            header("Location: cajascompensacion.php");
        }
        else
        {
            $lb_valido=$io_validacion->uf_solo_letras($nombrecaja);   // Validación del nombre
            if(!$lb_valido)
            {
                $clase->Aviso(2,"El nombre debe contener solo letras &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
                header("Location: cajascompensacion.php");
                exit();
            }
            else
            {
                // Opción para guardar una nueva caja
                if($opcion == "guardarnuevo")
                {
                    // Validación de que el código ya exista
                    $vsqlx = "SELECT COUNT(codigo) FROM cajascompensacion WHERE codigo ='".$codigo."'";
                    $valor = $clase->SeleccionarUno($vsqlx);
    
                    if($valor>=1)
                    {
                        $clase->Aviso(3,"El código <b> $codigo </b> ya existe &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
                        header("Location: cajascompensacion.php");
                    }
                    else
                    {
                        // Validación de la existencia del nombre de la caja
                        $vsqlx = "SELECT COUNT(nombrecaja) FROM cajascompensacion WHERE nombrecaja ='".$nombrecaja."'";
                        $valordesc = $clase->SeleccionarUno($vsqlx);
    
                        if($valordesc>=1)
                        {
                            $clase->Aviso(3,"El nombre <b> $nombrecaja </b> ya existe &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
                            header("Location: cajascompensacion.php");
                        }
                        else
                        {
                            // Almaceno la nueva caja
                            $vsql = "INSERT INTO cajascompensacion (subsistema, codigo, nit, nombrecaja) 
                                          VALUES ('".$subsistema."','".$codigo."','".$nit."','".$nombrecaja."')";
                            $cant = $clase->EjecutarSQL($vsql);
        
                            // valido que se almacenen los datos para emitir el mensaje correspondiente
                            if(mysql_affected_rows() < 1)                        
                                $clase->Aviso(3,"No se incluyó la caja de compensación");
                            else
                                $clase->Aviso(1,"Caja de compensación creada exitosamente");                                                
                        }
                    }
                }

                // Opción para modificar una nueva caja
                if($opcion == "guardareditado")
                {
                    // ---------------------------------------------------------------------------------------------- //
                    // Proceso para validar si el código introducido ya existe
                    $lb_codigodiferente=false;
                    $lb_codigonuevoexiste=false;
                    $valorcod = 0;
    
                    $codnuevo = trim($codigo);
                    $vsqly = "SELECT codigo FROM cajascompensacion WHERE idcajacomp=".$idcajacomp;
                    $codanterior = $clase->SeleccionarUno($vsqly);
                    
                    if($codnuevo!=$codanterior)
                        $lb_codigodiferente=true;
    
                    if($lb_codigodiferente)
                    {
                        // Validación de la existencia del código de la caja
                        $vsqlx = "SELECT COUNT(codigo) FROM cajascompensacion WHERE codigo ='".$codnuevo."'";
                        $valorcod = $clase->SeleccionarUno($vsqlx);
    
                        if($valorcod>=1)
                            $lb_codigonuevoexiste=true;
                    }
                    // ---------------------------------------------------------------------------------------------- //
                    // Proceso para validar si el nombre introducido ya existe
                    $lb_descripciondiferente=false;
                    $lb_descripcionnuevoexiste=false;
                    $valordes = 0;
    
                    $desnueva = trim($nombrecaja);
                    $vsqly = "SELECT nombrecaja FROM cajascompensacion WHERE idcajacomp=".$idcajacomp;
                    $desanterior = $clase->SeleccionarUno($vsqly);                    
                    
                    if($desnueva!=$desanterior)
                        $lb_descripciondiferente=true;
    
                    if($lb_descripciondiferente)
                    {
                        // Validación de la existencia del nombre de la caja
                        $vsqlx = "SELECT COUNT(nombrecaja) FROM cajascompensacion WHERE nombrecaja ='".$desnueva."'";
                        $valordes = $clase->SeleccionarUno($vsqlx);
    
                        if($valordes>=1)
                            $lb_descripcionnuevoexiste=true;
                    }
    
                    // ---------------------------------------------------------------------------------------------- //
                    // Ejecuto las validaciones
                    if(($lb_codigodiferente)&&($lb_codigonuevoexiste))
                    {
                        $clase->Aviso(3,"El código <b> $codnuevo </b> ya existe &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
                        header("Location: cajascompensacion.php");
                    }
                    else
                    {
                        if(($lb_descripciondiferente)&&($lb_descripcionnuevoexiste))
                        {
                            $clase->Aviso(3,"El nombre <b> $nombrecaja </b> ya existe &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
                            header("Location: cajascompensacion.php");
                        }
                        else
                        {
                            // Almaceno la modificación
                            $vsql = "UPDATE cajascompensacion SET 
                                            subsistema = '".$subsistema."', 
                                            codigo = '".$codigo."',
                                            nit = '".$nit."', 
                                            nombrecaja = '".$nombrecaja."'
                                      WHERE idcajacomp = ".$idcajacomp;
                            $clase->EjecutarSQL($vsql);
            
                            // valido que se almacenen los datos para emitir el mensaje correspondiente
                            if(mysql_affected_rows() < 1)
                                $clase->Aviso(3,"No se modificó la caja de compensación");
                            else
                                $clase->Aviso(1,"Caja de compensación modificada exitosamente");
                        }
                    }
                }            
            }
            header("Location: cajascompensacion.php");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nuevo
    // Creación: 17/06/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para incluir una nueva caja enviándola 
    //              a la opción "guardarnuevo" para almacenarlo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nuevo")
    {
        $params = ' class="Texto11" ';
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/cajas.png" width="32" height="32" border="0"> </td>
                  <td width="1050"> <b>Inclusi&oacute;n de cajas de compensaci&oacute;n</b> </td>
                  <td><a href="cajascompensacion.php"><input type="button" value="<<" class="button"></a></td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<center>
                <form action="?opcion=guardarnuevo" method="POST">
                <fieldset style="width: 530px; height: 340px;" class="grupos">
                <legend class="titgrupos"> Datos </legend>
                <table width="350">
                 <tr height="55">
                  <td> <label class="Texto12"> <b>Subsistema:</b></label><br> 
                   <input type="text" name="subsistema" class="Texto15" size="5" maxlength="3" id="default" autocomplete="off"> 
                  </td>
                 </tr>
                 <tr height="55">
                  <td> <label class="Texto12"> <b>C&oacute;digo:</b></label><br>
                   <input type="text" name="codigo" class="Texto15"  maxlength="5" size="8" autocomplete="off"> 
                  </td>
                 </tr>
                 <tr height="55">
                  <td> <label class="Texto12"> <b>NIT:</b></label><br>
                   <input type="text" name="nit" class="Texto15"  maxlength="15" size="20" autocomplete="off"> 
                  </td>                   
                 </tr>                    
                 <tr height="55">
                  <td> <label class="Texto12"> <b>Nombre:</b></label><br>
                   <input type="text" name="nombrecaja" class="Texto15"  maxlength="100" size="50" autocomplete="off"> 
                  </td>
                 </tr>
                 <tr height="55">
                  <td align="center"><br><br> 
                   <input type="submit" value="guardar" class="button blue"> 
                  </td>
                 </tr>
                </table>
                <br><br>
                </fieldset>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: detalles
    // Creación: 17/06/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana de modificación de una caja llevándola a 
    //              la opción "guardareditado" donde almacena los datos
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "detalles")
    {
        $idcajacomp = $_GET['idcajacomp'];
        $params = ' class="Texto11" ';
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/cajas.png" width="32" height="32" border="0"> </td>
                  <td width="990"> <b>Modificar Cajas de compensaci&oacute;n </b></td>
                  <td width="20"> &nbsp; </td>
                  <td width="24"> 
                   <a href="cajascompensacion.php"><input type="button" value="<<" class="button"></a> 
                  </td>
                 </tr> 
                </table>
                <br><center>';
        
        $vsql = "SELECT * FROM cajascompensacion WHERE idcajacomp = ".$idcajacomp;

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        if($row = mysql_fetch_array($result))
        {
            $idcajacomp = $row['idcajacomp'];
            $cont.='<center>
                    <form action="?opcion=guardareditado" method="POST">
                    <input type="hidden" name="idcajacomp" value="'.$idcajacomp.'">
                    <fieldset style="width: 530px; height: 340px;" class="grupos">
                    <legend class="titgrupos"> Datos </legend>
                    <table width="350">
                     <tr height="55">
                      <td> <label class="Texto12"> <b>Subsistema:</b></label><br> 
                       <input type="text" name="subsistema" class="Texto15" size="5" maxlength="3" id="default" value="'.$row['subsistema'].'" autocomplete="off"> 
                      </td>
                     </tr>
                     <tr height="55">
                      <td> <label class="Texto12"> <b>C&oacute;digo:</b></label><br>
                       <input type="text" name="codigo" class="Texto15"  maxlength="5" size="8" value="'.$row['codigo'].'" autocomplete="off"> 
                      </td>
                     </tr>
                     <tr height="55">
                      <td> <label class="Texto12"> <b>NIT:</b></label><br>
                       <input type="text" name="nit" class="Texto15"  maxlength="15" size="20" value="'.$row['nit'].'" autocomplete="off"> 
                      </td>
                     </tr>
                     <tr height="55">
                      <td> <label class="Texto12"> <b>Nombre:</b></label><br>
                       <input type="text" name="nombrecaja" class="Texto15"  maxlength="100" size="50" value="'.$row['nombrecaja'].'" autocomplete="off"> 
                      </td>
                     </tr>
                    </table>
                    <table width="350">
                     <tr height="55">
                      <td align="center">
                       <br><br> 
                       <input type="submit" value="guardar" class="button blue"> 
                      </td>
                     </tr>	
                    </table>
                    <br>
                    </fieldset>';
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: encontrar
    // Creación: 17/06/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que encuentra una caja buscándolo por código o descripción
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "encontrar")
    {
        $criterio  = $_POST['criterio'];
        $arreglado = str_replace(" ","%",$criterio);
        $vsql = "SELECT * 
                   FROM cajascompensacion
                  WHERE codigo LIKE '%".$criterio."%' OR 
                        nombrecaja LIKE '%".$criterio."%'                         
               ORDER BY codigo ASC";
        $_SESSION['SQL_CAJA'] = $vsql;
        header("Location: cajascompensacion.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmacion
    // Creación: 17/06/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de una caja
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmacion")
    {
        $idcajacomp = $_GET['idcajacomp'];
        $nombrecaja = $clase->BDLockup($idcajacomp,'cajascompensacion','idcajacomp','nombrecaja');
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><b>Eliminar una cajas de compensaci&oacute;n</b><br><br><td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center">¿Confirma que desea eliminar la caja<br><b> '.$nombrecaja.'</b>? <br></td>       
                 </tr>
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"><br><br>
                   <form action="?opcion=eliminar" method="POST">
                   <input type="hidden" name="idcajacomp" value="'.$idcajacomp.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                   <a href="cajascompensacion.php" ><input type="button" value="CANCELAR" class="button blue"></a>
                   </form>
                   <br>
                  </td> 
                 </tr>
                </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminar
    // Creación: 17/06/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina físicamente una caja de compensación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminar")
    {        
        $idcajacomp = $_POST['idcajacomp'];

        // Valido que ningún empleado esté asociado a esta caja de compensación
        $vsqlx = "SELECT COUNT(idcajacomp) AS valor FROM terceros WHERE idcajacomp =".$idcajacomp;
        $valor = $clase->SeleccionarUno($vsqlx);
   
        if($valor>=1)        
        {
            $nombrecaja = $clase->BDLockup($idcajacomp,'cajascompensacion','idcajacomp','nombrecaja');
            $clase->Aviso(3,"No se puede eliminar la caja $nombrecaja porque existen empleados asociados a ella");
            header("Location: cajascompensacion.php");
        }
        else
        {
            $vsql = "DELETE FROM cajascompensacion WHERE idcajacomp = ".$idcajacomp;
            $clase->EjecutarSQL($vsql);

            // valido que se almacenen los datos para emitir el mensaje correspondiente
            if(mysql_affected_rows() < 1)
                $clase->Aviso(3,"No se eliminó la caja de compensación");
            else
                $clase->Aviso(1,"Caja de compensación eliminada exitosamente");

            header("Location: cajascompensacion.php");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nofiltro
    // Creación: 17/06/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que anula la búsqueda realizada por la opción “encontrar”
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nofiltro")
    {
        $vsql = "SELECT * FROM cajascompensacion ORDER BY codigo ASC";
        $_SESSION['SQL_CAJA'] = "";
        header("Location: cajascompensacion.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ""
    // Creación: 17/06/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana principal del formulario
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "")
    {
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/cajas.png" width="32" height="32" border="0"> </td>
                  <td width="800"> <b>Cajas de compensaci&oacute;n</b> </td>
                  <td width="10"> 
                   <a href="?opcion=cajaspdf" title="informe de eps en pdf" target="_blank"> 
                    <img src="images/iconos/exportarpdf2.png" border="0"> 
                   </a> 
                  </td>
                  <td width="15"> &nbsp; </td>
                  <td width="10"> 
                   <a href="?opcion=cajasxls" title="informe de eps en excel" target="_blank"> 
                    <img src="images/iconos/exportarexcel2.png" border="0"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td> 
                  <td width="24"> <a href="?opcion=nuevo"> <img src="images/basicas/icononuevo.png" border="0" title="nueva caja"> </a> </td> 
                  <form action="?opcion=encontrar" method="POST" name="x">
                  <td> <input type="text" name="criterio" size="20" placeholder="Criterio a Buscar" tabindex="1" id="default"> </td>
                  <td> <input type="submit" value="Encontrar" class="button"></form> </td>';                

        if($_SESSION['SQL_CAJA'] != "")
            $cont.='<td width="10"> <a href="?opcion=nofiltro"> <img src="images/basicas/nofiltro.png"> </a> </td>';           
  
        $cont.='  <td width="8"> &nbsp; </td>
                 </tr>	 			   
                </table> ';

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="20"> &nbsp; </td>
                   <td width="80"> C&oacute;digo </td>
                   <td width="320"> Nombre </td>			
                   <td width="85"> &nbsp; </td>
                   <td width="115"> &nbsp; </td>	
                   <td width="45"> &nbsp; </td>
                   <td width="50"> &nbsp; </td>
                   <td width="50"> &nbsp; </td>
                   <td width="45"> &nbsp; </td>
                   <td width="45"> &nbsp; </td>
                   <td width="45"> &nbsp; </td>
                   <td width="50"> &nbsp; </td>
                   <td width="50"> &nbsp; </td>
                   <td width="30"> &nbsp; </td>
                   <td width="30"> &nbsp; </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:690px; overflow-Y:scroll">';

        if($_SESSION['SQL_CAJA'] == "")
            $vsql = "SELECT * FROM cajascompensacion ORDER BY idcajacomp";
        else
            $vsql = $_SESSION['SQL_CAJA'];

        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        $i = 0;
        while($row = mysql_fetch_array($result)) 
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';
                    
            $cont.=' <td width="20"> &nbsp; </td>
                     <td width="90"> '.$row['codigo'].' </td>
                     <td width="605"> '.$row['nombrecaja'].' </td>
                     <td width="70"> &nbsp; </td>
                     <td width="20"> &nbsp; </td>
                     <td width="20"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>                     
                     <td width="30" align="center"> &nbsp; </td> 
                     <td width="30">
				      <a href="?opcion=confirmacion&idcajacomp='.$row['idcajacomp'].'" rel="facebox"><img src="images/basicas/iconoborrar.png" title="Eliminar" border="0"></a>
                     </td> 
                     <td width="30" align="center">
                      <a href="?opcion=detalles&idcajacomp='.$row['idcajacomp'].'"><img src="images/basicas/iconobuscar.png" title="Modificar caja" border="0"></a>
			         </td> <td width="10"> </td> 
                    </tr>';
        }
        $cont.=' </tbody>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: cajasxls
    // Creación: 16/01/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera la salida a Excel de las cajas de compensación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "cajasxls")
    {
        $vsql = $_SESSION['SQL_CAJA'];
        if($vsql == "")         $vsql = "SELECT * FROM cajascompensacion ORDER BY idcajacomp";

        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("cajas de compensación - DROPOS")
                                     ->setSubject("cajas de compensación - DROPOS")
                                     ->setDescription("cajas de compensación - DROPOS")
                                     ->setKeywords("cajas de compensación - DROPOS")
                                     ->setCategory("Categoria General");
        
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'INFORME DE CAJAS DE COMPENSACION')
                    ->setCellValue('A3', 'CODIGO')
                    ->setCellValue('B3', 'NOMBRE');
                 
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $i = 4;
        while($row = mysql_fetch_array($result))
        {
            $codigo = $row['codigo'];
            if(substr($codigo,0,1) == "0")            $codigo="'".$codigo;

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $codigo)
                        ->setCellValue('B'.$i, $row['nombrecaja']);
            $i++;
        }

        $rangoEncabezado = 'A3:B3';
        $rangoCeldas     = 'A3:B'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //        
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('cajas');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //                
        $nombrearcexcel = "cajas de compensacion.xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: cajaspdf
    // Creación: 16/01/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera la salida en pdf de las cajas de compensación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "cajaspdf")
    {
        // Traducción al español del mes que devuelve la función date()
        $mesimp = date('F');
        if($mesimp=="January")       $mesimp = "Enero";
        if($mesimp=="February")      $mesimp = "Febrero";
        if($mesimp=="March")         $mesimp = "Marzo";
        if($mesimp=="April")         $mesimp = "Abril";
        if($mesimp=="May")           $mesimp = "Mayo";
        if($mesimp=="June")          $mesimp = "Junio";
        if($mesimp=="July")          $mesimp = "Julio";
        if($mesimp=="August")        $mesimp = "Agosto";
        if($mesimp=="September")     $mesimp = "Septiembre";
        if($mesimp=="October")       $mesimp = "Octubre";
        if($mesimp=="November")      $mesimp = "Noviembre";
        if($mesimp=="December")      $mesimp = "Diciembre";

        // Procedo a construir el encabezado del recibo
        ini_set("memory_limit","200M");
        require('lib/fpdf/fpdf.php');
        $pdf=new FPDF();
        
        // Página nueva
        $pdf->AddPage("");
        $pagina = 1;

        // Logo Dromedicas
        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

        // Imprimo el encabezado del informe
        $x = 25;
        $y = 13;
        $pdf->SetFont('Arial','B',10);
        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
        $pdf->Text($x,$y,$enc);

        // Fecha y hora de impresión
        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

        $pdf->SetFont('Arial','',8);
        $pdf->Text($x+124,$y,$fechoraimp);

        $pdf->SetFont('Arial','B',10);
        $enc= "INFORME DE CAJAS DE COMPENSACION";               $pdf->Text($x,$y+5,$enc);

        // Encabezado del informe
        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(5,26,200,8,'F');

        $pdf->SetFont('Arial','B',9);
        $enc= "CODIGO";                         $pdf->Text($x-17,$y+18,$enc);
        $enc= "NOMBRE";                         $pdf->Text($x+17,$y+18,$enc);

        $vsql = $_SESSION['SQL_CAJA'];
        if($vsql == "")         $vsql = "SELECT * FROM cajascompensacion ORDER BY idcajacomp";
        
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $x = 8;
        $y = 39;
        $i = 0;
        $linea = 0;
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%38==0)
            {
                $pdf->AddPage("");
                $pagina++;

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

                // Imprimo el encabezado del informe
                $x = 25;
                $y = 13;
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+124,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "INFORME DE CAJAS DE COMPENSACION";               $pdf->Text($x,$y+5,$enc);

                // Encabezado del informe
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(5,26,200,8,'F');

                $pdf->SetFont('Arial','B',9);
                $enc= "CODIGO";                         $pdf->Text($x-17,$y+18,$enc);
                $enc= "NOMBRE";                         $pdf->Text($x+17,$y+18,$enc);

                $x = 8;
                $y = 39;
            }
            $linea++;

            $pdf->SetFont('Arial','',8);
            $codigo = $row['codigo'];
            $pdf->Text($x,$y,$codigo);
            $pdf->Text($x+34,$y,$row['nombrecaja']);

            $y+=6;
        }
        $pdf->Output();
    }

    ////////////////////////////////
    echo $cont.$clase->PiePagina();
?>