<?PHP
    @session_start(); 
    include("lib/Sistema.php");  
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ""
    // Creación: 26/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la vista principal del formulario 
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "")
    {
        // Pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/Folder docs.png" width="32" height="32" border="0"> </td>
                  <td width="750"> <b> Categor&iacute;as y sub categor&iacute;as </b> </td>
                  <td width="30" align="left"> 
                   <a href="?opcion=ventincluircategoria" rel="facebox">
                    <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0" title="incluir categor&iacute;a"> 
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> 
                   <a href="?opcion=categoriasxls" target="_blank">
                    <img src="images/iconos/exportarexcel2.png" border="0" width="32" height="32" title="exportar a una hoja de Excel"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="10" align="center"> 
                   <a href="categoriasxproducto.php" title="refrescar la ventana"> 
                    <img src="images/iconos/refrescar.png" width="32" height="32" border="0"> 
                   </a>                       
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="50" align="center"> <input type="button" class="button" value="<<" OnClick="document.location=\'principal.php\'"> </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';
    
        // encabezado de la vista
        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="12"> &nbsp; </td>
                   <td width="240"> &nbsp; </td>
                   <td width="25" align="center"> &nbsp; </td>
                   <td width="25" align="center"> &nbsp; </td>
                   <td width="25" align="center"> &nbsp; </td>
                   <td width="30"> &nbsp; </td>
                   <td width="240" align="right"> &nbsp; </td>                   
                   <td width="25" align="center"> &nbsp; </td>
                   <td width="25" align="center"> &nbsp; </td>
                   <td width="25" align="center"> &nbsp; </td>
                   <td width="253" align="right"> &nbsp; </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:600px; overflow-Y:scroll">'; 

        // Consulta de la vista
        $vsql = "SELECT * FROM categoriasportafolio ORDER BY padre, nivel, categoriaid";

        // Conexión a la base de datos
        $i = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $categoriaid = $row['categoriaid'];
            $padre = $row['padre'];
            
            $numproductos = productosxcatg($categoriaid);
            $numsubcatg = subcatg($padre);

            $nombrecategoria = $row['codcategoria'].' '.$row['nomcategoria'].' '.'<font color="blue"> ('.number_format($numproductos).' productos)</font>';

            // determino si es categoría o sub categoría
            if($categoriaid == $padre)
            {
                $cont.=' <td width="12"> &nbsp; </td>
                         <td width="240" align="left"> '.$nombrecategoria.' </td>'; 
                
                if(($numproductos == 0) && ($numsubcatg == 0))
                    $cont.=' <td width="25" align="center"> 
                              <a href="?opcion=confirmarelicat&categoriaid='.$categoriaid.'" rel="facebox">
                               <img src="images/basicas/iconoborrar.png" title="eliminar categor&iacute;a" border="0">
                              </a>
                             </td>';
                else
                    $cont.=' <td width="25" align="center"> &nbsp; </td>';

                $cont.=' <td width="25" align="center"> 
                          <a href="?opcion=venteditcat&categoriaid='.$categoriaid.'" rel="facebox">
                           <img src="images/basicas/auditoria.png" title="editar categor&iacute;a" border="0">
                          </a>
                         </td>                         
                         <td width="25" align="center"> 
                          <a href="?opcion=ventasigprodcat&categoriaid='.$categoriaid.'" target="_blank">
                           <img src="images/basicas/icononuevo.png" title="asignar productos" border="0">
                          </a>
                         </td>
                         <td width="30"> &nbsp; </td>
                         <td width="240" align="left"> &nbsp; </td>
                         <td width="25" align="center"> &nbsp; </td>
                         <td width="25" align="center"> &nbsp; </td>
                         <td width="25" align="center"> &nbsp; </td>
                         <td width="410" align="left"> &nbsp; </td>
                        </tr>';
            }
            else
            {
                $cont.=' <td width="12">&nbsp;  </td>
                         <td width="240" align="left"> &nbsp; </td>
                         <td width="25" align="center"> &nbsp; </td>
                         <td width="25" align="center"> &nbsp; </td>
                         <td width="25" align="center"> &nbsp; </td>
                         <td width="30"> &nbsp; </td>
                         <td width="240" align="left"> '.$nombrecategoria.' </td>';

                if($numproductos == 0)
                    $cont.=' <td width="25" align="center"> 
                              <a href="?opcion=confirmarelisubcat&categoriaid='.$row['categoriaid'].'" rel="facebox">
                               <img src="images/basicas/iconoborrar.png" title="eliminar categor&iacute;a" border="0">
                              </a>
                             </td>';
                else
                    $cont.=' <td width="25" align="center"> &nbsp; </td>';

                $cont.=' <td width="25" align="center"> 
                          <a href="?opcion=venteditcat&categoriaid='.$categoriaid.'" rel="facebox">
                           <img src="images/basicas/auditoria.png" title="editar categor&iacute;a" border="0">
                          </a>
                         </td>      
                         <td width="25" align="center"> 
                          <a href="?opcion=ventasigprodcat&categoriaid='.$categoriaid.'" target="_blank">                           
                           <img src="images/basicas/icononuevo.png" title="asignar productos" border="0">
                          </a>
                         </td>
                         <td width="410" align="left"> &nbsp; </td>
                        </tr>';
            }
        }

        $cont.=' </tbody>
                </table>';
 
         // Impresión de los totales
         $cont.='<table width="100%">
                  <tr class="TituloTabla"> 
                   <td width="261"> &nbsp; </td>
                   <td width="375" align="right"> &nbsp; </td>
                   <td width="375" align="right"> &nbsp; </td>
                   <td width="375" align="right"> &nbsp; </td>
                   <td width="222"> &nbsp; </td>
                  </tr>
                 </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ventincluircategoria
    // Creación: 26/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para incluir una categoría
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventincluircategoria")
    {
        // Configuración de combos
        $params = ' class="Texto11" ';
        $vsqlcombocatpadre = "SELECT categoriaid, CONCAT(codcategoria,' ',nomcategoria) categoria FROM categoriasportafolio WHERE nivel = 1";

        // pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0"> </td>
                  <td width="450" align="center"> <b>Incluir categor&iacute;a</b> </td>
                 </tr> 
                </table>
                <form action="?opcion=guardarnnuevacategoria" method="POST" name="x">
                <table width="500">
                 <center>
                 <tr class="TablaDocsImPar">
                  <td width="120" align="right"><label class="Texto12"> Nombre: </label></td>
                  <td width="380">
                   &nbsp;&nbsp;
                   <input type="text" class="Texto11" name="nomcategoria" size="35" maxlenght="35" value="" style="text-transform:uppercase!Important;" autocomplete="off">
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="120" align="right"><label class="Texto12"> Categor&iacute;a padre: </label></td>
                  <td width="380"> &nbsp;&nbsp; '.$clase->CrearComboBuscar("categoriaid",$vsqlcombocatpadre,"categoria","categoriaid","","S",$params,300).' </td>
                 </tr>
                </table>
                <br>
                <center>
                <input type="submit" value="aceptar" class="button blue">
                <a href="categoriasxproducto.php"><input type="button" value="CANCELAR" class="button red"></a>
                </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardarnnuevacategoria
    // Creación: 26/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena una nueva categoría o sub categoría según sea el 
    //              caso
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarnnuevacategoria")
    {
        $nomcategoria = strtoupper($_POST['nomcategoria']);
        $categoriaid = $_POST['categoriaid'];

        // Inicializo las variables
        $vsql2 = "";
        $codcategoriastr = "";
        $codcatnum = 0;
        $codcategoria = "";
        $vsql5 = "";
        $newid = 0;
        $padre = 0;
        $nivel = 0;

        // Valido el nombre de la categoría
        if(strlen($nomcategoria) == 0)
            $clase->Aviso(3,"Debe ingresar el nombre de la categoría");
        else
        {
            if(strlen($categoriaid) == 0)
            {
                // Proceso a incluir una categoría padre

                // Construyo el código de la categoría
                $vsql2 = "SELECT MAX(codcategoria) FROM categoriasportafolio";
                $codcategoriastr = $clase->SeleccionarUno($vsql2);

                $codcatnum = intval($codcategoriastr);
                $codcatnum++;
                $codcategoria = strval($codcatnum);
                
                // Construyo el padre
                $vsql5 = "SELECT `AUTO_INCREMENT`
                            FROM INFORMATION_SCHEMA.TABLES
                           WHERE TABLE_SCHEMA = DATABASE()
                                 AND TABLE_NAME = 'categoriasportafolio'";                
                $newid = $clase->SeleccionarUno($vsql5);
                $padre = $newid;
                
                $nivel = 1;
            }
            else
            {
                // Procedo a incluir una sub categoría                

                // Construyo el código de la categoría
                $padre = $clase->BDLockup($categoriaid,'categoriasportafolio','categoriaid','padre');
                $vsql2 = "SELECT MAX(codcategoria) FROM categoriasportafolio WHERE padre = ".$padre;
                $codcategoriastr = $clase->SeleccionarUno($vsql2);                
                
                $codcatnum = doubleval($codcategoriastr);
                $codcatnum = $codcatnum + 0.1;                
                $codcategoria = strval($codcatnum);                

                $nivel = 2;                
            }

            // Almaceno la información
            $vsql = "INSERT INTO categoriasportafolio (codcategoria,nomcategoria,nivel,padre) VALUE ('".$codcategoria."','".$nomcategoria."',".$nivel.",".$padre.")";
            $clase->EjecutarSQL($vsql);

            // Emito el mensaje correspondiente
            if(mysql_affected_rows() >= 1)
                $clase->Aviso(1,"Categoría almacenada satisfactoriamente");
            else
                $clase->Aviso(3,"No se almacenó la categoría");

            // Redirecciona el formulario
            header("Location: categoriasxproducto.php");            
        }
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: confirmarelisubcat
    // Creación: 27/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la eliminación de una sub 
    //              categoría
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarelisubcat")
    {
        $categoriaid = $_GET['categoriaid'];
        
        $nomcategoria = $clase->BDLockup($categoriaid,'categoriasportafolio','categoriaid','nomcategoria');

        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><label class="Texto12"><b>Eliminar sub categor&iacute;a </b></label><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <br>
                   <label class="Texto12">¿Confirma que desea eliminar la sub categor&iacute;a<br><b>'.trim($nomcategoria).'</b>?</label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=eliminarsubcategoria&categoriaid='.$categoriaid.'" method="POST">
                   <input type="hidden" name="categoriaid" value="'.$categoriaid.'"> 
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="categoriasxproducto.php" ><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: eliminarsubcategoria
    // Creación: 27/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina físicamente una sub categoría
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarsubcategoria")
    {
        $categoriaid = $_POST['categoriaid'];

        $numproductos = productosxcatg($categoriaid);

        if($numproductos > 0)
            $clase->Aviso(3,"No se puede eliminar esta sub categoría");
        else
        {
            // Elimino el encabezado de la ruta
            $vsql = "DELETE FROM categoriasportafolio WHERE categoriaid = ".$categoriaid;
            $clase->EjecutarSQL($vsql);
    
            // Emito el mensaje correspondiente
            if(mysql_affected_rows() >= 1)
                $clase->Aviso(1,"Sub categoría eliminada satisfactoriamente");
            else
                $clase->Aviso(3,"No se eliminó la sub categoría");
        }        

        // Redirecciono el formulario
        header("Location: categoriasxproducto.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: confirmarelicat
    // Creación: 27/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la eliminación de una 
    //              categoría
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarelicat")
    {
        $categoriaid = $_GET['categoriaid'];
        
        $nomcategoria = $clase->BDLockup($categoriaid,'categoriasportafolio','categoriaid','nomcategoria');

        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><label class="Texto12"><b>Eliminar categor&iacute;a </b></label><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <br>
                   <label class="Texto12">
                    ¿Confirma que desea eliminar la categor&iacute;a<br><b>'.trim($nomcategoria).'</b>?                    
                   </label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=eliminarcategoria&categoriaid='.$categoriaid.'" method="POST">
                   <input type="hidden" name="categoriaid" value="'.$categoriaid.'"> 
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="categoriasxproducto.php" ><input type="button" value="CANCELAR" class="button red"></a>
                   </form>                   
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: eliminarcategoria
    // Creación: 27/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina físicamente una categoría
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarcategoria")
    {
        $categoriaid = $_POST['categoriaid'];
        $padre = $clase->BDLockup($categoriaid,'categoriasportafolio','categoriaid','padre');

        $numproductos = productosxcatg($categoriaid);
        $numsubcatg = subcatg($padre);

        if(($numproductos > 0) || ($numsubcatg > 0))
            $clase->Aviso(3,"No se puede eliminar esta categoría");
        else
        {
            // Elimino los productos de todas las categorías
            $vsql2 = "DELETE FROM categoriasportafolioxproductos WHERE categoriaid IN (SELECT categoriaid FROM categoriasportafolio WHERE padre = ".$padre.")";
            $clase->EjecutarSQL($vsql2);
            
            // Elimino las categorías y sub categorías
            $vsql = "DELETE FROM categoriasportafolio WHERE padre = ".$padre;
            $clase->EjecutarSQL($vsql);
    
            // Emito el mensaje correspondiente
            if(mysql_affected_rows() >= 1)
                $clase->Aviso(1,"Categoría eliminada satisfactoriamente");
            else
                $clase->Aviso(3,"No se eliminó la Categoría");            
        }

        // Redirecciono el formulario
        header("Location: categoriasxproducto.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: venteditcat
    // Creación: 27/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para editar una categoría
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "venteditcat")
    {
        $categoriaid = $_GET['categoriaid'];
        
        $nomcategoria = $clase->BDLockup($categoriaid,'categoriasportafolio','categoriaid','nomcategoria');

        // Pinto la ventana
        $cont.='<table width="400">
                 <tr class="CabezoteTabla">
                  <td align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td align="center"> <b>Editar categor&iacute;a</b> </td>
                 </tr> 
                </table>                
                <form action="?opcion=guardareditcat" name="y" method="POST">
                <input type="hidden" name="categoriaid" value="'.$categoriaid.'">
                <table width="400">
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left">
                   <label class="Texto12">Nombre:&nbsp;</label>
                   <input type="text" class="Texto11" name="nomcategoria" size="35" maxlenght="35" style="text-transform:uppercase!Important;" autocomplete="off" value="'.$nomcategoria.'">
                  </td>
                 </tr>
                </table> 
                <table width="400">
                 <tr class="CabezoteTabla">
                  <td align="center">                    
                   <input type="submit" value="aceptar" class="button blue">
                   <a href="categoriasxproducto.php" ><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardareditcat
    // Creación: 27/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena la modificación de una categoría
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardareditcat")
    {
        $categoriaid = $_POST['categoriaid'];
        $nomcategoria = strtoupper($_POST['nomcategoria']);

        // Modifico el registro
        $vsql = "UPDATE categoriasportafolio SET 
                        nomcategoria = '".$nomcategoria."'
                  WHERE categoriaid = ".$categoriaid;
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Categoría editada satisfactoriamente");
        else
            $clase->Aviso(3,"No se editó la categoría");

        // Redirecciona el formulario
        header("Location: categoriasxproducto.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ventasigprodcat
    // Creación: 27/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana donde se muestran y administran los 
    //              productos asociados a una categoría
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventasigprodcat")
    {
        $categoriaid = $_GET['categoriaid'];
        $nomcategoria = $clase->BDLockup($categoriaid,'categoriasportafolio','categoriaid','nomcategoria');

        // Determino si se activa la limpieza de la categoría
        $numproductos = productosxcatg($categoriaid);

        if($numproductos == 0)
            $limpiar = ' <img src="images/iconos/anulardoc.png" border="0" title="eliminar todos los productos"> ';
        else
            $limpiar = ' <a href="?opcion=confirmarlimpiar&categoriaid='.$categoriaid.'" rel="facebox">
                          <img src="images/iconos/anulardoc.png" border="0" title="eliminar todos los productos"> 
                         </a>';
        
        // Pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/Folder docs.png" width="32" height="32" border="0"> </td>
                  <td width="770"> <b> Asignar productos a categor&iacute;a <br> <font color="blue"> '.$nomcategoria.' </font> </b> </td>
                  <td width="20"> 
                   <a href="?opcion=ventinclproductocat&categoriaid='.$categoriaid.'" rel="facebox">
                    <img src="images/iconos/nuevodoc.png" border="0" title="incluir producto a categor&iacute;a"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> 
                   <a href="?opcion=ventanaimportarexcel&categoriaid='.$categoriaid.'" rel="facebox">
                    <img src="images/iconos/cargar.png" border="0" title="importar desde una hoja de Excel"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> 
                   <a href="?opcion=vererrores&categoriaid='.$categoriaid.'" rel="facebox">
                    <img src="images/iconos/notas.png" border="0" title="categor&iacute;a no guardados en el &uacute;ltimo proceso ejecutado"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> 
                   <a href="?opcion=productoscatpxls&categoriaid='.$categoriaid.'" target="_blank">
                    <img src="images/iconos/exportarexcel2.png" border="0" title="exportar a una hoja de Excel"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> '.$limpiar.' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="50" align="center"> <input type="button" class="button" value="<<" OnClick="document.location=\'categoriasxproducto.php\'"> </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';

        // detalle de la ventana
        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="11"> &nbsp; </td>
                   <td width="120" align="left"> C&oacute;digo </td>
                   <td width="520" align="left"> Producto </td>
                   <td width="392" align="left"> Laboratorio </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:550px; overflow-Y:scroll">';

        // Consulta de la vista
        $vsql = "SELECT p.productoid, p.codigo, p.descripcion producto, g.descripcion laboratorio 
                   FROM categoriasportafolioxproductos cpxp
                        INNER JOIN productos p ON (cpxp.productoid = p.productoid)
                        INNER JOIN gruposprod g ON (p.gruposprodid = g.gruposprodid)
                  WHERE cpxp.categoriaid = ".$categoriaid."
               ORDER BY 1";

        $_SESSION['SQL_PRODXCATXLS'] = $vsql;

        $i = 0;        
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';
                
            $cont.=' <td width="11"> &nbsp; </td>
                     <td width="120" align="left"> '.$row['codigo'].' </td>
                     <td width="518" align="left"> '.$row['producto'].' </td>
                     <td width="362" align="left"> '.$row['laboratorio'].' </td>
                     <td width="26" align="center"> 
                      <a href="?opcion=confirmareliminarprod&productoid='.$row['productoid'].'&categoriaid='.$categoriaid.'" rel="facebox">
                       <img src="images/basicas/iconoborrar.png" title="eliminar producto" border="0">
                      </a> 
                     </td>
                    </tr>';
        }

        $cont.=' </tbody>
                </table>';

        // pie de página
        $cont.='<table width="100%"> <tr class="TituloTabla"> <td width="1608" align="center"> <b>'.number_format($numproductos).' productos </b></td> </tr> </table>';        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: confirmareliminarprod
    // Creación: 27/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que muestra la ventana donde se confirma la eliminación de un 
    //              producto asociado a una categoría
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmareliminarprod")
    {
        $productoid = $_GET['productoid'];
        $categoriaid = $_GET['categoriaid'];

        $nomcategoria = $clase->BDLockup($categoriaid,'categoriasportafolio','categoriaid','nomcategoria');
        $descripcion = $clase->BDLockup($productoid,'productos','productoid','descripcion');

        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><label class="Texto12"><b>Eliminar producto </b></label><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <br>
                   <label class="Texto12">
                    ¿Confirma que desea eliminar el producto <br> <b>'.trim($descripcion).'</b> <br> de la categor&iacute;a<br><b>'.trim($nomcategoria).'</b>?<br>
                   </label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=eliminarproductocar&categoriaid='.$categoriaid.'&productoid='.$productoid.'" method="POST">
                   <input type="hidden" name="categoriaid" value="'.$categoriaid.'"> 
                   <input type="hidden" name="productoid" value="'.$productoid.'"> 
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="categoriasxproducto.php?opcion=ventasigprodcat&categoriaid='.$categoriaid.'" ><input type="button" value="CANCELAR" class="button red"></a>
                   </form>                   
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: eliminarproductocar
    // Creación: 27/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina físicamente un producto asociado a una categoría
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarproductocar")
    {
        $categoriaid = $_POST['categoriaid'];
        $productoid = $_POST['productoid'];

        // Elimino el producto
        $vsql = "DELETE FROM categoriasportafolioxproductos WHERE categoriaid = ".$categoriaid." AND productoid = ".$productoid;        
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Producto eliminada satisfactoriamente");
        else
            $clase->Aviso(3,"No se eliminó el producto");

        // Redirecciono el formulario
        header("Location: categoriasxproducto.php?opcion=ventasigprodcat&categoriaid=$categoriaid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaimportarexcel
    // Creación: 27/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la venta donde se capta la hoja de Excel desde la cual 
    //              se importarán los productos para la categoría
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaimportarexcel")
    {
        $categoriaid = $_GET['categoriaid'];
        
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder importar estos datos </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="categoriasxproducto.php?opcion=ventasigprodcat&categoriaid='.$categoriaid.'" id="theform" enctype="multipart/form-data">
                       <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />
                       </form> 
                      </td>
                     </tr>
                    </table>';
        else
        {
            $nomcategoria = $clase->BDLockup($categoriaid,'categoriasportafolio','categoriaid','nomcategoria');

            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                    $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar productos para la categor&iacute;a <br> <font color="blue"> '.$nomcategoria.' </font> </td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=importarexcel&categoriaid='.$categoriaid.'" id="theform" enctype="multipart/form-data">
                       <input type="hidden" name="categoriaid" value="'.$categoriaid.'">
                       <input type="file" name="excel" /><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>
                     </tr>
                    </table>';
    
            // estructura de la hoja de excel
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&oacute;digo del producto </td> </tr>
                    </table>';
    
            // ejemplo de como será la hoja de excel
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplomarcas.png" width="340" height="220" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx </font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel
    // Creación: 01/06/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para almacenar las listas especiales desde una hoja de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel")
    {
		set_time_limit(0);
		extract($_POST);
        $categoriaid = $_POST["categoriaid"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: categoriasxproducto.php?opcion=ventasigprodcat&categoriaid=$categoriaid");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {                    
                    $_DATOS_EXCEL[$i]['codigo'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();                    
                
                    if(strlen($_DATOS_EXCEL[$i]['codigo']) == 0)
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;
            
            $carpetaactual = 'reportes/';
            $nomcategoria = $clase->BDLockup($categoriaid,'categoriasportafolio','categoriaid','nomcategoria');

            // Construcción de la variable con los documentos no grabados
            $nocodigos = 'PRODUCTOS ASOCIADOS A LA CATEGORIA'.Chr(13).Chr(10);
            $nocodigos.= ''.str_pad($nomcategoria,1,"").''.Chr(13).Chr(10);
            $nocodigos.= 'CODIGOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocodigos.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                // inicializo las variables
                $lbgrabo = false;
                $vsql6 = "";
                $numreg = 0;
                $codigoproducto = "";

                // obtengo los datos del registro                
                $codigo = $_DATOS_EXCEL[$j]['codigo'];

                // valido que el código exista
                $codigoproducto = $clase->BDLockup($codigo,'productos','codigo','codigo');
                if($codigoproducto != "")
                {
                    $productoid = $clase->BDLockup($codigo,'productos','codigo','productoid');
    
                    // Valido que el producto no esté incluido en la categoría
                    $vsql6 = "SELECT COUNT(*) numreg FROM categoriasportafolioxproductos WHERE categoriaid = ".$categoriaid." AND productoid = ".$productoid;
                    $numreg = $clase->SeleccionarUno($vsql6);
    
                    if($numreg == 0)
                    {
                        $vsql = "INSERT INTO categoriasportafolioxproductos (categoriaid,productoid) VALUE (".$categoriaid.",".$productoid.")";
                        $clase->EjecutarSQL($vsql);
    
                        if(mysql_affected_rows() >= 1)
                        {
                            $grabados++;
                            $lbgrabo = true;
                        }                    
                    }
                }

                // Almaceno en un archivo de texto las códigos que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocodigos.= str_pad($codigo,1,"").''.Chr(13).Chr(10);          // Actualizo la variable con el documento no almacenado
                    $archivo = "erroresprodxcat.txt";                               // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");                 // se abre el archivo para escribir
                    fwrite($fd, $nocodigos);                                        // Grabas
                    fclose($fd);                                                    // Cierras el archivo
                }
            }
            
            $fechoraimp = fechayhoraejecucion();

            $nocodigos.= ''.Chr(13).Chr(10);
            $nocodigos.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);                 // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "erroresprodxcat.txt";                                                       // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                                         // se abre el archivo para escribir
            fwrite($fd, $nocodigos);                                                                // Grabas
            fclose($fd);                                                                            // Cierras el archivo

            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron los productos");
            else
                $clase->Aviso(1,"Se cargaron satisfactoriamente $grabados productos");
    
            // Redirecciono el formulario
            header("Location: categoriasxproducto.php?opcion=ventasigprodcat&categoriaid=$categoriaid");
        }
    }  

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: vererrores
    // Creación: 27/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para emitir la información del archivo de 
    //              texto erroresprodxcat.txt
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "vererrores")
    {
        $categoriaid = $_GET['categoriaid'];

        // Inicialización de variables
        $archivoerror = "reportes/erroresprodxcat.txt";
        $btnaceptar = '<a href="categoriasxproducto.php?opcion=ventasigprodcat&categoriaid='.$categoriaid.'">';
        $txt = "";
        $plantilla = fopen($archivoerror,"r") or die("No se han generado errores en la importación de estos datos");
        
        // Lleno la variable con los documentos no guardados
        while(!feof($plantilla))
        {
            $plantillaFinal = fgets($plantilla);
            $plantillaFinal = nl2br($plantillaFinal);
            $txt.= $plantillaFinal;
        }

        // Pinto la ventana con la información solicitada
        // echo $txt; exit();
        $txt = trim(str_replace("<br />","",$txt));
        $cont.='<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Productos no grabados <br>en el &uacute;ltimo proceso</b> </td> 
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="txt" cols="70" rows="38" disabled> '.$txt.' </textarea> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center">
                   '.$btnaceptar.'<input type="button" value="aceptar" class="button blue"></a>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventinclproductocat
    // Creación: 27/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para incluir un nuevo producto
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventinclproductocat")
    {
        $categoriaid = $_GET['categoriaid'];
        $nomcategoria = $clase->BDLockup($categoriaid,'categoriasportafolio','categoriaid','nomcategoria');

        $params = ' class="Texto11" ';
        $vsqlcomboproducto = "SELECT productoid, CONCAT(codigo,' - ',descripcion) FROM productos WHERE 1 ORDER BY productoid ASC";

        // pinto la ventana
        $cont ='<table width="800">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0"> </td>
                  <td width="750" align="center"> <b>Incluir producto a la categir&iacute;a <br> <font color="blue"> '.$nomcategoria.' </font> </b> </td>
                 </tr> 
                </table>
                <form action="?opcion=guardarnnuevoproducto&categoriaid='.$categoriaid.'" method="POST" name="x">
                <input type="hidden" name="categoriaid" value="'.$categoriaid.'">
                <table width="800">
                 <center>
                 <tr class="TablaDocsImPar">
                  <td width="80" align="right"><label class="Texto12"> Producto: </label></td>
                  <td width="720">
                   &nbsp;&nbsp;
                   '.$clase->CrearComboBuscar("productoid",$vsqlcomboproducto,"descripcion","productoid","","S",$params,620).'
                  </td>
                 </tr>
                </table>
                <br>
                <center>
                <input type="submit" value="aceptar" class="button blue">
                <a href="categoriasxproducto.php?opcion=ventasigprodcat&categoriaid='.$categoriaid.'" ><input type="button" value="CANCELAR" class="button red"></a>
                </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarnnuevoproducto
    // Creación: 27/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena un nuevo producto asociado a una categoría
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarnnuevoproducto")
    {
        $categoriaid = $_POST['categoriaid'];
        $productoid = $_POST['productoid'];

        // nombres de categoría y producto
        $nomcategoria = $clase->BDLockup($categoriaid,'categoriasportafolio','categoriaid','nomcategoria');
        $descripcion = $clase->BDLockup($productoid,'productos','productoid','descripcion');        

        // Valido que el producto no esté incluido en la categoría
        $vsql6 = "SELECT COUNT(*) numreg FROM categoriasportafolioxproductos WHERE categoriaid = ".$categoriaid." AND productoid = ".$productoid;
        $numreg = $clase->SeleccionarUno($vsql6);

        if($numreg > 0)
            $clase->Aviso(3,"$descripcion ya pertenece a la categoría $nomcategoria");
        else
        {
            // grabo el producto
            $vsql = "INSERT INTO categoriasportafolioxproductos (categoriaid,productoid) VALUE (".$categoriaid.",".$productoid.")";
            $clase->EjecutarSQL($vsql);

            // Emito el mensaje correspondiente
            if(mysql_affected_rows() >= 1)
                $clase->Aviso(1,"Producto almacenado satisfactoriamente");
            else
                $clase->Aviso(3,"No se almacenó el producto");
        }

        // Redirecciono el formulario
        header("Location: categoriasxproducto.php?opcion=ventasigprodcat&categoriaid=$categoriaid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: productoscatpxls
    // Creación: 27/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera una hoja de Excel con los productos asociados a una 
    //              categoría
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "productoscatpxls")
    {
        $categoriaid = $_GET['categoriaid'];
        $nomcategoria = $clase->BDLockup($categoriaid,'categoriasportafolio','categoriaid','nomcategoria');
        
        $vsql = $_SESSION['SQL_PRODXCATXLS'];

        // preparo el entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("Productos por categoria - DROPOS")
                                     ->setSubject("Productos por categoria - DROPOS")
                                     ->setDescription("Productos por categoria - DROPOS")
                                     ->setKeywords("Productos por categoria - DROPOS")
                                     ->setCategory("Categoria General");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'PRODUCTOS DE LA CATEGORIA '.$nomcategoria)
                    ->setCellValue('A3', 'CODIGO')
                    ->setCellValue('B3', 'PRODUCTO');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,4);

        $i=4;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        $cant   = @mysql_num_rows($result);
        while($row = @mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['codigo'])
                        ->setCellValue('B'.$i, $row['producto']);
            $i++;
        }

        $rangoEncabezado = 'A3:B3';
        $rangoCeldas     = 'A3:B'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('productos');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------------- //
        $nombrearcexcel = "productos de la categoria ".strtolower($nomcategoria).".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: categoriasxls
    // Creación: 28/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera una hoja de Excel con las categorías y sub categorías
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "categoriasxls")
    {
        // Consulta de las categorías
        $vsql = "SELECT * FROM categoriasportafolio ORDER BY padre, nivel, categoriaid";

        // preparo el entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("Categorias - DROPOS")
                                     ->setSubject("Categorias - DROPOS")
                                     ->setDescription("Categorias - DROPOS")
                                     ->setKeywords("Categorias - DROPOS")
                                     ->setCategory("Categoria General");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'CATEGORIAS Y SUB CATEGORIAS')
                    ->setCellValue('A3', 'CATEGORIAS')
                    ->setCellValue('B3', 'SUB CATEGORIAS');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,4);

        $i = 4;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        $cant   = @mysql_num_rows($result);
        while($row = @mysql_fetch_array($result))
        {
            $categoriaid = $row['categoriaid'];
            $padre = $row['padre'];

            $nombrecategoria = $row['codcategoria'].' '.$row['nomcategoria'];
            
            if($categoriaid == $padre)
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A'.$i, $nombrecategoria)
                            ->setCellValue('B'.$i, '');
            else
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A'.$i, '')
                            ->setCellValue('B'.$i, $nombrecategoria);

            $i++;
        }

        $rangoEncabezado = 'A3:B3';
        $rangoCeldas     = 'A3:B'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('categorias');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //
        $nombrearcexcel = "categorias y sub categorias.xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: confirmarlimpiar
    // Creación: 28/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la eliminación de todos los 
    //              productos de una categoría
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarlimpiar")
    {
        $categoriaid = $_GET['categoriaid'];
        $nomcategoria = $clase->BDLockup($categoriaid,'categoriasportafolio','categoriaid','nomcategoria');

        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><label class="Texto12"><b>Limpiar categor&iacute;a </b></label><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <br>
                   <label class="Texto12">
                    ¿Confirma que desea eliminar todos los productos asociados a la categor&iacute;a <br> <b>'.trim($nomcategoria).'</b>?<br>
                   </label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=limpiarprodcatg&categoriaid='.$categoriaid.'" method="POST">
                   <input type="hidden" name="categoriaid" value="'.$categoriaid.'">                    
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="categoriasxproducto.php?opcion=ventasigprodcat&categoriaid='.$categoriaid.'" ><input type="button" value="CANCELAR" class="button red"></a>
                   </form>                   
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: limpiarprodcatg
    // Creación: 28/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina todos los productos asociados a una categoría
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "limpiarprodcatg")
    {
        $categoriaid = $_POST['categoriaid'];

        // Elimino el producto
        $vsql = "DELETE FROM categoriasportafolioxproductos WHERE categoriaid = ".$categoriaid;
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Categoría limpiada satisfactoriamente");
        else
            $clase->Aviso(3,"No se limpió la categoría");

        // Redirecciono el formulario
        header("Location: categoriasxproducto.php?opcion=ventasigprodcat&categoriaid=$categoriaid");
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////
    // Función fechayhoraejecucion
    // Parámetro de entrada:    Ninguno
    // Valor de retorno:        $fechoraimp --> día, fecha y hora
    // Descripción: Función que devuelve la fecha con día, fecha y hora de ejecución del 
    //              último proceso
    ////////////////////////////////////////////////////////////////////////////////////////
    function fechayhoraejecucion()
    {
        $mesimp = date('F');
        if($mesimp == "January")       $mesimp = "enero";
        if($mesimp == "February")      $mesimp = "febrero";
        if($mesimp == "March")         $mesimp = "marzo";
        if($mesimp == "April")         $mesimp = "abril";
        if($mesimp == "May")           $mesimp = "mayo";
        if($mesimp == "June")          $mesimp = "junio";
        if($mesimp == "July")          $mesimp = "julio";
        if($mesimp == "August")        $mesimp = "agosto";
        if($mesimp == "September")     $mesimp = "septiembre";
        if($mesimp == "October")       $mesimp = "octubre";
        if($mesimp == "November")      $mesimp = "noviembre";
        if($mesimp == "December")      $mesimp = "diciembre";

        $dayweek = date("l");
        if($dayweek == "Monday")       $dayweek = "lunes";
        if($dayweek == "Tuesday")      $dayweek = "martes";
        if($dayweek == "Wednesday")    $dayweek = "miércoles";
        if($dayweek == "Thursday")     $dayweek = "jueves";
        if($dayweek == "Friday")       $dayweek = "viernes";
        if($dayweek == "Saturday")     $dayweek = "sábado";
        if($dayweek == "Sunday")       $dayweek = "domingo";

        $fechoraimp = "proceso ejecutado el ".$dayweek." ".date('d')." de ".$mesimp." de ".date('Y')." a las ".date('g:i a');
        return($fechoraimp);
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función productosxcatg
    // Parámetro de entrada:    $categoriaid --> Id de la categoría
    // Valor de retorno:        $numeroprod --> Número de productos de la categoría
    // Descripción: Función que determina el numero de productos asociados a una categoría
    ////////////////////////////////////////////////////////////////////////////////////////
    function productosxcatg($categoriaid)
    {
        $clase2 = new Sistema();

        $vsql8 = "SELECT COUNT(*) numeroprod FROM categoriasportafolioxproductos WHERE categoriaid = ".$categoriaid;
        $numeroprod = $clase2->SeleccionarUno($vsql8);

        return($numeroprod);
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función subcatg
    // Parámetro de entrada:    $padre --> Padre de la categoría
    // Valor de retorno:        $numcatg --> Número de sub categorías 
    // Descripción: Función que determina el número de sub categorías asociadas a una 
    //              categoría
    ////////////////////////////////////////////////////////////////////////////////////////    
    function subcatg($padre)
    {
        $clase2 = new Sistema();

        $vsql9 = "SELECT COUNT(*) numcatg FROM categoriasportafolio WHERE padre = ".$padre." AND categoriaid <> padre";
        $numcatg = $clase2->SeleccionarUno($vsql9);

        return($numcatg);
    }    

    echo $cont.$clase->PiePagina();
?>