<?PHP
    session_start(); 
    include("lib/Sistema.php");

    $clase = new Sistema();
    
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardareditado y guardarnuevo
    // Creación: 18/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opciones para incluir y modificar conceptos de nómina
    // Última modificación: Inclusión del campo que identifica que es una libranza
    //                      (23/11/2020)
    //                      Se incluyó el ámbito del concepto
    ////////////////////////////////////////////////////////////////////////////////////////
    if(($opcion == "guardareditado")||($opcion == "guardarnuevo"))
    {
        $conceptoid  = $_POST['conceptoid'];
        $codconcepto = strtoupper(trim($_POST['codconcepto']));
        $nomconcepto = strtoupper(trim($_POST['nomconcepto']));
        $tipodc      = $_POST['tipodc'];
        $esdeley     = $_POST['esdeley'];
        $ambito      = $_POST['ambito'];
        $formula     = $_POST['formula'];

        $eslibranza  = "";
        $eslicencia  = "";
        $montoocasional = "";
        $montopermanente = "";
        $recargo = "";
        

        switch($ambito)
        {
            case 'eslibranza':
                $eslibranza  = "CHECKED";
                break;            
            case 'eslicencia':
                $eslicencia  = "CHECKED";
                break;
            case 'montoocasional':
                $montoocasional = "CHECKED";
                break;
            case 'montopermanente':
                $montopermanente = "CHECKED";
                break;
            case 'recargo':
                $recargo = "CHECKED";
                break;
            default:
                break;
        }

        // Valido que todos los campos tengan datos
        if(($codconcepto == "")||($nomconcepto == "")||($formula == ""))
        {
            // $clase->Aviso(3,"Los datos código, nombre y formula no pueden estar vacíos, verifique por favor.");
            $clase->Aviso(2,"Los datos código, nombre y formula no pueden estar vacíos &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
            header("Location: conceptosnomina.php");
            exit();
        }
        else
        {
            // if(($eslibranza == "CHECKED")&&($eslicencia == "CHECKED"))
            // {
            //     $clase->Aviso(2,"El concepto no puede ser libranza y licencia a la vez &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
            //     header("Location: conceptosnomina.php");
            //     exit();
            // }
            // else
            // {
                // Opción para guardar un nuevo concepto
                if($opcion == "guardarnuevo")
                {
                    // Validación de que el código ya exista
                    $vsqlx = "SELECT COUNT(codconcepto) FROM conceptosnomina WHERE codconcepto ='".$codconcepto."'";
                    $valor = $clase->SeleccionarUno($vsqlx);

                    if($valor>=1)
                    {
                        $clase->Aviso(3,"El código <b> $codconcepto </b> ya existe, verifíquelo por favor");
                        header("Location: conceptosnomina.php");
                    }
                    else
                    {
                        // Validación de la existencia del nombre del concepto
                        $vsqlx = "SELECT COUNT(nomconcepto) FROM conceptosnomina WHERE nomconcepto ='".$nomconcepto."'";
                        $valordesc = $clase->SeleccionarUno($vsqlx);

                        if($valordesc>=1)
                        {
                            $clase->Aviso(3,"La descripción <b> $nomconcepto </b> ya existe, verifíquela por favor");
                            header("Location: conceptosnomina.php");
                        }
                        else
                        {
                            $vsql = "INSERT INTO conceptosnomina (codconcepto, nomconcepto, tipodc, esdeley, eslibranza, eslicencia, montoocasional, montopermanente, recargo, formula, creador, momento) 
                                          VALUES ('".$codconcepto."','".$nomconcepto."','".$tipodc."','".$esdeley."','".$eslibranza."','".$eslicencia."','".$montoocasional."',
                                                  '".$montopermanente."','".$recargo."','".$formula."','".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";
                            $cant = $clase->EjecutarSQL($vsql);
        
                            // valido que se almacenen los datos para emitir el mensaje correspondiente
                            if(mysql_affected_rows() < 1)                        
                                $clase->Aviso(3,"No se incluyó el concepto");
                            else
                                $clase->Aviso(1,"Concepto creado exitosamente");                                                
                        }
                    }
                }

                // Opción para modificar un periodo
                if($opcion == "guardareditado")
                {
                    // ---------------------------------------------------------------------------------------------- //
                    // Proceso para validar si el código introducido ya existe
                    $lb_codigodiferente=false;
                    $lb_codigonuevoexiste=false;
                    $valorcod = 0;

                    $codnuevo = trim($codconcepto);
                    $vsqly = "SELECT codconcepto FROM conceptosnomina WHERE conceptoid=".$conceptoid;
                    $codanterior = $clase->SeleccionarUno($vsqly);
                    
                    if($codnuevo!=$codanterior)
                        $lb_codigodiferente=true;

                    if($lb_codigodiferente)
                    {
                        // Validación de la existencia del código del concepto
                        $vsqlx = "SELECT COUNT(codconcepto) FROM conceptosnomina WHERE codconcepto ='".$codnuevo."'";
                        $valorcod = $clase->SeleccionarUno($vsqlx);

                        if($valorcod>=1)
                            $lb_codigonuevoexiste=true;
                    }
                    // ---------------------------------------------------------------------------------------------- //
                    // Proceso para validar si el nombre introducido ya existe
                    $lb_descripciondiferente=false;
                    $lb_descripcionnuevoexiste=false;
                    $valordes = 0;

                    $desnueva = trim($nomconcepto);
                    $vsqly = "SELECT nomconcepto FROM conceptosnomina WHERE conceptoid=".$conceptoid;
                    $desanterior = $clase->SeleccionarUno($vsqly);                    
                    
                    if($desnueva!=$desanterior)
                        $lb_descripciondiferente=true;

                    if($lb_descripciondiferente)
                    {
                        // Validación de la existencia del nombre del periodo
                        $vsqlx = "SELECT COUNT(nomconcepto) FROM conceptosnomina WHERE nomconcepto ='".$desnueva."'";
                        $valordes = $clase->SeleccionarUno($vsqlx);

                        if($valordes>=1)
                            $lb_descripcionnuevoexiste=true;
                    }

                    // ---------------------------------------------------------------------------------------------- //
                    // Ejecuto las validaciones
                    if(($lb_codigodiferente)&&($lb_codigonuevoexiste))
                    {
                        $clase->Aviso(3,"El código <b> $codnuevo </b> ya existe, verifíquelo por favor");
                        header("Location: conceptosnomina.php");
                    }
                    else
                    {
                        if(($lb_descripciondiferente)&&($lb_descripcionnuevoexiste))
                        {
                            $clase->Aviso(3,"La descripción <b> $nomconcepto </b> ya existe, verifíquela por favor");
                            header("Location: conceptosnomina.php");
                        }
                        else
                        {
                            $vsql = "UPDATE conceptosnomina SET 
                                            codconcepto = '".$codconcepto."', 
                                            nomconcepto = '".$nomconcepto."',
                                            tipodc = '".$tipodc."', 
                                            esdeley = '".$esdeley."', 
                                            eslibranza = '".$eslibranza."', 
                                            eslicencia = '".$eslicencia."',
                                            montoocasional = '".$montoocasional."',
                                            montopermanente = '".$montopermanente."',
                                            recargo = '".$recargo."',
                                            formula = '".$formula."' 
                                      WHERE conceptoid = ".$conceptoid."";
                            $clase->EjecutarSQL($vsql);
            
                            // valido que se almacenen los datos para emitir el mensaje correspondiente
                            if(mysql_affected_rows() < 1)
                                $clase->Aviso(3,"No se modificó el concepto");
                            else
                                $clase->Aviso(1,"Concepto modificado exitosamente");                        
                        }
                    }
                }            
                header("Location: conceptosnomina.php");
            // }
        }	 
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nuevo
    // Creación: 18/09/2020		última modificación: 26/02/2021
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción que pinta la ventana para incluir un nuevo concepto enviándolo 
    //              a la opción "guardarnuevo" para almacenarlo
    // Última modificación: Inclusión del campo que identifica que es una libranza
    //                      (23/11/2020)
    //                      Se incluyó la generación del código del concepto para ser 
    //                      propuesto y se incluyó el ámbito del concepto
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nuevo")
    {
        // Obtengo el código más alto
        $vsql = "SELECT MAX(codconcepto) AS ultcodigo FROM conceptosnomina";
        $ultcodigo = $clase->SeleccionarUno($vsql);

        // Genero el correlativo del código del concepto
        $numcod = intval($ultcodigo);
        $numcod += 1;
        $newcod = strval($numcod);

        // Se rellena con ceros en caso de ser necesario
        if(strlen($newcod)==1)      $newcod = "00".$newcod;
        if(strlen($newcod)==2)      $newcod = "0".$newcod;

        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/infventaspos.png" width="32" height="32" border="0"> </td>
                  <td width="1050"> <b>Nuevo concepto de n&oacute;mina</b> </td>
                  <td><a href="conceptosnomina.php"><input type="button" value="<<" class="button"></a></td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<center>
                <form action="?opcion=guardarnuevo" method="POST">
                <fieldset style="width: 530px; height: 480px;" class="grupos">
                <legend class="titgrupos"> Datos </legend>
                <table width="350">
                 <tr height="55">
                  <td> 
                   <label class="Texto12"> <b>C&oacute;digo</b></label><br> 
                   <input type="text" name="codconcepto" class="Texto15" size="10" maxlength="10" id="default" autocomplete="off" value="'.$newcod.'"> 
                  </td>
                 </tr>
                 <tr height="55">
                  <td> 
                   <label class="Texto12"> <b>Nombre:</b></label><br>
                   <input type="text" name="nomconcepto" class="Texto15" maxlength="50" size="50" autocomplete="off"> 
                  </td>
                 </tr>
                 <tr height="45">
                  <td width="20"> 
                   <label class="Texto12"> <b>Tipo de concepto:</b></label>
                   <select name="tipodc" id="tipodc" style="height:25px">
                    <option value="D" selected> Deduci&oacute;n </option>   
                    <option value="C"> Devengado </option>
                   </select>
                  </td>
                 </tr>
                 <tr height="45">
                  <td> 
                   <label class="Texto12"><b> Es de ley </b></label>
                   <input type="checkbox" name="esdeley" id="esdeley" value="CHECKED">
                  </td>
                 </tr>
                 <tr height="55">
                  <td>
                   <label class="Texto12"> <br> <b> &Aacute;mbito: </b> <br>
                   <input type="radio" name="ambito" value="eslibranza"> <label class="Texto12"> libranza <br>
                   <input type="radio" name="ambito" value="eslicencia"> <label class="Texto12"> licencia <br>
                   <input type="radio" name="ambito" value="montoocasional"> <label class="Texto12"> monto ocasional <br>
                   <input type="radio" name="ambito" value="montopermanente"> <label class="Texto12"> monto permanente <br>
                   <input type="radio" name="ambito" value="recargo"> <label class="Texto12"> recargo <br>
                  </td>
                 </tr>	
                 <tr height="55">
                  <td> 
                   <label class="Texto12"> <b>Formula:</b></label><br>
                   <input type="text" name="formula" class="Texto15" maxlength="150" size="50" autocomplete="off"> 
                  </td>
                 </tr>
                 <tr height="55">
                  <td align="center"><br><br> 
                   <input type="submit" value="aceptar" class="button blue"> 
                  </td>
                 </tr>
                </table>
                <br><br>
                </fieldset>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmacion
    // Creación: 18/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de un concepto de nómina
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmacion")
    {
        $conceptoid  = $_GET['conceptoid'];
        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
        $cont= '<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><b>Eliminar un concepto de n&oacute;mina</b><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center">
                   <label class="Texto12"> ¿Confirma que desea eliminar el concepto<br><b> '.$nomconcepto.'</b>? </label>                   
                   <br>
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br>
                   <form action="?opcion=eliminar" method="POST">
                   <input type="hidden" name="conceptoid" value="'.$conceptoid.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                   <a href="conceptosnomina.php" ><input type="button" value="CANCELAR" class="button blue"></a>
                   </form>
                   <br>
                  </td>
                 </tr>
                </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminar
    // Creación: 18/09/2020		última modificación: 23/11/2020
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción que elimina físicamente un concepto de nómina
    // Última modificación: Se incluyó la validación de que el concepto no haya sido 
    //                      utilizado algún periodo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminar")
    {
        $conceptoid = $_POST['conceptoid'];

        // Inicializo las variables
        $valordetnom = 0;
        $valorhistorico = 0;

        // Valido que este concepto no haya sido procesado en algún periodo para un empleado
        $vsql = "SELECT count(*) AS valordetnom 
                   FROM detallenomina 
                  WHERE conceptoid = ".$conceptoid;
        $valordetnom = $clase->SeleccionarUno($vsql);

        // Chequeo también en le histórico
        $vsql = "SELECT count(*) AS valorhistorico 
                   FROM hisdetallenomina 
                  WHERE conceptoid = ".$conceptoid;
        $valorhistorico = $clase->SeleccionarUno($vsql);

        if(($valordetnom>0)||($valorhistorico>0))
        {
            $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
            $clase->Aviso(3,"No se puede eliminar el concepto $nomconcepto porque ya ha sido utilizado en periodos anteriores");
        }
        else
        {
            $vsql = "DELETE FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
            $clase->EjecutarSQL($vsql);
    
            // valido que se almacenen los datos para emitir el mensaje correspondiente
            if(mysql_affected_rows() < 1)
                $clase->Aviso(3,"No se eliminó el concepto $nomconcepto");
            else
                $clase->Aviso(1,"Concepto $nomconcepto eliminado exitosamente");
        }
        header("Location: conceptosnomina.php");
    }
  
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: detalles
    // Creación: 18/09/2020		última modificación: 26/02/2021
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción que pinta la ventana de modificación de un concepto llevándolo a 
    //              la opción "guardareditado" donde almacena los datos
    // Última modificación: Inclusión del campo que identifica que es una libranza
    //                      (23/11/2020)
    //                      Se incluyó el ámbito del concepto
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "detalles")
    {
        $conceptoid = $_GET['conceptoid'];
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/infventascaja.png" width="32" height="32" border="0"> </td>
                  <td width="990"> <b>Modificar concepto de n&oacute;mina </b></td>
                  <td width="20"> &nbsp; </td>
                  <td width="24"> <a href="conceptosnomina.php"><input type="button" value="<<" class="button blue"></a> </td>
                  <td width="10"> &nbsp; </td>
                 </tr> 
                </table>
                <br>
                <center>';
        
        $vsql = "SELECT codconcepto, nomconcepto, tipodc, esdeley, eslibranza, eslicencia, montoocasional, montopermanente, recargo, formula 
                   FROM conceptosnomina 
                  WHERE conceptoid = ".$conceptoid;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        if($row = mysql_fetch_array($result))
        {
            $opteslibranza = "";
            $opteslicencia = "";
            $optmontoocasional = "";
            $optmontopermanente = "";
            $optrecargo = "";

            if($row['eslibranza'] == "CHECKED")          $opteslibranza = "CHECKED";
            if($row['eslicencia'] == "CHECKED")          $opteslicencia = "CHECKED";
            if($row['montoocasional'] == "CHECKED")      $optmontoocasional = "CHECKED";
            if($row['montopermanente'] == "CHECKED")     $optmontopermanente = "CHECKED";
            if($row['recargo'] == "CHECKED")             $optrecargo = "CHECKED";

            $auxtipodc = $row['tipodc'];
            $cont.='<center>
                    <form action="?opcion=guardareditado" method="POST">
                    <input type="hidden" name="conceptoid" value="'.$conceptoid.'">
                    <fieldset style="width: 530px; height: 460px;" class="grupos">
                    <legend class="titgrupos"> Datos </legend>
                    <table width="350">
                     <tr height="45">
                      <td> 
                       <label class="Texto12"> <b>C&oacute;digo</b></label><br> 
                       <input type="text" name="codconcepto" class="Texto15" size="10" maxlength="10" id="default" value="'.$row['codconcepto'].'" autocomplete="off"> 
                      </td>
                     </tr>
                     <tr height="45">
                      <td> 
                       <label class="Texto12"> <b>Nombre:</b></label><br>
                       <input type="text" name="nomconcepto" class="Texto15" maxlength="50" size="50" value="'.$row['nomconcepto'].'" autocomplete="off"> 
                      </td>
                     </tr>
                     <tr height="45">
                      <td width="20"> <label class="Texto12"> <b>Tipo de concepto:</b></label>
                       <select name="tipodc" id="tipodc" style="height:25px">';

            // Aquí determino qué tipo de documento es
            if($auxtipodc=="D")
            {
                $cont.='<option value="D" selected> Deduci&oacute;n </option>   
                        <option value="C"> Devengado </option>';
            }
            else
            {
                $cont.='<option value="D"> Deduci&oacute;n </option>   
                        <option value="C" selected> Devengado </option>';
            }

            $cont.='   </select>
                      </td>
                     </tr>
                     <tr height="45">
                      <td> 
                       <label class="Texto12"> <b> Es de ley </b> </label> 
                       <input type="checkbox" name="esdeley" value="CHECKED" '.$row['esdeley'].'>
                      </td>
                     </tr>
                     <tr height="55">
                      <td>
                       <label class="Texto12"> <br> <b> &Aacute;mbito: </b> <br>
                       <input type="radio" name="ambito" value="eslibranza" '.$opteslibranza.'> <label class="Texto12"> libranza <br>
                       <input type="radio" name="ambito" value="eslicencia" '.$opteslicencia.'> <label class="Texto12"> licencia <br>
                       <input type="radio" name="ambito" value="montoocasional" '.$optmontoocasional.'> <label class="Texto12"> monto ocasional <br>
                       <input type="radio" name="ambito" value="montopermanente" '.$optmontopermanente.'> <label class="Texto12"> monto permanente <br>
                       <input type="radio" name="ambito" value="recargo" '.$optrecargo.'> <label class="Texto12"> recargo <br>
                      </td>
                     </tr>
                     <tr height="55">
                      <td> 
                       <label class="Texto12"> <b>Formula:</b></label><br> 
                       <input type="text" class="Texto15" name="formula" size="50" maxlenght="150" value="'.$row['formula'].'">
                      </td>
                     </tr>
                    </table>
                    <table width="350">
                     <tr height="45">
                      <td align="center">
                       <br><br> 
                       <input type="submit" value="aceptar" class="button blue"> 
                      </td>
                     </tr>
                    </table>
                    <br></fieldset>';
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtro
    // Creación: 22/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para hacer una búsqueda avanzada por uno 
    //              o varios criterios
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "filtro")
    {
        $cont ='<form action="?opcion=filtrar" method="POST" name="x">
                <table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Filtrar B&uacute;squeda de conceptos </b> </td> 
                 </tr> 
                </table>
                <table width="400">
                 <tr class="TablaDocsImPar">
                  <td width="180" align="right"> C&oacute;digo:&nbsp </td> 
                  <td width="220"><input type="text" class="Texto11" name="codconcepto" size="10" maxlenght="10" value="" style="text-transform:uppercase!Important;" autocomplete="off"></td>	
                 </tr>	
                 <tr class="TablaDocsImPar">
                  <td width="180" align="right"> Nombre:&nbsp </td> 
                  <td width="220"><input type="text" class="Texto11" name="nomconcepto" size="40" maxlenght="50" value="" style="text-transform:uppercase!Important;" autocomplete="off"></td>
                 </tr>	
                 <tr class="TablaDocsImPar">
                  <td width="180" align="right"> Tipo de &nbsp;<br>concepto: &nbsp; </td>	
                  <td width="220">
                   <select name="tipodc" id="tipodc">
                    <option value="T" selected> Todos </option> 
                    <option value="D"> Deducido </option>
                    <option value="C"> Cr&eacute;dito </option>
                   </select>
                  </td>	
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="180" align="right"> Es de ley: &nbsp; </td>
                  <td width="220">
                   <select name="esdeley" id="esdeley">
                    <option value="T" selected> Todos </option>   
                    <option value="S"> S&iacute; </option>
                    <option value="N"> No </option>
                   </select>
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="180" align="right"> Formula: &nbsp;</td>
                  <td width="220"> <input type="text" name="formula" class="Texto11" size="40" maxlength="150" autocomplete="off"></td>
                 </tr>
                </table>
                <center>
                <br>
                <table width="400">
                 <input type="submit" value="filtrar conceptos" class="button red">
                </table>
                </form><br>';
        echo $cont;
        exit();
    }

    ///////////////////////////////////////////////////////////////////////////////////////////  
    // Opción: filtrar
    // Creación: 22/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que aplica los criterios de filtro para la consulta
    // Última modificación: 
    ///////////////////////////////////////////////////////////////////////////////////////////  
    if($opcion == "filtrar")
    {
        // Variables para filtrar la consulta
        $codconcepto = strtoupper($_POST['codconcepto']);
        $nomconcepto = strtoupper($_POST['nomconcepto']);
        $tipodc 	 = $_POST['tipodc'];
        $esdeley 	 = $_POST['esdeley'];
        $formula 	 = $_POST['formula'];

        $cwhere = "conceptoid > 0 ";    // Inicialización de la variable para filtrar la consulta

        // Aplicación de los filtros seleccionados
        if(strlen($codconcepto)>0)      $cwhere.=" AND codconcepto LIKE '%".$codconcepto."%' "; 
        if(strlen($nomconcepto)>0)	    $cwhere.=" AND nomconcepto LIKE '%".$nomconcepto."%' "; 
        if($tipodc=="D")	            $cwhere.=" AND tipodc = 'D' "; 
        if($tipodc=="C")	            $cwhere.=" AND tipodc = 'C' ";
        if($esdeley=="S")               $cwhere.=" AND esdeley = 'CHECKED' "; 
        if($esdeley=="N")	            $cwhere.=" AND esdeley = '' ";
        if(strlen($formula)>0)	        $cwhere.=" AND formula LIKE '%".$formula."%' "; 

        // Construcción de la consulta
        $vsql = "SELECT * FROM conceptosnomina WHERE ".$cwhere." ORDER BY conceptoid";
        
        // Envío de la información
        $_SESSION['SQL_CONCEPTOSNOM'] = $vsql;
        header("Location: conceptosnomina.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: encontrar
    // Creación: 18/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que encuentra un concepto buscándolo por código o descripción
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "encontrar")
    {
        $criterio  = $_POST['criterio'];
        $arreglado = str_replace(" ","%",$criterio);
        $vsql = "SELECT conceptoid, codconcepto, nomconcepto, tipodc, esdeley, formula 
                   FROM conceptosnomina
                  WHERE codconcepto LIKE '%".$criterio."%' OR 
                        nomconcepto LIKE '%".$criterio."%' 
               ORDER BY codconcepto ASC";
        $_SESSION['SQL_CONCEPTOSNOM'] = $vsql;
        header("Location: conceptosnomina.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nofiltro
    // Creación: 18/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que anula la búsqueda realizada por la opción “encontrar”
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nofiltro")
    {
        $vsql = "SELECT conceptoid, codconcepto, nomconcepto, tipodc 
                   FROM conceptosnomina 
               ORDER BY codconcepto ASC";
        $_SESSION['SQL_CONCEPTOSNOM'] = "";
        header("Location: conceptosnomina.php");
    }
  
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ""
    // Creación: 18/09/2020		última modificación: 23/11/2020
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana principal del formulario
    // Última modificación: Inclusión de la búsqueda simple y avanzada (22/09/2020)
    //                      Ajuste de los títulos de los conceptos
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "")
    {
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/infventaspos.png" width="32" height="32" border="0"> </td>
                  <td width="880"> <b>Conceptos de n&oacute;mina</b> </td>
                  <td width="30"><a href="?opcion=filtro" rel="facebox"><img src="images/iconos/vistaprevia.png" width="32" height="32" border="0"  title="búsqueda avanzada"> </a> </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30"> <a href="?opcion=nuevo"> <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0" title="nuevo concepto"> </a> </td>
                  <td width="10"> &nbsp; </td>
                  <form action="?opcion=encontrar" method="POST" name="x">
                  <td> <input type="text" name="criterio" size="20" style="width:200px;height:25px;" placeholder="Criterio a Buscar" tabindex="1" id="default"> </td>
                  <td width="10"> &nbsp; </td>
                  <td> <input type="submit" value="Encontrar" class="button"></form> </td>';

        if($_SESSION['SQL_CONCEPTOSNOM'] != "")
            $cont.='<td width="10"> <a href="?opcion=nofiltro"> <img src="images/basicas/nofiltro.png"> </a> </td>';
  
        $cont.='  <td width="8"> &nbsp; </td>
                 </tr>	
                </table>';

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:24px;">
                   <td width="20"> &nbsp; </td>
                   <td width="80"> C&oacute;digo </td>
                   <td width="320"> Nombre </td>			
                   <td width="85"> Tipo </td>
                   <td width="75" align="center"> Es de ley </td>	
                   <td width="55"> &nbsp; </td>
                   <td width="50"> &nbsp; </td>
                   <td width="50"> &nbsp; </td>
                   <td width="45"> &nbsp; </td>
                   <td width="45"> &nbsp; </td>
                   <td width="45"> &nbsp; </td>
                   <td width="50"> &nbsp; </td>
                   <td width="50"> &nbsp; </td>
                   <td width="30"> &nbsp; </td>
                   <td width="30"> &nbsp; </td>							 	 				 
                   <td width="30"> &nbsp; </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:600px; overflow-Y:scroll">';

        if($_SESSION['SQL_CONCEPTOSNOM'] == "")
            $vsql = "SELECT conceptoid, codconcepto, nomconcepto, tipodc, esdeley, formula   
                       FROM conceptosnomina 
                   ORDER BY conceptoid LIMIT 0,".$_SESSION["NUMREGISTROSXCONSULTA"];
        else
            $vsql = $_SESSION['SQL_CONCEPTOSNOM'];

        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        $i = 0;
        while($row = mysql_fetch_array($result)) 
        {
            // Asigno el tipo de documento
            if($row['tipodc']=="D")
                $tipodc="Deducción";
            
            if($row['tipodc']=="C")
                $tipodc="Devengado";

            if($row['tipodc']=="")
                $tipodc="No especifica";

            // Asigno el valor si es de ley
            if($row['esdeley']=="CHECKED")
                $esdeley="Sí";
            else
                $esdeley="No";

            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';
                    
            $cont.=' <td width="20"> &nbsp; </td>
                     <td width="90"> '.$row['codconcepto'].' </td>
                     <td width="340"> <b>'.$row['nomconcepto'].'</b> </td>
                     <td width="120"> '.$tipodc.' </td>
                     <td width="55"> '.$esdeley.' </td>
                     <td width="30"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="40"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="30"> &nbsp; </td> 
                     <td width="30" align="center"> &nbsp; </td>
                     <td width="30">
				      <a href="?opcion=confirmacion&conceptoid='.$row['conceptoid'].'" rel="facebox"> <img src="images/basicas/iconoborrar.png" title="Eliminar" border="0" width="20" height="20"> </a>
                     </td> 
                     <td width="30" align="center">
                      <a href="?opcion=detalles&conceptoid='.$row['conceptoid'].'"> <img src="images/basicas/iconobuscar.png" title="Modificar Periodo" border="0" width="20" height="20"> </a>
                     </td> 
                     <td width="10"> &nbsp; </td> 
                    </tr>';
        }
        $cont.=' </tbody>
                </table>';

        // pie de página
        $cont.= '<table width="100%"> <tr class="TituloTabla"> <td width="1608"> &nbsp; </td> </tr> </table>';                
    }
    ////////////////////////////////
    echo $cont.$clase->PiePagina();
?> 