<?PHP
    session_start(); 
    include("lib/Sistema.php");
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardareditado y guardarnuevo
    // Creación: 31/08/2020		última modificación: 06/01/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que valida y guarda los cambios en la tabla eps
    // Última modificación: Inclusión del campo sección
    ////////////////////////////////////////////////////////////////////////////////////////
    if(($opcion == "guardareditado")||($opcion == "guardarnuevo"))
    {
        $epsid  = $_POST['epsid'];
        $codeps = $_POST['codeps'];
        $descripcioneps = strtoupper($_POST['descripcioneps']);

        // Valido que sean introducidos los datos necesarios
        if(($codeps == "")||($descripcioneps == ""))
        {
            $clase->Aviso(2,"El código y la descripción no pueden estar vacíos &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
            header("Location: eps.php");
            exit();
        }
        else
        {
            if($opcion == "guardarnuevo")
            {
                // Validación de que el código ya exista
                $vsqlx = "SELECT COUNT(codeps) FROM eps WHERE codeps ='".trim($codeps)."'";
                $valor = $clase->SeleccionarUno($vsqlx);

                if($valor>=1)
                {
                    $clase->Aviso(2,"El código <b> $codeps </b> ya existe &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
                    header("Location: eps.php");
                    exit();
                }
                else
                {
                    // Validación de la existencia de descripción de la eps
                    $vsqlx = "SELECT COUNT(descripcioneps) FROM eps WHERE descripcioneps ='".trim($descripcioneps)."'";
                    $valor = $clase->SeleccionarUno($vsqlx);

                    if($valor>=1)
                    {
                        $clase->Aviso(2,"La descripción <b> $descripcioneps </b> ya existe &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
                        header("Location: eps.php");
                        exit();
                    }
                    else
                    {
                        // Almaceno la nueva EPS
                        $vsql = "INSERT INTO eps (codeps,descripcioneps) values ('".$codeps."','".$descripcioneps."')";
                        $cant = $clase->EjecutarSQL($vsql);

                        // valido que se almacenen los datos para emitir el mensaje correspondiente
                        if(mysql_affected_rows() < 1)
                            $clase->Aviso(3,"No se incluyó la EPS");
                        else
                            $clase->Aviso(1,"EPS creada exitosamente");
                    }
                }
            }

            if($opcion == "guardareditado")
            {
                // ---------------------------------------------------------------------------------------------- //
                // Proceso para validar si el código introducido ya existe
                $lb_codigodiferente = false;
                $lb_codigonuevoexiste = false;
                $valorcod = 0;

                $codnuevo = trim($codeps);
                $vsqly = "SELECT codeps FROM eps WHERE epsid=".$epsid;
                $codanterior = $clase->SeleccionarUno($vsqly);
                
                if($codnuevo!=$codanterior)
                    $lb_codigodiferente = true;

                if($lb_codigodiferente)
                {
                    // Validación de la existencia del código del concepto
                    $vsqlx = "SELECT COUNT(codeps) FROM eps WHERE codeps ='".$codnuevo."'";
                    $valorcod = $clase->SeleccionarUno($vsqlx);

                    if($valorcod>=1)
                        $lb_codigonuevoexiste = true;
                }
                // ---------------------------------------------------------------------------------------------- //
                if($lb_codigonuevoexiste)
                {
                    $clase->Aviso(2,"El código <b> $codeps </b> ya existe &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
                    header("Location: eps.php");
                    exit();
                }
                else
                {
                    // Proceso para validar si la descripción introducida ya existe
                    $lb_descripciondiferente = false;
                    $lb_descripcionnuevoexiste = false;
                    $valordes = 0;

                    $desnueva = trim($descripcioneps);
                    $vsqly = "SELECT descripcioneps FROM eps WHERE epsid = ".$epsid;
                    $desanterior = $clase->SeleccionarUno($vsqly);
                    
                    if($desnueva!=$desanterior)
                        $lb_descripciondiferente = true;

                    if($lb_descripciondiferente)
                    {
                        // Validación de la existencia del código del periodo
                        $vsqlx = "SELECT COUNT(descripcioneps) FROM eps WHERE descripcioneps ='".$desnueva."'";
                        $valordes = $clase->SeleccionarUno($vsqlx);

                        if($valordes>=1)
                            $lb_descripcionnuevoexiste = true;
                    }
                    
                    if(($lb_descripciondiferente)&&($lb_descripcionnuevoexiste))
                    {
                        $clase->Aviso(2,"La descripción <b> $descripcioneps </b> ya existe &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
                        header("Location: eps.php");
                        exit();
                    }
                    else
                    {
                        // Almaceno los cambios de la EPS
                        $vsql = "UPDATE eps SET
                                        codeps  = '".$codeps."', 
                                        descripcioneps  = '".$descripcioneps."'
                                  WHERE epsid = ".$epsid;
                        $clase->EjecutarSQL($vsql);
                        
                        // valido que se almacenen los datos para emitir el mensaje correspondiente
                        if(mysql_affected_rows() < 1)
                            $clase->Aviso(3,"No se modificó la EPS");
                        else
                            $clase->Aviso(1,"EPS modificada exitosamente");
                    }
                }
            }
        }
        header("Location: eps.php");
    }
  
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: nuevo
    // Creación: 31/08/2020		última modificación: 06/01/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para ingresar nuevas EPS’s
    // Última modificación: Inclusión del campo sección
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nuevo")
    {
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/profesionales.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b>Nueva Entidad Promotora de Salud </b></td>
                  <td align="right"><a href="eps.php"><input type="button" value="<<" class="button"></a></td>
                  <td width="8"> &nbsp; </td>
                 </tr>	 			   
                </table>';
        
        $cont.='<br><center>                
                <fieldset style="width: 530px; height: 220px;" class="grupos">
                <legend class="titgrupos"> Datos </legend>
                <form action="?opcion=guardarnuevo" method="POST">
                <table width="200">
                 <tr height="55"><td> <label class="Texto12"> <b> C&oacute;digo: </b></label><br>
                  <input type="text" autocomplete="off" name="codeps" class="Texto15"  maxlength="10" size="10"> </td>
                 </tr>
                 <tr height="55"><td> <label class="Texto12"> <b> Descripci&oacute;n: </b></label>
                  <br>
                  <input type="text" autocomplete="off" name="descripcioneps" class="Texto15"  maxlength="100" size="50"> </td>
                 </tr>
                 <tr height="55">
                  <td align="center"><br><br> <input type="submit" value="aceptar" class="button blue"> </td>
                 </tr>			                  
                </table>
                </form>
                <br>
                <br>
                </fieldset>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: detalles
    // Creación: 01/09/2020		última modificación: 06/01/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para modificar nuevas EPS’s
    // Última modificación: Inclusión del campo sección
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "detalles")
    {
        $epsid = $_GET['epsid'];
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/profesionales.png" width="32" height="32" border="0"> </td>
                  <td width="945"> <b>Modificar Entidad Promotora de Salud </b></td>
                  <td> <a href="eps.php"><input type="button" value="<<" class="button"></a> </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';
        
        $vsql = "SELECT * FROM eps WHERE epsid=".$epsid;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);

        if($row = mysql_fetch_array($result))
        {
            $cont.='<br><br><br><center>
                    <form action="?opcion=guardareditado" method="POST">
                    <input type="hidden" name="epsid" value="'.$epsid.'">                    
                    <fieldset style="width: 530px; height: 220px;" class="grupos">
                    <legend class="titgrupos"> Datos </legend>
                    <table width="400">                      
                     <tr height="55">
                      <td> 
                       <label class="Texto12"> <b>C&oacute;digo: </b></label><br> 
                       <input type="text" autocomplete="off" name="codeps" class="Texto15" size="10" maxlength="10" value="'.$row['codeps'].'"> 
                      </td>
                     </tr>                      
                     <tr height="55">
                      <td> 
                       <label class="Texto12"> <b>Descripci&oacute;n: </b></label><br>
                       <input type="text" autocomplete="off" name="descripcioneps" class="Texto15" maxlength="100" size="50" value="'.$row['descripcioneps'].'"> 
                      </td>
                     </tr>
                     <tr height="55">
                      <td align="center">
                       <br><br> 
                       <input type="submit" value="aceptar" class="button blue"> 
                      </td>
                     </tr>
                    </table>
                    </form> 
                    <br><br>
                    </fieldset>';
        }
        mysql_free_result($result);
        mysql_close($conex);
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: encontrar
    // Creación: 02/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para buscar por código o descripción una o varias EPS’s
    // Última modificación:
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "encontrar")
    {
        $criterio = $_POST['criterio'];
        $vsql = "SELECT * FROM eps WHERE codeps like '%".$criterio."%' OR descripcioneps like '%".$criterio."%' ORDER BY epsid ASC Limit 0,".$_SESSION["NUMREGISTROSXCONSULTA"];
        $_SESSION['SQL_EPS'] = $vsql;
        header("Location: eps.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: nofiltro
    // Creación: 03/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para restablecer todas las EPSs en la ventana principal
    // Última modificación:
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nofiltro")
    {
        $criterio = $_POST['criterio'];
        $vsql = "SELECT * FROM eps ORDER BY epsid ASC limit 0,30";
        $_SESSION['SQL_EPS'] = "";
        header("Location: eps.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ""
    // Creación: 31/08/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana principal del formulario de EPS
    // Última modificación:
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "")
    {
        if(($_SESSION["ROL"] == 'SAD')||($_SESSION["ROL"] == 'SUP'))
        {
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/profesionales.png" width="32" height="32" border="0"> </td>
                      <td width="800"> <b>Entidades Promotoras de Salud EPS</b> </td>
                      <td width="10"> 
                       <a href="?opcion=epspdf" title="informe de eps en pdf" target="_blank"> 
                        <img src="images/iconos/exportarpdf2.png" border="0"> 
                       </a> 
                      </td>
                      <td width="15"> &nbsp; </td>
                      <td width="10"> 
                       <a href="?opcion=epsxls" title="informe de eps en excel" target="_blank"> 
                        <img src="images/iconos/exportarexcel2.png" border="0"> 
                       </a> 
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> <a href="?opcion=nuevo"> <img src="images/basicas/icononuevo.png" border="0"> </a> </td>
                      <form action="?opcion=encontrar" method="POST" name="x">
                      <td> <input type="text" name="criterio" size="30" placeholder="Criterio a Buscar" tabindex="1" id="default"> </td>
                      <td> <input type="submit" value="Encontrar" class="button"></form> </td>';
          
            if($_SESSION['SQL_EPS'] != "")
                $cont.='<td width="10"> <a href="?opcion=nofiltro"> <img src="images/basicas/nofiltro.png"> </a> </td>';

            $cont.='  <td width="8"> &nbsp; </td>
                     </tr>
                    </table>';
      
            if($_SESSION['SQL_EPS'] == "")
                $vsql = "SELECT * FROM eps ORDER BY epsid ASC";
            else
                $vsql = $_SESSION['SQL_EPS'];

            $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                    <table width="100%" class="sortable">
                    <thead> 
                     <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;"> 
                      <td width="15"> &nbsp; </td>
                      <td width="150" align="left"> C&oacute;digo </td>				 
                      <td width="350" align="left"> Descripci&oacute;n </td>
                      <td width="150" align="left"> &nbsp; </td>			
                      <td width="350" align="left"> &nbsp; </td>		
                      <td width="50" align="left"> &nbsp; </td>	
                      <td width="45"> &nbsp; </td>
                      <td width="45"> &nbsp; </td>				 
                      <td width="45"> &nbsp; </td>
                     </tr>
                    </thead>
                    <tbody style="display:block; width:1050; height:690px; overflow-Y:scroll">';
          
            $i = 0;      
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            while($row = mysql_fetch_array($result)) 
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
                  
                $cont.=' <td width="15"> &nbsp; </td>
                         <td width="140"> '.$row['codeps'].' </td>
                         <td width="360"> <b>'.$row['descripcioneps'].'</b> </td>
                         <td width="150"> &nbsp; </td>
                         <td width="350"> &nbsp; </td>
                         <td width="30"> <a href="?opcion=confirmacion&epsid='.$row['epsid'].'" rel="facebox"><img src="images/basicas/iconoborrar.png" title="Eliminar" border="0"></a> </td>
                         <td width="35"> <a href="?opcion=detalles&epsid='.$row['epsid'].'"> <img src="images/basicas/iconobuscar.png" border="0"> </td>
                        </tr>';
            }
        
            $cont.='</tbody> 
                    </table> 
                    <br>';
            
            mysql_free_result($result);
            mysql_close($conex);
        }
        else
        {
            $clase->Aviso(3,'No tiene permisos suficientes para realizar esta operación');
            header("Location: principal.php");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmacion
    // Creación: 30/08/2020		última modificación: 18/09/2020
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para confirmar la eliminación de una EPS
    // Última modificación: Se incluyó la impresión de la descripción de la EPS
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmacion")
    {
        $epsid = $_GET['epsid'];
        $descripcion  = $clase->BDLockup($epsid,'eps','epsid','descripcioneps');
        $cont= '<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><b>Eliminar EPS</b><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"> ¿Confirma que desea eliminar la EPS<br><b> '.$descripcion.'</b>? <br></td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br>
                   <form action="?opcion=eliminar" method="POST">
                   <input type="hidden" name="epsid" value="'.$epsid.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                   <a href="eps.php" ><input type="button" value="CANCELAR" class="button blue"></a>
                   </form>
                   <br>
                  </td>
                 </tr>
                </table><br>';
        echo $cont;
        exit();
    }

    ///////////////////////////////////////////////////////////////////////////
    // Opción: eliminar
    // Creación: 30/08/2020		última modificación: 30/08/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para eliminar una EPS
    // Última modificación: Validación de la no eliminación de eps que tienen 
    //                      empleados asociadas a ella (08/09/2020)
    //                      Validación de la no eliminación del régimen 
    //                      especial
    ///////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminar")
    {
        $epsid = $_POST['epsid'];
        $descripcioneps = $clase->BDLockup($epsid,'eps','epsid','descripcioneps');

   	  	// Validación de que la EPS ya exista
        $vsqlx = "SELECT COUNT(epsid) FROM terceros WHERE epsid = '".$epsid."'";
        $valor = $clase->SeleccionarUno($vsqlx);
   
        if($valor>=1)
            $clase->Aviso(3,"No se puede eliminar la EPS $descripcioneps porque existen $valor empleados asociados a ella");
        else
        {
            if($epsid==37)
                $clase->Aviso(3,"No se puede eliminar la EPS");
            else
            {
                $vsql = "DELETE FROM eps WHERE epsid=".$epsid;
                $clase->EjecutarSQL($vsql);
    
                // valido que se almacenen los datos para emitir el mensaje correspondiente
                if(mysql_affected_rows() < 1)
                    $clase->Aviso(3,"No se eliminó la EPS $descripcioneps");
                else
                    $clase->Aviso(1,"EPS $descripcioneps eliminada exitosamente");
            }
        }
        header("Location: eps.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: epsxls
    // Creación: 16/01/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera la salida a Excel de las eps
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "epsxls")
    {
        $vsql = $_SESSION['SQL_EPS'];
        if($vsql == "")         $vsql = "SELECT * FROM eps ORDER BY epsid ASC";

        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("EPS - DROPOS")
                                     ->setSubject("EPS - DROPOS")
                                     ->setDescription("EPS - DROPOS")
                                     ->setKeywords("EPS - DROPOS")
                                     ->setCategory("Categoria General");        
        
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'INFORME DE EPS')
                    ->setCellValue('A3', 'CODIGO')
                    ->setCellValue('B3', 'NOMBRE');
                 
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $i = 4;
        while($row = mysql_fetch_array($result))
        {
            $codeps = $row['codeps'];
            if(substr($codeps,0,1) == "0")            $codeps="'".$codeps;

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $codeps)
                        ->setCellValue('B'.$i, $row['descripcioneps']);
            $i++;
        }

        $rangoEncabezado = 'A3:B3';
        $rangoCeldas     = 'A3:B'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //        
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('eps');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //                
        $nombrearcexcel = "eps.xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: cargospdf
    // Creación: 16/01/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera la salida en pdf de las eps
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "epspdf")
    {
        // Traducción al español del mes que devuelve la función date()
        $mesimp = date('F');
        if($mesimp=="January")       $mesimp = "Enero";
        if($mesimp=="February")      $mesimp = "Febrero";
        if($mesimp=="March")         $mesimp = "Marzo";
        if($mesimp=="April")         $mesimp = "Abril";
        if($mesimp=="May")           $mesimp = "Mayo";
        if($mesimp=="June")          $mesimp = "Junio";
        if($mesimp=="July")          $mesimp = "Julio";
        if($mesimp=="August")        $mesimp = "Agosto";
        if($mesimp=="September")     $mesimp = "Septiembre";
        if($mesimp=="October")       $mesimp = "Octubre";
        if($mesimp=="November")      $mesimp = "Noviembre";
        if($mesimp=="December")      $mesimp = "Diciembre";

        // Procedo a construir el encabezado del recibo
        ini_set("memory_limit","200M");
        require('lib/fpdf/fpdf.php');
        $pdf=new FPDF();
        
        // Página nueva
        $pdf->AddPage("");
        $pagina = 1;

        // Logo Dromedicas
        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

        // Imprimo el encabezado del informe
        $x = 25;
        $y = 13;
        $pdf->SetFont('Arial','B',10);
        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
        $pdf->Text($x,$y,$enc);

        // Fecha y hora de impresión
        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

        $pdf->SetFont('Arial','',8);
        $pdf->Text($x+124,$y,$fechoraimp);

        $pdf->SetFont('Arial','B',10);
        $enc= "INFORME DE EPS";               $pdf->Text($x,$y+5,$enc);

        // Encabezado del informe
        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(5,26,200,8,'F');

        $pdf->SetFont('Arial','B',9);
        $enc= "CODIGO";                         $pdf->Text($x-17,$y+18,$enc);
        $enc= "NOMBRE";                         $pdf->Text($x+17,$y+18,$enc);

        $vsql = $_SESSION['SQL_EPS'];
        if($vsql == "")         $vsql = "SELECT * FROM eps ORDER BY epsid ASC";
        
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $x = 8;
        $y = 39;
        $i = 0;
        $linea = 0;
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%38==0)
            {
                $pdf->AddPage("");
                $pagina++;

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

                // Imprimo el encabezado del informe
                $x = 25;
                $y = 13;
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+124,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "INFORME DE EPS";               $pdf->Text($x,$y+5,$enc);

                // Encabezado del informe
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(5,26,200,8,'F');

                $pdf->SetFont('Arial','B',9);
                $enc= "CODIGO";                         $pdf->Text($x-17,$y+18,$enc);
                $enc= "NOMBRE";                         $pdf->Text($x+17,$y+18,$enc);

                $x = 8;
                $y = 39;
            }
            $linea++;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x,$y,$row['codeps']);
            $pdf->Text($x+34,$y,$row['descripcioneps']);

            $y+=6;            
        }
        $pdf->Output();
    }

    // ------------------------------------ //
    echo $cont.$clase->PiePagina();
?> 