<?PHP
/*
  error_reporting(E_ALL);
  ini_set('display_errors', TRUE);
  ini_set('display_startup_errors', TRUE);
*/

  /////////////////////////////////////////////////////////////////////////  
  /// Impresion de la Planilla de Cierre Definitivo de Caja
  /////////////////////////////////////////////////////////////////////////  
  function PlanillaCierreDefinitivo($cierreid)
  {
	 $clase = new Sistema();
 	 $diaoperativo = $clase->BDLockup($cierreid,'cierres','cierreid','diaoperativo');	
     $momcierre    = $clase->BDLockup($cierreid,'cierres','cierreid','momento');		 
	 $nomoperador  = $_SESSION['USERNAME'];
	 
	 $sucid  = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid');	 
	 $nomsuc = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','descripcion');	 	 
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
	 $nitempresa = $_SESSION['G_NIT_EMPRESA'];
	 $cont.=  Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).'     '.$nomempresa.Chr(13).Chr(10);	
	 $cont.= '           '.$nitempresa.Chr(13).Chr(10);		 
 
     $cont.= ' **** CIERRE DE CAJA DEFINITIVO  ****  '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'COMPROBANTE DE CIERRE No. '.str_pad($cierreid,4,"0",STR_PAD_BOTH).Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'MOMENTO DEL CIERRE : '.substr($momcierre,0,16).Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= '      DIA OPERATIVO : '.$diaoperativo.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= ' USUARIO : '.substr($nomoperador,0,28).Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	 $cont.= str_pad('SUCURSAL : '.$nomsuc,42," ",STR_PAD_BOTH).Chr(13).Chr(10);		 
     $cont.= '---------------------------------------'.Chr(13).Chr(10).Chr(13).Chr(10);          

     //// Descripcion del Cuadre de Caja
	 ///// Efectivo
	 $vsqlventas = "SELECT SUM(DV.valorfp1) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                WHERE D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."'";
	 $ventas     = $clase->SeleccionarUno($vsqlventas);
	 ///// Tarjetas Debito y Credito
	 $vsqltar    = "SELECT SUM(DV.valorfp2 + DV.valorfp3) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                WHERE D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."'";
	 $tarjetas   = $clase->SeleccionarUno($vsqltar);
	 ///// Devoluciones
	 $vsqldevoluc  = "SELECT SUM(valor) FROM docudevolucion WHERE diaoperativo='".$diaoperativo."'";
	 $devoluciones = $clase->SeleccionarUno($vsqldevoluc);
	 ///// Recogidas
	 $vsqlrecog  = "SELECT SUM(valrecogida) FROM recogidas WHERE diaoperativo = '".$diaoperativo."'";
	 $recogidas  = $clase->SeleccionarUno($vsqlrecog);
	 ///// Arqueos
	 $vsqlcierr  = "SELECT SUM(valentrega) FROM cierres WHERE tipocierre = 'PAR' AND diaoperativo='".$diaoperativo."'";
	 $arqueos    = $clase->SeleccionarUno($vsqlcierr);
	 ///// Gastos
	 $vsqlgastos = "SELECT SUM(DC.valor) FROM detallecierre DC INNER JOIN cierres C ON (C.cierreid = DC.cierreid) WHERE C.cierreid=".$cierreid;
	 $gastos     = $clase->SeleccionarUno($vsqlgastos);
	 ///// Base Caja
	 $vsqlcierr  = "SELECT valcaja FROM cierres WHERE tipocierre = 'DEF' AND (diaoperativo='".$diaoperativo."')";
	 $basecaja   = $clase->SeleccionarUno($vsqlcierr);
	 ///// Valor entregado en el Cierre
	 $vsqlentreg = "SELECT valentrega FROM cierres WHERE tipocierre = 'DEF' AND (diaoperativo='".$diaoperativo."')";
	 $entregado  = $clase->SeleccionarUno($vsqlentreg);
	 ///// Domicilios
	 $vsqldomi   = "SELECT 0 FROM cierres WHERE 1";
	 $domicilios = $clase->SeleccionarUno($vsqldomi);
	 ///// Gastos
	 $vsqlbaloto = "SELECT 0 FROM cierres WHERE 1";
	 $baloto     = $clase->SeleccionarUno($vsqlbaloto);
	 
	 $ingresos   = $ventas + $baloto - $devoluciones;
	 $egresos    = $gastos + $recogidas + $arqueos + $entregado;	  
	 $saldo      = $ingresos - $egresos;
	 	 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '    DETALLES DEL ARQUEO DE CAJA        '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'CONCEPTO           INGRESOS    EGRESOS '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'EFECTIVO        '.str_pad(number_format($ventas,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
     $cont.= 'DEVOLUCIONES    '.str_pad(number_format((-1)*$devoluciones,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
     $cont.= 'TARJETAS DB/CR  '.str_pad(number_format($tarjetas,0),11," ",STR_PAD_LEFT).str_pad(number_format($tarjetas,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= 'RECOGIDAS       '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($recogidas,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= 'CIERRES PARC.   '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($arqueos,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	
     $cont.= 'GASTOS          '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($gastos,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);		  	 
     $cont.= 'EFECT. EN CAJA  '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($entregado,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= 'DOMICILIOS      '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= 'BALOTO          '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 
     $cont.= '======================================='.Chr(13).Chr(10);          	 
     $cont.= ' SUB TOTALES    '.str_pad(number_format($ingresos,0),11," ",STR_PAD_LEFT).str_pad(number_format($egresos,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= '======================================='.Chr(13).Chr(10);          	 
     
	 //// Calculo del Dinero Sobrante - Faltante
	 if($saldo>0)   {	   $dinfaltante = $saldo;	   $dinsobrante = 0;	            }
	 if($saldo<0)   {	   $dinfaltante = 0;   	       $dinsobrante = ((-1)*$saldo);	}
	 if($saldo == 0){	   $dinfaltante = 0;     	   $dinsobrante = 0; 	            }
	 
	 
	 /// Muestro el Sobrante / Faltante  
	 $cont.= ' DINERO FALTANTE            '.str_pad(number_format($dinfaltante,0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 
	 $cont.= ' DINERO SOBRANTE            '.str_pad(number_format($dinsobrante,0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	 
	 $cont.= '=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_='.Chr(13).Chr(10);          	 	 
	 $cont.= ' MONTO TOTAL A CONSIGNAR    '.str_pad(number_format(($ventas+$dinsobrante-$devoluciones-$gastos),0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	 	 
	 $cont.= '=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_='.Chr(13).Chr(10).Chr(13).Chr(10);          	 	 

	 $cont.= '=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_='.Chr(13).Chr(10);          	 	 
	 $cont.= ' TOTAL VENTA DEL DIA        '.str_pad(number_format(($ventas+$tarjetas-$devoluciones),0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	 	 
	 $cont.= '=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_='.Chr(13).Chr(10).Chr(13).Chr(10);          	 	 
	 
     /// Resumen de Impuestos
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '        RESUMEN DE IMPUESTOS           '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= '  %IVA   VLR BASE   VLR IVA   VLR VENTA'.Chr(13).Chr(10);          
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT DD.porciva , SUM(DD.valbase) base , SUM(DD.valiva) iva , SUM(DD.valtotal) total 
	          FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
			  INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid)
	          WHERE D.tipodoc = 'FVE' AND diaoperativo ='".$diaoperativo."' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' GROUP BY 1";

	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 $totbase = 0;     $totiva = 0;     $totventa = 0;	 
	 $detalles = "";
	 while($row = mysql_fetch_array($result))
	 { 
 	   $detalles.= str_pad($row['porciva'],5," ",STR_PAD_LEFT).'  ';
	   $detalles.= str_pad(number_format($row['base'],0),10," ",STR_PAD_LEFT).'  ';
	   $detalles.= str_pad(number_format($row['iva']),8," ",STR_PAD_LEFT).' ';
       $detalles.= str_pad(number_format($row['total']),11," ",STR_PAD_LEFT).Chr(13).Chr(10); 	 
 	   
	   $totbase += $row['base'];     $totiva+= $row['iva'];     $totventa += $row['total'];	   
	   $totales  = str_pad(number_format($totbase,0),17," ",STR_PAD_LEFT).'  ';
	   $totales .= str_pad(number_format($totiva,0),8," ",STR_PAD_LEFT).'  ';	   
	   $totales .= str_pad(number_format($totventa,0),10," ",STR_PAD_LEFT);	   	   
	 } 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= $totales.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     	 
	 //////////////////////////////////////////////////////////
	 ///// Discriminacion de Medios de Pago	 
	 //////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '   DISCRIMINACION DE MEDIOS DE PAGO    '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= ' MEDIO PAGO               TOTAL   CANT '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          

	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT diaoperativo , 
	          (SELECT COUNT(*) FROM docuventa WHERE valorfp1 > 0 AND diaoperativo = DV.diaoperativo) CanEfec , 
			  (SELECT COUNT(*) FROM docuventa WHERE valorfp2 > 0 AND diaoperativo = DV.diaoperativo) CanTarj , 
			  (SELECT COUNT(*) FROM docuventa WHERE valorfp3 > 0 AND diaoperativo = DV.diaoperativo) CanOtro ,
              (SELECT COUNT(*) FROM docuventa WHERE valorfp4 > 0 AND diaoperativo = DV.diaoperativo) CanCred ,			  
			   SUM(valorfp1) valorfp1 , SUM(valorfp2) valorfp2 , SUM(valorfp3) valorfp3 , SUM(valorfp4) valorfp4 
			   FROM docuventa DV WHERE diaoperativo = '".$diaoperativo."' 
			   GROUP BY 1 , 2 , 3 , 4 , 5";
	 
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 $det = "";
	 if($row = mysql_fetch_array($result))
	 { 
 	   $det = 'EFECTIVO ............';
	   $det.= str_pad(number_format($row['valorfp1'],0),10," ",STR_PAD_LEFT).str_pad(number_format($row['CanEfec'],0),7," ",STR_PAD_LEFT);
 	   $det.= Chr(13).Chr(10);
	   $det.= 'TARJ DEB/CRED .......';
	   $det.= str_pad(number_format(($row['valorfp2']+$row['valorfp3']),0),10," ",STR_PAD_LEFT).str_pad(number_format(($row['CanTarj']+$row['CanOtro']),0),7," ",STR_PAD_LEFT);
 	   $det.= Chr(13).Chr(10);
	   $det.= 'CREDITOS ............';
	   $det.= str_pad(number_format($row['valorfp4'],0),10," ",STR_PAD_LEFT).str_pad(number_format($row['CanCred'],0),7," ",STR_PAD_LEFT);
	 } 
	 $cont.= $det.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
	 
	 ///////////////////////////////////////////////////////////////////
	 ///// Estadisticas del Proceso de Venta
	 ///////////////////////////////////////////////////////////////////
	 $vsql    = "SELECT COUNT(*) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) WHERE DV.diaoperativo='".$diaoperativo."'";
	 $cliaten = $clase->SeleccionarUno($vsql);
	 $vsql    = "SELECT CONCAT(prefijo,' ',numero) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	          WHERE DV.diaoperativo='".$diaoperativo."' ORDER BY NUMERO ASC limit 0,1";
	 $finicial = $clase->SeleccionarUno($vsql);
	 $vsql    = "SELECT CONCAT(prefijo,' ',numero) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	          WHERE DV.diaoperativo='".$diaoperativo."' ORDER BY NUMERO DESC limit 0,1";
	 $ffinal  = $clase->SeleccionarUno($vsql);
	 $vsql = "SELECT COUNT(*) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
			  INNER JOIN terceros T ON (T.terid = D.terid1) WHERE T.codigo <> '99 'AND DV.diaoperativo = '".$diaoperativo."'";
	 $cliregis = $clase->SeleccionarUno($vsql);
	 $clinoreg = $cliaten-$cliregis;
	 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '   ESTADISTICAS DEL PROCESO DE VENTA   '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'FACTURA INICIAL : .........'.str_pad($finicial,12," ",STR_PAD_LEFT).Chr(13).Chr(10);          
     $cont.= 'FACTURA FINAL : ...........'.str_pad($ffinal,12," ",STR_PAD_LEFT).Chr(13).Chr(10);
     $cont.= 'CLIENTES ATENDIDOS : ......'.str_pad(number_format($cliaten,0),12," ",STR_PAD_LEFT).Chr(13).Chr(10);          
     $cont.= 'CLIENTES REGISTRADOS : ....'.str_pad(number_format($cliregis,0),12," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	           
	 $cont.= 'CLIENTES NO REGISTRADOS : .'.str_pad(number_format($clinoreg,0),12," ",STR_PAD_LEFT).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);          	 	 	 

     /////////////////////////////////////////////////////////////////
	 ///////   Relacion de Devoluciones
	 /////////////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '      DEVOLUCIONES DE CLIENTES         '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'CONSECUTIVO  USUARIO    HORA     VALOR '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(D.tipodoc,D.prefijo,D.numero) consec , creador , fechadoc , total 
	          FROM documentos d INNER JOIN docudevolucion DV ON (D.docuid = DV.docuid)
	          WHERE D.tipodoc = 'DVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' AND DV.diaoperativo ='".$diaoperativo."'";
		  
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 $detalles = "";     $candevo = 0;    $totdevo = 0;
 	 while($row = mysql_fetch_array($result))
	 { 
	   $detalles.= str_pad(substr($row['consec'],0,11),13," ",STR_PAD_RIGHT).str_pad(substr($row['creador'],0,11),11," ",STR_PAD_RIGHT);
	   $detalles.= str_pad(substr($row['fechadoc'],11,5),5," ",STR_PAD_RIGHT).str_pad(number_format($row['total'],0),9," ",STR_PAD_LEFT).Chr(13).Chr(10);
	   $totdevo += $row['total'];  	   $candevo++;
	 } 
	 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'CANT DEVOLUCIONES : '.str_pad(number_format($candevo,0),5," ",STR_PAD_LEFT).str_pad(number_format($totdevo,0),13," ",STR_PAD_LEFT);
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     /////////////////////////////////////////////////////////////////
	 ///////   Relacion de Domicilios 	 
	 /////////////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '      RELACION DE DOMICILIOS           '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'MENSAJERO         FACTURA        VALOR'.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(nombres,' ',apellidos) nommen , CONCAT(prefijo,numero) numfac ,  total 
	          FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid3)
	          INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	          WHERE (T.codigo <> '00' AND T.codigo <> '99' AND T.codigo <> '98') AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' 
			  AND diaoperativo ='".$diaoperativo."' GROUP BY 1,2";
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 $detalles = "";     $candomi = 0;    $vendomi = 0;
 	 while($row = mysql_fetch_array($result))
	 { 
	   $detalles.= substr($row['nommen'],0,16).'  '.substr($row['numfac'],0,10).str_pad(number_format($row['total'],0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
	   $vendomi += $row['total'];  	   $candomi++;
	 } 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'CANT DOMICILIOS : '.str_pad(number_format($candomi,0),5," ",STR_PAD_LEFT).str_pad(number_format($vendomi,0),15," ",STR_PAD_LEFT);
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     /////////////////////////////////////////////////////////////////
	 ///////   Relacion de Creditos por Empleado
	 /////////////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '     DETALLE DE VENTAS A CREDITO       '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'CONSECUTIVO  USUARIO        VALOR FACT.'.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(D.tipodoc,D.prefijo,D.numero) consec , CONCAT(nombres,' ',apellidos) usuario , total 
	          FROM documentos d INNER JOIN docuventa DV ON (D.docuid = DV.docuid)
			  INNER JOIN terceros T ON (T.terid = D.terid1)
			  WHERE D.formapago = 'CR' AND D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' AND DV.diaoperativo ='".$diaoperativo."'";
		  
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 $detalles = "";     $candevo = 0;    $totdevo = 0;
 	 while($row = mysql_fetch_array($result))
	 { 
	   $detalles.= str_pad(substr($row['consec'],0,11),13," ",STR_PAD_RIGHT).str_pad(substr($row['usuario'],0,16),17," ",STR_PAD_RIGHT);
	   $detalles.= str_pad(number_format($row['total'],0),9," ",STR_PAD_LEFT).Chr(13).Chr(10);
	   $totdevo += $row['total'];  	   $candevo++;
	 } 
	 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'TOTAL CREDITOS :    '.str_pad(number_format($candevo,0),5," ",STR_PAD_LEFT).str_pad(number_format($totdevo,0),13," ",STR_PAD_LEFT);
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     //// Resumen de los Cierres Parciales
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          	 
     $cont.= '  RESUMEN CIERRES PARCIALES Y ARQUEOS  '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= ' ARQUEO  USUARIO    FECHA / HORA       '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT * FROM cierres WHERE tipocierre = 'PAR' AND diaoperativo ='".$diaoperativo."' ORDER BY momento";

	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 $detalles = ""; 	 
	 while($row = mysql_fetch_array($result))
	 { 
 	   $detalles.= ' '.str_pad($row['cierreid'],6,"0",STR_PAD_LEFT).'  ';
	   $detalles.= str_pad(substr($row['creador'],0,10),12," ",STR_PAD_RIGHT);
	   $detalles.= $row['momento'];
	 } 
     $cont.= $detalles.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

	 //// Resumen de Gastos detallados en Sistema
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '     RELACION GASTOS REGISTRADOS       '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'PROVEEDOR / VALOR G   CONCEPTO          '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Detallo las recogidas de Dinero
	 $vsql = "SELECT CONCAT(T.nombres,' ',T.apellidos) prove , DC.valor , CO.descripcion 
	          FROM detallecierre DC INNER JOIN cierres C ON (C.cierreid = DC.cierreid) 
			  INNER JOIN conceptosgastos CO ON (CO.codigo = DC.codconcepto)
			  INNER JOIN terceros T ON (T.terid = DC.proveedor)			  
			  WHERE C.cierreid=".$cierreid;
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 $detalles = ""; 	 
	 while($row = mysql_fetch_array($result))
	 { 
 	   $detalles.= substr($row['prove'],0,40).Chr(13).Chr(10);
 	   $detalles.= str_pad(substr($row['descripcion'],0,24),24," ",STR_PAD_RIGHT).'   ';
	   $detalles.= str_pad(number_format($row['valor'],0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 } 
     $cont.= $detalles.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
	 	 
	 //// Resumen de los Cierres Parciales
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '  RELACION DE RECOGIDAS DE DINERO      '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'VALOR REC    USUARIO    FECHA / HORA '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Detallo las recogidas de Dinero
	 $vsql = "SELECT * FROM recogidas WHERE diaoperativo ='".$diaoperativo."' ORDER BY momento";
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 $detalles = ""; 	 
	 while($row = mysql_fetch_array($result))
	 { 
 	   $detalles.= str_pad(number_format($row['valrecogida'],0),9," ",STR_PAD_LEFT).'    ';
	   $detalles.= str_pad(substr($row['creador'],0,8),9," ",STR_PAD_RIGHT);
	   $detalles.= substr($row['momento'],0,16).Chr(13).Chr(10);
	 } 
     $cont.= $detalles.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

    /////////////////////////////////////////////////////////////////
	 ///////   Relacion de Transferencias de Mercancia
	 /////////////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '    TRANSFERENCIAS A OTRAS BODEGAS     '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'CONSECUTIVO  BOD. DESTINO         VALOR'.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(D.tipodoc,D.prefijo,D.numero) consec , B.codbodega , total 
	          FROM documentos d INNER JOIN docutranfe DV ON (D.docuid = DV.docuid)
			  INNER JOIN bodegas B ON (DV.bodegaiddes = B.bodegaid)
	          WHERE D.tipodoc = 'TRB' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' AND DV.diaoperativo ='".$diaoperativo."'";
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 $detalles = "";     $candevo = 0;    $totdevo = 0;
 	 while($row = mysql_fetch_array($result))
	 { 
	   $detalles.= str_pad(substr($row['consec'],0,11),13," ",STR_PAD_RIGHT).str_pad(substr($row['nombodega'],0,16),16," ",STR_PAD_RIGHT);
	   $detalles.= str_pad(number_format($row['total'],0),9," ",STR_PAD_LEFT).Chr(13).Chr(10);
	   $totdevo += $row['total'];  	   $candevo++;
	 } 
	 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'CANT DEVOLUCIONES : '.str_pad(number_format($candevo,0),5," ",STR_PAD_LEFT).str_pad(number_format($totdevo,0),13," ",STR_PAD_LEFT);
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     ////////////////////////////////////////////////////////////////////////
	 ////   Estadisticas de Ventas por Vendedor 	 
     ////////////////////////////////////////////////////////////////////////	 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '   ESTADISTICA DE VENTAS x VENDEDOR    '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT terid, CONCAT( nombres,  ' ', apellidos ) nomven, SUM( total ) total, (
			  SELECT SUM( total ) FROM documentos D2 INNER JOIN docudevolucion DD ON ( D2.docuid = DD.docuid ) 
			  WHERE DD.diaoperativo =  '".$diaoperativo."' AND D2.terid2 = D.terid2 )devo, (
			  SELECT SUM( DD3.valparcial ) FROM documentos D3 INNER JOIN docuventa DV3 ON ( D3.docuid = DV3.docuid ) 
			  INNER JOIN dedocumentos DD3 ON ( D3.docuid = DD3.docuid ) INNER JOIN productos P3 ON ( P3.productoid = DD3.productoid ) 
			  WHERE DV3.diaoperativo = '".$diaoperativo."' AND P3.codigo =  'RR' AND D3.terid2 = T.terid) recar
			  FROM documentos D INNER JOIN terceros T ON ( T.terid = D.terid2 ) INNER JOIN docuventa DV ON ( D.docuid = DV.docuid ) 
			  WHERE diaoperativo = '".$diaoperativo."' AND D.fecasentado <>  '0000-00-00' AND D.fecanulado =  '0000-00-00' GROUP BY 1,2";
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 $detalles = "";
 	 while($row = mysql_fetch_array($result))
	 { 
	   $total = $row['total'] - $row['devo'] - $row['recar'];
	   $detalles.= substr($row['nomven'],0,25).Chr(13).Chr(10);
 	   $detalles.= 'VENTAS            :        '.str_pad(number_format($row['total'],0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
 	   $detalles.= 'DEVOLUCIONES (-)  :        '.str_pad(number_format($row['devo'],0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
 	   $detalles.= 'RECARGAS (-)      :        '.str_pad(number_format($row['recar'],0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	   
       $detalles.= 'TOTAL             :        '.str_pad(number_format($total,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
       $detalles.= '---------------------------------------'.Chr(13).Chr(10);	   
	 } 
     $cont.= $detalles.Chr(13).Chr(10); 

     //// Fin del Cuadre
	 $cont.= "Observaciones".Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
	 $cont.= "NOMBRE/FIRMA ADMINISTRADOR SUCURSAL".Chr(13).Chr(10).Chr(13).Chr(10);	 	 	 	 	   
	 $cont.= "C.C : _____________________________".Chr(13).Chr(10).Chr(13).Chr(10);	 	 	 	 	   	 
     
	 $cont.= str_pad($_SESSION['G_SITIOWEB_PRO'],39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.';     
	 
     ////// Adiciono al Log la informacion
	 $clase->CrearLOG('018','Se imprimio el Cierre Definitivo con Exito',strtoupper($_SESSION["USERNAME"]),'');    
	 
	 // Genero el Archivo para Enviarlo a Impresora
	 $archivo= "print/tiradecierredef.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 // Genero el 2do Archivo para Enviarlo a Impresora
	 $archivo= "print/tiradecierredef2.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo

	 // Genero el Archivo para Enviarlo a Impresora
	 $archivo= "log/Cierre-".$cierreid.".txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("dmy")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo	 
 	 
  } // Fin de la Funcion  
    
  ///////////////////////////////////////////////////////////////////////  
  /// Impresion de la Planilla de Cierre Parcial o Arqueo 
  ///////////////////////////////////////////////////////////////////////  
  function PlanillaCierreParcial($cierreid)
  {
	 $clase = new Sistema();
 	 $diaoperativo = $clase->BDLockup($cierreid,'cierres','cierreid','diaoperativo');	
     $momcierre    = $clase->BDLockup($cierreid,'cierres','cierreid','momento');		 
     $vsqlx = "SELECT CONCAT(nombres,' ',apellidos) FROM terceros T INNER JOIN usuarios U ON (U.terid=T.terid) WHERE u.username='".$_SESSION['USERNAME']."'";
	 $nomoperador  = $clase->SeleccionarUno($vsqlx);
	 
	 $sucid  = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid');	 
	 $nomsuc = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','descripcion');	 	 
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
	 $nitempresa = $_SESSION['G_NIT_EMPRESA'];
	 $cont.=  Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).'     '.$nomempresa.Chr(13).Chr(10);	
	 $cont.= '           '.$nitempresa.Chr(13).Chr(10);		 
 
     $cont.= ' **** CIERRE DE CAJA PARCIAL  ****  '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'COMPROBANTE DE CIERRE No. '.str_pad($cierreid,4,"0",STR_PAD_BOTH).Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'MOMENTO DEL CIERRE : '.substr($momcierre,0,16).Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= '      DIA OPERATIVO : '.$diaoperativo.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= ' USUARIO : '.substr($nomoperador,0,28).Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	 $cont.= str_pad('SUCURSAL : '.$nomsuc,42," ",STR_PAD_BOTH).Chr(13).Chr(10);		 
     $cont.= '---------------------------------------'.Chr(13).Chr(10).Chr(13).Chr(10);          

     //// Descripcion del Cuadre de Caja
	 ///// Efectivo
	 $vsqlventas = "SELECT SUM(DV.valorfp1) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                WHERE D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."'";
	 $ventas     = $clase->SeleccionarUno($vsqlventas);
	 ///// Tarjetas Debito y Credito
	 $vsqltar    = "SELECT SUM(DV.valorfp2 + DV.valorfp3) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                WHERE D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."'";
	 $tarjetas   = $clase->SeleccionarUno($vsqltar);
	 ///// Devoluciones
	 $vsqldevoluc  = "SELECT SUM(valor) FROM docudevolucion WHERE diaoperativo='".$diaoperativo."'";
	 $devoluciones = $clase->SeleccionarUno($vsqldevoluc);
	 ///// Recogidas
	 $vsqlrecog  = "SELECT SUM(valrecogida) FROM recogidas WHERE diaoperativo = '".$diaoperativo."'";
	 $recogidas  = $clase->SeleccionarUno($vsqlrecog);
	 ///// Arqueos
	 $vsqlcierr  = "SELECT SUM(valentrega) FROM cierres WHERE tipocierre = 'PAR' AND diaoperativo='".$diaoperativo."'";
	 $arqueos    = $clase->SeleccionarUno($vsqlcierr);
	 ///// Gastos
	 $vsqlgastos = "SELECT SUM(DC.valor) FROM detallecierre DC INNER JOIN cierres C ON (C.cierreid = DC.cierreid) WHERE C.cierreid=".$cierreid;
	 $gastos     = $clase->SeleccionarUno($vsqlgastos);
	 ///// Base Caja
	 $vsqlcierr  = "SELECT valcaja FROM cierres WHERE tipocierre = 'DEF' AND (diaoperativo='".$diaoperativo."')";
	 $basecaja   = $clase->SeleccionarUno($vsqlcierr);
	 ///// Valor entregado en el Cierre
	 $vsqlentreg = "SELECT valentrega FROM cierres WHERE tipocierre = 'DEF' AND (diaoperativo='".$diaoperativo."')";
	 $entregado  = $clase->SeleccionarUno($vsqlentreg);
	 ///// Domicilios
	 $vsqldomi   = "SELECT 0 FROM cierres WHERE 1";
	 $domicilios = $clase->SeleccionarUno($vsqldomi);
	 ///// Gastos
	 $vsqlbaloto = "SELECT 0 FROM cierres WHERE 1";
	 $baloto     = $clase->SeleccionarUno($vsqlbaloto);
	 
	 $ingresos   = $ventas + $baloto - $devoluciones;
	 $egresos    = $gastos + $recogidas + $arqueos + $entregado;	  
	 $saldo      = $ingresos - $egresos;
	 	 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '    DETALLES DEL ARQUEO DE CAJA        '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'CONCEPTO           INGRESOS    EGRESOS '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'EFECTIVO        '.str_pad(number_format($ventas,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
     $cont.= 'DEVOLUCIONES    '.str_pad(number_format((-1)*$devoluciones,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
     $cont.= 'TARJETAS DB/CR  '.str_pad(number_format($tarjetas,0),11," ",STR_PAD_LEFT).str_pad(number_format($tarjetas,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= 'RECOGIDAS       '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($recogidas,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= 'CIERRES PARC.   '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($arqueos,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	
     $cont.= 'GASTOS          '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($gastos,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);		  	 
     $cont.= 'EFECT. EN CAJA  '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($entregado,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= 'DOMICILIOS      '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= 'BALOTO          '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 
     $cont.= '======================================='.Chr(13).Chr(10);          	 
     $cont.= ' SUB TOTALES    '.str_pad(number_format($ingresos,0),11," ",STR_PAD_LEFT).str_pad(number_format($egresos,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= '======================================='.Chr(13).Chr(10);          	 
     
	 //// Calculo del Dinero Sobrante - Faltante
	 if($saldo>0)   {	   $dinfaltante = $saldo;	   $dinsobrante = 0;	            }
	 if($saldo<0)   {	   $dinfaltante = 0;   	       $dinsobrante = ((-1)*$saldo);	}
	 if($saldo == 0){	   $dinfaltante = 0;     	   $dinsobrante = 0; 	            }
	 
	 
	 /// Muestro el Sobrante / Faltante  
	 $cont.= ' DINERO FALTANTE            '.str_pad(number_format($dinfaltante,0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 
	 $cont.= ' DINERO SOBRANTE            '.str_pad(number_format($dinsobrante,0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	 
	 $cont.= '=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_='.Chr(13).Chr(10);          	 	 
	 $cont.= ' MONTO TOTAL A CONSIGNAR    '.str_pad(number_format(($ventas+$dinsobrante-$devoluciones-$gastos),0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	 	 
	 $cont.= '=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_='.Chr(13).Chr(10).Chr(13).Chr(10);          	 	 

	 $cont.= '=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_='.Chr(13).Chr(10);          	 	 
	 $cont.= ' TOTAL VENTA DEL DIA        '.str_pad(number_format(($ventas+$tarjetas-$devoluciones),0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	 	 
	 $cont.= '=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_='.Chr(13).Chr(10).Chr(13).Chr(10);          	 	 
	 
     /// Resumen de Impuestos
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '        RESUMEN DE IMPUESTOS           '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= '  %IVA   VLR BASE   VLR IVA   VLR VENTA'.Chr(13).Chr(10);          
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT DD.porciva , SUM(DD.valbase) base , SUM(DD.valiva) iva , SUM(DD.valtotal) total 
	          FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
			  INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid)
	          WHERE D.tipodoc = 'FVE' AND diaoperativo ='".$diaoperativo."' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' GROUP BY 1";

	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 $totbase = 0;     $totiva = 0;     $totventa = 0;	 
	 $detalles = "";
	 while($row = mysql_fetch_array($result))
	 { 
 	   $detalles.= str_pad($row['porciva'],5," ",STR_PAD_LEFT).'  ';
	   $detalles.= str_pad(number_format($row['base'],0),10," ",STR_PAD_LEFT).'  ';
	   $detalles.= str_pad(number_format($row['iva']),8," ",STR_PAD_LEFT).' ';
       $detalles.= str_pad(number_format($row['total']),11," ",STR_PAD_LEFT).Chr(13).Chr(10); 	 
 	   
	   $totbase += $row['base'];     $totiva+= $row['iva'];     $totventa += $row['total'];	   
	   $totales  = str_pad(number_format($totbase,0),17," ",STR_PAD_LEFT).'  ';
	   $totales .= str_pad(number_format($totiva,0),8," ",STR_PAD_LEFT).'  ';	   
	   $totales .= str_pad(number_format($totventa,0),10," ",STR_PAD_LEFT);	   	   
	 } 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= $totales.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     	 
	 //////////////////////////////////////////////////////////
	 ///// Discriminacion de Medios de Pago	 
	 //////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '   DISCRIMINACION DE MEDIOS DE PAGO    '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= ' MEDIO PAGO               TOTAL   CANT '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          

	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT diaoperativo , 
	          (SELECT COUNT(*) FROM docuventa WHERE valorfp1 > 0 AND diaoperativo = DV.diaoperativo) CanEfec , 
			  (SELECT COUNT(*) FROM docuventa WHERE valorfp2 > 0 AND diaoperativo = DV.diaoperativo) CanTarj , 
			  (SELECT COUNT(*) FROM docuventa WHERE valorfp3 > 0 AND diaoperativo = DV.diaoperativo) CanOtro ,
              (SELECT COUNT(*) FROM docuventa WHERE valorfp4 > 0 AND diaoperativo = DV.diaoperativo) CanCred ,			  
			   SUM(valorfp1) valorfp1 , SUM(valorfp2) valorfp2 , SUM(valorfp3) valorfp3 , SUM(valorfp4) valorfp4 
			   FROM docuventa DV WHERE diaoperativo = '".$diaoperativo."' 
			   GROUP BY 1 , 2 , 3 , 4 , 5";
	 
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 $det = "";
	 if($row = mysql_fetch_array($result))
	 { 
 	   $det = 'EFECTIVO ............';
	   $det.= str_pad(number_format($row['valorfp1'],0),10," ",STR_PAD_LEFT).str_pad(number_format($row['CanEfec'],0),7," ",STR_PAD_LEFT);
 	   $det.= Chr(13).Chr(10);
	   $det.= 'TARJ DEB/CRED .......';
	   $det.= str_pad(number_format(($row['valorfp2']+$row['valorfp3']),0),10," ",STR_PAD_LEFT).str_pad(number_format(($row['CanTarj']+$row['CanOtro']),0),7," ",STR_PAD_LEFT);
 	   $det.= Chr(13).Chr(10);
	   $det.= 'CREDITOS ............';
	   $det.= str_pad(number_format($row['valorfp4'],0),10," ",STR_PAD_LEFT).str_pad(number_format($row['CanCred'],0),7," ",STR_PAD_LEFT);
	 } 
	 $cont.= $det.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
	 
	 ///////////////////////////////////////////////////////////////////
	 ///// Estadisticas del Proceso de Venta
	 ///////////////////////////////////////////////////////////////////
	 $vsql    = "SELECT COUNT(*) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) WHERE DV.diaoperativo='".$diaoperativo."'";
	 $cliaten = $clase->SeleccionarUno($vsql);
	 $vsql    = "SELECT CONCAT(prefijo,' ',numero) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	          WHERE DV.diaoperativo='".$diaoperativo."' ORDER BY NUMERO ASC limit 0,1";
	 $finicial = $clase->SeleccionarUno($vsql);
	 $vsql    = "SELECT CONCAT(prefijo,' ',numero) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	          WHERE DV.diaoperativo='".$diaoperativo."' ORDER BY NUMERO DESC limit 0,1";
	 $ffinal  = $clase->SeleccionarUno($vsql);
	 $vsql = "SELECT COUNT(*) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
			  INNER JOIN terceros T ON (T.terid = D.terid1) WHERE T.codigo <> '99 'AND DV.diaoperativo = '".$diaoperativo."'";
	 $cliregis = $clase->SeleccionarUno($vsql);
	 $clinoreg = $cliaten-$cliregis;
	 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '   ESTADISTICAS DEL PROCESO DE VENTA   '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'FACTURA INICIAL : .........'.str_pad($finicial,12," ",STR_PAD_LEFT).Chr(13).Chr(10);          
     $cont.= 'FACTURA FINAL : ...........'.str_pad($ffinal,12," ",STR_PAD_LEFT).Chr(13).Chr(10);
     $cont.= 'CLIENTES ATENDIDOS : ......'.str_pad(number_format($cliaten,0),12," ",STR_PAD_LEFT).Chr(13).Chr(10);          
     $cont.= 'CLIENTES REGISTRADOS : ....'.str_pad(number_format($cliregis,0),12," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	           
	 $cont.= 'CLIENTES NO REGISTRADOS : .'.str_pad(number_format($clinoreg,0),12," ",STR_PAD_LEFT).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);          	 	 	 

     /////////////////////////////////////////////////////////////////
	 ///////   Relacion de Devoluciones
	 /////////////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '      DEVOLUCIONES DE CLIENTES         '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'CONSECUTIVO  USUARIO    HORA     VALOR '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(D.tipodoc,D.prefijo,D.numero) consec , creador , fechadoc , total 
	          FROM documentos d INNER JOIN docudevolucion DV ON (D.docuid = DV.docuid)
	          WHERE D.tipodoc = 'DVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' AND DV.diaoperativo ='".$diaoperativo."'";
		  
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 $detalles = "";     $candevo = 0;    $totdevo = 0;
 	 while($row = mysql_fetch_array($result))
	 { 
	   $detalles.= str_pad(substr($row['consec'],0,11),13," ",STR_PAD_RIGHT).str_pad(substr($row['creador'],0,11),11," ",STR_PAD_RIGHT);
	   $detalles.= str_pad(substr($row['fechadoc'],11,5),5," ",STR_PAD_RIGHT).str_pad(number_format($row['total'],0),9," ",STR_PAD_LEFT).Chr(13).Chr(10);
	   $totdevo += $row['total'];  	   $candevo++;
	 } 
	 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'CANT DEVOLUCIONES : '.str_pad(number_format($candevo,0),5," ",STR_PAD_LEFT).str_pad(number_format($totdevo,0),13," ",STR_PAD_LEFT);
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     /////////////////////////////////////////////////////////////////
	 ///////   Relacion de Domicilios 	 
	 /////////////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '      RELACION DE DOMICILIOS           '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'MENSAJERO         FACTURA        VALOR'.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(nombres,' ',apellidos) nommen , CONCAT(prefijo,numero) numfac ,  total 
	          FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid3)
	          INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	          WHERE (T.codigo <> '00' AND T.codigo <> '99' AND T.codigo <> '98') AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' 
			  AND diaoperativo ='".$diaoperativo."' GROUP BY 1,2";
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 $detalles = "";     $candomi = 0;    $vendomi = 0;
 	 while($row = mysql_fetch_array($result))
	 { 
	   $detalles.= substr($row['nommen'],0,16).'  '.substr($row['numfac'],0,10).str_pad(number_format($row['total'],0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
	   $vendomi += $row['total'];  	   $candomi++;
	 } 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'CANT DOMICILIOS : '.str_pad(number_format($candomi,0),5," ",STR_PAD_LEFT).str_pad(number_format($vendomi,0),15," ",STR_PAD_LEFT);
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     /////////////////////////////////////////////////////////////////
	 ///////   Relacion de Creditos por Empleado
	 /////////////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '     DETALLE DE VENTAS A CREDITO       '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'CONSECUTIVO  USUARIO        VALOR FACT.'.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(D.tipodoc,D.prefijo,D.numero) consec , CONCAT(nombres,' ',apellidos) usuario , total 
	          FROM documentos d INNER JOIN docuventa DV ON (D.docuid = DV.docuid)
			  INNER JOIN terceros T ON (T.terid = D.terid1)
			  WHERE D.formapago = 'CR' AND D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' AND DV.diaoperativo ='".$diaoperativo."'";
		  
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 $detalles = "";     $candevo = 0;    $totdevo = 0;
 	 while($row = mysql_fetch_array($result))
	 { 
	   $detalles.= str_pad(substr($row['consec'],0,11),13," ",STR_PAD_RIGHT).str_pad(substr($row['usuario'],0,16),17," ",STR_PAD_RIGHT);
	   $detalles.= str_pad(number_format($row['total'],0),9," ",STR_PAD_LEFT).Chr(13).Chr(10);
	   $totdevo += $row['total'];  	   $candevo++;
	 } 
	 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'TOTAL CREDITOS :    '.str_pad(number_format($candevo,0),5," ",STR_PAD_LEFT).str_pad(number_format($totdevo,0),13," ",STR_PAD_LEFT);
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
	 	 
	 //// Resumen de los Cierres Parciales
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '  RELACION DE RECOGIDAS DE DINERO      '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'VALOR REC    USUARIO    FECHA / HORA '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Detallo las recogidas de Dinero
	 $vsql = "SELECT * FROM recogidas WHERE diaoperativo ='".$diaoperativo."' ORDER BY momento";
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 $detalles = ""; 	 
	 while($row = mysql_fetch_array($result))
	 { 
 	   $detalles.= str_pad(number_format($row['valrecogida'],0),9," ",STR_PAD_LEFT).'    ';
	   $detalles.= str_pad(substr($row['creador'],0,8),9," ",STR_PAD_RIGHT);
	   $detalles.= substr($row['momento'],0,16).Chr(13).Chr(10);
	 } 
     $cont.= $detalles.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     /////////////////////////////////////////////////////////////////
	 ///////   Relacion de Transferencias de Mercancia
	 /////////////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '    TRANSFERENCIAS A OTRAS BODEGAS     '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'CONSECUTIVO  BOD. DESTINO         VALOR'.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(D.tipodoc,D.prefijo,D.numero) consec , B.codbodega , total 
	          FROM documentos d INNER JOIN docutranfe DV ON (D.docuid = DV.docuid)
			  INNER JOIN bodegas B ON (DV.bodegaiddes = B.bodegaid)
	          WHERE D.tipodoc = 'TRB' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' AND DV.diaoperativo ='".$diaoperativo."'";
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 $detalles = "";     $candevo = 0;    $totdevo = 0;
 	 while($row = mysql_fetch_array($result))
	 { 
	   $detalles.= str_pad(substr($row['consec'],0,11),13," ",STR_PAD_RIGHT).str_pad(substr($row['nombodega'],0,16),16," ",STR_PAD_RIGHT);
	   $detalles.= str_pad(number_format($row['total'],0),9," ",STR_PAD_LEFT).Chr(13).Chr(10);
	   $totdevo += $row['total'];  	   $candevo++;
	 } 
	 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'CANT DEVOLUCIONES : '.str_pad(number_format($candevo,0),5," ",STR_PAD_LEFT).str_pad(number_format($totdevo,0),13," ",STR_PAD_LEFT);
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     //// Fin del Cuadre
	 $cont.= "Observaciones".Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
	 $cont.= "NOMBRE/FIRMA ADMINISTRADOR SUCURSAL".Chr(13).Chr(10).Chr(13).Chr(10);	 	 	 	 	   
	 $cont.= "C.C : _____________________________".Chr(13).Chr(10).Chr(13).Chr(10);	 	 	 	 	   	 
     
	 $cont.= str_pad($_SESSION['G_SITIOWEB_PRO'],39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.';     
	 
     ////// Adiciono al Log la informacion
	 $clase->CrearLOG('018','Se imprimio el Cierre Definitivo con Exito',strtoupper($_SESSION["USERNAME"]),'');    
	 
	 // Genero el Archivo para Enviarlo a Impresora
	 $archivo= "print/tiradecierredef.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 // Genero el Archivo para Enviarlo a Impresora
	 $archivo= "log/Cierre-".$cierreid.".txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("dmy")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo	 
 	 	 
  } // Fin de la Funcion  
  

  ///////////////////////////////////////////////////////////////////////  
  /// Impresion de la Tira de Especiales por Dia 
  ///////////////////////////////////////////////////////////////////////  
  function ImpresionTiraCortaBonificado($diaoperativo)
  {
     $clase = new Sistema();
	 $sucid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid');	 
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
	 $nitempresa = $_SESSION['G_NIT_EMPRESA'];

	 $cont.=  Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).$nomempresa.Chr(13).Chr(10);	
	 $cont.=  $nitempresa.Chr(13).Chr(10);		 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 
	 /// Hago la Consulta de los datos del cierre
	 $vsql = "SELECT S.descripcion nomsucursal, T.nombres, T.apellidos, C. * 
			  FROM cierres C INNER JOIN sucursales S ON ( C.sucid = S.sucursalid ) 
		  	  INNER JOIN usuarios U ON ( U.username = C.creador ) 
			  INNER JOIN terceros T ON ( T.terid = U.terid ) 
			  WHERE C.diaoperativo='".$diaoperativo."' AND S.sucursalid=".$sucid;

	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 if($row = mysql_fetch_array($result))
	 { 
 	   $nomsucursal  = $row['nomsucursal'];
	   $diaoperativo = $row['diaoperativo'];
 	   $fecha        = substr($row['momento'],8,2)."/".substr($row['momento'],5,2)."/".substr($row['momento'],0,4);
 	   $hora         = substr($row['momento'],11,2).":".substr($row['momento'],14,2); 	    	   
	   $realiza      = substr($row['nombres'].' '.$row['apellidos'],0,24); 
     } 

     $cont.= 'SUCURSAL : '.$nomsucursal.Chr(13).Chr(10);		 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'DIA OPERATIVO  : '.$diaoperativo.Chr(13).Chr(10);	 
	 $cont.= 'FECHA   : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
     $cont.= '======================================='.Chr(13).Chr(10);          	 	
	 $cont.= '  ****  RESUMEN DE ESPECIALES  *****    '.Chr(13).Chr(10);    
	 $cont.= '======================================='.Chr(13).Chr(10);     
     	     	 
	 /// Hago la Consulta de los datos del cierre
	 $fechaC=  substr($diaoperativo,6,4)."-".substr($diaoperativo,3,2)."-".substr($diaoperativo,0,2);
	 $vsql2 = "SELECT T.apellidos, T.nombres, P.descripcion, B. fecha , B.porcenboni , SUM(B.cantidad) cantidad , SUM(B.valorventa) valorventa , SUM(B.valorcomi) valorcomi
			   FROM bonificado B INNER JOIN terceros T ON ( T.terid = B.vendedor ) INNER JOIN productos P ON ( P.productoid = B.productoid ) 
			   WHERE B.fecha = '".$fechaC."' AND B.sucursalid =".$sucid." GROUP BY 1,2,3,4,5 ORDER BY T.apellidos ASC , T.nombres ASC , P.descripcion ASC";

	 /// Parametros para la totalizacion 
	 $vendedact = "";   	 $detalles  = "";       $totventa=0;   $totventabon=0;
	 
	 $conex2  = $clase->Conectar();
     $result2 = mysql_query($vsql2,$conex2);
 	 while($row2 = mysql_fetch_array($result2))
	 { 
       if($vendedact != substr($row2['nombres']." ".$row2['apellidos'],0,27))
	   {
           if($vendedact != "")
		   {
		     $tv   = str_pad(number_format($totventa),8," ",STR_PAD_LEFT);
		     $tvb  = str_pad(number_format($totventabon),8," ",STR_PAD_LEFT);			 
			 $detalles.= '======================================='.Chr(13).Chr(10);     	 
             $detalles.= 'TOTAL VENTAS ESPECIALES :    '.$tv.Chr(13).Chr(10);     	 		 
             $detalles.= 'TOTAL ESPECIALES :           '.$tvb.Chr(13).Chr(10);     	 		 			   
			 $detalles.= '======================================='.Chr(13).Chr(10);     	 	   
			 $totventa = 0;               $totventabon = 0;
		   }
		   
		   $vendedact = substr($row2['nombres']." ".$row2['apellidos'],0,27);
		   $detalles.= '**************************************'.Chr(13).Chr(10);     	 
           $detalles.= 'VENDEDOR : '.$vendedact.Chr(13).Chr(10);     	 		   
	   }

	   $totventa += $row2['valorventa'];
	   $totventabon += $row2['valorcomi'];	   
     } 
     $tv   = str_pad(number_format($totventa),9," ",STR_PAD_LEFT);
	 $tvb  = str_pad(number_format($totventabon),9," ",STR_PAD_LEFT);			 			
	 $detalles.= '======================================='.Chr(13).Chr(10);     	 
     $detalles.= 'TOTAL VENTAS ESPECIALES :    '.$tv.Chr(13).Chr(10);     	 		 
     $detalles.= 'TOTAL ESPECIALES :           '.$tvb.Chr(13).Chr(10);     	 		 			   
     $detalles.= '======================================='.Chr(13).Chr(10);     	 	   

     //// Genero la Tira 
	 $cont.= $detalles;
     
     $cont.= str_pad($_SESSION['G_SITIOWEB_PRO'],39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.';     
	 
     ////// Adiciono al Log la informacion
	 $clase->CrearLOG('018','Se imprimio la tira de Especiales con Exito',strtoupper($_SESSION["USERNAME"]),'');    
	 
	 // Genero el Archivo para Enviarlo a Impresora
	 $archivo= "print/tirabonificado.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("dmy")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo	 
	 
  } // Fin de la Funcion
  
  ///////////////////////////////////////////////////////////////////////  
  /// Impresion de la Tira de Especiales por Dia 
  ///////////////////////////////////////////////////////////////////////  
  function ImpresionTiraBonificado($diaoperativo)
  {
     $clase = new Sistema();
	 $sucid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid');	 
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
	 $nitempresa = $_SESSION['G_NIT_EMPRESA'];

	 $cont.=  Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).$nomempresa.Chr(13).Chr(10);	
	 $cont.=  $nitempresa.Chr(13).Chr(10);		 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 
	 /// Hago la Consulta de los datos del cierre
	 $vsql = "SELECT S.descripcion nomsucursal, T.nombres, T.apellidos, C. * 
			  FROM cierres C INNER JOIN sucursales S ON ( C.sucid = S.sucursalid ) 
		  	  INNER JOIN usuarios U ON ( U.username = C.creador ) 
			  INNER JOIN terceros T ON ( T.terid = U.terid ) 
			  WHERE C.diaoperativo='".$diaoperativo."' AND S.sucursalid=".$sucid;

	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 if($row = mysql_fetch_array($result))
	 { 
 	   $nomsucursal  = $row['nomsucursal'];
	   $diaoperativo = $row['diaoperativo'];
 	   $fecha        = substr($row['momento'],8,2)."/".substr($row['momento'],5,2)."/".substr($row['momento'],0,4);
 	   $hora         = substr($row['momento'],11,2).":".substr($row['momento'],14,2); 	    	   
	   $realiza      = substr($row['nombres'].' '.$row['apellidos'],0,24); 
     } 

     $cont.= 'SUCURSAL : '.$nomsucursal.Chr(13).Chr(10);		 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'DIA OPERATIVO  : '.$diaoperativo.Chr(13).Chr(10);	 
	 $cont.= 'FECHA   : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
	 $cont.= 'REALIZO : '.$realiza.Chr(13).Chr(10);
     $cont.= '======================================='.Chr(13).Chr(10);          	 	
	 $cont.= '  ****  PRODUCTOS ESPECIALES  *****    '.Chr(13).Chr(10);    
	 $cont.= '======================================='.Chr(13).Chr(10);     
     	 
	 /// Hago la Consulta de los datos del cierre
	 $fechaC=  substr($diaoperativo,6,4)."-".substr($diaoperativo,3,2)."-".substr($diaoperativo,0,2);
	 $vsql2 = "SELECT T.apellidos, T.nombres, P.descripcion, B. fecha , B.porcenboni , SUM(B.cantidad) cantidad , SUM(B.valorventa) valorventa , SUM(B.valorcomi) valorcomi
			   FROM bonificado B INNER JOIN terceros T ON ( T.terid = B.vendedor ) INNER JOIN productos P ON ( P.productoid = B.productoid ) 
			   WHERE B.fecha = '".$fechaC."' AND B.sucursalid =".$sucid." GROUP BY 1,2,3,4,5 ORDER BY T.apellidos ASC , T.nombres ASC , P.descripcion ASC";

	 /// Parametros para la totalizacion 
	 $vendedact = "";   	 $detalles  = "";       $totventa=0;   $totventabon=0;
	 
	 $conex2  = $clase->Conectar();
     $result2 = mysql_query($vsql2,$conex2);
 	 while($row2 = mysql_fetch_array($result2))
	 { 
       if($vendedact != substr($row2['nombres']." ".$row2['apellidos'],0,27))
	   {
           if($vendedact != "")
		   {
		     $tv   = str_pad(number_format($totventa),8," ",STR_PAD_LEFT);
		     $tvb  = str_pad(number_format($totventabon),8," ",STR_PAD_LEFT);			 
			 $detalles.= '======================================='.Chr(13).Chr(10);     	 
             $detalles.= 'TOTAL VENTAS ESPECIALES :    '.$tv.Chr(13).Chr(10);     	 		 
             $detalles.= 'TOTAL ESPECIALES :           '.$tvb.Chr(13).Chr(10);     	 		 			   
			 $detalles.= '======================================='.Chr(13).Chr(10);     	 	   
			 $totventa = 0;               $totventabon = 0;
		   }
		   
		   $vendedact = substr($row2['nombres']." ".$row2['apellidos'],0,27);
	       $detalles.= '**************************************'.Chr(13).Chr(10);     	 
           $detalles.= 'VENDEDOR : '.$vendedact.Chr(13).Chr(10);     	 		   
           $detalles.= '**************************************'.Chr(13).Chr(10);     	 
		   $detalles.= 'ESPECIAL          %       Base    Desc'.Chr(13).Chr(10);     	 
           $detalles.= '--------------------------------------'.Chr(13).Chr(10);     	 		   
	   }

 	   $detalles.= str_pad(substr($row2['descripcion'],0,12),13," ",STR_PAD_RIGHT).'  ';
	   $detalles.= str_pad($row2['porcenboni'],5," ",STR_PAD_LEFT).'  '.str_pad(number_format($row2['valorventa']),8," ",STR_PAD_LEFT);
	   $detalles.= str_pad(number_format($row2['valorcomi']),8," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   
       
	   $totventa += $row2['valorventa'];
	   $totventabon += $row2['valorcomi'];	   
     } 
     $tv   = str_pad(number_format($totventa),9," ",STR_PAD_LEFT);
	 $tvb  = str_pad(number_format($totventabon),9," ",STR_PAD_LEFT);			 			
	 $detalles.= '======================================='.Chr(13).Chr(10);     	 
     $detalles.= 'TOTAL VENTAS ESPECIALES :    '.$tv.Chr(13).Chr(10);     	 		 
     $detalles.= 'TOTAL ESPECIALES :           '.$tvb.Chr(13).Chr(10);     	 		 			   
     $detalles.= '======================================='.Chr(13).Chr(10);     	 	   

     //// Genero la Tira 
	 $cont.= $detalles;
     
     $cont.= str_pad($_SESSION['G_SITIOWEB_PRO'],39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.';     
	 
     ////// Adiciono al Log la informacion
	 $clase->CrearLOG('018','Se imprimio la tira de Especiales con Exito',strtoupper($_SESSION["USERNAME"]),'');    
	 
	 // Genero el Archivo para Enviarlo a Impresora
	 $archivo= "print/tirabonificado.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("dmy")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo	 
	 
  } // Fin de la Funcion

  //////////////////////////////////////////////////  
  function ImpresionTiraMensajeria($docuid)
  {
     $clase = new Sistema();	 
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
     $cont = $nomempresa.Chr(13).Chr(10);	 
	 
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.fecasentado , D.fecanulado , D.base , D.iva ,  D.total , t.dni codcliente , D.terid3 , 
	 		  CONCAT(T.nombres,' ',T.apellidos) nomcliente , T.dni , T.direccion , T.telfijo , T.telmovil , P.codigo codproducto , P.descripcion nomproducto , DD.valunitario , 
			  SUM(DD.cantidad) cantidad ,  SUM(DD.valparcial) valparcial 
			  FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid1)
			  INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
			  INNER JOIN productos P ON (P.productoid = DD.productoid)
			  WHERE D.docuid=".$docuid." AND P.codigo = 'DO' GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19";

	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
	 	 
 	 while($row = mysql_fetch_array($result))
	 { 
 	   /// Nombre del Archivo para la Sincronizacion
	   $nombredoc = $row['tipodoc'].$row['prefijo'].$row['numero']; 
	   
	   $prefijo = $row['prefijo'];
 	   $numero  = $row['numero'];
 	   $fecha   = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);
 	   $hora    = substr($row['fechadoc'],11,2).":".substr($row['fechadoc'],14,2); 	   
 	   
	   $total    = $clase->BDLockup($docuid,'documentos','docuid','total'); 
 	   
   	   $cliente  = substr($row['nomcliente'],0,24); 
   	   $nitcli   = $row['dni']; 	   
   	   $dircli   = $row['direccion']; 	   	   
   	   $telcli   = $row['telmovil']." ".$row['telfijo']; 	   	   	   
   	   
	   $domi = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE terid=".$row['terid3']);
	   $domiciliario = substr($domi,0,32); 
 	   
	   $detalles.= 'TOTAL A CANCELAR : '.str_pad(number_format($total),18," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   
     } 

     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= '    *** RECIBO DE DOMICILIO ***       '.Chr(13).Chr(10);	 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= 'FACTURA DE VENTA No.'.$prefijo.' '.$numero.Chr(13).Chr(10);
	 $cont.= 'FECHA   : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'CLIENTE : '.$cliente.Chr(13).Chr(10);
	 $cont.= 'IDENTIF : '.$nitcli.Chr(13).Chr(10);
	 $cont.= 'DIRECC  : '.$dircli.Chr(13).Chr(10);
	 $cont.= 'TELEFON : '.$telcli.Chr(13).Chr(10).Chr(13);
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          	 	
     $cont.= 'DOMICIL : '.$domiciliario.Chr(13).Chr(10);	      
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= $detalles;	 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);           
     $cont.= Chr(13).Chr(10).str_pad("www.dromedicas.com.co",39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.'.Chr(13).Chr(10);
	 
	 // Genero el Archivo para Enviarlo a Impresora
	 $archivo= "print/mensajeria.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("dmy")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
  } // Fin de la Funcion
  
  //////////////////////////////////////////////////////////////////////  
  //////////////////////////////////////////////////////////////////////  
  function ImpresionPOSFactura($docuid)
  {
     $clase = new Sistema();	 
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
     $cont = $nomempresa.Chr(13).Chr(10);	 
	 
	 /// Cargo las configuraciones del Prefijo del Documento
	 $tipodoc = $clase->BDLockup($docuid,"documentos","docuid","tipodoc");
	 $prefijo = $clase->BDLockup($docuid,"documentos","docuid","prefijo");	  
	 
     $vsql = "SELECT * FROM consecutivos WHERE tipodoc='".$tipodoc."' AND prefijo='".$prefijo."'";
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
	 if($row = mysql_fetch_array($result))
	 {
	    $encab1 = $row['encab1'];	
	    $encab2 = $row['encab2'];	
	    $encab3 = $row['encab3'];				    
	    $encab4 = $row['encab4'];				    
	    $encab5 = $row['encab5'];				    			    
	    
		$pie1 = $row['pie1'];	    
		$pie2 = $row['pie2'];	    
		$pie3 = $row['pie3'];	    
		$pie4 = $row['pie4'];	    
		$pie5 = $row['pie5'];	 
		
		$txtres = $row['txtresolucion'];	    
	 }    
	 
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.fecasentado , D.fecanulado , D.base , D.iva ,  D.total ,
	  		  t.dni codcliente , D.terid2 , D.terid3 , CONCAT(T.nombres,' ',T.apellidos) nomcliente , T.dni , T.direccion , T.telfijo ,
			  T.telmovil , P.codigo codproducto , P.descripcion nomproducto , DD.valunitario , SUM(DD.unicom) cajas , 
			  SUM(DD.unifra) unidades ,
			  SUM(DD.valparcial) valparcial 
			  FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid1)
			  INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
			  INNER JOIN productos P ON (P.productoid = DD.productoid)
			  WHERE D.docuid=".$docuid." GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20";
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
     
	 if($encab1!= "")
       $cont.= $encab1.Chr(13).Chr(10);
	 if($encab2!= "")
	   $cont.= $encab2.Chr(13).Chr(10);
 	 if($encab3!= "")
	   $cont.= $encab3.Chr(13).Chr(10);
 	 if($encab4!= "")
	   $cont.= $encab4.Chr(13).Chr(10);
 	 if($encab5!= "")
	   $cont.= $encab5.Chr(13).Chr(10);	 	 	 	 
	 
	 $teriddomi = "";  
 	 while($row = mysql_fetch_array($result))
	 { 
 	   /// Nombre del Archivo para la Sincronizacion
	   $nombredoc = $row['tipodoc'].$row['prefijo'].$row['numero']; 
	   
	   $teriddomi = $row['terid3'];
	   $prefijo = $row['prefijo'];
 	   $numero  = $row['numero'];
 	   $fecha   = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);
 	   $hora    = substr($row['fechadoc'],11,2).":".substr($row['fechadoc'],14,2); 	   
 	   
	   $subtotal = $row['base']; 
	   $iva      = $row['iva']; 	   
	   $total    = $row['total']; 
 	   
   	   $cliente  = substr($row['nomcliente'],0,24); 
   	   $nitcli   = $row['dni']; 	   
   	   $dircli   = $row['direccion']; 	   	   
   	   $telcli   = $row['telmovil']." ".$row['telfijo']; 	   	   	   
   	   
	   $vend = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE terid=".$row['terid2']);
	   $vendedor = substr($vend,0,27); 
 	   
	   if($row['codproducto'] != 'DO')
	   {
 	     $detalles.= str_pad(substr($row['nomproducto'],0,19),19," ",STR_PAD_RIGHT).'  ';
	     $detalles.= str_pad($row['cajas'],3," ",STR_PAD_LEFT).' '.str_pad($row['unidades'],3," ",STR_PAD_LEFT).'  ';
		 $detalles.= str_pad(number_format($row['valparcial']),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   
	   } 	 
     } 

	 $cont.= 'DOC. EQUIVALENTE No.'.$prefijo.' '.$numero.Chr(13).Chr(10);
	 $cont.= $txtres.Chr(13).Chr(10);	 	 	
     $cont.= '---------------------------------------'.Chr(13).Chr(10); 
	 $cont.= 'FECHA   : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
	 $cont.= 'CLIENTE : '.$cliente.Chr(13).Chr(10);
	 $cont.= 'IDENTIF : '.$nitcli.Chr(13).Chr(10);
	 $cont.= 'DIRECC  : '.$dircli.Chr(13).Chr(10);
	 $cont.= 'TELEFON : '.trim($telcli).Chr(13).Chr(10).Chr(13);
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          	 	
     
	 $medicoid = $clase->SeleccionarUno("SELECT medicoid FROM docuventa WHERE docuid=".$docuid);
	 if($medicoid != 1)
	 {
        $domi = $clase->SeleccionarUno("SELECT nommedico FROM medicos WHERE medicoid=".$medicoid);
		$cont.= 'MEDICO  : '.substr(strtoupper($domi),0,27).Chr(13).Chr(10);
        $cont.= '---------------------------------------'.Chr(13).Chr(10);     	 
	 }     	 
	 
	 if($teriddomi != 1)
	 {
        $domi = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE terid=".$teriddomi);
		$cont.= 'MENSAJE : '.substr($domi,0,27).Chr(13).Chr(10);
        $cont.= '---------------------------------------'.Chr(13).Chr(10);     	 
	 }         
	 
     $cont.= 'VENDEDOR: '.$vendedor.Chr(13).Chr(10);	      
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= 'PRODUCTO             CAJ UNI      TOTAL'.Chr(13).Chr(10);
     $cont.= '---------------------------------------'.Chr(13).Chr(10);     
	 $cont.= $detalles;	 
	 $cont.= '                            -----------'.Chr(13).Chr(10);     
	 $cont.= '              TOTAL '.$_SESSION['G_MONEDALOCAL'].'   '.str_pad(number_format($total),16," ",STR_PAD_LEFT).Chr(13).Chr(10);     	 
	 $cont.= '                            ==========='.Chr(13).Chr(10);     
	 
	 $cont.= 'SUBTOTAL : '.number_format($subtotal).Chr(13).Chr(10);
	 $cont.= 'I.V.A    : '.number_format($iva).Chr(13).Chr(10);
	 $cont.= 'TOTAL    : '.number_format($total).Chr(13).Chr(10);	 	 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);     	 
	 
	 /// Especifico el Medio de Pago de la Factura
	 $efectivo = $clase->SeleccionarUno("SELECT valorfp1 FROM docuventa WHERE docuid=".$docuid);	 
	 //echo"<b>".$efectivo."<br>";
	 if($efectivo > 0){   //// Si la venta es en efectivo - Abro el cajon portamonedas
		 copy("recursos/ABRIRCAJON.dat","print/abrir.txt");
		 $cont.= 'EFECTIVO '.str_pad(number_format($efectivo),30," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 }
	 
	 $tarjetas = $clase->SeleccionarUno("SELECT valorfp2 + valorfp3 FROM docuventa WHERE docuid=".$docuid);	 
	 if($tarjetas > 0)
	     $cont.= 'TARJETAS DEB / CRED '.str_pad(number_format($tarjetas),19," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 
	 $creditos = $clase->SeleccionarUno("SELECT valorfp4 FROM docuventa WHERE docuid=".$docuid);	 
	 if($creditos > 0)
	     $cont.= 'CREDITOS AUTORIZADOS '.str_pad(number_format($creditos),17," ",STR_PAD_LEFT).Chr(13).Chr(10);
		 	 
	 $cont.= '---------------------------------------'.Chr(13).Chr(10);     	 	 
	 
	 /// Consulto si hubo que dar vueltos 
	 $vueltos = $clase->BDLockup($docuid,'docuventa','docuid','vueltos');
	 if($vueltos > 0){
   	  $cont.= 'VUELTOS  '.str_pad(number_format($vueltos),30," ",STR_PAD_LEFT).Chr(13).Chr(10);	   
	  $cont.= '---------------------------------------'.Chr(13).Chr(10);     	 	 
	 }
	 
	 /// Muestro los Pie de Pagina
	 if($pie1!= "")
	   $cont.= $pie1.Chr(13).Chr(10);
	 if($pie2!= "")
	   $cont.= $pie2.Chr(13).Chr(10);
	 if($pie3!= "")
	   $cont.= $pie3.Chr(13).Chr(10);
	 if($pie4!= "")
	   $cont.= $pie4.Chr(13).Chr(10);
	 if($pie5!= "")
	   $cont.= $pie5.Chr(13).Chr(10);	
	 
     $cont.= str_pad("www.dromedicas.com.co",39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.'.Chr(13).Chr(10);     
	 
	 // Genero el Archivo para Enviarlo a Impresora
	 if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR") 
    	 $archivo= "../Dropbox/00/print/factura.txt"; // el nombre de tu archivo
     else
         $archivo= "print/factura.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo

	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("my")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 /// La marco en la Base de datos como Impresa
     $clase->EjecutarSQL("UPDATE documentos SET impreso = 'S' WHERE docuid=".$docuid);
     $clase->EjecutarSQL("UPDATE docuveJnta SET impreso = CURRENT_TIMESTAMP WHERE docuid=".$docuid);

	 //// Si es un Credito a Empleados - Imprime copia
	 $formapago = $clase->SeleccionarUno("SELECT formapago FROM documentos WHERE docuid=".$docuid);
	 if($formapago == 'CR')
	 {   
     	$archivo= "print/facturacopia1.txt"; // el nombre de tu archivo
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en �l
        fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
        fclose($fch); // Cierras el archivo
	 }
	 
	 //// Si el Medio de Pago es Tarjetas - Imprimo la Copia de la Factura
	 $estarje = $clase->SeleccionarUno("SELECT valorfp2 + valorfp3 FROM docuventa WHERE docuid=".$docuid);
	 if($estarje > 0)
	 {   
     	$archivo= "print/facturacopia1.txt"; // el nombre de tu archivo
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en �l
        fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
        fclose($fch); // Cierras el archivo
	 }
	 
	 //// Si es una Formula Medica enviada para CloseUp 
	 $esmedico = $clase->SeleccionarUno("SELECT medicoid FROM docuventa WHERE docuid=".$docuid);
	 if($esmedico!=0)
	 {   
     	$archivo= "print/facturacopia2.txt"; // el nombre de tu archivo
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en �l
        fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
        fclose($fch); // Cierras el archivo
	 }
	 
	 //// Si alguno de los productos que se facturan tiene Beneficio - Debe Imprimir una copia 
	 $vsqlaux="SELECT COUNT(*) FROM dedocumentos DD INNER JOIN productos P ON ( P.productoid = DD.productoid ) 
			   WHERE P.recambio = 'CHECKED' AND DD.docuid =".$docuid;
	 $beneficio = $clase->SeleccionarUno($vsqlaux);
	 if($beneficio > 0)
	 {   
     	$archivo= "print/facturacopia3.txt"; // el nombre de tu archivo
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en �l
        fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
        fclose($fch); // Cierras el archivo
	 }
	 
	 //// Si la factura es de Domicilio mando a imprimir el Ticket de mensajeria
	 $esdomi = $clase->SeleccionarUno("SELECT terid3 FROM documentos WHERE docuid=".$docuid);
	 if($esdomi!=1)
	    ImpresionTiraMensajeria($docuid);	    
	 
  } // Fin de la Funcion
  
  /////////////////////////////////////////////////////////////////////////////////////
  ///// MODULO : Transferencias   -    Permite Cargar una Transferencia desde Archivo 
  /////////////////////////////////////////////////////////////////////////////////////  
  function CargarRemision($numerorem)
  {
     $clase = new Sistema();
	 $ruta      = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/transferencias/".$numerorem.".txt";
	 if(file_exists($ruta))
	 {	 
       $docuid = "";
	   $numlinea = 1;
	   $continuar = "S";
	   
	   $fp = fopen($ruta,"r");	   
	   while ($linea= fgets($fp,2048))
       {
	      if($numlinea == 1)
		  {
		    $clase->EjecutarSQL($linea);
			
		  }		  
		  else
		  {	
		     
			 if($numlinea == 2)  
			 {
		        $inserto = $clase->EjecutarSQL(substr($linea,1,2048));
				if($inserto > 0){
				  $continuar = "S";   				  
				}
				else
				  $continuar = "N";				  
			 }	
			 else
			 {
			    
			   if($continuar == "S")	
			   {
				if($numlinea == 3)
				{
				  if(substr($linea,0,11)=='|SELECTUNO|')  
		            $docuid = $clase->SeleccionarUno(substr($linea,11,2048));
					
			      $clase->EjecutarSQL("DELETE FROM dedocumentos WHERE docuid=".$docuid);		
			      $clase->EjecutarSQL("UPDATE documentos SET base = 0 , iva = 0 , total = 0 WHERE docuid=".$docuid);		
				} 
				else
				{
				   if($docuid != "")
				   {
				      $linea2 = str_replace("|||||",$docuid,$linea);
					 
					  if(substr($linea2,0,3) == "**I")
					     $clase->EjecutarSQL(substr($linea2,2,2048));							 
					  
					  if(substr($linea2,0,3) == "***")
					     $clase->EjecutarSQL(substr($linea2,3,2048)); 					 				   
			      }
                } 
			  }	
			}			  
		  }	 
 
		 $numlinea++;	
		 	     		  
       } /// Fin del While
	   
     } /// Fin de If File Exist
	/// Cierro el Archivo
    fclose($fp);
	
	/// Elimino el Archivo  luego de Cargar la remision para prevenir almacenamiento en Disco
	if(file_exists($ruta))
	 unlink($ruta);
	/// Elimino los Productos que esten con Cantidad Cero
    $clase->EjecutarSQL("DELETE FROM dedocumentos WHERE cantidad = 0 AND docuid=".$docuid);

    /// Genero la remision a las tablas de Auditoria
	$numremision = $clase->SeleccionarUno("SELECT CONCAT(tipodoc,prefijo,numero) FROM documentos WHERE docuid=".$docuid);
    $clase->EjecutarSQL("CALL PA_GenerarAuditoria('".$numremision."')"); 
	
	return($docuid);	 	 
  } // Fin de la Funcion

  /////////////////////////////////////////////////////////////////////////////////////////////
  /// Cargar Pedido de Sucursales
  ///////////////////////////////////////////////////////////////
  function CargarPedido($numerorem)
  {
	 $clase = new Sistema();
     $esurgente = "N";                  $docuid="";
	 $ruta      = "../Dropbox/00/pedidos/".$numerorem.".txt";
	 
	 if(!file_exists($ruta))
	 {  
	    $ruta    = "../Dropbox/00/pedidosu/".$numerorem.".txt";
		$esurgente = "S";
	 }	
  
     if(file_exists($ruta))
	 { 	 
	   $docuid = "";
	   $numlinea = 1;
	   $cantotal = 0;         $valtotal = 0; 
	   $fp = fopen($ruta,"r");	   
	   while ($linea= fgets($fp,2048))
       {
	      if($numlinea == 1)
		  {
		    $clase->EjecutarSQL($linea);			
		  }		  
		  else
		  {	
		     
			 if($numlinea == 2)  
			 {
		        $clase->EjecutarSQL(substr($linea,1,2048));
				echo substr($linea,1,2048);
			 }	
			 else
			 {
			    if($numlinea == 3)
				{
				  if(substr($linea,0,11)=='|SELECTUNO|')  
		            $docuid = $clase->SeleccionarUno(substr($linea,11,2048));

			      $clase->EjecutarSQL("UPDATE documentos SET base = 0 , iva = 0 , total = 0 WHERE docuid=".$docuid);		
				} 
				else
				{
				   if($docuid != "")
				   {
				      $linea2 = str_replace("|||||",$docuid,$linea);
                   
					  if(substr($linea2,0,3) == "**I")
					     $clase->EjecutarSQL(substr($linea2,2,2048));							 
					  
					  if(substr($linea2,0,3) == "***")
					     $clase->EjecutarSQL(substr($linea2,3,2048));
					 
				   }
                } 
			 }
			  
		  }	 
 
		 $numlinea++;	
       } /// Fin del While
	   
     } /// Fin de If File Exist
	 
	/// Le Asigno el Consecutivo Unioco de Pedidos de Sucursales PVE - DEP - 0000X
	$numante = $clase->SeleccionarUno("SELECT CONCAT(tipodoc,prefijo,numero) FROM documentos WHERE docuid=".$docuid);		 
    $numero = $clase->SeleccionarUno("SELECT numero FROM consecutivos WHERE tipodoc='PVE' AND prefijo='DEP'");		 
	$numerox = str_pad(($numero+1),6,0,STR_PAD_LEFT);
	$clase->EjecutarSQL("UPDATE consecutivos SET numero = ".$numerox." WHERE tipodoc='PVE' AND prefijo='DEP'");	 
		
	/// Si es Urgente Lo reverso
	$clase->EjecutarSQL("UPDATE documentos SET observacion = CONCAT('".$numante."',' ',observacion) , prefijo = 'DEP' , numero = '".$numerox."', fecasentado = '0000-00-00' , impreso='N' WHERE docuid=".$docuid);		 
		 
	/// Cierro el Archivo
    fclose($fp);
	
	/// Elimino el Archivo  luego de Cargar la remision para prevenir almacenamiento en Disco
	
	if(file_exists($ruta))
	 unlink($ruta);
    	
 	return($docuid);	 	 

  } // Fin de la Funcion


  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////  
  function CargarRemisionAutomatica($numerorem)
  {
     $clase = new Sistema();
	 $ruta      = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/automatico/".$numerorem;
	 $rutahecho = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/transferencias/".$numerorem;
	 
	 if(file_exists($ruta))
	 {	 
       $docuid = "";
	   $numlinea = 1;
	   
	   $fp = fopen($ruta,"r");	   
	   while ($linea= fgets($fp,1024))
       {
	      if($numlinea == 1)
		  {
		    $clase->EjecutarSQL($linea);			
		  }		  
		  else
		  {	
			 if($numlinea == 2)  
			 {
		        $clase->EjecutarSQL(substr($linea,1,2048));
			 }	
			 else
			 {
			    if($numlinea == 3)
				{
				  if(substr($linea,0,11)=='|SELECTUNO|')  
		            $docuid = $clase->SeleccionarUno(substr($linea,11,2048));
					
			      $clase->EjecutarSQL("UPDATE documentos SET base = 0 , iva = 0 , total = 0 WHERE docuid=".$docuid);		
				} 
				else
				{
				   if($docuid != "")
				   {
				      $linea2 = str_replace("|||||",$docuid,$linea);
					 
					  if(substr($linea2,0,3) == "**I")
					     $clase->EjecutarSQL(substr($linea2,2,2048));							 
					  
					  if(substr($linea2,0,3) == "***")
					     $clase->EjecutarSQL(substr($linea2,3,2048)); 					 				   
				   }
                } 
			 }
			  
		  }	 
		 
		 $numlinea++;	
		   		  
       } /// Fin del While
	   
	    /// Asiento la Tranferencia para que Descuente el Inventario
		$fechadoc  = date("Y-m-d");
        $vsql = "UPDATE documentos SET fecasentado ='".$fechadoc."' WHERE docuid=".$docuid;
		$clase->EjecutarSQL($vsql);
	   
     } /// Fin de If File Exist
	
	/// Cierro el Archivo Ocupado
	@fclose($fp);
	
	/// Genero la Impresion del Documento
	ImpresionPOSGeneral($docuid);
	
	/// Finalizado el Proceso, Muevo el Archivo a hecho
	@copy($ruta,$rutahecho);
	@unlink($ruta);	 	 
  } 
  
  //////////////////////////////////////////////////////////////////////
  ////           Impresion de Ajuste de Inventario
  //////////////////////////////////////////////////////////////////////  
  function ImpresionPOSGeneral($docuid,$copias=1)
  {
     $clase = new Sistema();	 
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
     $cont = $nomempresa.Chr(13).Chr(10);	 
	 
	 /// Cargo las configuraciones del Prefijo del Documento
	 $tipodoc = $clase->BDLockup($docuid,"documentos","docuid","tipodoc");
	 $prefijo = $clase->BDLockup($docuid,"documentos","docuid","prefijo");	  
	 $nomdocumento = $clase->BDLockup($tipodoc,"tipodoc","codigo","descripcion");	  
	 
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.creador , D.fecanulado , D.observacion , D.iva ,  D.total , t.dni codcliente , D.terid2 , D.terid3 , 
	 		  CONCAT(T.nombres,' ',T.apellidos) nomcliente , T.dni , T.direccion , T.telfijo , DD.bodegaid , P.codigo codproducto , P.descripcion nomproducto , DD.valunitario , 
			  SUM(DD.cantidad) cantidad , SUM(DD.unidades) unidades ,  SUM(DD.valparcial) valparcial 
			  FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid1)
			  INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
			  INNER JOIN productos P ON (P.productoid = DD.productoid)
			  WHERE D.docuid=".$docuid." GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20 ";

     if($tipodoc == "AJU")
	   $vsql.= 'ORDER BY cantidad DESC , P.descripcion';
	   
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
     
 	 while($row = mysql_fetch_array($result))
	 { 
	   $teriddomi = $row['terid3'];
	   $tipodoc = $row['tipodoc'];                       $prefijo = $row['prefijo'];
 	   $numero  = $row['numero'];
 	   $fecha   = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);
 	   $hora    = substr($row['fechadoc'],11,2).":".substr($row['fechadoc'],14,2); 	   

   	   $observacion = $row['observacion'];  	   
   	   $cantidad = $row['cantidad']; 
	   $creador  = $row['creador']; 	   
   	   $total    = $row['total']; 
	     
	   if($tipodoc == "AJU")
	   {    
    	 if($cantidad < 0)  $mov = "SAL - "; else $mov = "ENT - ";
		 $bodega = $clase->BDLockup($row['bodegaid'],'bodegas','bodegaid','codbodega');
		 $encabezado1 = ''; 
	     $detalles.= $mov.str_pad(substr($row['nomproducto'],0,20),20," ",STR_PAD_RIGHT).'  ';
	     $detalles.= str_pad(number_format($row['unidades'],1),3," ",STR_PAD_LEFT).'  '.str_pad(number_format($row['valparcial'],0),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   
		 $titulodet = 'MOV   PRODUCTO             CANT      TOTAL';
	   }
	   
	   if(($tipodoc == "REN")||($tipodoc == "INF"))
	   {    
	     $bodega = $clase->BDLockup($row['bodegaid'],'bodegas','bodegaid',"nombodega");
		 $encabezado1 = 'BODEGA   : '.$bodega; 
		 $detalles.= str_pad(substr($row['nomproducto'],0,26),26," ",STR_PAD_RIGHT).'  ';
	     $detalles.= str_pad($row['cantidad'],3," ",STR_PAD_LEFT).'  '.str_pad(number_format($row['valparcial']),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   
		 $titulodet = 'PRODUCTO                 CANT      TOTAL';
	   }
	   
	   if($tipodoc == "TRB")
	   {    
	     $bodegaori = $clase->BDLockup($row['bodegaid'],'bodegas','bodegaid',"nombodega");
		 $vsql1 = "SELECT nombodega FROM bodegas B INNER JOIN docutranfe DT ON (DT.bodegaidori = B.bodegaid) WHERE docuid=".$docuid;
		 $vsql2 = "SELECT nombodega FROM bodegas B INNER JOIN docutranfe DT ON (DT.bodegaiddes = B.bodegaid) WHERE docuid=".$docuid;		 
		 $bodori = $clase->SeleccionarUno($vsql1);
		 $boddes = $clase->SeleccionarUno($vsql2);		 
		 $encabezado1 = 'BOD. ORIGEN : '.$bodori.Chr(13).Chr(10);
		 $encabezado1.= 'BOD. DESTIN : '.$boddes;
		 $detalles.= str_pad(substr($row['nomproducto'],0,24),24," ",STR_PAD_RIGHT).'  ';
	     $detalles.= str_pad($row['unidades'],3," ",STR_PAD_LEFT).'  '.str_pad(number_format($row['valparcial']),9," ",STR_PAD_LEFT);
		 $detalles.= Chr(13).Chr(10); 	   
		 
		 $titulodet = 'PRODUCTO                 CANT      TOTAL';
	   } 
	   	 
     } 
     $cont.= $nomdocumento.Chr(13).Chr(10);
	 $cont.= 'No.'.$prefijo.' '.$numero.Chr(13).Chr(10);
     $cont.= '----------------------------------------'.Chr(13).Chr(10); 
	 $cont.= 'OBS : '.$observacion.Chr(13).Chr(10);	 	 
     $cont.= '----------------------------------------'.Chr(13).Chr(10); 	 
	 $cont.= 'FECHA   : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
	 $cont.= 'CREADOR : '.$creador.Chr(13).Chr(10);	 
     if($encabezado1 != "")
	 {
	    $cont.= '----------------------------------------'.Chr(13).Chr(10);          	 	
	    $cont.= $encabezado1.Chr(13).Chr(10);
	 }
	 $cont.= '----------------------------------------'.Chr(13).Chr(10);          	 	
     $cont.= $titulodet.Chr(13).Chr(10);
     $cont.= '========================================'.Chr(13).Chr(10);     
	 $cont.= $detalles;	 
	 $cont.= '                          --------------'.Chr(13).Chr(10);     
	 $cont.= '         TOTAL DOC : '.$_SESSION['G_MONEDALOCAL'].'   '.str_pad(number_format($total),16," ",STR_PAD_LEFT).Chr(13).Chr(10);     	 
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).'.'.Chr(13).Chr(10);     
	 	 
	 for($c=0;$c<$copias;$c++)
	 {
	    // Genero el Archivo para Enviarlo a Impresora
	    $archivo= "print/".$prefijo.$numero."-".$c.".txt"; // el nombre de tu archivo
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en �l
        fwrite($fch, $cont); // Grabas
        fclose($fch); // Cierras el archivo
     }
	 
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("dmy")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 	 
  } // Fin de la Funcion
  
  /////////////////////////////////////////////////////////////////////////  
  function ImpresionPOSKardex($vsql)
  {
	 $clase = new Sistema();
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
	 $nitempresa = $_SESSION['G_NIT_EMPRESA'];
     $sucursal   = $_SESSION['G_SUCURSALPOS'];
	 $nomsucursal = $clase->BDLockup($sucursal,'sucursales','codigo','descripcion');
	 $momento    = date(DATE_RFC2822);
	 
	 $cont.=  Chr(13).Chr(10).$nomempresa.Chr(13).Chr(10);	
	 $cont.=  $nitempresa.Chr(13).Chr(10);		 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= 'SUCURSAL : '.$nomsucursal.Chr(13).Chr(10);               
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          

	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
     $grupo = "";
	 while($row = mysql_fetch_array($result))  	
	 {
       $grupo = $row['grupo'];
	   $encab = 'BODEGA : '.$row['nombodega'].Chr(13).Chr(10);		 
       $encab.= '---------------------------------------'.Chr(13).Chr(10);          	   
       $encab.= 'LABORAT: '.$row['grupo'].Chr(13).Chr(10);		 	   
       $encab.= '======================================='.Chr(13).Chr(10); 
       $encab.= 'ARTICULO/CODIGO    UNIDAD   CAJ    UNID'.Chr(13).Chr(10);		 	   	            	   	   
       $encab.= '======================================='.Chr(13).Chr(10);          	   	   	   
       
	   $empaque  = $row['factor1'];
	   $detallar = $row['detallar'];
       $existencia = $row['cantidad'];
	   
	   if(abs($existencia) == 0){
	        $cajas = 0;     $unidades = 0;
   	   }
       else
       {
		 $partescanti = explode(".",$existencia);
       	 $cajas       = $partescanti[0];		  
         $decimal     = (round($existencia,10)-$cajas);
         $unidades    =  number_format(round(($decimal*$empaque),0),0);	
         if(($unidades == $empaque)&&($unidades!=0)){ 
	           $cajas++;
	           $unidades=0;
          }     
       } 
	   	
       $det  .= substr($row['descripcion'],0,40).Chr(13).Chr(10);
       $det  .= str_pad(substr($row['codigo'],0,15),15," ",STR_PAD_RIGHT).'     '.str_pad(substr($row['unidet'],0,4),4," ",STR_PAD_RIGHT).'  ';
	   $det  .= str_pad(substr(number_format($cajas,0),0,5),5," ",STR_PAD_LEFT);

	   if($_SESSION['G_MODOTRABAJO'] == "PUNTODEVENTA")
  	       $det  .= str_pad(substr(number_format($unidades,0),0,5),5," ",STR_PAD_LEFT).Chr(13).Chr(10);	   
	   else
           $det  .= str_pad(substr(number_format($unidades,0),0,5),5," ",STR_PAD_LEFT)."    _______  _______".Chr(13).Chr(10);	   	   	   
	 }  

     //// Genero la Tira 
	 $cont.= $encab.$det.Chr(13).Chr(10).$momento.Chr(13).Chr(10).Chr(13).Chr(10);
     /// Web
     $cont.= str_pad($_SESSION['G_SITIOWEB_PRO'],39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.';
     if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR") 
        $cont.= Chr(12).Chr(13);     
	 
     ////// Adiciono al Log la informacion
	 $clase->CrearLOG('018','Se genero informe de Kardex por Laboratorio',strtoupper($_SESSION["USERNAME"]),$vsql);    
	 
	 // Genero el Archivo para Enviarlo a Impresora
	 if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR") 
    	 $archivo= "../Dropbox/00/print/Kardex_".$grupo.".txt"; // el nombre de tu archivo
     else
	 	 $archivo= "print/Kardex_".$grupo.".txt"; // el nombre de tu archivo
		 
	 $fch= fopen($archivo, "w"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("dmy")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo	 
	 
  } // Fin de la Funcion
 
  ///////////////////////////////////////////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////////////////////////////////
  function RecordatoriosLlamadas($fecha)
  {
     $clase = new Sistema();
	 $sucid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid');	 
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
	 $nitempresa = $_SESSION['G_NIT_EMPRESA'];

	 $enca =  Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).$nomempresa.Chr(13).Chr(10);	
	 $enca.=  $nitempresa.Chr(13).Chr(10);		 
     $enca.= '---------------------------------------'.Chr(13).Chr(10);          
	 $deta = "";
	 
	 /// Hago la Consulta de los datos del cierre
	 $vsql = "SELECT D.fechadoc, DATE_ADD( D.fechadoc, INTERVAL DD.diasrecor DAY ) as fecharec, P.descripcion nomproducto , T.* 
	          FROM documentos D INNER JOIN dedocumentos DD ON ( D.docuid = DD.docuid ) INNER JOIN productos P ON (P.productoid = DD.productoid) 
			  INNER JOIN terceros T ON (T.terid = D.terid1) 
			  WHERE DD.diasrecor >0 AND EXTRACT( DAY FROM DATE_ADD( D.fechadoc, INTERVAL DD.diasrecor DAY )) = '".substr($fecha,8,2)."'";

	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 while($row = mysql_fetch_array($result))
	 { 
 	   $fecha        = substr($row['momento'],8,2)."/".substr($row['momento'],5,2)."/".substr($row['momento'],0,4);
 	   $hora         = substr($row['momento'],11,2).":".substr($row['momento'],14,2); 	    	   
	   $cliente      = substr($row['nombres'].' '.$row['apellidos'],0,24); 
	   $telcliente   = substr($row['telfijo'].' '.$row['telmovil'],0,24); 	   
	   $dircliente   = substr($row['direccion'],0,24); 	   	   
	   $producto     = substr($row['nomproducto'],0,24); 
	   
	   $deta .= "CLIENTE : ".$cliente.Chr(13).Chr(10);
	   $deta .= "MEDICAM : ".$producto.Chr(13).Chr(10);
	   $deta .= "TELEFON : ".$telcliente.Chr(13).Chr(10);
	   $deta .= "DIRECCI : ".$dircliente.Chr(13).Chr(10);	   	   	     
       $deta .= '---------------------------------------'.Chr(13).Chr(10);          
     } 

	 $enca.= 'FECHA   : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
     $enca.= '======================================='.Chr(13).Chr(10);          	 	
	 $enca.= '****  RECORDATORIO DE LLAMADAS  *****    '.Chr(13).Chr(10);    
	 $enca.= '======================================='.Chr(13).Chr(10);     
     
     $cont = $enca.$deta;
	 
     $cont.= str_pad("www.dromedicas.com.co",39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.';     
	 
     ////// Adiciono al Log la informacion
	 $clase->CrearLOG('018','Se imprimio el informe de recordatorios',strtoupper($_SESSION["USERNAME"]),'');    
	 
	 // Genero el Archivo para Enviarlo a Impresora
	 $archivo= "print/fichero.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("dmy")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo	 	 
  }

  ////////////////////////////////////////////////////////////////////////
  function ActualizarDiaOperativoServidor()  
  {
     $clase = new Sistema();
     if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR")
	 {
	      $diahoy = date("d/m/Y");
		  if($diahoy != $_SESSION['G_DIAOPERATIVO'])
		  {   	 
	         $_SESSION['G_DIAOPERATIVO'] = $diahoy;
		     $clase->EjecutarSQL("UPDATE configuraciones SET contenido ='".$diahoy."' WHERE variab='G_DIAOPERATIVO'");
	      }		  
	 }  
  }  

  /////////////////////////////////////////////////////////////////////////////////////////////////
  function Actualizarsihayceros($docuid) 
  {
     $clase = new Sistema();
	 $vsql="SELECT DISTINCT productoid , bodegaid FROM dedocumentos WHERE docuid=".$docuid;
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
	 while($row = mysql_fetch_array($result)) 
	 { 
         $pid = $row['productoid'];
		 $bid = $row['bodegaid'];
		 
		 $vsql2 = "SELECT SUM(if(cantidad>0,cantidad,'')) entradas , SUM(if(cantidad<0,cantidad,'')) salidas 
                   FROM kardex WHERE productoid=".$pid." AND bodegaid=".$bid;
  		 
         $result2 = mysql_query($vsql2,$conex);
	     while($row2 = mysql_fetch_array($result2)) 
	     { 
	         $entradas = round($row2['entradas'],2);
			 $salidasx = round($row2['salidas'],2);
			 $salidas  = (-1)*$salidasx;
			 if(strcmp($entradas,$salidas) == 0)
			   $clase->EjecutarSQL("UPDATE existencias SET cantidad = 0 WHERE bodegaid=".$bid." AND productoid=".$pid);
		 }
     }
	 return;
  }  


 /////////////////////////////////////////////////
																																																																																																																																																																																																																																																																																																																																																																																																																				 function GenerarExistenciasAServidor()
 {
     ini_set("memory_limit","100M");
	 error_reporting(E_ALL);
     $clase = new Sistema();
	 $bodegaid = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS'],'bodegas','codbodega','bodegaid');
	 
	 /// Elimino el Archivo 
	 $archivo1 = "../Dropbox/Todos/ULT-Existencias-".$_SESSION['G_SUCURSALPOS'].".sql";
	 if(file_exists($archivo1))
       unlink($archivo1);

	 $clase = new Sistema();
	 $vsql = "SELECT * FROM existencias WHERE bodegaid =".$bodegaid." AND cantidad <> 0";
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
	 $fp = fopen($archivo1,"w");
	 $cont="";
	 $i=0;
	 while($row = mysql_fetch_array($result))
	 { 
	   if($i==0)
	      $cont.="UPDATE IGNORE existencias SET cantidad = 0 WHERE bodegaid=".$row['bodegaid'].";".Chr(13).Chr(10);	   
		  
	   $cont.="UPDATE IGNORE existencias SET cantidad =".$row['cantidad']." WHERE bodegaid=".$row['bodegaid']." AND productoid=".$row['productoid'].";".Chr(13).Chr(10);	   
	   $i++;
	 } 
     
	 /// Ingreso otros Parametros de Actualizacion	 
	 $version = $clase->BDLockup('G_VERSIONAPP','configuraciones','variab','contenido');
	 $cont.="UPDATE IGNORE sucursales SET version='".$version."' , diaoperativo='".$_SESSION['G_DIAOPERATIVO']."' , ultcierre='".date("dMY His")."' WHERE codigo='".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);	   
	 	  
	 fwrite($fp,$cont);
     fclose($fp);	 

	 ///////////////////////////////////////////////////////////
	 /// Genero el Archivo de KARDEX
     GenerarArchivoKardex(date("mY"));	 
 } 
  
 ////////////////////////////////////////////////////
 function GenerarArchivoKardex($periodo)
 {
     ini_set("memory_limit","100M");
	 error_reporting(E_ALL);

     $archivo = "../Dropbox/Todos/ULT-Kardex-".$_SESSION['G_SUCURSALPOS'].".sql";
	 if(file_exists($archivo))
	   unlink($archivo);
	 
	 $clase = new Sistema();
	 $vsql = "SELECT * FROM kardex WHERE periodo = '".$periodo."' ORDER BY fechadoc ASC";
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
	 $fp = fopen($archivo,"w");
	 $cont="";	 
	 $i=0;
	 while($row = mysql_fetch_array($result))
	 { 
	   if($i==0)
	      $cont.="DELETE FROM KARDEX WHERE periodo = '".$periodo."' AND bodegaid=".$row['bodegaid'].";".Chr(13).Chr(10);	
		   
	   $cont.="INSERT IGNORE INTO kardex(tipodoc,prefijo,fechadoc,numero,productoid,periodo,bodegaid,sucursalid,cantidad,creador,momento) values('".
	          $row['tipodoc']."','".$row['prefijo']."','".$row['fechadoc']."','".$row['numero']."',".$row['productoid'].",'".$row['periodo']."',".
			  $row['bodegaid'].",".$row['sucursalid'].",".$row['cantidad'].",'VENDEDOR','".$row['momento']."');".Chr(13).Chr(10);	   
	   $i++;		  
	 }       
	 fwrite($fp,$cont);
     fclose($fp);	 
  }  


 ////////////////////////////////////////////////////
 function GenerarConsolidado($periodo)
 {
	if($periodo != "")
	{
	ini_set("memory_limit","100M");
	error_reporting(E_ALL);

    $archivo = "../Dropbox/Todos/CONSOLIDA-".$periodo."-".$_SESSION['G_SUCURSALPOS'].".sql";
	if(file_exists($archivo))
	   unlink($archivo);
	 
	 $clase = new Sistema();
	 $vsql = "SELECT doc.tipodoc AS TIPODOC,doc.prefijo AS PREFIJODOC,doc.numero AS NUMERODOC
,doc.fechadoc AS FECHADOC,doc.periodo AS PERIODODOC,doc.formapago AS FORMAPAGODOC,cli.dni AS DNICLIDOC,cli.nombres AS NOMBRESCLIDOC,cli.apellidos AS APECLIDOC
,cli.direccion AS DIRCLIDOC,concat(cli.telfijo,_utf8' ',cli.telmovil) AS TELCLIDOC,ven.codvende AS CODVENDOC,ven.nombres AS NOMVENDOC,ven.apellidos AS APEVENDOC
,men.codvende AS CODMENDOC,men.nombres AS NOMMENDOC,men.apellidos AS APEMENDOC,med.codmedico AS CODMEDDOC,med.dni AS DNIMEDDOC,med.nommedico AS NOMMEDDOC
,doc.observacion AS OBSERVADOC,doc.totalitems AS ITEMSDOC,doc.base AS VRBASEDOC,doc.iva AS VRIVADOC,suc.codigo AS CODSUCURSAL,suc.descripcion AS NOMSUCDOC
,doc.creador AS CREDORDOC,doc.momento AS MOMENTODOC,doc.total AS TOTALDOC,bod.codbodega AS DECODBOD,bod.nombodega AS DENOMBOD,dd.cantidad AS DECANTIDAD
,dd.valunitario AS DEVALUNI,dd.valparcial AS DEVALPAR,dd.valbase AS DEVALBASE,dd.valiva AS DEVALIVA,dd.valtotal AS DEVALTOTAL,dd.unicom AS DEUNICOM
,dd.unifra AS DEUNIFRA,dvt.diaoperativo AS DVDIAOPE,ddv.diaoperativo AS DDDIAOPE,dvt.valorfp1 AS FPEFECTIVO,(dvt.valorfp2+dvt.valorfp3) AS FPTARJETAS,dvt.valorfp4 AS FPOTROS,pro.codigo AS CODPRODUCTO,pro.descripcion AS NOMPRODUCTO,lab.codigo AS CODLABO,lab.descripcion AS NOMLABO FROM (((((((((((documentos DOC join sucursales SUC on((doc.sucursalid = suc.sucursalid))) join terceros CLI on((cli.terid = doc.terid1))) join terceros VEN on((ven.terid = doc.terid2))) join terceros MEN on((men.terid = doc.terid3))) join dedocumentos DD on((doc.docuid = dd.docuid))) join bodegas BOD on((bod.bodegaid = dd.bodegaid))) join productos PRO on((pro.productoid = dd.productoid))) join gruposprod LAB on((lab.gruposprodid = pro.gruposprodid))) left join docuventa DVT on((doc.docuid = dvt.docuid))) left join medicos MED on((med.medicoid = dvt.medicoid))) left join docudevolucion DDV on((doc.docuid = ddv.docuid))) where ((doc.periodo = _utf8'".$periodo."') and (doc.fecasentado <> _utf8'0000-00-00') and ((doc.tipodoc = _utf8'FVE') or (doc.tipodoc = _utf8'DVE') or (doc.tipodoc = _utf8'DVE')))";
	 
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
	 $fp = fopen($archivo,"w");
	 $cont="";	 
	 $i=0;
	 while($row = mysql_fetch_array($result))
	 { 
	   if($i==0)
	      $cont.="DELETE FROM consolida1 WHERE PERIODODOC = '".$periodo."' AND DECODBOD='".$row['DECODBOD']."';".Chr(13).Chr(10);	
		   
	   $cont.="INSERT INTO consolida1(TIPODOC, PREFIJODOC, NUMERODOC, FECHADOC, PERIODODOC, FORMAPAGODOC, DNICLIDOC, NOMBRESCLIDOC, APECLIDOC, DIRCLIDOC, TELCLIDOC, CODVENDOC, NOMVENDOC, APEVENDOC, CODMENDOC, NOMMENDOC, APEMENDOC, CODMEDDOC, DNIMEDDOC, NOMMEDDOC, OBSERVADOC, ITEMSDOC, VRBASEDOC, VRIVADOC, CODSUCURSAL, NOMSUCDOC, CREDORDOC, MOMENTODOC, TOTALDOC, DECODBOD, DENOMBOD, DECANTIDAD, DEVALUNI, DEVALPAR, DEVALBASE, DEVALIVA, DEVALTOTAL, DEUNICOM, DEUNIFRA, DVDIAOPE, DDDIAOPE, FPEFECTIVO , FPTARJETAS , FPOTROS , CODPRODUCTO, NOMPRODUCTO, CODLABO, NOMLABO, MOMINSERTADO) VALUES ('".$row['TIPODOC']."','".$row['PREFIJODOC']."','".$row['NUMERODOC']."','".$row['FECHADOC']."','".$row['PERIODODOC']."','".$row['FORMAPAGODOC']."','".$row['DNICLIDOC']."','".$row['NOMBRESCLIDOC']."','".$row['APECLIDOC']."','".$row['DIRCLIDOC']."','".$row['TELCLIDOC']."','".$row['CODVENDOC']."','".$row['NOMVENDOC']."','".$row['APEVENDOC']."','".$row['CODMENDOC']."','".$row['NOMMENDOC']."','".$row['APEMENDOC']."','".$row['CODMEDDOC']."','".$row['DNIMEDDOC']."','".$row['NOMMEDDOC']."','".$row['OBSERVADOC']."','".$row['ITEMSDOC']."','".$row['VRBASEDOC']."','".$row['VRIVADOC']."','".$row['CODSUCURSAL']."','".$row['NOMSUCDOC']."','".$row['CREDORDOC']."','".$row['MOMENTODOC']."','".$row['TOTALDOC']."','".$row['DECODBOD']."','".$row['DENOMBOD']."','".$row['DECANTIDAD']."','".$row['DEVALUNI']."','".$row['DEVALPAR']."','".(0+$row['DEVALBASE'])."','".(0+$row['DEVALIVA'])."','".(0+$row['DEVALTOTAL'])."','".$row['DEUNICOM']."','".$row['DEUNIFRA']."','".$row['DVDIAOPE']."','".$row['DDDIAOPE']."',".(0+$row['FPEFECTIVO']).",".(0+$row['FPTARJETAS']).",".(0+$row['FPOTROS']).",'".$row['CODPRODUCTO']."','".$row['NOMPRODUCTO']."','".$row['CODLABO']."','".$row['NOMLABO']."',CURRENT_TIMESTAMP);".Chr(13).Chr(10);	   
	   $i++;		  
	 }  

	 fwrite($fp,$cont);
     fclose($fp);	 
   }	 
  }  


  
  ///////////////////////////////////////////////////////////////////////////////// 
  ////   INTERFAZ DROPOS - VISUAL TNS
  /////////////////////////////////////////////////////////////////////////////////  
  ////   1. COMPRAS
  ////   Al asentar una Compra - Genera el registro en TNS /  
  /////////////////////////////////////////////////////////////////////////////////
  function QUITARCompraTNS($docuid)
  {
	 $clase = new Sistema();
	 $claseTNS = new Datos();
 
     $vsql = "SELECT * FROM documentos D INNER JOIN terceros T ON (D.terid1 = T.terid) WHERE docuid=".$docuid;
	 $con  = $clase->Conectar();
     $result = mysql_query($vsql,$con);

	 if($row = mysql_fetch_array($result))
	 {
        $codcomp    = "FC";
        $codprefijo = "XX";
        $numero     = $row['numero'];
        
        // 1. ME CONECTO
		// Lo Busco - Si Existe Lo Elimino y lo SobreEscribo
		$conex = $claseTNS->Conectar();
        
		// 2. ELIMINO LA COMPRA - SI LA HAY
        // Busco el KARDEXID de la Compra Existente
        $kardexid    = $claseTNS->SelectOne($conex,"SELECT KARDEXID FROM KARDEX WHERE CODCOMP='FC' AND CODPREFIJO='00' AND NUMERO='".$numero."'");
		if($kardexid!="")
		{
		  // Elimino lo que hay de Prueba
		  $vsqlTNS0 = "DELETE FROM DEKARDEX WHERE KARDEXID=".$kardexid;
		  $claseTNS->Consulta($conex,$vsqlTNS0);   
		  
		  $vsqlTNS0 = "DELETE FROM KARDEX WHERE KARDEXID=".$kardexid;
		  $claseTNS->Consulta($conex,$vsqlTNS0);   
        }
 	 }
  }

  //////////////////////////////////////////////////  
  function EnviarCompraTNS($docuid)
  {
	 $clase = new Sistema();
	 $claseTNS = new Datos();
 
     $vsql = "SELECT * FROM documentos D INNER JOIN terceros T ON (D.terid1 = T.terid) WHERE docuid=".$docuid;
	 $con  = $clase->Conectar();
     $result = mysql_query($vsql,$con);

	 if($row = mysql_fetch_array($result))
	 {
        $codcomp    = "FC";
        $codprefijo = "XX";
        $numero     = $row['numero'];
        $nrodocref  = $row['nrodocref'];		
		$obs        = 'Factura de Compra No. FCO '.$row['prefijo'].' '.$row['numero'].' generado por DROPos v. '.$_SESSION['G_VERSIONAPP'];        
        $fecha      = substr($row['fechadoc'],5,2).'/'.substr($row['fechadoc'],8,2).'/'.substr($row['fechadoc'],0,4);
        $formapago  = 'CR';		
		$total      = $row['total'];
        $periodo    = substr($fecha,0,2);
        
        // 1. ME CONECTO
		// Lo Busco - Si Existe Lo Elimino y lo SobreEscribo
		$conex = $claseTNS->Conectar();
        
		// 2. CREO EL TERCERO SI NO ESTA EN TNS
		// Busco la Informacion del Tercero
		$terid    = $claseTNS->SelectOne($conex,"SELECT TERID FROM TERCEROS WHERE NIT='".$row['dni']."' OR NITTRI='".$row['dni']."'");				
		if($terid == "")
		{
		   $vsql1 = "INSERT INTO TERCEROS(TIPODOCIDEN,CIUDANEID,CLASIFICAID,ZONA1,ZONA2,FECHCREAC,NIT,NITTRI,NOMBRE,PROVEED,OBSERV) 
		             VALUES('C',1,1,1,1,'".date("m/d/Y")."','".$row['codigo']."','".$row['dni']."','".
					 $row['nombres']." ".$row['apellidos']."','S','Creado por DROPos')";
		   $claseTNS->Consulta($conex,$vsql1);     	   
		   $terid    = $claseTNS->SelectOne($conex,"SELECT TERID FROM TERCEROS WHERE NITTRI='".$row['dni']."'");					
		}
		
		// 2. ELIMINO LA COMPRA - SI LA HAY
        // Busco el KARDEXID de la Compra Existente
        $kardexid    = $claseTNS->SelectOne($conex,"SELECT KARDEXID FROM KARDEX WHERE CODCOMP='FV' AND CODPREFIJO='00' AND NUMERO='".$numero."'");
		if($kardexid=="")
		{
         // 4. INSERTO EL ENCABEZADO DEL DOCUMENTO
		 // Inserto el Encabezado del Comprobante
         $vsqlTNS1 = "INSERT INTO KARDEX( CODCOMP , CODPREFIJO , NUMERO , FECHA , OBSERV , PERIODO , BCOID , CENID , AREADID , SUCID , RETIVA , RETICA , RETFTE , AJUSTEBASE , AJUSTEIVA , AJUSTEIVAEXC , AJUSTENETO , CLIENTE , VENDEDOR , FORMAPAGO , NROFACPROV , VRBASE , VRIVA , VRICONSUMO,VRRFTE,VRRICA,VRRIVA,TOTAL,FPCONTADO,FPCREDITO,FACTORCONV,IMPORTADO , USUARIO) 
		              VALUES('FC','".$prefijo."','".$numero."','".$fecha."','Importado de Dropos v ".$_SESSION['G_VERSIONAPP']." el ".
			 		 date("d/m/Y")."','".date("m")."',1,1,1,1,0,0,0,0,0,0,0,".$terid.",1,'".$formapago."','".$nrodocref."',".$total.",0,0,0,0,0,".$total.",0,".$total.",1,'S','ADMIN')";
		 $claseTNS->Consulta($conex,$vsqlTNS1);
        
		 // 5. BUSCO EL KARDEXID 
         $kardexid    = $claseTNS->SelectOne($conex,"SELECT MAX(KARDEXID) kardexid FROM KARDEX");

         // 6. INSERTO EL ENCABEZADO DEL DOCUMENTO
		 // Inserto el Detalle
          $vsqlTNS2 = "INSERT INTO DEKARDEX( KARDEXID , MATID , BODID , TIPUND , CANLISTA , CANMAT , PORCIVA , PRECIOBASE , 
		               PRECIOIVA , PRECIOVTA , PRECIONETO , PARCVTA ) VALUES(".$kardexid.",3,1,'D',1,1,0,".$total.",".$total.
					   ",".$total.",".$total.",".$total.")";
		  $claseTNS->Consulta($conex,$vsqlTNS2);
         }
		 else
		   $clase->Aviso(2,'La Factura ya existe en TNS');

       $claseTNS->desconectar($conex);
     }
  }  

  ////////////////////////////////////////////////////////////////////////////  
  //// 2. INTERFAZ DE VENTAS                                              ////  
  ////////////////////////////////////////////////////////////////////////////  
  function QUITARVentaTNS($docuid)
  {
	 $clase = new Sistema();
	 $claseTNS = new Datos();
 
     $vsql = "SELECT * FROM documentos D INNER JOIN terceros T ON (D.terid1 = T.terid) WHERE docuid=".$docuid;
	 $con  = $clase->Conectar();
     $result = mysql_query($vsql,$con);

	 if($row = mysql_fetch_array($result))
	 {
        $codcomp    = "FC";
        $codprefijo = "XX";
        $numero     = $row['numero'];
        
        // 1. ME CONECTO
		// Lo Busco - Si Existe Lo Elimino y lo SobreEscribo
		$conex = $claseTNS->Conectar();
        
		// 2. ELIMINO LA COMPRA - SI LA HAY
        // Busco el KARDEXID de la Compra Existente
        $kardexid    = $claseTNS->SelectOne($conex,"SELECT KARDEXID FROM KARDEX WHERE CODCOMP='FC' AND CODPREFIJO='00' AND NUMERO='".$numero."'");
		if($kardexid!="")
		{
		  // Elimino lo que hay de Prueba
		  $vsqlTNS0 = "DELETE FROM DEKARDEX WHERE KARDEXID=".$kardexid;
		  $claseTNS->Consulta($conex,$vsqlTNS0);   
		  
		  $vsqlTNS0 = "DELETE FROM KARDEX WHERE KARDEXID=".$kardexid;
		  $claseTNS->Consulta($conex,$vsqlTNS0);   
        }
 	 }
  }
        
  //////////////////////////////////////////////////  
  function EnviarVentasaTNS($docuid)
  {
     $clase = new Sistema();
	 $claseTNS = new Datos();
 
     $vsql = "SELECT * FROM documentos D INNER JOIN terceros T ON (D.terid1 = T.terid) WHERE docuid=".$docuid;
	 $con  = $clase->Conectar();
     $result = mysql_query($vsql,$con);

	 if($row = mysql_fetch_array($result))
	 {
        $codcomp    = "FV";
        $codprefijo = date("m");
        $numero     = $row['numero'];
        $nrodocref  = $row['nrodocref'];		
		$mesfv      = substr($row['fechadoc'],8,2);
		$obs        = 'Factura de Venta Credito No. FVE '.$row['prefijo'].' '.$row['numero'].' generado por DROPos v. '.$_SESSION['G_VERSIONAPP'];        
        $fecha      = substr($row['fechadoc'],5,2).'/'.$mesfv.'/'.substr($row['fechadoc'],0,4);
        $fecvence   = substr($row['fechadoc'],5,2).'/'.($mesfv+1).'/'.substr($row['fechadoc'],0,4);		
        $formapago  = "CR";
		$total      = $row['total'];
        $periodo    = substr($fecha,0,2);
        
        // 1. ME CONECTO
		// Lo Busco - Si Existe Lo Elimino y lo SobreEscribo
		$conex = $claseTNS->Conectar();
        
		// 2. ELIMINO LA COMPRA - SI LA HAY
        // Busco el KARDEXID de la Compra Existente
        $kardexid    = $claseTNS->SelectOne($conex,"SELECT KARDEXID FROM KARDEX WHERE CODCOMP='FV' AND CODPREFIJO='".$codprefijo."' AND NUMERO='".$numero."'");
		if($kardexid!="")
		{
		  // Elimino lo que hay de Prueba
		  $vsqlTNS0 = "DELETE FROM KARDEX WHERE CODCOMP='FV' AND CODPREFIJO='".$codprefijo."' AND NUMERO='".$numero."'";
		  $claseTNS->Consulta($conex,$vsqlTNS0);   
        }
		
		// 3. CREO EL TERCERO SI NO ESTA EN TNS
		// Busco la Informacion del Tercero
		$terid    = $claseTNS->SelectOne($conex,"SELECT TERID FROM TERCEROS WHERE NIT='".$row['dni']."' OR NITTRI='".$row['dni']."'");				
		if($terid == "")
		{
		   $vsql1 = "INSERT INTO TERCEROS(TIPODOCIDEN,CIUDANEID,CLASIFICAID,ZONA1,ZONA2,FECHCREAC,NIT,NITTRI,NOMBRE,PROVEED,OBSERV,DIRECC1,TELEF1,CIUDANEID,CTACLI) 
		             VALUES('C',1,1,1,1,'".date("m/d/Y")."','".$row['codigo']."','".$row['dni']."','".
					 $row['nombres']." ".$row['apellidos']."','S','Creado por DROPos','NO SUMINISTRA','',2,437)";
		   $claseTNS->Consulta($conex,$vsql1);     	   
		   $terid    = $claseTNS->SelectOne($conex,"SELECT TERID FROM TERCEROS WHERE NITTRI='".$row['dni']."'");					
		}		
        
        // 4. INSERTO EL ENCABEZADO DEL DOCUMENTO
		// Inserto el Encabezado del Comprobante
         $vsqlTNS1 = "INSERT INTO KARDEX( CODCOMP , CODPREFIJO , NUMERO , FECHA , FECVENCE , OBSERV , PERIODO , BCOID , CENID , AREADID , SUCID , RETIVA , RETICA , RETFTE , AJUSTEBASE , AJUSTEIVA , 
		              AJUSTEIVAEXC , AJUSTENETO , CLIENTE , VENDEDOR , FORMAPAGO , NROFACPROV , VRBASE , VRIVA , VRICONSUMO,VRRFTE,VRRICA,VRRIVA,TOTAL,FPCONTADO,FPCREDITO,FACTORCONV,IMPORTADO , USUARIO) 
		              VALUES('FV','".$codprefijo."','".$numero."','".$fecha."','".$fecvence."','Importado de Dropos v ".$_SESSION['G_VERSIONAPP']." el ".
			 		 date("d/m/Y")."','".date("m")."',1,1,1,1,0,0,0,0,0,0,0,".$terid.",1,'".$formapago."','".$nrodocref."',".$total.",0,0,0,0,0,".$total.",0,".$total.",1,'N','ADMIN')";
		$claseTNS->Consulta($conex,$vsqlTNS1);
        
		// 5. BUSCO EL KARDEXID 
        $kardexid    = $claseTNS->SelectOne($conex,"SELECT MAX(KARDEXID) kardexid FROM KARDEX");

        // 6. INSERTO EL ENCABEZADO DEL DOCUMENTO
		// Inserto el Detalle
        $vsqlTNS2 = "INSERT INTO DEKARDEX( KARDEXID , MATID , BODID , TIPUND , CANLISTA , CANMAT , PORCIVA , PRECIOBASE , PRECIOIVA , PRECIOVTA , PRECIONETO , PARCVTA ) 
					 VALUES(".$kardexid.",3,1,'D',1,1,0,".$total.",".$total.",".$total.",".$total.",".$total.")";
		$claseTNS->Consulta($conex,$vsqlTNS2);

        $claseTNS->desconectar($conex);
     }
  }  


//////////////////////////////////////////////////////////////////////////
/// CLASE MONTO EN LETRAS
//////////////////////////////////////////////////////////////////////////
class EnLetras
{
  var $Void = "";
  var $SP = " ";
  var $Dot = ".";
  var $Zero = "0";
  var $Neg = "Menos";
  
function ValorEnLetras($x, $Moneda ) 
{
    $s="";
    $Ent="";
    $Frc="";
    $Signo="";
        
    if(floatVal($x) < 0)
     $Signo = $this->Neg . " ";
    else
     $Signo = "";
    
    if(intval(number_format($x,2,'.','') )!=$x) //<- averiguar si tiene decimales
      $s = number_format($x,2,'.','');
    else
      $s = number_format($x,0,'.','');
       
    $Pto = strpos($s, $this->Dot);
        
    if ($Pto === false)
    {
      $Ent = $s;
      $Frc = $this->Void;
    }
    else
    {
      $Ent = substr($s, 0, $Pto );
      $Frc =  substr($s, $Pto+1);
    }

    if($Ent == $this->Zero || $Ent == $this->Void)
       $s = "Cero ";
    elseif( strlen($Ent) > 7)
    {
       $s = $this->SubValLetra(intval( substr($Ent, 0,  strlen($Ent) - 6))) . 
             "Millones " . $this->SubValLetra(intval(substr($Ent,-6, 6)));
    }
    else
    {
      $s = $this->SubValLetra(intval($Ent));
    }

    if (substr($s,-9, 9) == "Millones " || substr($s,-7, 7) == "Mill�n ")
       $s = $s . "de ";

    $s = $s . $Moneda;

    if($Frc != $this->Void)
    {
       $s = $s . " Con " . $this->SubValLetra(intval($Frc)) . "Centavos";
       //$s = $s . " " . $Frc . "/100";
    }
    return ($Signo . $s . " MCTE");
   
}


function SubValLetra($numero) 
{
    $Ptr="";
    $n=0;
    $i=0;
    $x ="";
    $Rtn ="";
    $Tem ="";

    $x = trim("$numero");
    $n = strlen($x);

    $Tem = $this->Void;
    $i = $n;
    
    while( $i > 0)
    {
       $Tem = $this->Parte(intval(substr($x, $n - $i, 1). 
                           str_repeat($this->Zero, $i - 1 )));
       If( $Tem != "Cero" )
          $Rtn .= $Tem . $this->SP;
       $i = $i - 1;
    }

    
    //--------------------- GoSub FiltroMil ------------------------------
    $Rtn=str_replace(" Mil Mil", " Un Mil", $Rtn );
    while(1)
    {
       $Ptr = strpos($Rtn, "Mil ");       
       If(!($Ptr===false))
       {
          If(! (strpos($Rtn, "Mil ",$Ptr + 1) === false ))
            $this->ReplaceStringFrom($Rtn, "Mil ", "", $Ptr);
          Else
           break;
       }
       else break;
    }

    //--------------------- GoSub FiltroCiento ------------------------------
    $Ptr = -1;
    do{
       $Ptr = strpos($Rtn, "Cien ", $Ptr+1);
       if(!($Ptr===false))
       {
          $Tem = substr($Rtn, $Ptr + 5 ,1);
          if( $Tem == "M" || $Tem == $this->Void)
             ;
          else          
             $this->ReplaceStringFrom($Rtn, "Cien", "Ciento", $Ptr);
       }
    }while(!($Ptr === false));

    //--------------------- FiltroEspeciales ------------------------------
    $Rtn=str_replace("Diez Un", "Once", $Rtn );
    $Rtn=str_replace("Diez Dos", "Doce", $Rtn );
    $Rtn=str_replace("Diez Tres", "Trece", $Rtn );
    $Rtn=str_replace("Diez Cuatro", "Catorce", $Rtn );
    $Rtn=str_replace("Diez Cinco", "Quince", $Rtn );
    $Rtn=str_replace("Diez Seis", "Dieciseis", $Rtn );
    $Rtn=str_replace("Diez Siete", "Diecisiete", $Rtn );
    $Rtn=str_replace("Diez Ocho", "Dieciocho", $Rtn );
    $Rtn=str_replace("Diez Nueve", "Diecinueve", $Rtn );
    $Rtn=str_replace("Veinte Un", "Veintiun", $Rtn );
    $Rtn=str_replace("Veinte Dos", "Veintidos", $Rtn );
    $Rtn=str_replace("Veinte Tres", "Veintitres", $Rtn );
    $Rtn=str_replace("Veinte Cuatro", "Veinticuatro", $Rtn );
    $Rtn=str_replace("Veinte Cinco", "Veinticinco", $Rtn );
    $Rtn=str_replace("Veinte Seis", "Veintise�s", $Rtn );
    $Rtn=str_replace("Veinte Siete", "Veintisiete", $Rtn );
    $Rtn=str_replace("Veinte Ocho", "Veintiocho", $Rtn );
    $Rtn=str_replace("Veinte Nueve", "Veintinueve", $Rtn );

    //--------------------- FiltroUn ------------------------------
    If(substr($Rtn,0,1) == "M") $Rtn = "Un " . $Rtn;
    //--------------------- Adicionar Y ------------------------------
    for($i=65; $i<=88; $i++)
    {
      If($i != 77)
         $Rtn=str_replace("a " . Chr($i), "* y " . Chr($i), $Rtn);
    }
    $Rtn=str_replace("*", "a" , $Rtn);
    return($Rtn);
}


function ReplaceStringFrom(&$x, $OldWrd, $NewWrd, $Ptr)
{
  $x = substr($x, 0, $Ptr)  . $NewWrd . substr($x, strlen($OldWrd) + $Ptr);
}


function Parte($x)
{
    $Rtn='';
    $t='';
    $i='';
    Do
    {
      switch($x)
      {
         Case 0:  $t = "Cero";break;
         Case 1:  $t = "Un";break;
         Case 2:  $t = "Dos";break;
         Case 3:  $t = "Tres";break;
         Case 4:  $t = "Cuatro";break;
         Case 5:  $t = "Cinco";break;
         Case 6:  $t = "Seis";break;
         Case 7:  $t = "Siete";break;
         Case 8:  $t = "Ocho";break;
         Case 9:  $t = "Nueve";break;
         Case 10: $t = "Diez";break;
         Case 20: $t = "Veinte";break;
         Case 30: $t = "Treinta";break;
         Case 40: $t = "Cuarenta";break;
         Case 50: $t = "Cincuenta";break;
         Case 60: $t = "Sesenta";break;
         Case 70: $t = "Setenta";break;
         Case 80: $t = "Ochenta";break;
         Case 90: $t = "Noventa";break;
         Case 100: $t = "Cien";break;
         Case 200: $t = "Doscientos";break;
         Case 300: $t = "Trescientos";break;
         Case 400: $t = "Cuatrocientos";break;
         Case 500: $t = "Quinientos";break;
         Case 600: $t = "Seiscientos";break;
         Case 700: $t = "Setecientos";break;
         Case 800: $t = "Ochocientos";break;
         Case 900: $t = "Novecientos";break;
         Case 1000: $t = "Mil";break;
         Case 1000000: $t = "Mill�n";break;
      }

      If($t == $this->Void)
      {
        $i = $i + 1;
        $x = $x / 1000;
        If($x== 0) $i = 0;
      }
      else
         break;
           
    }while($i != 0);
   
    $Rtn = $t;
    Switch($i)
    {
       Case 0: $t = $this->Void;break;
       Case 1: $t = " Mil";break;
       Case 2: $t = " Millones";break;
       Case 3: $t = " Billones";break;
    }
    return($Rtn . $t);
}

}


 
?>