<?php

include("../../lib/Sistema.php");

/**
 * Clase API del WebService
 * Permite hacer las 4 Actividades Básicas CRUD a la Tabla Existencias
 * Desde WebService
 * @author Milagros Rodriguez
 * @version 2017-01-28
 */

class api
{
	private $db;

	/**
	 * Constructor - Abre una conexion a la Base de Datos
	 *
	 * @param Vacío
	 * @return Conexion a la Base de Datos
	 */
	
	function __construct()
	{
		$clase = new Sistema();
		$this->db = new mysqli('192.168.14.252','java','d2218aa','droposservidor2017db');
	}

	/**
	 * Destructor - close DB connection
	 *
	 * @param Vacío
	 * @return Vacío
	 */

	function __destruct()
	{
		$this->db->close();
	}

	/**
	 * Obtiene si el tercero tiene puntos disponibles para redimir
	 * @param Documento del cliente y valor de la compra a canjear
	 * @return Si puede canjear o no
	 */
	function getAcumularPuntos($params)
	{
		/// Variable de Retorno del Servicio
		$retorno = 0;
		$clase = new Sistema();
        $periodo = date("mY");
		
		//// Evaluamos si Tiene Puntos
		$terid   = $clase->BDLockup($params['id'],"terceros","dni","terid");
		$compra  = $params['valor'];
		$idsuc        = $params['idsuc'];
		$numfact      = $params['numfact'];
		$totfact      = $params['totfact'];
		$idafiliado   = $params['idafiliado'];
		$cedulacli    = $params['id'];
		$moment       = date("Y-m-d H:i:s");
		$puntos       = number_format($compra);
		$fecha_actual = date("Y-m-d");
		$vence        = date("Y-m-d",strtotime($fecha_actual."+ 1 year"));
		
		$query = "SELECT documento, totalpuntos   
				FROM afiliado  WHERE documento = '".$params['id']."'";
		$list = array();
		$result = $this->db->query($query);
		if($row = $result->fetch_assoc())
		{
			$cupo    = $row['totalpuntos'];
		}

		//// Valido si se puede aceptar la transaccion o NO
		// Hasta que se establezca la valoracion puntos vs pesos
		$disponible = $cupo + $compra;
		// Actualizo los puntos disponibles en la tabla de afiliado
		$clase->EjecutarSQL("UPDATE afiliado SET totalpuntos = $disponible WHERE documento = '".$params['id']."' ");

		$vsql = "INSERT INTO transaccion (idtransaccion,idsucursal,fechatransaccion,nrofactura,valortotaltx,tipotx,idafiliado,puntostransaccion,vencen,redimidos,saldo,envionotificacion) 
		VALUES(0,".$idsuc.",'".$moment."','".$numfact."',".$totfact.",1,".$idafiliado.",".$compra.",'".$vence."',0,0,1)";
		$clase->EjecutarSQL($vsql);

		$retorno = 1;

		$nomsuc      = $clase->BDLockup($idsuc,"sucursales","sucursalid","descripcion");
		$nomafiliado = $clase->BDLockup($idafiliado,"afiliado","idafiliado","nombres");
		$apeafiliado = $clase->BDLockup($idafiliado,"afiliado","idafiliado","apellidos");
		$host        = $clase->BDLockup("G_HOSTCORREO","configuraciones","variab","contenido");
		$usercorreo  = $clase->BDLockup("G_USERCORREO","configuraciones","variab","contenido");
		$clavecorreo = $clase->BDLockup("G_CLAVECORREO","configuraciones","variab","contenido");
		/// Cargo la Plantilla y posteriormente le reemplazo las variables
		$plantilla = "";
		$ruta = "../../recursos/html/acumulapuntos.html";
		$fp = fopen($ruta,"r");     
		while ($linea= fgets($fp,2048))
			$plantilla.= $linea;

		/// Reemplazo los campos  
		$plantilla = str_replace("#{SUCURSAL}", $nomsuc , $plantilla);                
		$plantilla = str_replace("#{FACTURA}", $numfact , $plantilla );                 
		$plantilla = str_replace("#{CLIENTE}" , $nomafiliado.' '.$apeafiliado, $plantilla);
		$plantilla = str_replace("#{CEDULACLI}", $cedulacli, $plantilla);                
		$plantilla = str_replace("#{PUNTOS}" , $puntos , $plantilla); 
		$plantilla = str_replace("#{FECHADOC}" , $moment , $plantilla);
	
			
		require '../../lib/PHPMailer/PHPMailerAutoload.php';
		$mail = new PHPMailer;
		$mail->isSMTP();
		$mail->SMTPDebug = 0;
		$mail->Debugoutput = 'html'; 
		$mail->Host = $host;
		$mail->Port = 587;
		$mail->SMTPSecure = 'tls';
		$mail->SMTPAuth = true;
		$mail->Timeout=20;
		$mail->CharSet = 'UTF-8';
		$mail->Username = $usercorreo;
		$mail->Password = $clavecorreo;
		$mail->setFrom('sistemas2@dromedicas.com.co', 'Puntos Farmanorte');
		$mail->addReplyTo('sistemas2@dromedicas.com.co', 'Puntos Farmanorte');
		$mail->addAddress($email, "Cliente Puntos");
		$mail->addAddress('sistemas2@dromedicas.com.co', "Puntos Farmanorte"); 
		$mail->Subject = 'Acumulación de Puntos Farmanorte';
		$mail->isHTML(true);       
		$mail->Body = $plantilla;
		$mail->send();
		
		return($retorno);
	}

} /// Fin de la Clase API
