<?php

include("../../lib/Sistema.php");

/**
 * Clase API del WebService
 * Permite hacer las 4 Actividades Básicas CRUD a la Tabla Existencias
 * Desde WebService
 * @author Said Rodriguez
 * @version 2017-01-28
 */

class api
{
	private $db;

	/**
	 * Constructor - Abre una conexion a la Base de Datos
	 *
	 * @param Vacío
	 * @return Conexion a la Base de Datos
	 */
	
	function __construct()
	{
		$clase = new Sistema();
		$this->db = new mysqli($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
	}

	/**
	 * Destructor - close DB connection
	 *
	 * @param Vacío
	 * @return Vacío
	 */

	function __destruct()
	{
		$this->db->close();
	}

	/**
	 * Obtiene la existencia en Sucursales del Producto consultado
	 * @param ID del Producto	 
	 * @return Lista de Existencia por Bodegas en Formato JSON
	 */
	function getExistenciaProducto($params)
	{
		$clase = new Sistema();
		
		$ciudadsucursal = $clase->BDLockup($params['suc'],'sucursales','codigo','ciudadcodigo');
		$query = "SELECT IF(CIU.codigo=".$ciudadsucursal." , 0 , 1) orden , CIU.codigo codciudad , CIU.nombre nomciudad , GP.descripcion grupo, B.codbodega , B.nombodega , 
		          S.ultrecepcion , E.cantidad , 0 rotacion , P.* ,
				  0 transporte
				  FROM productos P INNER JOIN gruposprod GP ON ( GP.gruposprodid = P.gruposprodid ) 
				  INNER JOIN existencias E ON ( P.productoid = E.productoid ) 
				  INNER JOIN bodegas B ON ( B.bodegaid = E.bodegaid ) 
				  INNER JOIN sucursales S ON (S.sucursalid = B.sucursalid)
				  INNER JOIN ciudades CIU ON (CIU.codigo = S.ciudadcodigo) 
				  WHERE P.bloqueado <> 'CHECKED' AND S.activa = 'CHECKED' AND abs(round(E.cantidad)) > 0 AND B.visibletodos = 'CHECKED' AND B.codbodega <> 'BB'  
				  AND (B.codbodega <> '00' AND B.codbodega <> 'COD') AND B.bodespecial <> 'CHECKED' AND P.productoid = ".$params['id']." ORDER BY orden ASC , CIU.nombre ASC , B.codbodega ASC";
  //echo $query; exit;
 		$list = array();
		$result = $this->db->query($query);
		while ($row = $result->fetch_assoc())
		{
			$list[] = $row;
		}
		
        //// Registro la consulta Remota
        if((strlen($params['id'])>0)&&(strlen($params['suc'])>0))
        {
        	$vsql2 = "INSERT INTO consultasexiproductos(productoid,codsucursal,momento) VALUES('".$params['id']."','".$params['suc']."',CURRENT_TIMESTAMP)";
            $stmt = $this->db->prepare($vsql2);
            $r = $stmt->execute();
        }
        
        /// Retorno los datos
 		return $list;
	}

} /// Fin de la Clase API
