<?PHP
    @session_start(); 
    include("lib/Sistema.php");    
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanadatos
    // Creación: 25/11/2020		última modificación: 16/12/2020
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción que pinta la ventana para la captación de datos del informe  
    //              general de conceptos por periodos
    // Última modificación: Se incluyó el combo para el tipo de nómina a emitir: empleados 
    //                      o extralegal (27/11/2020)
    //                      Inclusión de la opción todos en el tipo de nómina
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanadatos")
    {
        $params = ' class="Texto11" ';
        $vsqlcomboperiodo  = "SELECT codigo, CONCAT(codigo,' - ',descripcion) 
                                FROM periodosnomina 
                               WHERE cerrado ='CHECKED' OR 
                                     periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')                                    
                            ORDER BY periodoid ASC";        
    
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/cargacademica.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Informe general de conceptos por periodo </b></td>
                  <td> &nbsp; </td>
                  <td width="8"> &nbsp; </td>
                 </tr>           
                </table>';    
        
        $cont.='<form action="infgencomper.php?opcion=listadoconcepto" method="POST" name="x" target="_blank">
                 <center>
                 <table width="100%">
                  <tr class="BarraDocumentos">
                   <td align="center"><br><br><b> Datos del informe <br><br></td>
                  </tr>
                 </table>  
                 <table width="100%">
                  <tr class="BarraDocumentos"> 
                   <td width="220"> &nbsp; </td>
                   <td width="20"> Periodo: </td>
                   <td width="120">';

        $cont.= $clase->CrearComboBuscar("codigo",$vsqlcomboperiodo,"descripcion","codigo","","N",$params,400);
                    
        $cont.='   </td> 
                   <td width="220"> &nbsp; </td>
                  </tr>
                  <tr class="BarraDocumentos"> 
                   <td width="220"> &nbsp; </td>
                   <td width="20"> Tipo: </td>
                   <td width="120">
                    <SELECT name="tiponomina" id="tiponomina" style="width:120px;height:20px">
                     <option value="todos" SELECTED> Todos </option>               
                     <option value="empleados"> Empleados </option>               
                     <option value="extralegal"> Extralegal </option>
                    </SELECT> 
                   </td> 
                   <td width="220"> &nbsp; </td>
                  </tr>
                 </table>                   
                 <table width="100%">                     
                  <tr class="BarraDocumentos"> 
                   <td width="371" height="50" align="center">&nbsp;  </td>      
                   <td width="164" height="50" align="center"> <input type="submit" value="vista" class="button blue" name="tiposalida"></td>
                   <td width="131" height="50" align="center"> <input type="submit" value="pdf" class="button red" name="tiposalida"></td>
                   <td width="185" height="50" align="center"> <input type="submit" value="excel" class="button blue" name="tiposalida"></td>
                   <td width="380" height="50" align="center">&nbsp;  </td>
                  </tr>
                 </table> 
                </form>';

        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                </table>';
        echo $cont;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: listadoconcepto
    // Creación: 25/11/2020		última modificación: 24/05/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que imprime el informe de general de nómina de acuerdo al 
    //              tipo de salida que se seleccione en la opción “ventanadatos” 
    //              (vista, PDF o Excel)
    // Última modificación: Se incluyó la impresión de montos de ocho cifras (11/12/2020)
    //                      Inclusión de la opción todos en el tipo de nómina (16/12/2020)
    //                      Se incorporó el campo de empleado activo en la nómina 
    //                      (11/08/2021)
    //                      se utilizó una sola consulta para todas las salidas y se 
    //                      optimizó cada una de ellas 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion=="listadoconcepto")
    {
        $codigo  = $_POST['codigo'];            // Variable para filtrar el periodo
        $tiposalida = $_POST["tiposalida"];     // Variable que indica qué tipo de informe se mostrará
        $tiponomina = $_POST["tiponomina"];     // Variable para el tipo de nómina

        // Variable para el nombre del periodo
        $descripcion = $clase->BDLockup($codigo,'periodosnomina','codigo','descripcion');

        // Variable para el ID del periodo
        $periodoid  = $clase->BDLockup($codigo,'periodosnomina','codigo','periodoid');

        // Consulta del informe de acuerda a la selección realizada
        $vsql = "SELECT c.nomconcepto, SUM(d.devengados) AS totdevengados, 
                        SUM(d.descuentos) AS totdescuentos, c.tipodc 
                   FROM detallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                        INNER JOIN terceros t ON (d.terid = t.terid)
                  WHERE d.pernominaid = ".$periodoid." ";

        switch($tiponomina)
        {
            case 'empleados':
                $vsql.= " AND (t.esempleadoactivo='CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))";
                break;
            case 'extralegal':
                $vsql.= " AND t.extralegal = 'CHECKED'";
                break;
            case 'todos':
                $vsql.= " AND t.esempleadoactivo='CHECKED'";
                break;
            default:
                break;
        }
        $vsql.= " GROUP BY d.conceptoid";

        // ------------------------------------------------------------------------------------------------------------------------------------------ //
        // Muestra el informe en una vista del sistema
        if($tiposalida=="vista")
        {
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/cargacademica.png" width="32" height="32" border="0"> </td>
                      <td width="840"> <b>Informe general de conceptos por periodo </b></td>
                      <td> &nbsp; </td>
                      <td width="8"> &nbsp; </td>
                     </tr>
                    </table>';

            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>
                      <td width="840"> <b> Periodo: </b>'.$descripcion.' <b>tipo:</b> '.strtoupper($tiponomina).'</td>
                      <td> &nbsp; </td>
                      <td width="8"> &nbsp; </td>
                     </tr>           
                    </table>';

            $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                     <table width="100%" class="sortable">
                      <thead> 
                       <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                        <td width="27"> &nbsp; </td>
                        <td width="335" align="left"> Nombre </td>
                        <td width="296" align="right"> &nbsp; </td>			                        
                        <td width="308" align="right"> &nbsp; </td>                        
                        <td width="11"> &nbsp; </td>
                        <td width="219"> &nbsp; </td>                        
                        <td width="80"> &nbsp; </td> 
                        <td width="242" align="right"> Saldo </td>                      
                        <td width="40"> &nbsp; </td>
                       </tr>
                      </thead>
                      <tbody style="display:block; width:1050px; height:400px; overflow-Y:scroll">';

            // Impresión del detalle del informe
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $total = 0;
            $i = 0;
            $totaldevengado = 0;
            $totaldescuento = 0;
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';

                $cont.=' <td width="27"> &nbsp; </td>
                         <td width="315" align="left"> '.$row['nomconcepto'].' </td>
                         <td width="316" align="right"> &nbsp; </td>                         
                         <td width="327" align="right"> &nbsp; </td>
                         <td width="10"> &nbsp; </td>                         
                         <td width="11" align="center"> &nbsp; </td>                         
                         <td width="198" align="right"> &nbsp; </td> 
                         <td width="110"> &nbsp; </td>';

                if($row['tipodc']=="C")
                {
                    $cont.='<td width="242" align="right"><font color="GREEN">'.number_format($row['totdevengados']).'</font></td>';
                    $total += $row['totdevengados'];                                            // Incremento la variable del total
                    $totaldevengado += $row['totdevengados'];                                   // Incremento la variable del devengado
                }
                else
                {
                    $cont.='<td width="242" align="right"><font color="#FF00FF">'.number_format($row['totdescuentos']).'</font></td>';
                    $total += $row['totdescuentos'];                                            // Incremento la variable del total
                    $totaldescuento += $row['totdescuentos'];                                   // Incremento la variable del descuento
                }                

                $cont.=' <td width="10"> &nbsp; </td>
                        </tr>';
            }

            $cont.=' </tbody>
                    </table>';

            $cont.='<table width="100%">
                     <tr class="TituloTabla"> 
                      <td width="220"> &nbsp; </td>
                      <td width="320" align="left"> <font color="WHITE"> <b> Total devengado: </b> '.number_format($totaldevengado).' </font> </td>
                      <td width="27"> &nbsp; </td>
                      <td width="320" align="left"> <font color="WHITE"> <b> Total descuento: </b> '.number_format($totaldescuento).' </font> </td>
                      <td width="30"> &nbsp; </td>
                     </tr>
                    </table>';

            echo $cont.$clase->PiePagina();
        }

        // ------------------------------------------------------------------------------------------------------------------------------------------ //
        // Muestra el informe en formato PDF
        if($tiposalida=="pdf")
        {
            // Inicializo las variables
            $longitud = 0;              $lineatotales = 0;              $mesimp = "";               $fechoraimp = "";           $tipodc = "";
            $enc = "";                  $pie = "";

            // Traducción al español del mes que devuelve la función date()
            $mesimp = date('F');
            if($mesimp=="January")       $mesimp = "Enero";
            if($mesimp=="February")      $mesimp = "Febrero";
            if($mesimp=="March")         $mesimp = "Marzo";
            if($mesimp=="April")         $mesimp = "Abril";
            if($mesimp=="May")           $mesimp = "Mayo";
            if($mesimp=="June")          $mesimp = "Junio";
            if($mesimp=="July")          $mesimp = "Julio";
            if($mesimp=="August")        $mesimp = "Agosto";
            if($mesimp=="September")     $mesimp = "Septiembre";
            if($mesimp=="October")       $mesimp = "Octubre";
            if($mesimp=="November")      $mesimp = "Noviembre";
            if($mesimp=="December")      $mesimp = "Diciembre";            

            // Procedo a construir el encabezado del recibo
            ini_set("memory_limit","200M");
            require('lib/fpdf/fpdf.php');
            $pdf=new FPDF();
        
            // Página nueva
            $pdf->AddPage("");
            $pagina = 1;

            // Logo Dromedicas
            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

            // Imprimo el encabezado del informe
            $x = 25;
            $y = 13;
            $pdf->SetFont('Arial','B',10);
            $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";          $pdf->Text($x,$y,$enc);

            // Fecha y hora de impresión
            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x+124,$y,$fechoraimp);

            $pdf->SetFont('Arial','B',10);
            $enc= "INFORME GENERAL DE CONCEPTOS POR PERIODO";               $pdf->Text($x,$y+5,$enc);
            $enc= "PERIODO: ";                                              $pdf->Text($x,$y+10,$enc);

            $pdf->SetFont('Arial','',10);
            $enc=strtoupper($descripcion);                                  $pdf->Text($x+19,$y+10,$enc);

            $pdf->SetFont('Arial','B',10);
            $enc= "TIPO: ";                                                 $pdf->Text($x,$y+15,$enc);

            $pdf->SetFont('Arial','',10);
            $enc=strtoupper($tiponomina);                                   $pdf->Text($x+12,$y+15,$enc);

            $pdf->SetFillColor(220,220,220);                                $pdf->Rect(5,33,200,8,'F');

            $pdf->SetFont('Arial','B',9);
            $enc= "CONCEPTO";                                               $pdf->Text($x-17,$y+25,$enc);
            $enc= "TOTAL";                                                  $pdf->Text($x+165,$y+25,$enc);

            // Impresión del detalle del informe
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $total = 0;
            $x = 8;
            $y = 46;
            $totaldevengado = 0;
            $totaldescuento = 0;
            while($row = mysql_fetch_array($result))
            {
                $pdf->SetFont('Arial','',8);
                $pdf->Text($x,$y,$row['nomconcepto']);

                if($row['tipodc']=="C")
                {
                    // Alineación de los montos correspondientes
                    $longitud = strlen(intval($row['totdevengados']));

                    if($longitud==5)            $pdf->Text($x+185,$y,number_format($row['totdevengados']));
                    if($longitud==6)            $pdf->Text($x+183,$y,number_format($row['totdevengados']));
                    if($longitud==7)            $pdf->Text($x+181,$y,number_format($row['totdevengados']));
                    if($longitud==8)            $pdf->Text($x+179,$y,number_format($row['totdevengados']));
                    if($longitud==9)            $pdf->Text($x+177,$y,number_format($row['totdevengados']));
                    if($longitud==10)           $pdf->Text($x+175,$y,number_format($row['totdevengados']));
                    if($longitud==11)           $pdf->Text($x+173,$y,number_format($row['totdevengados']));
                    if($longitud==12)           $pdf->Text($x+171,$y,number_format($row['totdevengados']));

                    $total += $row['totdevengados'];
                    $totaldevengado += $row['totdevengados'];
                }
                else
                {
                    // Alineación de los montos correspondientes
                    $longitud = strlen(intval($row['totdescuentos']));

                    if($longitud==5)            $pdf->Text($x+185,$y,number_format($row['totdescuentos']));
                    if($longitud==6)            $pdf->Text($x+183,$y,number_format($row['totdescuentos']));
                    if($longitud==7)            $pdf->Text($x+181,$y,number_format($row['totdescuentos']));
                    if($longitud==8)            $pdf->Text($x+179,$y,number_format($row['totdescuentos']));
                    if($longitud==9)            $pdf->Text($x+177,$y,number_format($row['totdescuentos']));
                    if($longitud==10)           $pdf->Text($x+175,$y,number_format($row['totdescuentos']));
                    if($longitud==11)           $pdf->Text($x+173,$y,number_format($row['totdescuentos']));
                    if($longitud==12)           $pdf->Text($x+171,$y,number_format($row['totdescuentos']));

                    $total += $row['totdescuentos'];
                    $totaldescuento += $row['totdescuentos'];
                }

                $y+=6;
            }

            // Impresión del pie de página del informe

            // Totales
            $lineatotales = $y;
            $pdf->SetFillColor(220,220,220);
            $pdf->Rect(5,$lineatotales,200,8,'F');

            $pdf->SetFont('Arial','B',10);
            $pie= "TOTAL DEVENGADO: ";                  $pdf->Text($x,$y+5,$pie);

            // Alineación de los montos correspondientes
            $longitud = strlen(intval($totaldevengado));

            if($longitud==6)            $pdf->Text($x+50,$y+5,number_format($totaldevengado));            
            if($longitud==7)            $pdf->Text($x+46,$y+5,number_format($totaldevengado));
            if($longitud==8)            $pdf->Text($x+42,$y+5,number_format($totaldevengado));
            if($longitud==9)            $pdf->Text($x+38,$y+5,number_format($totaldevengado));
            if($longitud==10)           $pdf->Text($x+34,$y+5,number_format($totaldevengado));

            $pie= "TOTAL DESCUENTO: ";                  $pdf->Text($x+90,$y+5,$pie);

            // Alineación de los montos correspondientes
            $longitud = strlen(intval($totaldescuento));

            if($longitud==6)            $pdf->Text($x+135,$y+5,number_format($totaldescuento));
            if($longitud==7)            $pdf->Text($x+131,$y+5,number_format($totaldescuento));
            if($longitud==8)            $pdf->Text($x+127,$y+5,number_format($totaldescuento));
            if($longitud==9)            $pdf->Text($x+127,$y+5,number_format($totaldescuento));
            if($longitud==10)           $pdf->Text($x+126,$y+5,number_format($totaldescuento));
            if($longitud==11)           $pdf->Text($x+125,$y+5,number_format($totaldescuento));
            if($longitud==12)           $pdf->Text($x+124,$y+5,number_format($totaldescuento));
            $pdf->Output();
        }

        // ------------------------------------------------------------------------------------------------------------------------------------------ //
        // El informe es mostrado en una salida a Excel
        if($tiposalida=="excel")
        {
            require_once 'lib/PHPExcel.php';
            $clase = new Sistema();
            $clase->Conectar();
            ini_set("memory_limit","100M");

            // Preparación del entorno para la salida a Excel
            $clase = new Sistema();
            $clase->Nombredb = $_SESSION['DBNOMBRE'];
            error_reporting(E_ALL);
            ini_set('display_errors', TRUE);
            ini_set('display_startup_errors', TRUE);
            date_default_timezone_set('Europe/London');
        
            if (PHP_SAPI == 'cli')
                die('This example should only be run from a Web Browser');
        
            // Create new PHPExcel object
            $objPHPExcel = new PHPExcel();
        
            // Set document properties
            $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                         ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                         ->setTitle("Saldo de conceptos - DROPOS")
                                         ->setSubject("Saldo de conceptos - DROPOS")
                                         ->setDescription("Saldo de conceptos - DROPOS")
                                         ->setKeywords("Saldo de conceptos - DROPOS")
                                         ->setCategory("Categoria General");

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A1', 'INFORME GENERAL DE CONCEPTOS POR PERIODO')
                        ->setCellValue('A2', 'PERIODO: '.$descripcion)
                        ->setCellValue('A3', 'TIPO: '.strtoupper($tiponomina))
                        ->setCellValue('A4', 'EMPLEADO')
                        ->setCellValue('B4', 'TOTAL');
            
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
            
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $cant   = mysql_num_rows($result);
            $i=5;
            $totalconcepto = 0;
            $totaldevengado = 0;
            $totaldescuento = 0;            
            while($row = mysql_fetch_array($result))
            {
                if($row['tipodc']=="C")
                {
                    $totalconcepto = $row['totdevengados'];
                    $totaldevengado += $totalconcepto;
                }
                else
                {
                    $totalconcepto = $row['totdescuentos'];
                    $totaldescuento += $totalconcepto;
                }

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A'.$i, $row['nomconcepto'])
                            ->setCellValue('B'.$i, number_format($totalconcepto));
                $i++;
            }
            
            $i--;
            $rangoEncabezado = 'A4:B4';
            $rangoCeldas     = 'A4:B'.($i);

            // Impresión de los totales
            $y = $i + 2;
            $z = $y + 1;

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$y, "TOTAL DEVENGADO:")
                        ->setCellValue('B'.$y, number_format($totaldevengado))
                        ->setCellValue('A'.$z, "TOTAL DESCUENTO: ")
                        ->setCellValue('B'.$z, number_format($totaldescuento));
            
            // Formato de Encabezado y Celdas
            $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
            
            $EstiloCeldas = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '00000000'),
                ),
                ),
            );
            $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
            /// Formato de Encabezados 
            $EstiloEncabezado = array(
            'font' => array(
                'bold' => true,
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
            ),
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '00000000'),
                ),
            ),
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'rotation' => 90,
                'startcolor' => array(
                    'argb' => '00FFFFCC',
                ),
                'endcolor' => array(
                    'argb' => 'FFFFFF',
                ),
                ),
            );
            $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
            // Rename worksheet
            $objPHPExcel->getActiveSheet()->setTitle('general conceptos por periodo');
            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
            $objPHPExcel->setActiveSheetIndex(0);
            // Redirect output to a client’s web browser (Excel5)
            header('Content-Type: application/vnd.ms-excel');
            $nombrearcexcel = "general de conceptos por periodo ".strtolower($descripcion).".xls";
            header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
            header('Cache-Control: max-age=0');
            /// Genero la Salida
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
            exit;
        }
    }
?>