import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class JsonWebserviceClient {

    public static void main(String[] args) {
        // La URL del webservice a la que enviaremos la peticion
        String webserviceUrl = "http://localhost:8080/api/data"; // ! Cambia esto por la URL real de tu webservice
        
        // Rutas de los archivos
        Path inputFilePath = Paths.get("in/request.json");
        Path outputFilePath = Paths.get("out/response.json");

        try {
            // 1. Leer el contenido del archivo JSON de entrada
            String jsonRequestBody = Files.readString(inputFilePath);
            System.out.println("Leyendo archivo de entrada: " + inputFilePath);

            // 2. Crear el cliente HTTP
            HttpClient client = HttpClient.newHttpClient();

            // 3. Construir la peticion POST
            HttpRequest request = HttpRequest.newBuilder()
                    .uri(URI.create(webserviceUrl))
                    .header("Content-Type", "application/json") // Establecer el tipo de contenido
                    .POST(HttpRequest.BodyPublishers.ofString(jsonRequestBody)) // Establecer el cuerpo de la peticion
                    .build();

            // 4. Enviar la peticion y recibir la respuesta de forma sincrona
            System.out.println("Enviando peticion POST a: " + webserviceUrl);
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());

            // 5. Verificar el codigo de estado de la respuesta
            if (response.statusCode() == 200) {
                System.out.println("Peticion exitosa! Codigo de estado: " + response.statusCode());
                String jsonResponse = response.body();

                // 6. Almacenar la respuesta en un nuevo archivo JSON
                Files.writeString(outputFilePath, jsonResponse);
                System.out.println("Respuesta guardada en: " + outputFilePath);
            } else {
                System.out.println("Error en la peticion. Codigo de estado: " + response.statusCode());
                System.out.println("Cuerpo de la respuesta de error: " + response.body());
            }

        } catch (IOException e) {
            System.err.println("Error de entrada/salida: Asegurate de que 'request.json' existe.");
            e.printStackTrace();
        } catch (InterruptedException e) {
            System.err.println("La peticion fue interrumpida.");
            e.printStackTrace();
        } catch (Exception e) {
            System.err.println("Ocurrio un error inesperado.");
            e.printStackTrace();
        }
    }
}