<?php

/****************************************************************************************************
*                                   Clase Mensajes                                                   *
*                Clase que almacena los mensajes del Sistema de Reportes Web                         *
*****************************************************************************************************/

class Mensajes{

	  public $TNS_MEN_DB_NO_CON_DB = "<b>ERROR AL CONECTAR CON LA BASE DE DATOS <br> ERROR : </b>";
	  public $TNS_MEN_DB_ERR_CONSULT = "<b>ERROR EN LA CONSULTA SQL REALIZADA <br> ERROR : </b>";	
    public $TNS_MEN_DB_ERR_OBTEN_RES = "<b>ERROR EN AL OBTENER EL RESULTADO DE LA CONSULTA SQL REALIZADA <br> ERROR : </b>";		
    public $TNS_MEN_DB_ERR_CLOSE = "<b>ERROR AL CERRAR LA CONEXION A LA BASE DE DATOS <br> ERROR : </b>";		
}

/*****************************************************************************************************
*                                   Clase Datos                                                      *
*                Clase que gestiona el acceso a bases de datos  - Extiende de Mensajes               *
*****************************************************************************************************/


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class Datos extends Mensajes
{
  	public $SERVIDOR = '192.168.14.185';
  	public $DATABASE = 'D:\Datos TNS\PRUEBAS2018.GDB';
  	public $USUARIO = 'SYSDBA';
  	public $PASSDB = 'masterkey';
    public $DSNODBC = "CONEXIONTNS";

		/************************************************************************
		*  Conectar                                                             *
		*  Establece una conexion a la base de datos                            *
		*************************************************************************/

 	  function Conectar()
    {
        //if(!$con=@odbc_connect($this->DSNODBC,$this->USUARIO,$this->PASSDB))
        if(!$con=@odbc_connect('CONEXIONTNS','SYSDBA','masterkey'))
        {
  	       return(false);
  	     }  
  	     else 
        {
          odbc_autocommit($con,TRUE);
          return($con);
        }
    }	

    /************************************************************************
    *  Consulta                                                             *
    *  Ejecuta una consulta sql a traves de la conexion activa              *
    *************************************************************************/
    
    function Consulta2($con,$sql) 
    {
        if(!$res = @odbc_exec($con , $sql))
        {
           return(false);
        } 
        else 
           return($res);
    }
       

		/************************************************************************
		*  Consulta                                                             *
		*  Ejecuta una consulta sql a traves de la conexion activa              *
		*************************************************************************/
    
     function consulta($con,$sql) 
     {
     	  if(!$res = @odbc_exec($con , $sql))
        {
         return(false);
    	  } 
  	    else 
          return($res);
     }

		/*************************************************************************
		*  Recordset                                                             *
		*  Extrae un recordset a un objeto luego de la ejecucion de una consulta *
		*************************************************************************/
   
     function recordset($res) 
     {
        return(@odbc_fetch_object($res));
     }


		/*************************************************************************
		*  Recordset                                                             *
		*  Extrae un recordset a un objeto luego de la ejecucion de una consulta *
		*************************************************************************/
   
     function recordset2($res,$nomcampo) 
     {
        odbc_fetch_row($res);
        $campo = odbc_result($res,$nomcampo);
        return(@$campo);
     }
     
     	/*************************************************************************
		*  Recordset                                                             *
		*  Extrae un recordset a un objeto luego de la ejecucion de una consulta *
		*************************************************************************/
   
     function Tns_Bd_Lockup($con,$valor,$tabla,$campo,$retorna)
     {
       $sql = 'SELECT '.$retorna.' FROM '.$tabla.' WHERE ('.$campo.'="'.$valor.'")';	

        $resXX = $this->consulta($con,$sql);
        $row = $this->recordset2($resXX);
		    return($row[0]);
     }

     	/*************************************************************************
		*  Recordset                                                             *
		*  Extrae un recordset a un objeto luego de la ejecucion de una consulta *
		*************************************************************************/
   
     function selectOne($con,$sql,$nomcampo)
     {
     	
        $rs = $this->consulta($con,$sql);
        $valor = $this->recordset2($rs,$nomcampo);
		    return($valor);
     }

     
		/*************************************************************************
		*  Desconectar                                                           *
		*  Cierra una conexion activa a la base de datos                         *
		*************************************************************************/
   
     function desconectar($con) 
     {
    	  odbc_close($con);
    	  return;
     }

     /*************************************************************************
    *  Desconectar  Todo                                                       * 
    *  Cierra Todas las Conexiones Activas 
    *************************************************************************/
   
     function DesconectarTodo() 
     {
        odbc_close_all();
        return;
     }


} // Fin de Datos

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


class Formulario extends Datos
{
   public $HojaEstilos="";  
   public $Encabezado="";
   public $Pie="";

    function __construct($titulo)
   {
    $this->HojaEstilos = 'estilo.css';
    $this->Encabezado='<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd"><html><head>'
    .'<link rel="stylesheet" href="css/'.$this->HojaEstilos.'" type="text/css">'
	.'<title>'.$titulo.'</title><script language="JavaScript" src="calendario/javascripts.js"></script></head><body topmargin="0"><table width="100%"><tr>'
	.'<td width=130><img src="images/logoSmall.jpg" border=0></td>'
	.'<td><font size="1" face="Verdana"><b>'.$titulo.'</b></font></td></tr></table>'; 
	
    $this->Pie='<br><br><table border=0 width="100%"><tr><td width="100%" align="center"><b>TNS Software Ltda.</b><br>Derechos Reservados 2007 - '
	.'Desarrollado bajo OpenSource Free Code</td></tr></table>';
	
   }

   function Encabezado()
   {
    echo $this->Encabezado;
   }
   
   
   
   function Pie()
   {
    echo $this->Pie;
   }
   
   function ComboMesas()
   { 
    $con = $this->conectar();
    $res = $this->consulta($con,"SELECT TERID , NOMBRE FROM TERCEROS WHERE(CLIENTE <> 'null') ORDER BY NOMBRE");
    echo'<select name="help_mesas" OnChange="PasarMesa();">';
	while($obj=$this->recordset($res))
       echo'<option value="'.$obj->TERID.'">'.$obj->NOMBRE.'</option>';
	echo'</select>';   
    $this->desconectar($con);
   }

   function ComboMeseros()
   { 
    $con = $this->conectar();
    $res = $this->consulta($con,"SELECT TERID , NOMBRE FROM TERCEROS WHERE(VENDED <> 'null') ORDER BY NOMBRE");
    echo'<select name="help_meseros" OnChange="PasarMesero();">';
	while($obj=$this->recordset($res))
       echo'<option value="'.$obj->TERID.'">'.$obj->NOMBRE.'</option>';
	echo'</select>';   
    $this->desconectar($con);
   }

   function ComboArticulos()
   { 
    $con = $this->conectar();
    $res = $this->consulta($con,"SELECT MATID , DESCRIP FROM MATERIAL ORDER BY DESCRIP");
    echo'<select name="help_articulos" OnChange="PasarArticulo();">';
	while($obj=$this->recordset($res))
       echo'<option value="'.$obj->MATID.'">'.$obj->DESCRIP.'</option>';
	echo'</select>';   
    $this->desconectar($con);
   }
   
   
} // Fin de reporte

?>