<?PHP
  include("lib/Sistema.php");
  require_once 'lib/PHPExcel.php';
  $clase = new Sistema();
 
  //////////////////////////////////////////////////////////////////////////////
  //////  Controlo que si el Usuario tiene acceso a este Modulo
  $tienepermiso = PermisoAcceso($_SESSION['USERNAME'],"02.01");  
  if($tienepermiso != "S")
  {
      $clase->Aviso(2,"El Usuario NO Tiene permiso para acceder a este Modulo");
	    header("Location: principal.php");
      exit();
  }

  //////////////////////////////////////////////////////////////////////////////  
  $avisos = ""; 
  $opcion = "";
  $opcion = $_GET["opcion"];  
  

  ///////////////////////////////////////////////////////////////////////////////////////////////////////// 
  // Opción: saveposnuevo
  // Creación: 19/10/2019    última modificación: 11/12/2019
  // Creador: Luis Flórez    modificado por: 
  // Descripción: Copia de la opción “savepos” donde se actualizarán los campos de la compra con los que 
  //              trae de "posnuevo", se ignoraron temporalmente algunas validaciones.
  // Última modificación: Se quitaron las validaciones y se ajustó para incluir un nuevo producto.
  //                      Posteriormente se validó que el producto no exista en la compra.
  //                      Después se validó que no acepte productos que no estén en la orden de compra.
  ///////////////////////////////////////////////////////////////////////////////////////////////////////// 
  if($opcion == "saveposnuevo")
  {
      $docuid   = $_POST['docuid'];
      $cantidad = $_POST['cantidad'];
      $valor    = $_POST['valor'];
      $codprod  = strtoupper($_POST['codproducto']);
      $prefijo  = $clase->BDLockup($docuid,'documentos','docuid','prefijo');      
      $sucursal = $clase->BDLockup($docuid,'documentos','docuid','sucursalid');

      // ------------------------------------------------------------------------------------------------------------------------------- //
      // Validación de la existencia del producto en la compra

      //// Traduccion de Codigos de Barras
      $CODREAL = $clase->SeleccionarUno("SELECT codigo FROM productos WHERE bloqueado <> 'CHECKED' AND (codigo = '".$codprod."' OR codbarra LIKE '%".$codprod."%')");

      if(strlen($codprod) > 4)
      {
          $vsql = "SELECT * FROM docuself WHERE docuid = ".$docuid;
          $conex  = $clase->Conectar();
          $result = mysql_query($vsql,$conex); 
          $canordenes = mysql_num_rows($result);
          $listaordenes = "";    $i =0;
          while($row = mysql_fetch_array($result))  
          {
              if($i>0)
                  $listaordenes.= ",";
          
              $listaordenes.= $row['docuid2'];
              $i++;
          }   

          if(strlen($listaordenes)>0)
          {
              $vsqle  = "SELECT DD.dedocumid 
                           FROM dedocumentos DD 
                                INNER JOIN productos P ON (P.productoid = DD.productoid) 
                          WHERE DD.docuid IN (".$listaordenes.") AND 
                                P.codigo='".$CODREAL."' limit 0,1";    
              $existe = 0+$clase->SeleccionarUno($vsqle);

              // ------------------------------------------------------------------------------------------------ //
              /*
              // Controlo que el producto esté en la orden de compra              
              if($existe > 0)
              {
                  echo'<script language="javascript">
                      <!--
                          alert("Este producto ya se encuentra en la compra");
                          window.opener.location.reload();
                          document.location.href = "compras.php?opcion=posnuevo&docuid='.$docuid.'";
                      -->
                      </script>'; 
                  // exit();
              } 
              */
              // ------------------------------------------------------------------------------------------------ //
              // Controlo que el producto no esté en la orden de compra
              if($existe == 0)
              {
                  echo'<script language="javascript">
                        <!--
                           alert("Este producto no se encuentra en la compra");
                           window.opener.location.reload();                   
                           document.location.href = "compras.php?opcion=posnuevo&docuid='.$docuid.'";
                         -->
                       </script>';
                  exit;
              }
              // ------------------------------------------------------------------------------------------------ //   
          }
      }
      // ------------------------------------------------------------------------------------------------------------------------------- //      

      // Obtengo la bodega
      if($sucursal==19)      
        $bodegaid = $clase->BDLockup("50",'bodegas','codbodega','bodegaid');      
      else
        $bodegaid = $clase->BDLockup("DB",'bodegas','codbodega','bodegaid');

      //// Traduccion de Codigos de Barras
      $productoid = $clase->SeleccionarUno("SELECT productoid FROM productos WHERE bloqueado <> 'CHECKED' AND (codigo = '".$codprod."' OR codbarra LIKE '%".$codprod."%')");

      if(strlen($codprod) > 4)
      {
          // Valido que no se repitan los productos en la compra          
          $vsqlpro = "SELECT COUNT(*) FROM dedocumentos WHERE docuid = ".$docuid." AND productoid=".$productoid;

          $hayproductos = 0+$clase->SeleccionarUno($vsqlpro);

          if($hayproductos>0)
          {
              echo'<script language="javascript">
                    <!--
                       alert("Este producto ya se encuentra registrado en la compra");
                       window.opener.location.reload();                   
                       document.location.href = "compras.php?opcion=posnuevo&docuid='.$docuid.'";
                     -->
                   </script>';
              exit;
          }
          else
          {
              // ------------------------------------------------------------------------------------------------------------------------------------------------- //
              // Obtengo los datos mínimos para grabar el registro
              $valparcial = $cantidad * $valor;
              $porciva  = $clase->BDLockup($productoid,'productos','productoid','porciva');
              $costoprod = $valor;
              $valiva = ($valparcial / (1 + (porciva/100)));
              $valbase = $valparcial - $valiva;

              // Actualizo la información
              $vsqlx = "INSERT INTO dedocumentos (docuid,productoid,bodegaid,cantidad,unidades,tipund,costoprod,valunitario,valparcial,porciva,valbase,
                        valiva,valtotal,unicom,unifra) VALUES(".$docuid.",".$productoid.",".$bodegaid.",".$cantidad.",".$cantidad.",'D',".
                        $costoprod.",".$valor.",".$valparcial.",".$porciva.",".$valbase.",".$valiva.",".$valparcial.
                        ",".$cantidad.",0)";
              $clase->EjecutarSQL($vsqlx);

              $ID = $clase->SeleccionarUno("SELECT MAX(dedocumid) FROM dedocumentos WHERE docuid = ".$docuid." AND productoid=".$row['productoid']);
              $vsqlx2 = "INSERT INTO dedocuorden(dedocumid,precioant,dctol1,dctol2,dctol3,dctol4,obsequio) 
                                   VALUES(".$ID.",0,0,0,0,0,0)";
              $clase->EjecutarSQL($vsqlx2);

              $clase->EjecutarSQL("CALL PA_CalValoresFCO(".$docuid.")");
                
              echo'<script language="javascript">
                    <!--
                       window.opener.location.reload();                   
                       document.location.href = "compras.php?opcion=posnuevo&docuid='.$docuid.'";
                    -->
                    </script>';
              exit();
              // ------------------------------------------------------------------------------------------------------------------------------------------------- //            
          }
      }
  } // fin de la opción saveposnuevo

  //////////////////////////////////////////////////////////////////////////////////////////////////////////  
  //  Opción: posnuevo
  //  Creación: 19/10/2019    última modificación: 13/11/2019
  //  Creador: Luis Flórez    modificado por:
  //  Descripción: Copia de la opción “pos” donde se incluirán los campos cantidad y valor de tipo numérico
  //  Última modificación: Disminución de tamaño de la ventana
  //                       Se descartó el valor inicial en cantidad y valor, se incluyó la función para 
  //                       pasar de un campo a otro con la tecla enter.
  //////////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "posnuevo")
  {
    $docuid = $_GET['docuid'];
    $error  = $_GET['error'];
    
    if(($error == "")||($error == 0))
    {
      // $COLOR = "#808080";
      $COLOR = "#EAEAEA";

      $cont.='<link rel="stylesheet" href="css/estiloadministrativos.css" type="text/css">';
      //$cont.='<body bgcolor="'.$COLOR.'" leftmargin="0" topmargin="0" rightmargin="0" bottonmargin="0" OnLoad="document.x.default.focus();">';   

      $cont.='<body bgcolor="'.$COLOR.'" style="overflow-x:hidden; overflow-y:hidden" OnLoad="document.x.default.focus();">';      

      $cont.='<script type="text/javascript">

                function handleEnter (field, event) 
                {
                    var keyCode = event.keyCode ? event.keyCode : event.which ? event.which : event.charCode;
                    if (keyCode == 13) {
                    var i;
                    for (i = 0; i < field.form.elements.length; i++)
                    if (field == field.form.elements[i])
                    break;
                    i = (i + 1) % field.form.elements.length;
                    field.form.elements[i].focus();
                    return false;
                    }
                    else
                    return true;
                }
                </script>

              <form action="?opcion=saveposnuevo" method="POST" name="x">
                <input type="hidden" name="docuid" value="'.$docuid.'">
              <table width="100%" bgcolor="'.$COLOR.'">  

                <tr bgcolor="'.$COLOR.'">
                <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp; </td>
                </tr>                

                <tr bgcolor="'.$COLOR.'">
                <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> C&oacute;digo barra </td>
                </tr>                
                <tr bgcolor="'.$COLOR.'">
                <td align="center" bgcolor="'.$COLOR.'"> <input type="text" onkeypress="return handleEnter(this, event)" autofocus required name="codproducto" class="Texto15" size="17" id="codproducto" tabindex="1" autocomplete="off" onclick="this.select()"> </td>                
                </tr>

                <tr bgcolor="'.$COLOR.'">
                <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp; </td>
                </tr>                

                <tr bgcolor="'.$COLOR.'">
                <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> Cantidad </td>
                </tr>                
                <tr bgcolor="'.$COLOR.'">
                <td align="center" bgcolor="'.$COLOR.'"> <input type="number" onkeypress="return handleEnter(this, event)" name="cantidad" id="cantidad" min="1" step="0.01" '.$cantidad.' autocomplete="off"> </td>
                </tr>

                <tr bgcolor="'.$COLOR.'">
                <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp; </td>
                </tr>                
                
                <tr bgcolor="'.$COLOR.'">
                <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> Valor </td>
                </tr>                
                <tr bgcolor="'.$COLOR.'">
                <td align="center" bgcolor="'.$COLOR.'"> <input type="number" onkeypress="return handleEnter(this, event)" name="valor" min="1" step="0.01" '.$valor.' autocomplete="off"> </td>                
                </tr>
                
                <tr bgcolor="'.$COLOR.'" height="60">
                <td align="center" bgcolor="'.$COLOR.'"><br><center><input type="submit" class="button red" value="Adicionar Producto"></td>
                </tr>       
              
                <tr bgcolor="'.$COLOR.'">
                <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                </tr>                

              </table></form>';
    }
  
    if($error == "1")
    {
       $COLOR = "red";
       $cont.='<body bgcolor="'.$COLOR.'" leftmargin="0" topmargin="0" rightmargin="0" bottonmargin="0">';
       $cont.='<font color="white"><center><BR><h1>ERROR <br> PRODUCTO NO ENCONTRADO </H1><BR>
             <a href="transferencias.php?opcion=pos&docuid='.$docuid.'">
         <input type="button" value="CONTINUAR INGRESANDO PRODUCTOS" class="button"></a>';
    }       

    if($error == "2")
    {
       $COLOR = "orange";
       $cont.='<body bgcolor="'.$COLOR.'" leftmargin="0" topmargin="0" rightmargin="0" bottonmargin="0">';
       $cont.='<font color="white"><center><BR><h1>ERROR <br> DOCUMENTO YA ESTA CERRADO </H1><BR>
             <a href="#" OnClick="window.close();"><input type="button" value="CERRAR VENTANA" class="button"></a>';
    }       

    if($error == "3")
    {
       $COLOR = "blue";
       $cont.='<body bgcolor="'.$COLOR.'" leftmargin="0" topmargin="0" rightmargin="0" bottonmargin="0">';
       $cont.='<font color="white"><center><BR><h1>YA ALCANZO EL LIMITE DE ITEMS</h1><h2> NO PODRA ADICIONAR MAS PRODUCTOS AL DOCUMENTO</H2><BR>
             <a href="#" OnClick="window.close();"><input type="button" value="CERRAR VENTANA" class="button"></a>';
    } 
    echo $cont;
    exit();
  } // fin de la opción posnuevo       


  ///////////////////////////////////////////////////////////////////////////////  
  ///////////////////////////////////////////////////////////////////////////////  
  if($opcion == "enviaraservidorprincipal")
  {
      $docuid   = $_GET['docuid'];
      $regresar = $_GET['regresar'];
      
      $resultado = CopiarFacturaCompraAServidor($docuid);
      if($resultado)
        $clase->Aviso(1,'Transferencia Copiada al Servidor Principal');	 
      else
        $clase->Aviso(3,'Error al Enviar Documento. Por favor intente de Nuevo');	  	
      
      //// Lo redirecciono segun corresponda  
      if($regresar == "CHECKED")  
        header("Location: compras.php?opcion=crearimportar&docuid=".$docuid);
      else   
        header("Location: compras.php");
  }

  /////////////////////////////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////////////////////////////   
  if($opcion == "regenerarcod")
  {
      $docuid    = $_GET['docuid']; 
      $numerocod = $clase->BDLockup($docuid,"documentos","docuid","observacion2");
      
      ReemplazarCantidadesTRBnueva($docuid,$numerocod);
      $clase->Aviso(1,'Regenerado con Exito'); 
      header("Location: compras.php?opcion=crearimportar&docuid=".$docuid);
  }
  
  /////////////////////////////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////////////////////////////   
  if($opcion == "regenerartns2")
  {
      ini_set("memory_limit","200M");            
      set_time_limit(0);

      $periodo = $_POST['periodo'];
      $vsql = "SELECT * FROM documentos WHERE tipodoc = 'FCO' AND periodo = '".$periodo."'";
      $conex  = $clase->Conectar();
      $result = mysql_query($vsql,$conex);	
      while($row = mysql_fetch_array($result)) 
      {
          $existe = ExisteCompraTNS($row['nrodocref']);
          if($existe == 0)
          {
            EnviarCompraTNS($row['docuid']);
            echo $row['tipodoc'].$row['prefijo'].$row['numero']." - ".$row['nrodocref']."<br>";
          }
      }
         
      $clase->Aviso(1,'Documentos Regenerados a TNS con Exito'); 
      header("Location: compras.php");	
   } 

  /////////////////////////////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////////////////////////////   
  if($opcion == "regenerartns")
  {
     $vsqlcombo = "SELECT * FROM periodos ORDER BY orden DESC";                     
     $params    = ' class="Texto11" OnChange="x.submit();" ';        
     $combo     = $clase->CrearComboEsp("periodo",$vsqlcombo,"desperiodo","codperiodo",date("mY"),"N",$params);

     $cont = $clase->HeaderBlanco("Cargar Cuentas por Cobrar desde Sucursales");
     $cont.='<table width="100%">
             <tr class="CabezoteTabla"> 
              <td width="10"> </td>
              <td width="37"> <img src="images/iconos/mantenimientos.png" width="32" height="32" border="0"> </td>
              <td width="950"> <b> Regenerar Compras a TNS </b> <td>
              <td><a href="javascript:history.back();"><input type="button" value="<<" class="button"></a></td>
              <td width="8"> </td>
             </tr></table>';    
  
     $cont.='<form action="compras.php?opcion=regenerartns2" method="POST" name="x">
              <br><br><br><center>
                <table width="600"><tr class="BarraDocumentos"><td align="center"><br><br><b>Regenerar Compras a TNS<br><br></td></tr></table>  
                  <table width="600">
                    <tr class="BarraDocumentos">  
                      <td width="100">  </td>     
                      <td width="85"> Periodo </td>         
                      <td width="120"> '.$combo.' </td>
                      <td width="50"></td>   
                    </tr>';

    ///////////////////////////////////////////////////                
    if($_SESSION['SUPERUSUARIO'] == "CHECKED")
    {
       $cont.='<tr class="BarraDocumentos">  
                <td width="100">  </td>     
                <td width="85"> &nbsp; </td>         
                <td width="120"> <input type="checkbox" name="REEMPLAZAR" value="CHECKED"> Reemplazar Actuales <br><font color="gray"> (Solo Super Usuario) </td>
                <td width="50"></td>   
              </tr>';
    }            

    $cont.='</table>
            <table width="600"> 
              <tr class="BarraDocumentos"> 
           <td align="center"><br><input type="submit" value="cargar cuentas por cobrar" class="button red"><br><br><br><br></td>        
        </tr>
       </table> </form>';
     echo $cont;  
     exit;
  }  

  ////////////////////////////////////////////////////////////////////////////////////////  
  //// Generar TRB - Genera un Documento Transferencia de tipo REM a partir de una FCO
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "generarTRB")
  {
  	 $docuid  = $_GET['docuid'];              $id=0;
      
  	 //// Encabezado de la Orden de Compra  	 
   	 $vsql = "SELECT * FROM documentos WHERE docuid =".$docuid;  	
  	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);	
  	 if($row = mysql_fetch_array($result)) 
  	 {
  		  $conse = $van+1;
        $numero = "-".rand(11111,99999);
   	    $referencia = "";
        
        // Inserto en Documentos
  		  $vsqlx = "INSERT INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,terid1,terid2,terid3,nrodocref,observacion,sucursalid,creador,momento) VALUES('TRB','REM','".
                  $numero."','".$row['periodo']."',CURRENT_DATE,'".$row['terid1']."','".$row['terid2']."','".$row['terid3']."','".$row['prefijo'].$row['numero'].
  				        "','Documento Generado desde Factura Compra No.  ".$row['tipodoc'].' '.$row['prefijo'].' '.$row['numero']."','".$row['sucursalid']."','".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";
        $id = $clase->EjecutarSQL($vsqlx);
        
        $numorden = $row['prefijo']." ".$numero;  
        $NDocuid  = $clase->SeleccionarUno("SELECT docuid FROM documentos WHERE tipodoc = 'TRB' AND prefijo='REM' AND numero='".$numero."'");
  		
  		  //// Totalizo los valores de la Compra
  		  $clase->EjecutarSQL("PA_CalValoresFCO(".$NDocuid.")");
     }	 
   
     //// Tabla DocuTranfe
     $clase->EjecutarSQL("INSERT INTO docutranfe(docuid,diaoperativo,bodegaidori,bodegaiddes,kardexori,kardexdes) VALUES(".$NDocuid.",'".$_SESSION['G_DIAOPERATIVO']."',2,1,'N','N')");

  	 ///// Inserto los Productos desde la Compra
  	 if($id>0)
  	 {
  	   // Importo los productos
  	   $vsql = "SELECT * FROM dedocumentos WHERE docuid =".$docuid;
  	   $conex  = $clase->Conectar();
       $result = mysql_query($vsql,$conex);	
  	   while($row = mysql_fetch_array($result)) 
  	   {
          $ddid  = $row['dedocumid'];	 
          $unitario = $clase->BDLockup($row['productoid'],"productos","productoid","precio1m");
          $parcial  = ($unitario*$row['cantidad']);
          
  		    $vsqly = "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,tipund,costoprod,valunitario,valdescuento,valparcial,porciva,valbase,valiva,valtotal,diasrecor,numlinea,unicom,unifra) values(".
  		              $NDocuid.",'".$row['productoid']."','".$row['bodegaid']."','".$row['cantidad']."','".$row['cantidad']."','".$row['tipund']."','".$row['costoprod']."','".$unitario."','".
  				          $row['valdescuento']."','".$parcial."','".$row['porciva']."','".$row['valbase']."','".$row['valiva']."','".$parcial."','".$row['diasrecor']."',0,'".
  				          $row['cantidad']."','".$row['unifra']."')";	 
  		    $clase->EjecutarSQL($vsqly);  
  	   }
       
       //// Totalizo los valores de la Compra
       $clase->EjecutarSQL("PA_CalValoresFCO(".$NDocuid.")");
        
   	   $clase->Aviso(1,'Se ha generado la Transferencia No. <b>'.$numero.'</b>');
  	   header("Location: transferencias.php?opcion=crear&docuid=".$NDocuid);		 
  	 }  	 
  } 

  //////////////////////////////////////////////////////////////////////////////////////// 
  //////// INFORME DE ANALISIS DE COSTO ///////////////////////////////////////////////// 
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "analisiscosto")
  {
    $docuid = $_GET['docuid'];
     
    $teridprov = $clase->BDLockup($docuid,'documentos','docuid','terid1');  
    $numcompra = $clase->BDLockup($docuid,'documentos','docuid','CONCAT(prefijo,numero)');  
	  $nrodocref = $clase->BDLockup($docuid,'documentos','docuid','nrodocref');
   
    //// Actualizo la Retencion en la Fuente
    refrescarRetefuente($docuid);

	  $vsqlx = "SELECT CONCAT(prefijo,numero) FROM documentos D INNER JOIN docuself DS ON (D.docuid = DS.docuid2) WHERE DS.docuid =".$docuid." limit 0,1";
	  $numoc = $clase->SeleccionarUno($vsqlx);
	 
	  $control1 = ValidarProductosCostoBajo($docuid);

	  $valcom = $clase->BDLockup($docuid,'documentos','docuid','total');
	  $valoco = $clase->SeleccionarUno("SELECT total FROM documentos D INNER JOIN docuself DS ON (D.docuid = DS.docuid2) WHERE DS.docuid =".$docuid." limit 0,1");	 
    $creadoroc = $clase->SeleccionarUno("SELECT creador FROM documentos D INNER JOIN docuself DS ON (D.docuid = DS.docuid2) WHERE DS.docuid =".$docuid." limit 0,1");	 
    $diferencia = $valcom-$valoco;

    //// Si es una remision - Evalua las diferencias sino No 
    $cont = $clase->HeaderBlanco("Analisis Costo Compra");
    $cont.='
    
    <center>
    <table width="1550">
      <tr class="TablaDocsImPar"> 
        <td width="100%" align="center"><br> <h2> An&aacute;lisis de Costos de la Factura </h2> </td>
      </tr>	 			   
    </table>';	 

    $cont.=' 
    <table width="100%">
      <tr class="CabezoteTabla"> 
        <td width="10"> </td>
        <td width="37"> <img src="images/iconos/compras.png" width="32" height="32" border="0"> </td>
        <td width="200"> <b> Diferencias</b> <td>
        <td width="200"> Fact Compra <br><b> <a href="reportes/impcompras.php?docuid='.$docuid.'" target="_blank"> <font color="blue">'.$numcompra.'</b></a></td>        
        <td width="200"> Orden Compra <br><b> <a href="productos.php?opcion=link&nrodoc=PCO'.trim($numoc).'" target="_blank"> <font color="blue">'.$numoc.'</b></a></td>				 
        <td width="200"> Creador :  <br> <font color="blue">'.$creadoroc.' </td>	
        <td width="120" align="right"> Vlr Orden C.<br><b> '.number_format($valoco).'</b> <td>
        <td width="120" align="right"> Vlr Compra <br><b> '.number_format($valcom).'</b> <td>
        <td width="120" align="right"> Diferencia<br><b><font color="red">'.number_format($diferencia).'</b> <td>';

    if($opcion == "pre-asentar")			 
    $cont.='
        <td width="60" align="center"><a href="javascript:history.back();"><input type="button" class="button" value="<<"></a> </td>
        <td width="50" align="center"><a href="compras.php"><input type="button" class="button blue" value="Compras"></a> </td>'; 

    $cont.='
        <td width="10">&nbsp;</td>				 
      </tr>
    </table>';

   $cont.= PermisosEspeciales(1,$docuid);  

    $cont.='
      <div id="zoliframe">
        <iframe id="miiframe" onload="displayTest();" src="compras.php?opcion=listadiferencias&boton=no&docuid='.$docuid.'&numoco='.$numoc.'" frameborder="0" scrollbars="auto" width="1550" height="780"></iframe>
      </div>  ';

      echo $cont; exit();
    } //// Fin del Agregar Detalle 

///////////////////////////////////////////////////////////////
/////////////INFORME DETALLE DE PRODUCTO       ///////////////
//////////////////////////////////////////////////////////////////

    if($opcion == "detalleproducto")
    {
      $docuid = $_GET['docuid'];
       
      $teridprov = $clase->BDLockup($docuid,'documentos','docuid','terid1');  
      $numcompra = $clase->BDLockup($docuid,'documentos','docuid','CONCAT(prefijo,numero)');  
      $nrodocref = $clase->BDLockup($docuid,'documentos','docuid','nrodocref');
     
      //// Actualizo la Retencion en la Fuente
      refrescarRetefuente($docuid);
  
      $vsqlx = "SELECT CONCAT(prefijo,numero) FROM documentos D INNER JOIN docuself DS ON (D.docuid = DS.docuid2) WHERE DS.docuid =".$docuid." limit 0,1";
      $numoc = $clase->SeleccionarUno($vsqlx);
     
      $control1 = ValidarProductosCostoBajo($docuid);
  
      $valcom = $clase->BDLockup($docuid,'documentos','docuid','total');
      $valoco = $clase->SeleccionarUno("SELECT total FROM documentos D INNER JOIN docuself DS ON (D.docuid = DS.docuid2) WHERE DS.docuid =".$docuid." limit 0,1");	 
      $creadoroc = $clase->SeleccionarUno("SELECT creador FROM documentos D INNER JOIN docuself DS ON (D.docuid = DS.docuid2) WHERE DS.docuid =".$docuid." limit 0,1");	 
      $diferencia = $valcom-$valoco;
  
       //// Si es una remision - Evalua las diferencias sino No 
    $cont = $clase->HeaderBlanco("Analisis Costo Compra");
    $cont.='
    <center>
    <table width="1550">
      <tr class="TablaDocsImPar"> 
        <td width="100%" align="center"><br> <h2> An&aacute;lisis de Costos de la Factura </h2> </td>
      </tr>	 			   
    </table>';	 

    $cont.=' 
    <table width="100%">
      <tr class="CabezoteTabla"> 
        <td width="10"> </td>
        <td width="37"> <img src="images/iconos/compras.png" width="32" height="32" border="0"> </td>
        <td width="200"> <b> Diferencias</b> <td>
        <td width="200"> Fact Compra <br><b> <a href="reportes/impcompras.php?docuid='.$docuid.'" target="_blank"> <font color="blue">'.$numcompra.'</b></a></td>        
        <td width="200"> Orden Compra <br><b> <a href="productos.php?opcion=link&nrodoc=PCO'.trim($numoc).'" target="_blank"> <font color="blue">'.$numoc.'</b></a></td>				 
        <td width="200"> Creador :  <br> <font color="blue">'.$creadoroc.' </td>	
        <td width="120" align="right"> Vlr Orden C.<br><b> '.number_format($valoco).'</b> <td>
        <td width="120" align="right"> Vlr Compra <br><b> '.number_format($valcom).'</b> <td>
        <td width="120" align="right"> Diferencia<br><b><font color="red">'.number_format($diferencia).'</b> <td>';

    if($opcion == "pre-asentar")			 
    $cont.='
        <td width="60" align="center"><a href="javascript:history.back();"><input type="button" class="button" value="<<"></a> </td>
        <td width="50" align="center"><a href="compras.php"><input type="button" class="button blue" value="Compras"></a> </td>'; 

    $cont.='
        <td width="10">&nbsp;</td>				 
      </tr>
    </table>';
  
    $cont.= PermisosEspeciales(2,$docuid);  	 
     
     $vsql   = "SELECT * FROM documentos D LEFT JOIN docucompra DC ON (D.docuid = DC.docuid) WHERE D.docuid=".$docuid;
  	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);

	   if($row = mysql_fetch_array($result)) 
	   {
  	    $aplicar2 = $row['aplicar2'];
  	    $cont.= $clase->HeaderBlanco("Compra # ".substr($row['nrodocref'],0,10)); 
        $cont.= Javascript();		 
	  
    	  $bodegapredet = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS'],'bodegas','codbodega','bodegaid');

    	  if($row['terid1'] != 1)
    	    $codterid1 = $clase->BDLockup($row['terid1'],'terceros','terid','dni');

    	  if($row['terid2'] != 1)
    	    $vendedor = $clase->BDLockup($row['terid2'],'terceros','terid','dni');
	  
    	  $fecha  = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);
        $fechac  = substr($row['momento'],8,2)."/".substr($row['momento'],5,2)."/".substr($row['momento'],0,4);
    	  $fechav = substr($row['fecvence'],8,2)."/".substr($row['fecvence'],5,2)."/".substr($row['fecvence'],0,4);

    	  $diferencia = (strtotime($row['fecvence'])-strtotime($row['fechadoc']));
    	  $diascartera = round($row['diascartera']);

	  $cont.='<table width="100%">
	            <tr class="CabezoteTabla"> 
			         <td width="10"> </td>
			         <td width="37"> <img src="images/iconos/cotizacion.png" width="32" height="32" border="0"> </td>
               <td width="1100"><b> Detalle Producto a Producto de Rotaci&oacute;n - Precios - Utilidad </b><td>
          		 <td width="8"> </td>
			       </tr>	 			   
			     </table>';
			        	
	 
	 //// Selecciono los articulos para detallarlos
     $vsql2= "SELECT 
                DD.porciva ivadig , 
                TRIM(GP.descripcion) labo , 
                B.* , 
                DD.* , 
                COALESCE(DDO.dctol1,0) dctol1 , 
                COALESCE(DDO.dctol2,0) dctol2 , 
                COALESCE(DDO.dctol3,0) dctol3 , 
                COALESCE(DDO.dctol4,0) dctol4 , 
                P.bloqueado , 
                P.controlado , 
                P.regulado , 
                DDO.obsequio , 
                P.codigo , 
                P.descripcion , 
                P.precio1m , 
                P.precio1g , 
                P.porciva ivapro , 
                P.porcutilfijo ,
                FU_Rotacion30dias(P.productoid) rotacion , 
                FU_ExistenciaTotal(P.productoid) existencia                
              FROM dedocumentos DD INNER JOIN productos P ON (DD.productoid = P.productoid)
              INNER JOIN gruposprod GP ON (GP.gruposprodid = P.gruposprodid)
	            INNER JOIN bodegas B ON (B.bodegaid = DD.bodegaid) 
	            LEFT JOIN dedocuorden DDO ON (DDO.dedocumid = DD.dedocumid)
	 		        WHERE DD.docuid=".$docuid." ORDER BY DD.dedocumid DESC";	 

	 $conex2  = $clase->Conectar();  
     $result2 = mysql_query($vsql2,$conex2);
	 $registros = mysql_num_rows($result2);
	 
	 if($registros > 0)
	 {
        $i = 0;
        $cont.='
        <script type="text/javascript" src="lib/sorttable.js"></script>
        <table width="100%" class="sortable" id="faccompra">
			     <thead> 
	           <tr class="TituloTabla" style="display:block; padding-top:10px;height:38px;"> 
			         <td width="10"> </td>
			         <td width="15"> </td>
			         <td width="120"> C&oacute;digo <br>de Barras</td>
               <td width="170"> Producto y/o Servicio </td>		
               <td width="40"> Laborator</td>		
               <td width="90" align="right"> Precio<br>Base </td>
               <td width="75" align="right"> Porcen<br>Utilidad </td>
               <td width="95" align="right"> Precio<br>M&iacute;nimo </td>	
               <td width="85" align="right"> Param<br>Control </td>	
               <td width="80" align="right"> Utilidad<br>Bruta </td>				 
               <td width="60" align="right"> Cant </td>				 
               <td width="50" align="right"> Obse </td>	
               <td width="60" align="right"> R30 </td>           
               <td width="50" align="right"> Tiene D&iacute;as </td>
               <td width="90" align="right"> Valor<br>Unitario</td>
               <td width="50" align="right"> Dto $</td>
               <td width="55" align="right"> %Iva </td>
               <td width="90" align="right"><b>Vlr Base</td>
               <td width="80" align="right"><b>Vlr Iva</td>
               <td width="100" align="right"><b>Vlr Total</b></td>
               <td width="20" align="right"></td>
			       </tr>
			    </thead>
			  <tbody style="display:block; width:1550px; height:450px; overflow-Y:scroll">';			

		    $dcto1 = $clase->BDLockup($docuid,'docucompra','docuid','dcto1');
        $dcto2 = $clase->BDLockup($docuid,'docucompra','docuid','dcto2');
        $dcto3 = $clase->BDLockup($docuid,'docucompra','docuid','dcto3');	 	
        $dcto4 = $clase->BDLockup($docuid,'docucompra','docuid','dcto4');	
		  
      while($row2 = mysql_fetch_array($result2))
	    {
	       /// Cálculo del Precio Minimo de Venta 
           $productoid   = $row2['productoid']; 
           $valor        = (($row2['valunitario']*$row2['cantidad'])/($row2['cantidad']+$row2['obsequio']));
           $porcutilfijo = round($row2['porcutilfijo'],1);
           $costoinf     = $row2['costoinf'];
           $precio1g     = $row2['precio1g'];  
     
           $valor        = $valor-($valor*($dcto1/100));
           //$valor        = $valor-($valor*($dcto2/100));
           $valor        = $valor-($valor*($dcto3/100));
           $valor        = $valor-($valor*($dcto3/100));

           //$valor        = $valor-($valor*($row2['dctol1']/100));
           //$valor        = $valor-($valor*($row2['dctol2']/100));
           $valor        = $valor-($valor*($row2['dctol3']/100));
           $valor        = $valor-($valor*($row2['dctol4']/100));

           //$valor        = @$valor-($valor*($row2['valdescuento']/100));   
           $nprecio      = @($valor/((100-$porcutilfijo)/100));
           
           if($row2['precio1g'] < $nprecio)
		      $alertaprecio = '<b><font color="red">';
           else
              $alertaprecio = '';			   

		   if($row2['ivapro'] > 0)
		   {
		      $base       = $nprecio;
		      $coniva     = round($base + ($base*($row2['ivapro']/100)));  //12562
		      $dosultimas = substr($coniva,strlen($coniva)-2,strlen($coniva));
		      $factor     = 100-$dosultimas;
		      $aproximado = $coniva+$factor;
		      $nprecio    = $aproximado/(1+($row2['ivapro']/100));
		      $nompro     = '<font color="blue">'.substr($row2['descripcion'],0,90).'</font>';	
		   }		   
		   else
		      $nompro = substr($row2['descripcion'],0,30); 	 
		   
		       //// Calculo el Valor aprox de Precio
		       $valor        = $row2['valunitario'];
           $valor        = $valor-($valor*($dcto1/100));
           //$valor        = $valor-($valor*($dcto2/100));
           $valor        = $valor-($valor*($dcto3/100));
           $valor        = $valor-($valor*($dcto4/100));
           $valor        = $valor-($valor*($row2['valdescuento']/100));
		       $parametro = @((abs($valor-$precio1g)*100)/$precio1g);		   

           //// Calculo de la Utilidad Bruta
           $utilidad = $row2['precio1g']-$valor;
           if($utilidad>0)  $utilx = '<font color="gray">'.number_format($utilidad).'</font>';
           else             $utilx = '<font color="red">'.number_format($utilidad).'</font>';    
           
           if($row2['obsequio']>0)
              $obsequiox = number_format($row2['obsequio']);
           else
              $obsequiox = "-"; 

           $i++;
  		 
       ///Calculo el numero de dias que quedaría el producto 
       $tienepara  = @((($row2['existencia']+$row2['cantidad']+$row2['transito']+$row2['obsequio']))/($row2['rotacion']/30));  
       if($tienepara < 90)
         $tieneparax = '<font color="#8000FF">'.number_format($tienepara);
       else
         $tieneparax = '<font color="red">'.number_format($tienepara); 
      

       /// Aplico los colores de la Siguiente forma
       /// Gris - Inactivos  Verdes - Con Observacion  - Purpura Especial
       //// Resalta los Verdes que tienen ***    
       $color='<font color="black">';                         ///// Negro por Defecto 
       if($row2['enespe'] > 0)                                 ///// En Bodegas Especiales
           $color='<font color="#2E2EFE">';
       if($row2['bloqueado'] == "CHECKED")                     ///// Productos Bloqueados
           $color='<font color="GRAY">'; 
       if($row2['controlado'] == "CHECKED")                    ///// Productos Precio Regulados
           $color='<font color="BLUE">'; 
       if($row2['regulado'] == "CHECKED")                      ///// Productos Control Especial
           $color='<font color="#BF00FF">'; 
       if(substr($row2['observacion'],0,2) == "**")            ///// Productos Bonificados
           $color='<font color="#01DF3A">'; 
       if(substr($row2['observacion'],0,1) == "+")             ///// Productos Bonificado Temporalmente
           $color='<font color="orange">'; 
       if(substr($row2['observacion'],0,1) == "/")             ///// Productos Ventas Especiales
           $color='<font color="#FF33F9">'; 
       if(substr($row2['observacion'],0,1) == "?")             ///// Productos Se debe quitar Bonificado con Existencia Cero 
           $color='<font color="#B45F04">'; 


       if($i%2 == 0)
		      $cont.='<tr class="TablaDocsPar" id="'.$i.'" data-value="'.$row2['dedocumid'].'">';
		   else
		      $cont.='<tr class="TablaDocsImPar" id="'.$i.'" data-value="'.$row2['dedocumid'].'">';

		   $cont.=' <td width="10">&nbsp;</td> 
		            <td width="20">'.$i.'</td>
		            <td width="110"> <b> <font color="black" size ="0.3">  '.$row2['codigo'].'</b></td>
		            <td width="200"> <a href="productos.php?opcion=detalles&productoid='.$row2['productoid'].'" target="_blank"> '.$color.' '.$nompro.' </font> </a> </td>
		            <td width="80"><b>'.$color.''.substr($row2['labo'],0,12).'</b> </td>
      					<td width="80" align="right">'.$color.''.$alertaprecio.number_format($row2['precio1g']).'</td>
      					<td width="90" align="right"><font color="blue">'.$color.''.number_format($row2['porcutilfijo'],1).' %</td>
      					<td width="95" align="right">'.$color.''.$alertaprecio.number_format($nprecio,2).'</td>
      					<td width="90" align="right"> <font color="blue">'.$alertaprecio.number_format($parametro,1).' %</td>
      					<td width="90" align="right">'.$color.''.$utilx.'</td>					
      					<td width="70" align="right">'.number_format($row2['cantidad']).'</td>					
      					<td width="60" align="right"> <font color="red">'.$obsequiox.'</font></td>					
                <td width="60" align="right"> <font color="gray">'.number_format($row2['rotacion']).' </font></td>  
                <td width="60" align="right"> <b> '.$tieneparax.' </font></td>  
      					<td width="90" align="right" class="estilovalor">'.number_format($row2['valunitario'],2).'</td>
      					<td width="60" align="center"> <b> <font color="gray" size ="0.3">'.$row2['valdescuento'].'</b></td>					
      					<td width="70" align="center">'.number_format($row2['ivadig'],1).'</td>
      					<td width="80" align="right" class="azul"> '.number_format($row2['valbase'],2).'</b></td>		
      					<td width="80" align="right"> '.number_format($row2['valiva'],1).'</b></td>		
                <td width="110" align="right" class="estilovalor"><b>'.number_format($row2['valtotal'],2).'</b></td>		
                <td  width="30" align="right"> <a href="productos.php?opcion=rotaciondrog&id='.$row2['productoid'].'" target="_blank">
                <img src="images/basicas/estadisticas.png" border="0" title="Rotación del Producto"></a></td>										 	 				 					
      					<td width="15"> </td>';
	      
		  $cont.='</tr>';   				  
	    }		  

      $cont.='</tbody></table><br><br>';
  
	  } /// Si hay articulos 
	 
	 } //// 
	 echo $cont; exit();
  } //// Fin del Agregar Detalle 

  //////////////////////////////////////////////////////////////////////////////////////////////////////    
  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "modificarenc2")
  {
     $docuid     = $_POST['docuid'];
     $nrodocref  = strtoupper($_POST['nrodocref']);
     $fechadoc   = $_POST['fechadoc'];
     $fechalle   = $_POST['fechallegada'];
     $formpago   = $_POST['formapago'];
     $observacion2 = $_POST['observacion2'];
     
     $dcto1      = 0 + $_POST['dcto1'];
     $dcto2      = 0 + $_POST['dcto2'];
     $dcto3      = 0 + $_POST['dcto3'];
     $dcto4      = 0 + $_POST['dcto4'];

     /// Con el Proveedor -> Nit .. Busco el Terid
     $proveedor  = $_POST['proveedor'];
     $terid   = $clase->BDLockup($proveedor,"terceros","dni","terid");

     /// Actualizo la Compra
     $vsqlc = "UPDATE documentos SET nrodocref = '".$nrodocref."' , observacion2 = '".$observacion2."' , fechadoc = '".$fechadoc."' , formapago = '".$formapago."' 
               WHERE docuid = ".$docuid;
     $clase->EjecutarSQL($vsqlc);

     $vsqlc = "UPDATE docucompra SET dcto1 = ".$dcto1." , dcto2 = '".$dcto2."' , dcto3 = '".$dcto3."' , dcto4 = '".$dcto4."' , fechallegada = '".$fechalle."' WHERE docuid = ".$docuid;
     $clase->EjecutarSQL($vsqlc);
     
     /// Actualizo la Fecha de Vencimineto en Base a los Dias
     $vsqlaux = "UPDATE documentos SET fecvence = DATE_ADD('".$fechalle."', INTERVAL ".$dias." DAY) WHERE docuid=".$docuid;
     $clase->EjecutarSQL($vsqlaux); 

     /// Si es a Credito - Actualizo la Cuenta por Pagar
     $formapago  = $clase->BDLockup($docuid,"documentos","prefijo","formapago"); 
     if($formapago == "CR")
     {
         /// Con el Docuid -> Busco el Prefijo y Numero
         $prefijo = $clase->BDLockup($docuid,"documentos","prefijo","prefijo");
         $numero  = $clase->BDLockup($docuid,"documentos","prefijo","numero");
         
         /// Actualizo la Cuenta por Pagar
         $vsqlc2 = "UPDATE documentos SET terid1 = ".$terid." , nrodocref = '".$nrodocref."' , fechadoc = '".$fechadoc."' , descuentogen = ".$dcto1." 
                    WHERE tipodoc = 'CXP' AND prefijo = '".$prefijo."' AND numero = '".$numero."'";
         $clase->EjecutarSQL($vsqlc2);
     } 
    
     //// Envio el Correo de Notificacion
     $plantilla = "";                                                      
     $ruta = "recursos/html/cambiopreciofco.html";
     $fp = fopen($ruta,"r");     
     while ($linea= fgets($fp,2048))
       $plantilla.= $linea;
     
     /// Extraigo la Informacion
     $factura     = $clase->BDLockup($docuid,"documentos","docuid","CONCAT(tipodoc,' ',prefijo,' ',numero)");
     $usuario     = $_SESSION['USERNAME'];
     $momento     = date("d/m/Y H:i:s");   
    
     /// Reemplazo los campos  
     $plantilla = str_replace("#{USUARIO}" , $usuario , $plantilla); 
     $plantilla = str_replace("#{FACTURA}", $factura , $plantilla );                 
     $plantilla = str_replace("#{MOMENTO}" , $momento, $plantilla);
     $plantilla = str_replace("#{TRANSACCION}", $docuid, $plantilla);                

     require 'lib/PHPMailer/PHPMailerAutoload.php';
     $mail = new PHPMailer;
     $mail->isSMTP();
     $mail->SMTPDebug = 0;
     if($_SESSION['G_TIPOCORREO'] == "HTML")
       $mail->Debugoutput = 'html'; 
     
     $mail->Host = $_SESSION['G_HOSTCORREO'];
     $mail->Port = 587;
     $mail->SMTPSecure = 'tls';
     $mail->SMTPAuth = true;
     $mail->Timeout=20;
     $mail->CharSet = 'UTF-8';
     $mail->Username = $_SESSION['G_USERCORREO'];
     $mail->Password = $_SESSION['G_CLAVECORREO'];
     $mail->setFrom('sistemas@dromedicas.com.co', 'DROPOS ERP Notificaciones');
     $mail->addReplyTo('sistemas@dromedicas.com.co', 'DROPOS ERP Notificaciones');
     
     $mail->addAddress("johnduran@dromedicas.com.co", "Gerencia Dromedicas");
     $mail->addAddress("contabilidad@dromedicas.com.co", "Contabilidad Dromedicas");
     //$mail->addAddress("sistemas@dromedicas.com.co", "Sistemas Dromedicas");
     
     $mail->Subject = 'Cambio Encabezado de Facturas de Compra';
     
     $mail->isHTML(true);       
     $mail->Body = $plantilla;
     $mail->send();

     /// Redirecciono al Listado
     $clase->Aviso(2,"<b>Hecho : </b> Encabezado de la Factura modificado con Exito");
     header("Location: compras.php");
  }
      
  //////////////////////////////////////////////////////////////////////////////////////////////////////    
  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "modificarenc")
  {
        $docuid    = $_GET['docuid'];
        
        /// Busco la Forma de Pago - Si es Credito - Busco si Tiene Abonos para saber si es posible o no
        $formapago  = $clase->BDLockup($docuid,"documentos","docuid","formapago"); 
        if($formapago == "CR")
        {
           /// Con el Docuid -> Busco el Prefijo y Numero
           $prefijo = $clase->BDLockup($docuid,"documentos","docuid","prefijo");
           $numero  = $clase->BDLockup($docuid,"documentos","docuid","numero");
           
           $vsqlx = "SELECT COUNT(*) FROM documentos WHERE tipodoc = 'CXP' AND prefijo = '".$prefijo."' AND numero = '".$numero."' AND ROUND(saldo) < ROUND(total)";
           $cxpvivas = $clase->SeleccionarUno($vsqlx);
           if($cxpvivas > 0)
           {
              echo'<script language="javascript">
                     <!--
                        alert("Esta Factura ya tiene Comprobantes de Egreso Asociados. No se puede modificar");
                        document.location.href = "compras.php";
                     -->
                   </script>';
           }   
        }  
        
        //// Verifico que sea un SuperUsuario para ejecutar esta tarea
        if($_SESSION['SUPERUSUARIO'] == "")
        {
           if($_SESSION['USERNAME'] != "D.LOZANO")
           {
              echo'<script language="javascript">
                     <!--
                        alert("Debe ser SuperUsuario para ejecutar esta tarea");
                        document.location.href = "compras.php";
                     -->
                   </script>';
           }            
        }  

        $documento = $clase->SeleccionarUno("SELECT CONCAT(tipodoc,prefijo,numero) FROM documentos WHERE docuid = ".$docuid);
        
        //// Cargo los Datos a Mostrar
        $terid  = $clase->BDLockup($docuid,"documentos","docuid","terid1");  
        $dni    = $clase->BDLockup($terid,"terceros","terid","dni");
        
        $nrodoc   = $clase->BDLockup($docuid,"documentos","docuid","nrodocref");
        $fechadoc = substr($clase->BDLockup($docuid,"documentos","docuid","fechadoc"),0,10);
        $dcto1    = $clase->BDLockup($docuid,"docucompra","docuid","dcto1");
        $dcto2    = $clase->BDLockup($docuid,"docucompra","docuid","dcto2");
        $dcto3    = $clase->BDLockup($docuid,"docucompra","docuid","dcto3");
        $dcto4    = $clase->BDLockup($docuid,"docucompra","docuid","dcto4");
        $dias     = $clase->BDLockup($docuid,"docucompra","docuid","diascartera");
        $fechalle = $clase->BDLockup($docuid,"docucompra","docuid","fechallegada");
        $observacion2 = $clase->BDLockup($docuid,"documentos","docuid","observacion2");

        /// Convierto la Forma de Pago en RadioButtons
        $formapago = $clase->BDLockup($docuid,"documentos","docuid","formapago");
        if($formapago == "CR")   $sel1 = 'CHECKED';   else     $sel2 = 'CHECKED';

        $cont='<form action = "compras.php?opcion=modificarenc2" method = "POST">
                 <input type="hidden" name="docuid" value="'.$docuid.'">
               <table width="600">
                 <tr class="TituloTabla"> 
                   <td align="center"> <b>Modificar Encabezado del Documento <font color="red">'.$documento.'</b> <td> 
                 </tr> 
               </table>
               <table width="600">
                 <tr class="TablaDocsPar">       
                   <td width="20"> &nbsp; </td>         
                   <td width="360"> No. Factura Prov </td>        
                   <td width="360"> <input type="text" name="nrodocref" class="Texto11" autocomplete="off" value="'.$nrodoc.'"> </td>        
                   <td width="20"> &nbsp; </td>         
                 </tr>
                 <tr class="TablaDocsImPar">       
                   <td width="20"> &nbsp; </td>         
                   <td width="360"> Documento Relacionado </td>        
                   <td width="360"> <input type="text" name="observacion2" class="Texto11" autocomplete="off" value="'.$observacion2.'"> </td>        
                   <td width="20"> &nbsp; </td>         
                 </tr>
                 <tr class="TablaDocsPar">       
                   <td width="20"> &nbsp; </td>         
                   <td width="360"> Fecha Documento </td>        
                   <td width="360"> <input type="date" name="fechadoc" class="Texto11" autocomplete="off" value="'.$fechadoc.'"> </td>        
                   <td width="20"> &nbsp; </td>         
                 </tr>
                 <tr class="TablaDocsImPar">       
                   <td width="20"> &nbsp; </td>         
                   <td width="360"> Fecha Llegada </td>        
                   <td width="360"> <input type="date" name="fechallegada" class="Texto11" autocomplete="off" value="'.$fechalle.'"> </td>        
                   <td width="20"> &nbsp; </td>         
                 </tr>
                 <tr class="TablaDocsImPar">       
                   <td width="20"> &nbsp; </td>         
                   <td width="360"> Dias Vencim </td>        
                   <td width="360"> <input type="text" name="dias" class="Texto11" autocomplete="off" size="3" value="'.round($dias).'" readonly> </td>        
                   <td width="20"> &nbsp; </td>         
                 </tr>
                 <tr class="TablaDocsPar">       
                   <td width="20"> &nbsp; </td>         
                   <td width="360"> Forma Pago </td>        
                   <td width="360"> <input type="radio" name="formapago" class="Texto11" value = "CR" '.$sel1.'> Cr&eacute;dito &nbsp;&nbsp;
                                    <input type="radio" name="formapago" class="Texto11" value = "CO" '.$sel2.'> Contado &nbsp;&nbsp;
                   </td>        
                   <td width="20"> &nbsp; </td>         
                 </tr>
                 <tr class="TablaDocsImPar">       
                   <td width="20"> &nbsp; </td>         
                   <td width="360"> Descuentos </td>        
                   <td width="360"> Dcto 1 <input type="text" name="dcto1" class="Texto11" size="3" autocomplete="off" value="'.$dcto1.'"> &nbsp; 
                                    Dcto 2 <input type="text" name="dcto2" class="Texto11" size="3" autocomplete="off" value="'.$dcto2.'"> &nbsp; 
                   </td>        
                   <td width="20"> &nbsp; </td>         
                 </tr>
                 <tr class="TablaDocsPar">       
                   <td width="20"> &nbsp; </td>         
                   <td width="360"> Descuentos x Notas </td>        
                   <td width="360"> Dcto Nota 1 <input type="text" name="dcto3" class="Texto11" size="3" autocomplete="off" value="'.$dcto3.'"> &nbsp; 
                                    Dcto Nota 2 <input type="text" name="dcto4" class="Texto11" size="3" autocomplete="off" value="'.$dcto4.'"> &nbsp; 
                   </td>        
                   <td width="20"> &nbsp; </td>         
                 </tr>
            </table><br><center>
             <input type="submit" class="button red" value="MODIFICAR ENCABEZADO DE LA COMPRA"> 
            <br>'; 
      echo $cont; exit;
  }    


  //////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////
  if($opcion == "delcondipro")
  {  
      $id = $_GET['id'];         
      $clase->EjecutarSQL("DELETE  FROM condicionesprove WHERE id = ".$id);
      $clase->Aviso(2,"<b>Hecho : </b> Condiciones almacenadas con Exito");
      header("Location: compras.php?opcion=condicionesprov");
  }

  //////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////
  if($opcion == "savecondipro")
  {  
     $proveedor = $_POST['proveedor'];                   $descripcion = strtoupper($_POST['descripcion']);
     $dcto1 = 0 + $_POST['dcto1'];                       $dcto2 = 0 + $_POST['dcto2'];
     $dcto3 = 0 + $_POST['dcto3'];                       $dcto4 = 0 + $_POST['dcto4'];
     $dias  = 0 + $_POST['dias'];                        $lispre = $_POST['lispre'];

     if(strlen($proveedor)>0)
     {
        $pid  = $clase->BDLockup($proveedor,"terceros","dni","terid");
        $vsql = "INSERT INTO condicionesprove(proveedorid,descripcion,dias,dcto1,dcto2,dcto3,dcto4,lispre,creador) VALUES(".$pid.",'".
                $descripcion."','".$dias."','".$dcto1."','".$dcto2."','".$dcto3."','".$dcto4."','".$lispre."','".$_SESSION['USERNAME']."')";

        $clase->EjecutarSQL($vsql); 
        $clase->Aviso(2,"<b>Hecho : </b> Condiciones almacenadas con Exito");
        header("Location: compras.php?opcion=condicionesprov");
     }
     else
     {
        $clase->Aviso(3,"<b>Error : </b> Debe Ingresar toda la informacion");
        header("Location: compras.php?opcion=addcondiprov");
     }
  }
   
  //////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////
  if($opcion == "addcondiprov")
  {  
      $cont = $clase->Header("S","W");  
      $cont.='<table width="100%">
             <tr class="CabezoteTabla"> 
              <td width="10"> &nbsp; </td>
              <td width="37"> <img src="images/iconos/configuracion.png" width="32" height="32" border="0"> </td>
              <td width="950"> <b> Agregar Condiciones de Proveedores</b> - Acuerdos comerciales para descuentos en Compras<td>
              <td> <a href="compras.php?opcion=condicionesprov"><input type="button" value="<<" class="button blue"></a> </td>
              <td width="10"> &nbsp; </td>
             </tr>           
            </table>';  
       
      $cont.='<center><br>
            <form action="compras.php?opcion=savecondipro" method="POST">
            <fieldset style="width: 530px; height: 400px;" class="grupos">
               <legend class="titgrupos"> Agregar Condiciones </legend>
                <table width="350">   
                     <tr height="55"><td> <label class="Texto12"> <b>Proveedor</b></label><br>
                                     
<!-- ************************************************************************************************ -->
<!-- AJAX AUTOSUGGEST SCRIPT -->
<script type="text/javascript" src="lib/ajax_framework7.js"></script>
<style type="text/css">
#search-wrap7 input{font-size:12px; text-transform:Capitalize; background-color:#D6F0FE; border-style:groove;}
#res7{width:150px; border:solid 1px #DEDEDE; display:none;}
#res7 ul, #res7 li{padding:0; margin:0; border:0; list-style:none; background:#F6F6F6;}
#res7 li {border-top:solid 1px #DEDEDE; background:#CEEAF5;}
#res7 li a{display:block; padding:2px; text-decoration:none; color:#000000; font-weight:bold; font-size:10px; font-family:Verdana;}
#res7 li a small{display:block; text-decoration:none; color:#999999; font-weight:normal; font-size:9px;font-family:Verdana;}
#res7 li a:hover{background:#FFFFFF;}
#res7 ul {padding:4px;}
</style>
<div id="search-wrap7">
<input name="proveedor" onkeypress="return TabulaEnter(this, event)" id="search-q7" type="text" onkeyup="javascript:autosuggest7();" maxlength="12" size="35" autocomplete="off" tabindex="13"  value="'.$codterid1.'"/>
<div id="res7"></div>

&nbsp;<label class="Texto10"><b>'.$nombre.'</b></label>
</div>
<!-- AJAX AUTOSUGGEST SCRIPT -->
<!-- ************************************************************************************************ -->

                     <tr height="55"><td> <label class="Texto12"> <b>Nombre Convenio</b></label><br>
                       <input type="text" name="descripcion" class="Texto12"  maxlength="40" size="40"> </td></tr>
                </table>
                <table width="350">
                     <tr height="55">
                        <td> <label class="Texto12"> <b>Dcto 1 </b></label><br> 
                          <input type="text" name="dcto1" class="Texto12" size="5" maxlength="5"> </td>
                        <td> <label class="Texto12"> <b>Dcto 2 </b></label><br> 
                          <input type="text" name="dcto2" class="Texto12" size="5" maxlength="5"> </td>
                     </tr>
                     <tr height="55">
                        <td> <label class="Texto12"> <b>Dcto Nota 1 </b></label><br> 
                          <input type="text" name="dcto3" class="Texto12" size="5" maxlength="5"> </td>
                        <td> <label class="Texto12"> <b>Dcto Nota 2 </b></label><br> 
                          <input type="text" name="dcto4" class="Texto12" size="5" maxlength="5"> </td>
                     </tr>
                     <tr height="55">
                        <td> <label class="Texto12"> <b>Dias Plazo </b></label><br> 
                          <input type="text" name="dias" class="Texto12" size="5" maxlength="5"> </td>
                        <td> <input type="checkbox" name="lispre" class="Texto12" value="CHECKED"> 
                               <label class="Texto12"> Con Lista Precios </b></label><br> 
                           </td>
                     </tr>
                </table>   
                <table width="350">   
                     <tr>
                       <td align="center"><br><br> <input type="submit" value="Guardar Condiciones Proveedor" class="button blue"> </td></tr>      
                </table>
              <br><br></form>
            </fieldset>';
  }

  //////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////
  if($opcion == "condicionesprov")
  {  
      $cont = $clase->Header("S","W");  
      $cont.='<table width="100%">
             <tr class="CabezoteTabla"> 
              <td width="10"> &nbsp; </td>
              <td width="37"> <img src="images/iconos/configuracion.png" width="32" height="32" border="0"> </td>
              <td width="950"> <b>Condiciones de Proveedores</b> - Acuerdos comerciales para descuentos en Compras<td>
              <td> <a href="compras.php?opcion=addcondiprov"><input type="button" value=" + " class="button red"></a> </td>
              <td> <a href="javascript:history.back();"><input type="button" value="<<" class="button blue"></a> </td>
              <td width="10"> &nbsp; </td>
             </tr>           
            </table>';  
       
      /// Busco en el LOG de Auditoria los cambios al Documento
      $vsql = "SELECT T.nombres , T.apellidos , C.* 
               FROM condicionesprove C INNER JOIN terceros T ON (C.proveedorid = T.terid) 
               WHERE 1 ORDER BY C.id DESC";
      $conex  = $clase->Conectar();
      $result = mysql_query($vsql,$conex);

      $cont.='<table width="100%">
            <thead>
              <tr class="TituloTabla" style="display:block; padding-top:10px;height:28px;"> 
                <td width="20"> </td>
                <td width="210"> Proveedor </td>     
                <td width="180"> Convenio </td>   
                <td width="140" align="right"> Dias </td>     
                <td width="80" align="right" align="right"> Dcto 1 </td>     
                <td width="80" align="right"> Dcto 2 </td>     
                <td width="80" align="right"> Dcto 3 </td>     
                <td width="80" align="right"> Dcto 4 </td>     
                <td width="80" align="right"> Lista P </td>  
                <td width="140" align="center"> Usuario </td>
                <td width="140" align="center"> Momento </td>
                <td width="20"> </td>                 
                <td width="20"> </td>                 
              </tr>
            </thead>
          <tbody style="display:block; width:1050px; height:560px; overflow-Y:scroll">';  

    $i = 0;
    while($row = mysql_fetch_array($result)) 
    {
       $i++;
       if($i%2 == 0)
         $cont.='<tr class="TablaDocsPar">';
       else
         $cont.='<tr class="TablaDocsImPar">';     
              
       $cont.=' <td width="20"> </td>
                <td width="180"><b>'.$row['nombres'].' '.$row['apellidos'].' </td>
                <td width="150"> '.$row['descripcion'].' </td>
                <td width="120" align="right"> '.number_format($row['dias']).' </td>
                <td width="80" align="right"> '.number_format($row['dcto1']).' </td>
                <td width="80" align="right"> '.number_format($row['dcto2']).' </td>
                <td width="80" align="right"> '.number_format($row['dcto3']).' </td>
                <td width="80" align="right"> '.number_format($row['dcto4']).' </td>
                <td width="80" align="center"> <input type="checkbox" disabled '.$row['lispre'].'> </td>
                <td width="100" align="center"> '.$row['creador'].' </td>
                <td width="100" align="right"> '.$row['momento'].' </td>
                <td width="20" align="center"> <a href="compras.php?opcion=delcondipro&id='.$row['id'].'"> <img src="images/basicas/iconoborrar.png"> </a></td>                 
                <td width="10"> &nbsp; </td></tr>';
    }
    $cont.='</tbody></table><br>';

  }

  //////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////
  if($opcion == "contenidoexcel")
  {  
       $docuid = $_GET['docuid'];
       $vsql = "SELECT P.codigo , P.descripcion , sum(DD.cantidad) cantidad , SUM(DD.valunitario) valunitario  
                FROM dedocumentos DD INNER JOIN productos P ON (DD.productoid = P.productoid) 
                WHERE docuid = ".$docuid." GROUP BY 1,2";
       $_SESSION['SQL_EXCEL'] = $vsql;
       header("Location: reportes/exportarexcel.php?opcion=reporte21");   
  }

  ////////////////////////////////////////////////////////////////////////////  
  /////////////////////////////////////////////////////////////////////"////////  
  if($opcion == "fcoconnotas")
  {
      $cont = $clase->Header("S","W");  
      $cont.='<table width="100%">
             <tr class="CabezoteTabla"> 
              <td width="10"> </td>
              <td width="37"> <img src="images/iconos/notas.png" width="32" height="32" border="0"> </td>
              <td width="850"> <b>Facturas de Compra con Notas D&eacute;bito</b> - Descuentos por Nota que se generan Autom&aacute;ticamente<td>
              <td><a href="compras.php"><input type="submit" value="<< Compras" class="button blue"></a></td>
             </tr>           
            </table>';  
       
      /// Busco en el LOG de Auditoria los cambios al Documento
      $vsql = "SELECT DISTINCT T.nombres , T.apellidos , D.* FROM documentos D
                INNER JOIN terceros T ON (D.terid1 = T.terid) 
                INNER JOIN docucompra D2 ON (D.docuid = D2.docuid) 
                INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid)
                INNER JOIN dedocuorden DDO ON (DD.dedocumid = DDO.dedocumid)
                WHERE D.fecasentado <> '0000-00-00' AND D.fechadoc > '2015-12-31' AND D.tipodoc = 'FCO' 
                AND (D2.dcto3 > 0 OR D2.dcto4 > 0  OR DDO.dctol3 > 0 OR DDO.dctol4 > 0 )
                ORDER BY D.fechadoc DESC";
      $conex  = $clase->Conectar();
      $result = mysql_query($vsql,$conex);

      $cont.='<table width="100%">
            <thead>
              <tr class="TituloTabla" style="display:block; padding-top:10px;height:28px;"> 
                <td width="20"> </td>
                <td width="150"> Documento </td>     
                <td width="130">  Fecha </td>     
                <td width="170">  Num Prov </td>     
                <td width="50">  FP </td>     
                <td width="350"> Proveedor </td>
                <td width="150" align="right">  Vlr Total </td>     
                <td width="150" align="center"> Usuario </td>
                <td width="30"> </td>                 
              </tr>
            </thead>
          <tbody style="display:block; width:1050px; height:560px; overflow-Y:scroll">';  

    $i = 0;
    while($row = mysql_fetch_array($result)) 
    {
       $i++;
       if($i%2 == 0)
         $cont.='<tr class="TablaDocsPar">';
       else
         $cont.='<tr class="TablaDocsImPar">';     
              
       $cont.=' <td width="20"> </td>
                <td width="170"> <font color="blue"> <a href="reportes/impcompras.php?docuid='.$row['docuid'].'" target="_blank"> 
                '.$row['tipodoc'].' '.$row['prefijo'].' '.$row['numero'].' </a></td>
                <td width="150"> '.substr($row['fechadoc'],0,10).' </td>
                <td width="170"> <b>'.$row['nrodocref'].' </td>
                <td width="50"> '.$row['formapago'].' </td>
                <td width="400"> '.$row['nombres'].' '.$row['apellidos'].'</td>
                <td width="150" align="right"> <b>'.number_format($row['total'],1).' </td>     
                <td width="150" align="center"> <b><font color="gray">'.$row['creador'].'</b> </td>
                <td width="20"> &nbsp; </td></tr>';
    }
    $cont.='</tbody></table><br>';
  }
  //////////////////////////////////////////////////////////////////////////////////////////////////
  ///Edicion en linea para factura de compra                                                  /////
  ////////////////////////////////////////////////////////////////////////////////////////////////

//***
//Proceso VALOR: Valbase,valiba,vrtotal (id´s de la celda en la tabla)
  //Actualiza la fila cuando se edita el valor del producto
  //Recibe el ID del registro y el nuevo valor del producto.
  //Retorna el nuevo valor para "Valor Dcto", "Diferencia", "Dif Porcentaje", "Vlr Total"
  //Retorna los Globales para  "Items", "Vlr Base", "Vlr Iva", "Total"
  if($opcion == "actualizarvalor")
  {
    $idDedocumento = $_GET['id'];
    $nuevaValor = $_GET['vunit'];
    $x = $_GET['vunit'];
    if($nuevaValor == 0){
      // echo "invalid";
      exit;
    }
    
    try{
      // echo $nuevaValor; exit;
      //obtengo el id del documento
      $docuid = $clase->SeleccionarUno("SELECT docuid FROM dedocumentos WHERE dedocumid = " .$idDedocumento  );  

      //actualizo el nuevo valor unitario - obtengo los costos informativos
      $valornumericox = str_replace(",","",$nuevaValor);
      $queryString = "UPDATE dedocumentos SET valunitario = ".$valornumericox." WHERE dedocumid=".$idDedocumento;
      $clase->EjecutarSQL($queryString);

      $deDocumentosTemp    = $clase->SeleccionarUno("SELECT CONCAT(valunitario,'|',porciva,'|',cantidad) FROM dedocumentos WHERE dedocumid = " .$idDedocumento  );   
      list($valunitario, $porciva, $cantidad ) = split('[|]', $deDocumentosTemp);

      $vbase = $cantidad * $valunitario;
      $viva  = round((($cantidad*$valunitario)*$porciva)/100);
      $vpar  = $vbase + $viva;

      $queryString1 = "UPDATE dedocumentos 
                      SET 
                       valbase  = ".$vbase.",
                       valiva = ".$viva.",
                       valparcial = ".$vpar.",
                       valtotal =".$vpar."
                       WHERE dedocumid=".$idDedocumento;
      $clase->EjecutarSQL($queryString1); 
     
      $vsql  = "SELECT SUM(cantidad) FROM dedocumentos WHERE docuid=".$docuid;
      $totalitems  = $clase->SeleccionarUno($vsql);
      $vsql  = "SELECT SUM(valbase) FROM dedocumentos WHERE docuid=".$docuid;
      $base  = $clase->SeleccionarUno($vsql);
      $vsql  = "SELECT SUM(valiva) FROM dedocumentos WHERE docuid=".$docuid;
      $iva   = $clase->SeleccionarUno($vsql);
      $vsql  = "SELECT SUM(valtotal) FROM dedocumentos WHERE docuid=".$docuid;   
      $total = $clase->SeleccionarUno($vsql);      
      $clase->EjecutarSQL("UPDATE documentos SET totalitems =".$totalitems." , base=".$base." , iva=".$iva." , total=".$total." WHERE docuid=".$docuid); 

      $queryString2    = $clase->SeleccionarUno("SELECT CONCAT(valbase,'|',valiva,'|',valparcial) FROM dedocumentos WHERE dedocumid = " .$idDedocumento  );   
      list($v_base, $v_iva, $v_par ) = split('[|]', $queryString2);

      echo "".number_format($v_base,2).";".number_format($viva,2).";".number_format($v_par,2).";".number_format($base,2).";".number_format($iva,2).";".number_format($total,2).";".number_format($total,2).""; 
    
    }catch(Exception $e){
      echo 'Error ',  $e->getMessage();
    } 
   
    exit;
  }//fin del VALOR

  //////////////////////////////////////////////////////////////////////////////////////////////////////////////
  //Proceso de backend para edicion en linea para el campo de Obsequio de factura de compra
  //
  if($opcion == "actualizarObsequio")
  {
    $idDedocumento = $_GET['id'];
    $nuevoValor = $_GET['obsequioId'];
    echo $nuevoValor; exit;
    if($nuevoValor == 0){
      echo "invalid";
      exit;
    }
    //  prueba de obsequio
    
    
    try{
      
      //obtengo el id del documento
      $docuid = $clase->SeleccionarUno("SELECT docuid FROM dedocumentos WHERE dedocumid = " .$idDedocumento  );  

      //actualizo el nuevo valor para obsequio   
      $obsequioX = str_replace(",","",$nuevoValor);  
      $queryString = "UPDATE dedocuorden SET obsequio = ".$obsequioX." WHERE dedocumid=".$idDedocumento;
      echo $queryString;
      $clase->EjecutarSQL($queryString);
      
    }catch(Exception $e){
      echo 'Error ',  $e->getMessage();
    } 
    exit;
  }//fin del VALOR


  //Proceso de backend para edicion en linea para el campo de Cantidad de factura de compra
  //
  if($opcion == "actualizarcantidad")
  {
    $idDedocumento = $_GET['id'];
    $nuevoValor = $_GET['cantidadId'];
    if($nuevoValor == 0){
      echo "invalid";
      exit;
    }
    
    try{
      
      //obtengo el id del documento
      $docuid = $clase->SeleccionarUno("SELECT docuid FROM dedocumentos WHERE dedocumid = " .$idDedocumento  );  

      //actualizo el nuevo valor unitario - obtengo los costos informativos
      $queryString = "UPDATE dedocumentos SET cantidad = ".$nuevoValor." WHERE dedocumid=".$idDedocumento;
      $clase->EjecutarSQL($queryString);

      $deDocumentosTemp    = $clase->SeleccionarUno("SELECT CONCAT(valunitario,'|',porciva,'|',cantidad) FROM dedocumentos WHERE dedocumid = " .$idDedocumento  );   
      list($valunitario, $porciva, $cantidad ) = split('[|]', $deDocumentosTemp);

      $vbase = $cantidad * $valunitario;
      $viva  = round((($cantidad*$valunitario)*$porciva)/100);
      $vpar  = $vbase + $viva;

      $queryString1 = "UPDATE dedocumentos 
                      SET 
                       valbase  = ".$vbase.",
                       valiva = ".$viva.",
                       valparcial = ".$vpar.",
                       valtotal =".$vpar."
                       WHERE dedocumid=".$idDedocumento;
      $clase->EjecutarSQL($queryString1); 
     
      $vsql  = "SELECT SUM(cantidad) FROM dedocumentos WHERE docuid=".$docuid;
      $totalitems  = $clase->SeleccionarUno($vsql);
      $vsql  = "SELECT SUM(valbase) FROM dedocumentos WHERE docuid=".$docuid;
      $base  = $clase->SeleccionarUno($vsql);
      $vsql  = "SELECT SUM(valiva) FROM dedocumentos WHERE docuid=".$docuid;
      $iva   = $clase->SeleccionarUno($vsql);
      $vsql  = "SELECT SUM(valtotal) FROM dedocumentos WHERE docuid=".$docuid;   
      $total = $clase->SeleccionarUno($vsql);      
      $clase->EjecutarSQL("UPDATE documentos SET totalitems =".$totalitems." , base=".$base." , iva=".$iva." , total=".$total." WHERE docuid=".$docuid); 

      $queryString2    = $clase->SeleccionarUno("SELECT CONCAT(valbase,'|',valiva,'|',valparcial) FROM dedocumentos WHERE dedocumid = " .$idDedocumento  );   
      list($v_base, $v_iva, $v_par ) = split('[|]', $queryString2);

      echo "".number_format($valunitario).";".number_format($v_base).";".number_format($viva).";".number_format($v_par).";".number_format($base,2).";".number_format($iva,2).";".number_format($total,2).";".number_format($total,2).""; 
      
    }catch(Exception $e){
      echo 'Error ',  $e->getMessage();
    } 
    exit;
  }//fin del VALOR


  //////////////////////////////////////////////////////////////////////////////////////////////////////    
  //// Abril 07 2017 
  //// Regenera a Tesoreria TODAS las Nota Debito segun los descuentos de la Factura de Compra
  //////////////////////////////////////////////////////////////////////////////////////////////////////
  if($opcion == "regenerarndbfco")
  {
     $i = $_GET['i'];    if($i == "") $i = 0;

     $vsql = "SELECT DISTINCT D.docuid FROM documentos D 
              INNER JOIN docucompra D2 ON (D.docuid = D2.docuid) 
              INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid)
              INNER JOIN dedocuorden DDO ON (DD.dedocumid = DDO.dedocumid)
              WHERE D.fechadoc > '2015-12-31' AND D.tipodoc = 'FCO' AND (D2.dcto3 > 0 OR D2.dcto4 > 0  OR DDO.dctol3 > 0 OR DDO.dctol4 > 0 )
              LIMIT ".$i.",1";
     
     $docuid = $clase->SeleccionarUno($vsql);
     if($docuid != "")
     {
        GenerarNotasCompra($docuid);
        echo"Factura de Compra Id. <b>".$docuid."</b> - Regenerada..."; 
        $i++;
        echo'<script language="javascript">
              <!--
                function redireccionarPagina() 
                {
                  window.location = "compras.php?opcion=regenerarndbfco&i='.$i.'";
                }
                
                setTimeout("redireccionarPagina()", 1000);
              -->
             </script>'; 
     }
     else
     {
        echo"Proceso Finalizado con Exito"; 
     } 
     exit();
  }


  //////////////////////////////////////////////////////////////////////////////////////////////////////    
  //// Abril 06 2017 
  //// Regenera a Tesoreria la Nota Debito segun los descuentos de la Factura de Compra
  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "regenerarnotasdb")
  {
      $docuid = $_GET['docuid'];
      GenerarNotasCompra($docuid);
      
      $clase->Aviso(1,"Notas D&eacute;bito de la Compra Re-generadas exitosamente");
      header("Location: compras.php");
  }

  //////////////////////////////////////////////////////////////////////////////////////////////////////    
  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "cambiarperiodo2")
  {
     $codper = $_POST['periodo'];
     header("Location: compras.php?periodo=".$codper);
     exit();
  }    

  //////////////////////////////////////////////////////////////////////////////////////////////////////    
  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "cambiarperiodo")
  {
    $vsqlcombo = "SELECT * FROM periodos ORDER BY orden DESC";
    $params    = ' class="Texto9" OnChange="x.submit();"';       
    $combo     = $clase->CrearComboEsp("periodo",$vsqlcombo,"codperiodo","nomperiodo","","",$params);
    
    $cont='<form action="compras.php?opcion=cambiarperiodo2" method="POST" name="x">
           <table width="400">
             <tr class="CabezoteTabla"> 
             <td align="center"> Cambiar de Periodo </b> <td> 
           </tr> </table>
           <table width="400">
             <tr class="TablaDocsImPar">       
               <td width="50"> &nbsp; </td>        
               <td width="150"> Periodo :  </td>        
               <td width="200"> '.$combo.' <input type="submit" value="Ir"></form> </td>        
             </tr>
           </table>';
    
    echo $cont;  exit();
  }           

  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "diferenciaspdf2")
  {
     ini_set("memory_limit","300M");
     set_time_limit(0);
 
     $docuid = $_GET['docuid'];
     $numoco = $_GET['numoco'];  
  
     require('lib/fpdf/fpdf.php');
     $pdf=new FPDF();
     $pdf->AddPage();
     $pdf->SetFont('Arial','B',11);               $pdf->Text(10,13,'ENTRE COSTOS INFORMATIVOS DE PRODUCTOS ANTERIOR Y NUEVO');
     $pdf->SetFillColor(220,220,220);             $pdf->Rect(10,16,190,25,'F');         
     
     //// Extraigo los datos del Encabezado del PDF
     $pdf->SetFont('Arial','B',9);               
     $pdf->Text(13,22,'ORDEN COMPRA No.');        $pdf->Text(60,22,'PROVEEDOR');          $pdf->Text(145,22,'CREADOR');            $pdf->Text(186,22,'VALOR');
     $pdf->Text(13,35,'COMPRA No.');              $pdf->Text(60,35,'PROVEEDOR');          $pdf->Text(145,35,'CREADOR');            $pdf->Text(186,35,'VALOR');
     
     $NumeroOC  = $numoco;
     $proveOC   = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros T INNER JOIN documentos D ON (T.terid = D.terid1) WHERE CONCAT(D.tipodoc,D.prefijo,D.numero) = 'PCO".$numoco."'");
     $creadorOC = $clase->BDLockup("PCO".$numoco,"documentos","CONCAT(tipodoc,prefijo,numero)","creador");
     $valorOC   = $clase->BDLockup("PCO".$numoco,"documentos","CONCAT(tipodoc,prefijo,numero)","total");

     $NumeroC  = $clase->BDLockup($docuid,"documentos","docuid","CONCAT(tipodoc,prefijo,numero)");
     $proveC   = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros T INNER JOIN documentos D ON (T.terid = D.terid1) WHERE D.docuid = ".$docuid);
     $creadorC = $clase->BDLockup($docuid,"documentos","docuid","creador");
     $valorC   = $clase->BDLockup($docuid,"documentos","docuid","total");

     $pdf->SetFont('Arial','',9);               
     $pdf->Text(13,26,$NumeroOC);                 $pdf->Text(60,26,$proveOC);             $pdf->Text(145,26,$creadorOC);           $pdf->Text(182,26,number_format($valorOC));
     $pdf->Text(13,38,$NumeroC);                  $pdf->Text(60,38,$proveC);              $pdf->Text(145,38,$creadorC);            $pdf->Text(182,38,number_format($valorC));
   
     //// Busco todas las Ordenes de Compra que se relacionan con esta compra
     $vsql = "SELECT * FROM docuself WHERE docuid = ".$docuid;
     $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex); 
     $canordenes = mysql_num_rows($result);
     $listaordenes = "";
     while($row = mysql_fetch_array($result))  
     {
        if($i>0)
        $listaordenes.= ",";
      
      $listaordenes.= $row['docuid2'];
       $i++;
    }   

     ///// BLOQUE3 : Productos IGUALES   
     ///// Diferencias en el Producto en Cantidad y Precio
     $vsql = "SELECT P.productoid , P.codigo , P.descripcion , P.factor1 , P.costoinf , DD.valunitario , DD.valparcial , DD.cantidad , DDO.obsequio , DCC.dcto1 , P.porciva 
              FROM documentos D INNER JOIN docucompra DCC ON (D.docuid = DCC.docuid)
              INNER JOIN dedocumentos DD ON ( D.docuid = DD.docuid ) 
              INNER JOIN dedocuorden DDO ON ( DD.dedocumid = DDO.dedocumid ) 
              INNER JOIN productos P ON ( P.productoid = DD.productoid ) 
              WHERE D.docuid = ".$docuid." ORDER BY descripcion ASC";

     $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex); 
    
     $x=10;   $y = 49; $totalgen = 0;

     $pdf->SetFillColor(220,220,220);              $pdf->Rect(10,44,190,6,'F');                             
     $pdf->SetFont('Arial','B',9);
     $pdf->Text($x+0,$y,"CODBARRA");               $pdf->Text($x+24,$y,"PRODUCTO");   
     $pdf->Text($x+95,$y,"CANT");                  $pdf->Text($x+113,$y,"ANTER CI");   
     $pdf->Text($x+136,$y,"NUEVO CI");             $pdf->Text($x+159,$y,"DIFER");   
     $pdf->Text($x+177,$y,"% DIF");
     
     $x=10;   $y = 53; $totalgen = 0;
     while($row = mysql_fetch_array($result)) 
     {
       $Ncostoinf = (($row['valunitario']*$row['cantidad'])/($row['cantidad']+$row['obsequio']));
       $Ncostoinf = ($Ncostoinf-($Ncostoinf*($row['dcto1']/100)));
       if($row['porciva']>0)
         $Ncostoinf = $Ncostoinf-($Ncostoinf*($row['porciva']/100));

       $difpre = $row['costoinf']-$Ncostoinf;
       $porcendif = @abs(($difpre/$row['costoinf'])*100);
       //// Si Es error no lo muestro
       //if(($difpre < 0)&&($porcendif>1))
       if($difpre < 0)
       { 
          $pdf->SetFont('Arial','',8);                            $pdf->Text($x+0,$y,$row['codigo']);        $pdf->Text($x+24,$y,substr($row['descripcion'],0,30));   
          $pdf->SetXY($x+88,$y-1.5);                              $pdf->MultiCell(16,1,number_format(($row['cantidad']+$row['obsequio']),0),0,'R');  
          $pdf->SetXY($x+112,$y-1.5);                             $pdf->MultiCell(16,1,number_format($row['costoinf'],0),0,'R');  
          $pdf->SetXY($x+135,$y-1.5);                             $pdf->MultiCell(16,1,number_format($Ncostoinf,0),0,'R');  
          $pdf->SetXY($x+153,$y-1.5);                             $pdf->MultiCell(16,1,number_format($difpre,1),0,'R');  
          $pdf->SetXY($x+172,$y-1.5);                             $pdf->MultiCell(16,1,number_format($porcendif,1),0,'R');  

          //// Paginacion
          if($y>270){
             $pdf->AddPage();    $y = 20;
          }
          
          $totalgen += $difpre;
          $y+=4; 
      } /// IF DIf Precio    

    } // While
     
     $pdf->SetFont('Arial','B',10);  
     $pdf->SetXY($x+163,$y-1.3);                                    $pdf->MultiCell(25,1,number_format($totalgen,1),0,'R');   
     
     /////////// FINALIZANDO EL INFORME
     /// Nombres del Aplicativo
     $pdf->SetFont('Arial','',8);           $cont= 'Pagina '.$pag;           $pdf->Text(10,280,$cont);
     $pdf->Text(50,280,$pie1);              $pdf->Text(164,280,$_SESSION['G_NOMBRE_APP']);
  
     /// Genero el PDF 
     $pdf->Output();  
  } /// Fin del 2do PDF


  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "diferenciaspdf")
  {
     ini_set("memory_limit","300M");
     set_time_limit(0);

	 $docuid = $_GET['docuid'];
	 $numoco = $_GET['numoco'];	 
  
     require('lib/fpdf/fpdf.php');
	 $pdf=new FPDF();
	 $pdf->AddPage();
	 $pdf->SetFont('Arial','B',11);               $pdf->Text(10,13,'DIFERENCIAS PRECIO ORDEN DE COMPRA - FACTURA');
     $pdf->SetFillColor(220,220,220);             $pdf->Rect(10,16,190,25,'F');	        
     
     //// Extraigo los datos del Encabezado del PDF
     $pdf->SetFont('Arial','B',9);               
     $pdf->Text(13,22,'ORDEN COMPRA No.');        $pdf->Text(60,22,'PROVEEDOR');          $pdf->Text(145,22,'CREADOR');            $pdf->Text(186,22,'VALOR');
     $pdf->Text(13,35,'COMPRA No.');              $pdf->Text(60,35,'PROVEEDOR');          $pdf->Text(145,35,'CREADOR');            $pdf->Text(186,35,'VALOR');
     
     $NumeroOC  = $numoco;
     $proveOC   = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros T INNER JOIN documentos D ON (T.terid = D.terid1) WHERE CONCAT(D.tipodoc,D.prefijo,D.numero) = 'PCO".$numoco."'");
     $creadorOC = $clase->BDLockup("PCO".$numoco,"documentos","CONCAT(tipodoc,prefijo,numero)","creador");
     $valorOC   = $clase->BDLockup("PCO".$numoco,"documentos","CONCAT(tipodoc,prefijo,numero)","total");

     $NumeroC  = $clase->BDLockup($docuid,"documentos","docuid","CONCAT(tipodoc,prefijo,numero)");
     $proveC   = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros T INNER JOIN documentos D ON (T.terid = D.terid1) WHERE D.docuid = ".$docuid);
     $creadorC = $clase->BDLockup($docuid,"documentos","docuid","creador");
     $valorC   = $clase->BDLockup($docuid,"documentos","docuid","total");

     $pdf->SetFont('Arial','',9);               
     $pdf->Text(13,26,$NumeroOC);                 $pdf->Text(60,26,$proveOC);             $pdf->Text(145,26,$creadorOC);           $pdf->Text(182,26,number_format($valorOC));
     $pdf->Text(13,38,$NumeroC);                  $pdf->Text(60,38,$proveC);              $pdf->Text(145,38,$creadorC);            $pdf->Text(182,38,number_format($valorC));
	 
	 //// Busco todas las Ordenes de Compra que se relacionan con esta compra
	 $vsql = "SELECT * FROM docuself WHERE docuid = ".$docuid;
	 $conex  = $clase->Conectar();
	 $result = mysql_query($vsql,$conex);	
     $canordenes = mysql_num_rows($result);
	 $listaordenes = "";
	 while($row = mysql_fetch_array($result))  
     {
	      if($i>0)
		    $listaordenes.= ",";
			
		  $listaordenes.= $row['docuid2'];
		  $i++;
	 }	 

	   ///// BLOQUE1 : Productos IGUALES   
     ///// Diferencias en el Producto en Cantidad y Precio
 	 $vsql = "SELECT DISTINCT C.prefijo , C.numero , C.nrodocref , OC.prefijo , OC.numero , P.codigo, P.descripcion, P.factor1 , 
	          DC.cantidad CanCom, (DOC.cantidad+DDOX.obsequio) CanOrd, ((DC.valunitario*DC.cantidad)/(DC.cantidad+DDOX.obsequio)) ValCom, DOC.valunitario ValOrd 
			  FROM documentos C INNER JOIN dedocumentos DC ON ( C.docuid = DC.docuid ) 
              LEFT JOIN dedocuorden DDOX ON (DDOX.dedocumid = DC.dedocumid)
			  INNER JOIN productos P ON ( P.productoid = DC.productoid ) 
			  INNER JOIN docuself DS ON (DS.docuid = C.docuid) INNER JOIN documentos OC ON ( OC.docuid = DS.docuid2 )  
			  INNER JOIN dedocumentos DOC ON ( OC.docuid = DOC.docuid AND DOC.productoid = DC.productoid) 
              WHERE C.docuid =".$docuid." ORDER BY P.descripcion ASC ";  			  

	 $conex  = $clase->Conectar();
	 $result = mysql_query($vsql,$conex);	
  
  
     $x=10;   $y = 49; $totalgen = 0;

     $pdf->SetFillColor(220,220,220);      	       $pdf->Rect(10,44,190,6,'F');	                            
     $pdf->SetFont('Arial','B',9);
     $pdf->Text($x+0,$y,"CODBARRA");               $pdf->Text($x+24,$y,"PRODUCTO");   
	 $pdf->Text($x+95,$y,"CANT");                  $pdf->Text($x+113,$y,"COMPRA");   
 	 $pdf->Text($x+139,$y,"ORDEN");                $pdf->Text($x+159,$y,"DIFER");   
	 $pdf->Text($x+175,$y,"DIF TOT");
     
	 $x=10;   $y = 53; $totalgen = 0;
     while($row = mysql_fetch_array($result)) 
     {
	    $diferencia1 = $row['ValCom']-$row['ValOrd'];
	    $diferencia2 = $row['CanCom']*$diferencia1;
        if($diferencia1>1)
        { 
		      $pdf->SetFont('Arial','',8);                            $pdf->Text($x+0,$y,$row['codigo']);        $pdf->Text($x+24,$y,substr($row['descripcion'],0,30));   
			    $pdf->SetXY($x+88,$y-1.5);                              $pdf->MultiCell(16,1,number_format($row['CanCom'],0),0,'R'); 	
	        $pdf->SetXY($x+112,$y-1.5);                             $pdf->MultiCell(16,1,number_format($row['ValCom'],0),0,'R'); 	
	        $pdf->SetXY($x+135,$y-1.5);                             $pdf->MultiCell(16,1,number_format($row['ValOrd'],0),0,'R'); 	
	        $pdf->SetXY($x+149,$y-1.5);                             $pdf->MultiCell(20,1,number_format($diferencia1,1),0,'R'); 	
	        $pdf->SetXY($x+168,$y-1.5);                             $pdf->MultiCell(20,1,number_format($diferencia2,1),0,'R'); 	

        //// Paginacion
        if($y>270){
          $pdf->AddPage();    $y = 20;
        }
	        $totalgen += $diferencia2;
		    $y+=4; 
        }        
     }
     
     $pdf->SetFont('Arial','B',10);  
     $pdf->SetXY($x+163,$y-1.3);                                    $pdf->MultiCell(25,1,number_format($totalgen,1),0,'R'); 	
 

     ///// BLOQUE2 : Errores en Cantidades
     ///// Diferencias en el Producto en Cantidad y Precio
 	 $vsql = "SELECT DISTINCT P.productoid , P.codigo , P.descripcion , P.factor1 , 
 	          SUM(IF(D.tipodoc = 'PCO' , (DD.cantidad+DDO.obsequio) , (-1)*(DD.cantidad+DDO.obsequio))) Diferencia , 
 	          COALESCE(SUM(IF(D.tipodoc = 'PCO' , DD.cantidad ,0)),0) EnOrden , COALESCE(SUM(IF(D.tipodoc = 'FCO' , DD.cantidad ,0)),0) EnFactura , 
 	          COALESCE(SUM(IF(D.tipodoc = 'PCO' , DDO.obsequio ,0)),0) ObsEnOrden , COALESCE(SUM(IF(D.tipodoc = 'FCO' , DDO.obsequio ,0)),0) ObsEnFactura 	          
			  FROM dedocumentos DD INNER JOIN productos P ON (DD.productoid = P.productoid)
			  INNER JOIN documentos D ON (D.docuid = DD.docuid)
			  LEFT JOIN dedocuorden DDO ON (DDO.dedocumid = DD.dedocumid)
			  WHERE D.docuid IN (".$docuid.",".$listaordenes.")
			  GROUP BY 1,2,3,4 ORDER BY P.descripcion ASC ";  	

	 $conex  = $clase->Conectar();
	 $result = mysql_query($vsql,$conex);	
  
  
     $x=10;   $y += 8; $totalgen = 0;

     $pdf->SetFillColor(220,220,220);      	       $pdf->Rect(10,$y-4,190,6,'F');	                            
     $pdf->SetFont('Arial','B',9);
     $pdf->Text($x+0,$y,"CODBARRA");               $pdf->Text($x+24,$y,"PRODUCTO");   
	 $pdf->Text($x+87,$y,"CANT ORD");              $pdf->Text($x+108,$y,"OBS ORDEN");   
 	 $pdf->Text($x+132,$y,"CANT COMP");            $pdf->Text($x+155,$y,"OBS COM");   
	 $pdf->Text($x+175,$y,"DIFERE");
     
	 $x=10;   $y += 5; $totalgen = 0;
     while($row = mysql_fetch_array($result)) 
     {
	      $diferencia = (0+abs($row['EnOrden']+$row['ObsEnOrden'])-($row['EnFactura']+$row['ObsEnFactura']));
        if(abs($diferencia) >= 1)
        {
    	      $pdf->SetFont('Arial','',8);                            $pdf->Text($x+0,$y,$row['codigo']);        $pdf->Text($x+24,$y,substr($row['descripcion'],0,30));   
    		    $pdf->SetXY($x+88,$y-1.5);                              $pdf->MultiCell(16,1,number_format($row['EnOrden'],0),0,'R'); 	
            $pdf->SetXY($x+112,$y-1.5);                             $pdf->MultiCell(16,1,number_format($row['ObsEnOrden'],0),0,'R'); 	
            $pdf->SetXY($x+135,$y-1.5);                             $pdf->MultiCell(16,1,number_format($row['EnFactura'],0),0,'R'); 	
            $pdf->SetXY($x+153,$y-1.5);                             $pdf->MultiCell(16,1,number_format($row['ObsEnFactura'],0),0,'R'); 	
            $pdf->SetXY($x+172,$y-1.5);                             $pdf->MultiCell(16,1,number_format(abs($diferencia),0),0,'R'); 	
            
            //// Paginacion
            if($y>270){
            	$pdf->AddPage();    $y = 20;
            }
            
            $totalgen2 += $diferencia;
    		    $y+=4; 
      }
     }
      	 
     /////////// FINALIZANDO EL INFORME
     /// Nombres del Aplicativo
     $pdf->SetFont('Arial','',8);           $cont= 'Pagina '.$pag;           $pdf->Text(10,280,$cont);
     $pdf->Text(50,280,$pie1);              $pdf->Text(164,280,$_SESSION['G_NOMBRE_APP']);
  
     /// Genero el PDF 
     $pdf->Output();	
  }  

  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////    
  if($opcion == "actualizarcosto")
  {
     //// Busco las nuevas
     $docuid = $_GET['id']; 
     CostoAsentarCompra($docuid);
     $clase->Aviso(1,'Costos Actualizados con Exito');
     header("Location: productos.php");
  } 

  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////    
  if($opcion == "copiaraservidor")
  {
     //// Busco las nuevas
     $docuid = $_GET['docuid']; 
     $exito = CopiarCompraAServidor($docuid);
     $clase->Aviso(1,'Factura de Compra copiada al Servidor con Exito');
     header("Location: compras.php");
  } 

  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////    
  if($opcion == "accionesmasivas")
  {
      //// Busco las nuevas
      $docuid = $_POST['docuid']; 
      $lista  = ""; 
      
      $vsql = "SELECT dedocumid FROM dedocumentos WHERE docuid=".$docuid;
      $conex  = $clase->Conectar();
      $result = mysql_query($vsql,$conex);
      while($row = mysql_fetch_array($result)) 
      { 
         if($_POST['LIN-'.$row['dedocumid']] == "S")
            $lista.= $row['dedocumid'].",";
      }
      $lista = $lista."-1";
      
      ///// Eliminar Lineas
      $clase->EjecutarSQL("DELETE FROM dedocumentos WHERE dedocumid IN (".$lista.")");
      $clase->Aviso(1,'Productos eliminados del Documento con Exito');
      header("Location: compras.php?opcion=crearimportar&docuid=".$docuid);
   }   


  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "actcostoprod")
  {
	 $productoid  = $_GET['productoid'];
     $vsql = "SELECT D.docuid FROM dedocumentos DD INNER JOIN productos P ON (DD.productoid = P.productoid) INNER JOIN documentos D ON (D.docuid = DD.docuid) 
              WHCERE D.tipodoc = 'FCO' AND D.fecasentado <> '0000-00-00' AND P.productoid = '".$productoid."' ORDER BY docuid DESC LIMIT 0,1";
     $docuid = $clase->SeleccionarUno($vsql); 
     CostoAsentarCompra($docuid);		  
     $clase->Aviso(2,"Costo del Producto recalculado con Exito");
	 header("Location: productos.php");
  }   

  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "duplicar")
  {
	 $docuid  = $_GET['docuid'];              $id=0;
    
	 //// Encabezado de la Orden de Compra  	 
 	 $vsql = "SELECT * FROM documentos WHERE docuid =".$docuid;  	
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);	
	 if($row = mysql_fetch_array($result)) 
	 {
		$conse1 = $clase->SeleccionarUno("SELECT numero FROM consecutivos WHERE tipodoc = '".$row['tipodoc']."' AND prefijo = '".$row['prefijo']."'");
		$conse = $conse1+1;
		$clase->EjecutarSQL("UPDATE consecutivos SET numero = '".$conse."' WHERE tipodoc = '".$row['tipodoc']."' AND prefijo = '".$row['prefijo']."'");
        $numero = $conse;
 	    $referencia = "";

		$vsqlx = "INSERT INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,terid1,terid2,terid3,nrodocref,observacion,sucursalid,creador,momento) VALUES('".$row['tipodoc']."','".
		          $row['prefijo']."','".$numero."','".$row['periodo']."','".$row['fechadoc']."','".$row['terid1']."','".$row['terid2']."','".$row['terid3']."','".
				  $referencia."','".$row['observacion']."','".$row['sucursalid']."','".$row['creador']."',CURRENT_TIMESTAMP)";

		$id = $clase->EjecutarSQL($vsqlx);
		$numorden = $row['prefijo']." ".$numero;  
        $NDocuid = $clase->SeleccionarUno("SELECT docuid FROM documentos WHERE tipodoc='".$row['tipodoc']."' AND prefijo='".$row['prefijo']."' AND numero='".$numero."'");
     }	 

	 ///// Paso de la Orden Anterior a esta
	 if($id>0)
	 {
	   // Importo los productos
	   $vsql = "SELECT * FROM dedocumentos WHERE docuid =".$docuid;
	   $conex  = $clase->Conectar();
       $result = mysql_query($vsql,$conex);	
	   while($row = mysql_fetch_array($result)) 
	   {
	      $ddid  = $row['dedocumid'];	 
		  $vsqly = "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,tipund,costoprod,valunitario,valdescuento,valparcial,porciva,valbase,valiva,valtotal,diasrecor,numlinea,unicom,unifra) values(".
		           $NDocuid.",'".$row['productoid']."','".$row['bodegaid']."','".$row['cantidad']."','".$row['unidades']."','".$row['tipund']."','".$row['costoprod']."','".$row['valunitario']."','".
				   $row['valdescuento']."','".$row['valparcial']."','".$row['porciva']."','".$row['valbase']."','".$row['valiva']."','".$row['valtotal']."','".$row['diasrecor']."',0,'".
				   $row['unicom']."','".$row['unifra']."')";	 
		  $clase->EjecutarSQL($vsqly);  
	   }

        /// Asiento el Documento 
	    $clase->EjecutarSQL("UPDATE dedocumentos SET unidades = cantidad WHERE docuid=".$NDocuid);	   

        //// Totalizo los valores de la Compra
		$clase->EjecutarSQL("PA_CalValoresFCO(".$NDocuid.")");		
	    
	   $clase->Aviso(1,'Factura de Compra duplicada con Exito. No. <b>'.$numorden.'</b>');
	   header("Location: transferencias.php?opcion=crear&docuid=".$NDocuid);		 
	 }  	 
  } 


  /////////////////////////////////////////////////////////////////////////////  
  /////////////////////////////////////////////////////////////////////"////////  
  if($opcion == "logactividades")
  {
     $docuid    = $_GET['docuid'];
	 $documento = $clase->SeleccionarUno("SELECT CONCAT(tipodoc,prefijo,numero) FROM documentos WHERE docuid=".$docuid);

	 $cont = $clase->Header("S","W");	 
	 $cont.='<table width="100%">
	           <tr class="CabezoteTabla"> 
			     <td width="10"> </td>
			     <td width="37"> <img src="images/iconos/notas.png" width="32" height="32" border="0"> </td>
				 <td width="780"> <b>LOG de Cambios al Documento </b> - Fact de Compra No. <b>'.$documento.'</b><td>
				 <td><a href="compras.php"><input type="submit" value="<< Transferencias" class="button blue"></a></td>
			   </tr>	 			   
			 </table> ';	
			 
    /// Busco en el LOG de Auditoria los cambios al Documento
    $vsql = "SELECT * FROM logauditoria WHERE docuid = ".$docuid." ORDER BY momento DESC";
   	$conex  = $clase->Conectar();
    $result = mysql_query($vsql,$conex);

 	$cont.='<table width="100%">
	          <thead>
	            <tr class="TituloTabla" style="display:block; padding-top:10px;height:28px;"> 
			     <td width="20"> </td>
				 <td width="170">  Fecha / Hora </td>			
			     <td width="400"> Evento </td>
			     <td width="150" align="center"> Usuario </td>
				 <td width="150"> Equipo </td>
				 <td width="100"> Direccion IP </td>
				 <td width="20"> </td>				 				 
			   </tr>
			 </thead>
			<tbody style="display:block; width:1050px; height:280px; overflow-Y:scroll">';	

    $i = 0;
    while($row = mysql_fetch_array($result)) 
	{
		 $i++;
	     
	     $momento2 = substr($row['momento'],8,2)."/".substr($row['momento'],5,2)."/".substr($row['momento'],0,4)." a las ".substr($row['momento'],11,2).":".substr($row['momento'],14,2);

		 if($i%2 == 0)
		   $cont.='<tr class="TablaDocsPar">';
		 else
		   $cont.='<tr class="TablaDocsImPar">';		 
		          
		 $cont.=' <td width="20"> </td>
				  <td width="170"> '.$momento2.' </td>
				  <td width="400"> '.$row['descripcion'].' </td>
				  <td width="150" align="center"> <b><i>'.$row['usuario'].'</i></b> </td>
				  <td width="150"> '.$row['equipo'].' </td>				  				  
				  <td width="100"> '.$row['direccionip'].' </td>				  				  
				  <td width="20"> &nbsp; </td></tr>';
	}

	$cont.='</tbody></table>';
	$cont.='<table width="100%">
	           <tr class="CabezoteTabla"> 
			     <td width="10"> </td>
			     <td width="37"> <img src="images/iconos/notas.png" width="32" height="32" border="0"> </td>
				 <td width="780"> <b>Reversiones al Documento </b> <td>				
			   </tr>	 			   
			 </table> ';	
			 
    /// Busco en el LOG de Auditoria los cambios al Documento
    $vsql = "SELECT * FROM logcambios WHERE valor = ".$docuid." ORDER BY momento DESC";
    $result = mysql_query($vsql,$conex);

 	$cont.='<table width="100%">
	          <thead>
	            <tr class="TituloTabla" style="display:block; padding-top:10px;height:28px;"> 
			     <td width="20"> </td>
				 <td width="250">  Fecha / Hora </td>			
			     <td width="500"> Motivo Digitado </td>
			     <td width="200" align="center"> Usuario Revers&oacute; </td>
				 <td width="20"> </td>				 				 				 
			   </tr>
			 </thead>
			<tbody style="display:block; width:1050px; height:220px; overflow-Y:scroll">';	
    $i = 0;
    while($row = mysql_fetch_array($result)) 
	{
		$i++;
	     
	     $momento2 = substr($row['momento'],8,2)."/".substr($row['momento'],5,2)."/".substr($row['momento'],0,4)." a las ".substr($row['momento'],11,2).":".substr($row['momento'],14,2);

		 if($i%2 == 0)
		   $cont.='<tr class="TablaDocsPar">';
		 else
		   $cont.='<tr class="TablaDocsImPar">';		 
		          
		 $cont.=' <td width="20"> </td>
				  <td width="250"> '.$momento2.' </td>
				  <td width="500"> '.$row['motivo'].' </td>
				  <td width="200" align="center"> <b><i>'.$row['creador'].'</i></b> </td>
				  <td width="20"> &nbsp; </td></tr>';
	}

	$cont.='</tbody></table>';	

  }

  /////////////////////////////////////////////////////////////////////////    
  /////////////////////////////////////////////////////////////////////////    
  if($opcion == "cargararchivo2")
  { 
    $docuid   = $_POST['docuid'];
    $tipodid = 7;
    $observ  = "DOCUMENTO ESCANEADO - SOPORTE DE LA FACTURA";

  	$nombre_archivo1 = $_FILES['narchivo']['name']; 
    $tipo_archivo1   = $_FILES['narchivo']['type']; 
    $tamano_archivo1 = $_FILES['narchivo']['size']; 
	 
    if($nombre_archivo1 != "")
    { 
        $destipo = $clase->BDLockup($tipodid,"tipodocudigital","tipodid","codigo"); 
        $aleatorio = rand(1111,9999);
        $nombrefinal1 = $docuid.'-'.$destipo.'-'.$aleatorio.'.'.substr($nombre_archivo1,(strlen($nombre_archivo1)-4),strlen($nombre_archivo1));

      if (move_uploaded_file($_FILES['narchivo']['tmp_name'],'media/docudigital/cargas/'.$nombrefinal1))
      {
            $vsql = "INSERT INTO archivodigital(tipoid,docuid1,filename,observacion,creador) VALUES(".$tipodid.",".$docuid.",'".$nombrefinal1."','".$observ."','".$_SESSION['USERNAME']."')";
            $clase->EjecutarSQL($vsql);	 
      }   
    }
	  //echo $nombre_archivo1; echo $vsql; exit;
  	$clase->Aviso(1,"Soporte Digitalizado asignado a la Factura de Compra Exitosamente");
    echo'<script language="javascript">
	   <!--
	      window.close();
		  window.opener.location.reload();
	   -->
	  </script>';
  }

  ////////////////////////////////////////////////////////////////////////////////        
  ////////////////////////////////////////////////////////////////////////////////    
  if($opcion == "exportarexcel")
  {
    $docuid = $_GET['docuid'];
	// Create new PHPExcel object
	$objPHPExcel = new PHPExcel();
	// Set document properties
	$objPHPExcel->getProperties()->setCreator("Dromedicas del Oriente SAS")
								 ->setLastModifiedBy("Dromedicas del Oriente SAS")
								 ->setTitle("Informe CLOSE UP - DROPOS")
								 ->setSubject("Informe CLOSE UP - DROPOS")
								 ->setDescription("Informe CLOSE UP - DROPOS")
								 ->setKeywords("Informe CLOSE UP - DROPOS")
								 ->setCategory("Todas las Droguerias");    
    $vsql = "SELECT DISTINCT D.tipodoc, D.prefijo, D.numero, D.fechadoc, GP.descripcion labo, P.descripcion produc, DD.valunitario, SUM( DD.unicom ) unicom, SUM( DD.unifra ) unifra, SUM( DD.valparcial ) valparcial
			 FROM documentos D INNER JOIN dedocumentos DD ON ( D.docuid = DD.docuid ) INNER JOIN productos P ON ( P.productoid = DD.productoid ) INNER JOIN gruposprod GP ON ( GP.gruposprodid = P.gruposprodid ) 
			 WHERE D.docuid = ".$docuid." GROUP BY 1 , 2, 3, 4, 5, 6, 7 ORDER BY GP.descripcion ASC , P.descripcion ASC";  	// Add some data
	$objPHPExcel->setActiveSheetIndex(0)
    	        ->setCellValue('A1', 'TIPODOC')
        	    ->setCellValue('B1', 'PREFIJO')
        	    ->setCellValue('C1', 'NUMERO')				
            	->setCellValue('D1', 'FECHA')
				->setCellValue('E1', 'LABORATORIO')
				->setCellValue('F1', 'PRODUCTO')
				->setCellValue('G1', 'VLR UNIT')				
				->setCellValue('H1', 'CAJAS')								
				->setCellValue('I1', 'UNIDADES')
				->setCellValue('J1', 'VLR PARCIAL');
    
	$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);				
	$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);					
	$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);				
	$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);					
	$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);						
	$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);						
	$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);						
	$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);						
	$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);						
	$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);						

	$conex  = $clase->Conectar();
    $result = mysql_query($vsql,$conex); 
	$cant   = mysql_num_rows($result);
    $i=2;
	while($row = mysql_fetch_array($result)) 
	{
	  $fecha = fechahumanos($row['fechadoc']);
	  
	  $objPHPExcel->setActiveSheetIndex(0)
   		          ->setCellValue('A'.$i, $row['tipodoc'])
   		          ->setCellValue('B'.$i, $row['prefijo'])
   	    	      ->setCellValue('C'.$i, $row['numero'])
   	    	      ->setCellValue('D'.$i, $row['fechadoc'])				  
   	      	      ->setCellValue('E'.$i, $row['labo'])
				  ->setCellValue('F'.$i, $row['produc'])
				  ->setCellValue('G'.$i, $row['valunitario'])				  
				  ->setCellValue('H'.$i, $row['unicom'])
				  ->setCellValue('I'.$i, $row['unifra'])
				  ->setCellValue('J'.$i, $row['valparcial']);
      $i++;
    }
    
	$rangoEncabezado = 'A1:J1';
	$rangoCeldas     = 'A2:J'.($cant+1);
	
    // Formato de Encabezado y Celdas
    $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
    
    $EstiloCeldas = array(
	'borders' => array(
		'allborders' => array(
			'style' => PHPExcel_Style_Border::BORDER_THIN,
			'color' => array('argb' => '00000000'),
		),
	  ),
     );
    $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
    /// Formato de Encabezados 
    $EstiloEncabezado = array(
	'font' => array(
		'bold' => true,
	),
	'alignment' => array(
		'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
		'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
	),
	'borders' => array(
		'allborders' => array(
			'style' => PHPExcel_Style_Border::BORDER_THIN,
			'color' => array('argb' => '00000000'),
		),
	),
	'fill' => array(
		'type' => PHPExcel_Style_Fill::FILL_SOLID,
		'rotation' => 90,
		'startcolor' => array(
			'argb' => '00FFFFCC',
		),
		'endcolor' => array(
			'argb' => 'FFFFFF',
		),
	  ),
    );
    $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);	
	// Rename worksheet
	$objPHPExcel->getActiveSheet()->setTitle('DocumentoExportadoExcel');
	// Set active sheet index to the first sheet, so Excel opens this as the first sheet
	$objPHPExcel->setActiveSheetIndex(0);
	// Redirect output to a client’s web browser (Excel5)
	header('Content-Type: application/vnd.ms-excel');
	header('Content-Disposition: attachment;filename="Exportado.xls"');
	header('Cache-Control: max-age=0');
    /// Genero la Salida
	$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
	$objWriter->save('php://output');
	exit;
  }		
  
  ////////////////////////////////////////////////////////////////////////////////        
  ////////////////////////////////////////////////////////////////////////////////    
  if($opcion == "cargararchivo")
  {
    $docuid = $_GET['docuid'];
    $compra = $clase->BDLockup($docuid,"documentos","docuid","CONCAT(tipodoc,prefijo,numero)");     
	echo' <form enctype="multipart/form-data" action="compras.php?opcion=cargararchivo2" method="POST" name="x">   
	        <input type="hidden" name="docuid" value="'.$docuid.'">
	         <table width="500" bgcolor="#819FF7"> 
	           <tr height="25">
				 <td align="center"> <br><br><h3>Cargar Archivo a <br> la Compra No. '.$compra.'</h3><br></td> 
			   </tr> <tr height="25"> 
				  <td align="center"> <input type="file" name="narchivo"> <br><br></td> 
			   </tr> <tr height="25"> 
			      <td align="center"> 
				     <input type="submit" value="Cargar Archivo" class="button red"> <br><br></td> 
			   </tr>
			</table></form>';
	exit();
  }			

  /////////////////////////////////////////////////////////////////////////////////////  
  /////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "digitalizar")
  {
	$docuid  = $_GET['docuid'];
    $cont    = $fechadoc.'<table width="400">
	           <tr class="CabezoteTabla"> 
				 <td align="center"> <b> Digitalizar Documento </b> <td> 
			   </tr> 
			</table>
		    <table width="400">
			  <tr class="TablaDocsImPar">
			    <td width="40" align="center"> <img src="images/basicas/imagenes.png" border="0"> </td> 
				<td width="360"><a href="#" onClick="window.open(\'tomarfoto/index.php\',\'Foto\',\'width=720,height=430\');"> 
					            <b> Digitalizar esta Compra </b></a></td></tr> 
			  <tr class="TablaDocsPar">
			    <td width="40" align="center"> <img src="images/basicas/guardar.png" border="0"> </td> 
				<td width="360"><a href="compras.php?opcion=cargarfoto&docuid='.$docuid.'"><b>Guardar Foto de la Compra</b></a></td> 
             </tr></table>'; 	
    echo $cont;	
    exit();
  }
  
  /////////////////////////////////////////////////////////////////////////    
  if($opcion == "cargarfoto")
  {
     $id = $_GET['docuid'];
     $compra = $clase->BDLockup($id,"documentos","docuid","CONCAT(tipodoc,prefijo,numero)");     
     copy('tomarfoto/images/'.$_SESSION['USERNAME'].'.jpg','media/docudigital/cargas/'.$compra.'.jpg');
	 $tipo = $clase->BDLockup("DOC","tipodocudigital","codigo","tipodid");     
     $vsql = "INSERT INTO archivodigital(tipoid,docuid1,filename,observacion,creador) VALUES(".$tipo.",".$docuid.",'".$compra.".jpg','DIGITALIZACION DEL DOCUMENTO','".$_SESSION['USERNAME']."')";
	 $clase->EjecutarSQL($vsql);
     $clase->Aviso(1,'Factura Digitalizada con Exito');	 	      
	 header('Location: compras.php?opcion=crear&docuid='.$id);
  } 
  
  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "pre-crear")
  {
    $tipodoc   = "FCO";
    $prefijo   = $_SESSION['G_PREF_FCO'];
	$numero    = $clase->SeleccionarUno("SELECT numero FROM consecutivos WHERE tipodoc ='".$tipodoc."' AND prefijo='".$prefijo."'");
	$periodo   = date("mY");
	$fechadoc  = date("Y-n-d");
	$fechanull = "0000-00-00";
	$sucursalid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid'); 
		
	$existe = $clase->SeleccionarUno("SELECT COUNT(*) FROM documentos WHERE tipodoc='".$tipodoc."' AND prefijo='".$prefijo."' AND numero='".$numero."'");
	
	if($existe == 0)
	{
	   //// Inserto el encabezado del Documento
	   $vsql = "INSERT INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecasentado,fecanulado,formapago,terid1,total,impreso,totalitems,sucursalid,creador,momento) VALUES('".
	           $tipodoc."','".$prefijo."','".$numero."','".$periodo."','".$fechadoc."','".$fechanull."','".$fechanull."','CO',1,0,'N',0,".$sucursalid.",'".
			   $_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";
	   $clase->EjecutarSQL($vsql);
	
	   /// Actualizo el Consecutivo al Siguiente
	   $numerosig = str_pad($numero + 1,5,0,STR_PAD_LEFT);
	   $clase->EjecutarSQL("UPDATE consecutivos SET numero='".$numerosig."' WHERE tipodoc='".$tipodoc."' AND prefijo='".$prefijo."'");
	
	   /// Busco el Maximo Docuid - El recien insertado
     $docuid = $clase->SeleccionarUno("SELECT MAX(docuid) FROM documentos WHERE tipodoc='".$tipodoc."' AND prefijo = '".$prefijo."' AND numero = '".$numero."' AND creador = '".$_SESSION['USERNAME']."'");
   	   
	   $vsql = "INSERT INTO docucompra(docuid) VALUES(".$docuid.")";
	   $clase->EjecutarSQL($vsql);

	   //// Registro en el Log la creacion 
       $clase->CrearLOG('004','Crea Factura de Compra '.$tipodoc.' '.$prefijo." ".$numero,strtoupper($_SESSION["USERNAME"]),'',$docuid);	   	   

	   header("Location: ?opcion=crear&docuid=".$docuid);
	}
	else
	{
	   $clase->Aviso(2,'Ya existe un Documento <b>'.$tipodoc.' '.$prefijo.' '.$numero.'</b> en el Sistema. Verifique el Consecutivo');
	   header("Location: compras.php");		 
	}  
  }

  ///////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "filtrar")
  {
      $prefijo      = $_POST['prefijo'];              $numero = $_POST['numero'];                 $numero2 = $_POST['numero2'];
      $fechadesde   = $_POST['fechadesde'];           $fd = $fechadesde;
      $fechahasta   = $_POST['fechahasta'];           $fh = $fechahasta;
      $cliente      = $_POST['cliente'];              $usuario      = $_POST['usuario'];          $sa = $_POST['soloabiertas'];

      // Nuevos criterios de filtro
      $estatus         = $_POST['estatus'];
      $formapago       = $_POST['formapago'];
      $ordercompraasoc = $_POST['ordercompraasoc'];

      /// Aplico los filtros digitados
      if(strlen($prefijo)>0)         $order.= " AND D.prefijo = '".$prefijo."' ";
      if(strlen($numero)>0)          $order.= " AND D.numero like '%".$numero."%' ";
      if(strlen($numero2)>0)         $order.= " AND D.nrodocref like '%".$numero2."%' ";	 
      if(strlen($fd)>0)     	       $order.= " AND D.fechadoc >= '".$fd." 00:00:00' ";
      if(strlen($fh)>0)     	       $order.= " AND D.fechadoc <= '".$fh." 23:59:59' ";
      if(strlen($cliente)>0)         $order.= " AND (T.nombres like '".$cliente."%' OR T.apellidos like '".$cliente."%') ";	 	 
      if(strlen($usuario)>0)         $order.= " AND D.creador = '".$usuario."' ";
      if(strlen($sa)>0)              $order.= " AND D.fecasentado = '0000-00-00'";	

      // Nuevas condiciones para el filtro de la consulta
      if($formapago=="CO")         $order.= " AND D.formapago = 'CO' ";  
      if($formapago=="CR")         $order.= " AND D.formapago = 'CR' ";
      if($estatus=="C")            $order.= " AND D.fecasentado <> '0000-00-00' ";
      if($estatus=="A")            $order.= " AND D.fecasentado = '0000-00-00' ";
      if($ordercompraasoc==on)     
          $order.= " AND D.docuid IN (SELECT ds.docuid FROM docuself ds WHERE ds.docuid = D.docuid) "; 
      else 
          $order.= " AND D.docuid NOT IN (SELECT ds.docuid FROM docuself ds WHERE ds.docuid = D.docuid) ";
        
      $vsql = "SELECT D.* , T.nombres , T.apellidos , S.descripcion codsucursal ,
                      (SELECT CONCAT(prefijo,' ',numero) 
                         FROM documentos OC 
                              INNER JOIN docuself DS ON (DS.docuid2 = OC.docuid) 
                        WHERE DS.docuid = D.docuid limit 0,1 ) orden , 
                      (SELECT codigo 
                         FROM sucursales 
                        WHERE sucursalid = D.sucursalid) sucursal 
                 FROM documentos D 
                      INNER JOIN sucursales S ON (D.sucursalid = S.sucursalid)
                      INNER JOIN terceros T ON (T.terid = D.terid1)
                WHERE D.tipodoc = 'FCO' ".$order."
             ORDER BY D.docuid ASC limit 0,1000";

      $_SESSION['SQL_COMPRAS'] = $vsql;
      header("Location: compras.php");
  }
  
  ///////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "filtro")
  {
    $fecha = date("Y-m-"); 
    $vsqlcombo1 = "SELECT bodegaid , nombodega FROM bodegas WHERE codbodega <> '00' ORDER BY nombodega ASC";			  	  
    $vsqlcombo2 = "SELECT bodegaid , nombodega FROM bodegas WHERE codbodega <> '00' ORDER BY nombodega ASC";			  	  	
    $params = ' class="Texto11" ';			  
	$cont=' <form action="?opcion=filtrar" method="POST" name="x">
	        <table width="400">
	           <tr class="CabezoteTabla"> 
				 <td align="center"> <b> Filtrar Busqueda de Documentos </b> <td> 
			   </tr> 
			</table>
		    <table width="400">
			  <tr class="TablaDocsImPar">				
				<td width="150" align="right"> Prefijo : &nbsp;</td> 			  
			    <td width="350"><input type="text" class="Texto11" name="prefijo" size="5" maxlenght="10" value="" style="text-transform:uppercase!Important;" autocomplete="off"></td>				
			  <tr class="TablaDocsImPar">				
				<td width="150" align="right"> Numero : &nbsp;</td> 			  
			    <td width="350"><input type="text" class="Texto11" name="numero" size="12" maxlenght="10" value="" style="text-transform:uppercase!Important;" autocomplete="off"></td>				
			  <tr class="TablaDocsImPar">				
				<td width="150" align="right"> Numero Prov: &nbsp;</td> 			  
			    <td width="350"><input type="text" class="Texto11" name="numero2" size="12" maxlenght="10" value="" style="text-transform:uppercase!Important;" autocomplete="off"> </td>				
			  <tr class="TablaDocsImPar">				
				<td width="150" align="right"> Fecha Desde : &nbsp;</td> 			  
			    <td width="350"><input type="date" class="Texto11" name="fechadesde" size="12" maxlenght="10" value="'.$fecha.'01"></td>				
			  <tr class="TablaDocsImPar">				
				<td width="150" align="right"> Fecha Hasta : &nbsp;</td> 			  
			    <td width="350"><input type="date" class="Texto11" name="fechahasta" size="12" maxlenght="10" value="'.$fecha.'30"></td>				
			  <tr class="TablaDocsImPar">				
				<td width="150" align="right"> Proveedor : &nbsp;</td> 			  
			    <td width="350"><input type="text" class="Texto11" name="cliente" size="30" maxlenght="30" value="" style="text-transform:uppercase!Important;" autocomplete="off"></td>				
              </tr>
			  <tr class="TablaDocsImPar">				
				<td width="150" align="right"> Username : &nbsp;</td> 			  
			    <td width="350"><input type="text" class="Texto11" name="usuario" size="30" maxlenght="30" value="" style="text-transform:uppercase!Important;" autocomplete="off"></td></tr>			
          <!--
			  <tr class="TablaDocsImPar">				
				<td width="150" align="right"> Opciones : &nbsp;</td> 			  
			    <td width="350"><input type="checkbox" class="Texto11" name="soloabiertas" value="CHECKED"> Solo Documentos Abiertos </td></tr>
          -->
          <!-- Nuevos filtros para la búsqueda avanzada -->
        <td align="right">Estatus:</td>
          <td><input type="radio" name="estatus" value="A">
                <label for="radio">Abiertas 
                  <input type="radio" name="estatus" value="C">
                Cerradas 
                <input type="radio" name="estatus" value="T" checked="checked" >
                Todas </label></td>
          </tr>
        <tr class="TablaDocsImPar">
          <td align="right">Forma de pago:</td>
          <td><input type="radio" name="formapago" value="CO">
                <label for="radio">Contado 
                  <input type="radio" name="formapago" value="CR">
                Crédito 
                <input name="formapago" type="radio" value="TD" checked="checked">
                Todas </label></td>
            </tr>
          <tr class="TablaDocsImPar">       
          <td width="150" align="right">&nbsp;</td>         
          <td width="350"><input type="checkbox" name="ordercompraasoc" checked="checked">
                <label for="checkbox">Con orden de compra asociada </label></td>
          <!-- -------------------------------------------- -->
	           </table><center>
	          <br><input type="submit" value="filtrar documentos" class="button red"></form><br><br>';				
    echo $cont;	
    exit();
  }

  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "agregaroc2")
  {
	  $docuid = $_GET['docuid'];   	  $ndocuid = $_GET['ndocuid'];
	  /// Asocio la Orden de Compra a la nueva compra creada
	  $vsql = "INSERT INTO docuself(docuid,docuid2) VALUES(".$docuid.",".$ndocuid.")";
	  $clase->EjecutarSQL($vsql); 
	  $clase->Aviso(1,"Orden de Compra Asociada con Exito");
	  header("Location: compras.php?opcion=crear&docuid=".$docuid);
  }

  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "validariva")
  {
	  $docuid = $_GET['docuid'];

      $vsql ="UPDATE dedocumentos SET valbase = (valtotal/((porciva/100)+1)) WHERE docuid=".$docuid; 
	  $clase->EjecutarSQL($vsql);      

	  $vsql = "SELECT SUM(valbase) FROM dedocumentos WHERE docuid=".$docuid;
	  $base = $clase->SeleccionarUno($vsql);

	  $vsql ="SELECT SUM(valiva) FROM dedocumentos WHERE docuid=".$docuid; 
	  $iva  = $clase->SeleccionarUno($vsql);
      
      $vsql ="UPDATE documentos SET base=".$base." , iva = ".$iva."WHERE docuid=".$docuid; 
	  $clase->EjecutarSQL($vsql);      

	  $clase->Aviso(1,"Impuestos y Retenciones recalculadas con Exito");
	  header("Location: compras.php");
  }

  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "agregaroc")
  {
    $docuid    = $_GET['docuid'];
	$terid     = $clase->BDLockup($docuid,'documentos','docuid','terid1');
	$numdocumento = $clase->SeleccionarUno("SELECT CONCAT(tipodoc,' ',prefijo,' ',numero) FROM documentos WHERE docuid=".$docuid);
    $cont='<table width="400">
	           <tr class="CabezoteTabla"> 
				 <td align="center"> Adicionar Ordenes de Compra a la <b>'.$numdocumento.'</b> <td> 
			   </tr> 
			</table>
		    <table width="400">';
	$vsql = "SELECT * FROM documentos WHERE tipodoc = 'PCO' AND terid1=".$terid." AND docuid NOT IN ( SELECT DISTINCT docuid2 FROM docuself ) ORDER BY fechadoc DESC";
   	$conex  = $clase->Conectar();
    $result = mysql_query($vsql,$conex);
	$registros = mysql_num_rows($result);
    $i = 0;
    while($row = mysql_fetch_array($result)) 
	{
      if($i%2 == 0)
	    $cont.='<tr class="TablaDocsImPar">';
	  else
		$cont.='<tr class="TablaDocsPar">';		 

      $cont.='<td width="20">&nbsp;</td>
	          <td width="150"><b>'.$row['tipodoc'].' '.$row['prefijo'].' '.$row['numero'].'</b></td>
	          <td width="100" align="center"><a href="reportes/imppedidopro.php?docuid='.$row['docuid'].'" target="_blank">Visualizar</a></td>
			  <td width="100" align="center"><a href="?opcion=agregaroc2&docuid='.$docuid.'&ndocuid='.$row['docuid'].'"><input type="button" value="Adicionar"></a></td>
			  </tr>';				
    }
	$cont.='</table><br>'; 
	if($registros == 0)
	   $cont.='<CENTER><B>No hay Ordenes de Compra Pendientes<br>para este cliente<br><br>';

    ///// Genero la informacion
	echo $cont;	
    exit();
  }

  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "recalcular")
  {
     $docuid = $_GET['docuid'];
     $clase->EjecutarSQL("CALL PA_CalValoresFCO(".$docuid.")");
     $clase->Aviso(1,"Totales de la Factura recalculados exitosamente");
     header("Location: compras.php");
  }

  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "regenerarteso")
  {
     $docuid = $_GET['docuid'];
     $sepuede = SePuedeReversar($docuid);
     if($sepuede == 1)
     {
         GenerarTesoreria($docuid);
         $clase->Aviso(1,"Documento Regenerado a Tesoreria con Exito");
     }
     else
         $clase->Aviso(2,"<b>Error</b> No se puede Regenerar porque ya se encuentra en un Egreso");  

     header("Location: compras.php");
  }

    //////////////////////////////////////////////////////////////////////////////////////////////////////  
  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "regenerarteso2")
  {
     $docuid = $_GET['docuid'];
     $sepuede = SePuedeReversar($docuid);
     if($sepuede == 1)
     {
         GenerarTesoreria($docuid);
         $clase->Aviso(1,"Documento Regenerado a Tesoreria con Exito");
     }
     else
         $clase->Aviso(2,"<b>Error</b> No se puede Regenerar porque ya se encuentra en un Egreso");  

     header("Location: repauditoria.php?opcion=aud_tesoreria");
  }
  
  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "estadoproductos")
  {
     $docuid = $_GET['docuid'];
     header("Location: reportes/impevolucionprocompras.php?docuid=".$docuid);
  }  

   //////////////////////////////////////////////////////////////////////////////////////////////////////  
  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "consignacion")
  {
     $docuid = $_GET['docuid'];
     $vsql ="UPDATE documentos SET observacion2 = 'CONSIGNACION' WHERE docuid=".$docuid; 
     $clase->EjecutarSQL($vsql);  
     $clase->Aviso(1,"Compra marcada como consignacion");    
     header("Location: compras.php");
  }


  //////////////////////////////////////////////////////////////////////////////////////////////////////    
  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "menu")
  {
        $docuid       = $_GET['id'];
        $numoco       = $_GET['numoco'];
    	  $documento    = $clase->SeleccionarUno("SELECT CONCAT(tipodoc,prefijo,numero) FROM documentos WHERE docuid=".$docuid);
    	  $numdocumento = $clase->SeleccionarUno("SELECT CONCAT(tipodoc,' ',prefijo,' ',numero) FROM documentos WHERE docuid=".$docuid);
        $foto1        = $clase->BDLockup($docuid,"archivodigital","docuid1","filename"); 
        $consignacion = $clase->BDLockup($docuid,"documentos","docuid","observacion2");
        $fecasentado  = $clase->BDLockup($docuid,"documentos","docuid","fecasentado"); 
        
        $final='(Compra NO Marcada)' ;
        $color = '<font color="red">';
        if($consignacion=='CONSIGNACION'){
          $final = '(Compra Marcada)';
          $color = '<font color="green">';
        }

        $tienenota  = 0;
        $tienenota += $clase->SeleccionarUno("SELECT SUM(dcto3+dcto4) FROM docucompra WHERE docuid=".$docuid); 
        $tienenota += $clase->SeleccionarUno("SELECT SUM(DDO.dctol3+DDO.dctol4) FROM dedocumentos DD INNER JOIN dedocuorden DDO ON (DD.dedocumid = DDO.dedocumid) WHERE DD.docuid=".$docuid); 

        $cont='<table width="400">
    	           <tr class="CabezoteTabla"> 
    				 <td align="center"> Opciones del Documento <b>'.$numdocumento.'</b> <td> 
    			   </tr> 
    			</table>
    		    <table width="400">
    			  <tr class="TablaDocsImPar" style="height:25px;!Important">				
    				<td width="40" align="center"> <img src="images/basicas/pdf.png" border="0"> </td> 			  
    			    <td width="360"> <a href="reportes/impcompras.php?docuid='.$docuid.'" target="_blank"> Vista Previa en PDF </a></td>				
    			  </tr>
    			  <tr class="TablaDocsPar" style="height:25px;!Important">				
    				<td width="40" align="center"> <img src="images/basicas/print.png" border="0"> </td> 			  
    			    <td width="360"> <a href="reportes/impcomprapos.php?docuid='.$docuid.'"> Impresion POS </a></td>				
    			  </tr><tr class="TablaDocsImPar" style="height:25px;!Important">				    
    				<td width="40" align="center"> <img src="images/basicas/kardex.png" border="0"> </td> 
    				<td width="360"> <B><a href="?opcion=kardexlocal&docuid='.$docuid.'">Ver Kardex Local</a></td> 
    			  <tr class="TablaDocsPar" style="height:25px;!Important">				
    				<td width="40" align="center"> <img src="images/basicas/asentado.png" border="0"> </td> 			  
    			    <td width="360"> <a href="?opcion=recalcosto&docuid='.$docuid.'"> Recalcular costos de la Compra </a></td>				
                  </tr>';
            
            if($fecansentado != "0000-00-00")      
            {
                $cont.='<tr class="TablaDocsImPar" style="height:25px;!Important">
                          <td width="40" align="center"> <img src="images/basicas/regenerar.png" border="0"> </td> 
                          <td width="360"> <a href="?opcion=regenerar&docuid='.$docuid.'"> Regenerar Movimiento de Inventario</td>
                        </tr>';
            }
    	          
    $cont.='<tr class="TablaDocsPar" style="height:25px;!Important">
    			    <td width="40" align="center"> <img src="images/basicas/duplicar.png" border="0"> </td> 
    				<td width="360"> <a href="?opcion=duplicar&docuid='.$docuid.'"> Duplicar Documento </td>
    			  </tr>
    			  <tr class="TablaDocsImPar" style="height:25px;!Important">				
    				<td width="40" align="center"> <img src="images/basicas/diferencias.png" border="0"> </td> 			  
    			    <td width="360"> <a href="?opcion=pre-asentar&docuid='.$docuid.'"> Diferencias con Orden de Compra </a></td>				
                  </tr>
               	  <tr class="TablaDocsPar" style="height:25px;!Important">				
    				<td width="40" align="center"> <img src="images/basicas/excel.png" border="0"> </td> 			  
    			    <td width="360"> <a href="?opcion=exportarexcel&docuid='.$docuid.'"> Exportar Documento a Excel </a></td>				
                  </tr>
                  <tr class="TablaDocsImPar" style="height:25px;!Important">				
    				<td width="40" align="center"> <img src="images/basicas/validar.png" border="0"> </td> 			  
    			    <td width="360"> <a href="?opcion=validariva&docuid='.$docuid.'"> Validar Impuestos y Retenciones </a></td>				
                  </tr>
                  <tr class="TablaDocsPar" style="height:25px;!Important">				    
    				  <td width="40" align="center"> <img src="images/basicas/asentado.png" border="0"> </td> 
     				  <td width"360"> <a href="?opcion=logactividades&docuid='.$docuid.'"> LOG de Actividades del Documento </a></td>
                  </tr>
                  <tr class="TablaDocsImPar" style="height:25px;!Important">				
    				<td width="40" align="center"> <img src="images/basicas/regenerar.png" border="0"> </td> 			  
    			    <td width="360"> <a href="?opcion=regenerarteso&docuid='.$docuid.'"> Regenerar Documento a Tesoreria </a></td>				
                  </tr>
                  <tr class="TablaDocsPar" style="height:25px;!Important">				
    				<td width="40" align="center"> <img src="images/basicas/porproducto.png" border="0"> </td> 			  
    			    <td width="360"> <a href="?opcion=estadoproductos&docuid='.$docuid.'" target="_blank"> Evoluci&oacute;n de Productos </a></td>				
            </tr>
            <tr class="TablaDocsImPar" style="height:25px;!Important">           
              <td width="40" align="center"> <img src="images/basicas/pdf.png" border="0"> </td> 
              <td width="360"> <a href="compras.php?opcion=diferenciaspdf&docuid='.$docuid.'&numoco='.$numoco.'" target="_blank"> <b>Ver Diferencias PDF</B> </a></td></tr>
            <tr class="TablaDocsPar" style="height:25px;!Important">           
              <td width="40" align="center"> <img src="images/basicas/rayo.png" border="0"> </td> 
              <td width="360"> <a href="#" OnClick="window.open(\'pedidopro.php?opcion=vectorizador&docuid='.$docuid.'\',\'Vectoriz\',\'left=100,top=100,width=1000,height=900\');">
                <b>Plan de Vectorizaci&oacute;n de Productos</B> </a></td></tr>  
           ';
    			
          //// Permite Regenerar las Notas Credito de las Compras
          if($tienenota>0)
          {         
            $cont.='<tr class="TablaDocsImPar" style="height:25px;!Important"> <td width="40" align="center"> <img src="images/basicas/rayo.png" border="0"> </td>         
                  <td width="360"> <a href="compras.php?opcion=regenerarnotasdb&docuid='.$docuid.'"> Regenerar Notas Debito x Descuentos </a> <font color="red">(Tiene Dctos Notas DB)</font> </td> </tr>';
          }

        	if($foto1 != "")
        	{ 		  	
            //// Cargo la imagen predeterminada
            $escaneado = $clase->SeleccionarUno("SELECT filename FROM archivodigital WHERE docuid1 = ".$docuid);
            if($escaneado == "")    $escaneado = "nofoto.png";

            $cont.='<tr class="TablaDocsPar" style="height:25px;!Important">				
        				<td width="40" align="center"> <img src="images/basicas/imagenes.png" border="0"> </td> 			  
                  <td width="360"> <a href="media/docudigital/cargas/'.$escaneado.'" target="_blank"> Ver Documento Digitalizado </a></td>				
                      </tr>';
        	}
        	else
        	{ 		  	
         	  $cont.='<tr class="TablaDocsPar" style="height:25px;!Important">				
        				<td width="40" align="center"> <img src="images/basicas/rayo.png" border="0"> </td> 			  
        			    <td width="360"> <a href="#" OnClick="window.open(\'compras.php?opcion=cargararchivo&docuid='.$docuid.'\',\'Cargar\',\'width=550,height=320\');"> Cargar documento Digitalizado </a></td>				
                      </tr>';
        	}		  

        	  $cont.='<tr class="TablaDocsImPar" style="height:25px;!Important">				
        				<td width="40" align="center"> <img src="images/basicas/asentado.png" border="0"> </td> 			  
        			    <td width="360"> <a href="compras.php?opcion=recalcular&docuid='.$docuid.'"> Recalcular Totales e Impuestos de la Factura de Compra</a></td></tr>';
          
          if($_SESSION['SUPERUSUARIO'] == "CHECKED")
          {
            $cont.='<tr class="TablaDocsPar" style="height:25px;!Important">				
                <td width="40" align="center"> <img src="images/basicas/rayo.png" border="0"> </td> 
                <td width="360"> <a href="compras.php?opcion=enviaraservidorprincipal&docuid='.$docuid.'"> ReEnviar a Servidor Principal </a></td></tr>';
          }

            if($_SESSION['USERNAME'] == "ADMIN")			    
            {
              $cont.='<tr class="TablaDocsPar" style="height:25px;!Important">				
        				<td width="40" align="center"> <img src="images/basicas/duplicar.png" border="0"> </td> 			  
        			    <td width="360"> <a href="compras.php?opcion=copiaraservidor&docuid='.$docuid.'" target="_blank"> <b>Copiar este documento al Servidor</b> </a></td></tr>';
            }	
        

      $cont.='<tr class="TablaDocsPar" style="height:25px;!Important">       
                  <td width="40" align="center"> <img src="images/basicas/cotizar.png" border="0"> </td>         
                  <td width="360"> <a href="compras.php?opcion=analisiscosto&docuid='.$docuid.'" target = "_blank"> <b> Ver An&aacute;lisis de Costos </b> </a> </td></tr>
              <tr class="TablaDocsImPar" style="height:25px;!Important">       
                  <td width="40" align="center"> <img src="images/basicas/tns.png" border="0"> </td>         
                  <td width="360"> <a href="compras.php?opcion=regenerartnsfco&docuid='.$docuid.'"> <b>Enviar Compra a TNS </b> </a></td></tr>
              <tr class="TablaDocsPar" style="height:25px;!Important">       
                  <td width="40" align="center"> <img src="images/basicas/rayo.png" border="0"> </td>         
                  <td width="360"> <a href="compras.php?opcion=generarTRB&docuid='.$docuid.'" target = "_blank"> Generar Remisi&oacute;n TRB REM desde Factura de Compra </a> </td></tr>
              <tr class="TablaDocsPar" style="height:25px;!Important">       
                  <td width="40" align="center"> <img src="images/basicas/actualizar.png" border="0"> </td> 
                  <td width="360"> <a href="compras.php?opcion=regenerarcod&docuid='.$docuid.'"> Regenerar la Transferencia COD </a></td></tr>';

      if($_SESSION["SUPERUSUARIO"]=='CHECKED' ){
        $cont.=' 
                <tr class="TablaDocsPar" style="height:25px;!Important">				
                  <td width="40" align="center"> <img src="images/basicas/ok.png" border="0"> </td> 			  
                  <td width="360"> <a href="?opcion=consignacion&docuid='.$docuid.'"> Mercanc&iacute;a a Consignaci&oacute;n </a><b> '.$color.$final.'</font></b></td>				
                </tr>	';
      }
              
               
      	$cont.='</table><br>';     
      	echo $cont; exit();
  }
  
  /////////////////////////////////////////////////////////////////////////////  
  if($opcion == "kardexlocal")
  {
     $docuid    = $_GET['docuid'];
   $documento = $clase->SeleccionarUno("SELECT CONCAT(tipodoc,prefijo,numero) FROM documentos WHERE docuid=".$docuid);

   $cont = $clase->Header("S","W");  
   $cont.='<table width="100%">
             <tr class="CabezoteTabla"> 
           <td width="10"> </td>
           <td width="37"> <img src="images/iconos/transferencias.png" width="32" height="32" border="0"> </td>
         <td width="780"> <b>Detalle de Movimiento Kardex </b> - Documento No. <b>'.$documento.'</b><td>
         <td><a href="transferencias.php"><input type="submit" value="<< Transferencias" class="button blue"></a></td>
         </tr>           
       </table> ';  
       
     $vsql = "SELECT K.fechadoc , K.tipodoc , K.prefijo , K.numero , TD.tipomovin , P.descripcion , B.nombodega , P.factor1 , P.codigo , SUM(K.cantidad) cantidad
        FROM kardex K INNER JOIN bodegas B ON (K.bodegaid = B.bodegaid) 
        INNER JOIN tipodoc TD ON (TD.codigo = K.tipodoc)
        INNER JOIN productos P ON (P.productoid = K.productoid)
        WHERE CONCAT(K.tipodoc,K.prefijo,K.numero) ='".$documento."' 
        GROUP BY 1,2,3,4,5,6,7,8,9
        ORDER BY P.descripcion ASC , cantidad ASC";

    $conex  = $clase->Conectar();
    $result = mysql_query($vsql,$conex);

  $cont.='<div style="overflow:auto; height:680px;width:1050px;">
            <script type="text/javascript" src="lib/sorttable.js"></script>
            <table width="100%" class="sortable">
             <tr class="TituloTabla"> 
           <td width="20"> </td>
         <td width="90">  Fecha </td>     
           <td width="110"> Documento </td>
           <td width="50" align="center"> Tipo </td>
         <td width="50" align="right"> Cajas </td>
         <td width="50" align="right"> Unids </td>
         <td width="20"> </td>                          
         <td width="100"> Cod Barra </td>
         <td width="250"> Producto </td>                             
         <td width="120"> Bodega </td>                     
         <td width="30"> </td>                 
         </tr>';  
    $i = 0;
    while($row = mysql_fetch_array($result)) 
  {
     $i++;
  
       if(abs($row['cantidad']) == 0){
          $cajas = 0;     $unidades = 0;
         }
       else
       {
           $partescanti = explode(".",$row['cantidad']);
           $cajas       = $partescanti[0];      
           $decimal     = (round($row['cantidad'],10)-$cajas);
             $unidades    =  number_format(round(($decimal*$row['factor1']),0),0);  
           if(($unidades == $empaque)&&($unidades!=0)){ 
             $cajas++;
             $unidades=0;
       }     
        }

     if($row['cantidad'] > 0) { $tipomov = '<font color="blue"> ENTRADA</font>';   $color = '<font color="blue">';  }
     if($row['cantidad'] < 0) { $tipomov = '<font color="red"> SALIDA </font>';    $color = '<font color="red">';   }
     
     if($i%2 == 0)
       $cont.='<tr class="TablaDocsPar">';
     else
       $cont.='<tr class="TablaDocsImPar">';     
              
     $cont.=' <td width="20"> </td>
          <td width="90"> '.fechahumanos($row['fechadoc']).' </td>
          <td width="110"> '.$row['tipodoc'].' '.$row['prefijo'].' '.$row['numero'].'</td>
          <td width="50" align="center"> <b><i>'.$tipomov.'</i></b> </td>
          <td width="50" align="right"> <b>'.number_format($cajas).'</b> </td>                    
          <td width="50" align="right"> <b>'.number_format($unidades).'</b> </td>                   
          <td width="20"> </td>                                   
          <td width="100"> '.substr($row['codigo'],0,36).' </td>
          <td width="250"> '.substr($row['descripcion'],0,36).' </td>   
          <td width="150"> <b> '.$color.$row['nombodega'].' </b> </td>                    
          <td width="30"> </td></tr>';
  }
  $cont.='</table>';      
    mysql_free_result($result); 
    mysql_close($conex);        
  }
  

  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "pre-reversar2")
  {
     $docuid  = $_POST['docuid'];      $motivo  = $_POST['motivo'];
	 if(strlen($motivo)>8)
	 {
		$vsql = "INSERT INTO logcambios(tabla,campo,valor,motivo,creador,momento) values('documentos','docuid',".$docuid.",'".$motivo."','".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";
		$clase->EjecutarSQL($vsql);
		header("Location: ?opcion=reversar&docuid=".$docuid);	 
	 }
	 else
	 {
	    $clase->Aviso(2,"<b>ERROR :</b> El motivo es incorrecto");
		header("Location: compras.php");
	 }    
  }
  
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "pre-reversar")
  {
     $docuid  = $_GET['docuid'];

     $permitido = SePuedeReversar($docuid);

     if($permitido == 1)
     {
         $cont='<form action="?opcion=pre-reversar2" method="POST">
    	           <input type="hidden" name="docuid" value="'.$docuid.'">
    			         <table width="400">
    	              <tr class="CabezoteTabla"> 
    				          <td align="center"> <b> Digite el Motivo</b> <td> 
    			          </tr> 
    	              <tr class="CabezoteTabla"> 
    				          <td align="center"> <textarea name="motivo" cols="50" rows="5"></textarea>  <td> 
    			          </tr> 
    	              <tr class="CabezoteTabla"> 
    				          <td align="center"> <input type="submit" value="Guardar y Continuar" class="button">  <td> 
    			         </tr>
    			      </table></form>';				
    	    echo $cont ;  exit();
     } 
     else
     {
         $cont=' <table width="400">
                    <tr class="CabezoteTabla"> 
                      <td align="center"> <b> ERROR </b> Esta Factura se Encuentra relacionada para Pago. </td> 
                    </tr></table>';       
         echo $cont ;  exit();
     } 
  }
  

  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "reversarlibre")
  {
      $docuid  = $_GET['docuid'];
      /// Reverso el Costo     
      CostoReversarCompra($docuid);

      /// Elimino las notas si las hay
      EliminarNotasDebito($docuid);
      
      //// Reverso el Documento
      $fecha   = "0000-00-00"; 
      $clase->EjecutarSQL("UPDATE documentos SET fecasentado = '".$fecha."' WHERE docuid=".$docuid);
  }   

  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "reversar")
  {
     ini_set("memory_limit","200M");
  	 $docuid  = $_GET['docuid'];
  	 $fecha   = "0000-00-00"; 
     
     //// Valido que el Documento no sea de mas de 2 años y si es asi - Aborta Transaccion
     $anocontrol = (date("Y")-1);
     $fechacontrol = $anocontrol."-01-01";
     $vsql = "SELECT DATEDIFF(fechadoc,'".$fechacontrol."') FROM documentos WHERE docuid = ".$docuid;
     $dias = $clase->SeleccionarUno($vsql);
     if($dias<0)
     {
        echo'<script language="javascript">
              <!--
                 alert("Fecha NO Permitida para realizar esta transaccion");
                 document.location.href = "compras.php";
               -->
             </script>';
        exit;
     } 

     //// Verifico si el Usuario tiene permiso para Reversar Antes de hacer el proceso
     $reversar = $clase->GetPermiso("FACTURAS DE COMPRAS",$_SESSION['USERNAME'],"reversar");
     if($reversar == "")
     {
        $clase->Aviso(2,'<b>Error : </b> No tiene permisos para Reversar Compras');
        header("Location: transferencias.php");
        exit;
     }   

     /// Busco los Campos requeridos para validar
     $errores   = 0;
     $formapago = $clase->BDLockup($docuid,"documentos","docuid","formapago");
     $nrodocref = $clase->BDLockup($docuid,"documentos","docuid","nrodocref");
     $numdoc    = $clase->BDLockup($docuid,"documentos","docuid","CONCAT(tipodoc,prefijo,numero)");
     
     /// Periodo del Documento
     $vsql = "SELECT bloqcompras FROM periodos P INNER JOIN documentos D ON (D.periodo = P.codperiodo) WHERE D.docuid=".$docuid;
     $bloqueado = $clase->SeleccionarUno($vsql);
     if($bloqueado == "")
     {
         if($errores == 0)
         {
           /// Reverso el Costo     
           CostoReversarCompra($docuid);

           /// Elimino las notas si las hay
           EliminarNotasDebito($docuid);
           
           /// Reverso la compra en TNS
           ////QUITARCompraTNS($docuid);
         
           //// Reverso el Documento
           $clase->EjecutarSQL("UPDATE documentos SET fecasentado = '".$fecha."' , sincronizado = '0000-00-00' WHERE docuid=".$docuid);

           //// Envío el Correo de Notificacion
           $plantilla = "";                                                      
           $ruta = "recursos/html/cambiopreciofco.html";
           $fp = fopen($ruta,"r");     
           while ($linea= fgets($fp,2048))
             $plantilla.= $linea;
           
           /// Extraigo la Informacion
           $factura     = $clase->BDLockup($docuid,"documentos","docuid","CONCAT(tipodoc,' ',prefijo,' ',numero)");
           $usuario     = $_SESSION['USERNAME'];
           $momento     = date("d/m/Y H:i:s");   
          
           /// Reemplazo los campos  
           $plantilla = str_replace("#{USUARIO}" , $usuario , $plantilla); 
           $plantilla = str_replace("#{FACTURA}", $factura , $plantilla );                 
           $plantilla = str_replace("#{MOMENTO}" , $momento, $plantilla);
           $plantilla = str_replace("#{TRANSACCION}", $docuid, $plantilla);                

           require 'lib/PHPMailer/PHPMailerAutoload.php';
           $mail = new PHPMailer;
           $mail->isSMTP();
           $mail->SMTPDebug = 0;
           if($_SESSION['G_TIPOCORREO'] == "HTML")
              $mail->Debugoutput = 'html'; 
            
            $mail->Host = $_SESSION['G_HOSTCORREO'];
            $mail->Port = 587;
            $mail->SMTPSecure = 'tls';
            $mail->SMTPAuth = true;
            $mail->Timeout=20;
            $mail->CharSet = 'UTF-8';
            $mail->Username = $_SESSION['G_USERCORREO'];
            $mail->Password = $_SESSION['G_CLAVECORREO'];
           $mail->setFrom('sistemas@dromedicas.com.co', 'DROPOS ERP Notificaciones');
           $mail->addReplyTo('sistemas@dromedicas.com.co', 'DROPOS ERP Notificaciones');
           
           $mail->addAddress("johnduran@dromedicas.com.co", "Gerencia Dromedicas");
           $mail->addAddress("contabilidad@dromedicas.com.co", "Contabilidad Dromedicas");
           //$mail->addAddress("sistemas@dromedicas.com.co", "Sistemas Dromedicas");
           
           $mail->Subject = 'Reversion de Facturas de Compra';
           
           $mail->isHTML(true);       
           $mail->Body = $plantilla;
           $mail->send();
         } 

         /// Reverso el Documento
         $clase->Aviso(1,'Documento Abierto Exitosamente');   
         header("Location: compras.php?opcion=crear&docuid=".$docuid);
     }
     else
     {
     	$clase->Aviso(2,'<b>Error</b> El Periodo se encuentra Bloqueado!');
     	header("Location: compras.php");
     }
   }

  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "pre-asentar")
  {
	 $docuid    = $_GET['docuid'];
   $teridprov = $clase->BDLockup($docuid,'documentos','docuid','terid1');  
   $numcompra = $clase->BDLockup($docuid,'documentos','docuid','CONCAT(prefijo,numero)');  
	 $nrodocref = $clase->BDLockup($docuid,'documentos','docuid','nrodocref');
   /*
   /// Valido si está Asentado lo redireccione 
   $fecasentado = $clase->BDLockup($docuid,"documentos","docuid","fecasentado"); 
   if($fecasentado != "0000-00-00")
   {
      $clase->Aviso(3,"Documento se encuentra Cerrado");
      header("Location: compras.php");
      exit();
   } 
*/
   //// Actualizo la Retencion en la Fuente
   refrescarRetefuente($docuid);

   //// No asentar Factura con el Tercero Varios
   if($teridprov <= 3)
   {
        echo'<script language="javascript">
            <!--
              alert("No puede Asentar la Factura con ese Proveedor. Por favor seleccione otro");
              document.location.href = "compras.php?opcion=crear&docuid='.$docuid.'";
             -->
           </script>';
   }  

   //// No asentar Factura sin el Numero del Proveedor
	 if(strlen($nrodocref) == 0)
	 {
        echo'<script language="javascript">
     	      <!--
     	        alert("Debe Digitar Numero Compra Proveedor");
     	        document.location.href = "compras.php?opcion=crear&docuid='.$docuid.'";
     	       -->
     	     </script>';
	 }	
   
   
   ///Actualizo los OBSEQUIOS al campo Unidades para que ingrese al inventario estas cantidades
   $vsql = "SELECT DD.dedocumid , COALESCE(DC.obsequio,0) obsequio , COALESCE(DD.cantidad,0) cantidad FROM dedocumentos DD LEFT JOIN dedocuorden DC ON (DD.dedocumid = DC.dedocumid) WHERE DD.docuid =".$docuid;  	
   $conex  = $clase->Conectar();
   $result = mysql_query($vsql,$conex);	
   while($row = mysql_fetch_array($result)) 
   {
       $totalx = ($row['cantidad']+$row['obsequio']);
       $clase->EjecutarSQL("UPDATE dedocumentos SET unidades = ".$totalx." WHERE dedocumid=".$row['dedocumid']);
   }

   /// Suspendo el Control de Precios al Asentar la FCO - Dividir Orden de Compra
	 $vsqlx = "SELECT CONCAT(prefijo,numero) FROM documentos D INNER JOIN docuself DS ON (D.docuid = DS.docuid2) WHERE DS.docuid =".$docuid." limit 0,1";
	 $numoc = $clase->SeleccionarUno($vsqlx);
	 $control1 = ValidarProductosCostoBajo($docuid);
   if(strlen($control1) > 0)
   {	
     	echo'<script language="javascript">
     	      <!--
     	        alert("'.$control1.'");
     	        document.location.href = "compras.php?opcion=crear&docuid='.$docuid.'";
     	       -->
     	     </script>';
   }   

	 $valcom = $clase->BDLockup($docuid,'documentos','docuid','total');
	 $valoco = $clase->SeleccionarUno("SELECT total FROM documentos D INNER JOIN docuself DS ON (D.docuid = DS.docuid2) WHERE DS.docuid =".$docuid." limit 0,1");	 
	 $creadoroc = $clase->SeleccionarUno("SELECT creador FROM documentos D INNER JOIN docuself DS ON (D.docuid = DS.docuid2) WHERE DS.docuid =".$docuid." limit 0,1");	 
	 $diferencia = $valcom-$valoco;

	 //// Si es una remision - Evalua las diferencias sino No 
	 $cont = $clase->Header("S","W");	 
	 $cont.='<table width="100%">
	           <tr class="CabezoteTabla"> 
			     <td width="10"> </td>
			     <td width="37"> <img src="images/iconos/compras.png" width="32" height="32" border="0"> </td>
				 <td width="200"> <b> Diferencias</b> <td>
				 <td width="200"> Fact Compra <br><b> <a href="reportes/impcompras.php?docuid='.$docuid.'" target="_blank"> <font color="blue">'.$numcompra.'</b></a></td>        
         <td width="200"> Orden Compra <br><b> <a href="productos.php?opcion=link&nrodoc=PCO'.trim($numoc).'" target="_blank"> <font color="blue">'.$numoc.'</b></a></td>				 
				 <td width="200"> Creador :  <br> <font color="blue">'.$creadoroc.' </td>	
				 <td width="120" align="right"> Vlr Orden C.<br><b> '.number_format($valoco).'</b> <td>
				 <td width="120" align="right"> Vlr Compra <br><b> '.number_format($valcom).'</b> <td>
				 <td width="120" align="right"> Diferencia<br><b><font color="red">'.number_format($diferencia).'</b> <td>';
	    
		if($opcion == "pre-asentar")			 
		   $cont.='<td width="60" align="center"><a href="javascript:history.back();"><input type="button" class="button" value="<<"></a> </td>
		           <td width="50" align="center"><a href="compras.php"><input type="button" class="button blue" value="Compras"></a> </td>'; 
			
		$cont.='<td width="10">&nbsp;</td>				 
			    </tr></table>  
			   <script type="text/javascript">// <![CDATA[
        function preloader(){
            document.getElementById("loading").style.display = "none";
            document.getElementById("zoliframe").style.display = "block";
        }//preloader
        window.onload = preloader;
		// ]]></script>
    	<style>
         div#zoliframe {
         display: none;
        }
        div#loading {
        top: 500 px;
        margin: auto;
        position:relative;
        z-index: 1000;
        width: 500px;
        height: 128px;
        cursor: wait;
      }
    </style>
	<div id="loading"> <center><br><br><br><h3>Procesando Informacion .... </h3>
	                   <br><img src="images/basicas/loading.gif" border="0"><br><br><br><br>
					   Por favor espere mientras el sistema calcula las diferencias ... <br><br></div>
    <div id="zoliframe">
	<iframe id="miiframe" onload="displayTest();" src="compras.php?opcion=listadiferencias&docuid='.$docuid.'&numoco='.$numoc.'" frameborder="0" scrollbars="auto" width="100%" height="740"></iframe></div>';
    echo $cont; exit();				            
  }
  
  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "listadiferencias")
  {
     ini_set("memory_limit","300M");
     set_time_limit(0);

	   $docuid = $_GET['docuid'];
     $numoco = $_GET['numoco'];	 
     $boton  = $_GET['boton'];	 
  
     $titulo1.= $clase->HeaderBlanco($titulo);
	 
	 $conex   = $clase->Conectar();
     $result  = mysql_query($vsql,$conex);	
	 
	 //// Busco todas las Ordenes de Compra que se relacionan con esta compra
	 $vsql = "SELECT * FROM docuself WHERE docuid = ".$docuid;
	 $conex  = $clase->Conectar();
	 $result = mysql_query($vsql,$conex);	
     $canordenes = mysql_num_rows($result);
	 $listaordenes = "";
	 while($row = mysql_fetch_array($result))  
     {
	      if($i>0)
		    $listaordenes.= ",";
			
		  $listaordenes.= $row['docuid2'];
		  $i++;
	 }	 
	 
	 ///// /////// Productos Iguales		   
   ///// Diferencias en el Producto en Cantidad y Precio
 	 $vsql = "SELECT DISTINCT P.productoid, C.prefijo , C.numero , C.nrodocref , OC.prefijo , OC.numero , P.codigo, P.descripcion, P.factor1 , 
	          DC.cantidad CanCom, (DOC.cantidad+DDOX.obsequio) CanOrd, ((DC.valunitario*DC.cantidad)/(DC.cantidad+DDOX.obsequio)) ValCom, DOC.valunitario ValOrd 
			      FROM documentos C INNER JOIN dedocumentos DC ON ( C.docuid = DC.docuid ) 
            LEFT JOIN dedocuorden DDOX ON (DDOX.dedocumid = DC.dedocumid)
			      INNER JOIN productos P ON ( P.productoid = DC.productoid ) 
			      INNER JOIN docuself DS ON (DS.docuid = C.docuid) INNER JOIN documentos OC ON ( OC.docuid = DS.docuid2 )  
			      INNER JOIN dedocumentos DOC ON ( OC.docuid = DOC.docuid AND DOC.productoid = DC.productoid) 
            WHERE C.docuid =".$docuid." ORDER BY P.descripcion ASC ";  			  

	 $conex  = $clase->Conectar();
	 $result = mysql_query($vsql,$conex);	
     $reg1   = mysql_num_rows($result);
	 if($reg1)
	 {	
	 $parte0 ='<link rel="stylesheet" href="css/estiloadministrativos.css" type="text/css">
	           <table class="TablaDocsImPar" width="100%"><td align="center"><FONT COLOR="BLUE"><b>DIFERENCIAS EN PRECIOS DE ORDEN VS COMPRA</td>
                 <td width="50"> <a href="compras.php?opcion=diferenciaspdf&docuid='.$docuid."&numoco=".$numoco.'" target="_blank"> 
                  <input type="button" class="button" value="En pdf"> </a>   
	           </tr></table>';
	 $parte0.='<script type="text/javascript" src="lib/sorttable.js"></script>
	           <table width="100%" class="sortable">
	           <tr class="TituloTabla"> 
			     <td width="10"> </td>
			     <td width="95">C&oacute;digo Barra</td>
				 <td width="250">Nombre del Producto</td>			
				 <td width="50" align="right">Unid<br>Emp</td>							 
				 <td width="60" align="right">Canti<br>Compra</td>
				 <td width="100" align="right">Valor<br>Orden C.</td>
				 <td width="100" align="right">Valor<br>Compra</td>
         <td width="100" align="right">Diferencias</td>
         <td width="60" align="right">% Dif</td>
				 <td width="100" align="right">Dif Total</td>	
				 <td width="100" align="right">Observaci&oacute;n</td>						 				 
         <td width="25" align="center"></td>	
         <td width="25" align="center"></td>				 
				 <td width="15" align="center"></td>				 
        	   </tr>';	

    $errores = 0;     $reg1 = 0;     $reg2 = 0;    $reg3 = 0;
	$tot1 = 0;   $tot2 = 0;   $difx = 0;
	while($row = mysql_fetch_array($result)) 
	{
       $errlocal = 0;   $observ = "";
	   /// Si hay diferencias entre lo que se pidio y lo que llego
	   if((round($row['CanCom'])<>round($row['CanOrd']))||(round($row['ValCom'])<>round($row['ValOrd'])))
	   {
	     /// Si el precio es mayor -> Error
		 if(round($row['ValCom']) > round($row['ValOrd']))
		 {
		   $tot1 += $row['ValOrd'];             $tot2 += $row['ValCom'];
		   $errores++;       $errlocal++;       $observ = "Precio es superior a lo negociado";
		 } /// Si es Menor, no genera Error	     
	   }  
	   	   
	   /// Si hay diferencias entre lo que se pidio y lo que llego
	   if((round($row['CanCom']*$row['ValCom']))>(round($row['CanOrd']*$row['ValOrd'])))
	   {
		   $tot1 += $row['ValOrd'];             $tot2 += $row['ValCom'];
		   $errores++;       $errlocal++;       $observ = "Precio-Cantidad superan lo negociado";
	   }
	   
	   
	   if($errlocal == 0)
	      $icon = '<img src="images/basicas/ok.png" border="0">';
	   else
	      $icon = '<img src="images/basicas/nofiltro.png" border="0">'; 	 
	   
	   //// Si Es error no lo muestro
	   if($errlocal > 0)
	   { 	  
	     $diferencias = ($row['ValCom']-$row['ValOrd']);
       $diftotal    = $row['CanCom']*$diferencias;
       $porcdif     = (($diferencias/$row['ValCom'])*100);

       if($diftotal > 0)
       { 
	        $parte0.=' <tr class="TablaDocsPar">
	                 <td width="10"> </td>
		             <td width="95"><input type="text" class="Texto10" value="'.$row['codigo'].'" size="12"></td>
		             <td width="250">'.substr($row['descripcion'],0,35).'</td>			
			         <td width="80" align="right">'.number_format($row['factor1']).'</td>						 				 					 
				     <td width="100" align="right">'.number_format($row['CanCom'],2).'</td>						 
				     <td width="100" align="right">'.number_format($row['ValOrd'],2).'</td>						 
		    		 <td width="100" align="right">'.number_format($row['ValCom'],2).'</td>						 
             <td width="100" align="right"><b>'.number_format($diferencias,2).'</b> &nbsp;</td>						 		    		 
             <td width="100" align="right"><font color="red">'.number_format($porcdif,1).' %</font> &nbsp;</td>						 		    		 
		    		 <td width="100" align="right"><font color="blue"><b>'.number_format($diftotal,2).'</b> &nbsp;</td>						 		    		 
				     <td width="100" align="right"><font color="gray" size="1">'.$observ.'</font></td>						 				 
           <td width="15" align="center">'.$icon.'</td>			
           <td  width="30" align="right"> <a href="productos.php?opcion=rotaciondrog&id='.$row['productoid'].'" target="_blank">
           <img src="images/basicas/estadisticas.png" border="0" title="Rotación del Producto"></a></td>								 
				     <td width="15" align="center">&nbsp;</td></tr>';				 
          $difetotal += $diftotal;
         }
       }

       
	 }
   $parte0.="</table>";
     
	 //// Muestro la Totalizacion
	 $parte0.='<table width="100%">
	            <tr class="TablaDocsImPar">
                 <td width="105">&nbsp;</td>
                 <td width="250"><b>TOTAL DIFERENCIAS</b></td>				 
                 <td width="120">&nbsp;</td>			
                 <td width="80"><B>&nbsp;</td>			
                 <td width="20">&nbsp;</td>							 
                 <td width="30"><B>&nbsp;</td>			
                 <td width="30" align="right"><b><font color="blue">'.number_format($difetotal,2).'</td>							 
                 <td width="110">&nbsp;</td></tr></table>';
	}

	 //////////////////////////////////////////////////////////////////////////
	 //////////// Productos Iguales   -   Bloque 2		   
   //////////// Diferencias en el Producto en Cantidad y Precio
 	 $vsql = "SELECT DISTINCT P.productoid , P.codigo , P.descripcion , P.factor1 , P.posranking ,  
 	          SUM(IF(D.tipodoc = 'PCO' , (DD.cantidad+DDO.obsequio) , (-1)*(DD.cantidad+DDO.obsequio))) Diferencia , 
             FU_Rotacion30dias(P.productoid) ROTACION , FU_ExistenciaTotal(P.productoid) EXITOTAL , FU_TransitoCompras(P.productoid) TRANSITO , 
 	          COALESCE(SUM(IF(D.tipodoc = 'PCO' , DD.cantidad ,0)),0) EnOrden , COALESCE(SUM(IF(D.tipodoc = 'FCO' , DD.cantidad ,0)),0) EnFactura , 
 	          COALESCE(SUM(IF(D.tipodoc = 'PCO' , DDO.obsequio ,0)),0) ObsEnOrden , COALESCE(SUM(IF(D.tipodoc = 'FCO' , DDO.obsequio ,0)),0) ObsEnFactura 	          
			  FROM dedocumentos DD INNER JOIN productos P ON (DD.productoid = P.productoid)
			  INNER JOIN documentos D ON (D.docuid = DD.docuid)
			  LEFT JOIN dedocuorden DDO ON (DDO.dedocumid = DD.dedocumid)
			  WHERE D.docuid IN (".$docuid.",".$listaordenes.")
			  GROUP BY 1,2,3,4,5 ORDER BY P.descripcion ASC ";  	

	 $conex  = $clase->Conectar();
	 $result = mysql_query($vsql,$conex);	
     $reg1   = mysql_num_rows($result);
	 if($reg1)
	 {	
	 $parte1 ='<link rel="stylesheet" href="css/estiloadministrativos.css" type="text/css">
	           <table class="TablaDocsImPar" width="100%"><td align="center" width="90%"> <b> ERRORES - C&Oacute;DIGOS DE BARRA IGUALES - <FONT COLOR="RED"> ERROR EN CANTIDAD </td>
                <td> <form action="compras.php?opcion=dividirorden&docuid='.$docuid.'" method="POST" name="Y" target="_TOP">
                       <input type="hidden" name="docuid" value="'.$docuid.'"> 
                       <input type="hidden" name="listaordenes" value="'.$listaordenes.'">
                       <input type="hidden" name="vsqlx" value="'.$vsql.'">
					   <input type="submit" value="Separar Orden de Compra" class="button red"> </form> </td>
	           </tr></table>';
	 $parte1.='<script type="text/javascript" src="lib/sorttable.js"></script>
	           <table width="100%" class="sortable">
	           <tr class="TituloTabla"> 
			     <td width="10"> </td>
           <td width="45">Pos</td>
           <td width="95">C&oacute;digo Barra</td>
         <td width="160">Nombre del Producto</td>			
         <td width="45" align="right">Tiene Dias</td>
         <td width="45" align="right">M&aacute;x Pedir</td>
				 <td width="50" align="right">Unid<br>Emp</td>							 
				 <td width="80" align="right">Cantidad<br>Orden C.</td>						 
				 <td width="80" align="right">Obsequio<br>Orden C.</td>
				 <td width="80" align="right">Cantidad<br>Fact C.</td>						 
				 <td width="80" align="right">Obsequio<br>Fact C.</td>						 
				 <td width="100" align="right">Diferencia</td>
				 <td width="180" align="center">Observaci&oacute;n</td>						 				 				 
         <td width="25" align="center"></td>	
         <td width="25" align="center"></td>				 
        	   </tr>';	

    $errores1 = 0;   
    $reg1 = 0;     $reg2 = 0;    $reg3 = 0;
	$tot1 = 0;   $tot2 = 0;   $difx = 0;
	while($row = mysql_fetch_array($result)) 
	{
       $errlocal = 0;   $observ = "";
	   $diferencia = (0+$row['EnOrden']-$row['EnFactura']);

       //// Si Es error no lo muestro
	   if($diferencia != 0)
	   { 
	      if($diferencia < 0)
	         $observ = '<font color="red">Sobrante vs Orden Compra</font>';	         
	      else
	         $observ = '<font color="blue">Faltante vs Orden Compra</font>';

          // Si es un obsequio, busco la observacion
          if($row['codigo'] == "OBSEQUIOS") 
          {
	         $ddid = $clase->SeleccionarUno("SELECT dedocumid FROM dedocumentos WHERE productoid = ".$row['productoid']." AND docuid IN (".$listaordenes.")");
	         $mensaje = '<br><font color="blue">'.$clase->SeleccionarUno("SELECT texto FROM observapro WHERE productoid = ".$row['productoid']." AND dedocumid = ".$ddid." LIMIT 0,1"); 
          }
          else
          	 $mensaje = "";

	   	  $icon = '<img src="images/basicas/nofiltro.png" border="0">'; 	 
        
        /// Calculo el Numero de Dias
        $tienepara = (($row['EXITOTAL']*30)/$row['ROTACION']);
        if(round($tienepara) <= 60) $tienex = '<b><font color="red">'.number_format($tienepara)."</font>";
        else                $tienex = number_format($tienepara);
        
        /// Calculo el Maximo a Pedir 
        $maximo = (($row['ROTACION']*3)-$row['TRANSITO']-$row['EXITOTAL']);
        if($maximo < 0)  $maximo = 0;
        
	      $errores1 ++;
	      $parte1.=' <tr class="TablaDocsPar">
                   <td width="10"> </td>
                   <td width="45"><font color="gray"> '.number_format($row['posranking']).' </font> </b> &nbsp;</td>						 				 					 
		             <td width="95"><input type="text" class="Texto10" value="'.$row['codigo'].'" size="14"></td>
                 <td width="160">'.substr($row['descripcion'],0,35).$mensaje.' </td>			
                 <td width="45" align="right"> '.$tienex.' </font> </b> &nbsp;</td>						 				 					 
                 <td width="45" align="right"><font color="red"> '.$maximo.' </font> </b> &nbsp;</td>						 				 					 
			         <td width="80" align="right"><b><font color="gray"> '.number_format($row['factor1']).' </font></b> </td>						 				 					 
				     <td width="50" align="right">'.number_format($row['EnOrden'],1).'</td>	
				     <td width="50" align="right">'.number_format($row['ObsEnOrden'],1).'</td>							 
				     <td width="80" align="right">'.number_format($row['EnFactura'],1).'</td>
				     <td width="50" align="right">'.number_format($row['ObsEnFactura'],1).'</td>							 
			    	 <td width="100" align="right"> <b>'.number_format(abs($diferencia),1).'<b></td>						 				 
             <td width="180" align="center">'.$observ.' </font></td>						 				 
             <td  width="30" align="right"> <a href="productos.php?opcion=rotaciondrog&id='.$row['productoid'].'" target="_blank">
           <img src="images/basicas/estadisticas.png" border="0" title="Rotación del Producto"></a></td>				
				     <td width="25" align="center">&nbsp;</td></tr>';				 
       }
	 }
     $parte1.="</table>";     
	}

	 //////////////////////////////////////////////////////////////////////////
	 /////  Productos Iguales		   
     /////  Diferencias en el Producto en Cantidad y Precio
 	 $vsql = "SELECT P.productoid , P.codigo , P.descripcion , P.factor1 , P.costoinf , DD.valunitario , DD.valparcial , DD.cantidad , DDO.obsequio , DCC.dcto1 , P.porciva 
			  FROM documentos D INNER JOIN docucompra DCC ON (D.docuid = DCC.docuid)
			  INNER JOIN dedocumentos DD ON ( D.docuid = DD.docuid ) 
              INNER JOIN dedocuorden DDO ON ( DD.dedocumid = DDO.dedocumid ) 
			  INNER JOIN productos P ON ( P.productoid = DD.productoid ) 
              WHERE D.docuid = ".$docuid." ORDER BY descripcion ASC";  			  

	 $conex  = $clase->Conectar();
	 $result = mysql_query($vsql,$conex);	
     $reg1   = mysql_num_rows($result);
	 if($reg1)
	 {	
	 $parte12 ='<link rel="stylesheet" href="css/estiloadministrativos.css" type="text/css">
	           <table class="TablaDocsImPar" width="100%"><td align="center"><b> ERRORES - C&Oacute;DIGOS DE BARRA IGUALES - <FONT COLOR="RED">ERROR EN PRECIO </td>
             <td width="50"> <a href="compras.php?opcion=diferenciaspdf2&docuid='.$docuid."&numoco=".$numoco.'" target="_blank"> 
                  <input type="button" class="button" value="En pdf"> </a> </tr></table>';
	 $parte12.='<script type="text/javascript" src="lib/sorttable.js"></script>
	           <table width="100%" class="sortable">
	           <tr class="TituloTabla"> 
			     <td width="10"> </td>
			     <td width="95">C&oacute;digo Barra</td>
				 <td width="200">Nombre del Producto</td>			
				 <td width="50" align="right">Unid<br>Emp</td>							 
				 <td width="100" align="right">Anter Costo<br>Informat</td>
				 <td width="100" align="right">Nuevo Costo<br>Informat</td>				 
				 <td width="80" align="right">Diferencia<br>Precios</td>
				 <td width="80" align="right">% Dif</td>
				 <td width="25" align="center"></td>
				 <td width="100" align="right">Observaci&oacute;n</td>						 				 
         <td width="25" align="center"></td>		
         <td width="25" align="center"></td>				 
				 <td width="15" align="center"></td>				 
        	   </tr>';	

    $errores2 = 0;  
    $reg1 = 0;     $reg2 = 0;    $reg3 = 0;
	$tot1 = 0;   $tot2 = 0;   $difx = 0;
	while($row = mysql_fetch_array($result)) 
	{
       $errlocal = 0;   $observ = "";
	     $icon = '<img src="images/basicas/ok.png" border="0">';
       
       $Ncostoinf = (($row['valunitario']*$row['cantidad'])/($row['cantidad']+$row['obsequio']));
       $Ncostoinf = ($Ncostoinf-($Ncostoinf*($row['dcto1']/100)));
       if($row['porciva']>0)
       	 $Ncostoinf = $Ncostoinf-($Ncostoinf*($row['porciva']/100));

       $difpre = $row['costoinf']-$Ncostoinf;
       $porcendif = @abs(($difpre/$row['costoinf'])*100);
	   //// Si Es error no lo muestro
	   //if(($difpre < 0)&&($porcendif>1))
	   if($difpre < 0)
	   { 	  
	     if($difpre > 0)
	       $diferenpre = number_format(abs($difpre),1);
	     else
	       $diferenpre = '<font color="red">'.number_format(abs($difpre),1);
         
         $observ  = "Diferencias Costos";
         $errores2++;
	     $parte12.=' <tr class="TablaDocsPar">
	                 <td width="10"> </td>
		               <td width="95"><input type="text" class="Texto10" value="'.$row['codigo'].'" size="14"></td>
		               <td width="200">'.substr($row['descripcion'],0,35).'</td>			
			             <td width="80" align="right">'.number_format($row['factor1']).'</td>						 				 					 
      				     <td width="80" align="right">'.number_format($row['costoinf'],2).'</td>	
      				     <td width="80" align="right">'.number_format($Ncostoinf,2).'</td>	
      				     <td width="80" align="right"> <b>'.$diferenpre.'</td>						 
      				     <td width="80" align="right">'.number_format($porcendif,1).' %</td>	
      				     <td width="50" align="center"> <a href="productos.php?opcion=proveedores&id='.$row['productoid'].'" target="_blank">
                             <img src="images/basicas/estacompras.png" border="0" title="Estadisticas de Compras"></a> </td>					 
      				     <td width="100" align="right"><font color="blue">'.$observ.'</font></td>						 				 
                   <td width="15" align="center">'.$icon.'</td>	
                   <td  width="30" align="right"> <a href="productos.php?opcion=rotaciondrog&id='.$row['productoid'].'" target="_blank">
           <img src="images/basicas/estadisticas.png" border="0" title="Rotación del Producto"></a></td>							 
      				     <td width="15" align="center">&nbsp;</td></tr>';				 
       }
	 }

     $parte12.="</table>";
	 //// Muestro la Totalizacion
	 $difetotales = $tot1-$tot2;
	 $parte12.='<table width="100%">
	            <tr class="TablaDocsImPar">
                 <td width="105">&nbsp;</td>
                 <td width="250"><b>TOTAL DIFERENCIAS</b></td>				 
                 <td width="120">&nbsp;</td>			
                 <td width="80"><B>'.number_format($tot1,2).'</td>			
                 <td width="70">&nbsp;</td>							 
                 <td width="100"><B>'.number_format($tot2,2).'</td>			
                 <td width="70"><b><font color="blue">'.number_format($difetotales).'</td>							 
                 <td width="20">&nbsp;</td></tr></table>';
	}

    
	  /////////////////////////////////////////////////////////////////
	  ///// Boton de las Diferencias	
	  /////////////////////////////////////////////////////////////////
	  if(($errores1>0)||($errores2>0)) 
    {
	    $pie2.='<center><br>
	           <a href="compras.php?opcion=crear&docuid='.$docuid.'" target="_parent">
	           <input type="button" class="button" value="<< SOLUCIONAR DIFERENCIAS"></a>';
			   
	    $permiso = $clase->GetPermiso("FACTURAS DE COMPRAS",$_SESSION['USERNAME'],"especial2");
      if($permiso == "CHECKED"){        
	    $pie2.='<br><br><br><center><a href="compras.php?opcion=asentar&docuid='.$docuid.'" target="_parent">
	            <input type="button" class="button red" value="OMITIR ERRORES Y FINALIZAR FACTURA DE COMPRA"></a><br><br>';	
	  }		
	  	  
   	  //$cont = $parte0.$parte1.$parte12.$parte2.$parte3.$pie1.$pie2;		   
	}
	else
	{
	      $asentada = $clase->BDLockup($docuid,"documentos","docuid","fecasentado");      
          
          if(($asentada == "0000-00-00")&&($boton!='no'))
          {	
	         $pie2.='<center><br>
	                 <a href="compras.php?opcion=asentar&docuid='.$docuid.'" target="_parent">
	                 <input type="button" class="button blue" value="CERRAR FACTURA DE COMPRA"></a><br><br>';
	      }           
	      $cont = $titulo1.$pie2;	   	 
	}	
	$cont = $parte0.$parte1.$parte12.$pie1.$pie2;	
	echo $cont;   exit();
  }


  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "dividirorden")
  {
	 $docuid        = $_POST['docuid'];              
	 $listaordenes  = $_POST['listaordenes'];              
	 $vsqlxxx       = str_replace('\\', '' , $_POST['vsqlx']);              
     $OCid = $clase->BDLockup($docuid,'docuself','docuid','docuid2');
 
	 //// Encabezado de la Orden de Compra  	 
 	 $vsql = "SELECT * FROM documentos D INNER JOIN docucompra DC ON (D.docuid = DC.docuid) WHERE D.docuid =".$OCid;  	
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);	
	 if($row = mysql_fetch_array($result)) 
	 {
	    $van = $clase->SeleccionarUno("SELECT COUNT(*) FROM documentos WHERE tipodoc='PCO' AND nrodocref LIKE '".substr($row['nrodocref'],0,5)."%'");
		$conse = $van+1;
        $numeroOC = $clase->BDLockup($OCid,'documentos','docuid','numero');
		if(substr($numeroOC,(strlen($numeroOC)-2),1) == "-")
		{
		   $numactual = substr($numeroOC,(strlen($numeroOC)-1),1);
		   $numero    = substr($numeroOC,0,(strlen($numeroOC)-2))."-".($numactual+1); 
		}
		else 
		   $numero = $numeroOC."-1"; 	
		
		
 	     $referencia = $row['numero'];

		   $vsqlx = "INSERT INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,formapago,terid1,terid2,terid3,nrodocref,observacion,sucursalid,creador,momento) VALUES('PCO','".
		          $row['prefijo']."','".$numero."','".$row['periodo']."','".$row['fechadoc']."','".$row['formapago']."','".$row['terid1']."','".$row['terid2']."','".$row['terid3']."','".
				  $referencia."','".$row['observacion']."','".$row['sucursalid']."','".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";

        $id = $clase->EjecutarSQL($vsqlx);
		    $numorden = $row['nrodocref']." ".$numero;  
        $NDocuid = $clase->SeleccionarUno("SELECT docuid FROM documentos WHERE tipodoc='PCO' AND prefijo='".$row['prefijo']."' AND numero='".$numero."'");
		
	    /// Asiento el Documento 
	    $clase->EjecutarSQL("UPDATE dedocumentos SET unidades = cantidad WHERE docuid=".$NDocuid);

        /// Asiento el Documento 
	    $clase->EjecutarSQL("UPDATE documentos SET fecasentado = '".$fecha."' WHERE docuid=".$NDocuid);		

        /// Aplico los Descuentos
        $vsql = "INSERT INTO docucompra(docuid,dcto1,dcto2,dcto3,dcto4) values(".$NDocuid.",".$row['dcto1'].",".$row['dcto2'].",".$row['dcto3'].",".$row['dcto4'].")";

        $clase->EjecutarSQL($vsql);  
  	 }
	 
	 ///// Paso de la Orden Anterior a esta
	 if($NDocuid>0)
	 {
	   $conex  = $clase->Conectar();
       $result3 = mysql_query($vsqlxxx,$conex);	

	   while($row3 = mysql_fetch_array($result3)) 
	   {
	      $diferencia  = ($row3['EnOrden']-$row3['EnFactura']); 
          $codpro      = $row3['codigo'];
          $productoidX = $row3['productoid']; 

          if($diferencia != 0)
          {
             $pid   = $row3['productoid'];
             $vsql2 = "SELECT * FROM dedocumentos WHERE docuid IN (".$listaordenes.") AND productoid = ".$pid;
             
             $conex2  = $clase->Conectar();
             $result2 = mysql_query($vsql2,$conex2);	
	         if($row2 = mysql_fetch_array($result2))
	         {
                $vsql3 = "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,costoprod,valunitario,valdescuento,valparcial,porciva,valbase,
                	     valiva,valtotal,docuref,unicom,unifra) 
	                     VALUES(".$NDocuid.",".$pid.",".$row2['bodegaid'].",".$diferencia.",".$diferencia.",".$row2['costoprod'].",".$row2['valunitario'].",".
	                     $row2['valdescuento'].",".$row2['valparcial'].",".$row2['porciva'].",".$row2['valbase'].",".$row2['valiva'].",".$row2['valtotal'].",'".
	                     $row2['docuref']."',".$row2['unicom'].",".$row2['unifra'].")";
	            $clase->EjecutarSQL($vsql3);

                $DDID = $clase->SeleccionarUno("SELECT MAX(dedocumid) FROM dedocumentos WHERE docuid = ".$NDocuid." AND productoid = ".$pid);
                
                //// Actualizo las cantidades en la Nueva Orden
                $canfac = $clase->SeleccionarUno("SELECT COALESCE(cantidad,0) FROM dedocumentos WHERE docuid = ".$docuid." AND productoid=".$pid );
                $canobs = $clase->SeleccionarUno("SELECT COALESCE(obsequio,0) FROM dedocuorden WHERE dedocumid = ".$row2['dedocumid']);
                
                $vsqly = "UPDATE dedocumentos SET cantidad = (cantidad - ".$canobs.") WHERE dedocumid =".$DDID;
//		        $clase->EjecutarSQL($vsqly);  		        

		          $vsql3 = "INSERT INTO dedocuorden(dedocumid,obsequio) VALUES(".$DDID.",".$canobs.")";
	            $clase->EjecutarSQL($vsql3);
		       
	         } 
          }	
	   }
	
   		//// Totalizo los valores de la Compra
		$cantproductos = $clase->SeleccionarUno("SELECT SUM(cantidad) FROM dedocumentos WHERE docuid=".$NDocuid);
		$total = $clase->SeleccionarUno("SELECT SUM(valtotal) FROM dedocumentos WHERE docuid=".$NDocuid);		
		$clase->EjecutarSQL("UPDATE documentos SET total=".$total." , totalitems=".$cantproductos." , fecasentado = '".date("Y-n-d")."' WHERE docuid=".$NDocuid);

	    $clase->Aviso(1,'Orden de Compra Separada con Exito. No. <a href="reportes/imppedidopro.php?docuid='.$NDocuid.'">'.$numorden.'</a>');
	    header("Location: compras.php?opcion=pre-asentar&docuid=".$docuid);		 
	 }  
  } 
     
  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "asentar")
  {
      ini_set("memory_limit","300M");
      set_time_limit(0);

      $docuid    = $_GET['docuid'];

      ///Actualizo los OBSEQUIOS al campo Unidades para que ingrese al inventario estas cantidades
      $vsql = "SELECT DD.dedocumid , COALESCE(DC.obsequio,0) obsequio , COALESCE(DD.cantidad,0) cantidad FROM dedocumentos DD LEFT JOIN dedocuorden DC ON (DD.dedocumid = DC.dedocumid) WHERE DD.docuid =".$docuid;  	
      $conex  = $clase->Conectar();
      $result = mysql_query($vsql,$conex);	
      while($row = mysql_fetch_array($result)) 
      {
          $totalx = ($row['cantidad']+$row['obsequio']);
          $clase->EjecutarSQL("UPDATE dedocumentos SET unidades = ".$totalx." WHERE dedocumid=".$row['dedocumid']);
      }

      //// Valido que el Documento no sea de mas de 2 años y si es asi - Aborta Transaccion
      $anocontrol = (date("Y")-1);
      $fechacontrol = $anocontrol."-01-01";
      $vsql = "SELECT DATEDIFF(fechadoc,'".$fechacontrol."') FROM documentos WHERE docuid = ".$docuid;
      $dias = $clase->SeleccionarUno($vsql);
      if($dias<0)
      {
          echo'<script language="javascript">
                <!--
                  alert("Fecha NO Permitida para realizar esta transaccion");
                  document.location.href = "compras.php";
                -->
              </script>';
          exit;
      } 
      
      /// 0. Variables para control de los procesos
      $enviadaTNS = 'NO';
      $costosgen  = 'NO';
      $cartaragen = 'NO';

      /// 1. Validaciones 
      $numerocod = $clase->BDLockup($docuid,"documentos","docuid","observacion2");
      if(substr($numerocod,0,6) == "TRBCOD")
      {
         //// Aplico la Bodega COD a la Compra
         $clase->EjecutarSQL("UPDATE dedocumentos SET bodegaid = 165 WHERE docuid = ".$docuid); 

         //// Reemplazo en el COD los Valores de la Factura de Compra 
         ReemplazarCantidadesTRBnueva($docuid,$numerocod); 
      }
         
      $asentada = $clase->BDLockup($docuid,"documentos","docuid","fecasentado");
      $asentar = $clase->GetPermiso("FACTURAS DE COMPRAS",$_SESSION['USERNAME'],"asentar");
      if(($asentar == "CHECKED")&&($asentada == '0000-00-00'))
      {
        //////////////////////////////////////////////////////////////
        /// Aplico la Sucursal al Documento
        if(substr($numerocod,0,6) == "TRBCOD")
           $bodegaidx = $clase->BDLockup("COD","bodegas","codbodega","bodegaid");
        else
        {
            $sucid = $clase->BDLockup($docuid,"documentos","docuid","sucursalid");
            if($sucid == 19) 
                $bodegaidx = $clase->BDLockup("50","bodegas","codbodega","bodegaid");
            else   
                $bodegaidx = $clase->BDLockup("DB","bodegas","codbodega","bodegaid");
            
            $clase->EjecutarSQL("UPDATE dedocumentos SET bodegaid = ".$bodegaidx." WHERE docuid = ".$docuid);
        }   
        
        $fecasentado = $clase->BDLockup($docuid,"documentos","docuid","fecasentado");
        
        if($fecasentado == '0000-00-00')
        {
            $fecha   = date("Y-n-d"); 
            $vsql2 = "SELECT D.fecasentado FROM docuself DS INNER JOIN documentos D ON ( DS.docuid2 = D.docuid ) WHERE DS.docuid =".$docuid." ORDER BY D.fecasentado ASC LIMIT 0,1";
            $ordencerra  = $clase->SeleccionarUno($vsql2);
            
            if($ordencerra != "0000-00-00")
            {
              /// Selecciono el IVA en las lineas para aplicarselo al Encabezado de la Factura 
              $vsql  = "SELECT SUM(valbase) FROM dedocumentos WHERE docuid=".$docuid;
              $base  = $clase->SeleccionarUno($vsql);
              $vsql  = "SELECT SUM(valiva) FROM dedocumentos WHERE docuid=".$docuid;
              $iva   = $clase->SeleccionarUno($vsql);
          
              $clase->EjecutarSQL("UPDATE documentos SET base=".$base." , iva=".$iva." WHERE docuid=".$docuid);	 
        
              /// Cargo los Descuentos 
              $dcto1 = $clase->BDLockup($docuid,'docucompra','docuid','dcto1');
              $dcto2 = $clase->BDLockup($docuid,'docucompra','docuid','dcto2');
              $dcto3 = $clase->BDLockup($docuid,'docucompra','docuid','dcto3');	 	 
              $dcto4 = $clase->BDLockup($docuid,'docucompra','docuid','dcto4');
              $dcto5 = $clase->BDLockup($docuid,'documentos','docuid','descuentogen');

              if($dcto3 > 0)
              {
                $total = $clase->BDLockup($docuid,'documentos','docuid','total');
                //$base  = $total - ($total*($dcto1/100));
                //$base  = $base - ($base*($dcto2/100));         		
                GenerarNotaDescuento($docuid,$dcto3,$base,1);
              }	    		

              if($dcto4 > 0)
              {
                $total = $clase->BDLockup($docuid,'documentos','docuid','total');
                //$base  = $total - ($total*($dcto1/100));
                //$base  = $base - ($base*($dcto2/100));         		
                GenerarNotaDescuento($docuid,$dcto4,$base,2);
              }

              if($dcto5 > 0)
              {
                $total = $clase->BDLockup($docuid,'documentos','docuid','total');
                //$base  = $total - ($total*($dcto1/100));
                //$base  = $base - ($base*($dcto2/100));         		
                GenerarNotaDescuento($docuid,$dcto5,$basenotas,8,"V"); 
              }
              
              /////////////////////////////////////////////////////////////////////////////////////
              ///// Soluciono el Problema de los Obsequios
              $vsql = "SELECT DD.dedocumid , COALESCE(DC.obsequio,0) obsequio , COALESCE(DD.cantidad,0) cantidad FROM dedocumentos DD LEFT JOIN dedocuorden DC ON (DD.dedocumid = DC.dedocumid) WHERE DD.docuid =".$docuid;  	
              $conex  = $clase->Conectar();
              $result = mysql_query($vsql,$conex);	
              while($row = mysql_fetch_array($result)) 
              {
                    $totalx = ($row['cantidad']+$row['obsequio']);
                    $clase->EjecutarSQL("UPDATE dedocumentos SET unidades = ".$totalx." WHERE dedocumid=".$row['dedocumid']);
              }
              
              //// Asiento el Documento 		
              $clase->EjecutarSQL("UPDATE documentos SET fecasentado = '".$fecha."' WHERE docuid=".$docuid);
              
              //// Asentar Compra Barranquilla
              $prefijo = $clase->BDLockup($docuid,"documentos","docuid","prefijos");
              if($prefijo == "BAR")
              {
                  header("Location: compras.php?opcion=confirmarcompra&docuid=".$docuid);
                  exit;
              }   
              else
              {
                //// Recalculo el Costo de Los productos de La Factura de Compra	 
                CostoAsentarCompra($docuid);
                $costosgen = "SI";
                
                //// Recalculo el Transito y el R30 de los Productos
                ActualizaDatosEspeciales(0,$docuid); 
                
                //// Genero a Tesoreria el Movimiento
                $formapago = $clase->BDLockup($docuid,'documentos','docuid','formapago');	 
                if($formapago == "CR")
                {
                   GenerarTesoreria($docuid);
                   $carteragen = "SI";
                }
                
                /// Envío la compra a TNS
                EnviarCompraTNS($docuid);
                $enviadaTNS = "SI";
            
                /// Redirecciono a la pagina de la Compra
                $clase->Aviso(1,'Documento Cerrado Exitosamente');
              }
        }
        else{
          
              echo'<script language="javascript">
                    <!--
                      alert("La Orden de Compra asociada se encuentra abierta");
                      window.location = "compras.php?opcion=crear&docuid='.$docuid.'";
                    -->
                  </script>';    
        }
      }
      else{
        
        $clase->Aviso(2,'<b>ERROR :</b> Documento ya se encuentra asentado');
        header("Location: compras.php?opcion=crear&docuid=".$docuid);		 
        }    

      } /// Fin de Permiso para Asentar
      else
      {
          $clase->Aviso(2,'<b>ERROR :</b> No tiene permiso para Asentar Facturas de Compra');
          header("Location: compras.php");	
      }  

     //// Recalculo el Costo de Los productos de La Factura de Compra	 
     if($costosgen == "NO")
        CostoAsentarCompra($docuid);
               
     //// Genero a Tesoreria el Movimiento
     $formapago = $clase->BDLockup($docuid,'documentos','docuid','formapago');	 
     if(($formapago == "CR")&&($carteragen == "NO"))
        GenerarTesoreria($docuid);
      
     $clase->Aviso(1,'Facturas de Compra cerrada con Exito');
     header("Location: compras.php?opcion=confirmarcompra&docuid=".$docuid);	
   }

   /////////////////////////////////////////////////////////////////////////////////////////
   //// RE-HACE las tareas de ASENTADO - COSTOS - Tesoreria 
   /////////////////////////////////////////////////////////////////////////////////////////
   if($opcion == "confirmarcompra")
   {
       $docuid  = $_GET['docuid'];

       ///Actualizo los OBSEQUIOS al campo Unidades para que ingrese al inventario estas cantidades
       $vsql = "SELECT DD.dedocumid , COALESCE(DC.obsequio,0) obsequio , COALESCE(DD.cantidad,0) cantidad FROM dedocumentos DD LEFT JOIN dedocuorden DC ON (DD.dedocumid = DC.dedocumid) WHERE DD.docuid =".$docuid;  	
       $conex  = $clase->Conectar();
       $result = mysql_query($vsql,$conex);	
       while($row = mysql_fetch_array($result)) 
       {
          $totalx = ($row['cantidad']+$row['obsequio']);
          $clase->EjecutarSQL("UPDATE dedocumentos SET unidades = ".$totalx." WHERE dedocumid=".$row['dedocumid']);
       }

       //// Reproceso el Asentar
       if($docuid != "")
       {
           $fecasentado = $clase->BDLockup($docuid,"documentos","docuid","fecasentado");
           if(($fecasentado == "0000-00-00")||($fecasentado == ""))
               $clase->EjecutarSQL("UPDATE documentos SET fecasentado = CURRENT_DATE WHERE docuid=".$docuid);
           
           CostoAsentarCompra($docuid);
           GenerarTesoreria($docuid); 
           
           header("Location: compras.php");	 
           exit;
       }
       else
         echo"Error en ID";
   }

  /////////////////////////////////////////////////////////////////////////////////////////
  if($opcion == "recalcosto")
  {
	   $docuid  = $_GET['docuid'];
	   $fecha   = date("Y-n-d"); 
     CostoAsentarCompra($docuid);
     header("Location: compras.php");	 
  }

  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "regenerar")
  {
      $docuid  = $_GET['docuid'];
      $fecasentado = $clase->BDLockup($docuid,"documentos","docuid","fecasentado");
      if($fecasentado == "0000-00-00")
           $clase->Aviso(3,'Opcion <b>No Valida</b> para Documentos Abiertos');	 
      else    
      {
        ///Actualizo los Obsequios al campo Unidades para que ingrese al inventario estas cantidades
        $vsql = "SELECT DD.dedocumid , COALESCE(DC.obsequio,0) obsequio , COALESCE(DD.cantidad,0) cantidad FROM dedocumentos DD LEFT JOIN dedocuorden DC ON (DD.dedocumid = DC.dedocumid) WHERE DD.docuid =".$docuid;  	
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);	
        while($row = mysql_fetch_array($result)) 
        {
            $totalx = ($row['cantidad']+$row['obsequio']);
            $clase->EjecutarSQL("UPDATE dedocumentos SET unidades = ".$totalx." WHERE dedocumid=".$row['dedocumid']);
        }
       
        // Limpio los movimientos de Kardex Existentes
        $tipodoc = $clase->SeleccionarUno('SELECT tipodoc FROM documentos WHERE docuid='.$docuid);
        $prefijo = $clase->SeleccionarUno('SELECT prefijo FROM documentos WHERE docuid='.$docuid);
        $numero  = $clase->SeleccionarUno('SELECT numero FROM documentos WHERE docuid='.$docuid);
        $clase->EjecutarSQL("DELETE FROM kardex WHERE tipodoc='".$tipodoc."' AND prefijo='".$prefijo."' AND numero='".$numero."'");
        $clase->EjecutarSQL('CALL PA_AsentarDocumento('.$docuid.',"FCO")');
        
        $clase->Aviso(1,'Movimiento de Inventario Regenerado Exitosamente');	 
      }
      
      header("Location: compras.php");		 
  }


  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "regenerar2")
  {
      $docuid  = $_GET['docuid'];
      
      ///Actualizo los Obsequios al campo Unidades para que ingrese al inventario estas cantidades
      $vsql = "SELECT DD.dedocumid , COALESCE(DC.obsequio,0) obsequio , COALESCE(DD.cantidad,0) cantidad FROM dedocumentos DD LEFT JOIN dedocuorden DC ON (DD.dedocumid = DC.dedocumid) WHERE DD.docuid =".$docuid;  	
      $conex  = $clase->Conectar();
      $result = mysql_query($vsql,$conex);	
      while($row = mysql_fetch_array($result)) 
      {
          $totalx = ($row['cantidad']+$row['obsequio']);
          $clase->EjecutarSQL("UPDATE dedocumentos SET unidades = ".$totalx." WHERE dedocumid=".$row['dedocumid']);
      }
     
      // Limpio los movimientos de Kardex Existentes
      $tipodoc = $clase->SeleccionarUno('SELECT tipodoc FROM documentos WHERE docuid='.$docuid);
      $prefijo = $clase->SeleccionarUno('SELECT prefijo FROM documentos WHERE docuid='.$docuid);
      $numero  = $clase->SeleccionarUno('SELECT numero FROM documentos WHERE docuid='.$docuid);
      $clase->EjecutarSQL("DELETE FROM kardex WHERE tipodoc='".$tipodoc."' AND prefijo='".$prefijo."' AND numero='".$numero."'");
      $clase->EjecutarSQL('CALL PA_AsentarDocumento('.$docuid.',"FCO")');
      
      $clase->Aviso(1,'Movimiento de Inventario Regenerado Exitosamente');	 
      header("Location: repauditoria.php?opcion=aud_compras");		 
  }

  ///////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "regenerartnsfco")
  {
  	 $docuid = $_GET['docuid'];
  	 EnviarCompraTNS($docuid);
  	 $clase->Aviso(1,'Documento Regenerado a TNS con Exito'); 
  	 header("Location: compras.php");		 
  }
      
  ///////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "imprimir")
  {
	 $docuid = $_GET['docuid'];
	 header("Location: reportes/impcompras.php?docuid=".$docuid);		 
  }

  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "guardarencab")
  {
      $docuid     = $_POST['docuid'];
      $fecha      = $_POST['fechadoc'];
      $deposito   = $_POST['deposito'];
      $formapago  = $_POST['formapago'];
      $fechallegada    = $_POST['fechallegada'];
      $nrodocref = $_POST['nrodocref'];

      //// Valido que No haya un mismo numero de Factura para ese Mismo Proveedor - Numero Exacto asi sea de 1 digito
      $proveedorid = $clase->BDLockup($docuid,"documentos","docuid","terid1");
      $existenum = $clase->SeleccionarUno("SELECT COUNT(*) FROM documentos WHERE terid1 = ".$proveedorid." AND TRIM(nrodocref) = TRIM('".$nrodocref."')");
      if($existenum > 1)
      {
          echo '<script language="javascript">
                  <!--
                    alert("ERROR - Ya Existe otra factura con ese mismo Numero para ese mismo Proveedor. No puede ser vacío. Intente de Nuevo.");
                    document.location.href = "compras.php?opcion=crear&docuid='.$docuid.'";
                  -->
                </script>';
          exit;
      }

      //// Valido que la Fecha de llegada no sea ni mañana ni hace un mes
      if($_SESSION['SUPERUSUARIO'] != "CHECKED")   /// Si es SUPER Usuario lo omite
      {
          $hoy = date("Y-n-d");
          if($fechallegada > $hoy)
          {
              echo '<script language="javascript">
                <!--
                  alert("ERROR - La Fecha de Llegada No Puede ser superior a HOY!");
                  document.location.href = "compras.php?opcion=crear&docuid='.$docuid.'";
                -->
              </script>';
              exit;
          }  
          else
          {
            $haceunmes = $clase->SeleccionarUno("SELECT DATE_SUB(NOW(), INTERVAL 30 DAY)");
            if($fechallegada <= $haceunmes )
            {
                echo '<script language="javascript">
                      <!--
                        alert("ERROR - La Fecha de Llegada No Puede ser inferior a HACE 30 DIAS!");
                        document.location.href = "compras.php?opcion=crear&docuid='.$docuid.'";
                      -->
                      </script>';
                exit;
            }  
          }    
      }

      ///////////////////////////////////////////////////////////////
      /// Aplico la Sucursal al Documento
      $sucid = $clase->BDLockup($deposito,"sucursales","codigo","sucursalid");
      $clase->EjecutarSQL("UPDATE documentos SET sucursalid = ".$sucid." WHERE docuid = ".$docuid);
      if($deposito == "00") 
         $bodegaidx = $clase->BDLockup("50","bodegas","codbodega","bodegaid");
      else   
         $bodegaidx = $clase->BDLockup($deposito,"bodegas","codbodega","bodegaid");
      $clase->EjecutarSQL("UPDATE dedocumentos SET bodegaid = ".$bodegaidx." WHERE docuid = ".$docuid);

      
      ///////////////////////////////////////////////////////////////
      //// Si no tiene la variable DiasCartera - Calcularla
      $diascartera = $clase->BDLockup($docuid,"docucompra","docuid","diascartera");
      if($diascartera <= 0) 
      {
         $fechallegada = $clase->BDLockup($docuid,"docucompra","docuid","fechallegada");
         if($fechallegada == "0000-00-00")
            $fechallegada = $clase->BDLockup($docuid,"documentos","docuid","fechadoc");

         $teridpro  = $clase->BDLockup($docuid,"documentos","docuid","terid1");
         $diasprov  = $clase->BDLockup($teridpro,"terceros","terid","diascompras");
         if($diasprov>0)
         {
           $nfecvence = $clase->SeleccionarUno("SELECT ADDDATE('".substr($fechallegada,0,10)."',INTERVAL ".$diasprov." DAY) FROM docucompra WHERE docuid=".$docuid); 
           $clase->EjecutarSQL("UPDATE documentos SET fecvence = '".$nfecvence."' WHERE docuid =".$docuid);    
           $clase->EjecutarSQL("UPDATE docucompra SET diascartera = '".$diasprov."' , fechallegada = '".substr($fechallegada,0,10)."' WHERE docuid =".$docuid);
         }
     }

     $mes    = substr($fecha,3,2); 
     $ano    = substr($fecha,6,4);
     
     $nrodocref = $_POST['nrodocref'];
     $aplicar2  = $_POST['aplicar2'];
     $existe = 0 + $clase->SeleccionarUno("SELECT COUNT(*) FROM documentos WHERE tipodoc = 'FCO' AND nrodocref='".$nrodocref."'");

     if($existe > 2)
     {
        echo '<script language="javascript">
               <!--
                  alert("ERROR - El Numero de Factura del Proveedor ya Existe!");
                  document.location.href = "compras.php?opcion=crear&docuid='.$docuid.'";
               -->
              </script>';
     }
     else
     {
       //// Valido si el periodo está Bloqueado
       $vsql = "SELECT bloqcompras FROM periodos WHERE codperiodo = '".$mes.$ano."'";
       $bloqueado = $clase->SeleccionarUno($vsql);
       if($bloqueado == "CHECKED")
       {
          $clase->Aviso(3,'<b>ERROR :</b> Periodo Bloqueado para ingreso de Documentos');
          header("Location: compras.php");          exit();
     }

     //// Permito colocar solamente prefijo DEP o F22 
     $tipodoc = 'FCO';
     $prefijo = strtoupper($_POST['prefijo']);
     if(($prefijo != "DEP")&&($prefijo != "BAR")&&($prefijo != "F22")&&($prefijo != "WE"))
     {
        $clase->Aviso(3,'<b>ERROR :</b> Prefijo NO Valido');
        header("Location: compras.php");          exit();
     }
     else
     {
        $prefijoant = $clase->BDLockup($docuid,"documentos","docuid","prefijo");
        if($prefijo != $prefijoant)
        {
            $numero    = $clase->SeleccionarUno("SELECT numero FROM consecutivos WHERE tipodoc ='".$tipodoc."' AND prefijo='".$prefijo."'");
            $numerosig = str_pad($numero + 1,5,0,STR_PAD_LEFT);
            $clase->EjecutarSQL("UPDATE consecutivos SET prefijo = '".$prefijo."' , numero='".$numerosig."' WHERE tipodoc='".$tipodoc."' AND prefijo='".$prefijo."'");

            $clase->EjecutarSQL("UPDATE documentos SET prefijo = '".$prefijo."' , numero = '".$numero."' WHERE docuid =".$docuid);
        }
     }
     
     /// Valido que no se ingrese una Factura duplicada con el mismo numero de proveedor de ese mismo proveedor
     $provid = $clase->BDLockup($docuid,'documentos','docuid','terid1');
     $nrodocref  = strtoupper($_POST['nrodocref']);
     $existe1 = $clase->SeleccionarUno("SELECT COUNT(*) FROM documentos WHERE tipodoc = 'FCO' AND terid1=".$provid." AND nrodocref='".$nrodocref."' AND nrodocref<>''");
     if($existe1 > 1)
     {
        echo"ERROR :</b> Ya existe un numero de Factura de ese Proveedor ingresado al Sistema. Aseg&uacute;rese que es una Compra diferente";
        exit;
     }
     else
     {
         $fecha      = $_POST['fechadoc'];                    $fecvence  = $_POST['fecvence'];
         $observ     = $_POST['observ'];                      $cliente   = $_POST['cliente'];     	 
         $nrodocref  = strtoupper($_POST['nrodocref']);       $formapago = $_POST['formapago'];     	 
         $retefuente = 0+$_POST['retefuente'];                $dctogen   = 0+$_POST['descuentogen'];
         $diascartera  = $_POST['dias'];                      $aplicar2  = $_POST['aplicar2'];
         $ajubase    = 0+$_POST['ajustebase'];                $ajuiva    = 0+$_POST['ajusteiva'];                 $ajuneto  = 0+$_POST['ajusteneto'];
	       $fechallegada = $_POST['fechallegada'];              $impoconsumo = 0+$_POST['impoconsumo'];
         if($fechallegada == "") $fechallegada = $fecha;
         
         $fechahoy = strtotime(date("d-m-Y H:i:00",time()));
         $fechax   = $fecha;
          
         ///// Coloco los Dias de Plazo y Vencimiento desde la fecha de llegada
         $clase->EjecutarSQL("UPDATE documentos SET fecvence = DATE_ADD('".$fechallegada."', INTERVAL ".$diascartera." DAY) WHERE docuid = ".$docuid);
	  
      	 /// Descuentos
      	 $dcto1    = $_POST['dcto1'];    	  $dcto2   = $_POST['dcto2'];          $dcto3    = $_POST['dcto3'];           $dcto4    = $_POST['dcto4'];
      	 if($dcto1 == "") $dcto1 = 0;
      	 if($dcto2 == "") $dcto2 = 0;
      	 if($dcto3 == "") $dcto3 = 0;
      	 if($dcto4 == "") $dcto4 = 0;

    	   /// Transformo los valores recibidos del POST
    	   if($cliente == "") 
    	       $cliente = '00';
    	   
         $terid1   = $clase->BDLockup($cliente,'terceros','dni','terid');
    	 
    	   $fecham   = substr($fecha,6,4)."-".substr($fecha,3,2)."-".substr($fecha,0,2);  
         $fechav   = substr($fecvence,6,4)."-".substr($fecvence,3,2)."-".substr($fecvence,0,2);  	      
     
         // Actualizo la informacion del Encabezado
         if($fecha == "")
         { 
            $fechax = $_POST['fecha'];    
            $fecha  = substr($fechax,6,4)."-".substr($fechax,3,2)."-".substr($fechax,0,2);  
         }
         $vsql = "UPDATE documentos SET nrodocref ='".$nrodocref."' , fechadoc ='".$fecha."' , observacion='".$observ."' , retefuente=".$retefuente." , 
                  descuentogen =".$dctogen." , terid1=".$terid1." , ajustebase = ".$ajubase." , ajusteiva = ".$ajuiva." , ajusteneto = ".$ajuneto." , 
                  impoconsumo = ".$impoconsumo." , formapago = '".$formapago."'  
                  WHERE docuid=".$docuid;
                 
         $clase->EjecutarSQL($vsql);	 

         /// Docucompra
    	   $vsql = "UPDATE docucompra SET dcto1 = ".$dcto1." , dcto2 = ".$dcto2." , dcto3 = ".$dcto3." , dcto4 = ".$dcto4." , 
                  fechallegada = '".$fechallegada."' , aplicar2 = '".$aplicar2."' WHERE docuid = ".$docuid;
         $clase->EjecutarSQL($vsql);	 

         //// ReCalcular Valores - ReteFuente
    	   $clase->EjecutarSQL("CALL PA_CalValoresFCO(".$docuid.")");

    	   /// Actualizo el Total de Items del Encabezado
         $vsql  = "SELECT SUM(cantidad) FROM dedocumentos WHERE docuid=".$docuid;
      	 $totalitems  = $clase->SeleccionarUno($vsql);
      	 $vsql = "UPDATE productos SET totalitems = ".$totalitems." WHERE docuid=".$docuid;
      	 $clase->EjecutarSQL($vsql);
    	 
      	 /// Actualizo el Total = Total - (ReteFte + Desctos ) 
         $vsql  = "SELECT SUM(valtotal) FROM dedocumentos WHERE docuid=".$docuid;
      	 $sumalineas  = $clase->SeleccionarUno($vsql);
      	 $vsql = "UPDATE documentos SET total = (".$sumalineas." - (descuentogen)) WHERE docuid=".$docuid;
      	 $clase->EjecutarSQL($vsql);

          /// Muestro la insercion del producto y redirecciono a la pagina
      	  $clase->Aviso(1,'Encabezado de la Compra guardado Exitosamente');
       }
      
      //// Recalcular Valores 
      $clase->EjecutarSQL("CALL PA_CalVAloresFCO(".$docuid.")");

      /// Regreso al Documento
      header("Location: ?opcion=crear&docuid=".$docuid);		 	 
    }
  }

////////////////////////////////////////////////////////////////////////////////////////  
if($opcion == "borraritem")
{
	  $dedocumid = $_POST['dedocumid'];
	  $docuid    = $_POST['docuid'];
     
	  //// ELimino el producto en el detalle
    $vsql = "DELETE FROM dedocumentos WHERE dedocumid=".$dedocumid;
	  $clase->EjecutarSQL($vsql);

 	  /// Actualizo el Total de Items del Encabezado
    $vsql  = "SELECT SUM(cantidad) FROM dedocumentos WHERE docuid=".$docuid;
	  $totalitems  = $clase->SeleccionarUno($vsql);
    $vsql  = "SELECT SUM(valtotal) FROM dedocumentos WHERE docuid=".$docuid;
	  $valtotal  = $clase->SeleccionarUno($vsql);
	  $vsql = "UPDATE documentos SET totalitems = ".$totalitems." , total =".$valtotal." WHERE docuid=".$docuid;
	  $clase->EjecutarSQL($vsql);
 
    //// ReCalcular Valores - ReteFuente
	  $clase->EjecutarSQL("CALL PA_CalValoresFCO(".$docuid.")");

	  /// Actualizo el Total de Items del Encabezado
    $vsql  = "SELECT SUM(cantidad) FROM dedocumentos WHERE docuid=".$docuid;
	  $totalitems  = $clase->SeleccionarUno($vsql);
	  $vsql = "UPDATE productos SET totalitems = ".$totalitems." WHERE docuid=".$docuid;
	  $clase->EjecutarSQL($vsql);
	  
	  /// Actualizo el Total = Total - (ReteFte + Desctos ) 
    $vsql  = "SELECT SUM(valtotal) FROM dedocumentos WHERE docuid=".$docuid;
	  $sumalineas  = $clase->SeleccionarUno($vsql);
	  $vsql = "UPDATE documentos SET total = (".$sumalineas." - (retefuente + descuentogen)) WHERE docuid=".$docuid;
	  $clase->EjecutarSQL($vsql);
	 
    // Muestro la insercion del producto y redirecciono a la pagina
	  $clase->Aviso(3,'Producto  <b>'.$producto.'</b> Eliminado de la cotizacion con Exito');
	  header("Location: ?opcion=crear&docuid=".$docuid);		 
}

////////////////////////////////////////////////////////////////////////////////////////  
if($opcion == "anular")
{
	  $docuid    = $_POST['docuid'];
     
	  //// ELimino el producto en el detalle
    $vsql = "UPDATE documentos SET fecanulado = fechadoc WHERE docuid=".$docuid;
	  $clase->EjecutarSQL($vsql);	 
	 
	  // Muestro la insercion del producto y redirecciono a la pagina
	  $clase->Aviso(2,'Documento Anulado con Exito');
	  header("Location: compras.php");		 
}

  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "eliminar")
  {
  	  $docuid    = $_POST['docuid'];
     
      //// La Copio a 
      $NDocuidx = DuplicarBorrarDocumento($docuid);
       
      //// Registro la anulacion del Documento 
      $vsql = "INSERT INTO anulaciondoc(docuidanula,docuid2gen,tipo,observacion,codmotivo,desmotivo,creador,momento) 
                VALUES(".$docuid.",".$NDocuidx.",'ELI','Documento eliminado por el Usuario','00','MOTIVO NO ESPECIFICADO','".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";
      $clase->EjecutarSQL($vsql);
  	  
      //// ELimino el producto en el detalle
      $vsql = "DELETE  FROM dedocumentos WHERE docuid=".$docuid;
	    $clase->EjecutarSQL($vsql);
      $vsql = "DELETE  FROM docuself WHERE docuid=".$docuid;
	    $clase->EjecutarSQL($vsql);
      $vsql = "DELETE  FROM documentos WHERE docuid=".$docuid;
	    $clase->EjecutarSQL($vsql);	 
	 
	    // Muestro la insercion del producto y redirecciono a la pagina
	    $clase->Aviso(3,'Documento eliminado con Exito');
	    header("Location: compras.php");		 
  }
  
  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "agregardetalle")
  {
	   $docuid      = $_POST['docuid'];
     $codproducto = $_POST['producto'];
     $cantidad    = 0 + $_POST['cantidad'];
	   $unidades    = 0 + $_POST['unidades'];
	   $precio      = 0 + $_POST['precio'];
	   $descuento   = number_format((0 + $_POST['descuento']),2);
	   $descuento2  = $_POST['descuento2'];	 
     $porciva     = 0 + $_POST['iva'];	 
     $valtotal    = 0 + $_POST['total'];	 
	   $bodegaid    = $clase->BDLockup('50','bodegas','codbodega','bodegaid');	 	
	  
	   $dcto1    = $clase->BDLockup($docuid,'docucompra','docuid','dcto1');	 	 
	   $dcto2    = $clase->BDLockup($docuid,'docucompra','docuid','dcto2');	 	 
	   $dcto3    = $clase->BDLockup($docuid,'docucompra','docuid','dcto3');
	   $aplicar2 = $clase->BDLockup($docuid,'docucompra','docuid','aplicar2');	 	 	 	 	 


     if(($aplicar2 == "CHECKED")&&($dcto2 > 0)) 
     {
     	 $monto = ($precio*($dcto2/100));
     	 $precio = $precio-$monto;
     }

     $productoid  = $clase->BDLockup($codproducto,'productos','codigo','productoid'); 
     $empaque     = $clase->BDLockup($productoid,'productos','productoid','factor1'); 
	   $valparcial  = (($cantidad*$precio)+(($cantidad*$precio)*($porciva/100))-(($cantidad*$precio)*($descuento/100)));

	   $unicom      = $cantidad;
	   $unifra      = $unidades; 
	   $valbase     = round(($valtotal/(1+($porciva/100))),2);
	   $valiva      = round(($valtotal - $valbase),2);
	   $valtotal    = round($valtotal,2); 
     
	   $cantidadx   = ($unicom + ($unifra/$empaque));  
   
     if($bodegaid == "")
        $bodegaid = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS'],"bodegas","codbodega","bodegaid");

	   //// Inserto el producto en el detalle
     $vsql = "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,costoprod,valunitario,valdescuento,valparcial,porciva,valbase,valiva,valtotal,docuref,unicom,unifra) 
	          VALUES(".$docuid.",".$productoid.",".$bodegaid.",".$cantidadx.",".$cantidad.",".$precio.",".$precio.",".$descuento.",".$valparcial.",".$porciva.",".$valbase.
			 ",".$valiva.",".$valtotal.",'".$descuento2."',".$unicom.",".$unifra.")";
	   $clase->EjecutarSQL($vsql);
   
	   $dedocumid = $clase->SeleccionarUno("SELECT MAX(dedocumid) FROM dedocumentos");

	   /// Actualizo el Total de Items del Encabezado
     $vsql  = "SELECT SUM(cantidad) FROM dedocumentos WHERE docuid=".$docuid;
	   $totalitems  = $clase->SeleccionarUno($vsql);
	   $vsql = "UPDATE productos SET totalitems = ".$totalitems." WHERE docuid=".$docuid;
	   $clase->EjecutarSQL($vsql);

     //// ReCalcular Valores - ReteFuente
	   $clase->EjecutarSQL("CALL PA_CalValoresFCO(".$docuid.")");
	   $vsql  = "SELECT SUM(unidades) FROM dedocumentos WHERE docuid=".$docuid;
	   $totalitems  = $clase->SeleccionarUno($vsql);
	   $vsql  = "SELECT SUM(valbase) FROM dedocumentos WHERE docuid=".$docuid;
	   $base  = $clase->SeleccionarUno($vsql);
	   $vsql  = "SELECT SUM(valiva) FROM dedocumentos WHERE docuid=".$docuid;
	   $iva   = $clase->SeleccionarUno($vsql);
	   $vsql  = "SELECT SUM(valtotal) FROM dedocumentos WHERE docuid=".$docuid;
	   $total = $clase->SeleccionarUno($vsql);		 
	   $clase->EjecutarSQL("UPDATE documentos SET totalitems =".$totalitems." , base=".$base." , iva=".$iva." , total=".$total." WHERE docuid=".$docuid);	 	
	 
	 /// Actualizo el Total = Total - (ReteFte + Desctos ) 
     $vsql  = "SELECT SUM(valtotal) FROM dedocumentos WHERE docuid=".$docuid;
	 $sumalineas  = $clase->SeleccionarUno($vsql);
	 $vsql = "UPDATE documentos SET total = (".$sumalineas." - (retefuente + descuentogen)) WHERE docuid=".$docuid;
	 $clase->EjecutarSQL($vsql);
	 
	 //// Muestro un Aviso si con la cantidad Facturada queda en Existencia Cero
	 $vsql = "SELECT precio1m FROM productos WHERE productoid=".$productoid;
	 $preciov = $clase->SeleccionarUno($vsql);		    
	 
	 if($preciov == 0)
     {
	 	 $mensaje = '<br><br><center>
				       <img src="images/basicas/alerta3.png" border="0"><br>
					   <a href="compras.php?opcion=crear&docuid='.$docuid.'"><br>
					   <input type="button" value="Continuar con el Ingreso de la Compra" class="button blue"></a>';		  
         echo $mensaje;
		 exit(); 
	 }
	 
	 $precioest = $preciov*0.95;
	 $preciotemp= $precio-($precio*($dcto1/100))-($precio*($dcto2/100))-($precio*($dcto3/100));
	 if($precioest <= $preciotemp)
     {
	 	 $mensaje = '<br><br><center>
				       <img src="images/basicas/alerta2.png" border="0"><br>
					   <a href="compras.php?opcion=crear&docuid='.$docuid.'"><br>
					   <input type="button" value="Continuar con el Ingreso de la Compra" class="button blue"></a>';		  
         echo $mensaje;
		 exit(); 
	 }
     
	 //// Muestro un Aviso si con la cantidad Facturada queda en Existencia Cero
	 $vsql = "SELECT cantidad FROM existencias WHERE bodegaid = ".$bodegaid." AND productoid=".$productoid ;
	 $existencia = $clase->SeleccionarUno($vsql);		    
	 
	 if($existencia < 0)
     {
	 	 $mensaje = '<br><br><center>
				       <img src="images/basicas/alerta1.png" border="0"><br>
					   <a href="compras.php?opcion=crear&docuid='.$docuid.'"><br>
					   <input type="button" value="Continuar con el Ingreso de la Compra" class="button blue"></a>';		  
         echo $mensaje;
		 exit(); 
	 }
	 else
	 { 
	   // Muestro la insercion del producto y redirecciono a la pagina
	   $clase->Aviso(1,'Producto <b>'.$codproducto.'</b> agregado a la Compra con exito');
	   header("Location: ?opcion=crear&docuid=".$docuid);		 
	 }  
  }

  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "guardaritem")
  {
      $docuid       = $_POST['docuid'];
      $dedocumid    = $_POST['dedocumid'];
      $cantidad     = 0+$_POST['cantidad'];
      $unidades     = 0+$_POST['unidades'];	 
      $valunitario  = $_POST['valunitario'];
      $porciva      = $_POST['porciva'];
      $valdcto      = $_POST['valdcto'];
      $valico       = $_POST['valico'];
      $obsequio     = 0+$_POST['obsequio'];          	 if(($valdcto2 == "")||($valdcto2 == 0)) $valdcto2 = "";

 	   $devalbase    = round((($cantidad*$valunitario)-$valdcto),2); 
     $devaliva     = round(($devalbase*($porciva/100)),2);
     $devaltotal   = round(($devalbase+$devaliva),2);

  	 $dcto2    = $clase->BDLockup($docuid,'docucompra','docuid','dcto2');	 	 
	   $aplicar2 = $clase->BDLockup($docuid,'docucompra','docuid','aplicar2');	 	 	 	 	 

     if(($aplicar2 == "CHECKED")&&($dcto2 > 0)) 
     {
     	 $monto = ($valunitario*($dcto2/100));
     	 $valunitario = $valunitario-$monto;
     }
        
 	   $vsql1 = "UPDATE dedocumentos SET cantidad = ".$cantidad." , unidades = ".($cantidad+$obsequio)." , valunitario = ".$valunitario." , 
	           porciva=".$porciva." , valdescuento=".$valdcto." , docuref = '".$valdcto2."' ,
	           valbase=".$devalbase." , valiva=".$devaliva." , valico = ".$valico." , valtotal=".$devaltotal." WHERE dedocumid=".$dedocumid;
     
     $vsql1 = "UPDATE dedocumentos SET cantidad = ".$cantidad." , unidades = ".($cantidad+$obsequio)." , valunitario = ".$valunitario." , valico = ".$valico."  WHERE dedocumid=".$dedocumid;
	   $clase->EjecutarSQL($vsql1);

     $vsql1 = "UPDATE dedocuorden SET obsequio = ".$obsequio." WHERE dedocumid=".$dedocumid;
	   $clase->EjecutarSQL($vsql1);

	   $vsql       = "SELECT SUM(unidades) FROM dedocumentos WHERE docuid=".$docuid;
	   $totalitems = $clase->SeleccionarUno($vsql);
     $vsql       = "SELECT SUM(valbase) FROM dedocumentos WHERE docuid=".$docuid;
     $base       = $clase->SeleccionarUno($vsql);
     $vsql       = "SELECT SUM(valiva) FROM dedocumentos WHERE docuid=".$docuid;
     $iva        = $clase->SeleccionarUno($vsql);
     $vsql       = "SELECT SUM(valtotal) FROM dedocumentos WHERE docuid=".$docuid;
     $total      = $clase->SeleccionarUno($vsql);	 
     $clase->EjecutarSQL("UPDATE documentos SET totalitems =".$totalitems." , base=".$base." , iva=".$iva." , total=".$total." WHERE docuid=".$docuid);	 

     //// ReCalcular Valores - ReteFuente
	   $clase->EjecutarSQL("CALL PA_CalValoresFCO(".$docuid.")");
	 
	   $clase->Aviso(1,'Registro modificado con Exito');
	   header("Location: compras.php?opcion=crear&docuid=".$docuid);
  }

  //////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "editaritem")
  {
    $docuid       = $_GET['docuid'];
	  $dedocumid    = $_GET['dedocumid'];
    $productoid   = $clase->BDLockup($dedocumid,"dedocumentos","dedocumid","productoid");
    $nompro       = $clase->BDLockup($productoid,"productos","productoid","descripcion");

	  $cantidad    = $clase->BDlockup($dedocumid,'dedocumentos','dedocumid','cantidad');
	  $valunitario = $clase->BDlockup($dedocumid,'dedocumentos','dedocumid','valunitario');	
	  $porciva     = $clase->BDlockup($dedocumid,'dedocumentos','dedocumid','porciva');	
    $valdcto     = $clase->BDlockup($dedocumid,'dedocumentos','dedocumid','valdescuento');		
    $obse        = 0+$clase->BDlockup($dedocumid,'dedocuorden','dedocumid','obsequio');		
    $valico      = 0+$clase->BDlockup($dedocumid,'dedocumentos','dedocumid','valico');		
	
    $cont ='<table width="400">
	           <tr class="CabezoteTabla"> 
				 <td align="center"> Editar : <b>'.$nompro.'</b> <td> 
			   </tr> 
			</table>
			<form action="compras.php?opcion=guardaritem" method="POST">
			<input type="hidden" name="docuid" value="'.$docuid.'">
			<input type="hidden" name="dedocumid" value="'.$dedocumid.'">			
		    <table width="400">
			  <tr class="TablaDocsImPar">				
				<td width="150" align="right"> Cantidad &nbsp; </td> 			  
			    <td width="250"> <input type="text" name="cantidad" size="10" value="'.$cantidad.'"></td></tr>	
			  <tr class="TablaDocsPar">				
				<td width="150" align="right"> Vlr Unitario  &nbsp; </td> 			  
			    <td width="250"> <input type="text" name="valunitario" size="10" value="'.$valunitario.'"></td></tr>				
        </tr>
        <tr class="TablaDocsImPar">	
        <td width="150" align="right"> Vlr ImpoConsumo  &nbsp; </td> 			  
			    <td width="250"> <input type="text" name="valico" size="10" value="'.$valico.'"></td></tr>				
			  </tr>			
			  <tr class="TablaDocsPar">				
				<td width="150" align="right"> Obsequio &nbsp; </td> 			  
			    <td width="250">  <input type="text" name="obsequio" size="10" value="'.$obse.'"></td></tr>	
 			</table><center> <br> <input type="submit" value="Actualizar Registro" class="button blue"></form><br>'; 
      echo $cont;	
      exit();	
  }
 
 ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "refrescardcto")
  {
	   $docuid = $_GET['docuid'];
	   $OCid   = $clase->BDLockup($docuid,'docuself','docuid','docuid2');
     
	   $formapago = $clase->BDLockup($OCid ,'documentos','docuid','formapago');

     $dcto1 = $clase->BDLockup($OCid ,'docucompra','docuid','dcto1');
     $dcto2 = $clase->BDLockup($OCid ,'docucompra','docuid','dcto2');
     $dcto3 = $clase->BDLockup($OCid ,'docucompra','docuid','dcto3');	 	
     $dcto4 = $clase->BDLockup($OCid ,'docucompra','docuid','dcto4');	 	
     $diascar = $clase->BDLockup($OCid ,'docucompra','docuid','diascartera');
     
     $vsql = "UPDATE documentos SET formapago = '".$formapago."' WHERE docuid = ".$docuid;
     $clase->EjecutarSQL($vsql);

     $vsql = "UPDATE docucompra SET dcto1=".$dcto1." , dcto2=".$dcto2." , dcto3=".$dcto3." , dcto4=".$dcto4." , diascartera = ".$diascar." WHERE docuid=".$docuid;
     $clase->EjecutarSQL($vsql);

     if($formapago == "CR")
     {
         $fecllegada = $clase->BDLockup($docuid ,'docucompra','docuid','fechallegada');
         $vsql = "UPDATE documentos SET fecvence = DATE_ADD('".$fecllegada."', INTERVAL ".round($diascar)." DAY) WHERE docuid = ".$docuid;
         $clase->EjecutarSQL($vsql);
     } 

     $vsql    = "SELECT DD.dedocumid , DD.productoid FROM dedocumentos DD WHERE DD.docuid = ".$docuid;
     $conex   = $clase->Conectar();
     $result  = mysql_query($vsql,$conex);
     while($row = mysql_fetch_array($result))
     {
          $ddid = $clase->SeleccionarUno("SELECT dedocumid FROM dedocumentos DD WHERE productoid = ".$row['productoid']." AND docuid = ".$OCid);
        
          if(strlen($ddid)>0)
          {
            $dctol1 = 0 + $clase->BDLockup($ddid,"dedocuorden","dedocumid","dctol1");
            $dctol2 = 0 + $clase->BDLockup($ddid,"dedocuorden","dedocumid","dctol2");
            $dctol3 = 0 + $clase->BDLockup($ddid,"dedocuorden","dedocumid","dctol3");
            $dctol4 = 0 + $clase->BDLockup($ddid,"dedocuorden","dedocumid","dctol4");
          
            $vsqlx = "UPDATE dedocuorden SET dctol1 = ".$dctol1." , dctol2 = ".$dctol2." , dctol3 = ".$dctol3." , dctol4 = ".$dctol4." WHERE dedocumid=".$row['dedocumid']; 
          }
          else
            $vsqlx = "INSERT INTO dedocuorden(dedocumid,dctol1,dctol2,dctol3,dctol4,precioant,obsequio) VALUES(".$ddid.",0,0,0,0,0,0)";
          
         $clase->EjecutarSQL($vsqlx);
     }

     echo'<script language="javascript">
           <!-- 
             alert("Descuentos Actualizados con Exito");
             window.location = "compras.php?opcion=crear&docuid='.$docuid.'";
           -->
          </script>';
  
     exit();     
  }	

  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "importarpro2")
  {
  	 $docuid = $_POST['docuid']; 
  	 $OCid   = $_POST['ocid']; 

  	 $vsql = "SELECT * FROM dedocumentos DD LEFT JOIN dedocuorden DDO ON (DD.dedocumid = DDO.dedocumid) WHERE DD.docuid =".$OCid;
     $conex   = $clase->Conectar();
     $result  = mysql_query($vsql,$conex);
     while($row = mysql_fetch_array($result))
     {
        $dcto2    = $clase->BDLockup($docuid,'docucompra','docuid','dcto2');	 	 
	      $aplicar2 = $clase->BDLockup($docuid,'docucompra','docuid','aplicar2');	 	 	 	 	 

        $devalbase     = ($row['valbase']+$row['valiva']);  
        $devaliva      = $row['valiva'];

        $devaluni     = $row['valunitario'];  
     	  $devalparcial = $row['valparcial'];
        $devaltotal   = $row['valtotal'];

        if(($aplicar2 == "CHECKED")&&($dcto2 > 0)) 
        {
     	     $monto      = ($row['valunitario']*($dcto2/100));
     	     $devaluni   =  $row['valunitario']-$monto;  
     	     $devaltotal = $devaluni*$row['cantidad'];
        }        

        $vsqlx = "INSERT INTO dedocumentos (docuid,productoid,bodegaid,cantidad,unidades,tipund,costoprod,valunitario,valparcial,porciva,valbase,
                     valiva,valtotal,unicom,unifra) VALUES(".$docuid.",".$row['productoid'].",".$row['bodegaid'].",".$row['cantidad'].",".$row['unidades'].",'D',".
                     $row['costoprod'].",".$devaluni.",".$devalparcial.",".$row['porciva'].",".$devalbase.",".$devaliva.",".$devaltotal.
                     ",".$row['unicom'].",".$row['unifra'].")";
        $clase->EjecutarSQL($vsqlx);

        $DDID = $clase->SeleccionarUno("SELECT MAX(dedocumid) FROM dedocumentos WHERE docuid = ".$docuid." AND productoid = ".$row['productoid']);

        $vsql3 = "INSERT INTO dedocuorden(dedocumid,dctol1,dctol2,dctol3,dctol4,obsequio) 
                  VALUES(".$DDID.",".$row['dctol1'].",".$row['dctol2'].",".$row['dctol3'].",".$row['dctol4'].",".$row['obsequio'].")";
	    $clase->EjecutarSQL($vsql3);
     }

     // Muestro el mensaje de realizado!
     $clase->Aviso(1,"Productos Importados de la Orden de Compra con Exito");
	   header("Location: compras.php?opcion=crear&docuid=".$docuid);      
  }

  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "importarpro")
  {
	 $docuid = $_GET['docuid'];
	 $OCid   = $clase->SeleccionarUno("SELECT docuid2 FROM docuself WHERE docuid=".$docuid." LIMIT 0,1");
	 $cont='<form action="compras.php?opcion=importarpro2" method="POST">
	          <input type="hidden" name="docuid" value="'.$docuid.'">
	          <input type="hidden" name="ocid" value="'.$OCid.'">
	        <table width="400">
	           <tr class="CabezoteTabla"> 
				 <td align="center"> <b> Importar Productos a Fact de Compra </b> <td> 
			   </tr> 
			</table>
		    <table width="400">
			  <tr class="TablaDocsImPar">				
			    <td width="400" align="center"> <br><br> <input type="submit" class="button" value="Importar productos desde orden de compra"> <br><br> </td>				
			  </tr>
			</table></form>';
	echo $cont; exit();		  
  }


  /////////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "savepos")
  {
	   $docuid   = $_POST['docuid'];
	   $codprod  = strtoupper($_POST['codproducto']);
     $prefijo  = $clase->BDLockup($docuid,'documentos','docuid','prefijo');
     $bodegaid = $clase->BDLockup("50",'bodegas','codbodega','bodegaid');

     //// Traduccion de Codigos de Barras
     $CODREAL = $clase->SeleccionarUno("SELECT codigo FROM productos WHERE bloqueado <> 'CHECKED' AND (codigo = '".$codprod."' OR codbarra LIKE '%".$codprod."%')");

	 if(strlen($codprod) > 4)
	 {
	   $vsql = "SELECT * FROM docuself WHERE docuid = ".$docuid;
	   $conex  = $clase->Conectar();
	   $result = mysql_query($vsql,$conex);	
       $canordenes = mysql_num_rows($result);
	     $listaordenes = "";    $i =0;
	     while($row = mysql_fetch_array($result))  
       {
	      if($i>0)
		    $listaordenes.= ",";
			
		  $listaordenes.= $row['docuid2'];
		  $i++;
	   }	 

	   if(strlen($listaordenes)>0)
	   {
	     $vsqle  = "SELECT DD.dedocumid FROM dedocumentos DD 
	                INNER JOIN productos P ON (P.productoid = DD.productoid) 
	                WHERE DD.docuid IN (".$listaordenes.") AND P.codigo='".$CODREAL."' limit 0,1";  					 
	     $existe = 0+$clase->SeleccionarUno($vsqle);

	     /// Controlo que el producto se haya Pedido
	     /// SD: No permite adicionar productos que no esten pedidos
	     if($existe == 0)
         {
	      echo'<script language="javascript">
				 <!--
				    alert("Producto No esta en el Pedido! No se ingreso\nCod Barra : '.$codprod.'");
				    document.location.href = "compras.php?opcion=pos&docuid='.$docuid.'";
				 -->
				</script>';	
		  exit();			 
	     }	 
	     else
	     {   	
            $vsqle = "SELECT DD.cantidad FROM dedocumentos DD INNER JOIN productos P ON (P.productoid = DD.productoid) WHERE DD.docuid IN (".$listaordenes.") AND P.codigo='".$CODREAL."' limit 0,1";  					 
	          $enOrden = 0+$clase->SeleccionarUno($vsqle);
            $enFactura = $clase->SeleccionarUno("SELECT SUM(cantidad) FROM dedocumentos DD INNER JOIN productos P ON (P.productoid = DD.productoid) WHERE P.codigo = '".$CODREAL."' AND docuid=".$docuid);
            if($enOrden <= $enFactura)
            {
	          echo'<script language="javascript">
			  	   <!--
				    alert("SUPERA CANTIDAD EN ORDEN DE COMPRA");
				    document.location.href = "compras.php?opcion=pos&docuid='.$docuid.'";
				   -->
				  </script>';	
		      exit();			 
	        }	 
	        else
	        {           
	    	 $vsql   = "SELECT * FROM dedocumentos DD LEFT JOIN dedocuorden DDO ON (DD.dedocumid = DDO.dedocumid) WHERE DD.dedocumid =".$existe." LIMIT 0,1";
	    	 $conex  = $clase->Conectar();
             $result = mysql_query($vsql,$conex);
             while($row = mysql_fetch_array($result)) 
             {
                 
                /// Valido si el proveedor es regimen simplificado
                if($row['porciva'] > 0)
                {
                     $essimplif = $clase->SeleccionarUno("SELECT T.regimen FROM terceros T INNER JOIN documentos D ON (D.terid1 = T.terid) WHERE D.docuid = ".$docuid);
                     if($essimplif == "SI")
                     {
                        echo'<script language="javascript">
                               <!--
                                  alert("Proveedor Regimen Simplificado. El Producto se incluirá sin Iva");
                               -->
                            </script>';
                     }                
                }  

                 $vsqlx = "INSERT INTO dedocumentos (docuid,productoid,bodegaid,cantidad,unidades,tipund,costoprod,valunitario,valparcial,porciva,valbase,
                           valiva,valtotal,unicom,unifra) VALUES(".$docuid.",".$row['productoid'].",".$bodegaid.",".$row['cantidad'].",".$row['unidades'].",'D',".
                           $row['costoprod'].",".$row['valunitario'].",".$row['valparcial'].",".$row['porciva'].",".$row['valbase'].",".$row['valiva'].",".$row['valtotal'].
                           ",".$row['unicom'].",".$row['unifra'].")";
                 $clase->EjecutarSQL($vsqlx);

                 if((strlen($row['dctol1'])>0)||(strlen($row['dctol2'])>0)||(strlen($row['dctol3'])>0)||(strlen($row['dctol4'])>0))
                 {
                    $ID = $clase->SeleccionarUno("SELECT MAX(dedocumid) FROM dedocumentos WHERE docuid = ".$docuid." AND productoid=".$row['productoid']);
                   
                    $dcto2    = $clase->BDLockup($docuid,"docucompra","docuid","dcto2");
                    $aplicar2 = $clase->BDLockup($docuid,"docucompra","docuid","aplicar2");
                    
                    if(($dcto2 > 0)&&($aplicar2 == "CHECKED"))
                    {
                        $valuni = $row['valunitario'] - ($row['valunitario']*($dcto2/100));
                        $valpar = $valuni*$row['cantidad'];
                        if($row['porciva'] > 0)
                        {
                           $valiva  = ($valuni*$row['cantidad']*($row['porciva']/100));
                           $valbase = $valpar - $valiva; 
                           $vsql2 = "UPDATE dedocumentos SET valunitario = ".$valuni." , valbase = ".$valbase." , valiva = ".$valiva." , valparcial = ".$valpar." , valtotal = ".$valpar." WHERE dedocumid = ".$ID;                           
                        }  	
                        else 
	                       $vsql2 = "UPDATE dedocumentos SET valunitario = ".$valuni." , valparcial = ".$valpar." , valtotal = ".$valpar." WHERE dedocumid = ".$ID;
	                   
                      $clase->EjecutarSQL($vsql2);
                    }
                 	
                    $vsqlx2 = "INSERT INTO dedocuorden(dedocumid,precioant,dctol1,dctol2,dctol3,dctol4,obsequio) 
                               VALUES(".$ID.",".$row['precioant'].",".$row['dctol1'].",".$row['dctol2'].",".$row['dctol3'].",".$row['dctol4'].",".$row['obsequio'].")";
                    $clase->EjecutarSQL($vsqlx2);	
                 }
               }
            }
            
            $clase->EjecutarSQL("CALL PA_CalValoresFCO(".$docuid.")");
            
            echo'<script language="javascript">
          				 <!--
          				    window.opener.location.reload();
          				    document.location.href = "compras.php?opcion=pos&docuid='.$docuid.'";
          				 -->
          				</script>';	

		    exit();	
	    }   
      }
	}  
  }

  //////////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "pos")
  {
	 $docuid = $_GET['docuid'];
	 $error  = $_GET['error'];
  	
	 if(($error == "")||($error == 0))
	 {
	    $COLOR = "green";
		
		$cont.='<link rel="stylesheet" href="css/estiloadministrativos.css" type="text/css">';
		$cont.='<body bgcolor="'.$COLOR.'" leftmargin="0" topmargin="0" rightmargin="0" bottonmargin="0" OnLoad="document.x.default.focus();">';
        $cont.='<form action="?opcion=savepos" method="POST" name="x">
      	        <input type="hidden" name="docuid" value="'.$docuid.'">
	             <table width="100%" bgcolor="'.$COLOR.'">	
	              <tr bgcolor="'.$COLOR.'">
				     <td align="center" bgcolor="'.$COLOR.'"> <input type="text" name="codproducto" class="Texto70" size="17" id="default" tabindex="1" autocomplete="off"> </td>
			      </tr>
	              <tr bgcolor="'.$COLOR.'" height="130">
			    	 <td align="center" bgcolor="'.$COLOR.'"><br><center><input type="submit" class="button red" value="Adicionar Producto"></td>
			      </tr>			  
			      </table></form>'; 
	}
	
	if($error == "1")
	{
	   $COLOR = "red";
	   $cont.='<body bgcolor="'.$COLOR.'" leftmargin="0" topmargin="0" rightmargin="0" bottonmargin="0">';
	   $cont.='<font color="white"><center><BR><h1>ERROR <br> PRODUCTO NO ENCONTRADO </H1><BR>
	           <a href="transferencias.php?opcion=pos&docuid='.$docuid.'">
			   <input type="button" value="CONTINUAR INGRESANDO PRODUCTOS" class="button"></a>';
    }			  

	if($error == "2")
	{
	   $COLOR = "orange";
	   $cont.='<body bgcolor="'.$COLOR.'" leftmargin="0" topmargin="0" rightmargin="0" bottonmargin="0">';
	   $cont.='<font color="white"><center><BR><h1>ERROR <br> DOCUMENTO YA ESTA CERRADO </H1><BR>
	           <a href="#" OnClick="window.close();"><input type="button" value="CERRAR VENTANA" class="button"></a>';
    }			  

	if($error == "3")
	{
	   $COLOR = "blue";
	   $cont.='<body bgcolor="'.$COLOR.'" leftmargin="0" topmargin="0" rightmargin="0" bottonmargin="0">';
	   $cont.='<font color="white"><center><BR><h1>YA ALCANZO EL LIMITE DE ITEMS</h1><h2> NO PODRA ADICIONAR MAS PRODUCTOS AL DOCUMENTO</H2><BR>
	           <a href="#" OnClick="window.close();"><input type="button" value="CERRAR VENTANA" class="button"></a>';
    }			  

	echo $cont;
	exit();
  }        

  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "crearimportar")
  {
  	 $docuid = $_GET['docuid'];
     
     //// Cargo la imagen predeterminada
     $escaneado = $clase->SeleccionarUno("SELECT filename FROM archivodigital WHERE docuid1 = ".$docuid);
     if($escaneado == "")    $escaneado = "nofoto.png";
     
     /// Valido si está Asentado lo redireccione 
     $fecasentado = $clase->BDLockup($docuid,"documentos","docuid","fecasentado"); 
  	 if($fecasentado != "0000-00-00")
     {
       $clase->Aviso(3,"Documento se encuentra Cerrado");
       header("Location: compras.php");
           exit();
     } 
     
     /// Si no tiene registro en Docucompra - Lo inserto 
     $existe = $clase->BDLockup($docuid,"docucompra","docuid","COUNT(*)");
     if($existe == 0)
     {
        $vsqli = "INSERT INTO docucompra(docuid,dcto1,dcto2,dcto3,dcto4) VALUES(".$docuid.",0,0,0,0)";
        $clase->EjecutarSQL($vsqli);
     }

     /////////////////////////////////////////////////////////////////////////////////////
     ///// Soluciono el Problema de los Obsequios
     $vsql = "SELECT DD.dedocumid , COALESCE(DC.obsequio,0) obsequio , COALESCE(DD.cantidad,0) cantidad FROM dedocumentos DD LEFT JOIN dedocuorden DC ON (DD.dedocumid = DC.dedocumid) WHERE DD.docuid =".$docuid;  	
     $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);	
     while($row = mysql_fetch_array($result)) 
     {
          $totalx = ($row['cantidad']+$row['obsequio']);
          $clase->EjecutarSQL("UPDATE dedocumentos SET unidades = ".$totalx." WHERE dedocumid=".$row['dedocumid']);
     }

     /////////////////////////////////////////////////////////////////////////////////////  
     //// Para el Caso de las Compras Directas - Si permite modificar los descuentos
     $docuorigen = $clase->BDLockup($docuid,'documentos','docuid','observacion2');
     if(substr($docuorigen,0,6) == "TRBCOD")
     {
        $bloqueardctos = "";
        $bloquearfp    = "";
        $bloquearfp2   = "";
        $avisoorigen = '<font color="red"></b> Viene de la <b>'.$docuorigen.'</b></font>';
     }
     else
     {
        $bloqueardctos = " READONLY ";
        $bloquearfp    = " READONLY ";
        $bloquearfp2   = " READONLY ";
     }
        
     /////////////////////////////////////////////////////////////////////////////////////

     /// A Medida que se ingresan los productos .. que el sistema actualice la Retefuente 
     refrescarRetefuente($docuid);

     $vsql   = "SELECT * FROM documentos D LEFT JOIN docucompra DC ON (D.docuid = DC.docuid) WHERE D.docuid=".$docuid;
  	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);

	   if($row = mysql_fetch_array($result)) 
	   {
  	    $aplicar2 = $row['aplicar2'];
  	    $cont = $clase->HeaderBlanco("Compra # ".substr($row['nrodocref'],0,10)); 
        $cont.= Javascript();		 
	  
    	  $bodegapredet = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS'],'bodegas','codbodega','bodegaid');

    	  if($row['terid1'] != 1)
    	    $codterid1 = $clase->BDLockup($row['terid1'],'terceros','terid','dni');

    	  if($row['terid2'] != 1)
    	    $vendedor = $clase->BDLockup($row['terid2'],'terceros','terid','dni');
	  
    	  $fecha  = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);
        $fechac = substr($row['momento'],8,2)."/".substr($row['momento'],5,2)."/".substr($row['momento'],0,4);
    	  $fechav = substr($row['fecvence'],8,2)."/".substr($row['fecvence'],5,2)."/".substr($row['fecvence'],0,4);

    	  $diferencia = (strtotime($row['fecvence'])-strtotime($row['fechadoc']));
    	  $diascartera = round($row['diascartera']);

      $cont.='<form name="x" action="?opcion=guardarencab" method="POST">
              <input type="hidden" name="docuid" value="'.$docuid.'">
              <table width="1750">
              <tr class="CabezoteTabla"> 
            <td width="10"> </td>
            <td width="37"> <img src="images/iconos/cotizacion.png" width="32" height="32" border="0"> </td>
            <td width="600"><b> Facturas de Compra </b><br> Generaci&oacute;n Asistida a partir de la &Oacute;rden de Compra<td>
            <td width="500"><b> '.$avisoorigen.' <td>';

      // -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- //
      // Nuevo botón para la consulta de las órdenes de compra asociadas a un producto específico
      $cont.='<td width="40" align="center"><a href="#" OnClick="window.open(\'compras.php?opcion=ventanaconorden&docuid='.$docuid.'\',\'POS\',\'width=700,height=500,scrollbars=no\');">
      <img src="images/iconos/asignaturas.png" title="Ingreso Tipo POS" border="0" width="28" height="28"></a></td>';
      // -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- //
      
      $bajar = $clase->GetPermisoEspecial("DOC05",$_SESSION['USERNAME']);  
	    if(($_SESSION['SUPERUSUARIO'] == "CHECKED")||($bajar == "CHECKED"))
	    {		 
         $cont.='<td width="40" align="center"><a href="?opcion=importarpro&docuid='.$docuid.'" rel="facebox">
				                               <img src="images/iconos/descargar.png" title="Importar Productos" border="0" width="28" height="28"></a></td>';
      }
      
      $cont.='  <td width="40" align="center"><a href="compras.php?opcion=regenerarcod&docuid='.$docuid.'">
                                 <img src="images/iconos/devoluciones.png" title="Regenerar la Transferencia COD" border="0" width="28" height="28"></a></td>                                              
                 
                 <td width="40" align="center"><a href="#" onclick="window.open(\'compras.php?opcion=cargararchivo&docuid='.$docuid.'\',\'Cargar\',\'width=550,height=310\');">
                                               <img src="images/iconos/enviarservidor.png" title="Cargar Imagen Digitalizada" border="0" width="28" height="28"></a></td>                 
                 <td width="40" align="center"><a href="media/docudigital/cargas/'.$escaneado.'" target="_blank">
                                              <img src="images/iconos/docudigital.png" title="Ver Imagen Digitalizada" border="0" width="28" height="28"></a></td>                                               
                  <!-- --------------------- Nuevo botón para el procesamiento masivo de productos de la factura de compra ----------------------- -->
                  <td width="40" align="center"><a href="#" onclick="window.open(\'compras.php?opcion=ventanaprocesomasivo&docuid='.$docuid.'\',\'Cargar\',\'width=850,height=635,scrollbars=no\');">
                  <img src="images/iconos/reconciliar.png" title="Procesamiento masivo" border="0" width="28" height="28"></a></td>                                               
                 <!-- ---------------------------------------------------------------------------------------------------------------------------- -->
                 <td width="40" align="center"><a href="compras.php?opcion=crearn&docuid='.$docuid.'">
                 <img src="images/iconos/notificaciones.png" title="Ingreso Normal" border="0" width="28" height="28"></a></td>                                                                
                 <td width="40" align="center"><a href="#" OnClick="window.open(\'compras.php?opcion=posnuevo&docuid='.$docuid.'\',\'POS\',\'width=850,height=250,scrollbars=no\');">
                 <img src="images/iconos/nuevodoc.png" title="Ingreso Tipo POS" border="0" width="28" height="28"></a></td>
                 <!-- ------------------------------------------------------------------------------------------------------------------------------------------------------------- -->
                 <!--
                 <td width="40" align="center"><a href="?opcion=anular&docuid='.$docuid.'">
				                               <img src="images/iconos/anulardoc.png" title="Anular Documento" border="0" width="28" height="28"></a></td>

                 <td width="40" align="center"><a href="?opcion=eliminar&docuid='.$docuid.'">
				                               <img src="images/iconos/eliminardoc.png" title="Eliminar Documento" border="0" width="28" height="28"></a></td>
                  -->                     
                 <!-- ------------------------------------------------------------------------------------------------------------------------------------------------------------- -->
                 <td width="40" align="center"><a href="?opcion=confirmacionanular&docuid='.$docuid.'" rel="facebox">
                                       <img src="images/iconos/anulardoc.png" title="Anular Documento" border="0" width="28" height="28"></a></td>

                 <td width="40" align="center"><a href="?opcion=confirmacioneliminar&docuid='.$docuid.'" rel="facebox">
                                       <img src="images/iconos/eliminardoc.png" title="Eliminar Documento" border="0" width="28" height="28"></a></td>
                 <!-- ------------------------------------------------------------------------------------------------------------------------------------------------------------- -->
                 <td width="40" align="center"><a href="#" Onclick="window.open(\'?opcion=imprimir&docuid='.$docuid.'\',\'Imp'.$row['docuid'].'\',\'scrollbars=yes,height=600,width=800\', false);">			 
				                                <img src="images/iconos/imprimirdoc.png" title="Imprimir Documento" border="0" width="30" height="30"></a></td>
                 
                 <td width="40" align="center"><a href="?opcion=enviarmail&docuid='.$docuid.'" rel="facebox"> 
				                                <img src="images/iconos/enviarmaildoc.png" title="Enviar por E-mail" border="0" width="30" height="30"></a></td>
                 <td width="40" align="center"><a href="#" OnClick="x.submit();"> 
				                               <img src="images/iconos/guardardoc.png" title="Guardar Documento" border="0" width="28" height="28"></a></td>
                 <td width="40" align="center"><a href="?opcion=pre-asentar&docuid='.$docuid.'">
				                               <img src="images/iconos/cerrar.png" title="Cerrar Documento" border="0" width="28" height="28"></a></td>
                 <td width="40" align="center"><a href="?opcion=digitalizar&docuid='.$docuid.'" rel="facebox">
                                       <img src="images/iconos/digitalizar.png" title="Soporte Digital" border="0" width="28" height="28"></a></td>		
                 <td width="40" align="center"><a href="compras.php?opcion=enviaraservidorprincipal&regresar=CHECKED&docuid='.$docuid.'">
                                       <img src="images/iconos/cargar.png" title="Factura de Compra Lista" border="0" width="28" height="28"></a></td>   									   
				 <td width="8"> </td>
			   </tr>	 			   
			 </table> 
			 <table width="100%">	
	          <tr class="EncabezadoDocumento">
			    <td width="10"> </td>
			    <td width="150"><label class="Texto11"><b>N&uacute;mero Documento</b></label><br>
				 <b>'.$row['tipodoc'].'</b>
				 <input type="text" onkeypress="return TabulaEnter(this, event)" class="Texto11" name="prefijo" size="3" maxlenght="3" style="text-transform:uppercase;text-align:center" value="'.$row['prefijo'].'" autocomplete="off">
				 <input type="text" onkeypress="return TabulaEnter(this, event)" class="Texto11" name="numero" size="5" maxlenght="3" value="'.$row['numero'].'" readonly></td>
				<td width="150"><label class="Texto11"><b>No. Doc Proveed</b></label><br> 
				  <input type="text" onkeypress="return TabulaEnter(this, event)" class="Texto11" name="nrodocref" size="12" maxlenght="10" value="'.$row['nrodocref'].'"></td>
				<td width="170"><label class="Texto11"><b>Fecha Factura</b></label><br> 
				  <input type="date" class="Texto11" name="fechadoc" size="10" maxlenght="10" value="'.substr($row['fechadoc'],0,10).'"></td>			
        <td width="170"><label class="Texto11"><b>Fecha Llegada </b></label><br> 
          <input type="date" class="Texto11" name="fechallegada" size="10" maxlenght="10" value="'.substr($row['fechallegada'],0,10).'"></td>      
				<td width="80" align="center"><label class="Texto11"><b>&nbsp;Dias</b></label><br> 
				  <input type="text" onkeypress="return TabulaEnter(this, event)" class="Texto11" name="dias" size="2" maxlenght="10" value="'.$diascartera.'" style="text-align:center;" '.$bloquearfp2.'></td>
			    <td width="120"><label class="Texto11"><b>Fecha Vencim</b></label><br> 
          <input type="text" onkeypress="return TabulaEnter(this, event)" class="Texto11" name="fecvence" size="10" maxlenght="10" value="'.$fechav.'" style="text-align:center;" '.$bloquearfp2.'></td>';
          
        $sucid = $clase->BDLockup($docuid,"documentos","docuid","sucursalid");
        if($sucid == 19)
        {
            $checked1 = 'SELECTED';   $checked2 = '';   
        }  
        else
        {
            $checked1 = '';   $checked2 = 'SELECTED';   
        }

        $cont.='<td width="200"><label class="Texto11"><b>Dep&oacute;sito Ingreso</b></label><br> 
          <SELECT name="deposito"> 
            <option value="00" '.$checked1.'> Deposito Cúcuta </option>   
            <option value="DB" '.$checked2.'> Deposito Barranquilla </option>   
          </select>
        </td>        

        <td width="120"><label class="Texto11"><b>Forma Pago</b></label><br> 
				  <SELECT name="formapago" '.$bloquearfp.'> ';
					
					if($row['formapago'] == "CO")
				       $cont.='<option value="CO" selected> Contado </option>';
					else
					   $cont.='<option value="CO"> Contado </option>';   
					
					if($row['formapago'] == "CR")   
					   $cont.='<option value="CR" selected> Credito </option>';
					else
					   $cont.='<option value="CR"> Credito </option>';   

    	//// Nombre del Terceros
	   	if($row['terid1']!= 1)
	       $nombre = $clase->BDLockup($row['terid1'],'terceros','terid','CONCAT(nombres," ",apellidos)');
				  
				$cont.=' </select>
        </td>
        
				<td width="120"><label class="Texto11"><b>Vended.</b></label><br> 
				  <input type="text" onkeypress="return TabulaEnter(this, event)" class="Texto11" name="vendedor" size="5" maxlenght="10" value="'.$vendedor.'"></td>
				<td width="120"><label class="Texto11"><b>ReteFuente</b></label><br> 
				  <input type="text" onkeypress="return TabulaEnter(this, event)" class="Texto11" name="retefuente" style="text-align:right" size="10" maxlenght="10" value="'.$row['retefuente'].'" readonly></td>
				<td width="120"><label class="Texto11"><b>Descuento</b></label><br> 
				  <input type="text" onkeypress="return TabulaEnter(this, event)" class="Texto11" name="descuentogen" style="text-align:right" size="10" maxlenght="10" value="'.round($row['descuentogen'],2).'"></td> 
			  </tr></table>
			 <table width="100%">	
	          <tr class="EncabezadoDocumento">
			    <td width="10"> </td>
   				<td width="300"><label class="Texto11"><b>Proveedor</b></label><br> 

<!-- ************************************************************************************************ -->
<!-- AJAX AUTOSUGGEST SCRIPT -->
<script type="text/javascript" src="lib/ajax_framework7.js"></script>
<style type="text/css">
#search-wrap7 input{font-size:12px; text-transform:Capitalize; background-color:#D6F0FE; border-style:groove;}
#res7{width:150px; border:solid 1px #DEDEDE; display:none;}
#res7 ul, #res7 li{padding:0; margin:0; border:0; list-style:none; background:#F6F6F6;}
#res7 li {border-top:solid 1px #DEDEDE; background:#CEEAF5;}
#res7 li a{display:block; padding:2px; text-decoration:none; color:#000000; font-weight:bold; font-size:10px; font-family:Verdana;}
#res7 li a small{display:block; text-decoration:none; color:#999999; font-weight:normal; font-size:9px;font-family:Verdana;}
#res7 li a:hover{background:#FFFFFF;}
#res7 ul {padding:4px;}
</style>
<div id="search-wrap7">
<input name="cliente" onkeypress="return TabulaEnter(this, event)" id="search-q7" type="text" onkeyup="javascript:autosuggest7();" maxlength="12" size="20" autocomplete="off" tabindex="13"  value="'.$codterid1.'"/>
<div id="res7"></div>
<a href="#" OnClick="window.open(\'terceros.php?opcion=nuevorapido&docuid='.$docuid.'\',\'NuevoTer\',\'top=\'+parseInt(((screen.height) / 2) - 350)+\', width=830 ,height=600, left=\'+parseInt(((screen.width) / 2) - 350)+\', menubar=no, scrollbars=no, status=no, titlebar=no, toolbar=no,directories=no\')">
				  <img src="images/basicas/buscarcliente.png" border="0"></a>
<br><label class="Texto14"><font color="blue"><b>'.$nombre.'</b></label>
</div>
<!-- AJAX AUTOSUGGEST SCRIPT -->
<!-- ************************************************************************************************ -->

				</td>
				<td width="80" align="center">
				    <SELECT name="ordenes" class="Texto10" style="width:200px;height:45px" multiple>';
        
		  $vsql="SELECT DISTINCT CONCAT(D.tipodoc,' ',D.prefijo,' ',D.numero, ' - ',D.creador) ordenes FROM docuself DS INNER JOIN documentos D ON (DS.docuid2 = D.docuid) WHERE DS.docuid=".$docuid;
      $conex   = $clase->Conectar();
      $result2 = mysql_query($vsql,$conex);
      while($row2 = mysql_fetch_array($result2))
        $cont.='<option>'.$row2['ordenes'].'</option>';      
          
		  $cont.='</select><br><a href="?opcion=agregaroc&docuid='.$docuid.'" rel="facebox"><label class="Texto11">Ordenes Compra</label></a>
    
				<td width="20">&nbsp;</td>	
				<td width="200" align="center">	
				    <textarea name="observ" class="Texto11" cols="47" rows="4" placeholder="Observaciones y Anotaciones">'.$row['observacion'].'</textarea></td>
        <td width="10">&nbsp;</td>
        <td width="20" style="background-color:#0F3598!Important;">&nbsp;</td>
				<td width="100" style="background-color:#0F3598!Important;color:#FFFFFF;"><label class="Texto11"><b>Creado por</b></label><br> 
          <label class="Texto11">'.$row['creador']."<br>".$row['momento'].'</td>
        <td width="50">&nbsp;</td>
				<td width="150"> <label class="Texto10"> <b>Descuentos</b> (<a href="compras.php?opcion=refrescardcto&docuid='.$docuid.'">Refrescar</a>) <br>
				  <input type="text" name="dcto1" class="Texto10" size="3" style="text-align:right" value="'.$row['dcto1'].'" '.$bloqueardctos.'> 1er Dcto <br>
				  <input type="text" name="dcto2" class="Texto10" size="3" style="text-align:right" value="'.$row['dcto2'].'" '.$bloqueardctos.'> 2do Dcto <input type="checkbox" class="Texto11" name="aplicar2" value="CHECKED" '.$aplicar2.'> Aplicar <br>
				  <input type="text" name="dcto3" class="Texto10" size="3" style="text-align:right" value="'.$row['dcto3'].'" '.$bloqueardctos.'> <font color="blue"> Dcto Nota 1 <br>
                  <input type="text" name="dcto4" class="Texto10" size="3" style="text-align:right" value="'.$row['dcto4'].'" '.$bloqueardctos.'> <font color="blue"> Dcto Nota 2 </font><br>
 				</td></form>
			  </tr></table>';

        $bloquearAjustes = "";
        if($_SESSION["SUPERUSUARIO"] == "")
        {
          $mensajeBloq = '<font color="red" size="1"> Restringido >> </font>';
          $bloquearAjustes = " readonly";
        }       

        $cont.='<table width="100%">
          <tr class="EncabezadoDocumento">
            <td width="100" align="center"> '.$mensajeBloq.' </td>
            <td> Ajuste Base </td>
            <td> <input type="text" class="Texto12" size="3" name="ajustebase" id="ajustebase" value="'.$row['ajustebase'].'" OnKeyUp="PorcenAjusteBase()" '.$bloquearAjustes.'> </td>
            <td> <input type="text" class="Texto12" size="5" name="porbase" id="porbase" readonly> </td>
            <td> <b>Base </td>
            <td> <input type="text" class="Texto12" size="11" name="base" style="text-align:right;" value="'.number_format($row['base'],2).'" id="base" readonly> </td>
            <td width="100"> &nbsp; </td>
            <td> Ajuste IVA </td>
            <td> <input type="text" class="Texto12" size="3" name="ajusteiva" value="'.$row['ajusteiva'].'" id="ajusteiva" OnKeyUp="PorcenAjusteIva()" '.$bloquearAjustes.'> </td>
            <td> <input type="text" class="Texto12" size="5" name="poriva" id="poriva" readonly> </td>
            <td> <b>IVA </td>
            <td> <input type="text" class="Texto12" size="11" name="iva" id="iva" style="text-align:right;" value="'.number_format($row['iva'],2).'" readonly> </td>
            <td width="70"> &nbsp; </td>
            <td> <b>ImpoConsumo </td>
            <td> <input type="text" class="Texto12" size="10" name="impoconsumo" id="impoconsumo" style="text-align:right;" value="'.number_format($row['impoconsumo'],2).'"> </td>
            <td width="70"> &nbsp; </td>
            <td> Ajuste Neto </td>
            <td> <input type="text" class="Texto12" size="3" name="ajusteneto" value="'.$row['ajusteneto'].'" id="ajusteneto" OnKeyUp="PorcenAjusteNeto()" '.$bloquearAjustes.'> </td>
            <td> <input type="text" class="Texto12" size="5" name="porneto" id="porneto" readonly> </td>            
            <td> <b>Total </td>
            <td> <input type="text" class="Texto12" size="11" name="total" id="total" style="text-align:right;" value="'.number_format($row['total'],2).'" readonly> </td>
            <td width="100"> &nbsp; </td>
          </tr>
        </table>';	
    
	//// Lineas
	$lineas   = $clase->SeleccionarUno("SELECT COUNT(*) FROM dedocumentos WHERE docuid=".$docuid);	 
	$subtotal = $clase->SeleccionarUno("SELECT SUM(valtotal) FROM dedocumentos WHERE docuid=".$docuid);	 
	 
    //// Barra de Totales 
	$cont.='<table width="100%">
	           <tr class="CabezoteTabla"> 
			     <td width="100%" align="center">
			        <table width="96%">
					  <tr>						
              <td width="50" align="right"><label class="PuntoVentaRojo">Lineas</label><br>
                             <label class="PuntoVentaAzul"> '.number_format($lineas).'</b></label> </td>
              <td width="60">&nbsp;</td>
              <td width="80" align="right"><label class="PuntoVentarojo">Vlr Base</label><br>  
                             <label class="PuntoVentaAzul" id="vBaseId" >'.number_format(($row['base']+$row['ajustebase']),2).'</label></td>
              <td width="60">&nbsp;</td>
              <td width="80" align="right"><label class="PuntoVentarojo">Vlr IVA</label></b><br>               
                                           <label class="PuntoVentaAzul" id="vIvaId">'.number_format(($row['iva']+$row['ajusteiva']),2).'</b></label> </td>
              <td width="60">&nbsp;</td>
              <td width="80" align="right"><label class="PuntoVentarojo">Vlr ICO</label></b><br>               
                                          <label class="PuntoVentaAzul" id="vIcoId">'.number_format(($row['impoconsumo']),2).'</b></label> </td>                             
              <td width="60">&nbsp;</td>
              <td width="80" align="right"><label class="PuntoVentarojo">Sub-Total</label></b><br>             
                                           <label class="PuntoVentaAzul" id="subTotalId">'.number_format($subtotal,2).'</b></label> </td>
              <td width="60">&nbsp;</td>
              <td width="40" align="right"><label class="PuntoVentarojo">ReteFuente</label></b><br>           
                                           <label class="PuntoVentaAzul" id="subTotalId">'.number_format($row['retefuente'],2).'</b></label> </td>              
              <td width="60">&nbsp;</td>
              <td width="40" align="right"><label class="PuntoVentarojo">ReteICA</label></b><br>           
                                          <label class="PuntoVentaAzul" id="subTotalId">'.number_format($row['reteica'],2).'</b></label> </td>              
              <td width="60">&nbsp;</td>
              <td width="80" align="right"><label class="PuntoVentarojo">Total Compra</label></b><br> 
                             <label class="PuntoVentaAzul" id="vlrTotalId">'.number_format(($row['total']+$row['ajusteneto']),2).'</b></label> </td>
              <td width="10">&nbsp;</td>						
          </tr></table>  
				 <td>
	           </tr></table>';	
	 // ---------------------------------------------------------------------------------------------------------------------------------------------------------- //
	 //// Selecciono los articulos para detallarlos
     /*        
     $vsql2= "SELECT 
                DD.porciva ivadig , 
                TRIM(GP.descripcion) labo , 
                B.* , 
                DD.* , 
                COALESCE(DDO.dctol1,0) dctol1 , 
                COALESCE(DDO.dctol2,0) dctol2 , 
                COALESCE(DDO.dctol3,0) dctol3 , 
                COALESCE(DDO.dctol4,0) dctol4 , 
                P.bloqueado , 
                P.controlado , 
                P.regulado , 
                DDO.obsequio , 
                P.codigo , 
                P.descripcion , 
                P.precio1m , 
                P.precio1g , 
                P.porciva ivapro , 
                P.porcutilfijo ,
                FU_Rotacion30dias(P.productoid) rotacion , 
                (
                SELECT COALESCE(SUM(`cantidad`),0) FROM `existencias` WHERE `productoid` = P.productoid
                ) existencia                
              FROM dedocumentos DD INNER JOIN productos P ON (DD.productoid = P.productoid)
              INNER JOIN gruposprod GP ON (GP.gruposprodid = P.gruposprodid)
	            INNER JOIN bodegas B ON (B.bodegaid = DD.bodegaid) 
	            LEFT JOIN dedocuorden DDO ON (DDO.dedocumid = DD.dedocumid)
	 		        WHERE DD.docuid=".$docuid." ORDER BY DD.dedocumid DESC";	 
      */
   // ---------------------------------------------------------------------------------------------------------------------------------------------------------- //
     $vsql2= "SELECT DD.porciva ivadig , TRIM(GP.descripcion) labo , B.* , DD.* , COALESCE(DDO.dctol1,0) dctol1 , COALESCE(DDO.dctol2,0) dctol2 , 
                     COALESCE(DDO.dctol3,0) dctol3 , COALESCE(DDO.dctol4,0) dctol4 , P.bloqueado , P.controlado , P.regulado , DDO.obsequio , 
                     P.codigo , P.descripcion , P.precio1m , P.precio1g , P.porciva ivapro , P.porcutilfijo ,FU_Rotacion30dias(P.productoid) rotacion , 
                     (SELECT COALESCE(SUM(`cantidad`),0) 
                        FROM `existencias` 
                       WHERE `productoid` = P.productoid) existencia, 
                     (SELECT SUM(DDX.cantidad) 
                        FROM dedocumentos DDX 
                             INNER JOIN docuself DSX ON (DDX.docuid = DSX.docuid2) 
                       WHERE (DD.docuid = DSX.docuid AND DDX.productoid = DD.productoid)) cantiorden , 
                     (SELECT SUM(DDX.valunitario) 
                        FROM dedocumentos DDX 
                             INNER JOIN docuself DSX ON (DDX.docuid = DSX.docuid2) 
                       WHERE (DD.docuid = DSX.docuid AND DDX.productoid = DD.productoid)) valorden
                FROM dedocumentos DD 
                     INNER JOIN productos P ON (DD.productoid = P.productoid)
                     INNER JOIN gruposprod GP ON (GP.gruposprodid = P.gruposprodid)
                     INNER JOIN bodegas B ON (B.bodegaid = DD.bodegaid) 
                     LEFT JOIN dedocuorden DDO ON (DDO.dedocumid = DD.dedocumid)
               WHERE DD.docuid=".$docuid." ORDER BY DD.dedocumid DESC";                 
   // ---------------------------------------------------------------------------------------------------------------------------------------------------------- //

	 $conex2  = $clase->Conectar();  
     $result2 = mysql_query($vsql2,$conex2);
	 $registros = mysql_num_rows($result2);
	 
	 if($registros > 0)
	 {
        $i = 0;
		    $cont.='<script language="javascript">
             <!--
                function seleccionar_todo(docuid)
                { 
                  valor = document.f2.todos.checked;
                  if(valor)
                    marcartodo();
                  else
                    desmarcartodo();
                } 

                function marcartodo()
                {
                  for (i=0;i<document.f2.elements.length;i++) 
                    if(document.f2.elements[i].type == "checkbox")  
                      document.f2.elements[i].checked = 1;
                }

                function desmarcartodo()
                {
                  for (i=0;i<document.f2.elements.length;i++) 
                    if(document.f2.elements[i].type == "checkbox") 
                      document.f2.elements[i].checked = 0;
                }  

                function PorcenAjusteBase()
                {
                   var porcen = 0;
                   var base   = document.getElementById("base").value;
                   base = base.replace(",","");
                   base = base.replace(",","");
                   var basen  = base.replace(",","");
                   var ajuste = document.getElementById("ajustebase").value;
                   porcen = ((parseInt(ajuste)*100)/parseInt(basen));
                   document.getElementById("porbase").value = porcen.toFixed(2) + " %";
                }

                function PorcenAjusteIva()
                {
                   var porcen = 0;
                   var base   = document.getElementById("iva").value;
                   base = base.replace(",","");
                   base = base.replace(",","");
                   var basen  = base.replace(",","");
                   var ajuste = document.getElementById("ajusteiva").value;
                   porcen = ((parseInt(ajuste)*100)/parseInt(basen));
                   document.getElementById("poriva").value = porcen.toFixed(2) + " %";
                }

                function PorcenAjusteNeto()
                {
                   var porcen = 0;
                   var base   = document.getElementById("total").value;
                   base = base.replace(",","");
                   base = base.replace(",","");
                   var basen  = base.replace(",","");
                   var ajuste = document.getElementById("ajusteneto").value;
                   porcen = ((parseInt(ajuste)*100)/parseInt(basen));
                   document.getElementById("porneto").value =  porcen.toFixed(2) + " %";
                }

             -->
                </script>
		        <script type="text/javascript" src="lib/sorttable.js"></script>
		        <form action="compras.php?opcion=accionesmasivas" method="POST" name="f2">
                 <input type="hidden" name="docuid" value="'.$docuid.'">
			    <table width="100%" class="sortable" id="faccompra">
			     <thead> 
	              <tr class="TituloTabla" style="display:block; padding-top:10px;height:38px;"> 
                <td width="10"> </td>
                <td width="15"> </td>
                <td width="90"> C&oacute;digo <br>de Barras</td>
                <td width="185"> Producto y/o Servicio </td>    
                <td width="65"> Laboratorio </td>    
                <td width="75" align="right"> Precio<br>Base </td>
                <td width="75" align="right"> Porcen<br>Utilidad </td>
                <td width="85" align="right"> Precio<br>Minimo </td>  
                <td width="80" align="right"> Param<br>Control </td>  
                <td width="80" align="right"> Utilidad<br>Bruta </td>        
                <td width="60" align="right"> Cant </td>         
                <td width="60" align="right"> Cant<br>orden </td>         
                <td width="50" align="right"> Obse </td>  
                <td width="55" align="right"> R30 </td>           
                <td width="50" align="right"> Tiene Dias </td>
                <td width="75" align="right"> Valor<br>Unitario</td>
                <td width="75" align="right"> Valor<br>orden</td>
                <td width="60" align="right"> Valor<br>I.C.O</td>
                <td width="45" align="right"> Dto $</td>
                <td width="55" align="right"> %Iva </td>
                <td width="82" align="right"><b>Vr Base</td>
                <td width="68" align="right"><b>Vr Iva</td>
                <td width="83" align="right"><b>Vr Total</b>&nbsp;</td>
                <td width="49" align="center"> Dto 1</td>
                <td width="49" align="center"> Dto 2</td>
                <td width="49" align="center"> Dto 3</td>
                <td width="48" align="center"> Dto 4</td>
                <td width="20" align="center"> <input type="checkbox" name="todos" value="S" onClick="javascript:seleccionar_todo('.$docuid.');"> </td>
                <td width="25"> </td>
                <td width="25"> </td>
                <td width="25"> </td>          
                <td width="25"> </td>
                <td width="25"> </td>          
                <td width="5"> </td>                               
			      </tr>
			    </thead>
			  <tbody style="display:block; width:1750px; height:650px; overflow-Y:scroll">';			

		    $dcto1 = $clase->BDLockup($docuid,'docucompra','docuid','dcto1');
        $dcto2 = $clase->BDLockup($docuid,'docucompra','docuid','dcto2');
        $dcto3 = $clase->BDLockup($docuid,'docucompra','docuid','dcto3');	 	
        $dcto4 = $clase->BDLockup($docuid,'docucompra','docuid','dcto4');	
		  
      while($row2 = mysql_fetch_array($result2))
	    {
	       /// Cálculo del Precio Minimo de Venta 
           $productoid   = $row2['productoid']; 
           $valor        = (($row2['valunitario']*$row2['cantidad'])/($row2['cantidad']+$row2['obsequio']));
           $porcutilfijo = round($row2['porcutilfijo'],1);
           $costoinf     = $row2['costoinf'];
           $precio1g     = $row2['precio1g'];  
     
           $valor        = $valor-($valor*($dcto1/100));
           //$valor        = $valor-($valor*($dcto2/100));
           $valor        = $valor-($valor*($dcto3/100));
           $valor        = $valor-($valor*($dcto3/100));

           //$valor        = $valor-($valor*($row2['dctol1']/100));
           //$valor        = $valor-($valor*($row2['dctol2']/100));
           $valor        = $valor-($valor*($row2['dctol3']/100));
           $valor        = $valor-($valor*($row2['dctol4']/100));

           //$valor        = @$valor-($valor*($row2['valdescuento']/100));   
           $nprecio      = @($valor/((100-$porcutilfijo)/100));
           
           if($row2['precio1g'] < $nprecio)
		      $alertaprecio = '<b><font color="red">';
           else
              $alertaprecio = '';			   

		   if($row2['ivapro'] > 0)
		   {
		      $base       = $nprecio;
		      $coniva     = round($base + ($base*($row2['ivapro']/100)));  //12562
		      $dosultimas = substr($coniva,strlen($coniva)-2,strlen($coniva));
		      $factor     = 100-$dosultimas;
		      $aproximado = $coniva+$factor;
		      $nprecio    = $aproximado/(1+($row2['ivapro']/100));
		      $nompro     = '<font color="blue">'.substr($row2['descripcion'],0,90).'</font>';	
		   }		   
		   else
		      $nompro = substr($row2['descripcion'],0,60); 	 
		   
		       //// Calculo el Valor aprox de Precio
		       $valor        = $row2['valunitario'];
           $valor        = $valor-($valor*($dcto1/100));
           //$valor        = $valor-($valor*($dcto2/100));
           $valor        = $valor-($valor*($dcto3/100));
           $valor        = $valor-($valor*($dcto4/100));
           $valor        = $valor-($valor*($row2['valdescuento']/100));
		       $parametro = @((abs($valor-$precio1g)*100)/$precio1g);		   

           //// Calculo de la Utilidad Bruta
           $utilidad = $row2['precio1g']-$valor;
           if($utilidad>0)  $utilx = '<font color="gray">'.number_format($utilidad).'</font>';
           else             $utilx = '<font color="red">'.number_format($utilidad).'</font>';    
           
           if($row2['obsequio']>0)
              $obsequiox = number_format($row2['obsequio']);
           else
              $obsequiox = "-"; 

           $i++;
  		 
       ///Calculo el numero de dias que quedaría el producto 
       $tienepara  = @((($row2['existencia']+$row2['cantidad']+$row2['transito']+$row2['obsequio']))/($row2['rotacion']/30));  
       if($tienepara < 90)
         $tieneparax = '<font color="#8000FF">'.number_format($tienepara);
       else
         $tieneparax = '<font color="red">'.number_format($tienepara); 
      

       /// Aplico los colores de la Siguiente forma
       /// Gris - Inactivos  Verdes - Con Observacion  - Purpura Especial
       //// Resalta los Verdes que tienen ***    
       $color='<font color="black">';                         ///// Negro por Defecto 
       if($row2['enespe'] > 0)                                 ///// En Bodegas Especiales
           $color='<font color="#2E2EFE">';
       if($row2['bloqueado'] == "CHECKED")                     ///// Productos Bloqueados
           $color='<font color="GRAY">'; 
       if($row2['controlado'] == "CHECKED")                    ///// Productos Precio Regulados
           $color='<font color="BLUE">'; 
       if($row2['regulado'] == "CHECKED")                      ///// Productos Control Especial
           $color='<font color="#BF00FF">'; 
       if(substr($row2['observacion'],0,2) == "**")            ///// Productos Bonificados
           $color='<font color="#01DF3A">'; 
       if(substr($row2['observacion'],0,1) == "+")             ///// Productos Bonificado Temporalmente
           $color='<font color="orange">'; 
       if(substr($row2['observacion'],0,1) == "/")             ///// Productos Ventas Especiales
           $color='<font color="#FF33F9">'; 
       if(substr($row2['observacion'],0,1) == "?")             ///// Productos Se debe quitar Bonificado con Existencia Cero 
           $color='<font color="#B45F04">'; 


       if($i%2 == 0)
		      $cont.='<tr class="TablaDocsPar" id="'.$i.'" data-value="'.$row2['dedocumid'].'">';
		   else
		      $cont.='<tr class="TablaDocsImPar" id="'.$i.'" data-value="'.$row2['dedocumid'].'">';

		   $cont.=' <td width="10">&nbsp;</td> 
		            <td width="15">'.$i.'</td>
		            <td width="90"><input type="text" class="Texto10" size="11" value="'.$row2['codigo'].'"></td>
		            <td width="190"> <a href="productos.php?opcion=detalles&productoid='.$row2['productoid'].'" target="_blank"> '.$color.' '.$nompro.' </font> </a> </td>
		            <td width="90" align="center"><b>'.$color.''.substr($row2['labo'],0,12).'</b> </td>
      					<td width="80" align="right">'.$color.''.$alertaprecio.number_format($row2['precio1g']).'</td>
      					<td width="90" align="right"><font color="blue">'.$color.''.number_format($row2['porcutilfijo'],1).' %</td>
      					<td width="95" align="right">'.$color.''.$alertaprecio.number_format($nprecio,2).'</td>
      					<td width="90" align="right"> <font color="blue">'.$alertaprecio.number_format($parametro,1).' %</td>
      					<td width="90" align="right">'.$color.''.$utilx.'</td>					
      					<td width="80" align="right" id="cantidadId'.$i.'">'.number_format($row2['cantidad'],2).'</td>	
                <td width="80" align="right" id="cantidadOrden'.$i.'">'.number_format($row2['cantiorden'],2).'</td>                  
      					<td width="80" align="right" id="obsequioId'.$i.'"> <font color="red">'.$obsequiox.'</font></td>					
                <td width="60" align="right"> <font color="gray">'.number_format($row2['rotacion']).' </font></td>  
                <td width="60" align="right"> <b> '.$tieneparax.' </font></td>  
                <td width="85" align="right" class="estilovalor" id="vunit'.$i.'">'.number_format($row2['valunitario'],1).'</td>
                <td width="85" align="right" class="estilovalor" id="vunitOrden'.$i.'">'.number_format($row2['valorden'],1).'</td>
                <td width="80" align="right" > <font color="gray">'.number_format($row2['valico'],1).'</td>
      					<td width="60" align="right">'.$color.' <input type="text" class="Texto11" style="background-color:lightyellow; text-align:right;" size="6" value="'.number_format($row2['valdescuento'],1).'" readonly> </td>					
      					<td width="70" align="right">'.number_format($row2['ivadig'],1).'</td>
      					<td width="70" align="right" id="valbase'.$i.'" class="azul"> '.number_format($row2['valbase'],2).'</b></td>		
      					<td width="70" align="right" id="valiva'.$i.'"> '.number_format($row2['valiva'],1).'</b></td>		
      					<td width="85" align="right" class="estilovalor" id="valtotal'.$i.'"><b>'.number_format($row2['valtotal'],2).'</b></td>										
      					<td width="50" align="right"> <input type="text" class="Texto11" style="background-color:lightblue; text-align:center;" size="3" value="'.number_format($row2['dctol1'],1).'" readonly> </td>
      					<td width="50" align="right"> <input type="text" class="Texto11" style="background-color:lightblue; text-align:center;" size="3" value="'.number_format($row2['dctol2'],1).'" readonly> </td>
      					<td width="50" align="right"> <input type="text" class="Texto11" style="background-color:lightgreen; text-align:center;" size="3" value="'.number_format($row2['dctol3'],1).'" readonly> </td>
      					<td width="50" align="right"> <input type="text" class="Texto11" style="background-color:lightgreen; text-align:center;" size="3" value="'.number_format($row2['dctol4'],1).'" readonly> </td>
                <td width="23" align="center"> <input type="checkbox" class="Texto11" name="LIN-'.$row2['dedocumid'].'" value="S"> </td>
                <td width="23" align="center"><a href="#" OnClick="window.open(\'exipublica.php?codproducto='.$row2['codigo'].'\',\'ConsuExi\',\'width=650,height=720\');">
                    <img src="images/basicas/existencias.png" border="0"></a></td>         
                <td width="23" align="center"><a href="productos.php?opcion=rotaciondrog&id='.$row2['productoid'].'" target="_blank">
                    <img src="images/basicas/rotacion.png" border="0"></a></td>                                          
                <td width="23" align="center"><a href="productos.php?opcion=proveedores&id='.$row2['productoid'].'" target="_blank">
                    <img src="images/basicas/estacompras.png" border="0" title="Estadisticas de Compras"></a></td>
                <!-- ------------------------------------------------------------------------------------------------------------------- -->    
                <!--
      					<td width="23" align="center"><a href="?opcion=borraritem&docuid='.$row2['docuid'].'&dedocumid='.$row2['dedocumid'].'">
      					                               <img src="images/basicas/iconoborrar.png" border="0"></a></td>							 	 				 					
                -->
                <!-- ------------------------------------------------------------------------------------------------------------------- -->    
                <td width="23" align="center"><a href="?opcion=confirmacioborraritem&docuid='.$row2['docuid'].'&dedocumid='.$row2['dedocumid'].'" rel="facebox">
                                               <img src="images/basicas/iconoborrar.png" border="0"></a></td>
                <!-- ------------------------------------------------------------------------------------------------------------------- -->    
      					<td width="23" align="center"><a href="?opcion=editaritem&docuid='.$row2['docuid'].'&dedocumid='.$row2['dedocumid'].'" rel="facebox">
      					                               <img src="images/basicas/iconobuscar.png" border="0"></a></td>							 	 				 					
      					<td width="5"> </td>';
	      
		  $cont.='</tr>';   				  
	    }		  

        $cont.='</tbody></table>
  
            <script
  src="http://code.jquery.com/jquery-3.1.1.min.js"
  integrity="sha256-hVVnYaiADRTO2PzUGmuLJr8BLUSjGIZsDYGmIJLv2b8="
  crossorigin="anonymous"></script>

      <script
  src="http://code.jquery.com/ui/1.12.1/jquery-ui.min.js"
  integrity="sha256-VazP97ZCwtekAsvgPBSUwPFKdrwD3unUfSGVYrahUqU="
  crossorigin="anonymous"></script>

             <script>
              establecerTabla("faccompra");
              
              highLightElement("vBaseId", "rgba(35, 133, 255, 0.6)" );
              highLightElement("vIvaId", "rgba(35, 133, 255, 0.6)" );
              highLightElement("subTotalId", "rgba(35, 133, 255, 0.6)" );
              highLightElement("vlrTotalId", "rgba(35, 133, 255, 0.6)" );
              
              establecerTriggerDeFila("vunit", "valbase,valiva,valtotal,G_vBaseId,G_vIvaId,G_subTotalId,G_vlrTotalId","compras.php?opcion=actualizarvalor&id=");
             
              establecerTriggerDeFila("cantidadId", "vunit,valbase,valiva,valtotal,G_vBaseId,G_vIvaId,G_subTotalId,G_vlrTotalId","compras.php?opcion=actualizarcantidad&id=");

              establecerTriggerDeFila("obsequioId", "vunit,valbase,valiva,valtotal,G_vBaseId,G_vIvaId,G_subTotalId,G_vlrTotalId","compras.php?opcion=actualizarObsequio&id=");
              
            </script> 

              <br><center><a href="#" OnClick="f2.submit();"><input type="button" class="button blue" value="eliminar masivamente los elementos seleccionados"></a></form>';

	 } /// Si hay articulos 
	 
	} /// 
	echo $cont; exit();
  } //// Fin del Agregar Detalle 

  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "crear")
  {
      $docuid   = $_GET['docuid'];
      $clase->EjecutarSQL("CALL PA_CalVAloresFCO(".$docuid.")");
      $tienerem = 0 + $clase->SeleccionarUno("SELECT COUNT(*) FROM docucompra WHERE docuid=".$docuid);

      if($tienerem>0)
      {
          $vsql4 = "INSERT INTO docucompra(docuid,dcto1,dcto2,dcto3,dcto4) VALUES('".$docuid."',0,0,0,0)";
          $clase->EjecutarSQL($vsql4); 
      }
      
      header("Location: compras.php?opcion=crearimportar&docuid=".$docuid);    
  }      

  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "crearn")
  {
	 $docuid = $_GET['docuid'];
	 $fecasentado = $clase->BDLockup($docuid,"documentos","docuid","fecasentado");
	 if($fecasentado != "0000-00-00")
     {
         $clase->Aviso(3,"Documento se encuentra Cerrado");
         header("Location: compras.php");
         exit();
     } 

	 $vsql   = "SELECT * FROM documentos D LEFT JOIN docucompra DC ON (D.docuid = DC.docuid) WHERE D.docuid=".$docuid;
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);

	 if($row = mysql_fetch_array($result)) 
	 {
	  $cont = $clase->Header("S","W");
      $cont.= Javascript();		 
	  
	  $bodegapredet = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS'],'bodegas','codbodega','bodegaid');

	  if($row['terid1'] != 1)
	    $codterid1 = $clase->BDLockup($row['terid1'],'terceros','terid','dni');

	  if($row['terid2'] != 1)
	    $vendedor = $clase->BDLockup($row['terid2'],'terceros','terid','dni');
	  
	  $fecha  = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);
	  $fechav = substr($row['fecvence'],8,2)."/".substr($row['fecvence'],5,2)."/".substr($row['fecvence'],0,4);
	  $diferencia = @(strtotime($row['fecvence'])-strtotime($row['fechadoc']));
	  $dias=@intval($diferencia/60/60/24);
	  
	  $cont.='<form name="x" action="?opcion=guardarencab" method="POST">
	          <input type="hidden" name="docuid" value="'.$docuid.'">
			  <table width="100%">
	           <tr class="CabezoteTabla"> 
			     <td width="10"> </td>
			     <td width="37"> <img src="images/iconos/cotizacion.png" width="32" height="32" border="0"> </td>
				 <td width="670"><b> Facturas de Compra </b><td>';

	  if(($_SESSION['USERNAME'] == "J.DURAN")||($_SESSION['USERNAME'] == "ADMIN"))	
	  {		 
         $cont.='<td width="40" align="center"><a href="?opcion=importarpro&docuid='.$docuid.'" rel="facebox">
				                               <img src="images/iconos/descargar.png" title="Importar Productos" border="0" width="28" height="28"></a></td>';
    }
    $cont.='<!--  
            <td width="40" align="center"><a href="?opcion=anular&docuid='.$docuid.'">
				    <img src="images/iconos/anulardoc.png" title="Anular Documento" border="0" width="28" height="28"></a></td>
            -->
            <td width="40" align="center"><a href="?opcion=confirmacionanular&docuid='.$docuid.'" rel="facebox">
            <img src="images/iconos/anulardoc.png" title="Anular Documento" border="0" width="28" height="28"></a></td>
            <!--
            <td width="40" align="center"><a href="?opcion=eliminar&docuid='.$docuid.'">
				    <img src="images/iconos/eliminardoc.png" title="Eliminar Documento" border="0" width="28" height="28"></a></td>
            -->
            <td width="40" align="center"><a href="?opcion=confirmacioneliminar&docuid='.$docuid.'" rel="facebox">
            <img src="images/iconos/eliminardoc.png" title="Eliminar Documento" border="0" width="28" height="28"></a></td>
            <td width="40" align="center"><a href="?opcion=imprimir&docuid='.$docuid.'" target="_blank">				 
				    <img src="images/iconos/imprimirdoc.png" title="Imprimir Documento" border="0" width="30" height="30"></a></td>
            <td width="40" align="center"><a href="?opcion=enviarmail&docuid='.$docuid.'" rel="facebox"> 
				    <img src="images/iconos/enviarmaildoc.png" title="Enviar por E-mail" border="0" width="30" height="30"></a></td>
            <td width="40" align="center"><a href="#" OnClick="x.submit();"> 
				    <img src="images/iconos/guardardoc.png" title="Guardar Documento" border="0" width="28" height="28"></a></td>
            <td width="40" align="center"><a href="?opcion=pre-asentar&docuid='.$docuid.'">
				    <img src="images/iconos/cerrar.png" title="Cerrar Documento" border="0" width="28" height="28"></a></td>
            <td width="40" align="center"><a href="?opcion=digitalizar&docuid='.$docuid.'" rel="facebox">
				                               <img src="images/iconos/digitalizar.png" title="Soporte Digital" border="0" width="28" height="28"></a></td>											   
				 <td><a href="compras.php"><input type="button" value="<<" class="button"></a></td>    		     
				 <td width="8"> </td>
			   </tr>	 			   
			 </table> 
			 <table width="100%">	
	          <tr class="EncabezadoDocumento">
			    <td width="10"> </td>
			    <td width="300"><label class="Texto11"><b>N&uacute;mero Documento</b></label><br>
				 <b>'.$row['tipodoc'].'</b>
				 <input type="text" onkeypress="return TabulaEnter(this, event)" class="Texto11" name="prefijo" size="3" maxlenght="3" style="text-align:center" value="'.$row['prefijo'].'">
				 <input type="text" onkeypress="return TabulaEnter(this, event)" class="Texto11" name="numero" size="5" maxlenght="3" value="'.$row['numero'].'" readonly></td>

				<td width="150"><label class="Texto11"><b>No. Doc Proveed</b></label><br> 
				  <input type="text" onkeypress="return TabulaEnter(this, event)" class="Texto11" name="nrodocref" size="15" maxlenght="10" value="'.$row['nrodocref'].'"></td>
				<td width="30" align="left"><label class="Texto11"><b>&nbsp;Dias</b></label><br> 
				  <input type="text" onkeypress="return TabulaEnter(this, event)" class="Texto11" name="dias" size="2" maxlenght="10" value="'.$dias.'"></td>
				<td width="150"><label class="Texto11"><b>Fecha Recibido</b></label><br> 
				  <input type="text" onkeypress="return TabulaEnter(this, event)" class="Texto11" name="fecha" size="12" maxlenght="10" value="'.$fecha.'"  onClick="popUpCalendar(this, x.fecha,\'dd/mm/yyyy\');"></td>			<td width="150"><label class="Texto11"><b>Fecha Vencim</b></label><br> 
				  <input type="text" onkeypress="return TabulaEnter(this, event)" class="Texto11" name="fecvence" size="12" maxlenght="10" value="'.$fechav.'"></td>
				<td width="150"><label class="Texto11"><b>Forma Pago</b></label><br> 
				  <SELECT name="formapago"> ';
					
					if($row['formapago'] == "CO")
				       $cont.='<option value="CO" selected> Contado </option>';
					else
					   $cont.='<option value="CO"> Contado </option>';   
					
					if($row['formapago'] == "CR")   
					   $cont.='<option value="CR" selected> Credito </option>';
					else
					   $cont.='<option value="CR"> Credito </option>';   

    	//// Nombre del Terceros
		if($row['terid1']!= 1)
	       $nombre = $clase->BDLockup($row['terid1'],'terceros','terid','CONCAT(nombres," ",apellidos)');
				  
				$cont.=' </select>
				</td>
				<td width="120"><label class="Texto11"><b>Vended.</b></label><br> 
				  <input type="text" onkeypress="return TabulaEnter(this, event)" class="Texto11" name="vendedor" size="5" maxlenght="10" value="'.$vendedor.'"></td>
				<td width="120"><label class="Texto11"><b>ReteFuente</b></label><br> 
				  <input type="text" onkeypress="return TabulaEnter(this, event)" class="Texto11" name="retefuente" style="text-align:right" size="10" maxlenght="10" value="'.$row['retefuente'].'"></td>
				<td width="120"><label class="Texto11"><b>Descuento</b></label><br> 
				  <input type="text" onkeypress="return TabulaEnter(this, event)" class="Texto11" name="descuentogen" style="text-align:right" size="10" maxlenght="10" value="'.round($row['descuentogen'],2).'"></td> 
			  </tr></table>
			 <table width="100%">	
	          <tr class="EncabezadoDocumento">
			    <td width="10"> </td>
   				<td width="300"><label class="Texto11"><b>Proveedor</b></label><br> 

<!-- ************************************************************************************************ -->
<!-- AJAX AUTOSUGGEST SCRIPT -->
<script type="text/javascript" src="lib/ajax_framework7.js"></script>
<style type="text/css">
#search-wrap7 input{font-size:12px; text-transform:Capitalize; background-color:#D6F0FE; border-style:groove;}
#res7{width:150px; border:solid 1px #DEDEDE; display:none;}
#res7 ul, #res7 li{padding:0; margin:0; border:0; list-style:none; background:#F6F6F6;}
#res7 li {border-top:solid 1px #DEDEDE; background:#CEEAF5;}
#res7 li a{display:block; padding:2px; text-decoration:none; color:#000000; font-weight:bold; font-size:10px; font-family:Verdana;}
#res7 li a small{display:block; text-decoration:none; color:#999999; font-weight:normal; font-size:9px;font-family:Verdana;}
#res7 li a:hover{background:#FFFFFF;}
#res7 ul {padding:4px;}
</style>
<div id="search-wrap7">
<input name="cliente" onkeypress="return TabulaEnter(this, event)" id="search-q7" type="text" onkeyup="javascript:autosuggest7();" maxlength="12" size="25" autocomplete="off" tabindex="13"  value="'.$codterid1.'"/>
<div id="res7"></div>
<a href="#" OnClick="window.open(\'terceros.php?opcion=nuevorapido&docuid='.$docuid.'\',\'NuevoTer\',\'top=\'+parseInt(((screen.height) / 2) - 350)+\', width=830 ,height=600, left=\'+parseInt(((screen.width) / 2) - 350)+\', menubar=no, scrollbars=no, status=no, titlebar=no, toolbar=no,directories=no\')">
				  <img src="images/basicas/buscarcliente.png" border="0"></a>
&nbsp;<label class="Texto10"><b>'.$nombre.'</b></label>
</div>
<!-- AJAX AUTOSUGGEST SCRIPT -->
<!-- ************************************************************************************************ -->

				</td>
				<td width="80" align="center">
				    <SELECT name="ordenes" class="Texto10" style="width:200px;height:45px" multiple>';
        
		$vsql="SELECT CONCAT(D.tipodoc,' ',D.prefijo,' ',D.numero,' - ',D.creador) ordenes FROM docuself DS INNER JOIN documentos D ON (DS.docuid2 = D.docuid) WHERE DS.docuid=".$docuid;
	    $conex   = $clase->Conectar();
        $result2 = mysql_query($vsql,$conex);
        while($row2 = mysql_fetch_array($result2))
	      $cont.='<option>'.$row2['ordenes'].'</option>';
		
		$cont.='</select><br><a href="?opcion=agregaroc&docuid='.$docuid.'" rel="facebox"><label class="Texto11">Ordenes Compra</label></a>
		
				<td width="20">&nbsp;</td>	
				<td width="200" align="center">	
				    <textarea name="observ" class="Texto11" cols="47" rows="4" placeholder="Observaciones y Anotaciones">'.$row['observacion'].'</textarea></td>
				<td width="10">&nbsp;</td>
				<td width="180"><label class="Texto11"><b>Creado por</b></label><br> 
				  <label class="Texto11">'.$row['creador']."<br>".$row['momento'].'</td>
				<td width="150"> <label class="Texto10"> <b>Descuentos</b> (<a href="compras.php?opcion=refrescardcto&docuid='.$docuid.'">Refrescar</a>) <br>
				  <input type="text" name="dcto1" class="Texto10" size="3" style="text-align:right" value="'.$row['dcto1'].'" readonly> 1er Dcto <br>
				  <input type="text" name="dcto2" class="Texto10" size="3" style="text-align:right" value="'.$row['dcto2'].'" readonly> 2do Dcto <br>
				  <input type="text" name="dcto3" class="Texto10" size="3" style="text-align:right" value="'.$row['dcto3'].'" readonly> <font color="blue"> Dcto Nota 1 <br>
                  <input type="text" name="dcto4" class="Texto10" size="3" style="text-align:right" value="'.$row['dcto4'].'" readonly> <font color="blue"> Dcto Nota 2 </font><br>
 				</td></form>
			  </tr></table>';	
    
	//// Lineas
	$lineas   = $clase->SeleccionarUno("SELECT COUNT(*) FROM dedocumentos WHERE docuid=".$docuid);	 
	$subtotal = $clase->SeleccionarUno("SELECT SUM(valtotal) FROM dedocumentos WHERE docuid=".$docuid);	 
	 
    //// Barra de Totales 
	$cont.='<table width="100%">
	           <tr class="CabezoteTabla"> 
			     <td width="100%" align="center">
			        <table width="96%">
					  <tr>
                        <td width="5">&nbsp;</td>						
					    <td width="30"><label class="PuntoVentaRojo">Cant<br>Linea</label></b></td>
					    <td width="30" align="right"><label class="PuntoVentaAzul">'.number_format($lineas).'</b></label> </td>
                        <td width="30">&nbsp;</td>
					    <td width="70"><label class="PuntoVentarojo">Vlr<br>Base</label></b></td>
					    <td width="85" align="right"><label class="PuntoVentaAzul">'.number_format($row['base'],2).'</b></label> </td>
                        <td width="60">&nbsp;</td>
					    <td width="65"><label class="PuntoVentarojo">Vlr<br>IVA</label></b></td>
					    <td width="75" align="right"><label class="PuntoVentaAzul">'.number_format($row['iva'],2).'</b></label> </td>
                        <td width="50">&nbsp;</td>
					    <td width="60"><label class="PuntoVentarojo">Sub-<br>Total</label></b></td>
					    <td width="100" align="right"><label class="PuntoVentaAzul">'.number_format($subtotal).'</b></label> </td>
                        <td width="50">&nbsp;</td>
					    <td width="60"><label class="PuntoVentarojo">Total<br>Compra</label></b></td>
					    <td width="100" align="right"><label class="PuntoVentaAzul">'.number_format($row['total']).'</b></label> </td>
                        <td width="10">&nbsp;</td>						
                     </tr></table>  
				 <td>
	           </tr></table>';	
	
	$cont.='<form action="?opcion=agregardetalle" method="POST" name="y">
	         <input type="hidden" name="docuid" value="'.$docuid.'">'; 

	//// Busqueda e Insercion de Productos a la Cotizacion
    $cont.='<table width="100%">	
	          <tr class="EncabezadoDocumento2">
			    <td width="10"> </td>
   				<td width="650"><label class="Texto11"><b>Producto</b></label><br> 
     
<!-- ************************************************************************************************ -->
<!-- AJAX AUTOSUGGEST SCRIPT -->
<script type="text/javascript" src="lib/ajax_framework8.js"></script>
<style type="text/css">
#search-wrap8 input{font-size:12px; text-transform:Capitalize; background-color:#D6F0FE; border-style:groove;}
#res8{width:195px; border:solid 1px #DEDEDE; display:none;}
#res8 ul, #res8 li{padding:0; margin:0; border:0; list-style:none; background:#F6F6F6;}
#res8 li {border-top:solid 1px #DEDEDE; background:#CEEAF5;}
#res8 li a{display:block; padding:2px; text-decoration:none; color:#000000; font-weight:bold; font-size:10px; font-family:Verdana;}
#res8 li a small{display:block; text-decoration:none; color:#999999; font-weight:normal; font-size:9px;font-family:Verdana;}
#res8 li a:hover{background:#FFFFFF;}
#res8 ul {padding:4px;}
</style>
<div id="search-wrap8">
<input name="producto" autocomplete="off" onkeypress="return TabulaEnter(this, event)" id="search-q8" type="text" onkeyup="javascript:autosuggest8();" maxlength="33" size="23" autocomplete="off" tabindex="1"/>
<div id="res8"></div>
</div>
<!-- AJAX AUTOSUGGEST SCRIPT -->
<!-- ************************************************************************************************ -->';
    
    $cont.='    </td>
				<td width="60" align="right"> <label class="Texto11"> <b>Cajas</b> </label> <br>
				 <input type="text" name="cantidad" autocomplete="off" onkeypress="return TabulaEnter(this, event)" onkeyUp="CalcularValores()" style="text-align:right" maxlenght="5" size="5" class="Texto11"></td>
				<td width="70" align="right"> <label class="Texto11"> <b>Unids</b> </label> <br>
				 <input type="text" name="unidades" autocomplete="off" onkeypress="return TabulaEnter(this, event)" onkeyUp="CalcularValores()" style="text-align:right" maxlenght="5" size="6" class="Texto11" value="0"></td>
				<td width="20" align="right">&nbsp;</td>';
		
	$cont.='    <td width="80" align="right"> <label class="Texto11"> <b>Vlr Unitario</b> </label> <br>
				 <input type="text" name="precio" autocomplete="off" onkeypress="return TabulaEnter(this, event)" onkeyUp="return CalcularValores()" style="text-align:right" maxlenght="10" size="10" class="Texto11"></td>
				<td width="20" align="right">&nbsp;</td> 
				<td width="80" align="right"> <label class="Texto11"> <b>% I.V.A.</b> </label> <br>
				 <input type="text" name="iva" autocomplete="off" onkeypress="return TabulaEnter(this, event)" onkeyUp="return CalcularValores()" style="text-align:right" maxlenght="5" size="5" value="0" class="Texto11"></td><td width="20" align="right">&nbsp;</td> 
				<td width="80" align="right"> <label class="Texto11"> <b>% DCTO</b> </label> <br>
				 <input type="text" name="descuento" autocomplete="off" onkeypress="return TabulaEnter(this, event)" onkeyUp="return CalcularValores()" style="text-align:right" maxlenght="5" size="6" class="Texto11" value="0"></td><td width="20" align="right">&nbsp;</td>
                <td width="80" align="right"> <label class="Texto11"> <b>DCTO 2</b> </label> <br>
				 <input type="text" name="descuento2" autocomplete="off" onkeypress="return TabulaEnter(this, event)" onkeyUp="return CalcularValores()" style="text-align:right" maxlenght="5" size="6" class="Texto11" value="0"></td><td width="20" align="right">&nbsp;</td>				 
				<td width="80" align="right"> <label class="Texto11"> <b>SubTotal</b> </label> <br>
				 <input type="text" onkeypress="return TabulaEnter(this, event)" class="CajaEspecial" style="text-align:right" name="total" maxlenght="5" size="12" class="Texto11" readonly> </td> 
				<td width="10"></td>				
                <td width="60" align="center"> <input type="submit" name="submit" value="Adicionar" class="button blue"></form></td>				
				<td width="5"></td>				
			</tr></table>
			<script language="javascript">
			  <!-- 
			   analizarfoco();
			  -->
			</script>';
   	 
	 //// Selecciono los articulos para detallarlos
     $vsql2= "SELECT DD.porciva ivadig , B.* , DD.* , P.codigo , P.descripcion , P.precio1m , P.precio1g , P.porciva ivapro , P.porcutilfijo 
              FROM dedocumentos DD INNER JOIN productos P ON (DD.productoid = P.productoid)
	            INNER JOIN bodegas B ON (B.bodegaid = DD.bodegaid) 
	 		        WHERE DD.docuid=".$docuid." ORDER BY DD.dedocumid DESC";	 
	 $conex2  = $clase->Conectar();
     $result2 = mysql_query($vsql2,$conex2);
	 $registros = mysql_num_rows($result2);
	 
	 if($registros > 0)
	 {
        $i = 0;
		    $cont.='<script type="text/javascript" src="lib/sorttable.js"></script> 
                 <table width="100%" class="sortable">
                  <thead> 
                    <tr class="TituloTabla" style="display:block;padding-top:5px;height:12px;"> 
                    <td width="5"> </td>
                    <td width="90"> C&oacute;digo <br>de Barras</td>
                    <td width="220"> Producto y/o Servicio </td>	
                    <td width="5"> </td>		
                    <td width="80" align="right"> Precio<br>Base </td>
                    <td width="70" align="right"> Porcen<br>Utilidad </td>
                    <td width="75" align="right"> Precio<br>Minimo </td>	
                    <td width="70" align="right"> Param<br>Control </td>	
                    <td width="70" align="right"> Utilidad<br>Bruta </td>				 
                    <td width="60" align="right"> Cant </td>				 
                    <td width="80" align="right"> Valor<br>Unitario</td>
                    <td width="50" align="right"> Dto </td>
                    <td width="60" align="right"> Iva </td>
                    <td width="105" align="right"><b>Valor<br>Total</b></td>
                    <td width="30"> </td>
                    <td width="30"> </td> 				 
                    <td width="5"> </td>				 				 
                  </tr>
                </thead>
              <tbody style="display:block; width:1050px; height:690px; overflow-Y:scroll">';			

		    $dcto1 = $clase->BDLockup($docuid,'docucompra','docuid','dcto1');
        $dcto2 = $clase->BDLockup($docuid,'docucompra','docuid','dcto2');
        $dcto3 = $clase->BDLockup($docuid,'docucompra','docuid','dcto3');	 	
		    while($row2 = mysql_fetch_array($result2))
	      {
	         /// Cálculo del Precio Minimo de Venta 
           $productoid   = $row2['productoid']; 
           $valor        = $row2['valunitario'];
           $porcutilfijo = round($row2['porcutilfijo'],1);
           $costoinf     = $row2['costoinf'];
           $precio1g     = $row2['precio1g'];  
     
           $valor        = $valor-($valor*($dcto1/100));
           $valor        = $valor-($valor*($dcto2/100));
           $valor        = $valor-($valor*($dcto3/100));
           $valor        = @$valor-($valor*($row2['valdescuento']/100));   
           $nprecio      = @($valor/((100-$porcutilfijo)/100));
           
           if($row2['precio1g'] < $nprecio)
		          $alertaprecio = '<b><font color="red">';
           else
              $alertaprecio = '';			   

		       if($row2['ivapro'] > 0)
		          $nompro = '<font color="blue">'.substr($row2['descripcion'],0,35).'</font>';
		       else
		          $nompro = substr($row2['descripcion'],0,30); 	 
		   
		       //// Calculo el Valor aprox de Precio
		       $valor        = $row2['valunitario'];
           $valor        = $valor-($valor*($dcto1/100));
           $valor        = $valor-($valor*($dcto2/100));
           $valor        = $valor-($valor*($dcto3/100));
           $valor        = $valor-($valor*($row2['valdescuento']/100));
		       $parametro = @((abs($valor-$precio1g)*100)/$precio1g);		   

           //// Calculo de la Utilidad Bruta
           $utilidad = $row2['precio1g']-$valor;
           if($utilidad>0)  $utilx = '<font color="gray">'.number_format($utilidad).'</font>';
           else             $utilx = '<font color="red">'.number_format($utilidad).'</font>';    
           
           ///// Aplico las convenciones de Colores
           $i++;
       
           if($i%2 == 0)
              $cont.='<tr class="TablaDocsPar">';
           else
              $cont.='<tr class="TablaDocsImPar">';
        
          $cont.=' <td width="5"> </td> 
		            <td width="80"><input type="text" class="Texto10" size="11" value="'.$row2['codigo'].'"></td>
		            <td width="250"> <a href="productos.php?opcion=detalles&productoid='.$row2['productoid'].'" target="_blank"> <font color="black"> '.$nompro.' </font> </a> </td>
                <td width="10"> &nbsp;&nbsp;&nbsp; </td>
                <td width="85" align="right">'.$alertaprecio.number_format($row2['precio1g']).'</td>
                <td width="85" align="right"><font color="blue">'.number_format($row2['porcutilfijo'],1).' %</td>
                <td width="85" align="right">'.$alertaprecio.number_format($nprecio).'</td>
                <td width="90" align="right"> <font color="blue">'.$alertaprecio.number_format($parametro,2).' %</td>
                <td width="75" align="right">'.$utilx.'</td>					
                <td width="70" align="right"> '.number_format($row2['cantidad']).'</td>					
                <td width="85" align="right"><b>'.number_format($row2['valunitario'],2).' </b></td>
                <td width="65" align="right">'.number_format($row2['valdescuento'],2).'</td>					
                <td width="75" align="right">'.number_format($row2['ivadig'],2).'</td>
                <td width="105" align="right"><b>'.number_format($row2['valtotal'],2).'</b></td>		
                <!-- ------------------------------------------------------------------------------------------------------------------------------- -->
                <!--								
                <td width="30" align="center"><a href="?opcion=borraritem&docuid='.$row2['docuid'].'&dedocumid='.$row2['dedocumid'].'">
                                              <img src="images/basicas/iconoborrar.png" border="0"></a></td>							 	 				 					
                -->
                <!-- ------------------------------------------------------------------------------------------------------------------------------- -->
                <td width="30" align="center"><a href="?opcion=confirmacioborraritem&docuid='.$row2['docuid'].'&dedocumid='.$row2['dedocumid'].'" rel="facebox">
                                              <img src="images/basicas/iconoborrar.png" border="0"></a></td>                                                  
                <!-- ------------------------------------------------------------------------------------------------------------------------------- -->
                <td width="30" align="center"><a href="?opcion=editaritem&docuid='.$row2['docuid'].'&dedocumid='.$row2['dedocumid'].'" rel="facebox">
                                              <img src="images/basicas/iconobuscar.png" border="0"></a></td>							 	 				 					
                <td width="5"> </td>';
	      
		  $cont.='</tr>';   				  
	    }		  

        $cont.='</tbody></table>';

	 } /// Si hay articulos 
	 
	} /// 
	
  } //// Fin del Agregar Detalle 
  
    /////////////////////////////////////////  
  if($opcion == "ordenar")
  {
    $campo = $_GET['campo'];
	
	if($campo == "documento")  $order="D.tipodoc ASC , D.prefijo DESC , D.numero DESC";
	if($campo == "fecha")      $order="D.fechadoc DESC";
	if($campo == "hora")       $order="D.fechadoc DESC";
	if($campo == "proveedor")  $order="T.nombres ASC";	
    if($campo == "lineas")     $order="lineas ASC";	
    if($campo == "sucursal")   $order="S.descripcion ASC";		
    if($campo == "nrofacpro")  $order="D.nrodocref DESC";		
    if($campo == "creador")    $order="D.creador ASC";				
    if($campo == "total")      $order="D.total DESC";						
	
	  	$vsql = "SELECT D.* , T.nombres , T.apellidos , D.nrodocref , S.descripcion nomsucursal , 
				 (SELECT COUNT(*) FROM dedocumentos WHERE docuid = D.docuid) as lineas 
				 FROM documentos D 
				 INNER JOIN sucursales S ON (D.sucursalid = S.sucursalid) 
				 INNER JOIN terceros T ON (T.terid = D.terid1) 
				 WHERE D.tipodoc = 'FCO' ORDER BY ".$order." limit 0,".$_SESSION["NUMREGISTROSXCONSULTA"];
			 
	$_SESSION['SQL_COMPRAS'] = $vsql;
	header("Location: compras.php");
  }

  //////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "encontrar")
  {
    $criterio  = $_POST['criterio'];
	  $arreglado = str_replace(" ","%",$criterio);
  	$criterio = $arreglado;
  	$vsql = "SELECT D.* , T.nombres , T.apellidos , D.nrodocref , S.descripcion nomsucursal , 
			 (SELECT COUNT(*) FROM dedocumentos WHERE docuid = D.docuid) as lineas , 
			 (
			   SELECT CONCAT(prefijo,' ',numero) FROM documentos OC INNER JOIN docuself DS ON(DS.docuid2 = OC.docuid) WHERE DS.docuid = D.docuid limit 0,1
			 ) orden , 
       (SELECT CONCAT(docuid,'|',saldo) FROM documentos WHERE tipodoc = 'CXP' AND prefijo = D.prefijo AND numero = D.numero) saldo ,
       (SELECT COUNT(*) FROM logcambios WHERE campo = 'docuid' AND valor = D.docuid) novedades , 
       (SELECT codigo FROM sucursales WHERE sucursalid = D.sucursalid) sucursal 
			 FROM documentos D 
			 INNER JOIN sucursales S ON (D.sucursalid = S.sucursalid) 
			 INNER JOIN terceros T ON (T.terid = D.terid1) 
			 WHERE D.tipodoc = 'FCO' AND (D.nrodocref LIKE '%".$criterio."%' OR 
			 T.nombres like '%".$criterio."%' OR T.apellidos like '%".$criterio."%' OR D.numero like '%".$criterio.
			 "%' OR S.descripcion like '%".$criterio."%') ORDER BY D.tipodoc , D.prefijo , D.numero DESC limit 0,".$_SESSION["NUMREGISTROSXCONSULTA"];
	  $_SESSION['SQL_COMPRAS'] = $vsql;
    header("Location: compras.php");
  }

  /////////////////////////////////////////  
  if($opcion == "nofiltro")
  {
  	$vsql = "SELECT D.* , T.nombres , T.apellidos , D.nrodocref , S.descripcion nomsucursal , 
				 (SELECT COUNT(*) FROM dedocumentos WHERE docuid = D.docuid) as lineas , 
				 (
				   SELECT CONCAT(prefijo,' ',numero) FROM documentos OC INNER JOIN docuself DS ON(DS.docuid2 = OC.docuid) WHERE DS.docuid = D.docuid limit 0,1
				 ) orden , 
         (SELECT CONCAT(docuid,'|',saldo) FROM documentos WHERE tipodoc = 'CXP' AND prefijo = D.prefijo AND numero = D.numero) saldo 
				 FROM documentos D 
				 INNER JOIN sucursales S ON (D.sucursalid = S.sucursalid) 
				 INNER JOIN terceros T ON (T.terid = D.terid1) 
				 WHERE D.tipodoc = 'FCO' 
		     ORDER BY D.tipodoc ASC , D.prefijo ASC , D.numero ASC limit 0,100";
	$_SESSION['SQL_COMPRAS'] = "";
	header("Location: compras.php");
  } 

  /////////////////////////////////////////////////////////////////////////////////////  
  /////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "listaconsec")
  {
	 $cont = $clase->Header("S","W");	 
	 $cont.='<table width="100%">
	           <tr class="CabezoteTabla"> 
			     <td width="10"> </td>
			     <td width="37"> <img src="images/iconos/cotizacion.png" width="32" height="32" border="0"> </td>
				 <td width="800"> <b> Facturas de Compra </b> <td>
				 <td width="37"> <a href="compras.php"><input type="button" value="<<" class="button"></a> </td>
			   </tr></table>'; 
  
    $vsql = "SELECT S.descripcion nomsuc , D.* FROM documentos D INNER JOIN sucursales S ON (S.sucursalid = D.sucursalid) 
	         WHERE tipodoc ='FCO' ORDER BY fechadoc DESC , numero DESC limit 0,900";   				
	$conex  = $clase->Conectar();
    $result = mysql_query($vsql,$conex);
 	$cont.='<div style="overflow:auto; height:580px;width:950px;">
	         <script type="text/javascript" src="lib/sorttable.js"></script>
               <table width="100%" class="sortable">
	           <tr class="TituloTabla"> 
			     <td width="20"> </td>
				 <td width="30"></td>
			     <td width="180"> Documento </td>
				 <td width="120"> Fecha </td>		
				 <td width="120"> No.Fact Prov </td>
				 <td width="150"> Sucursal </td>										 
				 <td width="70" align="right"> Prods </td>
				 <td width="120" align="right"> Vlr Total </td>										 				 
				 <td width="120" align="center">&nbsp;&nbsp;Autoriz&oacute; </td>										 				 				 
				 <td width="30" align="right">&nbsp;</td>							 	 				 
			   </tr>';	
    $i = 0;
    while($row = mysql_fetch_array($result)) 
	{
		   $tipopedido = $row['nrodocref'];
		   
		   if($i%2 == 0)
		     $cont.='<tr class="TablaDocsPar">';
		   else
		     $cont.='<tr class="TablaDocsImPar">';		 
		          
		   $cont.=' <td width="20"> </td><td width="30" align="center">'.$icono.'</td>
			        <td width="180"> <b><a class="Ntooltip">'.$row['tipodoc'].' '.$row['prefijo'].' '.$row['numero'].'<span> '.$row['observacion'].' </span></b></td>
					<td width="120"> '.fechahumanos($row['fechadoc']).' </td>
				    <td width="120"> <b>'.$tipopedido.'</b> </td>				  
				    <td width="20"> '.$row['nomsuc'].' </td>				  
				    <td width="70" align="right"><b>'.number_format($row['totalitems'],0).'</b></td>
				    <td width="120" align="right"><b> '.number_format($row['total'],0).' </b></td>
				    <td width="120" align="center">&nbsp;&nbsp;<font color="blue">'.substr($row['creador'],0,10).'</font> &nbsp;</td>
                    <td width="30" align="center">  <a href="?opcion=menu&id='.$row['docuid'].'&numerorem=TRB '.$row['remision'].'" rel="facebox">
			        <img src="images/basicas/funciones.png" title="Opciones de la Transferencia" border="0"></a> </td></tr>';
	  } 
	  
	  $cont.='</table><br>';
  }

  ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////  
  if($opcion == "")
  {
	 ini_set("memory_limit","200M");                            set_time_limit(0);

   
	 /// Control de Permisos
	 if(($_SESSION['ROL'] != "SAD")&&($_SESSION['ROL'] != "SUP")){$clase->Aviso(2,"Acceso No Permitido"); header("Location: principal.php"); }  

	 $cont = $clase->Header("S","W");	 
	 $cont.='<table width="100%">
	           <tr class="CabezoteTabla"> 
			     <td width="10"> </td>
			     <td width="37"> <img src="images/iconos/cotizacion.png" width="32" height="32" border="0"> </td>
				 <td width="535"> <b> Facturas de Compra </b> <td>
				 <td width="25"> <a href="compras.php?opcion=filtro" rel="facebox"><img src="images/basicas/lupa.png"></a> <td>';

	 ////////////////////////////////////////////////////////////////////////////////////////////
	 //// Agregar Tranferencia			  
	 $agregar = $clase->GetPermiso("FACTURAS DE COMPRAS",$_SESSION['USERNAME'],"agregar");
     if(($agregar == "CHECKED"))
		$cont.='<td width="24"> <a href="?opcion=pre-crear"> <img src="images/basicas/icononuevo.png" border="0"> </a> </td>';
	 else	
		$cont.='<td width="24">&nbsp;</td>';
     
 	 ////////////////////////////////////////////////////////////////////////////////////////////
	 //// Buscar Tranferencia	  
	 $buscar = $clase->GetPermiso("FACTURAS DE COMPRAS",$_SESSION['USERNAME'],"buscar");
     if(($buscar == "CHECKED")){
		$cont.=' <form action="?opcion=encontrar" method="POST" name="x">
				 <td> <input type="text" name="criterio" size="30" placeholder="Criterio a Buscar" tabindex="1" id="default" autocomplete="off"> </td>
				 <td> <input type="submit" value="Encontrar" class="button"> </td> ';
     }
	 if($_SESSION['SQL_COMPRAS'] != "")
         $cont.='<td width="10"> <a href="?opcion=nofiltro"> <img src="images/basicas/nofiltro.png"> </a> </td>'; 

		$cont.=' </form>
                 <td width="37"><a href="compras.php?opcion=listaconsec" title="Ver Consecutivos"><img src="images/basicas/codigobarras.png" border="0"></a></td>		
    		     <td width="8">&nbsp;</td>
			   </tr>	 			   
			 </table>';
	
	 ////// Calculo el Total de Remisiones y el Total Vendido
	 $periodo = $_GET['periodo'];   if($periodo == "")  $periodo = date("mY");
	 $vsql1 = "SELECT SUM(D.total+D.retefuente) FROM documentos D WHERE D.tipodoc = 'FCO' AND CONCAT(SUBSTR(D.fechadoc,6,2),SUBSTR(D.fechadoc,1,4)) = '".$periodo."' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'";		
   $totalcom  = $clase->SeleccionarUno($vsql1);	 
	 $vsql2 = "SELECT SUM(P.costoinf*DD.cantidad) FROM documentos D INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) INNER JOIN productos P ON (P.productoid = DD.productoid) 
	           WHERE D.tipodoc = 'FCO' AND CONCAT(SUBSTR(D.fechadoc,6,2),SUBSTR(D.fechadoc,1,4)) = '".$periodo."' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'";		
	 $totalcosto  = $clase->SeleccionarUno($vsql2);	 
	 
	 //////////////////////////////////////////////////////////
 	 /////////// Indicadores de Valores de Venta  		 	
	 $cont.=' <table width="100%">
	            <tr> <td class="BarraDocumentosSel" align="center"> <b>Vlr Compras&nbsp;</b> $ &nbsp;'.number_format($totalcom).'</b> </td>
	                 <td class="BarraDocumentosSel" align="center"> <b>Costo Inf Compras&nbsp;</b> $ &nbsp;'.number_format($totalcosto).'</b> </td>
                   <td width="150" class="BarraDocumentosSel" align="center"> <a href="compras.php?opcion=cambiarperiodo" rel="facebox"> Cambio Periodo </a> ('.$periodo.') </td>
             </tr> </table> '; 

   $vsql = $_SESSION['SQL_COMPRAS'];
   /*
   if($vsql == "")
   {
      if($_SESSION["USU-REGIONPRED"] != "")
      {
        $zonasdelaregion = "";
        $vsql = "SELECT S.sucursalid FROM zonas Z INNER JOIN sucursales S ON (Z.codzona = S.zona) WHERE Z.codregion = '".$_SESSION["USU-REGIONPRED"]."'";
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        $i=0;
        $wherex = " AND (";
        while($row = @mysql_fetch_array($result))
        {
            if($i == 0)
              $wherex .= " S.sucursalid = '".$row['sucursalid']."' "; 
            else
              $wherex .= " OR S.sucursalid = '".$row['sucursalid']."' ";    
            $i++;
        }
        $wherex .= " )";
      } 

      $vsql = "SELECT D.* , T.nombres , T.apellidos , D.nrodocref , S.codigo codsucursal , 
          (SELECT COUNT(*) FROM dedocumentos WHERE docuid = D.docuid) as lineas ,
          (
            SELECT CONCAT(prefijo,' ',numero) FROM documentos OC INNER JOIN docuself DS ON(DS.docuid2 = OC.docuid) WHERE DS.docuid = D.docuid limit 0,1
          ) orden , 
          (SELECT CONCAT(docuid,'|',saldo) FROM documentos WHERE tipodoc = 'CXP' AND fecasentado <> '0000-00-00' AND prefijo = D.prefijo AND numero = D.numero LIMIT 0,1) saldo , 
          (SELECT codigo FROM sucursales WHERE sucursalid = D.sucursalid) sucursal 
          FROM documentos D 
          INNER JOIN sucursales S ON (D.sucursalid = S.sucursalid) 
          INNER JOIN terceros T ON (T.terid = D.terid1) 
          WHERE D.tipodoc = 'FCO' ".$wherex."
          ORDER BY D.tipodoc DESC , D.fechadoc DESC limit 0,60";
   }
  */
  if($vsql != "")
  {
    $conex  = $clase->Conectar();
    $result = @mysql_query($vsql,$conex);
  }

  $cont.='<script type="text/javascript" src="lib/sorttable.js"></script> 
          <table width="100%" class="sortable">
            <thead>
                  <tr class="TituloTabla" style="display:block; padding-top:10px;"> 
                    <th width="50" align="center"> Dep </th>
                    <th width="115" align="left">Compra No.</a></th>
                    <th width="80" align="left"> F Fact </a></th>			
                    <th width="60" align="left">Hora</a></th>							 
                    <th width="95" align="left">No. Prov</a></th>							 
                    <th width="30" align="left">FP</a></th>
                    <th width="30" align="left"> $ </a></th>
                    <th width="160" align="left">Proveedor</a></th>
                    <th width="50" align="center">Lin</a></th>
                    <th width="70">Orden C</a></th>	 
                    <th width="75">Creado</a></th>	 
                    <th width="90" align="right"> Vlr  Total </th>
                    <th width="80" align="center"> Creador</a></th>
                    <th width="25"> </th>
                    <th width="30"> </th>							 	 				 
                    <th width="30"> </th>
                    <th width="20"> </th>
                    <th width="20"> </th>				 				 
                </tr>
              </thead>
            <tbody style="display:block; width:100%; height:690px; overflow-Y:scroll">';	
    
    /// Permisos del Usuario
    $menu = $clase->GetPermiso("FACTURAS DE COMPRAS",$_SESSION['USERNAME'],"menu");
    $modificar = $clase->GetPermiso("FACTURAS DE COMPRAS",$_SESSION['USERNAME'],"modificar");
    $reversar = $clase->GetPermiso("FACTURAS DE COMPRAS",$_SESSION['USERNAME'],"reversar");
         
    $i = 0;
    while($row = @mysql_fetch_array($result)) 
	  {
      $i++;
		  if($i%2 == 0)
		    $cont.='<tr class="TablaDocsPar">';
		  else
		    $cont.='<tr class="TablaDocsImPar">';		 
  
      $marca = ' <b><font color="green">+</b>';
      if($row['sincronizado'] == "")
        $marca = ' <b><font color="red">*</b>'; 
          
      /// Muestro un Icono si está cancelada o no. En caso afirmativo - Lo llevo al CEGR
      $docuid = "";  $saldox = "";
      if($row['formapago'] == "CO")
         $pagado = '';
      else
      {
         list($docuid, $saldox) = split('|', $row['saldo']);
         $partes = explode("|", $row['saldo']);
         $docuid = $partes[0];
         $saldox = $partes[1];
         if($row['saldo'] != "")
         {
             if($saldox <= 0)
               $pagado = '<a href="reportes/impcomproegresonotas.php?opcion=tipo1&egresoid='.$docuid.'" target="_blank" alt="Ver Comprobante de Pago"  title="Ver Comprobante de Pago">
                           <img src = "images/basicas/pagado.png" border="0" alt="Ver Comprobante de Pago" title="Ver Comprobante de Pago"></a>';
             else
               $pagado = '<img src = "images/basicas/nopagado.png" border="0">';
         }
         else
          $pagado = '<img src = "images/basicas/nopagado.png" border="0">';
      }   

      //// Deposito Donde Ingreso
      if($row['sucursal'] == '00')  $ingreso = '<font color="red"> <b> CUC </b></font>';
      if($row['sucursal'] == 'DB')  $ingreso = '<font color="green"> <b> BAR </b></font>';
      $cont.=' <td width="50" align="center"> '.$ingreso.'</td>';

		  //// Preparo los Campos Observacion y Forma de Pago
		  //// Observacion
		  if($row['observacion']!=""){
		     $cont.='<td width="120"> <b><a class="Ntooltip">'.$row['tipodoc'].''.$row['prefijo'].''.$row['numero'].$marca.'<span> '.$row['observacion'].' </span></b></td>';
		  }else{
		     $cont.='<td width="120"> <b>'.$row['tipodoc'].''.$row['prefijo'].''.$row['numero'].'</b></td>';
		  }
         //// Forma de Pago
         if($row['formapago'] == "CO")         $formapagoX = '<font color="green"><b>'.substr($row['formapago'],0,2);
         if($row['formapago'] == "CR")         $formapagoX = '<font color="red"><b>'.substr($row['formapago'],0,2);         

		  /// Armo el Link de la Orden de Compra
		  if($row['orden'] != ""){
		     $linkcompra = '<a href="productos.php?opcion=link&nrodoc=PCO'.trim(str_replace(" ","",str_replace("%20","",$row['orden']))).'" target="_blank"><b>'.$row['orden'].'</b></a>';     
		  }else{  $linkcompra = "";   }
      
      
      /// Muestro cuando el documento tiene Novedades
      $novedades = "&nbsp;";
      if(($_SESSION['SUPERUSUARIO'] == "CHECKED")&&($row['novedades']>0)) 
          $novedades = '<a href="documentos.php?opcion=vernovedades&docuid='.$row['docuid'].'" rel="facebox"><img src="images/basicas/novedades.png" border="0"> </a> ';

      /// Muestro los detalles		 
		  $cont.=' <td width="80"> '.fechahumanos($row['fechadoc']).' </td>
				  <td width="60"> '.substr($row['momento'],11,5).' </td>				  
				  <td width="100"> <b>'.$row['nrodocref'].'</b> </td>				  	
				  <td width="30"> '.$formapagoX.' </td>				  			  
          <td width="30"> '.$pagado.' </td> 
				  <td width="180"> <b><font color="gray">'.substr($row['nombres'].' '.$row['apellidos'],0,22).'</font></b> </td>				  				  
				  <td width="50" align="center"> '.number_format($row['lineas']).' </td>				  				  				  
				  <td width="80"> <b>'.$linkcompra.'</b> </td>				  				  				  
				  <td width="90"> '.fechahumanos($row['momento']).' </td>				  				  
				  <td width="50" align="right"> <b>'.number_format($row['total']).'</b> </td>				  				  
				  <td width="90" align="center"> <font color="blue">'.substr($row['creador'],0,8).'</font> </td>';

     if(($row['fecasentado'] != '0000-00-00')&&(($_SESSION['SUPERUSUARIO'] == "CHECKED")||($_SESSION['USERNAME'] == "D.LOZANO")))
				$cont.='<td width="28" align="center"> <a href="?opcion=modificarenc&docuid='.$row['docuid'].'" rel="facebox">
                            <img src="images/basicas/nuevomail.png" title="Modificar Encabezado" border="0"></a> </td>';
     else                       
        $cont.='<td width="28" align="center">&nbsp;</td>';

     $cont.='<td width="28" align="center">';

		 ////////////////////////////////////////////////////////////////////////////////////////////
	     //// Modificar Tranferencia			  
	     if(($menu == "CHECKED")){
			$cont.='  <a href="?opcion=menu&id='.$row['docuid'].'&numoco='.trim(str_replace(" ","",str_replace("%20","",$row['orden']))).'" rel="facebox">
				       <img src="images/basicas/funciones.png" title="Menu de la Compra" border="0"></a>';
         }
		 $cont.='</td>';

		 if($row['fecasentado'] == "0000-00-00")			   	  
		 {
			  ////////////////////////////////////////////////////////////////////////////////////////////
	      //// Modificar Tranferencia			  
        if(($modificar == "CHECKED")){
         
         //// Para los Usuarios Normales les abre en una Ventana Modal | Para los Superusuarios como ventana Normal
         if($_SESSION['SUPERUSUARIO'] == "CHECKED")
         {
             $cont.='<td width="28">  <a href="?opcion=crear&docuid='.$row['docuid'].'" target="_blank">
                     <img src="images/basicas/iconobuscar.png" title="Modificar" border="0"></a> </td>';
         }
         else
         {
  			     $cont.='<td width="28">  <a href="#" Onclick="window.open(\'?opcion=crear&docuid='.$row['docuid'].'\',\'Transfe'.$row['docuid'].'\',\'scrollbars=yes,height=820,width=1140\', false);">
  				           <img src="images/basicas/iconobuscar.png" title="Modificar" border="0"></a> </td>';
         } 
			
      }else
			  $cont.='<td width="5">&nbsp;</td>';					   
		 }
		 else
		 {
			 ////////////////////////////////////////////////////////////////////////////////////////////
	         //// Reversar Tranferencia			  	         
             if(($reversar == "CHECKED")){
			 $cont.='<td width="28">  <a href="?opcion=pre-reversar&docuid='.$row['docuid'].'" rel="facebox">
				       <img src="images/basicas/bloqueado.png" title="Documento Bloqueado" border="0"></a> </td>';
			}else
			   $cont.='<td width="28">&nbsp;</td>'; 		   
		 }			   
		 
     $cont.=' <td width="20"> '.$novedades.' </td>
              <td width="5"> </td></tr>';
	}
	$cont.='</tbody></table>';
  }
  
////////////////////////////////////////////////////////////////////////////////////////
// Opción: confirmacionanular
// Creación: 06/12/2019   última modificación: 
// Creador: Luis Flórez   modificado por: 
// Descripción: Opción para confirmar la anulación de una compra.
// Última modificación: 
////////////////////////////////////////////////////////////////////////////////////////
if($opcion == "confirmacionanular")
{
    $docuid = $_GET['docuid'];

    $cont='<table width="500">
           <tr class="CabezoteTabla"> 
           <td align="center"><br><b>Anular registro</b><br><br><td> 
           </tr> 
           </table>
           <table width="500">
           <tr class="TablaDocsImPar">       
           <td width="400" align="center"><b> ¿Confirma que desea anular esta compra? </b> <br></td>       
           </tr>
           <tr class="TablaDocsImPar">       
           <td width="400" align="center"><br><br>
           <form action="?opcion=anular" method="POST">
           <input type="hidden" name="docuid" value="'.$docuid.'">
           <input type="submit" value="ACEPTAR" class="button red" >
           <a href="compras.php?opcion=crearimportar&docuid='.$docuid.'" ><input type="button" value="CANCELAR" class="button blue"></a>                          
           </form><br>
           </td>        
           </tr>
           </table><br>';
    
    echo $cont; 
    exit();   
}

////////////////////////////////////////////////////////////////////////////////////////
// Opción: confirmacioneliminar
// Creación: 06/12/2019   última modificación: 
// Creador: Luis Flórez   modificado por: 
// Descripción: Opción para confirmar la eliminación de una compra.
// Última modificación: 
////////////////////////////////////////////////////////////////////////////////////////
if($opcion == "confirmacioneliminar")
{
    $docuid = $_GET['docuid'];

    $cont='<table width="500">
           <tr class="CabezoteTabla"> 
           <td align="center"><br><b>Eliminar registro</b><br><br><td> 
           </tr> 
           </table>
           <table width="500">
           <tr class="TablaDocsImPar">       
           <td width="400" align="center"><b> ¿Confirma que desea eliminar esta compra? </b> <br></td>       
           </tr>
           <tr class="TablaDocsImPar">       
           <td width="400" align="center"><br><br>
           <form action="?opcion=eliminar" method="POST">
           <input type="hidden" name="docuid" value="'.$docuid.'">
           <input type="submit" value="ACEPTAR" class="button red" >
           <a href="compras.php?opcion=crearimportar&docuid='.$docuid.'" ><input type="button" value="CANCELAR" class="button blue"></a>                          
           </form><br>
           </td>        
           </tr>
           </table><br>';
    
    echo $cont; 
    exit();   
}

////////////////////////////////////////////////////////////////////////////////////////
// Opción: confirmacioborraritem
// Creación: 06/12/2019   última modificación: 
// Creador: Luis Flórez   modificado por: 
// Descripción: Opción para la confirmación de la eliminación de un producto de la 
//              orden de compra.
// Última modificación: 
////////////////////////////////////////////////////////////////////////////////////////
if($opcion == "confirmacioborraritem")
{    
    $dedocumid = $_GET['dedocumid'];
    $docuid    = $_GET['docuid'];

    $cont='<table width="500">
           <tr class="CabezoteTabla"> 
           <td align="center"><br><b>Eliminar registro</b><br><br><td> 
           </tr> 
           </table>
           <table width="500">
           <tr class="TablaDocsImPar">       
           <td width="400" align="center"><b> ¿Confirma que desea eliminar este producto? </b> <br></td>       
           </tr>
           <tr class="TablaDocsImPar">       
           <td width="400" align="center"><br><br>
           <form action="?opcion=borraritem" method="POST">
           <input type="hidden" name="docuid" value="'.$docuid.'">
           <input type="hidden" name="dedocumid" value="'.$dedocumid.'">
           <input type="submit" value="ACEPTAR" class="button red" >
           <a href="compras.php?opcion=crearimportar&docuid='.$docuid.'" ><input type="button" value="CANCELAR" class="button blue"></a>                          
           </form><br>
           </td>        
           </tr>
           </table><br>';
    
    echo $cont; 
    exit();   
}

////////////////////////////////////////////////////////////////////////////////////////
// Opción: ventanaprocesomasivo
// Creación: 09/12/2019   última modificación: 14/12/2019
// Creador: Luis Flórez   modificado por: 
// Descripción: Opción para la ventana donde se seleccionarán el(los) producto(s) 
//              y el(los) descuento(s) que se procesarán masivamente.
// Última modificación: Se cambió el revertir iva de colocar cera a una casilla de 
//                      verificación que indique dicho proceso.
////////////////////////////////////////////////////////////////////////////////////////
if($opcion == "ventanaprocesomasivo")
{
    $docuid = $_GET['docuid'];
    
    // Aquí obtengo el número de registros para determinar si se puede procesar masivamente la factura
    $vsqle  = "SELECT COUNT(*) 
                FROM dedocumentos DD 
                     INNER JOIN productos P ON (DD.productoid = P.productoid) 
               WHERE DD.docuid=".$docuid;
    $existe = 0+$clase->SeleccionarUno($vsqle);    

    // Redireccionamos el formulario de acuerdo al resultado de la consulta
    if($existe>0)
    {
        // Preparo el encabezado
        $enc = $clase->HeaderBlanco("Procesamiento masivo"); 
        $enc.='<table width="800">
                <tr class="CabezoteTabla"> 
                  <td width="10">&nbsp; </td>
                  <td width="37"> <img src="images/iconos/servicios.png" width="32" height="32" border="0"> </td>
                  <td width="700"><b> Productos de la factura de compra </b><td>
                </tr>
               </table>';

        $enc.='<script language="javascript">
             <!--
                function seleccionar_todo(docuid)
                { 
                  valor = document.f2.todos.checked;
                  if(valor)
                    marcartodo();
                  else
                    desmarcartodo();
                } 

                function marcartodo()
                {
                  for (i=0;i<document.f2.elements.length;i++) 
                    if(document.f2.elements[i].type == "checkbox")  
                      document.f2.elements[i].checked = 1;                    
                      document.f2.iva.checked = 0;
                      document.f2.revertitiva.checked = 0;
                }

                function desmarcartodo()
                {
                  for (i=0;i<document.f2.elements.length;i++) 
                    if(document.f2.elements[i].type == "checkbox")
                      document.f2.elements[i].checked = 0;                    
                      document.f2.iva.checked = 0;
                      document.f2.revertitiva.checked = 0;
                }  
              </script>

              <form action="compras.php?opcion=procesamientomasivo" method="POST" name="f2">
              <input type="hidden" name="docuid" value="'.$docuid.'">
                <table width="800">
                  <thead> 
                    <tr class="TituloTabla" style="display:block; padding-top:10px;height:25px;">  

                      <td width="70" align="center"> 
                      <input type="checkbox" name="todos" value="S" onClick="javascript:seleccionar_todo('.$docuid.');"> 
                      </td>                    

                      <td width="120"> Cod Barras</td>
                      <td width="610"> Producto y/o Servicio </td>
                    </tr>
                  </thead>
                  <tbody style="display:block; width:799px; height:300px; overflow-Y:scroll">';

        // Consulta de productos asociados a la factura
        $vsql = "SELECT P.codigo , P.descripcion , DD.dedocumid 
                  FROM dedocumentos DD 
                       INNER JOIN productos P ON (DD.productoid = P.productoid) 
                 WHERE DD.docuid=".$docuid." ORDER BY DD.dedocumid DESC";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);

        $i = 0;
        $det='';
        while($row2 = @mysql_fetch_array($result))
        {
            // Comienzo a imprimir el detalle de la factura
            if($i%2 == 0)
                $det.='<tr class="TablaDocsPar" id="'.$i.'" data-value="'.$row2['dedocumid'].'">';
            else
                $det.='<tr class="TablaDocsImPar" id="'.$i.'" data-value="'.$row2['dedocumid'].'">';

            $det.='<td width="70" align="center"> 
                   <input type="checkbox" class="Texto11" name="LIN-'.$row2['dedocumid'].'" value="S"> 
                   </td>

                   <td width="120"> <b> <font color="black" size ="0.3">  '.$row2['codigo'].'</b></td>
                   <td width="610"><b>'.substr($row2['descripcion'],0,170).'</b> </td>
                   </tr>';
            $i++;
        } // Fin del while
        $det.='</tbody></table>';

        $pie='<table width="800">
               <tr class="TituloTabla">
                <td width="800" align="center"><b> Descuentos </b><td>
               </tr>
              </table>';

        // Preparo el pie de página de la ventana
        $pie.='<script>
                function selpor(){
                  document.getElementById("pordcto").disabled = false;
                  document.getElementById("mondcto").value = 0;
                  document.getElementById("mondcto").disabled = true;                  
                }

                function selmonto(){
                  document.getElementById("pordcto").disabled = true;
                  document.getElementById("pordcto").value = 0;
                  document.getElementById("mondcto").disabled = false;                   
                } 

                function seliva(){
                  var isChecked = document.getElementById("iva").checked;
                  if(isChecked){
                     document.getElementById("porciva").disabled = false;
                  }
                  else{
                    document.getElementById("porciva").disabled = true;
                  }
                }                                

               </script>

               <table width="800">
               <tr class="CabezoteTabla">
                <td width="30">&nbsp; </td>
                <td width="100"><label class="Texto13">Tipo de descuento </label> 
                <br/>
                <input name="tipodcto" type="radio" value="rbselpor" onclick="selpor()" />Porcentaje
                <br/>
                <input name="tipodcto" type="radio" value="rbselmonto" onclick="selmonto()" />Monto
                </td>
                <td width="10">&nbsp; </td>
                <td width="100"><label class="Texto11">% dcto:</label> <input type="number" name="pordcto" id="pordcto" min="0" max="100" disabled> </td>
                <td width="10">&nbsp; </td>
                <td width="100"><label class="Texto11">Monto dcto:</label> <input type="number" name="mondcto" id="mondcto" size="3" min="0" step="0.01" disabled> </td>               
                <td width="10">&nbsp; </td>
                <td width="100">&nbsp; </td>               
               </tr>               
               <tr class="CabezoteTabla">
                <td width="30">&nbsp; </td>                
                <!-- <td width="100"> <input type="checkbox" name="iva" id="iva" unchecked onclick="seliva()"> IVA </td> -->
                <td width="100"> <input type="checkbox" name="iva" id="iva"> IVA </td>
                <td width="10">&nbsp; </td>
                <td width="100"> <input type="checkbox" name="revertitiva" id="revertitiva" unchecked> Revertir IVA  </td>
                <td width="10">&nbsp; </td>
                <td width="100"><label class="Texto11">Línea 1:</label> <input type="number" name="linea1" disabled="disabled" min="0" max="100"> </td>               
                <td width="10">&nbsp; </td>
                <td width="100"><label class="Texto11">Línea 2:</label> <input type="number" name="linea2" disabled="disabled" min="0" max="100"> </td>               
               </tr>               
               <tr class="CabezoteTabla">
                <td width="30">&nbsp; </td>
                <td width="100"> <label class="Texto11">Dcto 1:</label> <input type="number" name="dcto1" disabled="disabled" min="0" max="100"> </td>
                <td width="10">&nbsp; </td>
                <td width="100"> <label class="Texto11">Dcto 2:</label> <input type="number" name="dcto2" disabled="disabled" min="0" max="100"> </td>
                <td width="10">&nbsp; </td>
                <td width="100"> <label class="Texto11">Dcto 3:</label> <input type="number" name="dcto3" disabled="disabled" min="0" max="100"> </td>               
                <td width="10">&nbsp; </td>
                <td width="100" align="left"> <label class="Texto11">Dcto 4:</label> <input type="number" name="dcto4" disabled="disabled" min="0" max="100"> </td>               
               </tr>               
               <tr class="CabezoteTabla">
                <td width="30">&nbsp; </td>
                <td width="100">&nbsp; </td>
                <td width="10">&nbsp; </td>
                <td width="100">&nbsp; </td>
                <td width="10">&nbsp; </td>
                <td width="100">&nbsp; </td>               
                <td width="10">&nbsp; </td>
                <td width="100">&nbsp; </td>               
               </tr>              
              </table>';

        $pie.='<table width="800">
                <tr class="CabezoteTabla">
                 <td width="800" align="center"> <input type="submit" value="aplicar" class="button blue" > <td>
                </tr>
               </table></form>';

        // Imprimo la ventana
        $cont=$enc.$det.$pie;
        echo $cont;
        exit();
    }
    else
    {
          // Se devuelve a la ventana anterior
          echo "<script>
                    alert('No existen productos asociados a esta factura de compra');
                    window.close();                    
          </script>";          
    }    
} // Fin de la opción ventanaprocesomasivo

////////////////////////////////////////////////////////////////////////////////////////
// Opción: procesamientomasivo
// Creación: 09/12/2019   última modificación: 16/12/2019
// Creador: Luis Flórez   modificado por: 
// Descripción: Opción para el procesamiento masivo de producto(s) de la factura de 
//              orden de compra, inicialmente solo se procesarán los descuentos y 
//              el IVA.
// Última modificación: Se desarrollaron las opciones de revertir los descuentos cuando 
//                      se les indique que es cero y la aplicación del iva.
////////////////////////////////////////////////////////////////////////////////////////
if($opcion == "procesamientomasivo")
{
    $docuid      = $_POST['docuid'];
    $pordcto     = $_POST['pordcto'];
    $mondcto     = $_POST['mondcto'];
    $porciva     = $_POST['porciva'];
    $iva         = $_POST['iva'];
    $revertitiva = $_POST['revertitiva'];
    $lista       = "";
    $tipodcto    = $_POST['tipodcto'];
    $lb_proceso  = false;   
    
    // Consulta para extraer los productos de la factura de compra  
    $vsql = "SELECT dedocumid FROM dedocumentos WHERE docuid=".$docuid;
    $conex  = $clase->Conectar();
    $result = mysql_query($vsql,$conex);

    // Recorrido de la consulta para determinar los productos a los cuales se les realizará el procesamiento masivo
    while($row = mysql_fetch_array($result)) 
    { 
        if($_POST['LIN-'.$row['dedocumid']] == "S")
            $lista.= $row['dedocumid'].",";
    }
    $lista = $lista."-1";
    
    // Valido si se realizó la selección de los productos
    if($lista=="-1")
    {
        echo "<script>
                  alert('No se seleccionó ningún producto');
                  window.close();                    
        </script>";
    }
    else
    {
        
        // Valido la selección simultanea de IVA y Revertir IVA
        if(($iva==on)&&($revertitiva==on))
        {
          echo "<script>
                    alert('No se pueden seleccionar simultáneamente IVA y Revertir IVA');
                    window.close();
          </script>";
        }
        else
        {
            // Valido que no existan valores para procesar
            if(($tipodcto=="")&&($iva!=on)&&($revertitiva!=on))
            {

                echo "<script>
                          alert('No se indicó ningún cambio');
                          window.close();
                </script>";
            }
            else
            {
                // Proceso los descuentos por porcentaje
                if($tipodcto=="rbselpor")
                {
                    // Aquí proceso el porcentaje
                    if($pordcto!=0)
                    {
                        $clase->EjecutarSQL("UPDATE dedocumentos SET valdescuento = valtotal * (".$pordcto." / 100) WHERE dedocumid IN (".$lista.")");  // Actualizo el valor del descuento
                        $clase->EjecutarSQL("UPDATE dedocumentos SET valtotal = valtotal - valdescuento WHERE dedocumid IN (".$lista.")");  // Actualizo el valor total
                        $clase->EjecutarSQL("UPDATE dedocumentos SET valuniori = valunitario  WHERE dedocumid IN (".$lista.")"); // Actualizo el valor unitario original antes de aplicado el descuento
                        $clase->EjecutarSQL("UPDATE dedocumentos SET valunitario = valunitario - (valunitario * (".$pordcto." / 100)) WHERE dedocumid IN (".$lista.")"); // Actualizo el valor unitario
                        $clase->EjecutarSQL("CALL PA_CalValoresFCO(".$docuid.")");
                        $lb_proceso = true;
                    }
                    else
                    {
                        // Aquí es para revertir la aplicación del descuento por porcentaje
                        $clase->EjecutarSQL("UPDATE dedocumentos SET valunitario = valuniori WHERE dedocumid IN (".$lista.")");
                        $clase->EjecutarSQL("UPDATE dedocumentos SET valuniori = 0 WHERE dedocumid IN (".$lista.")");                        

                        // Aquí revierto la aplicación del porcentaje
                        $clase->EjecutarSQL("UPDATE dedocumentos SET valtotal = (valtotal + valdescuento) WHERE dedocumid IN (".$lista.")");
                        $clase->EjecutarSQL("UPDATE dedocumentos SET valdescuento = 0 WHERE dedocumid IN (".$lista.")");
                        $clase->EjecutarSQL("CALL PA_CalValoresFCO(".$docuid.")");
                        $lb_proceso = true;
                    }
                }

                // Proceso los descuentos por monto
                if($tipodcto=="rbselmonto")
                {
                    if($mondcto!=0)
                    {
                        $clase->EjecutarSQL("UPDATE dedocumentos SET valdescuento = ".$mondcto." WHERE dedocumid IN (".$lista.")");
                        $clase->EjecutarSQL("UPDATE dedocumentos SET valtotal = (valtotal - ".$mondcto.") WHERE dedocumid IN (".$lista.")");
                        $clase->EjecutarSQL("UPDATE dedocumentos SET valunitario = (valunitario - ".$mondcto.") WHERE dedocumid IN (".$lista.")");
                        $clase->EjecutarSQL("CALL PA_CalValoresFCO(".$docuid.")");
                        $lb_proceso = true;
                    }
                    else
                    {
                        // Aquí se revierte la aplicación de un descuento mal realizado
                        $clase->EjecutarSQL("UPDATE dedocumentos SET valtotal = (valtotal + valdescuento) WHERE dedocumid IN (".$lista.")");
                        $clase->EjecutarSQL("UPDATE dedocumentos SET valunitario = (valunitario + valdescuento) WHERE dedocumid IN (".$lista.")");
                        $clase->EjecutarSQL("UPDATE dedocumentos SET valdescuento = 0 WHERE dedocumid IN (".$lista.")");
                        $clase->EjecutarSQL("CALL PA_CalValoresFCO(".$docuid.")");
                        $lb_proceso = true;
                    }
                }
                    
                // Proceso los IVAs en caso de haber sido seleccionado
                if($iva==on)
                {   
                    // Almacenamos los valores iniciales                
                    $clase->EjecutarSQL("UPDATE dedocumentos SET valivatotori = valtotal WHERE dedocumid IN (".$lista.")");
                    $clase->EjecutarSQL("UPDATE dedocumentos SET valivauniori = valunitario WHERE dedocumid IN (".$lista.")");

                    // Actualizamos en porcentaje de IVA 
                    $clase->EjecutarSQL("UPDATE dedocumentos dd SET dd.porciva = (SELECT p.porciva FROM productos p WHERE p.productoid=dd.productoid) WHERE dedocumid IN (".$lista.")");
                    $clase->EjecutarSQL("UPDATE dedocumentos SET valtotal = valtotal / ((porciva/100)+1) WHERE dedocumid IN (".$lista.")");
                    $clase->EjecutarSQL("UPDATE dedocumentos SET valunitario = valunitario / ((porciva/100)+1) WHERE dedocumid IN (".$lista.")");                
                    $clase->EjecutarSQL("CALL PA_CalValoresFCO(".$docuid.")");
                    $lb_proceso = true;
                }

                // Proceso para revertir la aplicación del IVA
                if($revertitiva==on)
                {
                    $clase->EjecutarSQL("UPDATE dedocumentos SET porciva = 0 WHERE dedocumid IN (".$lista.")");
                    $clase->EjecutarSQL("UPDATE dedocumentos SET valtotal = valivatotori  WHERE dedocumid IN (".$lista.")");
                    $clase->EjecutarSQL("UPDATE dedocumentos SET valunitario = valivauniori WHERE dedocumid IN (".$lista.")");
                    $clase->EjecutarSQL("CALL PA_CalValoresFCO(".$docuid.")");
                    $lb_proceso = true;
                }

                // Imprimo el mensaje correspondiente si se realizaron procesos masivos
                if($lb_proceso)
                {
                    echo "<script>
                            alert('Se realizaron los procesos masivos exitosamente');
                            window.opener.location.reload();
                            window.close();                    
                    </script>";
                }  
                else
                {
                    echo "<script>
                              alert('No se realizó ningún proceso');
                              window.close();                    
                    </script>";
                }          
            }
        }
    }
}  // Fin de la opción procesamientomasivo

////////////////////////////////////////////////////////////////////////////////////////
// Opción: ventanaconorden
// Creación: 17/12/2019           última modificación: 
// Creador: Luis Flórez           modificado por: 
// Descripción: Ventana para ingresar el código del producto al cual se le consultará 
//              las órdenes de compras asociadas a él.
// Última modificación: 
////////////////////////////////////////////////////////////////////////////////////////
if($opcion == "ventanaconorden")
{
    $docuid = $_GET['docuid'];
    $error  = $_GET['error'];
    
    if(($error == "")||($error == 0))
    {
        $COLOR = "#EAEAEA";

        // $cont='<link rel="stylesheet" href="css/estiloadministrativos.css" type="text/css">';
        $cont.='<link rel="stylesheet" href="css/estiloadministrativos.css" type="text/css">';
        // $cont.='<body bgcolor="'.$COLOR.'" leftmargin="0" topmargin="0" rightmargin="0" bottonmargin="0" OnLoad="document.x.default.focus();">';   

        $cont.='<body bgcolor="'.$COLOR.'" style="overflow-x:hidden; overflow-y:hidden" OnLoad="document.x.default.focus();">';      

        $cont.='<script type="text/javascript">

                  function handleEnter (field, event) 
                  {
                      var keyCode = event.keyCode ? event.keyCode : event.which ? event.which : event.charCode;
                      if (keyCode == 13) {
                      var i;
                      for (i = 0; i < field.form.elements.length; i++)
                      if (field == field.form.elements[i])
                      break;
                      i = (i + 1) % field.form.elements.length;
                      field.form.elements[i].focus();
                      return false;
                      }
                      else
                      return true;
                  }
                  </script>

                <form action="?opcion=verordenesprod" method="POST" name="x">
                  <input type="hidden" name="docuid" value="'.$docuid.'">
                <table width="100%" bgcolor="'.$COLOR.'">  

                <tr bgcolor="'.$COLOR.'">
                <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp; </td>
                </tr>                

                <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> C&oacute;digo barra </td>
                  </tr>                
                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'"> <input type="text" onkeypress="return handleEnter(this, event)" autofocus required name="codbarra" class="Texto15" size="17" id="codbarra" tabindex="1" autocomplete="off" onclick="this.select()"> </td>                
                  </tr>

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp; </td>
                  </tr> 

                  <tr bgcolor="'.$COLOR.'" height="60">
                  <td align="center" bgcolor="'.$COLOR.'"><br><center><input type="submit" class="button red" value="Consultar &oacute;rdenes de compra"></td>
                  </tr>       
                
                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       
                  
                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                  <tr bgcolor="'.$COLOR.'">
                  <td align="center" bgcolor="'.$COLOR.'" width="360" class="Texto15"> &nbsp;  </td>
                  </tr>       

                </table></form>';
    }
  
    if($error == "1")
    {
        $COLOR = "red";
        $cont.='<body bgcolor="'.$COLOR.'" leftmargin="0" topmargin="0" rightmargin="0" bottonmargin="0">';
        $cont.='<font color="white"><center><BR><h1>ERROR <br> PRODUCTO NO ENCONTRADO </H1><BR>
              <a href="transferencias.php?opcion=pos&docuid='.$docuid.'">
          <input type="button" value="CONTINUAR INGRESANDO PRODUCTOS" class="button"></a>';
    }       

    if($error == "2")
    {
        $COLOR = "orange";
        $cont.='<body bgcolor="'.$COLOR.'" leftmargin="0" topmargin="0" rightmargin="0" bottonmargin="0">';
        $cont.='<font color="white"><center><BR><h1>ERROR <br> DOCUMENTO YA ESTA CERRADO </H1><BR>
              <a href="#" OnClick="window.close();"><input type="button" value="CERRAR VENTANA" class="button"></a>';
    }       

    if($error == "3")
    {
        $COLOR = "blue";
        $cont.='<body bgcolor="'.$COLOR.'" leftmargin="0" topmargin="0" rightmargin="0" bottonmargin="0">';
        $cont.='<font color="white"><center><BR><h1>YA ALCANZO EL LIMITE DE ITEMS</h1><h2> NO PODRA ADICIONAR MAS PRODUCTOS AL DOCUMENTO</H2><BR>
              <a href="#" OnClick="window.close();"><input type="button" value="CERRAR VENTANA" class="button"></a>';
    } 
    echo $cont;
    exit();    
} // Fin de la opción ventanaconorden

////////////////////////////////////////////////////////////////////////////////////////
// Opción: verordenesprod
// Creación: 12/12/2019   última modificación: 17/12/2019
// Creador: Luis Flórez   modificado por: 
// Descripción: Ventana para imprimir las órdenes de compra asociadas a un producto
// Última modificación: 
////////////////////////////////////////////////////////////////////////////////////////
if($opcion == "verordenesprod")
{
    $codbarra = $_POST['codbarra'];
    $nompro   = $clase->SeleccionarUno("SELECT descripcion FROM productos WHERE codbarra LIKE '%".$codbarra."%'");
    $cont = '';    $enc = '';    $det = '';    $pie = '';
    $enc      = '<link rel="stylesheet" href="css/estiloadministrativos.css" type="text/css">';

    // Título de la ventana
    $enc.='<table width="680">
              <tr class="CabezoteTabla"> 
              <td align="center"> <b>Ordenes de compra asociadas al producto: '.$nompro.'</b> <td> 
              </tr> 
            </table>
            <table width="680">';    

    // Consulta de las órdenes de compra del producto que no estén asociadas a una factura
    $vsql = "SELECT DC.tipodoc, DC.prefijo, DC.numero, DD.productoid, P.descripcion, DC.fechadoc,
                    DC.docuid 
               FROM dedocumentos DD
                    INNER JOIN documentos DC ON (DD.docuid = DC.docuid)
                    INNER JOIN productos P ON (DD.productoid = P.productoid)         
              WHERE DC.tipodoc = 'PCO' AND 
                    P.codbarra LIKE '%".$codbarra."%' AND
                    DC.docuid NOT IN (SELECT DS.docuid2
                                        FROM documentos C 
                                             INNER JOIN docuself DS ON (DS.docuid = C.docuid) 
                                       WHERE DS.docuid2 = DC.docuid) 
           ORDER BY DC.fechadoc DESC";

    $conex  = $clase->Conectar();
    $result = mysql_query($vsql,$conex);
    $registros = mysql_num_rows($result);
    $i = 0;
    
    if($registros == 0)
    {
      $det.='<tr class="TablaDocsImPar">';
      $det.='<td width="20">&nbsp;</td>
                <td width="250" align="center"> <font color="red"> <CENTER><b> No hay órdenes de compra <br>asociadas a este producto </b><br><br> </td>                
                <td width="20">&nbsp;</td>
                </tr>';
    }
    else
    {    
        // Impresión de las órdenes
        while($row = mysql_fetch_array($result))
        {
            if($i%2 == 0)
                $det.='<tr class="TablaDocsImPar">';
            else
                $det.='<tr class="TablaDocsPar">';

            $det.='<td width="20">&nbsp;</td>
                    <td width="150" align="center">'.$row['tipodoc'].' '.$row['prefijo'].' '.$row['numero'].'</td>
                    <td width="100" align="center"><a href="reportes/imppedidopro.php?docuid='.$row['docuid'].'" target="_blank">Visualizar</a></td>
                    <td width="20">&nbsp;</td>
                    </tr>';
        }
    }

    $pie='</table><br>';
    $cont=$enc.$det.$pie;    

    echo $cont;
    exit();
} // Fin de la opción verordenesprod

  echo $cont.$clase->PiePagina();  


  ////////////////////////////////////////////////////////////////////////////
  ////////////////////////////////////////////////////////////////////////////
  function fechahumanos($fechamysql)
  {
     return(substr($fechamysql,8,2)."/".substr($fechamysql,5,2)."/".substr($fechamysql,0,4));  
  }
  ////////////////////////////////////////////////////////////////////////////  
  function Javascript()
  {
    $contenido = '<script language="javascript">
              <!--
			  
			  function TabulaEnter(field, event) 
			  {
		   		var keyCode = event.keyCode ? event.keyCode : event.which ? event.which : event.charCode;
			    if (keyCode == 13) {
					var i;
				for (i = 0; i < field.form.elements.length; i++)
					if (field == field.form.elements[i])
						break;
					i = (i + 1) % field.form.elements.length;
					field.form.elements[i].focus();
					return false;
				} 
				else
				  CalcularValores();
								    
			  } 

			  function CalcularValores()
			  {
				 var resultado;
				 var resultado2;				 

				 if((document.y.cantidad.value != "")&&(document.y.precio.value != "")&&(document.y.iva.value == ""))  
				 {
				  resultado =  document.y.cantidad.value*document.y.precio.value;
				  document.y.total.value = resultado;	
				 }
				 
				 if((document.y.cantidad.value != "")&&(document.y.precio.value != "")&&(document.y.iva.value != ""))  
				 {
				  resultado = ((document.y.cantidad.value*document.y.precio.value)*(1+(document.y.iva.value/100)));
				  document.y.total.value = Math.round(parseFloat(resultado)*100)/100	
				 } 

				 if((document.y.cantidad.value != "")&&(document.y.precio.value != "")&&(document.y.iva.value != "")&&(document.y.descuento.value != "0"))  
				 {
				  resultado = ((document.y.cantidad.value*document.y.precio.value)*(1+(document.y.iva.value/100)));
				  resultado2 = ((document.y.descuento.value/100)*resultado);
				  document.y.total.value = Math.round(parseFloat((resultado-resultado2))*100)/100;	
				 } 

			  }
			  
			  function Mejorar()
			  {
				var cadena = ""; 
				if (document.x.descuento.value == "")  document.x.descuento.value=0; 				
				return;
			  }	

			  function Valida( formulario ) 
			  {
			    if (document.x.cantidad.value == "")  document.x.cantidad.value=0; 
				if((formulario.codigo.value != "")&&(formulario.descripcion.value != "")&&(formulario.grupoproducto.value != "")&&(formulario.lineaproducto.value != "")&&(formulario.clasiproducto.value != "")){
				    return true
			    } else {
				    alert("Complete todos los campos antes de Guardar");
					document.x.codigo.focus();
			 	    return false
			    }
			  }
			  
			 function analizarfoco()
  		 	 {
				 document.y.producto.focus();     		   
	         }	  
			  
             
			  -->
             </script>';
		return($contenido);	 
   }

//////////////////////////////////////////////////////////////////////////////////////////// 
  function GenerarKardexDestino($bodegadestino,$docuid)
  {
     ini_set("memory_limit","200M");                            set_time_limit(0);
     $clase = new Sistema();
     
     $bodid = $bodegadestino;
     $sucid = $clase->BDLockup($bodid,'bodegas','bodegaid','sucursalid');
     $vsql  = "SELECT * FROM dedocumentos DD INNER JOIN documentos D ON (D.docuid = DD.docuid) WHERE D.docuid=".$docuid;
     $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);  
     $i = 0;
     while($row = mysql_fetch_array($result))
     {
       $tipodoc    = $row['tipodoc'];  
       $prefijo    = $row['prefijo'];  
       $numero     = $row['numero']; 
       $fechadoc   = $row['fechadoc'];     
       $periodo    = $row['periodo'];          
    
       $productoid = $row['productoid']; 

       $cantidad   = ($row['unidades']);
      
       $creador    = $row['creador'];  
       $momento    = $row['momento'];

        if($i == 0)
        {
           //// Limpio los movimientos anteriores si los hay
           $clase->EjecutarSQL("DELETE  FROM kardex WHERE tipodoc = '".$tipodoc."' AND prefijo = '".$prefijo."' AND numero = '".$numero."' AND bodegaid=".$bodid);
        }

        $vsqlx = "INSERT  INTO kardex(tipodoc,prefijo,numero,fechadoc,periodo,productoid,bodegaid,sucursalid,cantidad,docuid,creador,momento) 
                  VALUES('".$tipodoc."','".$prefijo."','".$numero."','".$fechadoc."','".$periodo."',".$productoid.",".$bodid.",".$sucid.",".$cantidad.",".$docuid.",'".$creador."','".$momento."')";
        $clase->EjecutarSQL($vsqlx);      
        $i++;
     }  
    return; 
  }

   /////////////////////////////////////////////////////////////////////////////////
   /////////////////////////////////////////////////////////////////////////////////
   function CostoAsentarCompra($docuid)
   {
     $clase = new Sistema();

	   $vsql = "SELECT DISTINCT D.terid1 , P.productoid, DD.valunitario , DD.cantidad, DD.costoprod , COALESCE(DD.valdescuento,0) valdescuento , COALESCE(DD.docuref,0) docuref , 
  	          P.costoprom , DCC.dcto1 , DCC.dcto2 , DCC.dcto3 , COALESCE(DDOX.dctol1,0) dctol1 , COALESCE(DDOX.dctol2,0) dctol2 , COALESCE(DDOX.dctol3,0) dctol3 , 
  	          COALESCE(DDOX.dctol4,0) dctol4 , COALESCE(DDOX.obsequio,0) obsequio , D.terid1 , DD.valparcial , DD.valico , DCC.aplicarcondipro , DCC.aplicar2 ,
  	          SUM( E.cantidad ) existencia 
  	          FROM dedocumentos DD  INNER JOIN documentos D ON ( DD.docuid = D.docuid ) 
  	          INNER JOIN docucompra DCC ON (D.docuid = DCC.docuid) 
      			  INNER JOIN productos P ON ( P.productoid = DD.productoid ) 
      			  INNER JOIN existencias E ON ( P.productoid = E.productoid ) 
      			  LEFT JOIN dedocuorden DDOX ON (DDOX.dedocumid = DD.dedocumid) 
    		      WHERE (D.tipodoc = 'FCO' OR D.tipodoc = 'DCO') AND DD.valunitario > 0 AND EXTRACT( YEAR FROM fechadoc ) <>  '0000' AND D.docuid = ".$docuid." 
    		      GROUP BY 1 , 2, 3, 4 , 5 , 6 , 7 , 8 , 9 , 10 , 11 , 12 , 13 , 14 , 15 , 16 , 17 , 18 , 19 , 20 , 21";

	   $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
	   while($row = @mysql_fetch_array($result)) 
	   {
  	   $productoid      = $row['productoid'];
  	   $cantidad        = $row['cantidad'];
  	   $valunitario     = $row['costoprod'];	
  	   $costoprom       = $row['costoprom'];		      
  	   $existencia      = $row['existencia'];		      	   
  	   $valunitario     = $row['valunitario'];
  	   $valdescuento1   = $row['valdescuento'];             
  	   $valparcial      = 0+$row['valparcial'];   
       $valiva          = 0+$row['valiva'];   
       $valico          = 0+$row['valico'];
  	   $valdescuento2   = $row['docuref'];                  
  	   $aplicarcondipro = $row['aplicarcondipro'];     
  	   $dcto0           = $clase->BDLockup($row['terid1'],'terceros','terid','pordctofijocom');	
  	   $dcto1           = $row['dcto1'];
  	   $dcto2           = $row['dcto2'];             
  	   $dcto3           = $row['dcto3'];                  
  	   $dcto4           = $row['dcto4'];    
  	   $dcto5           = $row['dctol1'];
  	   $dcto6           = $row['dctol2'];             
  	   $dcto7           = $row['dctol3'];                  
  	   $dcto8           = $row['dctol4']; 
       $aplicar2        = $row['aplicar2']; 

       //// Busco el Tercero
       $terid =  $row['terid'];

       /////////////////////////////////////////////////////////
       //// Costo Informativo del Producto en esta compra
       $CostoInfxProd = ((($valico+$valunitario)*$cantidad)/($cantidad+$row['obsequio']));
       $UltCostoProd = $CostoInfxProd;
       
       //if($dcto0 > 0)  $CostoInfxProd -= ($CostoInfxProd*($dcto0/100));
       if($dcto1 > 0)  $CostoInfxProd1 = ($CostoInfxProd*($dcto1/100));
       if(($dcto2 > 0)&&($aplicar2))   $CostoInfxProd2 = ($CostoInfxProd*($dcto2/100));

  	   if($dcto3 > 0)  $CostoInfxProd3 = ($CostoInfxProd*($dcto3/100));
  	   if($dcto4 > 0)  $CostoInfxProd4 = ($CostoInfxProd*($dcto4/100));	   
  	   //if($dcto5 > 0)  $CostoInfxProd -= ($CostoInfxProd*($dcto5/100));
         //if($dcto6 > 0)  $CostoInfxProd -= ($CostoInfxProd*($dcto6/100));
  	   if($dcto7 > 0)  $CostoInfxProd7 = ($CostoInfxProd*($dcto7/100));
  	   if($dcto8 > 0)  $CostoInfxProd8 = ($CostoInfxProd*($dcto8/100));	   
       
       $CostoInfxProd =  $CostoInfxProd - ($CostoInfxProd1+$CostoInfxProd3+$CostoInfxProd4+$CostoInfxProd7+$CostoInfxProd8);
  
       /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
       //// Costo Promedio - Ultimas 6 compras del Producto
       $vsql2 = "SELECT DISTINCT D.numero , DD.productoid , DD.valunitario , DCC.dcto1 , DCC.dcto2 , DCC.dcto3 , DCC.aplicar2 , COALESCE(DDCX.dctol1,0) dctol1 , 
                 COALESCE(DDCX.dctol2,0) dctol2 , COALESCE(DDCX.dctol3,0) dctol3 , COALESCE(DDCX.dctol4,0) dctol4 , DD.valico , 
                 COALESCE(DD.valdescuento,0) valdescuento , DD.valunitario , COALESCE(DDCX.obsequio,0) obsequio , DD.valiva , SUM(DD.cantidad) canti ,
                 (SELECT SUM(cantidad) FROM existencias WHERE productoid = DD.productoid) exitotal 
        				 FROM documentos D INNER JOIN docucompra DCC ON (D.docuid = DCC.docuid) 
        				 INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
        				 LEFT JOIN dedocuorden DDCX ON (DDCX.dedocumid = DD.dedocumid)
        				 WHERE (D.tipodoc = 'FCO' OR D.tipodoc = 'DCO') AND DD.valunitario > 0 AND D.fecasentado <> '0000-00-00' AND DD.productoid = ".$productoid." 
        				 GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14 ORDER BY D.fechadoc DESC LIMIT 0,10"; 

       $conex2  = $clase->Conectar();
       $result2 = @mysql_query($vsql2,$conex2);
       $sumacanti = 0;     $sumaval = 0;    $j = 0;  
       $linealog = '<table width="600"> <tr> 
                      <td align="right" width="100"> <b> Cant </td> 
                      <td align="right" width="150"> <b> VUnit </td> 
                      <td align="right" width="150"> <b> VTotal </td> 
                      <td align="right" width="150"> <b> Exit </td>
                      <td align="right" width="50"> &nbsp; </td>
                    </tr>';
       
       while($row2 = @mysql_fetch_array($result2)) 
	     {
          $dcto1 = $row2['dcto1'];  
          $dcto2 = $row2['dcto2'];
          $dcto3 = $row2['dcto3'];
          $dcto4 = $row2['dcto4'];
          $aplicar2 = $row2['aplicar2'];
          //$dcto5 = $row2['dctol1'];
          //$dcto6 = $row2['dctol2'];
          $dcto7 = $row2['dctol3'];
          $dcto8 = $row2['dctol4'];
          $valdescuento = $row2['valdescuento'];
          
          $basenotas  = 0;
          $costoinf   = @(((($row2['valico']/$row2['canti'])+$row2['valunitario'])*$row2['canti'])/($row2['canti']+$row2['obsequio']));

          if($dcto1 > 0)  $costoinf = $costoinf - ($costoinf*($dcto1/100));
          //if(($dcto2 > 0)&&($aplicar2 == "CHECKED"))  $costoinf = $costoinf - ($costoinf*($dcto2/100));
	        $basenotas  = $costoinf;
            
  	      if($dcto3 > 0)  $costoinf = $costoinf - ($costoinf*($dcto3/100));
  	      if($dcto4 > 0)  $costoinf = $costoinf - ($costoinf*($dcto4/100));
            //if($dcto5 > 0)  $costoinf = $costoinf - ($costoinf*($dcto5/100));
            //if($dcto6 > 0)  $costoinf = $costoinf - ($costoinf*($dcto6/100));
  	      if($dcto7 > 0)  $costoinf = $costoinf - ($costoinf*($dcto7/100));
  	      if($dcto8 > 0)  $costoinf = $costoinf - ($costoinf*($dcto8/100));
            
          /* Genero las Notas En caso de que haya lugar */
          $basenotas  =  $basenotas - ($basenotas*($dcto5/100));
          $basenotas  =  $basenotas - ($basenotas*($dcto6/100));	      
          $basenotas  =  ($basenotas * ($row2['canti']+$row2['obsequio']));

          if(($dcto7 > 0)&&($basenotas>1000))           GenerarNotaDescuento($docuid,$dcto7,$basenotas,4);  
          if(($dcto8 > 0)&&($basenotas>1000))           GenerarNotaDescuento($docuid,$dcto8,$basenotas,5); 
          if(($valdescuento > 0)&&($basenotas>1000))    GenerarNotaDescuento($docuid,$valdescuento,$basenotas,6,"V"); 

          if($j==0)
          {
          	 $UltCostoProd  = $row2['valunitario'];
          	 $CostoInfxProd = $costoinf;
          }

          $sumacanti += (round($row2['canti'])+round($row2['obsequio']));
          $sumaval   += (round($costoinf)*round(($row2['canti']+$row2['obsequio'])));
          $j++;
          
          /// Linea LOG 
          $linealog.='<tr>
                         <td align="right"> '.number_format(($row2['canti']+$row2['obsequio']),1).'</td>
                         <td align="right"> '.number_format(($costoinf),1).'</td>
                         <td align="right"> '.number_format(((round($costoinf)*round(($row2['canti']+$row2['obsequio'])))),1).'</td>
                         <td align="right"> '.number_format(($row2['exitotal']),1).'</td>
                      </tr>';                             

          if($sumacanti >= $row2['exitotal']) 
          {
          	$linealog.='<tr>
                          <td align="right"> <b>'.number_format($sumacanti,1).'</td>
                          <td align="right"> <b>'.number_format(0,1).'</td>
                          <td align="right"> <b>'.number_format(($sumaval),1).'</td>
                          <td align="right"> <b>'.number_format(($row2['exitotal']),1).'</td>
                          <td align="right"> &nbsp; </td>
                        </tr></table>';
          	break;          	
          }	 
       }   	   
         
       $costoProm = round($sumaval/$sumacanti);
       $clase->EjecutarSQL("UPDATE productos SET costoprom =".$costoProm." , ultcosto =".$UltCostoProd." , costoinf =".$CostoInfxProd." , tablacostoprom = '".$linealog."' WHERE productoid =".$productoid);
       
     } /// While Productos de la Compra

   } // Fin de la Funcion

   /////////////////////////////////////////////////////////////////////////////////
   /////////////////////////////////////////////////////////////////////////////////
   function CostoReversarCompra($docuid)
   {
      CostoAsentarCompra($docuid);
   } // Fin de la Funcion


   /////////////////////////////////////////////////////////////////////////////////////////////
   /////////////////////////////////////////////////////////////////////////////////////////////   
   function ValidarProductosCostoBajo($docuid)
   {
       $clase = new Sistema();
       $dcto1 = $clase->BDLockup($docuid,'docucompra','docuid','dcto1');
       $dcto2 = $clase->BDLockup($docuid,'docucompra','docuid','dcto2');
       $dcto3 = $clase->BDLockup($docuid,'docucompra','docuid','dcto3');	 	 
       $dcto4 = $clase->BDLockup($docuid,'docucompra','docuid','dcto4');	 	 
   	  
       $vsql = "SELECT DISTINCT DD.porciva ivadig , P.porciva ivapro , DD.* , P.* , DDO.* 
                FROM dedocumentos DD INNER JOIN productos P ON (P.productoid = DD.productoid) 
                LEFT JOIN dedocuorden DDO ON (DDO.dedocumid = DD.dedocumid)
                WHERE docuid = ".$docuid;             
       $conex  = $clase->Conectar();
       $result = @mysql_query($vsql,$conex);
	     $mensaje = "";

       while($row = @mysql_fetch_array($result)) 
       {
            $productoid   = $row['productoid'];

            $dctol1 = $row['dctol1'];
            $dctol2 = $row['dctol2'];
            $dctol3 = $row['dctol3'];
            $dctol4 = $row['dctol4'];

            //$valor        = ($row['valparcial']/($row['cantidad']+$row['obsequio']));
            $valor        = (($row['valunitario']*$row['cantidad'])/($row['cantidad']+$row['obsequio']));
              
            $porcutilfijo = round($row['porcutilfijo'],1);
            $costoinf     = $row['costoinf'];
            $precio1g     = $row['precio1g'];                  
            
            $valor        = @$valor-($valor*($dcto1/100));
            $valor        = @$valor-($valor*($dcto2/100));
            $valor        = @$valor-($valor*($dcto3/100));
            $valor        = @$valor-($valor*($dcto4/100));

            $valor        = @$valor-($valor*($dctol1/100));
            $valor        = @$valor-($valor*($dctol2/100));
            $valor        = @$valor-($valor*($dctol3/100));
            $valor        = @$valor-($valor*($dctol4/100));

            $nprecio      = @($valor/((100-$porcutilfijo)/100));
            
            if($precio1g < $nprecio)
            {	
              $mensaje = "Debe modificar el Precio de Venta del Producto ".$row['descripcion']." ".$precio1g." - ".$nprecio;
              return($mensaje);
              break;
            }  

            if($row['ivadig']!=$row['ivapro'])
            {	
              $mensaje = "Debe modificar el IVA del Producto ".$row['descripcion'];
              return($mensaje);
              break;
            }  
        } 
    
      return($mensaje);
   } 

   /////////////////////////////////////////////////////////////////////////////////
   /////////////////////////////////////////////////////////////////////////////////   
   function EliminarNotasDebito($docuid)
   {
      $clase = new Sistema();

      $numero = $clase->BDLockup($docuid,"documentos","docuid","numero"); 
      $haynotas = $clase->SeleccionarUno("SELECT COUNT(*) FROM documentos WHERE tipodoc = 'NDB' AND prefijo = 'DEP' AND numero LIKE 'DC".$numero."%'"); 

      if($haynotas>0)
      {
         $conex  = $clase->Conectar();
         $vsql   = "DELETE  FROM documentos WHERE tipodoc = 'NDB' AND prefijo = 'DEP' AND numero LIKE 'DC".$numero."%' AND docuid NOT IN (SELECT docuidrel FROM dedocupago) ";
         $result = @mysql_query($vsql,$conex);
  	     while($row = @mysql_fetch_array($result)) 
  	     {
  	          $XDocuid = $row['docuid'];
  	          $vsql2 = "DELETE  FROM dedocucuenta WHERE docuid=".$XDocuid;
              $clase->EjecutarSQL($vsql2);      
              $vsql2 = "DELETE  FROM documentos WHERE docuid=".$XDocuid;
              $clase->EjecutarSQL($vsql2);
  	     } 	
      }      
   }	

   /////////////////////////////////////////////////////////////////////////////////
   /// Genera Automaticamente una Nota Debito a partir de una Factura de Compra
   /////////////////////////////////////////////////////////////////////////////////   
   function GenerarNotaDescuento($docuid,$dcto,$BaseNota,$numnota=1,$tipodescuento="P")
   {
      $clase = new Sistema();
      $conex  = $clase->Conectar();
	    $vsql = "SELECT * FROM documentos WHERE docuid=".$docuid; 
      $result = @mysql_query($vsql,$conex);
	    if($row = @mysql_fetch_array($result)) 
	    {
  	     $tipodoc     = $row['tipodoc'];
  	     $prefijo     = "DEF";
  	     $numero      = $row['numero']."-".$numnota;	
  	     
         $fechadoc    = $row['fechadoc'];	
  	     $fecasentado = $fechadoc;
  	     $fecvence    = $row['fecvence'];
  	     $periodo     = $row['periodo'];
  	     $nrodocref   = $row['tipodoc'].$row['prefijo'].$row['numero'];
  	     $terid1      = $row['terid1'];
  	     $base        = (($row['total']+$row['ajusteneto'])*(-1));
  	     $iva         = 0;
  	     $total       = (($row['total']+$row['ajusteneto'])*(-1));
  	     $sucursalid  = $row['sucursalid'];			     
  	     $creador     = $row['creador'];			     
         $porcen      = $dcto;
  	     $observ      = "Nota Debito Automatica No. ".$tipodoc." ".$prefijo." ".$numero."-".$numnota." | Descuento acordado : ".$porcen." % - Valor Base Dcto ".number_format($BaseNota);
  	     
	       if($tipodescuento == "P")
	         $totalnota   = ($BaseNota*($dcto/100));
	       else
           $totalnota   = ($dcto);
      }
      
      //// Primero la Busco y si está la Borro
      $existe = $clase->SeleccionarUno("SELECT docuid FROM documentos WHERE tipodoc = '".$tipodoc."' AND prefijo = '".$prefijo."' AND numero = '".$numero."'");
      if($existe != "")
      {
         $vsql3 = "DELETE  FROM dedocucuenta WHERE docuid=".$existe;
         $clase->EjecutarSQL($vsql3);      

         $vsql3 = "DELETE  FROM documentos WHERE docuid=".$existe;
         $clase->EjecutarSQL($vsql3);      
      }
           
      /// Inserto el Documento de Tesoreria - La Nota Debito
      if($totalnota > 999)
      {
           $vsql3 = "INSERT INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecasentado,fecvence,formapago,observacion,nrodocref,terid1,base,iva,total,saldo,sucursalid,creador,momento) 
                     VALUES('NDB','".$prefijo."','DC".$numero."','".$periodo."','".$fechadoc."','".$fecasentado."','".$fecvence."','CR','".$observ."','".$nrodocref."',".$terid1.",".$totalnota.",".$iva.",".$totalnota.",".$totalnota.",".$sucursalid.",'".$creador."',
                     CURRENT_TIMESTAMP)"; 
           $clase->EjecutarSQL($vsql3);      

           /// Busco el Docuid Insertado
           $NDOCUIDX = $clase->SeleccionarUno("SELECT docuid FROM documentos WHERE tipodoc = 'NDB' AND prefijo = '".$prefijo."' AND numero = '".$numero."'");      
      
           /// Inserto el Detalle del Concepto
           $vsql3 = "INSERT INTO dedocucuenta(docuid,concid,item,valor,interes,capital,valorini,doculpago,feculpago,teridpago,detalle,fecvence) 
                     VALUES(".$NDOCUIDX.",6,'001',".$totalnota.",0,".$totalnota.",".$totalnota.",'','0000-00-00',1,'".$nrodocref."','0000-00-00')"; 
           $clase->EjecutarSQL($vsql3);   	
           
           /// Paso a Negativo el Saldo por ser de Tipo NDB
           $clase->EjecutarSQL("UPDATE documentos SET base = (ABS(base)*(-1)) , total = (ABS(total)*(-1)) , saldo = (ABS(saldo)*(-1)) WHERE docuid = ".$NDOCUIDX);
      }
      
   }


   ///////////////////////////////////////////////////////////
   /// Regenera las Notas de Compras con Descuentos  
   ///////////////////////////////////////////////////////////
   function GenerarNotasCompra($docuid)
   {
      $clase = new Sistema();
      $conex  = $clase->Conectar();

      /// Primero Elimino las Existentes
      EliminarNotasCompra($docuid);
      
      /// Busco si hay descuentos en el Encabezado
      $dctonota1 = $clase->BDLockup($docuid,'docuorden','docuid','dcto3');  
      $dctonota2 = $clase->BDLockup($docuid,'docuorden','docuid','dcto4');
      
      //// Nota DB Corresponde al DCTO 3 del Encabezado de la FCO    
      if($dctonota1 > 0)
      {
           $base  = $clase->BDLockup($docuid,'documentos','docuid','total');
           GenerarNotaDescuento($docuid,$dctonota1,$base,1);
      }         

      //// Nota DB Corresponde al DCTO 4 del Encabezado de la FCO
      if($dctonota2 > 0)
      {
           $base  = $clase->BDLockup($docuid,'documentos','docuid','total');
           GenerarNotaDescuento($docuid,$dctonota2,$base,2);
      }

      ///// Busco si algun producto (DEDOCUMENTO) tiene Nota
      $vsql = "SELECT (DD.valunitario * DD.cantidad) valor , DDO.dctol3 , DDO.dctol4 
               FROM dedocumentos DD INNER JOIN dedocuorden DDO ON (DD.dedocumid = DDO.dedocumid) 
               WHERE DD.docuid = ".$docuid." AND (DDO.dctol3 > 0 OR DDO.dctol4 > 0)";
      $conex  = $clase->Conectar();
      $result = mysql_query($vsql,$conex); 
      $numnota = 3;
      while($row = mysql_fetch_array($result))  
      {
         $basenotas = $row['valor']*(-1);
         $dctonota3 = $row['dctol3'];
         $dctonota4 = $row['dctol4'];
         
         ///// Solo Genero la Nota si la BASE es Superior a $ 1000 y tiene Descto 3 en la Linea  
         if(($dctonota3 > 0)&&($basenotas>999))     
            GenerarNotaDescuento($docuid,$dctonota3,$basenotas,$numnota);  

         ///// Solo Genero la Nota si la BASE es Superior a $ 1000 y tiene Descto 3 en la Linea  
         if(($dctonota4 > 0)&&($basenotas>999))     
            GenerarNotaDescuento($docuid,$dctonota4,$basenotas,$numnota+1);  

         $numnota += 2;
      }   
   }

   ///////////////////////////////////////////////////////////
   /// Elimina las Notas Debito que tiene la Fact Compra 
   ///////////////////////////////////////////////////////////
   function EliminarNotasCompra($docuid)
   {
      $clase = new Sistema();
      $conex  = $clase->Conectar();
      
      $prefijo = $clase->BDLockup($docuid,"documentos","docuid","prefijo");
      $numero  = $clase->BDLockup($docuid,"documentos","docuid","numero");

      $vsql1 = "SELECT docuid FROM documentos WHERE tipodoc = 'NDB' AND prefijo = '".$prefijo."' AND numero LIKE 'DC".$numero."%'";
      $conex  = $clase->Conectar();
      $result = mysql_query($vsql1,$conex);
      while($row = mysql_fetch_array($result)) 
      { 
         $DOCUIDXDEL = $row['docuid'];
         
         $vsql3 = "DELETE  FROM dedocucuenta WHERE docuid=".$DOCUIDXDEL;
         $clase->EjecutarSQL($vsql3);      

         $vsql3 = "DELETE  FROM documentos WHERE docuid=".$DOCUIDXDEL;
         $clase->EjecutarSQL($vsql3);      
         
      }   
      return;
   }

   /////////////////////////////////////////////////////////////////////////////////
   /////////////////////////////////////////////////////////////////////////////////
   function CopiarCompraAServidor($docuid)
   {
     $clase = new Sistema();

     //// Conexion al Servidor
     $host     = "192.168.14.252";                 $username = "root";
     $password = "123";                            $db_name  = "droposservidordb";	   

     //// 1 Paso - Documentos
     $vsql1  = "SELECT DS.docuid2 , D.* FROM documentos D LEFT JOIN docuself DS ON (D.docuid = DS.docuid) WHERE D.docuid = ".$docuid;
     $conex  = $clase->Conectar();
     $result = mysql_query($vsql1,$conex);
     if($row = mysql_fetch_array($result)) 
     { 
        $OCid  = $row['docuid2'];

        $vsql2 = "INSERT INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecvence,fecasentado,fecanulado,formapago,nrodocref,
        	      terid1,terid2,terid3,codigo1,codigo2,codigo3,observacion,observacion2,retefuente,descuentogen,base,iva,total,saldo,
        	      impreso,totalitems,sucursalid,creador,momento) VALUES('".$row['tipodoc']."','".$row['prefijo']."','".$row['numero']."',
        	      '".$row['periodo']."','".$row['fechadoc']."','".$row['fecvence']."','".$row['fecasentado']."','".$row['fecanulado']."',
        	      '".$row['formapago']."','".$row['nrodocref']."','".$row['terid1']."','".$row['terid2']."','".$row['terid3']."',
        	      '".$row['codigo1']."','".$row['codigo2']."','".$row['codigo3']."','".$row['observacion']."','".$row['observacion2']."',
        	      '".$row['retefuente']."','".$row['descuentogen']."','".$row['base']."','".$row['iva']."','".$row['total']."',
        	      '".$row['saldo']."','".$row['impreso']."','".$row['totalitems']."','".$row['sucursalid']."','".$row['creador']."',
        	      '".$row['momento']."')";

        $enlace = mysql_connect($host, $username, $password)or die("cannot connect");
	    if (!$enlace)  $clase->Aviso(3,'Error al Conectarse al Servidor.' . mysql_error());
        mysql_select_db($db_name)or die("Base de Datos NO existe");
        
        $rx = mysql_query($vsql2,$enlace);
   
        $vsql3   = "SELECT docuid FROM documentos WHERE CONCAT(tipodoc,prefijo,numero) = '".$row['tipodoc'].$row['prefijo'].$row['numero']."'";
        $resultx = mysql_query($vsql3,$enlace); 
        if($rowx = mysql_fetch_array($resultx)) 
           $NDOCUIDX = $rowx['docuid'];        
     }
    
    
     // 2 Paso - Docucompra
     $vsql1 = "SELECT * FROM docucompra WHERE docuid=".$docuid;
     $conex  = $clase->Conectar();
     $result = mysql_query($vsql1,$conex);
     if($row = mysql_fetch_array($result)) 
     { 
        $vsql4 = "INSERT INTO docucompra(docuid,dcto1,dcto2,dcto3,dcto4,aplicarcondipro,diasplazo,paradias,aplicar2) VALUES(
                 '".$NDOCUIDX."','".$row['dcto1']."','".$row['dcto2']."','".$row['dcto3']."','".$row['dcto4']."','".$row['aplicarcondipro']."',
        	     '".$row['diasplazo']."','".$row['paradias']."','".$row['aplicar2']."')";
        
        $vsql44 = "INSERT INTO docuself(docuid,docuid2) VALUES(".$NDOCUIDX.",".$OCid.")";      
        
        $enlace = mysql_connect($host, $username, $password)or die("cannot connect");
	    if (!$enlace)  $clase->Aviso(3,'Error al Conectarse al Servidor.' . mysql_error());
        mysql_select_db($db_name)or die("Base de Datos NO existe");
        
        $rx = mysql_query($vsql4,$enlace); 

        $rx = mysql_query($vsql44,$enlace); 
     }
 
     // 4 Paso - Dedocumentos
     $vsql1 = "SELECT * FROM dedocumentos WHERE docuid=".$docuid;
     $conex  = $clase->Conectar();
     $result = mysql_query($vsql1,$conex);
     while($row = mysql_fetch_array($result)) 
     { 
        $vsql5 = "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,tipund,costoprod,valunitario,valdescuento,
        	      valparcial,porciva,valbase,valiva,valtotal,diasrecor,obsrecor,numlinea,docuref,unicom,unifra) VALUES(
                 '".$NDOCUIDX."','".$row['productoid']."','".$row['bodegaid']."','".$row['cantidad']."','".$row['unidades']."','".$row['tipund']."',
        	     '".$row['costoprod']."','".$row['valunitario']."','".$row['valdescuento']."','".$row['valparcial']."','".$row['porciva']."',
        	     '".$row['valbase']."','".$row['valiva']."','".$row['valtotal']."','".$row['diasrecor']."','".$row['obsrecor']."',
        	     '".(0+$row['numlinea'])."','".$row['docuref']."','".$row['unicom']."','".$row['unifra']."')";
        
        $enlace = mysql_connect($host, $username, $password)or die("cannot connect");
	    if (!$enlace)  $clase->Aviso(3,'Error al Conectarse al Servidor.' . mysql_error());
        mysql_select_db($db_name)or die("Base de Datos NO existe");
        $rx = mysql_query($vsql5,$enlace); 
 
        $vsql6 = "SELECT MAX(dedocumid) dedocumid FROM dedocumentos WHERE docuid=".$NDOCUIDX;
        $resultx = mysql_query($vsql6,$enlace); 
        if($rowx = mysql_fetch_array($resultx)) 
           $DDIDX = $rowx['dedocumid'];

        // 4 Paso - Dedocumentos
        $vsql10 = "SELECT * FROM dedocuorden WHERE dedocumid=".$row['dedocumid'];
        $conex  = $clase->Conectar();
        $result10 = mysql_query($vsql10,$conex);
        if($row10 = mysql_fetch_array($result10)) 
        { 
           $vsql7 = "INSERT INTO dedocuorden(dedocumid,precioant,dctol1,dctol2,dctol3,dctol4,obsequio) VALUES('".$DDIDX."',
                   '".$row10['precioant']."','".$row10['dctol1']."','".$row10['dctol2']."','".$row10['dctol3']."','".$row10['dctol4']."',
                   '".$row10['obsequio']."')";
           
           $enlace = mysql_connect($host, $username, $password)or die("cannot connect");
	       if (!$enlace)  $clase->Aviso(3,'Error al Conectarse al Servidor.' . mysql_error());
           mysql_select_db($db_name)or die("Base de Datos NO existe");
           $rx = mysql_query($vsql7,$enlace); 
        }

      }
     return(true);
  }
  

  ////////////////////////////////////////////////////////////////
  function refrescarRetefuente($docuid)
  {
     $clase = new Sistema();
     
     $terid   = $clase->BDLockup($docuid,"documentos","docuid","terid1");
     $porcent = $clase->BDLockup($terid,"terceros","terid","porreteftecom");
     $base    = $clase->BDLockup($docuid,"documentos","docuid","(base+impoconsumo)"); 
     $tope    = $_SESSION['G_TOPERETEFUENTE'];
     $retencion = ($base*($porcent/100)); 
     
     if(($retencion > 0)&&($base > $tope )) 
     {
       $clase->EjecutarSQL("UPDATE documentos SET retefuente = ".$retencion." WHERE docuid = ".$docuid);
       refrescarReteica($docuid);
     }
     else
        $clase->EjecutarSQL("UPDATE documentos SET retefuente = 0 WHERE docuid = ".$docuid); 
     
     return;  
  } 

  
  ////////////////////////////////////////////////////////////////
  function refrescarReteica($docuid)
  {
     $clase = new Sistema();
     
     $terid       = $clase->BDLockup($docuid,"documentos","docuid","terid1");
     $esautorret  = $clase->BDLockup($terid,"terceros","terid","autoret2");
     $base        = $clase->BDLockup($docuid,"documentos","docuid","(base+impoconsumo)"); 
     $tope        = $_SESSION['G_TOPERETEFUENTE'];
     $codsucursal = $clase->SeleccionarUno("SELECT S.codigo FROM sucursales S INNER JOIN documentos D ON (S.sucursalid = D.sucursalid) WHERE D.docuid=".$docuid);

     if($codsucursal == '00')   $porcent = '0.6';
     if($codsucursal == 'DB')   $porcent = '0.7';
     $retencion  = ($base*($porcent/100)); 

     if(($retencion > 0)&&($base > $tope )&&($esautorret != "CHECKED")) 
        $clase->EjecutarSQL("UPDATE documentos SET reteica = ".$retencion." WHERE docuid = ".$docuid);
     else
        $clase->EjecutarSQL("UPDATE documentos SET reteica = 0 WHERE docuid = ".$docuid); 
     
     return;  
  }

  ////////////////////////////////////////////////////////////////////////////////////////
  ///// Funcion para saber si una Factura de Compra se puede reversar o NO
  ///// Retorna 1 en caso afirmativo , 0 en caso Negativo
  function SePuedeReversar($docuid)
  {
      $clase = new Sistema();

      $retorno = 1;

      $vsql = "SELECT COM.docuid docuid1 , COM.fecasentado fecasentado1 , CXP.docuid docuid2 , CXP.fecasentado fecasentado2 , DDP.docuid docuid3
               FROM documentos COM LEFT JOIN documentos CXP ON (COM.numero = CXP.numero AND CXP.tipodoc = 'CXP')
               LEFT JOIN dedocupago DDP ON (DDP.docuidrel = CXP.docuid)
               WHERE COM.docuid = '".$docuid."'";
      $conex  = $clase->Conectar();
      $result = mysql_query($vsql,$conex);
      if($row = mysql_fetch_array($result)) 
      {       
           //// Si está en un Comprobante de Egreso -> NO
           if(strlen($row['docuid3'])>0)
             $retorno = 0;
      }

      return($retorno);  
  } 
  /////////////////////////////////////////////////////////////////////////////////////////
  function PermisosEspeciales($item, $docuid)
  {
  	 $conta ='<table width="100%">	
	          <tr class="BarraDocumentos">';
     if($item == 1)			  
	    $conta.='<td width="50%" class="BarraDocumentosSel" align="center"> <b> Diferencias en Precios de Productos </b> </td>';
     else
	    $conta.='<td width="50%" align="center"> <a href="compras.php?opcion=analisiscosto&docuid= '.$docuid.'"> Diferencias en Precios de Productos </td>';

     if($item == 2)			  
	    $conta.='<td width="50%" class="BarraDocumentosSel" align="center"> <b> Detalle de la Compra Producto a Producto </b> </td>';
     else
	    $conta.='<td width="50%" align="center"> <a href="compras.php?opcion=detalleproducto&docuid='.$docuid.'"> Detalle de la Compra Producto a Producto </a> </td>';
				
   	$conta.='</tr></table>';	 
   	return($conta);			 
  }

  ///////////////////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////////////////
  function ReemplazarCantidadesTRB($docuid,$numerocod)
  {
      $clase = new Sistema();
      $docuidtrb = $clase->SeleccionarUno("SELECT docuid FROM documentos WHERE CONCAT(tipodoc,prefijo,numero) = '".$numerocod."'");
      $bodegaid  = $clase->BDLockup("50","bodegas","codbodega","bodegaid");
      $bodegaid  = 2;

      $vsql   = "SELECT DD.productoid , SUM(DD.cantidad) canti , SUM(DD.unidades) uni , 
                (SELECT SUM(DD.cantidad) FROM dedocumentos WHERE productoid = DD.productoid AND docuid = ".$docuidtrb.") canti2 , 
                (SELECT SUM(DD.unidades) FROM dedocumentos WHERE productoid = DD.productoid AND docuid = ".$docuidtrb.") uni2 
                FROM documentos D INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) 
                WHERE D.docuid = ".$docuid." GROUP BY 1 ";

      $conex  = $clase->Conectar();
      $result = mysql_query($vsql,$conex);
      $haycambio = 0;
      while($row = mysql_fetch_array($result)) 
      {       
          $vsql1 = "UPDATE docutranfe SET bodegaidori = ".$bodegaid." WHERE docuid = ".$docuidtrb; 
          $clase->EjecutarSQL($vsql1); 
          $haycambio++;
        
          $vsql1 = "UPDATE dedocumentos SET bodegaid = ".$bodegaid." , cantidad = ".$row['canti']." , unicom = ".$row['canti']." , unifra = 0 WHERE docuid = ".$docuidtrb." AND productoid = ".$row['productoid']; 
          $clase->EjecutarSQL($vsql1); 
          $haycambio++;
         
          $vsql2 = "UPDATE dedocumentos SET unidades = ".$row['uni']." WHERE docuid = ".$docuidtrb." AND productoid = ".$row['productoid'];
          $clase->EjecutarSQL($vsql2); 
          $haycambio++;
      }

      if($haycambio>0)
      {
          /// La Re-Asiento la TRB 
          $clase->EjecutarSQL("CALL PA_AsentarTransferencia(".$docuidtrb.")");

          /// Regenero el Movimiento en la Sucursal
          GenerarAServidorCod($docuidtrb);

          /// Notifico con el Correo
          EnviarCorreoNotificacionTRB($docuidtrb);
      }
      return;
  }

  ///////////////////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////////////////
  function ReemplazarCantidadesTRBnueva($docuid,$numerocod)
  {
    $clase = new Sistema();
    $docuidtrb = $clase->SeleccionarUno("SELECT docuid FROM documentos WHERE CONCAT(tipodoc,prefijo,numero) = '".$numerocod."'");
    $bodegaid  = $clase->BDLockup("COD","bodegas","codbodega","bodegaid");
    $sucursalid = $clase->BDLockup($docuid,"documentos","docuid","sucursalid");
    
    //if($sucursalid == "53") $bodegaid = $clase->BDLockup("DB","bodegas","codbodega","bodegaid");
    //else                    $bodegaid = $clase->BDLockup("50","bodegas","codbodega","bodegaid");

    //// Fijo todas las compras saldrán de COD
    $bodegaid = $clase->BDLockup("COD","bodegas","codbodega","bodegaid");
    
    /// Marco cuando hay Cambios
    $haycambio = 0;
    
    if($docuidtrb!="")
    {
          /// Selecciono lo que tiene
          $vsql   = "SELECT DD.productoid , SUM(DD.cantidad) canti , SUM(DD.unidades) uni , 
                      (SELECT SUM(DD.cantidad) FROM dedocumentos WHERE productoid = DD.productoid AND docuid = ".$docuidtrb.") canti2 , 
                      (SELECT SUM(DD.unidades) FROM dedocumentos WHERE productoid = DD.productoid AND docuid = ".$docuidtrb.") uni2 
                      FROM documentos D INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) 
                      WHERE D.docuid = ".$docuid." GROUP BY 1 ";
      
          //// Recorro el resultado
          $conex  = $clase->Conectar();
          $result = mysql_query($vsql,$conex);
          $registros = mysql_num_rows($result);
      
          if($registros > 0)
          {
                  //// Elimino todas las lineas que tenga el COD
                  $vsql3 = "DELETE FROM dedocumentos WHERE docuid = ".$docuidtrb;
                  $clase->EjecutarSQL($vsql3);	
              
                  while($row = mysql_fetch_array($result)) 
                  {       
                      /// Cambio la Bodega Origen a la Transferencia de la COD por la 50 
                      $vsql = "UPDATE docutranfe SET bodegaidori = ".$bodegaid." WHERE docuid = ".$docuidtrb;
                      $clase->EjecutarSQL($vsql);	
                      
                      /// Busco el Costo
                      $costo = $clase->BDLockup($row['productoid'],"productos","productoid","costoinf"); 
                      
                      /// Inserto el detalle del Documento
                      $vsql = "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,valunitario,valparcial,porciva,valbase,valiva,valtotal,unicom,unifra) VALUES(".
                      $docuidtrb.",".$row['productoid'].",".$bodegaid.",".$row['canti'].",".$row['uni'].",".$costo.",".$costo.",0,".$costo.",0,".$costo.",".$row['canti'].",0)";
                      $clase->EjecutarSQL($vsql);	
                      
                      $haycambio++;
                  }
          }
             
          /// La Re-Asiento la TRB 
          $clase->EjecutarSQL("CALL PA_AsentarTransferencia(".$docuidtrb.")");
      
          /// Regenero el Movimiento en la Sucursal
          GenerarAServidorCod($docuidtrb);
      
          /// Notifico con el Correo
          //EnviarCorreoNotificacionTRB($docuidtrb);
    }
    return;
  }


  //////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////
  function EnviarCorreoNotificacionTRB($docuid)
  {
        $linea = "";      $cont="";
        
        $clase  = new Sistema();
        $numero = $clase->BDLockup($docuid,"documentos","docuid","numero"); 
        
        $bodegaid   = $clase->BDLockup($docuid,"docutranfe","docuid","bodegaiddes");
        $sucursalid = $clase->BDLockup($bodegaid,"bodegas","bodegaid","sucursalid");
        $correo     = $clase->BDLockup($sucursalid,"sucursales","sucursalid","email");

        require 'lib/PHPMailer/PHPMailerAutoload.php';
        $mail = new PHPMailer;
        $mail->isSMTP();
        $mail->SMTPDebug = 0;
        if($_SESSION['G_TIPOCORREO'] == "HTML")
          $mail->Debugoutput = 'html'; 
        
        $mail->Host = $_SESSION['G_HOSTCORREO'];
        $mail->Port = 587;
        $mail->SMTPSecure = 'tls';
        $mail->SMTPAuth = true;
        $mail->Timeout = 20;
        $mail->CharSet = 'UTF-8';
        $mail->Username = $_SESSION['G_USERCORREO'];
        $mail->Password = $_SESSION['G_CLAVECORREO'];
        $mail->setFrom('sistemas@dromedicas.com.co', 'DROPOS ERP App');
        $mail->addReplyTo('sistemas@dromedicas.com.co', 'DROPOS ERP App');
        
        $mail->addAddress($correo, "Sucursal Farmanorte");
        //$mail->addAddress('sistemas@dromedicas.com.co', "Sucursal Farmanorte");
        $mail->addAddress('asistentecompras@dromedicas.com.co', "Sucursal Farmanorte");
        $mail->addAddress('johnduran@dromedicas.com.co', "Sucursal Farmanorte");
        
        $mail->Subject = 'Se Modifico la Transferencia de Compra Directa TRBCOD'.$numero;
        $mail->isHTML(true);       
        $mail->Body = "<br><br>Se modific&oacute; el contenido de la Transferencia de Compra de Directa No. <b>TRBCOD".$numero.".</b>
                      <br><br>
                      Favor revise sus inventarios y haga kardex al producto.<br>";
        $mail->send();
        return; 
  }

  //////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  function GenerarAServidorCod($docuid)
  {
      $linea = "";      $cont="";
      $clase = new Sistema();
     
      //// Datos del Tercero
      $vsql="SELECT T.* FROM terceros T INNER JOIN documentos D ON (T.terid = D.terid1) WHERE D.docuid=".$docuid;
      $conex  = $clase->Conectar();
      $result = mysql_query($vsql,$conex);
      if($row = mysql_fetch_array($result))
      {
          $linea = "INSERT IGNORE INTO terceros(codigo,dni,tipodoc,apellidos,nombres,telfijo,telmovil,ciudadid,zonaterid,gruposperid,escliente,creador,momento) VALUES('".$row['codigo']."','".$row['dni']."','".$row['tipodoc']."','".$row['apellidos']."','".$row['nombres']."','".$row['telfijo']."','".$row['telmovil']."',1,1,1,'S','".$row['creador']."','".$row['momento']."');";
          $cont.= $linea.Chr(13).Chr(10);      
      }   
      
      //// Datos del Documento
      $vsql="SELECT * FROM documentos WHERE docuid=".$docuid;
      $conex  = $clase->Conectar();
      $result = mysql_query($vsql,$conex);
      if($row = mysql_fetch_array($result))
      {
          $linea = "*INSERT IGNORE INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,formapago,terid1,terid2,terid3,observacion,base,iva,total,impreso,totalitems,sucursalid,nrodocref,creador,momento) VALUES('".$row['tipodoc']."','".$row['prefijo']."','".$row['numero']."','".$row['periodo']."','".$row['fechadoc']."','".$row['formapago']."',1,1,1,'".trim(strtoupper(eregi_replace("[\n|\r|\n\r]",' ',$row['observacion'])))."',".$row['base'].",".$row['iva'].",".$row['total'].",'".$row['impreso']."',".$row['totalitems'].",".$row['sucursalid'].",'".$row['nrodocref']."','".$row['creador']."','".$row['momento']."');";
          $cont.= $linea.Chr(13).Chr(10); 
          $nombresincro = $row['tipodoc'].$row['prefijo'].$row['numero'];
      }  

      //// Comando *SEL-DOCUID
      $linea = "|SELECTUNO|SELECT docuid FROM documentos WHERE CONCAT(tipodoc,prefijo,numero)='".$nombresincro."'";
      $cont .= $linea.Chr(13).Chr(10); 
      
      /// Genero 2 Tipos de Documento - 1 de Salida de la Bodega de Origen y otro de Entrada Normal
      //// Detalles del Documento
      $vsql="SELECT * FROM dedocumentos WHERE docuid=".$docuid;
      $conex  = $clase->Conectar();
      $result = mysql_query($vsql,$conex);
      
      $cont1 = $cont;   /// Bodega Origen
      $cont2 = $cont;   /// Bodega Destino

      //////////////////////////////////////////////////////////////////////////////////////////////
      while($row = @mysql_fetch_array($result))
      {
        $linea = "**DELETE FROM dedocumentos WHERE docuid = ||||| AND productoid = ".$row['productoid']." AND cantidad = ".$row['cantidad'].";";     
        $cont1.= $linea.Chr(13).Chr(10);       
        $linea = "**INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,valunitario,valdescuento,valparcial,porciva,valbase,valiva,valtotal) VALUES(|||||,".$row['productoid'].",".$row['bodegaid'].",".$row['cantidad'].",".$row['unidades'].",".$row['valunitario'].",".$row['valdescuento'].",".$row['valparcial'].",".$row['porciva'].",".$row['valbase'].",".$row['valiva'].",".$row['valtotal'].");";     
        $cont1.= $linea.Chr(13).Chr(10);       

        $linea = "**DELETE FROM dedocumentos WHERE docuid = ||||| AND productoid = ".$row['productoid']." AND cantidad = ".$row['cantidad'].";";     
        $cont2.= $linea.Chr(13).Chr(10);       
        $linea = "**INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,valunitario,valdescuento,valparcial,porciva,valbase,valiva,valtotal) VALUES(|||||,".$row['productoid'].",".$row['bodegaid'].",".$row['cantidad'].",".$row['unidades'].",".$row['valunitario'].",".$row['valdescuento'].",".$row['valparcial'].",".$row['porciva'].",".$row['valbase'].",".$row['valiva'].",".$row['valtotal'].");";   
        $cont2.= $linea.Chr(13).Chr(10);       
      }  
      
      ///////////////////////////////////////////////////////////////////
      //// Docutranfe
      ///////////////////////////////////////////////////////////////////
      $vsql="SELECT * FROM docutranfe WHERE docuid=".$docuid;
      $conex  = $clase->Conectar();
      $result = mysql_query($vsql,$conex);
      while($row = mysql_fetch_array($result))
      {
          $bodegades  = $row['bodegaiddes'];
          $bodegaori  = $row['bodegaidori'];    
          $codbodegaori = $clase->BDLockup($bodegaori,"bodegas","bodegaid","codbodega"); 
          $codbodegades = $clase->BDLockup($bodegades,"bodegas","bodegaid","codbodega");
          $carpetaori = $clase->SeleccionarUno("SELECT codigo FROM sucursales S INNER JOIN bodegas B ON (B.sucursalid = S.sucursalid) WHERE B.bodegaid = ".$bodegaori);
          $carpetades = $clase->SeleccionarUno("SELECT codigo FROM sucursales S INNER JOIN bodegas B ON (B.sucursalid = S.sucursalid) WHERE B.bodegaid = ".$bodegades);

          $linea = "***INSERT INTO docutranfe(docuid,bodegaidori,bodegaiddes,kardexori,kardexdes,codbarra,enviado,planogen) VALUES(|||||,".$row['bodegaidori'].",".$row['bodegaiddes'].",'".$row['kardexori']."','".$row['kardexdes']."','".$row['codbarra']."','".$row['enviado']."','S');";
          $cont1.= $linea.Chr(13).Chr(10);       
          $cont2.= $linea.Chr(13).Chr(10);       
      }    

      ///////////////////////////////////////////////////////////////////////////
      /////  DESTINO es diferente a la bodega Actual la envio
      ///////////////////////////////////////////////////////////////////////////
      $directorio = "../Dropbox/Todos/".$carpetades."/automatico/"; 
      $archivo    = "../Dropbox/Todos/".$carpetades."/automatico/".$nombresincro.".txt"; 
      $archivoz   = "../Dropbox/Todos/".$carpetades."/automatico/DES".$nombresincro.".zip"; 
      $archivod   = "../Dropbox/Todos/".$carpetades."/transferencias/".$nombresincro.".txt"; 

      if(file_exists($archivo))
          unlink($archivo);
          
      ///// Creo nuevamente el Archivo con el nuevo contenido
      $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
      if($fch)
      {
          fwrite($fch, $cont1); // Grabas
          fclose($fch); // Cierras el archivo  
      }

      //// Creo nuevamente el Archivo con el nuevo contenido
      $fch= fopen($archivod, "w"); // Abres el archivo para escribir en él
      if($fch)
      {
          fwrite($fch, $cont1); // Grabas
          fclose($fch); // Cierras el archivo  
      }
      
      //// Lo comprimo en ZIP
      include('lib/pclzip/pclzip.lib.php');
      $archive = new PclZip($archivoz);
      $archive->add($archivo, PCLZIP_OPT_REMOVE_PATH, $directorio);
      unlink($archivo); 
      
  }  //// Fin de la Funcion
  
?>