<?php
/**
 * Ejemplo simple de Uso de un Webservice
 * @author Milagros Rodriguez
 * @version v1.0
 * @return  Datos del Producto en Formato JSON
 **/

// Vinculo el Archivo de la API
require_once 'api.php';

// Crea una nueva Instancia de la API del Producto
$api = new api();

// message to return
$message = array();

// Capturo el Metodo -> GET -> POST -> PUT -> DELETE
$method = $_SERVER['REQUEST_METHOD'];

//// Parametros que se le pasan a los métodos del WebService
$params = array();

switch($method)
{
	///////////////////////////////////////////////////////////////////////////////////////
	///// GET -> Obtiene la Lista de Productos o los datos de un producto con id = ID
	case 'GET':
	
		$params['id']          = $_GET["id"];
		$params['valor']       = $_GET["valor"];
		$params['idsuc']       = $_GET["idsuc"];
		$params['numfact']     = $_GET["numfact"];
		$params['totfact']     = $_GET["totfact"];
		$params['idafiliado']  = $_GET["idafiliado"];

		if(strlen($_GET["id"]) != "")
        {
			$data = $api->getAcumularPuntos($params);
			
			if(strlen($data)>0)
			{
				if($data == "1")
				{
					response(200,"sucess","Canje de puntos realizados",$data);
					exit;
				}
				else
				{
					$message["code"] = "0";
					$message["data"] = "";
					response(400,"error","Puntos Insuficientes",$data);				
					exit;
				}
				
			} else {
				$message["code"] = "0";
				$message["message"] = "Parametros Incorrectos al Webservice";
				response(400,"error","Existencia Producto",$data);
				exit;
			}	
        }
		else
		{
            $data = "ERROR : Es obligatorio Enviar un Parametro para consultar Existencia";
            $message["code"] = "0";
		 	$message["data"] = $data;		  
		}

	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// POST -> Crear Nuevo Producto
    case 'POST':
		    $data = "ERROR : No está Admitida la creacion de Productos Via WebService";
		    $message["code"] = "0";
		 	$message["data"] = $data;		  
	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// PUT -> Actualizar Datos del Producto
    case 'PUT':
		    $data = "ERROR : No está Admitida la Actualizacion de Productos Via WebService";
		    $message["code"] = "0";
		 	$message["data"] = $data;		  
	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// POST -> Crear Nuevo Producto
    case 'DELETE':
		    $data = "ERROR : No está Admitida la creacion de Productos Via WebService";
		    $message["code"] = "0";
		 	$message["data"] = $data;		  
	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// En caso de no ser ninguno de los Metodos permitidos muestro el error
	default://metodo NO soportado
       echo 'METODO NO SOPORTADO';
    break;
}

//////////////////////////////////////////////////////////////
//// Genera la Respuesta en Formato JSON
//////////////////////////////////////////////////////////////
function response($code=200, $status="", $message="" , $data="") 
{
    $status = strtolower($status);
    $response = array("code" => $code , "status" => $status ,"message" => $message , "data" => $data);
    echo json_encode($response);
 }   

?>
