<?php
include("../../lib/Sistema.php");
require_once('../../lib/PHPMailer/PHPMailerAutoload.php');

/**
 * Clase API del WebService
 * Permite hacer las 4 Actividades Básicas CRUD a la Tabla Existencias
 * Desde WebService
 * @author Said Rodriguez
 * @version 2017-01-28
 */

class api
{
	private $db;

	/**
	 * Constructor - Abre una conexion a la Base de Datos
	 *
	 * @param Vacío
	 * @return Conexion a la Base de Datos
	 */
	
	function __construct()
	{
		$clase = new Sistema();
		$this->db = new mysqli('192.168.14.252','root','d2218aa6664195','puntosfarmanorte');
	}

	/**
	 * Destructor - close DB connection
	 *
	 * @param Vacío
	 * @return Vacío
	 */

	function __destruct()
	{
		$this->db->close();
	}

	/**
	 * Obtiene la existencia en Sucursales del Producto consultado
	 * @param ID del Producto	 
	 * @return Lista de Existencia por Bodegas en Formato JSON
	 */
	function AfiliarPersona($params)
	{
		$query = "SELECT idafiliado FROM afiliado WHERE documento = '".$params['documento']."'";
		$list = array();
		$result = $this->db->query($query);
		while ($row = $result->fetch_assoc())
		    $ID  = $row['idafiliado'];

        /// Si Existe - Devuelve Cod 99 - Persona ya Afiliada 
        if($ID != "")
        {
	        /// Si los datos son Correctos se Actualiza el Afiliado
	        $nom = strtoupper($params['nombres']);    	            $ape  = strtoupper($params['apellidos']);
	        $tip = strtoupper($params['tipodocumento']);            $doc  = strtoupper($params['documento']);
	        $sex = strtoupper($params['sexo']);        	            $fij  = strtoupper($params['telefonofijo']);
	        $cel = strtoupper($params['celular']);    	            $ciu  = strtoupper($params['ciudad']);
	        $fna = strtoupper($params['fechanacimiento']);  	    $ema  = strtolower($params['email']);
	        $dir = strtoupper($params['direccion']);                $bar  = strtoupper($params['barrio']);
            $cla = $params['claveweb'];                             $ocu  = strtoupper($params['ocupacion']);
	        $est = strtoupper($params['estudios']);                 $hi4  = 0+strtoupper($params['hijosmenoresde4']);
	        $h412 = 0+strtoupper($params['hijosentre4y12']);        $h13  = 0+strtoupper($params['hijosentre13y18']);
            $him = 0+strtoupper($params['hijosmayores']);

	        /// Variables Fijas
	        $nac = "COL";                               $suc = 1;
	        $cre = "5";                                 $eda = (date("Y-n-d")-$fna);
	        
	        ///////////////////////////////////////////////////////////////////////
	        /// 2. Inserto el Documento
			$vsql = "UPDATE afiliado SET documento = '".$doc."' , nacionalidad = '".$nac."', nombres = '".$nom."' , apellidos = '".$ape."' , 
			         sexo = '".$sex."' , telefonofijo = '".$fij."' , celular = '".$cel."' , ciudad = '".$ciu."' , fechanacimiento = '".$fna."' , 
			         street = '".$dir."' , streetdos = '".$bar."' , email = '".$ema."' , claveweb = '".$cla."'  , ocupacion = '".$ocu."' ,  
			         estudios = '".$est."' , hijosmenoresde4 = '".$hi4."' , hijosentre4y12 = '".$h412."' , hijosentre13y18 = '".$h13."' , 
			         hijosmayores = '".$him."' WHERE idafiliado=".$ID;
			
			//// Ejecuto la Consulta SQL
			$stmt = $this->db->prepare($vsql);		            
	        $r = $stmt->execute();

	        ////////////////////////////////////////////
            /// Patologias
            for($i=1 ; $i<=25 ; $i++)
            {
	            if(strlen($params['p'.$i])>0)
				{
					$vsql = "INSERT INTO afiliadopatologia(idafiliado,idpatologia,fecha) VALUES(".$ID.",".$params['p'.$i].",CURRENT_DATE)";
					$stmt = $this->db->prepare($vsql);		            
			        $r = $stmt->execute();				
				}
            }

            ////////////////////////////////////////////
            /// Miembros del Nucleo Familiar
            $cant3 = 0 + $params['cantidadmiembro'];
            for($i=1 ; $i<=$cant3 ; $i++)
            {
	            if(strlen($params['tipomiembroval'.$i])>0)
				{
					if($i==1)
					  $vsql = "INSERT INTO nucleofamilia(idafiliado,idtipomiembro,rangoinicio,rangofin) VALUES(".$ID.",".$params['tipomiembroval'.$i].",".$params['valini'.$i].",".$params['valfin'.$i].")";
					else
					  $vsql.= " , (".$ID.",".$params['tipomiembroval'.$i].",".$params['valini'.$i].",".$params['valfin'.$i].")";	
				}
            }
			$stmt = $this->db->prepare($vsql);		            
	        $r = $stmt->execute();		

            ////////////////////////////////////////////
            /// Patologias del Nucleo Familiar
            for($i=1 ; $i<=25 ; $i++)
            {
	            if(strlen($params['pm'.$i])>0)
				{
					$vsql = "INSERT INTO afiliadopatologianucleo(idafiliado,idpatologia) VALUES(".$ID.",".$params['pm'.$i].")";
					$stmt = $this->db->prepare($vsql);		            
			        $r = $stmt->execute();				
				}
            }

            ////////////////////////////////////////////
            /// Referidos
            $cantrefe =  $params['cantreferido'];
			$correo = array();
            for($i=1 ; $i <= $cantrefe ; $i++)
            {
				$correo[$i] = $params['referido'.($i)];
				if($i==1)
            	   $vsql = "INSERT IGNORE INTO referido(idafiliado,emailreferido) VALUES (".$ID.",'".$params['referido'.($i)]."')";
            	else
            	   $vsql.= " , (".$ID.",'".$params['referido'.($i)]."')";	

            }
			$stmt = $this->db->prepare($vsql);		            
			$r = $stmt->execute();	
            
            /// Les envio el Email de Invitacion
            $this->EnviarCorreoReferido($correo);
			
	        /// Retorno 1 - Transaccion Exitosa 
	        return(1);		            
        }	  
	}

	 //////////////////////////////////////////////////////////////
  //// Envia un Correo Electronico de Invitacion al Referido
  //////////////////////////////////////////////////////////////
  function EnviarCorreoReferido($listacorreos) 
  {
  	 /// Cargo la Plantilla y posteriormente le reemplazo las variables
     try 
     {
	     $plantilla = "";
	     $ruta = "../../recursos/html/emailreferidopf.html";
	     $fp = fopen($ruta,"r");     
	     while ($linea= fgets($fp,2048))
	       $plantilla.= $linea;
	     
	     $mail = new PHPMailer;
	     $mail->isSMTP();
	     $mail->SMTPDebug = 0;
	     $mail->Debugoutput = 'html';
	     $mail->Host = 'smtp.gmail.com';
	     $mail->Port = 587;
	     $mail->SMTPSecure = 'tls';
	     $mail->SMTPAuth = true;
	     $mail->Timeout=20;
	     $mail->CharSet = 'UTF-8';
	     $mail->Username = "contacto.sms.service@gmail.com";
	     $mail->Password = "Barcelona2013.";
	     $mail->setFrom('info@puntosfarmanorte.com.co', 'Puntos Farmanorte App');
	     $mail->addReplyTo('info@puntosfarmanorte.com.co', 'Puntos Farmanorte App');
	     
	     $mail->addAddress("info@puntosfarmanorte.com.co", "Dpto Sistemas");
	     foreach ($listacorreos as $valor) 
	        $mail->AddBCC($valor , "Referido a Puntos Farmanorte");
	    
	     $mail->Subject = 'Afiliate a Puntos Farmanorte';
	     
	     $mail->isHTML(true);       
	     $mail->Body = $plantilla;
	     $mail->send();
     } 
     catch (Exception $e) 
     {
       echo 'Excepción capturada: ',  $e->getMessage(), "\n";
     }
  }

} /// Fin de la Clase API
