<?php

include("../../lib/Sistema.php");

/**
 * Clase API del WebService
 * Permite hacer las 4 Actividades Básicas CRUD a la Tabla Transferencias
 * Desde WebService
 * @author Said Rodriguez
 * @version 2017-01-30
 */

class api
{
	private $db;

	/**
	 * Constructor - Abre una conexion a la Base de Datos
	 *
	 * @param Vacío
	 * @return Conexion a la Base de Datos
	 */
	
	function __construct()
	{
		$clase = new Sistema();
		$this->db = new mysqli($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
	}

	/**
	 * Destructor - close DB connection
	 *
	 * @param Vacío
	 * @return Vacío
	 */

	function __destruct()
	{
		$this->db->close();
	}

	/**
	 * Obtiene un Listado de Transferencias (Las Ultimas 200)
	 *
	 * @param Vacio	 
	 * @return Lista de Transferencias en Formato JSON
	 */
	function getListaTransferencias()
	{
		$query = 'SELECT D.docuid , D.tipodoc , D.prefijo , D.numero , D.periodo , D.fechadoc , D.codigo1 , D.codigo2 , 
				  D.codigo3 , D.base , D.iva , D.total , D.totalitems , D.sucursalid , D.creador , D.momento ,
				  B2.codbodega codbodori , B.codbodega codboddes
				  FROM documentos D INNER JOIN docutranfe DT ON (D.docuid = DT.docuid) 
				  INNER JOIN bodegas B ON (B.bodegaid = DT.bodegaiddes) 
				  INNER JOIN bodegas B2 ON (B2.bodegaid = DT.bodegaidori) 
				  WHERE D.tipodoc = "TRB" AND D.fecasentado <> "0000-00-00" ORDER BY D.docuid DESC LIMIT 0,200';
		$list = array();
		$result = $this->db->query($query);
		while ($row = $result->fetch_assoc())
		{
			$list[] = $row;
		}
		return $list;
	}

	/**
	 * Obtiene los datos completos de una Transferencia
	 *
	 * @param Id del Documento Transferencia	 
	 * @return Lista de Datos de la Transferencia en Formato JSON
	 */
    function getDetalleTransferencia($params)
	{
		$query = 'SELECT D.tipodoc , D.prefijo , D.numero , D.periodo , D.fechadoc , D.codigo1 , D.codigo2 , D.nrodocref , 
				  D.codigo3 , D.observacion , D.base , D.iva , D.total , D.totalitems , D.sucursalid , D.creador , D.momento ,
				  B2.codbodega codbodori , B.codbodega codboddes , DT.bodegaidori , DT.bodegaiddes , P.codigo codproducto, 
				  P.productoid , DD.bodegaid , DD.valunitario , DD.valparcial , DD.porciva , DD.valbase , DD.valiva , DD.valtotal , 
				  SUM(DD.cantidad) cantidad , SUM(DD.unidades) unidades , SUM(DD.unicom) unicom , SUM(DD.unifra) unifra 
				  FROM documentos D INNER JOIN docutranfe DT ON (D.docuid = DT.docuid)
				  INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid)
				  INNER JOIN productos P ON (DD.productoid = P.productoid)
			 	  INNER JOIN bodegas B ON (B.bodegaid = DT.bodegaiddes)
				  INNER JOIN bodegas B2 ON (B2.bodegaid = DT.bodegaidori)
				  WHERE D.docuid = '.$params['id'].'  
                  GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,30 ORDER BY D.docuid DESC';
	
		$list = array();
		$result = $this->db->query($query);
		while ($row = $result->fetch_assoc())
		{
			$list[] = $row;
		}
		return $list;
	}

    /**
	 * Crea una nueva Transferencia por Cargar
	 *
	 * @param Array con los datos de la Transferencia	 
	 * @return 1 Exitoso - 0 Error 
	 */
    function setNuevaTransferencia($params)
	{
		$i=0;

		while($params[$i]->tipodoc)
        {
			//// Si es el 1er Registro ($i==0) Inserto el Documento y Docutranfe
			
			if($i==0)
            {
	            //// 1. Elimino la transferencia si Existe
				$vsql = "DELETE FROM documentos WHERE tipodoc = 'TXC' AND prefijo = '".$pre."' AND numero = '".$num."'";
				$stmt = $this->db->prepare($vsql);
	            $r = $stmt->execute();	

	            //// Le paso los parámetros
	            $pre = $params[$i]->prefijo;    	            $num  = $params[$i]->numero;
	            $per = $params[$i]->periodo;    	            $fec  = $params[$i]->fechadoc;
	            $co1 = $params[$i]->codigo1;    	            $co2  = $params[$i]->codigo2;
                $co3 = $params[$i]->codigo3;    	            $bas  = $params[$i]->base;
                $bor = $params[$i]->bodegaidori;  	            $bde  = $params[$i]->bodegaiddes;
                $obs = $params[$i]->observacion;                $nro  = $params[$i]->nrodocref;
                $iva = $params[$i]->iva;           	            $tot  = $params[$i]->total;
                $ite = $params[$i]->totalitems;   	            $suc  = $params[$i]->sucursalid;
                $cre = $params[$i]->creador;   	                $mom  = $params[$i]->momento;
	            
				/// 2. Inserto el Documento
				$vsql = "INSERT IGNORE INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,formapago,terid1,terid2,terid3,
					     observacion,base,iva,total,impreso,totalitems,sucursalid,nrodocref,creador,momento) 
                         VALUES('TXC','".$pre."','".$num."','".$per."','".$fec."','CO',1,1,1,'".$obs."',".$bas.",".$iva.",".$tot.
                         ",'S',".$ite.",".$suc.",'".$nro."','".$cre."','".$mom."')";
				$stmt = $this->db->prepare($vsql);

	            //// Ejecuto la Consulta SQL
	            $r = $stmt->execute();
	            
	            /// Obtengo el Docuid
	            $NDOCUID = $this->db->insert_id;
                
                /// 3. Inserto el DocuTranfe
				$vsql = "INSERT INTO docutranfe(docuid,bodegaidori,bodegaiddes,kardexori,kardexdes,codbarra,enviado,planogen) 
				         VALUES(".$NDOCUID.",".$bor.",".$bde.",'S','S','',CURRENT_TIMESTAMP,'S')";
				$stmt = $this->db->prepare($vsql);
	            //// Ejecuto la Consulta SQL
	            $r = $stmt->execute();
            }
            
            /// Si pudo insertar el Encabezado - Procedo con los detalles
            if($NDOCUID != "")
            {
                //// Recibo los parámetros del Detalle
	            $pid = $params[$i]->productoid;    	            $bid  = $params[$i]->bodegaid;
	            $can = $params[$i]->cantidad;    	            $uni  = $params[$i]->unidades;
	            $vun = $params[$i]->valunitario;    	        $vpa  = $params[$i]->valparcial;
	            $por = $params[$i]->porciva;    	            $vba  = $params[$i]->valbase;
	            $viv = $params[$i]->valiva;    	                $vto  = $params[$i]->valtotal;
	            $uco = $params[$i]->unicom;    	                $ufr  = $params[$i]->unifra;
                
                /// 4. Inserto los detalles
                $vsql2 = "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,valunitario,valdescuento,
                	      valparcial,porciva,valbase,valiva,valtotal,unicom,unifra) 
                          VALUES(".$NDOCUID.",".$pid.",".$bid.",".$can.",".$uni.",".$vun.",0,".$vpa.",".$por.
                          ",".$vba.",".$viv.",".$vto.",".$uco.",".$ufr.")";
                
                $stmt = $this->db->prepare($vsql2);
	            $r = $stmt->execute();
            } 	
          
            //// Siguiente Registro
	        $i++;
	    }    
        
        /// Recalculo los Valores de la transferencia
        $stmt = $this->db->prepare("CALL PA_CalValoresGEN(".$NDOCUID.")");
	    $r = $stmt->execute();

        //// Retorno el ID
        return $NDOCUID; 
	}

} /// Fin de la Clase API
