<?php

include("../../lib/Sistema.php");

/**
 * Clase API del WebService
 * Permite hacer las 4 Actividades Básicas CRUD a la Tabla Transferencias
 * Desde WebService
 * @author Said Rodriguez
 * @version 2017-01-30
 */

class api
{
	private $db;

	/**
	 * Constructor - Abre una conexion a la Base de Datos
	 *
	 * @param Vacío
	 * @return Conexion a la Base de Datos
	 */
	
	function __construct()
	{
		$clase = new Sistema();
		$this->db = new mysqli($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
	}

	/**
	 * Destructor - close DB connection
	 *
	 * @param Vacío
	 * @return Vacío
	 */

	function __destruct()
	{
		$this->db->close();
	}

	/**
	 * Obtiene un Listado de Transferencias (Las Ultimas 200)
	 *
	 * @param Vacio	 
	 * @return Lista de Transferencias en Formato JSON
	 */
	function getListaMensajeros()
	{
		$query = "SELECT CODCONVENIO , PERIODODOC , CODSUC , trim(P.descripcion) descripcion , P.nominstitucional , P.costoinf , 
                  CONCAT(CC.PREFIJODOC,' ',CC.NUMERODOC) NUMERO , (SUM(CAJENT)+SUM(UNIENT/P.factor1)) encajas , (SUM(CAJENT*P.factor1)+SUM(UNIENT)) enunidades , 
                  ((SUM(CAJENT)+SUM(UNIENT/P.factor1))*P.costoinf) valoracosto 
				  FROM consolidaconvenio CC INNER JOIN productos P ON (CC.DECODPRO = P.codigo)
				  WHERE 1
				  GROUP BY 1,2,3,4,5,6,7
				  ORDER BY 1,2,3,4 ASC";
		
		$list = array();
		$result = $this->db->query($query);
		while ($row = $result->fetch_assoc())
		{
			$list[] = $row;
		}
		return $list;
	}

	

} /// Fin de la Clase API
