<?PHP
    @session_start(); 
    include("lib/Sistema.php");  
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    // valido que esta opción esté habilitada 
    $cal_libranza  = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_CAL_LIBRANZA'");

    if($cal_libranza!="CHECKED")
    {
        $clase->Aviso(3,"esta opción se encuentra deshabilitada");
        header("Location: principal.php");
    }
    else
    {
        ////////////////////////////////////////////////////////////////////////////////////////
        // Opciones: valopcion
        // Creación: 23/11/2020		última modificación: 
        // Creador: Luis Flórez		modificado por: 
        // Descripción: Opción que valida y redirecciona el formulario al proceso seleccionado
        // Última modificación: 
        ////////////////////////////////////////////////////////////////////////////////////////        
        if($opcion == "valopcion")
        {
            $conceptoid = $_POST['conceptoid'];
            $terid = $_POST['terid'];
            
            $lonconcepto = strlen($conceptoid);
            $lonempleado = strlen($terid);
    
            if(($lonconcepto==0)||($lonempleado==0))
            {
                $clase->Aviso(3,"Debe introducir la libranza y el empleado");
                header("Location: libranzas.php?opcion=ventanalibranzas");
            }
            else
                header("Location: libranzas.php?opcion=ventanacuotasnew&conceptoid=$conceptoid&terid=$terid"); // Redirecciono a la ventana de libranzas                
        }
    
        ////////////////////////////////////////////////////////////////////////////////////////
        // Opciones: ventanacuotas
        // Creación: 23/11/2020		última modificación: 15/12/2020
        // Creador: Luis Flórez		modificado por: Luis Flórez
        // Descripción: Opción que pinta la ventana para procesar las ópticas
        // Última modificación: Validación de la no eliminación de las cuotas pagadas,
        //                      impresión del estatus de la cuota, eliminación de cuota.
        //                      (24/11/2020)
        //                      Se modificó el nombre de esta de ventanaopticas a ventanacuotas 
        //                      para ser utilizada para cualquier libranza (02/12/2020)
        //                      Inclusión de la opción que confirma la eliminación de una cuota
        ////////////////////////////////////////////////////////////////////////////////////////            
        if($opcion == "ventanacuotas")
        {
            $conceptoid = $_GET['conceptoid'];
            $terid = $_GET['terid'];
    
            // Inicialización de variables
            $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
            $nombres  = $clase->BDLockup($terid,'terceros','terid','nombres');
            $apellidos  = $clase->BDLockup($terid,'terceros','terid','apellidos');
            $vsqlcomboper = "SELECT periodoid, descripcion FROM periodosnomina WHERE cerrado<>'CHECKED' ORDER BY periodoid";
            
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/cajas.png" width="32" height="32" border="0"> </td>
                      <td width="900"> <b>Libranzas de n&oacute;mina</b> <td>                  
                      <td width="24"> <a href="libranzas.php?opcion=ventanalibranzas"><input type="button" value="<<" class="button"></a> </td>
                     </tr>
                    </table>';
    
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>                  
                      <td width="900"> <label class="Texto12"> Empleado:</label> '.$nombres.' '.$apellidos.'</td>
                     </tr>
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>                 
                      <td width="900"> <label class="Texto12"> Libranza:</label> '.$nomconcepto.' </td>
                     </tr>
                    </table>';
    
            $cont.='<table width="100%">        
                     <form action="?opcion=guardardetopt" name="y" method="POST">
                     <input type="hidden" name="conceptoid" value="'.$conceptoid.'">
                     <input type="hidden" name="terid" value="'.$terid.'">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>     
                      <td width="900"> <label class="Texto12"> Periodo:</label>';
    
            $cont.= $clase->CrearComboBuscar("periodoid",$vsqlcomboper,"nombres","periodoid","","N",$params,320);
    
            $cont.='  </td>
                      <td width="63"> <label class="Texto12"> Monto:</label></td>
                      <td width="634"> 
                       <input type="number" name="monto" onkeypress="return TabulaEnter(this, event)" min="0" class="Texto12New" size="6" autocomplete="off" OnKeyUp="return MenuTecla(event)" value="0"> 
                      </td>
                     </tr>
                    </table>
                    </form>';
    
            $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                    <table width="100%" class="sortable">
                     <thead> 
                      <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                       <td width="30"> &nbsp; </td>
                       <td width="320"> Periodo </td>
                       <td width="110" align="right"> Monto </td>			
                       <td width="20"> &nbsp; </td>
                       <td width="35" align="right"> Pagada </td>
                       <td width="580"> &nbsp; </td>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:500px; overflow-Y:scroll">';
    
            // Inicializo las variables necesarias
            $i = 0;
            $totoptica = 0;
            $procesado = "";
            $auxprocesada = "";
            $totalpagado = 0;
            $totaldeuda = 0;
    
            // Consulta para procesar la libranza
            $vsql = "SELECT l.pendienteid, p.descripcion, l.monto, l.procesado,
                            l.terid, l.conceptoid, periodoapagar    
                       FROM libranzaspendientes l
                            INNER JOIN periodosnomina p ON (l.periodoapagar = p.periodoid) 
                      WHERE l.terid = ".$terid." 
                            AND l.conceptoid = ".$conceptoid." 
                   ORDER BY l.pendienteid";
    
            $conex  = $clase->Conectar();
            $result = @mysql_query($vsql,$conex);
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
                
                $procesado = $row['procesado'];
    
                // Emito el mensaje correspondiente
                if($procesado!='CHECKED')
                    $auxprocesada = "No";
                else
                    $auxprocesada = "Sí";
                    
                $cont.=' <td width="30"> &nbsp; </td>
                         <td width="320"> '.$row['descripcion'].' </td>
                         <td width="110" align="right"> '.number_format($row['monto']).' </td>
                         <td width="20"> &nbsp; </td>
                         <td width="35" align="right"> '.$auxprocesada.' </td>
                         <td width="540"> &nbsp; </td>';
                         
                if($procesado!='CHECKED')
                {
                    $cont.='<td width="20" align="center">
                             <a href="?opcion=confirmacion&pendienteid='.$row['pendienteid'].'&terid='.$row['terid'].'&conceptoid='.$row['conceptoid'].'" rel="facebox" title="eliminar cuota">
                             <img src="images/basicas/iconoborrar.png" border="0"></a>
                            </td>                        
                            <td width="20" align="center">
                             <a href="?opcion=editarcuota&pendienteid='.$row['pendienteid'].'&terid='.$row['terid'].'&conceptoid='.$row['conceptoid'].'&periodoapagar='.$row['periodoapagar'].'" title="modificar cuota" rel="facebox">
                             <img src="images/basicas/iconobuscar.png" title="Modificar" border="0"></a>
                            </td>';
                    $totaldeuda += $row['monto'];
                }
                else
                {
                    $cont.='<td width="20" align="right"> &nbsp; </td>
                            <td width="20" align="right"> &nbsp; </td>';
                    $totalpagado += $row['monto'];
                }
    
                // Incremento la variable del total
                $totoptica += $row['monto'];
            }
    
            $cont.='  </tbody>
                     </table>';
    
            // Impresión de los totales
            $cont.='<table width="100%">
                     <tr class="TituloTabla"> 
                      <td width="441"> &nbsp; </td>
                      <td width="255" align="right"> <font color="WHITE"> <b> Total libranza: </b> '.number_format($totoptica).' </font> </td>
                      <td width="255" align="right"> <font color="WHITE"> <b> Total pagado: </b> '.number_format($totalpagado).' </font> </td>
                      <td width="255" align="right"> <font color="WHITE"> <b> Total deuda: </b> '.number_format($totaldeuda).' </font> </td>
                      <td width="402"> &nbsp; </td>
                     </tr>
                    </table>';
        }
    
    
        ////////////////////////////////////////////////////////////////////////////////////////
        // Opciones: ventanacuotasnew
        // Creación: 21/12/2020		última modificación: 01/03/2021
        // Creador: Luis Flórez		modificado por: 
        // Descripción: Opción que pinta la ventana para los datos de las libranzas
        // Última modificación: Mensaje que indica si se está incluyendo o editando inclusión 
        //                      del documento de identidad
        ////////////////////////////////////////////////////////////////////////////////////////            
        if($opcion == "ventanacuotasnew")
        {
            $conceptoid = $_GET['conceptoid'];
            $terid = $_GET['terid'];
    
            // Inicialización de variables
            $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
            $nombres  = $clase->BDLockup($terid,'terceros','terid','nombres');
            $apellidos  = $clase->BDLockup($terid,'terceros','terid','apellidos');
            $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid."";
            $nombreemp = $clase->SeleccionarUno($vsql);
    
            $vsql = "SELECT dni AS dni FROM terceros WHERE terid = ".$terid."";
            $dni = $clase->SeleccionarUno($vsql);
    
            // Verificamos si el empleado tiene ese tipo de libranza pendiente
            $vsql = "SELECT COUNT(libranzaid) AS numlib
                       FROM libranzas
                      WHERE terid=".$terid."
                            AND conceptoid=".$conceptoid."
                            AND cuotaspagadas < totalcuotas";
            $numlib = $clase->SeleccionarUno($vsql);
    
            if($numlib==0)
            {
                $accion="incluir";
                $totalcuotas = 0;
                $monto = 0;
                $cuotaspagadas = 0;
            }
            else
            {
                $accion="editar";
                $vsql = "SELECT libranzaid
                           FROM libranzas
                          WHERE terid=".$terid."
                                AND conceptoid=".$conceptoid."
                                AND cuotaspagadas < totalcuotas";
                $libranzaid = $clase->SeleccionarUno($vsql);
    
                $totalcuotas = $clase->BDLockup($libranzaid,'libranzas','libranzaid','totalcuotas');
                $monto = $clase->BDLockup($libranzaid,'libranzas','libranzaid','monto');
                $cuotaspagadas = $clase->BDLockup($libranzaid,'libranzas','libranzaid','cuotaspagadas');
                $quincena = $clase->BDLockup($libranzaid,'libranzas','libranzaid','tipoquincena');
            }
    
            // Pintamos la ventana
            $cont = $clase->Header("S","W");
    
            if($accion=="incluir")
                $cont.='<table width="100%">
                         <tr class="CabezoteTabla"> 
                          <td width="10"> &nbsp; </td>
                          <td width="37"> <img src="images/iconos/cajas.png" width="32" height="32" border="0"> </td>
                          <td width="900"> <b>Libranzas de n&oacute;mina</b> <font color="BLUE">(nueva)</font><td>';
    
            if($accion=="editar")
                $cont.='<table width="100%">
                         <tr class="CabezoteTabla"> 
                          <td width="10"> &nbsp; </td>
                          <td width="37"> <img src="images/iconos/cajas.png" width="32" height="32" border="0"> </td>
                          <td width="900"> <b>Libranzas de n&oacute;mina</b> <font color="BLUE">(edici&oacute;n)</font> <td>';
    
    
            if($accion=="editar")
                $cont.='<td>  
                         <a href="libranzas.php?opcion=confirmalibranza&libranzaid='.$libranzaid.'&terid='.$terid.'&conceptoid='.$conceptoid.'" rel="facebox">
                         <input type="button" value="deshabilitar" class="button red"></a>
                        </td>';
    
            $cont.='  <td width="24"> <a href="libranzas.php?opcion=ventanalibranzas"><input type="button" value="<<" class="button"></a> </td>
                     </tr>
                    </table>';
    
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>                  
                      <td width="900"> <label class="Texto12"> Documento:</label> '.$dni.'</td>
                     </tr>                
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>                  
                      <td width="900"> <label class="Texto12"> Nombre:</label> '.$nombreemp.'</td>                  
                     </tr>
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>                 
                      <td width="900"> <label class="Texto12"> Libranza:</label> '.$nomconcepto.' </td>
                     </tr>
                    </table>';
    
            $cont.='<table width="100%">        
                     <form action="?opcion=guardarcuotalbrz" name="y" method="POST">     
                     <input type="hidden" name="conceptoid" value="'.$conceptoid.'">
                     <input type="hidden" name="terid" value="'.$terid.'">
                     <input type="hidden" name="accion" value="'.$accion.'">
                     <input type="hidden" name="libranzaid" value="'.$libranzaid.'">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>
                      <td width="65"> <label class="Texto12"> Cuotas:</label> </td>
                      <td width="100">    
                       <input type="number" name="totalcuotas" min="1" class="Texto12" size="6" autocomplete="off" title="número de cuotas" value="'.$totalcuotas.'"> 
                      </td>
                      <td width="63"> <label class="Texto12"> Monto:</label></td>
                      <td width="200"> 
                       <input type="number" name="monto" min="1" class="Texto12New" size="6" autocomplete="off" value="'.$monto.'"> 
                      </td>
                      <td width="155"> a descontar en                    
                       <select name="tipoquincena" id="tipoquincena">';
    
            if($accion=="editar")
            {
                switch($quincena)
                {
                    case 'none':
                        break;            
                    case 'ambas':
                        $cont.='<option value="ambas" selected> ambas </option>       
                                <option value="primera"> primera </option>   
                                <option value="segunda"> segunda </option>';
                        break;
                    case 'primera':
                        $cont.='<option value="ambas"> ambas </option>       
                                <option value="primera" selected> primera </option>   
                                <option value="segunda"> segunda </option>';
                        break;
                    case 'segunda':
                        $cont.='<option value="ambas"> ambas </option>       
                                <option value="primera"> primera </option>   
                                <option value="segunda" selected> segunda </option>';
                        break;
                    default:
                        break;
                }
            }
    
            if($accion=="incluir")
                $cont.='<option value="ambas" selected> ambas </option>       
                        <option value="primera"> primera </option>   
                        <option value="segunda"> segunda </option>';
    
            $cont.='   </select>
                      </td>
                      <td width="20" alling="right"> <label class="Texto12"> quincena(s) </label> </td>
                      <td width="40"> 
                       <input type="submit" value="aceptar" class="button blue">
                      </td>
                     </tr>
                    </table>   
                    </form>';
    
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                     <center>
                      <td width="657" align="center"> <b>Hist&oacute;rico de cuotas pagadas de esta libranza</b> </td>
                     </tr>
                     </center>
                    </table>';
    
            $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                    <table width="100%" class="sortable">
                     <thead> 
                      <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                       <td width="30"> &nbsp; </td>
                       <td width="320"> Periodo </td>
                       <td width="110" align="right"> Monto </td>			
                       <td width="20"> &nbsp; </td>
                       <td width="35" align="right"> &nbsp; </td>
                       <td width="580"> &nbsp; </td>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:300px; overflow-Y:scroll">';
    
            // Inicializo las variables necesarias
            $i = 0;
            $totalpagado = 0;
            $totallibranza = 0;
            $totaldeuda = 0;
    
            // Consulta para procesar la libranza
            $vsql = "SELECT p.descripcion, h.descuentos
                       FROM hisdetallenomina h
                            INNER JOIN periodosnomina p ON (h.pernominaid = p.periodoid)
                      WHERE h.conceptoid = ".$conceptoid."
                            AND h.terid = ".$terid."
                   ORDER BY h.detalleid DESC";
    
            $conex  = $clase->Conectar();
            $result = @mysql_query($vsql,$conex);
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
                    
                $cont.=' <td width="30"> &nbsp; </td>
                         <td width="320"> '.$row['descripcion'].' </td>
                         <td width="110" align="right"> '.number_format($row['descuentos']).' </td>
                         <td width="20"> &nbsp; </td>
                         <td width="35" align="right"> &nbsp; </td>
                         <td width="540"> &nbsp; </td>
                         <td width="20" align="right"> &nbsp; </td>
                         <td width="20" align="right"> &nbsp; </td>
                        </tr> ';
            }
    
            $cont.='  </tbody>
                     </table>';
    
            $totallibranza = $totalcuotas * $monto;
            $totalpagado = $cuotaspagadas * $monto;
            $totaldeuda = $totallibranza - $totalpagado;
    
            // Impresión de los totales
            $cont.='<table width="100%">
                     <tr class="TituloTabla"> 
                      <td width="441"> &nbsp; </td>
                      <td width="255" align="right"> <font color="WHITE"> <b> Total libranza: </b> '.number_format($totallibranza).' </font> </td>
                      <td width="255" align="right"> <font color="WHITE"> <b> Total pagado: </b> '.number_format($totalpagado).' </font> </td>
                      <td width="255" align="right"> <font color="WHITE"> <b> Total deuda: </b> '.number_format($totaldeuda).' </font> </td>
                      <td width="402"> &nbsp; </td>
                     </tr>
                    </table>';
        }
    
        ////////////////////////////////////////////////////////////////////////////////////////
        // Opciones: guardarcuotalbrz
        // Creación: 21/12/2020		última modificación: 
        // Creador: Luis Flórez		modificado por: 
        // Descripción: Opción que almacena la libranza en la tabla “libranzas”
        // Última modificación: 
        ////////////////////////////////////////////////////////////////////////////////////////
        if($opcion == "guardarcuotalbrz")
        {
            $conceptoid = $_POST['conceptoid'];
            $terid = $_POST['terid'];
            $totalcuotas = $_POST['totalcuotas'];
            $monto = $_POST['monto'];
            $tipoquincena = $_POST['tipoquincena'];
            $accion = $_POST['accion'];
            $libranzaid = $_POST['libranzaid'];        
    
            if($accion=="incluir")
            {
                // Obtengo el número de registros de la tabla libranzas
                $vsql = "SELECT MAX(libranzaid) FROM libranzas";
                $numeroid = $clase->SeleccionarUno($vsql);
    
                // Incremento el ID
                $numeroid++;
    
                // Almaceno el nuevo registro en la tabla de libranza
                $vsql = "INSERT INTO libranzas (libranzaid,terid,conceptoid,monto,totalcuotas,cuotaspagadas,tipoquincena) 
                                        VALUES (".$numeroid.",".$terid.",".$conceptoid.",".$monto.",".$totalcuotas.",0,'".$tipoquincena."')";
                $clase->EjecutarSQL($vsql);
    
                // Envío el mensaje correspondiente
                if(mysql_affected_rows() < 1)
                    $clase->Aviso(3,"No se incluyó la libranza");
                else
                    $clase->Aviso(1,"Libranza incluida satisfactoriamente");
            }
    
            if($accion=="editar")
            {
                // Almaceno los cambios realizados
                $vsql = "UPDATE libranzas SET 
                                monto = ".$monto.", 
                                totalcuotas = ".$totalcuotas.",
                                tipoquincena = '".$tipoquincena."' 
                          WHERE libranzaid = ".$libranzaid;
                $clase->EjecutarSQL($vsql);
        
                // valido que se almacenen los datos para emitir el mensaje correspondiente
                if(mysql_affected_rows() < 1)
                    $clase->Aviso(3,"No se modificaron los datos de la libranza");
                else
                    $clase->Aviso(1,"Datos de la libranza editados satisfactoriamente");
            }
    
            // Redirecciono el formulario
            header("Location: libranzas.php?opcion=ventanalibranzas");
        }
    
        ////////////////////////////////////////////////////////////////////////////////////////
        // Opción: confirmalibranza
        // Creación: 21/12/2020		última modificación: 
        // Creador: Luis Flórez		modificado por: 
        // Descripción: Opción para confirmar la eliminación de una libranza
        // Última modificación: 
        ////////////////////////////////////////////////////////////////////////////////////////
        if($opcion == "confirmalibranza")
        {
            $libranzaid = $_GET['libranzaid'];
            $terid = $_GET['terid'];
            $conceptoid = $_GET['conceptoid'];
    
            $cont='<table width="500">
                    <tr class="CabezoteTabla"> 
                     <td align="center"><br><b>Eliminar una libranza</b><br><br><td> 
                    </tr> 
                   </table>
                   <table width="500">
                    <tr class="TablaDocsImPar">       
                     <td width="400" align="center">¿Confirma que desea deshabilitar esta libranza? </td>       
                    </tr>
                    <tr class="TablaDocsImPar">       
                     <td width="400" align="center"><br><br>
                      <form action="?opcion=eliminalibranza&libranzaid='.$libranzaid.'" method="POST">                   
                       <input type="hidden" name="libranzaid" value="'.$libranzaid.'">
                       <input type="hidden" name="terid" value="'.$terid.'">
                       <input type="hidden" name="conceptoid" value="'.$conceptoid.'">
                       <input type="submit" value="ACEPTAR" class="button red">
                        <a href="libranzas.php?opcion=ventanacuotasnew&conceptoid='.$conceptoid.'&terid='.$terid.'" ><input type="button" value="CANCELAR" class="button blue"></a>
                      </form>
                      <br>
                     </td>        
                    </tr>
                   </table><br>';		
            echo $cont; 
            exit();
        }
    
        ////////////////////////////////////////////////////////////////////////////////////////
        // Opción: eliminalibranza
        // Creación: 21/12/2020		última modificación: 17/03/2021
        // Creador: Luis Flórez		modificado por: 
        // Descripción: Opción para eliminar una libranza
        // Última modificación: Actualización de las cuotas pagadas igualándolas al total de 
        //                      cuotas en sustitución de la eliminación física del registro de 
        //                      la libranza
        ////////////////////////////////////////////////////////////////////////////////////////
        if($opcion == "eliminalibranza")
        {
            $libranzaid = $_POST['libranzaid'];
            $totalcuotas = $clase->BDLockup($libranzaid,'libranzas','libranzaid','totalcuotas');
            $cuotaspagadas = $totalcuotas;
    
            // Almaceno los cambios realizados
            $vsql = "UPDATE libranzas SET 
                            cuotaspagadas = ".$cuotaspagadas." 
                      WHERE libranzaid = ".$libranzaid;
            $clase->EjecutarSQL($vsql);
    
            // Emito el mensaje correspondiente
            if(mysql_affected_rows() < 1)
                $clase->Aviso(3,"No se eliminó la libranza");
            else
                $clase->Aviso(1,"Libranza eliminada satisfactoriamente");
    
            // Redirecciono el formulario
            header("Location: libranzas.php?opcion=ventanalibranzas");
        }    
        
        ////////////////////////////////////////////////////////////////////////////////////////
        // Opciones: guardardetopt
        // Creación: 23/11/2020		última modificación: 24/11/2020
        // Creador: Luis Flórez		modificado por: Luis Flórez
        // Descripción: Opción que almacena las cuotas de libranzas tipo óptica
        // Última modificación: Validación de la no repetición de una cuota en un mismo periodo 
        //                      para una misma libranza
        ////////////////////////////////////////////////////////////////////////////////////////
        if($opcion == "guardardetopt")
        {
            $conceptoid = $_POST['conceptoid'];
            $terid = $_POST['terid'];
            $periodoid = $_POST['periodoid'];
            $monto = $_POST['monto'];
            $procesado = "";
            $valcuota = 0;
    
            // Consulta para la validación de cuota para una libranza
            $vsql = "SELECT count(*) AS valcuota
                       FROM libranzaspendientes 
                      WHERE terid = ".$terid." 
                            AND conceptoid = ".$conceptoid." 
                            AND periodoapagar = ".$periodoid;
            $valcuota = $clase->SeleccionarUno($vsql);
    
            if($valcuota>=1)
                $clase->Aviso(3,"Este periodo ya ha sido incluido en esta libranza");
            else
            {
                // Obtengo el número de registros de la tabla detallenomina
                $vsql = "SELECT MAX(pendienteid) FROM libranzaspendientes";
                $numeroid = $clase->SeleccionarUno($vsql);
        
                // Incremento el ID
                $numeroid++;
        
                // Almaceno en la tabla el concepto de compras a crédito para el trabajador
                $vsql = "INSERT INTO libranzaspendientes (pendienteid,terid,conceptoid,monto,periodoapagar,procesado) 
                                                  VALUES ($numeroid,".$terid.",".$conceptoid.",".$monto.",".$periodoid.",'".$procesado."')";
                $clase->EjecutarSQL($vsql);
                    
                // Envío el mensaje correspondiente
                if(mysql_affected_rows() < 1)
                    $clase->Aviso(3,"No se incluyó la cuota de la libranza");
                else
                    $clase->Aviso(1,"Cuota incluida satisfactoriamente");
            }
    
            // Redirecciono el formulario
            header("Location: libranzas.php?opcion=ventanacuotas&conceptoid=$conceptoid&terid=$terid");
        }
    
        ////////////////////////////////////////////////////////////////////////////////////////
        // Opciones: borrarcuota
        // Creación: 24/11/2020		última modificación: 
        // Creador: Luis Flórez		modificado por: 
        // Descripción: Opción que elimina una cuota para una libranza
        // Última modificación: 
        ////////////////////////////////////////////////////////////////////////////////////////    
        if($opcion == "borrarcuota")
        {
            $pendienteid = $_POST['pendienteid'];
            $terid = $_POST['terid'];
            $conceptoid = $_POST['conceptoid'];        
    
            // Elimino la cuota
            $vsql = "DELETE FROM libranzaspendientes WHERE pendienteid = ".$pendienteid;
            $clase->EjecutarSQL($vsql);
    
            // Emito el mensaje correspondiente
            if(mysql_affected_rows() < 1)
                $clase->Aviso(3,"No se eliminó la cuota");
            else
                $clase->Aviso(1,"Cuota eliminada satisfactoriamente");
    
            // Redirecciono el formulario
            header("Location: libranzas.php?opcion=ventanacuotas&conceptoid=$conceptoid&terid=$terid");
        }
    
        ////////////////////////////////////////////////////////////////////////////////////////
        // Opción: confirmacion
        // Creación: 15/12/2020		última modificación: 
        // Creador: Luis Flórez		modificado por: 
        // Descripción: Opción para confirmar la eliminación de una cuota de libranza
        // Última modificación: 
        ////////////////////////////////////////////////////////////////////////////////////////
        if($opcion == "confirmacion")
        {
            $pendienteid = $_GET['pendienteid'];
            $terid = $_GET['terid'];
            $conceptoid = $_GET['conceptoid'];
            $monto = $clase->BDLockup($pendienteid,'libranzaspendientes','pendienteid','monto');
    
            $cont='<table width="500">
                    <tr class="CabezoteTabla"> 
                     <td align="center"><br><b>Eliminar una cuota de libranza</b><br><br><td> 
                    </tr> 
                   </table>
                   <table width="500">
                    <tr class="TablaDocsImPar">       
                     <td width="400" align="center">¿Confirma que desea eliminar esta cuota de <b>'.number_format($monto).'</b> pesos? <br></td>       
                    </tr>
                    <tr class="TablaDocsImPar">       
                     <td width="400" align="center"><br><br>
                      <form action="?opcion=borrarcuota&pendienteid='.$pendienteid.'&terid='.$terid.'&conceptoid='.$conceptoid.'" method="POST">
                       <input type="hidden" name="pendienteid" value="'.$pendienteid.'">
                       <input type="hidden" name="terid" value="'.$terid.'">
                       <input type="hidden" name="conceptoid" value="'.$conceptoid.'">
                       <input type="submit" value="ACEPTAR" class="button red">
                        <a href="libranzas.php?opcion=ventanacuotas&conceptoid='.$conceptoid.'&terid='.$terid.'" ><input type="button" value="CANCELAR" class="button blue"></a>
                      </form>
                      <br>
                     </td>        
                    </tr>
                   </table><br>';		
            echo $cont; 
            exit();
        }
    
        ////////////////////////////////////////////////////////////////////////////////////////
        // Opción: valborrarlote
        // Creación: 15/12/2020		última modificación: 30/08/2021
        // Creador: Luis Flórez		modificado por: Luis Flórez
        // Descripción: Opción para confirmar la eliminación de una cuota de libranza en el 
        //              proceso por lotes
        // Última modificación: Se suprimieron los parámetros $terid y $conceptoid debido a la 
        //                      sustitución de la tabla libranzaspendientes por la tabla 
        //                      libranzas (22/12/2020)
        //                      Inclusión del nombre del empleado y del concepto en el mensaje 
        //                      de confirmación
        ////////////////////////////////////////////////////////////////////////////////////////
        if($opcion == "valborrarlote")
        {
            $periodoid = $_GET['periodoid'];
            $detalleid = $_GET['detalleid'];
            $monto = $clase->BDLockup($detalleid,'detallenomina','detalleid','descuentos');
    
            $terid = $clase->BDLockup($detalleid,'detallenomina','detalleid','terid');
    
            // Nombre del empleado
            $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                       FROM terceros 
                      WHERE terid = ".$terid."";
            $nombreemp = $clase->SeleccionarUno($vsql);
    
            // Nombre de la libranza
            $conceptoid = $clase->BDLockup($detalleid,'detallenomina','detalleid','conceptoid');
            $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
    
            $cont='<table width="500">
                    <tr class="CabezoteTabla"> 
                     <td align="center"><br><b>Eliminar una cuota de libranza</b><br><br><td> 
                    </tr> 
                   </table>
                   <table width="500">
                    <tr class="TablaDocsImPar">       
                     <td width="400" align="center">¿Confirma que desea eliminar esta cuota de <b>'.number_format($monto).'</b> pesos <br>
                                                     del empleado(a) <b>'.$nombreemp.'</b> <br> de la libranza <b>'.$nomconcepto.'</b>?</td>       
                    </tr>
                    <tr class="TablaDocsImPar">       
                     <td width="400" align="center"><br><br>                  
                      <form action="?opcion=borrarcuotalote&periodoid='.$periodoid.'&detalleid='.$detalleid.'" method="POST">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">
                       <input type="hidden" name="detalleid" value="'.$detalleid.'">
                       <input type="submit" value="ACEPTAR" class="button red">
                        <a href="libranzas.php?opcion=libranzaslote&periodoid='.$periodoid.'" ><input type="button" value="CANCELAR" class="button blue"></a>
                      </form>
                      <br>
                     </td>        
                    </tr>
                   </table><br>';
            echo $cont;
            exit();
        }
    
        ////////////////////////////////////////////////////////////////////////////////////////
        // Opciones: editarcuota
        // Creación: 24/11/2020		última modificación: 
        // Creador: Luis Flórez		modificado por: 
        // Descripción: Opción que edita el monto de una cuota
        // Última modificación: 
        ////////////////////////////////////////////////////////////////////////////////////////        
        if($opcion == "editarcuota")
        {
            $pendienteid = $_GET['pendienteid'];
            $terid = $_GET['terid'];
            $conceptoid = $_GET['conceptoid'];
            $periodoapagar = $_GET['periodoapagar'];
            $descripcion = $clase->BDLockup($periodoapagar,'periodosnomina','periodoid','descripcion');
            $monto = $clase->BDLockup($pendienteid,'libranzaspendientes','pendienteid','monto');
    
            $cont='<table width="400">
                    <tr class="CabezoteTabla"> 
                     <td align="center"> Modificar monto del periodo<br><b>'.$descripcion.'</b> <td> 
                    </tr> 
                   </table>
                   <form action="libranzas.php?opcion=guardarcuota" method="POST" name="x">
                    <input type="hidden" name="pendienteid" value="'.$pendienteid.'">
                    <input type="hidden" name="conceptoid" value="'.$conceptoid.'">
                    <input type="hidden" name="terid" value="'.$terid.'">
                    <table width="400">
                    <center>
                    <br>
                    <tr class="TablaDocsImPar">				
                     <td width="150" align="right"> Monto: &nbsp;</td> 			  
                     <td width="250"> <input type="number" name="monto" class="Texto12New" size="6" min="0" maxlength="6" autocomplete="off" value="'.$monto.'"></td>
                    </tr>	
                   </table>
                    <br>
                    <center>
                    <input type="submit" value="aceptar" class="button blue">
                   </form><br>';
            echo $cont;
            exit();
        }
    
        ////////////////////////////////////////////////////////////////////////////////////////
        // Opciones: guardarcuota
        // Creación: 24/11/2020		última modificación: 
        // Creador: Luis Flórez		modificado por: 
        // Descripción: Opción que almacena la modificación del monto de una cuota
        // Última modificación: 
        ////////////////////////////////////////////////////////////////////////////////////////            
        if($opcion == "guardarcuota")
        {
            $pendienteid = $_POST['pendienteid'];
            $conceptoid = $_POST['conceptoid'];
            $terid = $_POST['terid'];
            $monto = $_POST['monto'];
    
            $vsql = "UPDATE libranzaspendientes SET monto = ".$monto." WHERE pendienteid = ".$pendienteid;
            $clase->EjecutarSQL($vsql);
    
            // valido que se almacenen los datos para emitir el mensaje correspondiente
            if(mysql_affected_rows() < 1)
                $clase->Aviso(3,"No se modificó el monto de la cuota");
            else
                $clase->Aviso(1,"Monto de la cuota modificada exitosamente");
    
            // Redirecciono el formulario
            header("Location: libranzas.php?opcion=ventanacuotas&conceptoid=$conceptoid&terid=$terid");
        }
    
        ////////////////////////////////////////////////////////////////////////////////////////
        // Opciones: libranzaslote
        // Creación: 02/12/2020		última modificación: 30/08/2021
        // Creador: Luis Flórez		modificado por: Luis Flórez
        // Descripción: Opción que procesa las libranzas por lote tomando en cuenta las cuotas 
        //              que se cancelaron en el periodo anterior
        // Última modificación: Se modificaron los llamados a las opciones de eliminación y 
        //                      edición de cuotas de libranzas cambiando los parámetros de 
        //                      acuerdo a la nueva tabla libranza que sustituye a la anterior 
        //                      libranzaspendientes (22/12/2020)
        //                      Inclusión de los descuentos permanentes en el combo de libranzas
        ////////////////////////////////////////////////////////////////////////////////////////        
        if($opcion == "libranzaslote")
        {
            $periodoid   = $_GET['periodoid'];
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
            
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/cajas.png" width="32" height="32" border="0"> </td>
                      <td width="900"> <b>Libranzas para el periodo '.$descripcion.'</b> <td>                  
                      <td width="24"> &nbsp; </td>
                     </tr>
                    </table>';
    
            $cont.='<input type="hidden" name="periodoid" value="'.$periodoid.'">
                    <script type="text/javascript" src="lib/sorttable.js"></script>
                    <table width="100%" class="sortable">
                     <thead> 
                      <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                       <td width="38"> &nbsp; </td>
                       <td width="360" align="left"> Empleado </td>
                       <td width="446" align="left"> Concepto </td>			
                       <td width="286" align="right"> Monto </td>                   
                       <td width="80">&nbsp;  </td>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:500px; overflow-Y:scroll">';
    
            $vsql = "SELECT c.conceptoid, c.nomconcepto, d.descuentos, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                            t.terid, d.detalleid 
                       FROM detallenomina d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                            INNER JOIN terceros t ON (d.terid = t.terid)
                      WHERE (c.eslibranza='CHECKED' 
                            OR c.montopermanente='CHECKED')
                            AND d.pernominaid = ".$periodoid."
                   ORDER BY c.conceptoid, t.nombres";
    
            $conex  = $clase->Conectar();
            $result = @mysql_query($vsql,$conex);
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
                    
                $cont.=' <td width="38">&nbsp;  </td>
                         <td width="373" align="left"> '.$row['nombreemp'].' </td>
                         <td width="433" align="left"> '.$row['nomconcepto'].' </td>
                         <td width="316" align="right"> '.number_format($row['descuentos']).' </td>
                         <td width="10"> &nbsp; </td>
                         <td width="20" align="center">
                          <a href="?opcion=valborrarlote&periodoid='.$periodoid.'&detalleid='.$row['detalleid'].'" rel="facebox" title="eliminar cuota">
                          <img src="images/basicas/iconoborrar.png" border="0"></a>
                         </td>                        
                         <td width="20" align="center">
                         <a href="?opcion=editcuotalote&terid='.$row['terid'].'&conceptoid='.$row['conceptoid'].'&periodoid='.$periodoid.'&detalleid='.$row['detalleid'].'&descuentos='.$row['descuentos'].'" title="modificar cuota" rel="facebox">
                          <img src="images/basicas/iconobuscar.png" title="Modificar" border="0"></a>
                         </td>                     
                        </tr>';
            }
    
            $cont.='  </tbody>
                     </table>';
        }
    
        ////////////////////////////////////////////////////////////////////////////////////////
        // Opciones: borrarcuotalote
        // Creación: 02/12/2020		última modificación: 22/12/2020
        // Creador: Luis Flórez		modificado por: Luis Flórez
        // Descripción: Opción para eliminar una cuota del proceso de libranzas por lote
        // Última modificación: Se suprimió el proceso en la tabla libranzaspendientes debido a 
        //                      que esta fue sustituida por la tabla libranzas
        ////////////////////////////////////////////////////////////////////////////////////////    
        if($opcion == "borrarcuotalote")
        {
            $periodoid = $_POST['periodoid'];
            $detalleid = $_POST['detalleid'];
            $cerrado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','cerrado');
    
            // Valido que el periodo no esté cerrado
            if($cerrado=="CHECKED")
                $clase->Aviso(3,"No se puede eliminar esta cuota de libranza porque este periodo ya fue cerrado");
            else
            {
                // Elimino el concepto en la tabla detallenomina
                $vsql = "DELETE FROM detallenomina WHERE detalleid = ".$detalleid;
                $clase->EjecutarSQL($vsql);
        
                if(mysql_affected_rows() >= 1)
                    $clase->Aviso(1,"Cuota eliminada satisfactoriamente");
                else
                    $clase->Aviso(3,"No se eliminó correctamente la cuota");
            }
    
            // Redirecciono el formulario
            header("Location: libranzas.php?opcion=libranzaslote&periodoid=$periodoid");
        }
    
        ////////////////////////////////////////////////////////////////////////////////////////
        // Opciones: editcuotalote
        // Creación: 02/12/2020		última modificación: 22/12/2020
        // Creador: Luis Flórez		modificado por: Luis Florez
        // Descripción: Opción que edita el monto de una cuota en el proceso por lotes
        // Última modificación: Inclusión del nombre del concepto y el nombre del empleado
        //                      (03/12/2020)
        //                      Se suprimió el proceso en la tabla libranzaspendientes debido a 
        //                      que esta fue sustituida por la tabla libranzas
        ////////////////////////////////////////////////////////////////////////////////////////        
        if($opcion == "editcuotalote")
        {
            $terid = $_GET['terid'];
            $conceptoid = $_GET['conceptoid'];
            $periodoid = $_GET['periodoid'];
            $detalleid = $_GET['detalleid'];
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
            $monto = $_GET['descuentos'];
    
            // Obtengo el nombre del concepto
            $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
    
            // Obtengo el nombre del empleado
            $vsql = "SELECT CONCAT(nombres,' ', apellidos) AS nomempleado FROM terceros WHERE terid = ".$terid;
            $nomempleado = $clase->SeleccionarUno($vsql);
    
            $cont='<table width="400">
                    <tr class="CabezoteTabla"> 
                     <td align="center"> Modificar monto del concepto: <b>'.$nomconcepto.'</b> </td>                  
                    </tr>
                    <tr class="CabezoteTabla"> 
                     <td align="center"> Periodo <b>'.$descripcion.'</b> </td> 
                    </tr>
                    <tr class="CabezoteTabla"> 
                     <td align="center"> Empleado <b>'.$nomempleado.'</b> </td> 
                    </tr>
                   </table>
                   <form action="libranzas.php?opcion=almcuotalote" method="POST" name="x">                
                    <input type="hidden" name="detalleid" value="'.$detalleid.'">
                    <input type="hidden" name="periodoid" value="'.$periodoid.'">
                    <table width="400">
                    <center>
                    <br>
                    <tr class="TablaDocsImPar">				
                     <td width="150" align="right"> Monto: &nbsp;</td> 			  
                     <td width="250"> <input type="number" name="monto" class="Texto12New" size="6" min="0" maxlength="6" autocomplete="off" value="'.$monto.'"></td>
                    </tr>	
                   </table>
                    <br>
                    <center>
                    <input type="submit" value="aceptar" class="button blue">
                   </form><br>';
            echo $cont;
            exit();
        }
    
        ////////////////////////////////////////////////////////////////////////////////////////
        // Opciones: almcuotalote
        // Creación: 02/12/2020		última modificación: 22/12/2020
        // Creador: Luis Flórez		modificado por: Luis Flórez
        // Descripción: Opción que almacena la modificación del monto de una cuota en el 
        //              proceso por lotes
        // Última modificación: Se suprimió el proceso en la tabla libranzaspendientes debido a 
        //                      que esta fue sustituida por la tabla libranzas
        ////////////////////////////////////////////////////////////////////////////////////////            
        if($opcion == "almcuotalote")
        {
            // $pendienteid = $_POST['pendienteid'];
            $detalleid = $_POST['detalleid'];
            $periodoid = $_POST['periodoid'];
            $monto = $_POST['monto'];
            $cerrado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','cerrado');
    
            // Valido que el periodo no esté cerrado
            if($cerrado=="CHECKED")
                $clase->Aviso(3,"No se puede editar esta cuota de libranza porque este periodo ya fue cerrado");

            else
            {
                // Modifico el monto en la tabla detallenomina
                $vsql = "UPDATE detallenomina SET descuentos = ".$monto." WHERE detalleid = ".$detalleid;
                $clase->EjecutarSQL($vsql);
        
                if(mysql_affected_rows() >= 1)
                    $clase->Aviso(1,"Monto de cuota modificada satisfactoriamente");
                else
                    $clase->Aviso(3,"El monto no se modificó correctamente");
            }
    
            // Redirecciono el formulario
            header("Location: libranzas.php?opcion=libranzaslote&periodoid=$periodoid");
        }    
    
        ////////////////////////////////////////////////////////////////////////////////////////
        // Opciones: ventanalibranzas
        // Creación: 23/11/2020		última modificación: 03/09/2021
        // Creador: Luis Flórez		modificado por: Luis Flórez
        // Descripción: Opción que pinta la ventana principal del proceso de libranzas
        // Última modificación: Se incorporó el campo de empleado activo en la nómina 
        //                      (11/08/2021)
        //                      Se optimizó el combo de empleados filtrando los empleados con 
        //                      el primer nombre y el primer apellido completos    
        ////////////////////////////////////////////////////////////////////////////////////////    
        if($opcion == "ventanalibranzas")
        {
            $vsqlcombolib = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) FROM conceptosnomina WHERE eslibranza='CHECKED' ORDER BY conceptoid";
            $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                               FROM terceros                            
                              WHERE esempleadoactivo='CHECKED' 
                                    AND basico > 0
                                    AND (primernombre <> '' AND primerapellido <> '') 
                           ORDER BY primernombre";
            $params = ' class="Texto11" ';
            
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/cajas.png" width="32" height="32" border="0"> </td>
                      <td width="900"> <b>Libranzas de n&oacute;mina</b> <td>
                      <td width="24"> &nbsp; </td>
                     </tr>
                    </table>';
    
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>
                      <form action="?opcion=valopcion" method="POST" name="x">                  
                      <input type="hidden" name="periodoid" value="'.$periodoid.'">
                      <td width="900"> <label class="Texto12"> Empleado:</label>';
    
            $cont.= $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","S",$params,500);
    
            $cont.='  </td>
                     </tr>
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>                 
                      <td width="900"> <label class="Texto12"> Libranza:</label>';
            
            $cont.= $clase->CrearComboBuscar("conceptoid",$vsqlcombolib,"nombres","conceptoid","","S",$params,420);
    
            $cont.='  </td>
                     </tr>
                    </table>';
    
            $cont.='<br>
                    <table width="100%">
                     <center>
                     <input type="submit" value="aceptar" class="button blue">
                    </table>
                   </form>
                   <br>';
        }
        ////////////////////////////////
        echo $cont.$clase->PiePagina();      
    }
?>