<?PHP
    @session_start(); 
    include("lib/Sistema.php");  
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanadatos
    // Creación: 10/12/2020		última modificación: 26/06/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para la captación de datos del informe  
    //              listado nómina resumen
    // Última modificación: Optimización del combo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanadatos")
    {
        $params = ' class="Texto11" ';        
        
        // Consulta de periodos
        $vsqlcomboperiodo  = "SELECT codigo, CONCAT(codigo,' - ',descripcion) 
                                FROM periodosnomina 
                               WHERE cerrado ='CHECKED' OR 
                                     periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')                                    
                            ORDER BY periodoid ASC";
    
        // pinto la ventana
        $cont = $clase->Header("S","W");    
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/informe1.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Listado n&oacute;mina resumen </b> <font color="BLUE">(extralegal)</font> </td>
                  <td> &nbsp; </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';

        // Combo de periodos
        $cont.='<form action="listadonomres.php?opcion=nominaresumen" method="POST" name="x" target="_blank">
                <center>
                <table width="100%">
                 <tr class="BarraDocumentos">
                  <td align="center"><br><br><b> Datos del informe <br><br></td>
                 </tr>
                </table>  
                <table width="100%">
                 <tr class="BarraDocumentos"> 
                  <td width="220"> &nbsp; </td>
                  <td width="20"> Periodo: </td>
                  <td width="120"> '.$clase->CrearComboBuscar("codigo",$vsqlcomboperiodo,"descripcion","codigo","","N",$params,400).' </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                </table>                   
                <table width="100%">                     
                 <tr class="BarraDocumentos"> 
                  <td width="371" height="50" align="center">&nbsp; </td>      
                  <td width="164" height="50" align="center"> <input type="submit" value="vista" class="button blue" name="tiposalida"></td>
                  <td width="131" height="50" align="center"> <input type="submit" value="pdf" class="button red" name="tiposalida"></td>
                  <td width="185" height="50" align="center"> <input type="submit" value="excel" class="button blue" name="tiposalida"></td>
                  <td width="380" height="50" align="center">&nbsp; </td>
                 </tr>
                </table> 
                </form>';

        // pie del formulario
        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                </table>';
                
        echo $cont.$clase->PiePagina();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nominaresumen
    // Creación: 10/12/2020		última modificación: 26/06/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que imprime el informe Listado nómina resumen de acuerdo al 
    //              tipo de salida que se seleccione en la opción “ventanadatos” 
    //              (vista, PDF o Excel)
    // Última modificación: Salida tipo vista del sistema (12/12/2020)
    //                      Salida en una hoja de Excel (14/12/2020)
    //                      Corrección del cálculo de los descuentos para que no tome en 
    //                      cuenta ciertos conceptos (24/03/2021)
    //                      Se incorporó el campo de empleado activo en la nómina 
    //                      (11/08/2021)
    //                      Se incluyeron los totales en la salida a Excel (18/08/2021)
    //                      validación de que el periodo esté calculado (20/09/2022)
    //                      Exclusión de la agrupación por departamento en cada una de las 
    //                      salidas 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion=="nominaresumen")
    {
        $codigo  = $_POST['codigo'];            // Variable para filtrar el periodo        
        $tiposalida = $_POST["tiposalida"];     // Variable que indica qué tipo de informe se mostrará

        // Variable para el nombre del periodo
        $descripcion = $clase->BDLockup($codigo,'periodosnomina','codigo','descripcion');

        // Variable para el ID del periodo
        $periodoid  = $clase->BDLockup($codigo,'periodosnomina','codigo','periodoid');

        // Valido que el periodo tenga datos para emitir el reporte
        $vsqldatos = "SELECT COUNT(*) AS numreg FROM detallenomina WHERE pernominaid = ".$periodoid."";
        $numreg = $clase->SeleccionarUno($vsqldatos);

        if($numreg==0)
        {
            $clase->Aviso(3,"El periodo $descripcion no posee información");
            header("Location: planillanom.php?opcion=ventanadatos");            
        }
        else
        {
            // Validación de que el periodo esté calculado
            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado!="CHECKED")
            {
                // Mensaje correspondiente
                $clase->Aviso(3,"No se puede emitir el reporte del periodo $descripcion porque no está calculado");
    
                // Redirecciona el formulario
                header("Location: listadonomres.php?opcion=ventanadatos");            
            }
            else
            {
                // Variable para determinar si el periodo está abierto o cerrado
                $cerrado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','cerrado');
    
                // Salida tipo vista del sistema
                if($tiposalida=="vista")
                {
                    // Pinto la ventana
                    $cont = $clase->Header("S","W");
                    $cont.='<table width="100%">
                             <tr class="CabezoteTabla"> 
                              <td width="10"> &nbsp; </td>
                              <td width="37"> <img src="images/iconos/asignacursos.png" width="32" height="32" border="0"> </td>
                              <td width="840"> <b> Listado de n&oacute;mina resumen (extralegal)</b> <br> Periodo '.$descripcion.' </td>
                              <td> &nbsp; </td>
                              <td width="8"> &nbsp; </td>
                             </tr>           
                            </table>';
    
                    // encabezado
                    $cont.='<table width="100%" class="sortable">
                             <thead> 
                              <tr class="TituloTabla" style="display:block;padding-top:5px;height:22px;">
                               <td width="7"> &nbsp; </td>
                               <td width="346" align="left"> Empleado </td>
                               <td width="112" align="left"> Documento </td>
                               <td width="99" align="right"> Básico </td>
                               <td width="100" align="center"> D&iacute;as </td>
                               <td width="110" align="right"> Devengados </td>
                               <td width="115" align="right"> Descuentos </td>
                               <td width="111" align="right"> Neto a pagar </td> 
                              </tr>
                             </thead>
                             <tbody style="display:block; width:1050px; height:510px; overflow-Y:scroll">';
    
                    // Consulta del informe
                    if($cerrado=="CHECKED")
                        $vsql = "SELECT s.codseccion, s.descripcionsec, p.nombre AS nombreemp,
                                        p.dni, p.basico, SUM(IF(d.conceptoid=1,d.valor,0)) AS dias, 
                                        SUM(d.devengados) AS devengados,
                                        SUM(IF(d.conceptoid NOT IN (4,5,6,9,28,43,58),d.descuentos,0)) AS descuentos, 
                                        (SUM(d.devengados) - SUM(IF(d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS neto
                                   FROM seccion s
                                        INNER JOIN periodoterceros p ON (s.seccionid = p.seccionid)
                                        INNER JOIN hisdetallenomina d ON (p.terid = d.terid)
                                  WHERE p.esempleadoactivo = 'CHECKED' 
                                        AND p.extralegal = 'CHECKED'
                                        AND d.pernominaid = ".$periodoid."
                                        AND p.pernominaid = ".$periodoid."
                               GROUP BY p.terid
                               ORDER BY s.seccionid, p.codvende";
                    else
                        $vsql = "SELECT s.codseccion, s.descripcionsec, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                                        t.dni, t.basico, SUM(IF(d.conceptoid=1,d.valor,0)) AS dias, 
                                        SUM(d.devengados) AS devengados,
                                        SUM(IF(d.conceptoid NOT IN (4,5,6,9,28,43,58),d.descuentos,0)) AS descuentos, 
                                        (SUM(d.devengados) - SUM(IF(d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS neto
                                   FROM seccion s
                                        INNER JOIN tercerosactual t ON (s.seccionid = t.seccionid)
                                        INNER JOIN detallenomina d ON (t.terid = d.terid)
                                  WHERE t.esempleadoactivo = 'CHECKED' 
                                        AND t.extralegal = 'CHECKED'
                                        AND d.pernominaid = ".$periodoid."
                               GROUP BY t.terid
                               ORDER BY s.seccionid, t.codvende";
    
                    $totdevengado = 0;
                    $totdescuento = 0;
                    $totneto = 0;
                    $seccionant = "";
                    $i = 0;
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    while($row = mysql_fetch_array($result))
                    {
                        $i++;

                        // ------------------------------------------------------------------------------------------------------------------------------------------------- //
                        // if($i==1)
                        // {
                        //     $cont.='<tr class="TablaDocsImPar">
                        //              <td width="7">&nbsp;  </td>
                        //              <td width="346"> <font color="BLUE"> <b>'.$row['codseccion'].' '.$row['descripcionsec'].' </b> </font></td>                                   
                        //              <td width="112"> &nbsp; </td>
                        //              <td width="99"> &nbsp; </td>	
                        //              <td width="100">&nbsp; </td>
                        //              <td width="110">&nbsp; </td>
                        //              <td width="115">&nbsp; </td>
                        //              <td width="111">&nbsp; </td>
                        //              <td width="30"> &nbsp; </td>     
                        //             </tr>';
    
                        //     $cont.='<tr class="TituloTabla">
                        //              <td width="7">&nbsp;  </td>
                        //              <td width="346" align="left"> Empleado </td>
                        //              <td width="112" align="left"> Documento </td>			
                        //              <td width="99" align="right"> Básico </td>
                        //              <td width="100" align="center"> Días </td>	
                        //              <td width="110" align="right"> Devengados </td>
                        //              <td width="115" align="right"> Descuentos </td>
                        //              <td width="111" align="right"> Neto a pagar </td>
                        //              <td width="30"> &nbsp; </td>                      
                        //             </tr>';
    
                        //     $cont.='<tr class="TablaDocsImPar">
                        //              <td width="7">&nbsp;  </td>
                        //              <td width="346" align="left"> '.$row['nombreemp'].' </td>
                        //              <td width="112" align="left"> '.$row['dni'].' </td>			
                        //              <td width="99" align="right"> '.number_format($row['basico']).' </td>
                        //              <td width="100" align="center"> '.number_format($row['dias']).' </td>	
                        //              <td width="110" align="right"> '.number_format($row['devengados']).' </td>
                        //              <td width="115" align="right"> '.number_format($row['descuentos']).' </td>
                        //              <td width="111" align="right"> '.number_format($row['neto']).' </td>
                        //              <td width="30"> &nbsp; </td>                      
                        //             </tr>';
    
                        //     $totdevengado += $row['devengados'];            // Incremento el total de devengados
                        //     $totdescuento += $row['descuentos'];            // Incremento el total de descuentos
                        // }
                        // else
                        // {                        
                        //     if($row['codseccion']!=$seccionant)
                        //     {
                        //         $cont.='<tr class="TablaDocsImPar">
                        //                  <td width="7">&nbsp;  </td>
                        //                  <td width="346"> <font color="BLUE"> <b>'.$row['codseccion'].' '.$row['descripcionsec'].' </b> </font> </td>                                   
                        //                  <td width="112"> &nbsp; </td>
                        //                  <td width="99"> &nbsp; </td>	
                        //                  <td width="100">&nbsp; </td>
                        //                  <td width="110">&nbsp; </td>
                        //                  <td width="115">&nbsp; </td>
                        //                  <td width="111">&nbsp; </td>
                        //                  <td width="30">&nbsp; </td>     
                        //                 </tr>';
    
                        //         $cont.='<tr class="TituloTabla">
                        //                  <td width="7">&nbsp;  </td>
                        //                  <td width="346" align="left"> Empleado </td>
                        //                  <td width="112" align="left"> Documento </td>			
                        //                  <td width="99" align="right"> Básico </td>
                        //                  <td width="100" align="center"> Días </td>	
                        //                  <td width="110" align="right"> Devengados </td>
                        //                  <td width="115" align="right"> Descuentos </td>
                        //                  <td width="111" align="right"> Neto a pagar </td>
                        //                  <td width="30"> &nbsp; </td>                      
                        //                 </tr>';                                    
                        //     }
    
                        //     if($i%2 == 0)
                        //         $cont.='<tr class="TablaDocsPar">';
                        //     else
                        //         $cont.='<tr class="TablaDocsImPar">';
    
                        //     $cont.=' <td width="7">&nbsp;  </td>
                        //              <td width="346" align="left"> '.$row['nombreemp'].' </td>
                        //              <td width="112" align="left"> '.$row['dni'].' </td>			
                        //              <td width="99" align="right"> '.number_format($row['basico']).' </td>
                        //              <td width="100" align="center"> '.number_format($row['dias']).' </td>	
                        //              <td width="110" align="right"> '.number_format($row['devengados']).' </td>
                        //              <td width="115" align="right"> '.number_format($row['descuentos']).' </td>
                        //              <td width="111" align="right"> '.number_format($row['neto']).' </td>
                        //              <td width="30"> &nbsp; </td>                      
                        //             </tr>';
    
                        //     $totdevengado += $row['devengados'];            // Incremento el total de devengados
                        //     $totdescuento += $row['descuentos'];            // Incremento el total de descuentos                                
                        // }
    
                        // $seccionant = $row['codseccion'];
                        // ------------------------------------------------------------------------------------------------------------------------------------------------- //

                        $cont.='<tr class="TablaDocsImPar">
                                 <td width="7"> &nbsp; </td>
                                 <td width="346" align="left"> '.$row['nombreemp'].' </td>
                                 <td width="112" align="left"> '.$row['dni'].' </td>
                                 <td width="99" align="right"> '.number_format($row['basico']).' </td>
                                 <td width="100" align="center"> '.number_format($row['dias']).' </td>
                                 <td width="110" align="right"> '.number_format($row['devengados']).' </td>
                                 <td width="115" align="right"> '.number_format($row['descuentos']).' </td>
                                 <td width="111" align="right"> '.number_format($row['neto']).' </td>
                                 <td width="30"> &nbsp; </td>
                                </tr>';

                        $totdevengado += $row['devengados'];            // Incremento el total de devengados
                        $totdescuento += $row['descuentos'];            // Incremento el total de descuentos
                    }
    
                    $cont.=' </tbody>
                            </table>';
    
                    $totneto = $totdevengado - $totdescuento;
    
                    $cont.='<table width="100%">
                             <tr class="TituloTabla"> 
                              <td width="10"> &nbsp; </td>
                              <td width="325" align="right"> <font color="WHITE"> <b> Total devengado: </b> '.number_format($totdevengado).' </font> </td>
                              <td width="325" align="right"> <font color="WHITE"> <b> Total descuento: </b> '.number_format($totdescuento).' </font> </td>
                              <td width="197" align="right"> <font color="WHITE"> <b> Neto a pagar: </b> '.number_format($totneto).' </font> </td>
                              <td width="60"> &nbsp; </td>
                             </tr>
                            </table>';
    
                    echo $cont.$clase->PiePagina();
                }
    
                // Salida tipo PDF
                if($tiposalida=="pdf")
                {
                    // Traducción al español del mes que devuelve la función date()
                    $mesimp = date('F');
                    if($mesimp=="January")       $mesimp = "Enero";
                    if($mesimp=="February")      $mesimp = "Febrero";
                    if($mesimp=="March")         $mesimp = "Marzo";
                    if($mesimp=="April")         $mesimp = "Abril";
                    if($mesimp=="May")           $mesimp = "Mayo";
                    if($mesimp=="June")          $mesimp = "Junio";
                    if($mesimp=="July")          $mesimp = "Julio";
                    if($mesimp=="August")        $mesimp = "Agosto";
                    if($mesimp=="September")     $mesimp = "Septiembre";
                    if($mesimp=="October")       $mesimp = "Octubre";
                    if($mesimp=="November")      $mesimp = "Noviembre";
                    if($mesimp=="December")      $mesimp = "Diciembre";
    
                    // Consulta del informe
                    if($cerrado=="CHECKED")
                        $vsql = "SELECT s.codseccion, s.descripcionsec, p.nombre AS nombreemp,
                                        p.dni, p.basico, SUM(IF(d.conceptoid=1,d.valor,0)) AS dias, 
                                        SUM(d.devengados) AS devengados,
                                        SUM(IF(d.conceptoid NOT IN (4,5,6,9,28,43,58),d.descuentos,0)) AS descuentos, 
                                        (SUM(d.devengados) - SUM(IF(d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS neto
                                   FROM seccion s
                                        INNER JOIN periodoterceros p ON (s.seccionid = p.seccionid)
                                        INNER JOIN hisdetallenomina d ON (p.terid = d.terid)
                                  WHERE p.esempleadoactivo = 'CHECKED' 
                                        AND p.extralegal = 'CHECKED'
                                        AND d.pernominaid = ".$periodoid."
                                        AND p.pernominaid = ".$periodoid."
                               GROUP BY p.terid
                               ORDER BY s.seccionid, p.codvende";
                    else
                        $vsql = "SELECT s.codseccion, s.descripcionsec, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                                        t.dni, t.basico, SUM(IF(d.conceptoid=1,d.valor,0)) AS dias, 
                                        SUM(d.devengados) AS devengados,
                                        SUM(IF(d.conceptoid NOT IN (4,5,6,9,28,43,58),d.descuentos,0)) AS descuentos, 
                                        (SUM(d.devengados) - SUM(IF(d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS neto
                                   FROM seccion s
                                        INNER JOIN tercerosactual t ON (s.seccionid = t.seccionid)
                                        INNER JOIN detallenomina d ON (t.terid = d.terid)
                                  WHERE t.esempleadoactivo = 'CHECKED' 
                                        AND t.extralegal = 'CHECKED'
                                        AND d.pernominaid = ".$periodoid."
                               GROUP BY t.terid
                               ORDER BY s.seccionid, t.codvende";
    
                    $clase = new Sistema();
                    ini_set("memory_limit","200M");
                    require('lib/fpdf/fpdf.php');
                    $pdf=new FPDF();
    
                    $pdf->AddPage("");
    
                    // Logo Dromedicas
                    $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');
    
                    $x = 35;
                    $y = 15;
                    $pagina = 1;
    
                    // Impresión del encabezado
                    $pdf->SetFont('Arial','B',10);
                    $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                    $pdf->Text($x,$y,$enc);
                    
                    // Fecha y hora de impresión
                    $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
    
                    $pdf->SetFont('Arial','',8);
                    $pdf->Text($x+110,$y,$fechoraimp);
    
                    $pdf->SetFont('Arial','B',10);
                    $enc= "NOMINA:";                    $pdf->Text($x,$y+7,$enc);
                    
                    $pdf->SetFont('Arial','',10);
                    $enc=strtoupper($descripcion);      $pdf->Text($x+18,$y+7,$enc);
    
                    $pdf->SetFont('Arial','B',10);
                    $enc= "LISTADO NOMINA RESUMEN";     $pdf->Text(35,$y+14,$enc);

                    $pdf->SetFillColor(220,220,220);
                    $pdf->Rect(7,$y+28,197,8,'F');

                    $pdf->SetFont('Arial','B',9);
                    $enc= "EMPLEADO";                   $pdf->Text(10,$y+33,$enc);
                    $enc= "DOCUMENTO";                  $pdf->Text(67,$y+33,$enc);
                    $enc= "BASICO";                     $pdf->Text(95,$y+33,$enc);
                    $enc= "DIAS";                       $pdf->Text(111,$y+33,$enc);
                    $enc= "DEVENGADOS";                 $pdf->Text(122,$y+33,$enc);
                    $enc= "DESCUENTOS";                 $pdf->Text(150,$y+33,$enc);
                    $enc= "NETO PAGADO";                $pdf->Text(177,$y+33,$enc);
        
                    // Inicialización de variables
                    $i = 0;                 $totdevengado = 0;                  $totdescuento = 0;
                    $totneto = 0;           $enletras = "";                     $seccionant = "";
                    $departamento = "";
    
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    while($row = mysql_fetch_array($result))
                    {
                        if($y%243==0)
                        {
                            $y=15;
                            $pagina++;
                            $pdf->AddPage("");
    
                            // Logo Dromedicas
                            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');
    
                            // Impresión del encabezado
                            $pdf->SetFont('Arial','B',10);
                            $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                            $pdf->Text($x,$y,$enc);
                            
                            // Fecha y hora de impresión
                            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
    
                            $pdf->SetFont('Arial','',8);
                            $pdf->Text($x+110,$y,$fechoraimp);
    
                            $pdf->SetFont('Arial','B',10);
                            $enc= "NOMINA:";                    $pdf->Text($x,$y+7,$enc);
                            
                            $pdf->SetFont('Arial','',10);
                            $enc=strtoupper($descripcion);      $pdf->Text($x+18,$y+7,$enc);
    
                            $pdf->SetFont('Arial','B',10);
                            $enc= "LISTADO NOMINA RESUMEN";     $pdf->Text(35,$y+14,$enc);

                            $pdf->SetFillColor(220,220,220);
                            $pdf->Rect(7,$y+28,197,8,'F');
    
                            $pdf->SetFont('Arial','B',9);
                            $enc= "EMPLEADO";                   $pdf->Text(10,$y+33,$enc);
                            $enc= "DOCUMENTO";                  $pdf->Text(67,$y+33,$enc);
                            $enc= "BASICO";                     $pdf->Text(95,$y+33,$enc);
                            $enc= "DIAS";                       $pdf->Text(111,$y+33,$enc);
                            $enc= "DEVENGADOS";                 $pdf->Text(122,$y+33,$enc);
                            $enc= "DESCUENTOS";                 $pdf->Text(150,$y+33,$enc);
                            $enc= "NETO PAGADO";                $pdf->Text(177,$y+33,$enc);
                        }
    
                        $i++;
                        $longitud = 0;

                        // --------------------------------------------------------------------------------------------------------------------------------------------- //
                        // if($i==1)
                        // {
                        //     $departamento = $row['codseccion']."      ".$row['descripcionsec'];
    
                        //     $pdf->SetFont('Arial','B',10);
                        //     $pdf->Text(10,$y+26,$departamento);
            
                        //     $pdf->SetFillColor(220,220,220);
                        //     $pdf->Rect(7,$y+28,197,8,'F');
    
                        //     $pdf->SetFont('Arial','B',9);
                        //     $enc= "EMPLEADO";
                        //     $pdf->Text(10,$y+33,$enc);
    
                        //     $enc= "DOCUMENTO";
                        //     $pdf->Text(67,$y+33,$enc);
    
                        //     $enc= "BASICO";
                        //     $pdf->Text(95,$y+33,$enc);
    
                        //     $enc= "DIAS";
                        //     $pdf->Text(111,$y+33,$enc);
    
                        //     $enc= "DEVENGADOS";
                        //     $pdf->Text(122,$y+33,$enc);
    
                        //     $enc= "DESCUENTOS";
                        //     $pdf->Text(150,$y+33,$enc);
    
                        //     $enc= "NETO PAGADO";
                        //     $pdf->Text(177,$y+33,$enc);
    
                        //     // Impresión de los datos del empleado
                        //     $pdf->SetFont('Arial','',8);
                        //     $pdf->Text(10,$y+40,substr($row['nombreemp'],0,30));
    
                        //     // documento
                        //     $longitud = strlen($row['dni']);
                        //     if($longitud==7)
                        //         $pdf->Text(70,$y+40,$row['dni']);
    
                        //     if($longitud==8)
                        //         $pdf->Text(68,$y+40,$row['dni']);
    
                        //     if($longitud==9)
                        //         $pdf->Text(68,$y+40,$row['dni']);
    
                        //     if($longitud==10)
                        //         $pdf->Text(67,$y+40,$row['dni']);
    
                        //     // Sueldo básico
                        //     $longitud = strlen($row['basico']);
                        //     if($longitud==6)
                        //         $pdf->Text(97,$y+40,number_format($row['basico'],0));
    
                        //     if($longitud==7)
                        //         $pdf->Text(95,$y+40,number_format($row['basico'],0));
    
                        //     // Días laborados
                        //     $longitud = strlen($row['dias']);
                        //     if($longitud==1)
                        //         $pdf->Text(115,$y+40,number_format($row['dias'],0));
    
                        //     if($longitud==2)
                        //         $pdf->Text(113,$y+40,number_format($row['dias'],0));
    
                        //     // Monto devengado
                        //     $longitud = strlen($row['devengados']);
                        //     if($longitud==5)
                        //         $pdf->Text(136,$y+40,number_format($row['devengados'],0));
    
                        //     if($longitud==6)
                        //         $pdf->Text(134,$y+40,number_format($row['devengados'],0));
    
                        //     if($longitud==7)
                        //         $pdf->Text(132,$y+40,number_format($row['devengados'],0));
    
                        //     $totdevengado += $row['devengados'];            // Incremento el total de devengados
    
                        //     // Descuentos
                        //     $longitud = strlen($row['descuentos']);
                        //     if($longitud==1)
                        //         $pdf->Text(170,$y+40,number_format($row['descuentos'],0));
    
                        //     if($longitud==2)
                        //         $pdf->Text(168,$y+40,number_format($row['descuentos'],0));
    
                        //     if($longitud==3)
                        //         $pdf->Text(166,$y+40,number_format($row['descuentos'],0));
    
                        //     if($longitud==4)
                        //         $pdf->Text(164,$y+40,number_format($row['descuentos'],0));
    
                        //     if($longitud==5)
                        //         $pdf->Text(163,$y+40,number_format($row['descuentos'],0));
    
                        //     if($longitud==6)
                        //         $pdf->Text(161,$y+40,number_format($row['descuentos'],0));
    
                        //     if($longitud==7)
                        //         $pdf->Text(158,$y+40,number_format($row['descuentos'],0));
    
                        //     $totdescuento += $row['descuentos'];            // Incremento el total de descuentos
    
                        //     // Neto a pagar
                        //     $longitud = strlen($row['neto']);
                        //     if($longitud==5)
                        //         $pdf->Text(193,$y+40,number_format($row['neto'],0));
    
                        //     if($longitud==6)
                        //         $pdf->Text(191,$y+40,number_format($row['neto'],0));
    
                        //     if($longitud==7)
                        //         $pdf->Text(189,$y+40,number_format($row['neto'],0));
                        // }
                        // else
                        // {
                        //     if($row['codseccion']!=$seccionant)
                        //     {
                        //         $y+=18;
    
                        //         $departamento = $row['codseccion']."      ".$row['descripcionsec'];
    
                        //         $pdf->SetFont('Arial','B',10);
                        //         $pdf->Text(10,$y+26,$departamento);
                
                        //         $pdf->SetFillColor(220,220,220);
                        //         $pdf->Rect(7,$y+28,197,8,'F');
        
                        //         $pdf->SetFont('Arial','B',9);
                        //         $enc= "EMPLEADO";
                        //         $pdf->Text(10,$y+33,$enc);
        
                        //         $enc= "DOCUMENTO";
                        //         $pdf->Text(67,$y+33,$enc);
        
                        //         $enc= "BASICO";
                        //         $pdf->Text(95,$y+33,$enc);
        
                        //         $enc= "DIAS";
                        //         $pdf->Text(111,$y+33,$enc);
        
                        //         $enc= "DEVENGADOS";
                        //         $pdf->Text(122,$y+33,$enc);
        
                        //         $enc= "DESCUENTOS";
                        //         $pdf->Text(150,$y+33,$enc);
        
                        //         $enc= "NETO PAGADO";
                        //         $pdf->Text(177,$y+33,$enc);
                        //     }
    
                        //     // Impresión de los datos del empleado
                        //     $pdf->SetFont('Arial','',8);
                        //     $pdf->Text(10,$y+40,substr($row['nombreemp'],0,30));
    
                        //     // documento
                        //     $longitud = strlen($row['dni']);
                        //     if($longitud==7)
                        //         $pdf->Text(68,$y+40,$row['dni']);
    
                        //     if($longitud==8)
                        //         $pdf->Text(68,$y+40,$row['dni']);
    
                        //     if($longitud==9)
                        //         $pdf->Text(68,$y+40,$row['dni']);
    
                        //     if($longitud==10)
                        //         $pdf->Text(67,$y+40,$row['dni']);
    
                        //     // Sueldo básico
                        //     $longitud = strlen($row['basico']);
                        //     if($longitud==6)
                        //         $pdf->Text(97,$y+40,number_format($row['basico'],0));
    
                        //     if($longitud==7)
                        //         $pdf->Text(95,$y+40,number_format($row['basico'],0));
    
                        //     // Días laborados
                        //     $longitud = strlen($row['dias']);
                        //     if($longitud==1)
                        //         $pdf->Text(115,$y+40,number_format($row['dias'],0));
    
                        //     if($longitud==2)
                        //         $pdf->Text(113,$y+40,number_format($row['dias'],0));
    
                        //     // Monto devengado
                        //     $longitud = strlen($row['devengados']);
                        //     if($longitud==5)
                        //         $pdf->Text(136,$y+40,number_format($row['devengados'],0));
    
                        //     if($longitud==6)
                        //         $pdf->Text(134,$y+40,number_format($row['devengados'],0));
    
                        //     if($longitud==7)
                        //         $pdf->Text(132,$y+40,number_format($row['devengados'],0));
    
                        //     $totdevengado += $row['devengados'];
    
                        //     // Descuentos
                        //     $longitud = strlen($row['descuentos']);
                        //     if($longitud==1)
                        //         $pdf->Text(170,$y+40,number_format($row['descuentos'],0));
    
                        //     if($longitud==2)
                        //         $pdf->Text(168,$y+40,number_format($row['descuentos'],0));
    
                        //     if($longitud==3)
                        //         $pdf->Text(166,$y+40,number_format($row['descuentos'],0));
    
                        //     if($longitud==4)
                        //         $pdf->Text(164,$y+40,number_format($row['descuentos'],0));
    
                        //     if($longitud==5)
                        //         $pdf->Text(163,$y+40,number_format($row['descuentos'],0));
    
                        //     if($longitud==6)
                        //         $pdf->Text(161,$y+40,number_format($row['descuentos'],0));
    
                        //     if($longitud==7)
                        //         $pdf->Text(158,$y+40,number_format($row['descuentos'],0));
    
                        //     $totdescuento += $row['descuentos'];
    
                        //     // Neto a pagar
                        //     $longitud = strlen($row['neto']);
    
                        //     if($longitud==5)
                        //         $pdf->Text(193,$y+40,number_format($row['neto'],0));
    
                        //     if($longitud==6)
                        //         $pdf->Text(191,$y+40,number_format($row['neto'],0));
    
                        //     if($longitud==7)
                        //         $pdf->Text(189,$y+40,number_format($row['neto'],0));
                        // }
                        // $seccionant = $row['codseccion'];
                        // --------------------------------------------------------------------------------------------------------------------------------------------- //

                        // Impresión de los datos del empleado
                        $pdf->SetFont('Arial','',8);
                        $pdf->Text(10,$y+40,substr($row['nombreemp'],0,30));

                        // documento
                        $longitud = strlen($row['dni']);
                        if($longitud==7)            $pdf->Text(70,$y+40,$row['dni']);
                        if($longitud==8)            $pdf->Text(68,$y+40,$row['dni']);
                        if($longitud==9)            $pdf->Text(68,$y+40,$row['dni']);
                        if($longitud==10)           $pdf->Text(67,$y+40,$row['dni']);

                        // Sueldo básico
                        $longitud = strlen($row['basico']);
                        if($longitud==6)            $pdf->Text(97,$y+40,number_format($row['basico'],0));
                        if($longitud==7)            $pdf->Text(95,$y+40,number_format($row['basico'],0));

                        // Días laborados
                        $longitud = strlen($row['dias']);
                        if($longitud==1)            $pdf->Text(115,$y+40,number_format($row['dias'],0));
                        if($longitud==2)            $pdf->Text(113,$y+40,number_format($row['dias'],0));

                        // Monto devengado
                        $longitud = strlen($row['devengados']);
                        if($longitud==5)            $pdf->Text(136,$y+40,number_format($row['devengados'],0));
                        if($longitud==6)            $pdf->Text(134,$y+40,number_format($row['devengados'],0));
                        if($longitud==7)            $pdf->Text(132,$y+40,number_format($row['devengados'],0));

                        $totdevengado += $row['devengados'];            // Incremento el total de devengados

                        // Descuentos
                        $longitud = strlen($row['descuentos']);
                        if($longitud==1)            $pdf->Text(170,$y+40,number_format($row['descuentos'],0));
                        if($longitud==2)            $pdf->Text(168,$y+40,number_format($row['descuentos'],0));
                        if($longitud==3)            $pdf->Text(166,$y+40,number_format($row['descuentos'],0));
                        if($longitud==4)            $pdf->Text(164,$y+40,number_format($row['descuentos'],0));
                        if($longitud==5)            $pdf->Text(163,$y+40,number_format($row['descuentos'],0));
                        if($longitud==6)            $pdf->Text(161,$y+40,number_format($row['descuentos'],0));
                        if($longitud==7)            $pdf->Text(158,$y+40,number_format($row['descuentos'],0));

                        $totdescuento += $row['descuentos'];            // Incremento el total de descuentos

                        // Neto a pagar
                        $longitud = strlen($row['neto']);
                        if($longitud==5)            $pdf->Text(193,$y+40,number_format($row['neto'],0));
                        if($longitud==6)            $pdf->Text(191,$y+40,number_format($row['neto'],0));
                        if($longitud==7)            $pdf->Text(189,$y+40,number_format($row['neto'],0));

                        $y+=6;
    
                        if($y>=220)
                            $y = 243;
                    }
    
                    if($y>=210)
                    {
                        $y=15;
                        $pagina++;
                        $pdf->AddPage("");
                    }
    
                    // Impresión de los totales
                    $pdf->SetFont('Arial','B',9);
                    $enc= "TOTALES NOMINA";                         $pdf->Text(22,$y+50,$enc);
                    $enc= "TOTAL DEVENGADOS: ";                     $pdf->Text(30,$y+56,$enc);
    
                    $pdf->SetFont('Arial','',9);
                    $longitud = strlen($totdevengado);
                    if($longitud==6)                $pdf->Text(84,$y+56,number_format($totdevengado,0));
                    if($longitud==7)                $pdf->Text(82,$y+56,number_format($totdevengado,0));
                    if($longitud==8)                $pdf->Text(80,$y+56,number_format($totdevengado,0));
                    if($longitud==9)                $pdf->Text(78,$y+56,number_format($totdevengado,0));
                    if($longitud==10)               $pdf->Text(76,$y+56,number_format($totdevengado,0));
    
                    $pdf->SetFont('Arial','B',9);
                    $enc= "TOTAL DESCUENTOS: ";     $pdf->Text(30,$y+62,$enc);
    
                    $pdf->SetFont('Arial','',9);
                    $longitud = strlen($totdescuento);
                    if($longitud==1)                $pdf->Text(95,$y+62,number_format($totdescuento,0));
                    if($longitud==2)                $pdf->Text(93,$y+62,number_format($totdescuento,0));
                    if($longitud==3)                $pdf->Text(91,$y+62,number_format($totdescuento,0));
                    if($longitud==4)                $pdf->Text(89,$y+62,number_format($totdescuento,0));
                    if($longitud==5)                $pdf->Text(87,$y+62,number_format($totdescuento,0));
                    if($longitud==6)                $pdf->Text(84,$y+62,number_format($totdescuento,0));
                    if($longitud==7)                $pdf->Text(83,$y+62,number_format($totdescuento,0));
                    if($longitud==8)                $pdf->Text(81,$y+62,number_format($totdescuento,0));
                    if($longitud==9)                $pdf->Text(79,$y+62,number_format($totdescuento,0));
    
                    $pdf->SetFont('Arial','B',9);
                    $enc= "________________";       $pdf->Text(69,$y+64,$enc);
                    $enc= "NETO PAGADO:";           $pdf->Text(30,$y+74,$enc);
    
                    $totneto = $totdevengado - $totdescuento;
    
                    $longitud = strlen($totneto);
                    if($longitud==6)                $pdf->Text(84,$y+74,number_format($totneto,0));
                    if($longitud==7)                $pdf->Text(82,$y+74,number_format($totneto,0));
                    if($longitud==8)                $pdf->Text(80,$y+74,number_format($totneto,0));
                    if($longitud==9)                $pdf->Text(78,$y+74,number_format($totneto,0));
                    if($longitud==10)               $pdf->Text(76,$y+74,number_format($totneto,0));
    
                    $enc= "________________";       $pdf->Text(69,$y+75,$enc);
                    $enc= "________________";       $pdf->Text(69,$y+76,$enc);
                    $enc= "TOTAL A PAGAR:";         $pdf->Text(30,$y+84,$enc);
    
                    $enletras = numtoletras($totneto);
    
                    $longitud = strlen($enletras);
                    if($longitud<=70)
                        $pdf->Text(68,$y+84,$enletras);
                    else
                    {
                        $pdf->Text(68,$y+84,substr($enletras,0,70));
                        $pdf->Text(68,$y+91,substr($enletras,70,70));
                    }
    
                    $pdf->Output();
                }
    
                // Salida en una hoja de Excel
                if($tiposalida=="excel")
                {
                    // Consulta para el informe
                    if($cerrado=="CHECKED")
                        $vsql = "SELECT s.codseccion, s.descripcionsec, p.nombre AS nombreemp,
                                        p.dni, p.basico, SUM(IF(d.conceptoid=1,d.valor,0)) AS dias, 
                                        SUM(d.devengados) AS devengados,
                                        SUM(IF(d.conceptoid NOT IN (4,5,6,9,28,43,58),d.descuentos,0)) AS descuentos, 
                                        (SUM(d.devengados) - SUM(IF(d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS neto, 
                                        b.descripcion banco, p.numcuenta
                                   FROM seccion s
                                        INNER JOIN periodoterceros p ON (s.seccionid = p.seccionid)
                                        INNER JOIN hisdetallenomina d ON (p.terid = d.terid)
                                        INNER JOIN bancos b ON (p.bancoid = b.bancoid)  
                                  WHERE p.esempleadoactivo = 'CHECKED' 
                                        AND p.extralegal = 'CHECKED'
                                        AND d.pernominaid = ".$periodoid."
                                        AND p.pernominaid = ".$periodoid."
                               GROUP BY p.terid
                               ORDER BY s.seccionid, p.codvende";
                    else
                        $vsql = "SELECT s.codseccion, s.descripcionsec, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                                        t.dni, t.basico, SUM(IF(d.conceptoid=1,d.valor,0)) AS dias, 
                                        SUM(d.devengados) AS devengados,
                                        SUM(IF(d.conceptoid NOT IN (4,5,6,9,28,43,58),d.descuentos,0)) AS descuentos, 
                                        (SUM(d.devengados) - SUM(IF(d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS neto, 
                                        b.descripcion banco, t.numcuenta
                                   FROM seccion s
                                        INNER JOIN tercerosactual t ON (s.seccionid = t.seccionid)
                                        INNER JOIN detallenomina d ON (t.terid = d.terid)
                                        INNER JOIN bancos b ON (t.bancoid = b.bancoid)  
                                  WHERE t.esempleadoactivo = 'CHECKED' 
                                        AND t.extralegal = 'CHECKED'
                                        AND d.pernominaid = ".$periodoid."
                               GROUP BY t.terid
                               ORDER BY s.seccionid, t.codvende";

                    require_once 'lib/PHPExcel.php';
                    $clase = new Sistema();
                    $clase->Conectar();
                    ini_set("memory_limit","100M");
                    
                    // Preparación del entorno para la salida a Excel
                    $clase = new Sistema();
                    $clase->Nombredb = $_SESSION['DBNOMBRE'];
                    error_reporting(E_ALL);
                    ini_set('display_errors', TRUE);
                    ini_set('display_startup_errors', TRUE);
                    date_default_timezone_set('Europe/London');
                
                    if (PHP_SAPI == 'cli')
                        die('This example should only be run from a Web Browser');
                
                    // Create new PHPExcel object
                    $objPHPExcel = new PHPExcel();
                
                    // Set document properties
                    $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                                 ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                                 ->setTitle("Listado nómina resumen - DROPOS")
                                                 ->setSubject("Listado nómina resumen - DROPOS")
                                                 ->setDescription("Listado nómina resumen - DROPOS")
                                                 ->setKeywords("Listado nómina resumen - DROPOS")
                                                 ->setCategory("Categoria General");

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A1', 'LISTADO NOMINA RESUMEN')
                                ->setCellValue('A2', 'PERIODO: '.$descripcion)                                
                                ->setCellValue('A4', 'Empleado')
                                ->setCellValue('B4', 'Documento')
                                ->setCellValue('C4', 'Banco')
                                ->setCellValue('D4', 'cuenta')
                                ->setCellValue('E4', 'Basico')
                                ->setCellValue('F4', 'Dias')
                                ->setCellValue('G4', 'Devengados')                                
                                ->setCellValue('H4', 'Descuentos')
                                ->setCellValue('I4', 'Neto a pagar');
                    
                    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
    
                    // Inicialización de variables
                    // $departamento = "";                 $seccionant = "";                   $celda1="";
                    // $celda2="";                         $celda3="";                         $celda4="";
                    // $celda5="";                         $celda6="";                         $celda7="";
                    
                    $i=4;
                    $totdevengado = 0;                      $totdescuento = 0;                  $totneto = 0;
    
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    $cant   = mysql_num_rows($result);
                    while($row = mysql_fetch_array($result))
                    {
                        $i++;

                        // ---------------------------------------------------------------------------------------------------------------------------------------------- //
                        // if($i==5)
                        // {
                        //     $departamento = $row['codseccion']."      ".$row['descripcionsec'];
    
                        //     $objPHPExcel->setActiveSheetIndex(0)
                        //                 ->setCellValue('A3', $departamento)
                        //                 ->setCellValue('A4', 'Empleado')
                        //                 ->setCellValue('B4', 'Documento')
                        //                 ->setCellValue('C4', 'Basico')
                        //                 ->setCellValue('D4', 'Dias')
                        //                 ->setCellValue('E4', 'Devengados')
                        //                 ->setCellValue('F4', 'Descuentos')
                        //                 ->setCellValue('G4', 'Neto a pagar');
    
                        //     $objPHPExcel->setActiveSheetIndex(0)
                        //                 ->setCellValue('A'.$i, $row['nombreemp'])
                        //                 ->setCellValue('B'.$i, $row['dni'])
                        //                 ->setCellValue('C'.$i, number_format($row['basico']))
                        //                 ->setCellValue('D'.$i, number_format($row['dias']))
                        //                 ->setCellValue('E'.$i, number_format($row['devengados']))
                        //                 ->setCellValue('F'.$i, number_format($row['descuentos']))
                        //                 ->setCellValue('G'.$i, number_format($row['neto']));
    
                        //     // Incremento de los totales
                        //     $totdevengado += $row['devengados'];
                        //     $totdescuento += $row['descuentos'];
                        //     $totneto += $row['neto'];
                        // }
                        // else
                        // {
                        //     if($row['codseccion']!=$seccionant)
                        //     {
                        //         $i++;
                        //         $departamento = $row['codseccion']."      ".$row['descripcionsec'];
    
                        //         $celda1="A".strval($i+1);
                        //         $celda2="B".strval($i+1);
                        //         $celda3="C".strval($i+1);
                        //         $celda4="D".strval($i+1);
                        //         $celda5="E".strval($i+1);
                        //         $celda6="F".strval($i+1);
                        //         $celda7="G".strval($i+1);
    
                        //         $objPHPExcel->setActiveSheetIndex(0)
                        //                     ->setCellValue('A'.$i, $departamento)
                        //                     ->setCellValue($celda1, 'Empleado')
                        //                     ->setCellValue($celda2, 'Documento')
                        //                     ->setCellValue($celda3, 'Basico')
                        //                     ->setCellValue($celda4, 'Dias')
                        //                     ->setCellValue($celda5, 'Devengados')
                        //                     ->setCellValue($celda6, 'Descuentos')
                        //                     ->setCellValue($celda7, 'Neto a pagar');
                        //         $i+=2;
                        //         $cant+=2;
                        //     }
    
                        //     $objPHPExcel->setActiveSheetIndex(0)
                        //                 ->setCellValue('A'.$i, $row['nombreemp'])
                        //                 ->setCellValue('B'.$i, $row['dni'])
                        //                 ->setCellValue('C'.$i, number_format($row['basico']))
                        //                 ->setCellValue('D'.$i, number_format($row['dias']))
                        //                 ->setCellValue('E'.$i, number_format($row['devengados']))
                        //                 ->setCellValue('F'.$i, number_format($row['descuentos']))
                        //                 ->setCellValue('G'.$i, number_format($row['neto']));
    
                        //     // Incremento de los totales
                        //     $totdevengado += $row['devengados'];
                        //     $totdescuento += $row['descuentos'];
                        //     $totneto += $row['neto'];                                    
                        // }
    
                        // $seccionant = $row['codseccion'];
                        // ---------------------------------------------------------------------------------------------------------------------------------------------- //

                        $numcuenta = $row['numcuenta'];

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A'.$i, $row['nombreemp'])
                                    ->setCellValue('B'.$i, $row['dni'])
                                    ->setCellValue('C'.$i, $row['banco'])
                                    ->setCellValue('D'.$i, $numcuenta)
                                    ->setCellValue('E'.$i, number_format($row['basico']))
                                    ->setCellValue('F'.$i, number_format($row['dias']))
                                    ->setCellValue('G'.$i, number_format($row['devengados']))                                    
                                    ->setCellValue('H'.$i, number_format($row['descuentos']))
                                    ->setCellValue('I'.$i, number_format($row['neto']));

                        // Incremento de los totales
                        $totdevengado += $row['devengados'];
                        $totdescuento += $row['descuentos'];
                        $totneto += $row['neto'];
                        $cant++;
                    }
                    
                    $rangoEncabezado = 'A4:I4';
                    $rangoCeldas     = 'A4:I'.($i);
    
                    $lineadev = $i + 2;
                    $lineadesc = $i + 3;
                    $lineaneto = $i + 4;
    
                    // Impresión de los totales
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A'.$lineadev, "TOTAL DEVENGADOS:")
                                ->setCellValue('A'.$lineadesc, "TOTAL DESCUENTOS:")
                                ->setCellValue('A'.$lineaneto, "NETO PAGADO:");
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('C'.$lineadev, number_format($totdevengado))
                                ->setCellValue('C'.$lineadesc, number_format($totdescuento))
                                ->setCellValue('C'.$lineaneto, number_format($totneto));
                    
                    // ------------------------------------------------------------------------------------------------------------- //
                    // Formato de Encabezado y Celdas
                    $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
                    
                    $EstiloCeldas = array(
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN,
                            'color' => array('argb' => '00000000'),
                        ),
                        ),
                    );
                    $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
                    /// Formato de Encabezados 
                    $EstiloEncabezado = array(
                    'font' => array(
                        'bold' => true,
                    ),
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                        'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
                    ),
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN,
                            'color' => array('argb' => '00000000'),
                        ),
                    ),
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'rotation' => 90,
                        'startcolor' => array(
                            'argb' => '00FFFFCC',
                        ),
                        'endcolor' => array(
                            'argb' => 'FFFFFF',
                        ),
                        ),
                    );
                    $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
                    // Rename worksheet
                    $objPHPExcel->getActiveSheet()->setTitle('Listado nómina resumen');
                    // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                    $objPHPExcel->setActiveSheetIndex(0);
                    // Redirect output to a client’s web browser (Excel5)
                    header('Content-Type: application/vnd.ms-excel');
                    // --------------------------------------------------------------------- //
                    // header('Content-Disposition: attachment;filename="listadonomres.xls"');
                    $nombrearcexcel = "nomina resumen ".strtolower($descripcion).".xls";
                    header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
                    // --------------------------------------------------------------------- //
                    header('Cache-Control: max-age=0');
                    /// Genero la Salida
                    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
                    $objWriter->save('php://output');
                    exit;
                }
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función numtoletras
    // Parámetro de entrada:    $xcifra --> número que se traducirá a letras    
    // Valor de retorno:        $xcadena --> cadena con el valor en letras
    // Descripción: Función que convierte un número en letras
    // Última modificación: Se suprimió la impresión de céntimos en el total en letras
    //                      (18/08/2021)
    ////////////////////////////////////////////////////////////////////////////////////////
    function numtoletras($xcifra)
    {
        $xarray = array(0 => "Cero",
            1 => "UN", "DOS", "TRES", "CUATRO", "CINCO", "SEIS", "SIETE", "OCHO", "NUEVE",
            "DIEZ", "ONCE", "DOCE", "TRECE", "CATORCE", "QUINCE", "DIECISEIS", "DIECISIETE", "DIECIOCHO", "DIECINUEVE",
            "VEINTI", 30 => "TREINTA", 40 => "CUARENTA", 50 => "CINCUENTA", 60 => "SESENTA", 70 => "SETENTA", 80 => "OCHENTA", 90 => "NOVENTA",
            100 => "CIENTO", 200 => "DOSCIENTOS", 300 => "TRESCIENTOS", 400 => "CUATROCIENTOS", 500 => "QUINIENTOS", 600 => "SEISCIENTOS", 700 => "SETECIENTOS", 800 => "OCHOCIENTOS", 900 => "NOVECIENTOS"
        );
    //
        $xcifra = trim($xcifra);
        $xlength = strlen($xcifra);
        $xpos_punto = strpos($xcifra, ".");
        $xaux_int = $xcifra;
        $xdecimales = "00";
        if (!($xpos_punto === false)) 
        {
            if ($xpos_punto == 0) 
            {
                $xcifra = "0" . $xcifra;
                $xpos_punto = strpos($xcifra, ".");
            }
            $xaux_int = substr($xcifra, 0, $xpos_punto); // obtengo el entero de la cifra a covertir
            $xdecimales = substr($xcifra . "00", $xpos_punto + 1, 2); // obtengo los valores decimales
        }
    
        $XAUX = str_pad($xaux_int, 18, " ", STR_PAD_LEFT); // ajusto la longitud de la cifra, para que sea divisible por centenas de miles (grupos de 6)
        $xcadena = "";
        for ($xz = 0; $xz < 3; $xz++) 
        {
            $xaux = substr($XAUX, $xz * 6, 6);
            $xi = 0;
            $xlimite = 6; // inicializo el contador de centenas xi y establezco el límite a 6 dígitos en la parte entera
            $xexit = true; // bandera para controlar el ciclo del While
            while ($xexit) 
            {
                if ($xi == $xlimite) 
                { // si ya llegó al límite máximo de enteros
                    break; // termina el ciclo
                }
    
                $x3digitos = ($xlimite - $xi) * -1; // comienzo con los tres primeros digitos de la cifra, comenzando por la izquierda
                $xaux = substr($xaux, $x3digitos, abs($x3digitos)); // obtengo la centena (los tres dígitos)
                for ($xy = 1; $xy < 4; $xy++) { // ciclo para revisar centenas, decenas y unidades, en ese orden
                    switch ($xy) {
                        case 1: // checa las centenas
                            if (substr($xaux, 0, 3) < 100) { // si el grupo de tres dígitos es menor a una centena ( < 99) no hace nada y pasa a revisar las decenas
                                
                            } else {
                                $key = (int) substr($xaux, 0, 3);
                                if (TRUE === array_key_exists($key, $xarray)){  // busco si la centena es número redondo (100, 200, 300, 400, etc..)
                                    $xseek = $xarray[$key];
                                    $xsub = subfijo($xaux); // devuelve el subfijo correspondiente (Millón, Millones, Mil o nada)
                                    if (substr($xaux, 0, 3) == 100)
                                        $xcadena = " " . $xcadena . " CIEN " . $xsub;
                                    else
                                        $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                                    $xy = 3; // la centena fue redonda, entonces termino el ciclo del for y ya no reviso decenas ni unidades
                                }
                                else { // entra aquí si la centena no fue numero redondo (101, 253, 120, 980, etc.)
                                    $key = (int) substr($xaux, 0, 1) * 100;
                                    $xseek = $xarray[$key]; // toma el primer caracter de la centena y lo multiplica por cien y lo busca en el arreglo (para que busque 100,200,300, etc)
                                    $xcadena = " " . $xcadena . " " . $xseek;
                                } // ENDIF ($xseek)
                            } // ENDIF (substr($xaux, 0, 3) < 100)
                            break;
                        case 2: // checa las decenas (con la misma lógica que las centenas)
                            if (substr($xaux, 1, 2) < 10) {
                                
                            } else {
                                $key = (int) substr($xaux, 1, 2);
                                if (TRUE === array_key_exists($key, $xarray)) {
                                    $xseek = $xarray[$key];
                                    $xsub = subfijo($xaux);
                                    if (substr($xaux, 1, 2) == 20)
                                        $xcadena = " " . $xcadena . " VEINTE " . $xsub;
                                    else
                                        $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                                    $xy = 3;
                                }
                                else {
                                    $key = (int) substr($xaux, 1, 1) * 10;
                                    $xseek = $xarray[$key];
                                    if (20 == substr($xaux, 1, 1) * 10)
                                        $xcadena = " " . $xcadena . " " . $xseek;
                                    else
                                        $xcadena = " " . $xcadena . " " . $xseek . " Y ";
                                } // ENDIF ($xseek)
                            } // ENDIF (substr($xaux, 1, 2) < 10)
                            break;
                        case 3: // checa las unidades
                            if (substr($xaux, 2, 1) < 1) { // si la unidad es cero, ya no hace nada
                                
                            } else {
                                $key = (int) substr($xaux, 2, 1);
                                $xseek = $xarray[$key]; // obtengo directamente el valor de la unidad (del uno al nueve)
                                $xsub = subfijo($xaux);
                                $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                            } // ENDIF (substr($xaux, 2, 1) < 1)
                            break;
                    } // END SWITCH
                } // END FOR
                $xi = $xi + 3;
            } // ENDDO
    
            if (substr(trim($xcadena), -5, 5) == "ILLON") // si la cadena obtenida termina en MILLON o BILLON, entonces le agrega al final la conjuncion DE
                $xcadena.= " DE";
    
            if (substr(trim($xcadena), -7, 7) == "ILLONES") // si la cadena obtenida en MILLONES o BILLONES, entoncea le agrega al final la conjuncion DE
                $xcadena.= " DE";
    
            // ----------- esta línea la puedes cambiar de acuerdo a tus necesidades o a tu país -------
            // if (trim($xaux) != "") {
            //     switch ($xz) {
            //         case 0:
            //             if (trim(substr($XAUX, $xz * 6, 6)) == "1")
            //                 $xcadena.= "UN BILLON ";
            //             else
            //                 $xcadena.= " BILLONES ";
            //             break;
            //         case 1:
            //             if (trim(substr($XAUX, $xz * 6, 6)) == "1")
            //                 $xcadena.= "UN MILLON ";
            //             else
            //                 $xcadena.= " MILLONES ";
            //             break;
            //         case 2:
            //             if ($xcifra < 1) {
            //                 $xcadena = "CERO PESOS CON $xdecimales/100";
            //             }
            //             if ($xcifra >= 1 && $xcifra < 2) {
            //                 $xcadena = "UN PESO CON $xdecimales/100";
            //             }
            //             if ($xcifra >= 2) {
            //                 $xcadena.= " PESOS CON $xdecimales/100"; //
            //             }
            //             break;
            //     } // endswitch ($xz)
            // } // ENDIF (trim($xaux) != "")

            if (trim($xaux) != "") 
            {
                switch ($xz) 
                {
                    case 0:
                        if (trim(substr($XAUX, $xz * 6, 6)) == "1")
                            $xcadena.= "UN BILLON ";
                        else
                            $xcadena.= " BILLONES ";
                        break;
                    case 1:
                        if (trim(substr($XAUX, $xz * 6, 6)) == "1")
                            $xcadena.= "UN MILLON ";
                        else
                            $xcadena.= " MILLONES ";
                        break;
                    case 2:
                        if ($xcifra < 1) {
                            $xcadena = "CERO PESOS";
                        }
                        if ($xcifra >= 1 && $xcifra < 2) {
                            $xcadena = "UN PESO";
                        }
                        if ($xcifra >= 2) {
                            $xcadena.= " PESOS"; //
                        }
                        break;
                } // endswitch ($xz)
            } // ENDIF (trim($xaux) != "")

            // ------------------      en este caso, para México se usa esta leyenda     ----------------
            $xcadena = str_replace("VEINTI ", "VEINTI", $xcadena); // quito el espacio para el VEINTI, para que quede: VEINTICUATRO, VEINTIUN, VEINTIDOS, etc
            $xcadena = str_replace("  ", " ", $xcadena); // quito espacios dobles
            $xcadena = str_replace("UN UN", "UN", $xcadena); // quito la duplicidad
            $xcadena = str_replace("  ", " ", $xcadena); // quito espacios dobles
            $xcadena = str_replace("BILLON DE MILLONES", "BILLON DE", $xcadena); // corrigo la leyenda
            $xcadena = str_replace("BILLONES DE MILLONES", "BILLONES DE", $xcadena); // corrigo la leyenda
            $xcadena = str_replace("DE UN", "UN", $xcadena); // corrigo la leyenda
        } // ENDFOR ($xz)
        return trim($xcadena);
    }

    function subfijo($xx)
    { // esta función regresa un subfijo para la cifra
        $xx = trim($xx);
        $xstrlen = strlen($xx);
        if ($xstrlen == 1 || $xstrlen == 2 || $xstrlen == 3)
            $xsub = "";
        //
        if ($xstrlen == 4 || $xstrlen == 5 || $xstrlen == 6)
            $xsub = "MIL";
        //
        return $xsub;
    }    
?>