<?PHP
    @session_start(); 
    include("lib/Sistema.php");
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];
    $avisos = "";
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: "filtrarmarcas"
    // Creación: 22/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que filtra la ventana principal por una marca
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtrarmarcas")
    {
        $marcaid = $_POST['marcaid'];
        header("Location: marcasproductos.php?opcion=ventanamxp&marcaid=$marcaid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanamxp
    // Creación: 21/02/2023		última modificación: 05/05/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la venta principal del formulario
    // Última modificación: Inclusión de los botones para rotación de cada marca y rotación 
    //                      y existencias para los productos asociados a cada marca
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanamxp")
    {
        // Pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/logros.png" width="32" height="32" border="0"> </td>
                  <td width="766"> <b>Marcas de productos</b> </td>
                  <td width="30" align="center"> 
                   <a href="?opcion=nuevamarca" rel="facebox"> 
                    <img src="images/basicas/icononuevo.png" title="incluir marca" border="0"> 
                   </a> 
                  </td>    
                  <td width="10"> &nbsp; </td>
                  <form action="?opcion=encontrar" method="POST" name="x">
                  <td> <input type="text" name="criterio" size="30" placeholder="Criterio a Buscar" tabindex="1" id="default"> </td>
                  <td> <input type="submit" value="Encontrar" class="button"></form> </td>';
        
        if($_SESSION['SQL_MARCA'] != "")
            $cont.='<td width="10"> <a href="?opcion=nofiltro"> <img src="images/basicas/nofiltro.png"> </a> </td>';

        $cont.='  <td width="24"> 
                   <a href="reportes/erroresmarca.php" target="_blank">
                    <img src="images/iconos/notas.png" border="0" width="38" height="38" title="c&oacute;digos de productos no guardados en el &uacute;ltimo proceso de importaci&oacute;n">
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="24"> 
                   <a href="principal.php">
                    <input type="button" value="<<" class="button">
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';
    
        if($_SESSION['SQL_MARCA'] == "")
            $vsql = "SELECT * FROM marcasproductos ORDER BY marcaid ASC";
        else
            $vsql = $_SESSION['SQL_MARCA'];

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;"> 
                   <td width="15">&nbsp;</td>
                   <td width="150" align="left"> C&oacute;digo </td>				 
                   <td width="350" align="left"> Descripci&oacute;n </td>
                   <td width="150" align="left"> Productos </td>			
                   <td width="350" align="left"> &nbsp; </td>		
                   <td width="50" align="left"> &nbsp; </td>	
                   <td width="45"> &nbsp; </td>
                   <td width="45"> &nbsp; </td>				 
                   <td width="45"> &nbsp; </td>
                  </tr>
                  </thead>
                  <tbody style="display:block; width:1050; height:200px; overflow-Y:scroll">';
        
        $i = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            // Número de productos asociados a esta marca
            $marcaid = $row['marcaid'];
            $vsql4 = "SELECT COUNT(*) FROM marcaxproducto WHERE marcaid = ".$marcaid."";
            $numproductosaso = $clase->SeleccionarUno($vsql4);
            
            // Imprimo el detalle
            $cont.='  <td width="15"> &nbsp; </td>
                      <td width="140" align="left"> '.$row['codmarca'].' </td>
                      <td width="280" align="left"> '.$row['nommarca'].' </td>
                      <td width="100"  align="right"> '.number_format($numproductosaso).' </td>
                      <td width="390"> &nbsp; </td>';            
            
            if($numproductosaso == 0)
                $cont.='  <td width="30"> &nbsp; </td>
                          <td width="30"> 
                           <a href="?opcion=confirmareliminar&marcaid='.$row['marcaid'].'" rel="facebox">
                            <img src="images/basicas/iconoborrar.png" title="eliminar marca '.$row['nommarca'].'" border="0">
                           </a> 
                          </td>';
            else
                $cont.='  <td width="30"> 
                           <a href="?opcion=infrotamarca&marcaid='.$row['marcaid'].'" target="_blank">
                            <img src="images/basicas/rotacion.png" title="rotaci&oacute;n de la marca '.$row['nommarca'].'" border="0">
                           </a>
                          </td>
                          <td width="30"> 
                           <a href="?opcion=marcaxls&marcaid='.$row['marcaid'].'" target="_blank">
                            <img src="images/basicas/excel.png" title="salida a Excel de la marca '.$row['nommarca'].'" border="0">
                           </a> 
                          </td>';

            $cont.='  <td width="30">
                       <a href="?opcion=asignarproducto&marcaid='.$row['marcaid'].'" rel="facebox">
                        <img src="images/basicas/iconorefrescar.png" title="asignar un producto a marca '.$row['nommarca'].'" border="0">
                        </a> 
                      </td>
                      <td width="30">
                       <a href="?opcion=importarexcel1&marcaid='.$row['marcaid'].'" rel="facebox">
                        <img src="images/basicas/subir.png" title="importar productos desde una hoja de Excel a la marca '.$row['nommarca'].'" border="0">
                       </a> 
                      </td>
                      <td width="30"> 
                       <a href="?opcion=editarmarca&marcaid='.$row['marcaid'].'" rel="facebox"> 
                        <img src="images/basicas/iconobuscar.png" title="editar marca '.$row['nommarca'].'" border="0"> 
                       </a> 
                      </td>
                     </tr>';
        }
    
        $cont.=' </tbody> 
                </table>';

        mysql_free_result($result);
        mysql_close($conex);

        // ----------------------------------------------------------------------------------------------------------------------------------------------- //
        // panel de marcas
        $marcaid = $_GET['marcaid'];
        if(strlen($marcaid) == 0)   $marcaid = $_POST['marcaid'];

        if(strlen($marcaid) == 0)
        {
            $vsql9 = "SELECT MIN(marcaid) minmarca FROM marcasproductos";
            $minmarca = $clase->SeleccionarUno($vsql9);
            $marcaid = $minmarca;
        }

        $params = ' class="Texto12" style="height:25px;width:300px;" OnChange="y.submit();"';
        $vsqlcombomarcas = "SELECT marcaid, CONCAT(codmarca,' - ',nommarca) FROM marcasproductos WHERE 1 ORDER BY marcaid";

        // Número de productos de la marca seleccionada
        $vsql11 = "SELECT COUNT(*) numprodmarca FROM marcaxproducto WHERE marcaid = ".$marcaid;
        $numprodmarca = $clase->SeleccionarUno($vsql11);

        $cont.='<form action="?opcion=filtrarmarcas" method="POST" name="y">
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10" align="center"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/notificaciones.png" width="32" height="32" border="0"> </td>
                  <td width="737" align="left"> 
                   <b>Productos asociados a la marca</b>
                   &nbsp;&nbsp
                   '.$clase->CrearComboEsp("marcaid",$vsqlcombomarcas,"marcaid","nommarca",$marcaid,"N",$params).' 
                   </form>
                  </td>';
        
        if($numprodmarca > 0)
            $cont.='<td width="37"> 
                     <a href="?opcion=confirmarvaciado&marcaid='.$marcaid.'" rel="facebox">
                      <img src="images/iconos/devoluciones.png" width="32" height="32" border="0" title="vaciar productos"> 
                     </a> 
                    </td>';
        else
            $cont.='<td width="37"> &nbsp; </td>';

        $cont.='  <td width="403" align="left"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                 <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                  <td width="12"> &nbsp; </td>
                  <td width="230" align="left"> C&oacute;digo </td>
                  <td width="693" align="left"> Producto </td>			
                  <td width="60"> &nbsp; </td>
                 </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:350px; overflow-Y:scroll">';

        $vsql8 = "SELECT p.codigo, p.descripcion, mxp.productoid
                    FROM productos p
                         INNER JOIN marcaxproducto mxp ON (p.productoid = mxp.productoid)
                   WHERE mxp.marcaid = ".$marcaid;

        // Impresión del detalle del informe
        $j = 0;
        $numprodxm = 0;
        $conex  = $clase->Conectar();
        $result2 = mysql_query($vsql8,$conex);
        while($row2 = mysql_fetch_array($result2))
        {
            $j++;
            if($j%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $cont.=' <td width="12"> &nbsp; </td>
                     <td width="290" align="left"> '.$row2['codigo'].' </td>
                     <td width="633" align="left"> '.$row2['descripcion'].' </td>
                     <td width="340"> &nbsp; </td>
                     <td width="30" align="center"> 
                      <a href="productos.php?opcion=rotaciondrog&id='.$row2['productoid'].'" target="_blank">
                       <img src="images/basicas/rotacion.png" border="0" title="Rotacion en Sucursales">
                      </a>
                     </td>
                     <td width="30" align="center">
                      <a href="#" OnClick="window.open(\'exipublica.php?codproducto='.$row2['codigo'].'\',\'ConsuExi\',\'width=730,height=780\');">
                       <img src="images/basicas/existencias.png" border="0" title="Existencia en Bodegas">
                      </a>
                     </td>
                     <td width="20" align="center">
                      <a href="?opcion=confirmaprod&productoid='.$row2['productoid'].'&marcaid='.$marcaid.'" rel="facebox" title="eliminar producto">
                       <img src="images/basicas/iconoborrar.png" border="0">
                      </a>
                     </td>
                     <td width="10" align="center"> &nbsp; </td>
                    </tr>';

            $numprodxm++;
        }

        $cont.=' </tbody>
                </table>';

        // Total de productos asociados
        $nommarca = $clase->BDLockup($marcaid,'marcasproductos','marcaid','nommarca');
        $cont.='<table width="100%">
                 <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;"> 
                  <td width="20"> &nbsp; </td>
                  <td width="1125" align="left"> <label class="Texto13"><b><font color="WHITE"> '.number_format($numprodxm).' productos asociados a la marca '.trim($nommarca).' </font></b></label> </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>';

        mysql_free_result($result2);
        mysql_close($conex);
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nuevamarca
    // Creación: 22/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar los datos de una nueva marca
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nuevamarca")
    {
        $codmarca = "";
        $nommarca = "";

        // pinto la ventana
        $cont ='<table width="400">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td width="350" align="center"> <b>Incluir marca</b> <br> </td>
                 </tr> 
                </table>
                <form action="?opcion=guardarnewmarca" method="POST" name="x">
                <table width="400">
                 <center>
                 <tr class="TablaDocsImPar">
                  <td width="100" align="right"><label class="Texto12"> C&oacute;digo: </label>&nbsp;</td>
                  <td width="300">
                   <input type="text" class="Texto13" name="codmarca" size="10" maxlenght="5" value="'.$codmarca.'">
                  </td>
                 </tr>	
                 <tr class="TablaDocsImPar">
                  <td width="100" align="right"><label class="Texto12"> Marca: </label>&nbsp; </td>
                  <td width="300">                  
                   <input type="text" class="Texto13" name="nommarca" size="30" maxlenght="30" value="'.$nommarca.'">
                  </td>
                 </tr>
                </table>
                <br>
                <center>
                <input type="submit" value="aceptar" class="button blue">
                <a href="marcasproductos.php?opcion=ventanamxp"><input type="button" value="CANCELAR" class="button red"></a>
                </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarnewmarca
    // Creación: 22/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que guarda los datos de una nueva marca
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarnewmarca")
    {
        $codmarca = $_POST['codmarca'];
        $nommarca = strtoupper(trim($_POST['nommarca']));
        
        // Validación de los campos
        if((strlen($codmarca) == 0)&&(strlen($nommarca) == 0))
            $clase->Aviso(3,"Se deben introducir todos los datos");
        else
        {
            // Valido el código
            $vsql2 = "SELECT COUNT(*) numcondigo FROM marcasproductos WHERE codmarca = '".$codmarca."'";
            $numcondigo = $clase->SeleccionarUno($vsql2);

            if($numcondigo > 0)
                $clase->Aviso(3,"El código $codmarca ya existe, verifique por favor");
            else
            {
                // Valido la marca
                $vsql3 = "SELECT COUNT(*) numnombre FROM marcasproductos WHERE nommarca = '".$nommarca."'";
                $numnombre = $clase->SeleccionarUno($vsql3);

                if($numnombre > 0)
                    $clase->Aviso(3,"La marca $nommarca ya existe, verifique por favor");
                else
                {
                    $vsql = "INSERT INTO marcasproductos (codmarca, nommarca) VALUES ('".$codmarca."','".$nommarca."')";
                    $clase->EjecutarSQL($vsql);
        
                    // Emito el mensaje correspondiente
                    if(mysql_affected_rows() >= 1)
                        $clase->Aviso(1,"Datos almacenados satisfactoriamente");
                    else
                        $clase->Aviso(3,"No se almacenaron los datos");
                }
            }
        }

        // Redirecciono el formulario
        $vsql = "SELECT MAX(marcaid) maxmarca FROM marcasproductos";
        $maxmarca = $clase->SeleccionarUno($vsql);
        $marcaid = $maxmarca;

        header("Location: marcasproductos.php?opcion=ventanamxp&marcaid=$marcaid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editarmarca
    // Creación: 22/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana de edición de una marca
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarmarca")
    {
        $marcaid = $_GET['marcaid'];
        $codmarca = $clase->BDLockup($marcaid,'marcasproductos','marcaid','codmarca');
        $nommarca = $clase->BDLockup($marcaid,'marcasproductos','marcaid','nommarca');

        $cont ='<table width="400">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/listadoestudiantesnotas.png" width="32" height="32" border="0"> </td>
                  <td width="350" align="center"><label class="Texto12"> <b>Editar marca</b> </label><br> </td>
                 </tr> 
                </table>
                <form action="?opcion=guardarmarcaeditada" method="POST" name="x">
                <input type="hidden" name="marcaid" value="'.$marcaid.'">
                <table width="400">
                 <center>
                 <tr class="TablaDocsImPar">
                  <td width="100" align="right"><label class="Texto12"> C&oacute;digo:</label> &nbsp;</td>
                  <td width="300">
                   <input type="text" name="codmarca" class="Texto13" size="5" maxlength="5" autocomplete="off" value="'.$codmarca.'">
                  </td>
                 </tr>	
                 <tr class="TablaDocsImPar">
                  <td width="100" align="right"><label class="Texto12"> Marca:</label> &nbsp; </td>
                  <td width="300">
                   <input type="text" name="nommarca" class="Texto13" size="30" maxlength="30" autocomplete="off" value="'.$nommarca.'">
                  </td>
                 </tr>
                </table>
                <br>
                <center>
                <input type="submit" value="aceptar" class="button blue">
                <a href="marcasproductos.php?opcion=ventanamxp&marcaid='.$marcaid.'" ><input type="button" value="CANCELAR" class="button red"></a>
                </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarmarcaeditada
    // Creación: 22/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para guardar los datos editados de una marca
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarmarcaeditada")
    {
        $marcaid = $_POST['marcaid'];
        $codmarcanew = $_POST['codmarca'];
        $nommarcanew = strtoupper(trim($_POST['nommarca']));

        // datos actuales
        $codmarcaold = $clase->BDLockup($marcaid,'marcasproductos','marcaid','codmarca');
        $nommarcaold = $clase->BDLockup($marcaid,'marcasproductos','marcaid','nommarca');

        // Validación de los campos
        if((strlen($codmarcanew) == 0)&&(strlen($nommarcanew) == 0))
            $clase->Aviso(3,"Se deben introducir todos los datos");
        else
        {
            // Valido el código
            if($codmarcanew == $codmarcaold)
                $lb_codigoigual = true;
            else
                $lb_codigoigual = false;

            if(!$lb_codigoigual)
            {
                $vsql2 = "SELECT COUNT(*) numcondigo FROM marcasproductos WHERE codmarca = '".$codmarcanew."'";
                $numcondigo = $clase->SeleccionarUno($vsql2);
            }

            if(!$lb_codigoigual && ($numcondigo > 0))
                $clase->Aviso(3,"El código $codmarcanew ya existe, verifique por favor");
            else
            {
                // Valido la marca
                if($nommarcanew == $nommarcaold)
                    $lb_marcaigual = true;
                else
                    $lb_marcaigual = false;

                if(!$lb_marcaigual)
                {
                    $vsql3 = "SELECT COUNT(*) numnombre FROM marcasproductos WHERE nommarca = '".$nommarcanew."'";
                    $numnombre = $clase->SeleccionarUno($vsql3);
                }

                if(!$lb_marcaigual && ($numnombre > 0))
                    $clase->Aviso(3,"La marca $nommarcanew ya existe, verifique por favor");
                else
                {
                    // Guardo los cambios
                    $vsql = "UPDATE marcasproductos SET 
                                    codmarca = '".$codmarcanew."', 
                                    nommarca = '".$nommarcanew." '
                              WHERE marcaid = ".$marcaid;
                    $clase->EjecutarSQL($vsql);

                    // Emito el mensaje correspondiente
                    if(mysql_affected_rows() >= 1)
                        $clase->Aviso(1,"Datos editados satisfactoriamente");
                    else
                        $clase->Aviso(3,"No se editaron los datos");
                }
            }
        }
        // Redirecciono el formulario
        header("Location: marcasproductos.php?opcion=ventanamxp&marcaid=$marcaid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmareliminar
    // Creación: 22/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que solicita la confirmación de la eliminación de una marca
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmareliminar")
    {
        $marcaid = $_GET['marcaid'];
        $nommarca = $clase->BDLockup($marcaid,'marcasproductos','marcaid','nommarca');
        
        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><label class="Texto12"><b>Eliminar marca</b></label><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <label class="Texto12">¿Confirma que desea eliminar la marca <br> <b>'.trim($nommarca).'</b>?</label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=elimarmarca&marcaid='.$marcaid.'" method="POST">
                   <input type="hidden" name="marcaid" value="'.$marcaid.'"> 
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="marcasproductos.php?opcion=ventanamxp" ><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                   <br>
                  </td> 
                 </tr>
                </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: elimarmarca
    // Creación: 22/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para eliminar físicamente una marca
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "elimarmarca")
    {
        $marcaid = $_POST['marcaid'];
        $nommarca = $clase->BDLockup($marcaid,'marcasproductos','marcaid','nommarca');

        // Validación de número de productos asociados a la marca
        $vsql5 = "SELECT COUNT(*) FROM marcaxproducto WHERE marcaid = ".$marcaid;
        $numproductosaso = $clase->SeleccionarUno($vsql5);
        
        if($numproductosaso)
            $clase->Aviso(3,"No se puede eliminar la marca $nommarca porque existen $numproductosaso productos asociadas a ella");
        else
        {
            // Elimino la cesantía
            $vsql = "DELETE FROM marcasproductos WHERE marcaid = ".$marcaid;
            $clase->EjecutarSQL($vsql);

            // Emito el mensaje correspondiente
            if(mysql_affected_rows() >= 1)
                $clase->Aviso(1,"Marca $nommarca eliminada satisfactoriamente");
            else
                $clase->Aviso(3,"No se eliminó la marca $nommarca");
        }
        // Redirecciono el formulario
        header("Location: marcasproductos.php?opcion=ventanamxp");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: encontrar
    // Creación: 22/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que hace la búsqueda de una marca
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "encontrar")
    {
        $criterio = $_POST['criterio'];
        $vsql = "SELECT * FROM marcasproductos WHERE nommarca LIKE '%".$criterio."%' ORDER BY marcaid ASC Limit 0,".$_SESSION["NUMREGISTROSXCONSULTA"];
        $_SESSION['SQL_MARCA'] = $vsql;
        header("Location: marcasproductos.php?opcion=ventanamxp");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nofiltro
    // Creación: 22/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que anula la búsqueda de una marca
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nofiltro")
    {
        $criterio = $_POST['criterio'];
        $vsql = "SELECT * FROM marcasproductos ORDER BY marcaid ASC limit 0,30";
        $_SESSION['SQL_MARCA'] = "";
        header("Location: marcasproductos.php?opcion=ventanamxp");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: asignarproducto
    // Creación: 22/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar un producto que se asociará a 
    //              una marca
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "asignarproducto")
    {
        $marcaid = $_GET['marcaid'];
        $nommarca = $clase->BDLockup($marcaid,'marcasproductos','marcaid','nommarca');

        $params = ' class="Texto12" ';
        $vsqlcomboproducto = "SELECT productoid, CONCAT(codigo,' - ',descripcion) FROM productos WHERE 1 ORDER BY productoid ASC";

        // Pinto la ventana
        $cont ='<table width="700">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><b>Asociar producto a la marca<br><font color="BLUE">'.$nommarca.'</font></b><br><br></td> 
                 </tr> 
                </table>
                <form action="?opcion=guardarasignacion&marcaid='.$marcaid.'" method="POST">
                <input type="hidden" name="marcaid" value="'.$marcaid.'"> 
                <table width="700">
                 <tr class="TablaDocsImPar">
                  <td width="100" align="right"><label class="Texto12"> Producto: </label>&nbsp;&nbsp;</td>
                  <td width="600">
                   '.$clase->CrearComboBuscar("productoid",$vsqlcomboproducto,"descripcion","productoid","","S",$params,570).'
                  </td>
                 </tr>
                </table> 
                <br>
                <center>
                <input type="submit" value="aceptar" class="button blue">
                <a href="marcasproductos.php?opcion=ventanamxp&marcaid='.$marcaid.'"><input type="button" value="CANCELAR" class="button red"></a>
                </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarasignacion
    // Creación: 22/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que asocia un producto a una marca
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarasignacion")
    {
        $marcaid = $_POST['marcaid'];
        $productoid = $_POST['productoid'];

        // valido que tenga todos los datos
        if((strlen($marcaid) == 0) && (strlen($productoid) == 0))
            $clase->Aviso(3,"Se deben introducir todos los datos");
        else
        {
            $descripcion = $clase->BDLockup($productoid,'productos','productoid','descripcion');
            $nommarca = $clase->BDLockup($marcaid,'marcasproductos','marcaid','nommarca');

            // Valido que el producto no está incluido en esta marca
            $vsql2 = "SELECT COUNT(*) numproductosmarca FROM marcaxproducto WHERE marcaid = ".$marcaid." AND productoid = ".$productoid;
            $numproductosmarca = $clase->SeleccionarUno($vsql2);

            if($numproductosmarca > 0)
                $clase->Aviso(3,"El producto $descripcion ya pertenece a la marca $nommarca");
            else
            {
                // Valido que el producto no esté asociado a otra marca
                $vsql6 = "SELECT COUNT(*) numproductorepetido FROM marcaxproducto WHERE productoid = ".$productoid;
                $numproductorepetido = $clase->SeleccionarUno($vsql6);

                if($numproductorepetido > 0)
                {
                    $vsql7 = "SELECT mp.nommarca marcaprod
                                FROM marcasproductos mp 
                                     INNER JOIN marcaxproducto mxp ON (mp.marcaid = mxp.marcaid)
                               WHERE mxp.productoid = ".$productoid;
                    $marcaprod = $clase->SeleccionarUno($vsql7);

                    $clase->Aviso(3,"El producto $descripcion ya pertenece a la marca $marcaprod");
                }
                else
                {
                    // Asigno el producto a la marca
                    $vsql = "INSERT INTO marcaxproducto (productoid, marcaid) VALUES (".$productoid.",".$marcaid.")";
                    $clase->EjecutarSQL($vsql);
    
                    // Emito el mensaje correspondiente
                    if(mysql_affected_rows() >= 1)
                        $clase->Aviso(1,"Producto $descripcion asociado a la marca $nommarca satisfactoriamente");
                    else
                        $clase->Aviso(3,"No se asoció el producto $descripcion a la marca $nommarca");
                }
            }
        }
        // Redirecciono el formulario
        header("Location: marcasproductos.php?opcion=ventanamxp&marcaid=$marcaid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmaprod
    // Creación: 22/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la eliminación de un producto
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmaprod")
    {
        $productoid = $_GET['productoid'];
        $marcaid = $_GET['marcaid'];
        
        $descripcion = $clase->BDLockup($productoid,'productos','productoid','descripcion');
        $nommarca = $clase->BDLockup($marcaid,'marcasproductos','marcaid','nommarca');
        
        // Pinto la ventana
        $cont= '<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><label class="Texto12"><b>Eliminar producto</b></label><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <label class="Texto12">
                   ¿Confirma que desea eliminar el producto <br> <b>'.$descripcion.'</b> <br> de la marca <br> <b>'.trim($nommarca).'</b>? 
                   </label>
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center"><br><br>
                   <form action="?opcion=elimarproducto&productoid='.$productoid.'&marcaid='.$marcaid.'" method="POST">
                   <input type="hidden" name="productoid" value="'.$productoid.'">
                   <input type="hidden" name="marcaid" value="'.$marcaid.'">
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="marcasproductos.php?opcion=ventanamxp&marcaid='.$marcaid.'"><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                   <br>
                  </td>
                 </tr>
                </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: elimarproducto
    // Creación: 22/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina físicamente un producto asociado a una marca
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "elimarproducto")
    {
        $productoid = $_POST['productoid'];
        $marcaid = $_POST['marcaid'];

        $descripcion = $clase->BDLockup($productoid,'productos','productoid','descripcion');
        $nommarca = $clase->BDLockup($marcaid,'marcasproductos','marcaid','nommarca');
        
        // Elimino la cesantía
        $vsql = "DELETE FROM marcaxproducto WHERE productoid = ".$productoid;
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Eliminado satisfactoriamente el producto $descripcion asociado a la marca $nommarca");
        else
            $clase->Aviso(3,"No se eliminó el producto $descripcion asociado a la marca $nommarca");

        // Redirecciono el formulario
        header("Location: marcasproductos.php?opcion=ventanamxp&marcaid=$marcaid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: marcaxls
    // Creación: 23/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite la salida a Excel de los productos asociados a una 
    //              marca
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "marcaxls")
    {
        $marcaid = $_GET['marcaid'];
        $nommarca = $clase->BDLockup($marcaid,'marcasproductos','marcaid','nommarca');

        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("marcas - DROPOS")
                                     ->setSubject("marcas - DROPOS")
                                     ->setDescription("marcas - DROPOS")
                                     ->setKeywords("marcas - DROPOS")
                                     ->setCategory("Categoria General");

        // encabezado
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'PRODUCTOS ASOCIADOS A LA MARCA '.$nommarca)
                    ->setCellValue('A3', 'CODIGO')
                    ->setCellValue('B3', 'PRODUCTO');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);

        // Consulta del informe
        $vsql = "SELECT p.codigo, p.descripcion, mxp.productoid
                   FROM productos p
                        INNER JOIN marcaxproducto mxp ON (p.productoid = mxp.productoid)
                  WHERE mxp.marcaid = ".$marcaid;

        // Detalle del informe
        $i = 4;
        $conex = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);
        while($row = mysql_fetch_array($result))
        {
            $codigo = $row['codigo'];
            if(substr($codigo,0,1) == "0")            $codigo="'".$codigo;

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $codigo)
                        ->setCellValue('B'.$i, $row['descripcion']);
            $i++;
        }

        $rangoEncabezado = 'A3:B3';
        $rangoCeldas     = 'A3:B'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('marcas');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // ----------------------------------------------------------------------------------- //
        // header('Content-Disposition: attachment;filename="planillanom.xls"');
        $nombrearcexcel = "productos asociados a la marca ".strtolower(trim($nommarca)).".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // ----------------------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarvaciado
    // Creación: 23/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar el vaciado de una marca
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarvaciado")
    {
        $marcaid = $_GET['marcaid'];
        $nommarca = $clase->BDLockup($marcaid,'marcasproductos','marcaid','nommarca');

        $vsql12 = "SELECT COUNT(*) numprodxmarca FROM marcaxproducto WHERE marcaid = ".$marcaid;
        $numprodxmarca = $clase->SeleccionarUno($vsql12);

        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><label class="Texto12"> <b>Vaciar marca</b></label><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <label class="Texto12">¿Confirma que desea eliminar '.$numprodxmarca.' productos de la marca <br> <b>'.trim($nommarca).'</b>? </label>
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center"><br>
                   <form action="?opcion=vaciarmarca&marcaid='.$marcaid.'" method="POST">
                   <input type="hidden" name="marcaid" value="'.$marcaid.'"> 
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="marcasproductos.php?opcion=ventanamxp&marcaid='.$marcaid.'"><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                   <br>
                  </td>
                 </tr>
                </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: vaciarmarca
    // Creación: 23/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina todos los productos asociados a una marca
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "vaciarmarca")
    {
        $marcaid = $_POST['marcaid'];
        $nommarca = $clase->BDLockup($marcaid,'marcasproductos','marcaid','nommarca');

        // Elimino la cesantía
        $vsql = "DELETE FROM marcaxproducto WHERE marcaid = ".$marcaid;
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Vaciada satisfactoriamente la marca $nommarca");
        else
            $clase->Aviso(3,"No se vació la marca $nommarca");

        // Redirecciono el formulario
        header("Location: marcasproductos.php?opcion=ventanamxp&marcaid=$marcaid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel1
    // Creación: 23/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar la hoja de Excel desde donde se 
    //              importarán los productos asociados a una marca
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel1")
    {
        $marcaid = $_GET['marcaid'];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder importar estos datos </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="marcasproductos.php?opcion=ventanamxp&marcaid='.$marcaid.'" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr" value="aceptar" class="button blue" />
                       </form> 
                      </td>
                     </tr>
                    </table>';
        else
        {
            // nombre de la marca
            $nommarca = $clase->BDLockup($marcaid,'marcasproductos','marcaid','nommarca');

            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                       $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });    
                      });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar productos <br> para la marca <br> <font color="BLUE">'.trim($nommarca).'</font></b> <br><br></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=importarexcel2&marcaid='.$marcaid.'" id="theform" enctype="multipart/form-data">
                       <input type="hidden" name="marcaid" value="'.$marcaid.'">
                       <input type="file" name="excel" /><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&oacute;digo del producto</td> </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplomarcas.png" width="260" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="BLUE"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel2
    // Creación: 23/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para importar los productos asociados a una marca    
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel2")
    {
		set_time_limit(0);
		extract($_POST);
		$marcaid = $_POST["marcaid"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;
        
        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: marcasproductos.php?opcion=ventanamxp&marcaid=$marcaid");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['codigo'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                
                    if(strlen($_DATOS_EXCEL[$i]['codigo']) == 0)
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores=0;
            $grabados = 0;

            $carpetaactual = 'reportes/';
            $nommarca = $clase->BDLockup($marcaid,'marcasproductos','marcaid','nommarca');

            // Construcción de la variable con los documentos no grabados
            $nocodigos = 'PRODUCTOS ASOCIADOS A LA MARCA'.Chr(13).Chr(10);
            $nocodigos.= ''.str_pad($nommarca,1,"").''.Chr(13).Chr(10);
            $nocodigos.= 'CODIGOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocodigos.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                $lbgrabo = false;
                $codigo = $_DATOS_EXCEL[$j]['codigo'];

                if($codigo != "")
                {
                    // Valido que el vendedor existe
                    $productoid = $clase->BDLockup($codigo,"productos","codigo","productoid");
                    
                    if($productoid != "")
                    {
                        // Valido que el producto no esté asociado a alguna marca
                        $vsql13 = "SELECT COUNT(*) repetido FROM marcaxproducto WHERE productoid = ".$productoid;
                        $repetido = $clase->SeleccionarUno($vsql13);
    
                        if($repetido == 0)
                        {
                            // Asigno el producto a la marca
                            $vsql = "INSERT INTO marcaxproducto (productoid, marcaid) VALUES (".$productoid.",".$marcaid.")";
                            $clase->EjecutarSQL($vsql);
    
                            if(mysql_affected_rows() >= 1)
                            {
                                $grabados++;
                                $lbgrabo = true;
                            }
                        }
                    }

                    // Almaceno en un archivo de texto las códigos que no fueron grabados en este proceso
                    if(!$lbgrabo)
                    {
                        $nocodigos.= str_pad($codigo,1,"").''.Chr(13).Chr(10);      // Actualizo la variable con el documento no almacenado
                        $archivo = "erroresmarca.txt";                              // nombre del archivo
                        $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                        fwrite($fd, $nocodigos);                                    // Grabas
                        fclose($fd);                                                // Cierras el archivo
                    }
                }
            }

            // --------------------------------------------------------------------------------------------------------------- //
            // Impresión de la fecha del último proceso ejecutado
            $mesimp = date('F');
            if($mesimp == "January")       $mesimp = "enero";
            if($mesimp == "February")      $mesimp = "febrero";
            if($mesimp == "March")         $mesimp = "marzo";
            if($mesimp == "April")         $mesimp = "abril";
            if($mesimp == "May")           $mesimp = "mayo";
            if($mesimp == "June")          $mesimp = "junio";
            if($mesimp == "July")          $mesimp = "julio";
            if($mesimp == "August")        $mesimp = "agosto";
            if($mesimp == "September")     $mesimp = "septiembre";
            if($mesimp == "October")       $mesimp = "octubre";
            if($mesimp == "November")      $mesimp = "noviembre";
            if($mesimp == "December")      $mesimp = "diciembre";

            $dayweek = date("l");
            if($dayweek == "Monday")       $dayweek = "lunes";
            if($dayweek == "Tuesday")      $dayweek = "martes";
            if($dayweek == "Wednesday")    $dayweek = "miércoles";
            if($dayweek == "Thursday")     $dayweek = "jueves";
            if($dayweek == "Friday")       $dayweek = "viernes";
            if($dayweek == "Saturday")     $dayweek = "sábado";
            if($dayweek == "Sunday")       $dayweek = "domingo";

            $fechoraimp = "proceso ejecutado el ".$dayweek." ".date('d')." de ".$mesimp." de ".date('Y')." a las ".date('g:i a');

            $nocodigos.= ''.Chr(13).Chr(10);
            $nocodigos.= str_pad($fechoraimp,1,"").''.Chr(13).Chr(10);      // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "erroresmarca.txt";                                  // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                 // se abre el archivo para escribir
            fwrite($fd, $nocodigos);                                        // Grabas
            fclose($fd);                                                    // Cierras el archivo
            // --------------------------------------------------------------------------------------------------------------- //
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron los productos");
            else
            {
                $nommarca = $clase->BDLockup($marcaid,'marcasproductos','marcaid','nommarca');
                $clase->Aviso(1,"Se cargaron $grabados productos a la marca $nommarca");
            }
    
            // Redirecciona el formulario
            header("Location: marcasproductos.php?opcion=ventanamxp&marcaid=$marcaid");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: infrotamarca
    // Creación: 05/05/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite en formato html del informe de rotación por marca
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "infrotamarca")
    {
        $marcaid = $_GET["marcaid"];
        $nommarca = $clase->BDLockup($marcaid,'marcasproductos','marcaid','nommarca');

        // Nombres de los 3 Ultimos periodos
        $codper1 = date("mY");
        $nomper1 = $clase->BDLockup($codper1,'periodos','codperiodo','desperiodo');
        $codper2 = date('mY',strtotime("-1 month"));
        $nomper2 = $clase->BDLockup($codper2,'periodos','codperiodo','desperiodo');
        $codper3 = date('mY',strtotime("-2 month"));
        $nomper3 = $clase->BDLockup($codper3,'periodos','codperiodo','desperiodo');
        $codper4 = date('mY',strtotime("-3 month"));
        $nomper4 = $clase->BDLockup($codper4,'periodos','codperiodo','desperiodo');
        $codper5 = date('mY',strtotime("-4 month"));
        $nomper5 = $clase->BDLockup($codper5,'periodos','codperiodo','desperiodo');
        $codper6 = date('mY',strtotime("-5 month"));
        $nomper6 = $clase->BDLockup($codper6,'periodos','codperiodo','desperiodo');

        $vsql = "SELECT S.codigo CodSuc , S.descripcion NomSuc , C.nombre NomCiudad , 
                        (SELECT COALESCE(SUM(EX.cantidad),0)  
                           FROM existencias EX 
                                INNER JOIN marcaxproducto MPX ON (EX.productoid = MPX.productoid)
                                INNER JOIN marcasproductos MX ON (MX.marcaid = MPX.marcaid)
                          WHERE MPX.marcaid = ".$marcaid." AND EX.bodegaid = B.bodegaid) existencia , 
                        (SELECT COALESCE(SUM(RX.salidas),0)  
                           FROM rotacionproducto RX 
                                INNER JOIN marcaxproducto MPX ON (RX.productoid = MPX.productoid)
                                INNER JOIN marcasproductos MX ON (MX.marcaid = MPX.marcaid)
                          WHERE MPX.marcaid = ".$marcaid." AND RX.bodegaid = B.bodegaid AND RX.codperiodo = '".$codper1."') rota01 , 
                        (SELECT COALESCE(SUM(RX.salidas),0)  
                           FROM rotacionproducto RX 
                                INNER JOIN marcaxproducto MPX ON (RX.productoid = MPX.productoid)
                                INNER JOIN marcasproductos MX ON (MX.marcaid = MPX.marcaid)
                          WHERE MPX.marcaid = ".$marcaid." AND RX.bodegaid = B.bodegaid AND RX.codperiodo = '".$codper2."') rota02 , 
                        (SELECT COALESCE(SUM(RX.salidas),0)  
                           FROM rotacionproducto RX 
                                INNER JOIN marcaxproducto MPX ON (RX.productoid = MPX.productoid)
                                INNER JOIN marcasproductos MX ON (MX.marcaid = MPX.marcaid)
                          WHERE MPX.marcaid = ".$marcaid." AND RX.bodegaid = B.bodegaid AND RX.codperiodo = '".$codper3."') rota03 , 
                        (SELECT COALESCE(SUM(RX.salidas),0)  
                           FROM rotacionproducto RX 
                                INNER JOIN marcaxproducto MPX ON (RX.productoid = MPX.productoid)
                                INNER JOIN marcasproductos MX ON (MX.marcaid = MPX.marcaid)
                          WHERE MPX.marcaid = ".$marcaid." AND RX.bodegaid = B.bodegaid AND RX.codperiodo = '".$codper4."') rota04 , 
                        (SELECT COALESCE(SUM(RX.salidas),0)  
                           FROM rotacionproducto RX 
                                INNER JOIN marcaxproducto MPX ON (RX.productoid = MPX.productoid)
                                INNER JOIN marcasproductos MX ON (MX.marcaid = MPX.marcaid)
                          WHERE MPX.marcaid = ".$marcaid." AND RX.bodegaid = B.bodegaid AND RX.codperiodo = '".$codper5."') rota05 , 
                        (SELECT COALESCE(SUM(RX.salidas),0)  
                           FROM rotacionproducto RX 
                                INNER JOIN marcaxproducto MPX ON (RX.productoid = MPX.productoid)
                                INNER JOIN marcasproductos MX ON (MX.marcaid = MPX.marcaid)
                          WHERE MPX.marcaid = ".$marcaid." AND RX.bodegaid = B.bodegaid AND RX.codperiodo = '".$codper6."') rota06
                   FROM bodegas B 
                        INNER JOIN sucursales S ON (S.sucursalid = B.sucursalid)
                        INNER JOIN ciudades C ON (C.ciudadid = S.ciudadid)
                  WHERE B.bodprincipal = 'CHECKED'
               ORDER BY B.orden ASC";

        $_SESSION['SQL_ROTAMARCAXLS'] = $vsql;

        // Pinto la ventana
        $cont = $clase->HeaderBlanco("Pedidos con Existencia Cero");
        $cont.='<script src="js/jquery.min.js"></script>
                <script src="lib/tableHeadFixer.js"></script>	
                <script>
                 /*$(document).on("keyup","#bscriterio",function(){
                  _this = this;
                  // Show only matching TR, hide rest of them
                  $.each($(".sortable tbody tr"), function() {
                  if ($(this).text().toLowerCase().indexOf($(_this).val().toLowerCase()) === -1)
                    $(this).hide();
                  else
                    $(this).show();
                  });                  
                 });*/
                 $(document).ready(function() {
                 $("#fixTableV").tableHeadFixer({"left" : 3}); 
                 });
                </script>
                <table width="1300">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/estadlineas.png" width="32" height="32" border="0"> </td>
                  <td width="1500"> <label class="Texto13"><strong> Rotación de la marca '.$nommarca.' </strong></label> <br> &uacute;ltimos seis periodos </td>
                  <td width="50" align="center"> 
                   <a href="?opcion=rotamarcaxls&marcaid='.$marcaid.'" target="_blank"> 
                    <img src="images/iconos/excel.png" border="0" title="salida del informe en una hoja de Excel" width="32"> 
                   </a>
                  </td>
                  <td width="20"> 
                   <a href="marcasproductos.php?opcion=ventanamxp&marcaid='.$marcaid.'"> 
                    <input type="button" value="<<" class="button"> 
                   </a> 
                  </td>re
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>
   				<script type="text/javascript" src="lib/sorttable.js"></script>
                <div id="parent">
                <table id="fixTableV" class="sortable">
                 <thead>
                  <tr class="">
                   <th width="180" class="ventasGeneral"> Sucursal </th>
                   <th width="420" class="ventasGeneral"> Ciudad </th>
                   <th width="150" class="ventasGeneral"> Existencia </th>
                   <th width="240" class="ventasGeneral"> Rotaci&oacute;n <br> '.$nomper1.' </th>
                   <th width="129" class="ventasGeneral"> Rotaci&oacute;n <br> '.$nomper2.' </th>
                   <th width="129" class="ventasGeneral"> Rotaci&oacute;n <br> '.$nomper3.' </th>
                   <th width="129" class="ventasGeneral"> Rotaci&oacute;n <br> '.$nomper4.' </th>
                   <th width="129" class="ventasGeneral"> Rotaci&oacute;n <br> '.$nomper5.' </th>
                   <th width="129" class="ventasGeneral"> Rotaci&oacute;n <br> '.$nomper6.' </th>
                  </tr>
                 </thead>
                 <tbody>';

        // impresión del detalle
        $i = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $cont.=' <td width="130" align="center"> '.$row['NomSuc'].' </td>
                     <td width="420" align="center"> '.$row['NomCiudad'].' </td>
                     <td width="240" align="center"> '.number_format($row['existencia']).' </td>
                     <td width="240" align="center"> '.number_format($row['rota01']).' </td>
                     <td width="129" align="center"> '.number_format($row['rota02']).' </td>
                     <td width="129" align="center"> '.number_format($row['rota03']).' </td>
                     <td width="129" align="center"> '.number_format($row['rota04']).' </td>
                     <td width="129" align="center"> '.number_format($row['rota05']).' </td>
                     <td width="129" align="center"> '.number_format($row['rota06']).' </td>
                    </tr>';
        }

        $cont.=' </tbody>
                </table>';
 
        echo $cont.$clase->PiePagina(); 
        exit;
 
        mysql_free_result($result);
        mysql_close($conex);
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: rotamarcaxls
    // Creación: 05/05/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite en una hoja de Excel el informe de rotación por marca
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "rotamarcaxls")
    {
        $marcaid = $_GET["marcaid"];
        $nommarca = $clase->BDLockup($marcaid,'marcasproductos','marcaid','nommarca');

        // Nombres de los 3 Ultimos periodos
        $codper1 = date("mY");
        $nomper1 = $clase->BDLockup($codper1,'periodos','codperiodo','desperiodo');
        $codper2 = date('mY',strtotime("-1 month"));
        $nomper2 = $clase->BDLockup($codper2,'periodos','codperiodo','desperiodo');
        $codper3 = date('mY',strtotime("-2 month"));
        $nomper3 = $clase->BDLockup($codper3,'periodos','codperiodo','desperiodo');
        $codper4 = date('mY',strtotime("-3 month"));
        $nomper4 = $clase->BDLockup($codper4,'periodos','codperiodo','desperiodo');
        $codper5 = date('mY',strtotime("-4 month"));
        $nomper5 = $clase->BDLockup($codper5,'periodos','codperiodo','desperiodo');
        $codper6 = date('mY',strtotime("-5 month"));
        $nomper6 = $clase->BDLockup($codper6,'periodos','codperiodo','desperiodo');

        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("existencias por marca - DROPOS")
                                     ->setSubject("existencias por marca - DROPOS")
                                     ->setDescription("existencias por marca - DROPOS")
                                     ->setKeywords("existencias por marca - DROPOS")
                                     ->setCategory("Categoria General");

        // encabezado
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'ROTACION DE LA MARCA '.strtoupper($nommarca))
                    ->setCellValue('A2', 'ULTIMOS SEIS PERIODOS')
                    ->setCellValue('A4', 'SUCURSAL')
                    ->setCellValue('B4', 'CIUDAD')
                    ->setCellValue('C4', 'EXISTENCIA')
                    ->setCellValue('D4', 'ROTACION '.strtoupper($nomper1))
                    ->setCellValue('E4', 'ROTACION '.strtoupper($nomper2))
                    ->setCellValue('F4', 'ROTACION '.strtoupper($nomper3))
                    ->setCellValue('G4', 'ROTACION '.strtoupper($nomper4))
                    ->setCellValue('H4', 'ROTACION '.strtoupper($nomper5))
                    ->setCellValue('I4', 'ROTACION '.strtoupper($nomper6));

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);

        $vsql = $_SESSION['SQL_ROTAMARCAXLS'];

        // Detalle del informe
        $i = 5;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['NomSuc'])
                        ->setCellValue('B'.$i, $row['NomCiudad'])
                        ->setCellValue('C'.$i, number_format($row['existencia']))
                        ->setCellValue('D'.$i, number_format($row['rota01']))
                        ->setCellValue('E'.$i, number_format($row['rota02']))
                        ->setCellValue('F'.$i, number_format($row['rota03']))
                        ->setCellValue('G'.$i, number_format($row['rota04']))
                        ->setCellValue('H'.$i, number_format($row['rota05']))
                        ->setCellValue('I'.$i, number_format($row['rota06']));
            $i++;            
        }        

        $rangoEncabezado = 'A4:I4';
        $rangoCeldas     = 'A4:I'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('autorizaciones por periodo');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // -------------------------------------------------------------------------------------- //
		// $filtroarchivo = str_replace(":", "", $filtroxls);
        $nombrearcexcel = "rotación de la marca ".strtolower($nommarca).".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // -------------------------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }    

    echo $cont.$clase->PiePagina();
?>