<?PHP
    @session_start();
    include("lib/Sistema.php");
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];
    $avisos = "";
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: reciboindividual
    // Creación: 05/11/2020		última modificación: 02/10/2025
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción que construye el PDF con el recibo de pago de un empleado
    // Última modificación: Modificación de la impresión del área y del pie de página en 
    //                      caso de ser empleado en condición de extralegal y alineación de 
    //                      los descuentos en caso de ser longitud 4 (28/11/2020)
    //                      Validación de la existencia del empleado en el periodo
    //                      (04/12/2020)
    //                      Inclusión del parámetro del ID del empleado y alineación del 
    //                      total a pagar en caso de ser un neto de siete cifras
    //                      (09/12/2020)
    //                      Sustitución del sueldo básico extraído de la tabla terceros por 
    //                      el almacenado en la tabla detallenomina (29/12/2020)
    //                      Se ordenó la consulta de los conceptos por devengados y 
    //                      deducciones por su código (19/02/2021)
    //                      En le recibo individual se añadieron las opciones para neto a 
    //                      pagar de cinco, cuatro y hasta tres cifras (10/07/2021)
    //                      Ajuste de las tablas para la impresión de la cédula y mensaje 
    //                      de validación (12/10/2022)
    //                      Eliminación de la lectura de la cédula y del combo del tipo 
    //                      de impresión (20/10/2022)
    //                      Recepción de los parámetros por GET en caso de no recibirlos en 
    //                      POST para la impresión del recibo desde el ajuste extemporáneo
    //                      (28/10/2022)
    //                      No aplicar el descuento a la incapacidad superior a 180 días
    //                      (11/01/2024)
    //                      Redireccionamiento del formulario a la selección del empleado
    //                      (26/02/2024)
    //                      Corrección del redirecionamiento del formulario al no conseguir
    //                      a un empleado en un periodo seleccionado
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "reciboindividual")
    {
        // Recibo los parámetros con los cuales filtraré el recibo
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];

        if(strlen($periodoid)==0)           $periodoid = $_GET['periodoid'];
        if(strlen($terid)==0)               $terid = $_GET['terid'];

        // Inicializo las variables
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $vsqldatos = "";                $codvende = "";             $nombreemp = "";                $documento = "";
        $cargo = "";                    $basico = 0;                $seccion = "";                  $fecingreso = "";
        $area = "";                     $banco = "";                $lineatotales = 0;              $epsid = 0;
        $eps = "";                      $nomconcepto = "";          $pensiones = "";                $longitud = 0;
        $fechoraimp = "";               $mesimp = "";               $extralegal = "";               $tipoimpresion = "recibo";

        // Variable para determinar si el periodo está abierto o cerrado
        $cerrado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','cerrado');

        if($cerrado=="CHECKED")
        {
            $tabla = "periodoterceros";
            $tabla2 = "hisdetallenomina";

        }
        else
        {
            $tabla = "tercerosactual";       
            $tabla2 = "detallenomina";
        }

        // Valido la existencia del empleado en el periodo
        // $vsqldatos = "SELECT COUNT(*) AS teridper FROM ".$tabla2." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        $vsqldatos = "SELECT COUNT(*) AS teridper FROM ".$tabla2." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        $teridper = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($teridper==0)
        {
            if($tabla == "periodoterceros")
                $vsql = "SELECT nombre FROM periodoterceros WHERE terid = ".$terid;

            if($tabla == "tercerosactual")
                $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
         
            $nombreemp = $clase->SeleccionarUno($vsql);
            $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

            if($nombreemp!="")
                $clase->Aviso(3,"$nombreemp no laboró en el periodo $descripcion");
            else
                $clase->Aviso(3,"el empleado de cédula $dni no laboró en el periodo $descripcion");
            
            header("Location: periodosnomina.php?opcion=pedircedula&periodoid=$periodoid");
        }
        else
        {
            if($cerrado=="CHECKED")
            {
                // El código del empleado
                $vsqldatos = "SELECT codvende FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
                $codvende = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                // El nombre del empleado
                $vsqldatos = "SELECT nombre AS nombreemp FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
                $nombreemp = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                // Documento
                $vsqldatos = "SELECT dni FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
                $dni = $clase->SeleccionarUno($vsqldatos);
                $documento = $dni;                
             
                // El cargo
                $vsqldatos = "SELECT c.descripcioncargo AS cargo 
                                FROM ".$tabla." p
                                     INNER JOIN cargos c ON (p.cargoid = c.cargoid) 
                               WHERE p.terid = ".$terid."
                                     AND p.pernominaid = ".$periodoid."";
                $cargo = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                // Sueldo básico
                $vsqldatos = "SELECT basico FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
                $basico = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                // La sección
                $vsqldatos = "SELECT s.descripcionsec 
                                FROM ".$tabla." p
                                     INNER JOIN seccion s ON (p.seccionid = s.seccionid) 
                               WHERE p.terid = ".$terid."
                                     AND p.pernominaid = ".$periodoid."";
                $seccion = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                // Fecha de ingreso
                $vsqldatos = "SELECT fecingreso FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
                $fecingreso = $clase->SeleccionarUno($vsqldatos);
                $fecingreso = substr($fecingreso,8,2)."/".substr($fecingreso,5,2)."/".substr($fecingreso,0,4);
                $vsqldatos = "";

                $vsqldatos = "SELECT extralegal FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
                $extralegal = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                $vsqldatos = "SELECT numcuenta FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
                $numcuenta = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                if($extralegal=="CHECKED")
                    $area = "EXTRALEGALES";
                else
                {
                    // El área
                    $vsqldatos = "SELECT a.descripcionarea 
                                    FROM ".$tabla." p
                                         INNER JOIN areanomina a ON (p.areaid = a.areaid) 
                                   WHERE p.terid = ".$terid."
                                         AND p.pernominaid = ".$periodoid."";
                    $area = $clase->SeleccionarUno($vsqldatos);
                    $vsqldatos = "";
                }

                // El banco
                $vsqldatos = "SELECT b.descripcion 
                                FROM ".$tabla." p
                                     INNER JOIN bancos b ON (p.bancoid = b.bancoid) 
                               WHERE p.terid = ".$terid."
                                     AND p.pernominaid = ".$periodoid."";
                $banco = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                // Número de cuenta bancaria
                $vsqldatos = "SELECT numcuenta FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
                $numcuenta = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                // EPS a la cual pertenece el empleado
                $vsqldatos = "SELECT e.descripcioneps 
                                FROM ".$tabla." p
                                     INNER JOIN eps e ON (p.epsid = e.epsid) 
                               WHERE p.terid = ".$terid."
                                     AND p.pernominaid = ".$periodoid."";
                $eps = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                // Fondo de pensiones al cual pertenece el empleado
                $vsqldatos = "SELECT p.descripcionafp 
                                FROM ".$tabla." t
                                     INNER JOIN pensiones p ON (t.pensionesid = p.pensionesid) 
                               WHERE t.terid = ".$terid."
                                     AND t.pernominaid = ".$periodoid."";
                $pensiones = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";
            }
            else
            {
                // El código del empleado
                $vsqldatos = "SELECT codvende FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
                $codvende = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";
        
                // El nombre del empleado
                $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
                $nombreemp = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";
                
                // Documento
                $vsqldatos = "SELECT dni FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
                $dni = $clase->SeleccionarUno($vsqldatos);                
                $documento = $dni;
        
                // El cargo
                $vsqldatos = "SELECT c.descripcioncargo 
                                FROM ".$tabla." t
                                     INNER JOIN cargos c ON (t.cargoid = c.cargoid) 
                               WHERE t.terid = ".$terid."
                                     AND pernominaid = ".$periodoid."";
                $cargo = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";
        
                // Sueldo básico
                $basico = $clase->BDLockup($terid,$tabla,'terid','basico');
        
                // La sección
                $vsqldatos = "SELECT s.descripcionsec 
                                FROM ".$tabla." t
                                     INNER JOIN seccion s ON (t.seccionid = s.seccionid) 
                               WHERE t.terid = ".$terid."
                                     AND pernominaid = ".$periodoid."";
                $seccion = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";
        
                // Fecha de ingreso
                $vsqldatos = "SELECT fecingreso FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
                $fecingreso = $clase->SeleccionarUno($vsqldatos);
                $fecingreso = substr($fecingreso,8,2)."/".substr($fecingreso,5,2)."/".substr($fecingreso,0,4);
                $vsqldatos = "";
        
                // Determino si el empleado es de condición extralegal
                $extralegal = $clase->BDLockup($terid,$tabla,'terid','extralegal');
                $numcuenta = $clase->BDLockup($terid,$tabla,'terid','numcuenta');
        
                if($extralegal=="CHECKED")
                    $area = "EXTRALEGALES";
                else
                {
                    // El área
                    $vsqldatos = "SELECT a.descripcionarea 
                                    FROM ".$tabla." t
                                         INNER JOIN areanomina a ON (t.areaid = a.areaid) 
                                   WHERE t.terid = ".$terid." AND pernominaid = ".$periodoid."";
                    $area = $clase->SeleccionarUno($vsqldatos);
                    $vsqldatos = "";
                }
        
                // El banco
                $vsqldatos = "SELECT b.descripcion 
                                FROM ".$tabla." t
                                     INNER JOIN bancos b ON (t.bancoid = b.bancoid) 
                               WHERE t.terid = ".$terid." AND pernominaid = ".$periodoid."";
                $banco = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";
        
                // Número de cuenta bancaria
                $vsqldatos = "SELECT numcuenta FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
                $numcuenta = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";
        
                // EPS a la cual pertenece el empleado
                $vsqldatos = "SELECT e.descripcioneps 
                                FROM ".$tabla." t
                                     INNER JOIN eps e ON (t.epsid = e.epsid) 
                               WHERE t.terid = ".$terid." AND pernominaid = ".$periodoid."";
                $eps = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";
        
                // Fondo de pensiones al cual pertenece el empleado
                $vsqldatos = "SELECT p.descripcionafp 
                                FROM ".$tabla." t
                                     INNER JOIN pensiones p ON (t.pensionesid = p.pensionesid) 
                               WHERE t.terid = ".$terid." AND pernominaid = ".$periodoid."";
                $pensiones = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";
            }

            // ---------------------------------------------------------------------------------------------------------------------- //
            // Opción para imprimir el recibo de pago sencillo
            if($tipoimpresion=="recibo")
            {
                // Procedo a construir el encabezado del recibo
                $clase = new Sistema();
                ini_set("memory_limit","200M");
                require('lib/fpdf/fpdf.php');
                $pdf=new FPDF('L','mm','A6');       // Recibo a media página
            
                // Página nueva
                $pdf->AddPage("");
                $pagina = 1;
        
                // Encabezado del recibo
                
                // Traducción al español del mes que devuelve la función date()
                $mesimp = date('F');
                if($mesimp=="January")       $mesimp = "Enero";
                if($mesimp=="February")      $mesimp = "Febrero";
                if($mesimp=="March")         $mesimp = "Marzo";
                if($mesimp=="April")         $mesimp = "Abril";
                if($mesimp=="May")           $mesimp = "Mayo";
                if($mesimp=="June")          $mesimp = "Junio";
                if($mesimp=="July")          $mesimp = "Julio";
                if($mesimp=="August")        $mesimp = "Agosto";
                if($mesimp=="September")     $mesimp = "Septiembre";
                if($mesimp=="October")       $mesimp = "Octubre";
                if($mesimp=="November")      $mesimp = "Noviembre";
                if($mesimp=="December")      $mesimp = "Diciembre";

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
                $pdf->SetFont('Arial','',8);
                $pdf->Text(147,14,$fechoraimp);
        
                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');
        
                $x = 35;
                $y = 15;
                $pdf->SetFont('Arial','B',10);
                $enc= "COMPROBANTE DE PAGO";
                $pdf->Text($x,$y,$enc);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y+7,$enc);
                $enc= "NOMINA: ";
                $pdf->Text($x,$y+14,$enc);
        
                $pdf->SetFont('Arial','',10);
                $enc=strtoupper($descripcion);
                $pdf->Text($x+18,$y+14,$enc);
        
                $x = 10;
                $y = 40;
                $pdf->SetFont('Arial','B',10);
        
                // Datos del empleado
                $enc= "CODIGO: ";
                $pdf->Text($x,$y,$enc);
        
                $pdf->SetFont('Arial','',10);
                $enc=$codvende;
                $pdf->Text($x+28,$y,$enc);
        
                $pdf->SetFont('Arial','B',10);
                $enc= "NOMBRE: ";
                $pdf->Text($x+60,$y,$enc);
        
                $pdf->SetFont('Arial','',10);
                $enc=strtoupper($nombreemp);
                $pdf->Text($x+80,$y,$enc);
        
                $pdf->SetFont('Arial','B',10);
                $enc= "DOCUMENTO: ";
                $pdf->Text($x,$y+7,$enc);
        
                $pdf->SetFont('Arial','',10);
                $enc=$documento;
                $pdf->Text($x+28,$y+7,$enc);
        
                $pdf->SetFont('Arial','B',10);
                $enc= "CARGO: ";
                $pdf->Text($x+60,$y+7,$enc);
        
                $pdf->SetFont('Arial','',10);
                $enc=strtoupper($cargo);
                $pdf->Text($x+80,$y+7,$enc);
        
                $pdf->SetFont('Arial','B',10);
                $enc= "BASICO: ";
                $pdf->Text($x,$y+14,$enc);
        
                $pdf->SetFont('Arial','',10);
                $enc=number_format($basico,2);
                $pdf->Text($x+28,$y+14,$enc);
        /*
                $pdf->SetFont('Arial','B',10);
                $enc= "SECCION: ";
                $pdf->Text($x+60,$y+14,$enc);
        
                $pdf->SetFont('Arial','',10);
                $enc=strtoupper($seccion);
                $pdf->Text($x+80,$y+14,$enc);
        */
                // $pdf->SetFont('Arial','B',10);
                // $enc= "FEC INGRESO: ";
                // $pdf->Text($x,$y+21,$enc);
        
                // $pdf->SetFont('Arial','',10);
                // $enc=$fecingreso;
                // $pdf->Text($x+28,$y+21,$enc);
        
                $pdf->SetFont('Arial','B',10);
                $enc= "AREA: ";
                $pdf->Text($x+60,$y+14,$enc);
        
                $pdf->SetFont('Arial','',10);
                $enc=strtoupper($area);
                $pdf->Text($x+80,$y+14,$enc);
        
                // Títulos del detalle
                $x = 10;
                $y = 68;
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(7,63,195,8,'F');
                $pdf->SetFont('Arial','B',9);
                $pdf->Text($x,$y,"CODIGO");
                $pdf->Text($x+20,$y,"CONCEPTO");
                $pdf->Text($x+75,$y,"CANTIDAD");
                $pdf->Text($x+105,$y,"DEVENGADOS");
                $pdf->Text($x+135,$y,"DESCUENTOS");
                $pdf->Text($x+170,$y,"SALDO/BASE");

                // $vsql = "SELECT c.codconcepto, c.nomconcepto, d.valor, d.devengados, d.descuentos, 
                //                 d.saldo, d.conceptoid
                //            FROM detallenomina d
                //                 INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                //           WHERE d.pernominaid = ".$periodoid." 
                //                 AND d.terid=".$terid."
                //        ORDER BY c.tipodc, c.codconcepto";

                $vsql = "SELECT c.codconcepto, c.nomconcepto, IF(d.conceptoid NOT IN (53,54),SUM(d.valor),COUNT(*)) valor, SUM(d.devengados) devengados, SUM(d.descuentos) descuentos, d.saldo, d.conceptoid 
                           FROM detallenomina d 
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                          WHERE d.pernominaid = ".$periodoid." 
                                AND d.terid = ".$terid." 
                       GROUP BY d.conceptoid 
                       ORDER BY c.tipodc, c.codconcepto";
        
                $conex  = $clase->Conectar();
                $result = mysql_query($vsql,$conex);
                $i = 0;
                $x = 10;
                $y = 76;
                $totdevengado = 0;
                $totdescuento = 0;
                $totpagar = 0;
                while($row = mysql_fetch_array($result))
                {
                    // Imprimo los conceptos con sus respectivos montos
                    $pdf->SetFont('Arial','',8);
                    $pdf->Text($x,$y,$row['codconcepto']);
        
                    if(($row['conceptoid']==4)||($row['conceptoid']==5))
                    {
                        if($row['conceptoid']==4)
                            $nomconcepto = $pensiones;
        
                        if($row['conceptoid']==5)
                            $nomconcepto = $eps;
        
                        if($nomconcepto=="")
                            $nomconcepto = "NO ESPECIFICA";
                    
                        $pdf->Text($x+20,$y,$nomconcepto);
                    }
                    else
                    {
                        $nomconcepto = substr($row['nomconcepto'],0,33);
                        $pdf->Text($x+20,$y,$nomconcepto);
                    }
        
                    // Impresión de los días
                    if($row['valor']>0)
                    {
                        // Alineación de los montos correspondientes
                        $longitud = strlen($row['valor']);
        
                        if($longitud==1)
                            $pdf->Text($x+81,$y,number_format($row['valor'],2));
        
                        if($longitud==2)
                            $pdf->Text($x+80,$y,number_format($row['valor'],2));

                        // $pdf->SetXY($x+78,$y-1.5);
                        // $pdf->MultiCell(10,1,number_format($row['valor'],2),0,'C');
                    }
        
                    // Impresión de los devengados
                    if($row['devengados']>0)
                    {
                        // Alineación de los montos correspondientes
                        $longitud = strlen($row['devengados']);

                        if($longitud==4)
                            $pdf->Text($x+120,$y,number_format($row['devengados'],0));

                        if($longitud==5)
                            $pdf->Text($x+118,$y,number_format($row['devengados'],0));
        
                        if($longitud==6)
                            $pdf->Text($x+117,$y,number_format($row['devengados'],0));
        
                        if($longitud==7)
                            $pdf->Text($x+115,$y,number_format($row['devengados'],0));
                    }
                    
                    // Impresión de los descuentos
                    if(($row['descuentos']>0)&&(($row['conceptoid']!=6)&&($row['conceptoid']!=9)&&($row['conceptoid']!=43)&&($row['conceptoid']!=58)))                    
                    {
                        // Alineación de los montos correspondientes
                        $longitud = strlen($row['descuentos']);

                        if($longitud==1)
                            $pdf->Text($x+155,$y,number_format($row['descuentos'],0));

                        if($longitud==2)
                            $pdf->Text($x+151,$y,number_format($row['descuentos'],0));

                        if($longitud==3)
                            $pdf->Text($x+150,$y,number_format($row['descuentos'],0));                        

                        if($longitud==4)
                            $pdf->Text($x+149,$y,number_format($row['descuentos'],0));
        
                        if($longitud==5)
                            $pdf->Text($x+148,$y,number_format($row['descuentos'],0));
        
                        if($longitud==6)
                            $pdf->Text($x+146,$y,number_format($row['descuentos'],0));
                    }
        
                    // Impresión del saldo/base
                    if($row['saldo']>0)
                    {
                        // Alineación de los montos correspondientes
                        $longitud = strlen($row['saldo']);
        
                        if($longitud==7)
                            $pdf->Text($x+178,$y,number_format($row['saldo'],0));
        
                        if($longitud==6)
                            $pdf->Text($x+180,$y,number_format($row['saldo'],0));
                    }
        
                    // Incremento los totales
                    $totdevengado += $row['devengados'];
        
                    if(($row['conceptoid']!=6)&&($row['conceptoid']!=9)&&($row['conceptoid']!=43)&&($row['conceptoid']!=58))
                        $totdescuento += $row['descuentos'];
        
                    $i++;
                    $y+=6;
                }
        
                // Imprimo los totales
                $lineatotales = $y;
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(7,$lineatotales,195,8,'F');
        
                $pdf->SetFont('Arial','B',10);
                $pie= "TOTALES: ";
                $pdf->Text($x+70,$y+5,$pie);
        
                $pdf->SetFont('Arial','',8);
        
                // Alineación de los montos correspondientes
                $longitud = strlen($totdevengado);
        
                if($longitud==5)
                    $pdf->Text($x+113,$y+5,number_format($totdevengado));
        
                if($longitud==6)
                    $pdf->Text($x+117,$y+5,number_format($totdevengado));
        
                if($longitud==7)
                    $pdf->Text($x+114,$y+5,number_format($totdevengado));
        
                // Alineación de los montos correspondientes
                $longitud = strlen($totdescuento);
        
                if($longitud==6)
                    $pdf->Text($x+146,$y+5,number_format($totdescuento));                

                if($longitud==5)
                    $pdf->Text($x+148,$y+5,number_format($totdescuento));
        
                if($longitud==4)
                    $pdf->Text($x+149,$y+5,number_format($totdescuento));
        
                $totpagar = $totdevengado - $totdescuento;
        
                $pdf->SetFillColor(180,180,180);
                $pdf->Rect(7,$lineatotales+8,195,8,'F');
        
                $pdf->SetFont('Arial','B',10);
                $pie= "NETO A PAGAR: ";
                $pdf->Text($x+70,$y+13,$pie);

                $longitud = strlen($totpagar);

                if($longitud==3)
                    $pdf->Text($x+153,$y+13,number_format($totpagar));

                if($longitud==4)
                    $pdf->Text($x+150,$y+13,number_format($totpagar));

                if($longitud==5)
                    $pdf->Text($x+147,$y+13,number_format($totpagar));

                if($longitud==6)
                    $pdf->Text($x+144,$y+13,number_format($totpagar));

                if($longitud==7)
                    $pdf->Text($x+141,$y+13,number_format($totpagar));

                // Impresión del banco y cuenta a la cual se le consigna
                $pdf->SetFont('Arial','',8);
                $pie= "                                                                                                                                                                     __________________________";
                $pdf->Text($x,$y+35,$pie);
                $pie= "                                                                                                                                                                     RECIBI CONFORME";
                $pdf->Text($x,$y+40,$pie);

                if($extralegal=="CHECKED")
                    $pie= "CONSIGNADO EN: EFECTIVO                                                                                                                  C.C.";
                else
                {
                    if(($numcuenta=="")||($numcuenta==NULL))
                        $pie= "CONSIGNADO EN: EFECTIVO                                                                                                                  C.C.";
                    else
                        $pie= "CONSIGNADO EN: ".strtoupper($banco)."                      CUENTA NO. ".$numcuenta."                            C.C.";            
                }
                
                $pdf->Text($x,$y+45,$pie);
                $pdf->Output();                
            }

            // ---------------------------------------------------------------------------------------------------------------------- //
            // Opción para la impresión del formato de nómina electrónica
            if($tipoimpresion=="nomelect")
            {
                $direccion = $clase->BDLockup($terid,'terceros','terid','direccion');
                $tipodoc = $clase->BDLockup($terid,'terceros','terid','tipodoc');
                $telfijo = $clase->BDLockup($terid,'terceros','terid','telfijo');
                $telmovil = $clase->BDLockup($terid,'terceros','terid','telmovil');
                $vsqldatos = "";

                // Ciudad a la cual pertenece el empleado
                $vsqldatos = "SELECT c.nombre  
                                FROM terceros t
                                     INNER JOIN ciudades c ON (t.ciudadid = c.ciudadid) 
                               WHERE t.terid = ".$terid;
                $ciudad = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                // Departamento al cual pertenece el empleado
                $vsqldatos = "SELECT c.departamento  
                                FROM terceros t
                                     INNER JOIN ciudades c ON (t.ciudadid = c.ciudadid) 
                               WHERE t.terid = ".$terid;
                $departamento = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                // Días trabajados
                $vsqldatos = "SELECT valor
                                FROM detallenomina 
                               WHERE pernominaid = ".$periodoid." 
                                     AND terid=".$terid;
                $diastrabajados = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                // Neto a pagar
                $vsqldatos = "SELECT (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D',d.descuentos,0))) AS neto
                                FROM detallenomina d
                                     INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                               WHERE pernominaid = ".$periodoid."
                                     AND terid=".$terid;
                $netoapagar = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                // --------------------------------------------------------------------------------------------------------------------- //

                // Procedo a construir el encabezado del recibo
                $clase = new Sistema();
                ini_set("memory_limit","200M");
                require('lib/fpdf/fpdf.php');
                $pdf=new FPDF();

                // Página nueva
                $pdf->AddPage("");
                $pagina = 1;

                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(10,10,115,8,'F');
                $pdf->Rect(127,10,78,8,'F');

                // Encabezado del formato
                $pdf->SetFont('Arial','B',8);
                $enc= "Empleador";
                $pdf->Text(12,15,$enc);

                $enc= "Desprendible de nomina No.";
                $pdf->Text(128,15,$enc);

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,23,12,15,'PNG','');

                $pdf->SetFont('Arial','B',8);
                $enc= "DROMEDICAS DEL ORIENTE SAS";
                $pdf->Text(25,23,$enc);

                $enc= "NIT:          900265730-0";
                $pdf->Text(25,28,$enc);

                $enc= "Regimen: Responsable del impuesto sobre las ventas - IVA";
                $pdf->Text(25,33,$enc);

                $enc= "Direccion: Avenida 7A # 0BN38 barrio Sevilla, Norte de Santander";
                $pdf->Text(25,38,$enc);

                $enc= "Telefono:  (7) 5780956";
                $pdf->Text(25,43,$enc);

                $enc= "Autorizacion NE:";
                $pdf->Text(128,23,$enc);

                $pdf->SetFont('Arial','',7);
                $enc= "No 18764003852015 valida desde 2020-09-05";
                $pdf->Text(152,21,$enc);

                $enc= "hasta 2021-09-05 rango desde NT1 hasta NT500";
                $pdf->Text(152,24,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Fecha de emision:";
                $pdf->Text(128,28,$enc);

                $enc= "Forma de pago:";
                $pdf->Text(128,33,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= "Contado";
                $pdf->Text(151,33,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Medio de pago:";
                $pdf->Text(163,33,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= "Transferencia";
                $pdf->Text(185,33,$enc);
                
                $pdf->SetFont('Arial','B',8);
                $enc= "Banco: ";
                $pdf->Text(128,38,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= substr($banco,6,20);
                $pdf->Text(139,38,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "No. cuenta: ";
                $pdf->Text(162,38,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= $numcuenta;
                $pdf->Text(178,38,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Tipo de nomina: ";
                $pdf->Text(128,43,$enc);
                
                $pdf->SetFont('Arial','',8);
                $enc= "Nomina individual";
                $pdf->Text(151,43,$enc);

                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(10,48,195,8,'F');                

                // Datos del empleado
                $pdf->SetFont('Arial','B',8);
                $enc= "Datos del empleado";
                $pdf->Text(12,53,$enc);

                $enc= "Nombre:";
                $pdf->Text(40,61,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= $nombreemp;
                $pdf->Text(52,61,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Tipo documento:";
                $pdf->Text(120,61,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= $tipodoc;
                $pdf->Text(144,61,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "No. de identificacion:";
                $pdf->Text(152,61,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= $documento;
                $pdf->Text(182,61,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Direccion:";
                $pdf->Text(40,66,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= substr($direccion,0,39);
                $pdf->Text(55,66,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "EPS:";
                $pdf->Text(120,66,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= substr($eps,0,39);
                $pdf->Text(128,66,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "AFP:";
                $pdf->Text(162,66,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= substr($pensiones,0,39);
                $pdf->Text(170,66,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Tel fijo:";
                $pdf->Text(40,71,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= $telfijo;
                $pdf->Text(51,71,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Celular:";
                $pdf->Text(72,71,$enc);
                
                $pdf->SetFont('Arial','',8);
                $enc= $telmovil;
                $pdf->Text(85,71,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Tipo de trabajo:";
                $pdf->Text(120,71,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= "Dependiente";
                $pdf->Text(143,71,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Subtipo de Tr:";
                $pdf->Text(162,71,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= "N.A.";
                $pdf->Text(183,71,$enc);                

                $pdf->SetFont('Arial','B',8);
                $enc= "Ciudad:";
                $pdf->Text(40,76,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= $ciudad;
                $pdf->Text(51,76,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Departamento:";
                $pdf->Text(68,76,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= $departamento;
                $pdf->Text(89,76,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Pais:";
                $pdf->Text(120,76,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= "Colombia";
                $pdf->Text(128,76,$enc);                

                $pdf->SetFont('Arial','B',8);
                $enc= "Salario integral:";
                $pdf->Text(145,76,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= "No";
                $pdf->Text(168,76,$enc);

                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(10,80,195,8,'F');

                // Detalle recibo de nomina
                $pdf->SetFont('Arial','B',8);
                $enc= "Detalle recibo de nomina";
                $pdf->Text(12,85,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Fecha de pago:";
                $pdf->Text(10,93,$enc);

                // $pdf->SetFont('Arial','',8);
                // $enc= "01/02/2021";
                // $pdf->Text(32,93,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "De la fecha:";
                $pdf->Text(47,93,$enc);

                // $pdf->SetFont('Arial','',8);
                // $enc= "01/02/2021";
                // $pdf->Text(64,93,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Dias trabajados:";
                $pdf->Text(79,93,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= $diastrabajados;
                $pdf->Text(102,93,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Cod. de empleado:";
                $pdf->Text(108,93,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= $codvende;
                $pdf->Text(135,93,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Tipo de jornada:";
                $pdf->Text(143,93,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Cargo:";
                $pdf->Text(10,98,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= strtoupper($cargo);
                $pdf->Text(20,98,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Dependencia:";
                $pdf->Text(65,98,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= strtoupper($seccion);
                $pdf->Text(85,98,$enc);
                
                $pdf->SetFont('Arial','B',8);
                $enc= "Sucursal:";
                $pdf->Text(118,98,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= "N.A.";
                $pdf->Text(132,98,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Salario base:";
                $pdf->Text(139,98,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= number_format($basico,2);
                $pdf->Text(158,98,$enc);

                $pdf->SetFont('Arial','B',8);
                $enc= "Tipo de riesgo:";
                $pdf->Text(177,98,$enc);

                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(10,102,195,8,'F');

                $pdf->SetFont('Arial','B',8);
                $enc= "Cantidad";
                $pdf->Text(12,107,$enc);
                $enc= "Unidad";
                $pdf->Text(32,107,$enc);
                $enc= "Descripcion";
                $pdf->Text(50,107,$enc);
                $enc= "Precio unitario";
                $pdf->Text(140,107,$enc);
                $enc= "Importe";
                $pdf->Text(190,107,$enc);

                $pdf->SetFont('Arial','',8);
                $enc= "1";
                $pdf->Text(17,115,$enc);
                $enc= $descripcion;
                $pdf->Text(50,115,$enc);
                $enc= number_format($netoapagar,2);
                $pdf->Text(145,115,$enc);
                $enc= number_format($netoapagar,2);
                $pdf->Text(185,115,$enc);
                
                $pdf->SetFillColor(180,180,180);
                $pdf->Rect(10,119,96,8,'F');
                $pdf->Rect(109,119,96,8,'F');

                // Devengado y Descuentos
                $pdf->SetFont('Arial','B',8);
                $enc= "Devengado";
                $pdf->Text(50,124,$enc);
                $enc= "Descuentos";
                $pdf->Text(150,124,$enc);

                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(10,127,96,8,'F');
                $pdf->Rect(109,127,96,8,'F');

                $enc= "Concepto";
                $pdf->Text(12,132,$enc);
                $enc= "Tipo";
                $pdf->Text(65,132,$enc);
                $enc= "Importe";
                $pdf->Text(94,132,$enc);

                $enc= "Concepto";
                $pdf->Text(110,132,$enc);
                $enc= "Tipo";
                $pdf->Text(150,132,$enc);
                $enc= "Importe";
                $pdf->Text(192,132,$enc);

                // Otros pagos
                $pdf->SetFillColor(180,180,180);
                $pdf->Rect(10,150,96,8,'F');
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(10,158,96,8,'F');
                $enc= "Otros pagos";
                $pdf->Text(50,155,$enc);
                $enc= "Concepto";
                $pdf->Text(12,163,$enc);
                $enc= "Cantidad";
                $pdf->Text(60,163,$enc);
                $enc= "Importe";
                $pdf->Text(94,163,$enc);

                // Inicialización de variables
                $lb_tiene_sueldo=false;
                $lb_tiene_transporte=false;
                $lb_tiene_salud=false;
                $lb_tiene_pension=false;
                $lb_devengado_adicional=false;
                $lb_descuento_adicional=false;
                $total_devengado=0;
                $total_otrospagos=0;
                $total_deducciones=0;
                $netoacobrar=0;
                $importeenletras ="";
                $subtotal=0;
                
                // Impresión del detalle del formato
                $vsql = "SELECT c.codconcepto, c.nomconcepto, d.valor, d.devengados, d.descuentos, 
                                d.saldo, d.conceptoid, c.tipodc 
                           FROM detallenomina d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                          WHERE d.pernominaid = ".$periodoid." 
                                AND d.terid=".$terid;

                $conex  = $clase->Conectar();
                $result = mysql_query($vsql,$conex);
                while($row = mysql_fetch_array($result))
                {
                    $pdf->SetFont('Arial','',7);
                    $nomconcepto = $row['nomconcepto'];
                    $conceptoid = $row['conceptoid'];

                    // Impresión de cada concepto
                    switch($conceptoid)
                    {
                        case 1:
                            // Impresión del sueldo devengado en el periodo
                            $lb_tiene_sueldo=true;
                            $pdf->Text(12,140,$nomconcepto);

                            // Alineación de los montos correspondientes
                            $longitud = strlen($row['devengados']);

                            if($longitud==5)
                                $pdf->Text(97,140,number_format($row['devengados'],0));

                            if($longitud==6)
                                $pdf->Text(95,140,number_format($row['devengados'],0));

                            if($longitud==7)
                                $pdf->Text(93,140,number_format($row['devengados'],0));

                            $total_devengado += $row['devengados'];

                            break;
                        case 3:
                            // Impresión del subsidio de transporte
                            $lb_tiene_transporte=true;
                            $pdf->Text(12,171,$nomconcepto);
                            $pdf->Text(65,171,"1");

                            // Alineación de los montos correspondientes
                            $longitud = strlen($row['devengados']);

                            if($longitud==5)
                                $pdf->Text(97,171,number_format($row['devengados'],0));

                            if($longitud==6)
                                $pdf->Text(95,171,number_format($row['devengados'],0));

                            $total_otrospagos += $row['devengados'];

                            break;
                        case 4:
                            // Impresión de lo descontado por pensión
                            $lb_tiene_pension=true;
                            $pdf->Text(110,140,$nomconcepto);

                            // Alineación de los montos correspondientes
                            $longitud = strlen($row['descuentos']);

                            if($longitud==5)
                                $pdf->Text(195,140,number_format($row['descuentos'],0));

                            if($longitud==6)
                                $pdf->Text(193,140,number_format($row['descuentos'],0));

                            $total_deducciones += $row['descuentos'];

                            break;
                        case 5:
                            // Impresión de lo descontado por salud
                            $lb_tiene_salud=true;
                            $pdf->Text(110,145,$nomconcepto);

                            // Alineación de los montos correspondientes
                            $longitud = strlen($row['descuentos']);

                            if($longitud==5)
                                $pdf->Text(195,145,number_format($row['descuentos'],0));

                            if($longitud==6)
                                $pdf->Text(193,145,number_format($row['descuentos'],0));
                            
                            $total_deducciones += $row['descuentos'];

                            break;
                        default:                            
                            // Impresión de los devengados adicionales
                            if($row['tipodc']=="C")
                            {
                                if(!$lb_devengado_adicional)
                                {
                                    if($lb_tiene_transporte)
                                        $yc=171;
                                    else
                                        $yc=166;
                                }

                                $pdf->Text(12,$yc+5,$nomconcepto);
                                $pdf->Text(65,$yc+5,$row['valor']);

                                // Alineación de los montos correspondientes
                                $longitud = strlen($row['devengados']);

                                if($longitud==5)
                                    $pdf->Text(97,$yc+5,number_format($row['devengados'],0));

                                if($longitud==6)
                                    $pdf->Text(95,$yc+5,number_format($row['devengados'],0));

                                $lb_devengado_adicional=true;

                                $total_otrospagos += $row['devengados'];
                            }

                            // Impresión de los descuentos adicionales
                            if($row['tipodc']=="D")
                            {
                                if(!$lb_tiene_pension)
                                {
                                    $det="PENSION";
                                    $pdf->Text(110,140,$det);

                                    $det="0.00";
                                    $pdf->Text(195,140,number_format($row['descuentos'],0));
                                }

                                if(!$lb_tiene_salud)
                                {
                                    $det="SALUD";
                                    $pdf->Text(110,145,$det);
                                    
                                    $det="0.00";
                                    $pdf->Text(195,145,number_format($row['descuentos'],0));
                                }

                                $yd=145;
                                $pdf->Text(110,$yd+5,$nomconcepto);

                                // Alineación de los montos correspondientes
                                $longitud = strlen($row['descuentos']);

                                if($longitud==5)
                                    $pdf->Text(196,$yd+5,number_format($row['descuentos'],0));
    
                                if($longitud==6)
                                    $pdf->Text(194,$yd+5,number_format($row['descuentos'],0));
                                
                                $total_deducciones += $row['descuentos'];
                            }

                            break;
                    }
                }

                // Impresión de los totales
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(109,158,96,8,'F');
                $pdf->SetFont('Arial','B',8);
                $pie= "Total devengado";
                $pdf->Text(112,163,$pie);
                $pie= "Total otros pagos";
                $pdf->Text(145,163,$pie);
                $pie= "Total deducciones";
                $pdf->Text(178,163,$pie);
                
                $pdf->SetFont('Arial','',7);
                $pdf->Text(125,171,number_format($total_devengado,0));
                $pdf->Text(160,171,number_format($total_otrospagos,0));
                $pdf->Text(194,171,number_format($total_deducciones,0));

                $netoacobrar=($total_devengado+$total_otrospagos)-$total_deducciones;
                $importeenletras = numtoletras($netoacobrar);

                // Impresión del importe en letras
                $pdf->SetFillColor(180,180,180);
                $pdf->Rect(10,190,96,8,'F');
                $pdf->SetFont('Arial','B',8);
                $pie= "Importe en letras";
                $pdf->Text(12,195,$pie);
                $pdf->SetFillColor(180,180,180);
                $pdf->SetFont('Arial','',7);
                $pdf->Text(12,203,$importeenletras);

                // Totales
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(109,175,96,8,'F');                

                $pdf->SetFont('Arial','B',8);
                $pie= "Subtotal";
                $pdf->Text(112,180,$pie);
                $pie= "Deducciones";
                $pdf->Text(152,180,$pie);
                $pie= "Total";
                $pdf->Text(196,180,$pie);

                $subtotal=$total_devengado+$total_otrospagos;
                $pdf->SetFont('Arial','',7);
                $pdf->Text(125,187,number_format($subtotal,0));
                $pdf->Text(160,187,number_format($total_deducciones,0));
                $pdf->Text(194,187,number_format($netoacobrar,0));

                // ------------------------------------------------------------------------------------- //
                // Muestro el Codigo QR
                // if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR")
                // {
                //     require "../lib/phpqrcode/qrlib.php";
                //     $dir = 'temp/';
                //     if (!file_exists($dir))
                //         mkdir($dir);
                //     $filename = $dir.'qrcode.png';
                //     $tamaño = 5; //Tamaño de Pixel
                //     $level = 'L'; //Precisión Baja
                //     $framSize = 3; //Tamaño en blanco
                //     $contenido = "http://www.farmanorte.com.co"; //Texto
                //     QRcode::png($contenido, $filename, $level, $tamaño, $framSize);
                //     $pdf->Image($dir.basename($filename),127,6,20,20,'PNG','');
                // }
                // ------------------------------------------------------------------------------------- //

                $pdf->Output();                
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanadatos
    // Creación: 01/12/2020		última modificación: 26/08/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para la captación de datos del informe  
    //              general de recibos de un periodo
    // Última modificación: Inclusión de combo de periodos (10/01/2023)
    //                      Corrección del combo de periodos incluyendo los periodos 
    //                      cerrados o calculados
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanadatos")
    {
        $params = ' class="Texto11" ';

        // Consulta para el combo de periodos
        // $vsqlcomboperiodo  = "SELECT codigo, CONCAT(codigo,' - ',descripcion) 
        //                         FROM periodosnomina 
        //                        WHERE cerrado = 'CHECKED' OR 
        //                              periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')
        //                     ORDER BY periodoid ASC";

        $vsqlcomboperiodo  = "SELECT codigo, CONCAT(codigo,' - ',descripcion) 
                                FROM periodosnomina 
                               WHERE cerrado = 'CHECKED' OR 
                                     calculado = 'CHECKED'
                            ORDER BY periodoid ASC";
    
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/infventaspos.png" width="32" height="32" border="0"> </td> 
                  <td width="840"> <b> Informe general de recibos por periodo </b> </td>
                  <td> &nbsp; </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';
        
        $cont.='<form action="recibodepago.php?opcion=recibogeneral" method="POST" name="x" target="_blank">                 
                <center>
                <table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="220"> &nbsp; </td>
                  <td width="20"> Periodo: </td>
                  <td width="120"> '.$clase->CrearComboBuscar("codigo",$vsqlcomboperiodo,"descripcion","codigo","","N",$params,400).' </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="220"> &nbsp; </td>
                  <td width="20"> Tipo: </td>
                  <td width="120"> 
                   <select name="tiponomina" id="tiponomina" style="width:120px;height:25px">
                    <option value="todos" selected> Todos </option>               
                    <option value="empleados"> Empleados </option>               
                    <option value="extralegal"> Extralegal </option>
                   </select> 
                  </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<table width="100%">
                 <tr class="BarraDocumentos"> 
                  <td width="260"> &nbsp; </td> 
                  <td width="100" alling="center">
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                </table>';
        echo $cont.$clase->PiePagina();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: recibogeneral
    // Creación: 01/12/2020		última modificación: 10/01/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que construye el PDF con todos los recibos de pago de un periodo
    // Última modificación: Se adaptó para imprimir dos recibos por página (03/12/2020)
    //                      Sustitución del sueldo básico extraído de la tabla terceros por 
    //                      el almacenado en la tabla detallenomina (29/12/2020)
    //                      Se incorporó el campo de empleado activo en la nómina 
    //                      (11/08/2021)
    //                      Se incluyó en la consulta el filtro del salario básico además de 
    //                      la validación de tener registros en el periodo (13/09/2021)
    //                      Adaptación de las consultas para filtrar por periodos e 
    //                      impresión para que se ajusten dos recibos por página.
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "recibogeneral")
    {
        // Recibo los parámetros con los cuales filtraré el recibo
        $codigo = $_POST['codigo'];
        $tiponomina = $_POST['tiponomina'];

        // Variable del periodo
        $periodoid = $clase->BDLockup($codigo,'periodosnomina','codigo','periodoid');
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $cerrado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','cerrado');

        if($cerrado=="CHECKED")
        {
            $tabla = "periodoterceros";
            $tabladet = "hisdetallenomina";
            $nomnreemp = "t.nombre AS nombreemp ";
        }
        else
        {
            $tabladet = "detallenomina";
            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado=="CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";

            $nomnreemp = "CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp ";
        }

        // Inicializo las variables
        $vsqldatos = "";                    $terid = 0;                 $codvende = "";                 $nombreemp = "";                    $documento = "";
        $cargo = "";                        $basico = 0;                $seccion = "";                  $fecingreso = "";                   $area = "";
        $banco = "";                        $lineatotales = 0;          $epsid = 0;                     $eps = "";                          $nomconcepto = "";
        $pensiones = "";                    $longitud = 0;              $fechoraimp = "";               $mesimp = "";                       $extralegal = "";
        $consulta = "";                     $pagina = 0;

        // Traducción al español del mes que devuelve la función date()
        $mesimp = date('F');
        if($mesimp=="January")       $mesimp = "Enero";
        if($mesimp=="February")      $mesimp = "Febrero";
        if($mesimp=="March")         $mesimp = "Marzo";
        if($mesimp=="April")         $mesimp = "Abril";
        if($mesimp=="May")           $mesimp = "Mayo";
        if($mesimp=="June")          $mesimp = "Junio";
        if($mesimp=="July")          $mesimp = "Julio";
        if($mesimp=="August")        $mesimp = "Agosto";
        if($mesimp=="September")     $mesimp = "Septiembre";
        if($mesimp=="October")       $mesimp = "Octubre";
        if($mesimp=="November")      $mesimp = "Noviembre";
        if($mesimp=="December")      $mesimp = "Diciembre";

        $clase = new Sistema();
        ini_set("memory_limit","200M");
        require('lib/fpdf/fpdf.php');
        $pdf=new FPDF();

        // Consulta para los empleados
        $consulta = "SELECT t.terid, t.codvende, t.dni, ".$nomnreemp.",  
                            t.basico, t.fecingreso, c.descripcioncargo, s.descripcionsec, t.extralegal, b.descripcion, t.numcuenta, e.descripcioneps, 
                            p.descripcionafp, a.descripcionarea
                       FROM ".$tabla." t
                            INNER JOIN cargos c ON (t.cargoid = c.cargoid) 
                            INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                            INNER JOIN bancos b ON (t.bancoid = b.bancoid)
                            INNER JOIN eps e ON (t.epsid = e.epsid) 
                            INNER JOIN pensiones p ON (t.pensionesid = p.pensionesid)  
                            INNER JOIN areanomina a ON (t.areaid = a.areaid) ";

        // Aquí filtro la consulta por tipo de nómina
        if($tiponomina=="todos")
            $consulta.= " WHERE t.esempleadoactivo='CHECKED'";

        if($tiponomina=="empleados")
            $consulta.= " WHERE t.esempleadoactivo='CHECKED' AND (t.extralegal ='' OR t.extralegal IS NULL)";

        if($tiponomina=="extralegal")
            $consulta.= " WHERE t.extralegal='CHECKED'";

        // Filtro del salario básico y el periodo
        $consulta.= " AND t.pernominaid = ".$periodoid." AND t.basico > 0 ";

        $vsql = $consulta;

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $i = 0;
        while($row = mysql_fetch_array($result))
        {
            // Obtengo las variables para el encabezado del recibo            
            $terid = $row['terid'];                 // El id del empleado

            // Validación que tenga registros en el periodo actual
            $vsql5 = "SELECT COUNT(*) AS numreg
                        FROM ".$tabladet."
                       WHERE pernominaid = ".$periodoid."
                             AND terid = ".$terid."";
            $numreg = $clase->SeleccionarUno($vsql5);

            if($numreg>0)
            {
                $codvende = $row['codvende'];           // El código del empleado
                $nombreemp = $row['nombreemp'];         // El nombre del empleado
                $documento = $row['dni'];               // Documento
                $cargo = $row['descripcioncargo'];      // El cargo
                
                $vsqldatos = "SELECT saldo FROM ".$tabladet." WHERE terid = ".$terid." AND conceptoid = 1 AND pernominaid = ".$periodoid."";
                $basico = $clase->SeleccionarUno($vsqldatos);               // Sueldo básico
                $seccion = $row['descripcionsec'];                          // La sección
    
                $fecingreso = $row['fecingreso'];                           // Fecha de ingreso
                $fecingreso = substr($fecingreso,8,2)."/".substr($fecingreso,5,2)."/".substr($fecingreso,0,4);
    
                // Determino si el empleado es de condición extralegal
                $extralegal = $row['extralegal'];
    
                if($extralegal=="CHECKED")
                    $area = "EXTRALEGALES";
                else
                    $area = $row['descripcionarea'];
    
                $banco = $row['descripcion'];                   // El banco
                $numcuenta = $row['numcuenta'];                 // Número de cuenta bancaria
                $eps = $row['descripcioneps'];                  // EPS a la cual pertenece el empleado
                $pensiones = $row['descripcionafp'];            // Fondo de pensiones al cual pertenece el empleado
    
                // Procedo a construir el encabezado del recibo
            
                // Página nueva
                $i++;
                $lbpar = false;
                $lbimpar = false;
    
                if($i%2 == 0)
                    $lbpar = true;
                else
                {
                    $pdf->AddPage("");
                    $lbimpar = true;
                    $pagina++;
                }
    
                // Encabezado del recibo    
                $x = 35;
                if($lbpar)
                    $y = 15;
                else
                    $y = 153;
    
                // Logo Dromedicas
                if($lbpar)      $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');
                else            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,150,20,25,'PNG','');
    
                $pdf->SetFont('Arial','B',10);
                $enc= "COMPROBANTE DE PAGO";                                                $pdf->Text($x,$y,$enc);
    
                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
    
                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+112,$y,$fechoraimp);
    
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";                      $pdf->Text($x,$y+7,$enc);
                $enc= "NOMINA: ";                                                           $pdf->Text(35,$y+14,$enc);
    
                $pdf->SetFont('Arial','',10);
                $enc=strtoupper($descripcion);                                              $pdf->Text($x+18,$y+14,$enc);
    
                $x = 10;
                if($lbpar)
                    $y = 40;
                else
                    $y = 180;
                
                // Datos del empleado
                $pdf->SetFont('Arial','B',10);
                $enc= "CODIGO: ";                                                           $pdf->Text($x,$y,$enc);
                $pdf->SetFont('Arial','',10);
                $enc=$codvende;                                                             $pdf->Text($x+28,$y,$enc);
                $pdf->SetFont('Arial','B',10);
                $enc= "NOMBRE: ";                                                           $pdf->Text($x+60,$y,$enc);
                $pdf->SetFont('Arial','',10);
                $enc=strtoupper($nombreemp);                                                $pdf->Text($x+80,$y,$enc);
                $pdf->SetFont('Arial','B',10);
                $enc= "DOCUMENTO: ";                                                        $pdf->Text($x,$y+7,$enc);
                $pdf->SetFont('Arial','',10);
                $enc=$documento;                                                            $pdf->Text($x+28,$y+7,$enc);
                $pdf->SetFont('Arial','B',10);
                $enc= "CARGO: ";                                                            $pdf->Text($x+60,$y+7,$enc);
                $pdf->SetFont('Arial','',10);
                $enc=strtoupper($cargo);                                                    $pdf->Text($x+80,$y+7,$enc);
                $pdf->SetFont('Arial','B',10);
                $enc= "BASICO: ";                                                           $pdf->Text($x,$y+14,$enc);
                $pdf->SetFont('Arial','',10);
                $enc=number_format($basico,2);                                              $pdf->Text($x+28,$y+14,$enc);
                // $pdf->SetFont('Arial','B',10);
                // $enc= "SECCION: ";                                                          $pdf->Text($x+60,$y+14,$enc);
                // $pdf->SetFont('Arial','',10);
                // $enc=strtoupper($seccion);                                                  $pdf->Text($x+80,$y+14,$enc);
                // $pdf->SetFont('Arial','B',10);
                // $enc= "FEC INGRESO: ";                                                      $pdf->Text($x,$y+21,$enc);
                // $pdf->SetFont('Arial','',10);
                // $enc=$fecingreso;                                                           $pdf->Text($x+28,$y+21,$enc);
                $pdf->SetFont('Arial','B',10);
                $enc= "AREA: ";                                                             $pdf->Text($x+60,$y+14,$enc);
                $pdf->SetFont('Arial','',10);
                $enc=strtoupper($area);                                                     $pdf->Text($x+80,$y+14,$enc);
    
                // Títulos del detalle
                $x = 10;
                if($lbpar)
                    $y = 68;
                else
                    $y = 210;
    
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect($x-3,$y-5,195,8,'F');
    
                $pdf->SetFont('Arial','B',9);
                $pdf->Text($x,$y,"CODIGO");                     $pdf->Text($x+20,$y,"CONCEPTO");                    $pdf->Text($x+75,$y,"CANTIDAD");
                $pdf->Text($x+105,$y,"DEVENGADOS");             $pdf->Text($x+135,$y,"DESCUENTOS");                 $pdf->Text($x+170,$y,"SALDO/BASE");
    
                // Impresión del detalle del recibo
                // $vsql2 = "SELECT c.codconcepto, c.nomconcepto, d.valor, d.devengados, d.descuentos, 
                //                  d.saldo, t.terid, d.conceptoid 
                //             FROM ".$tabladet." d
                //                  INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                //                  INNER JOIN ".$tabla." t ON (d.terid = t.terid AND d.pernominaid = t.pernominaid) 
                //            WHERE d.pernominaid = ".$periodoid."
                //                  AND t.terid = ".$terid."
                //         ORDER BY c.codconcepto";

                $vsql2 = "SELECT c.codconcepto, c.nomconcepto, IF(d.conceptoid NOT IN (53,54),SUM(d.valor),COUNT(*)) valor, SUM(d.devengados) devengados, SUM(d.descuentos) descuentos, d.saldo, d.conceptoid                                  
                            FROM ".$tabladet." d
                                 INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                                 INNER JOIN ".$tabla." t ON (d.terid = t.terid AND d.pernominaid = t.pernominaid) 
                           WHERE d.pernominaid = ".$periodoid."
                                 AND t.terid = ".$terid."
                        GROUP BY d.conceptoid         
                        ORDER BY c.tipodc, c.codconcepto";

                $conex  = $clase->Conectar();
                $result2 = mysql_query($vsql2,$conex);
                $cant   = mysql_num_rows($result2);
    
                $x = 10;
                if($lbpar)
                    $y = 76;
                else
                    $y = 218;
                
                $totdevengado = 0;
                $totdescuento = 0;
                $totpagar = 0;
                while($row2 = mysql_fetch_array($result2))
                {
                    // Imprimo los conceptos con sus respectivos montos
                    $pdf->SetFont('Arial','',8);
                    $pdf->Text($x,$y,$row2['codconcepto']);
    
                    if(($row2['conceptoid']==4)||($row2['conceptoid']==5))
                    {
                        if($row2['conceptoid']==4)          $nomconcepto = $pensiones;
                        if($row2['conceptoid']==5)          $nomconcepto = $eps;
                        if($nomconcepto=="")                $nomconcepto = "NO ESPECIFICA";
                        $pdf->Text($x+20,$y,$nomconcepto);
                    }
                    else
                    {
                        $nomconcepto = $row2['nomconcepto'];
                        $pdf->Text($x+20,$y,$nomconcepto);
                    }
    
                    // Impresión de los días
                    if($row2['valor']>0)
                    {
                        // Alineación de los montos correspondientes
                        $longitud = strlen($row2['valor']);
                        if($longitud==1)                    $pdf->Text($x+81,$y,number_format($row2['valor'],2));
                        if($longitud==2)                    $pdf->Text($x+80,$y,number_format($row2['valor'],2));
                    }
    
                    // Impresión de los devengados
                    if($row2['devengados']>0)
                    {
                        // Alineación de los montos correspondientes
                        $longitud = strlen($row2['devengados']);
                        if($longitud==5)                    $pdf->Text($x+118,$y,number_format($row2['devengados'],0));
                        if($longitud==6)                    $pdf->Text($x+117,$y,number_format($row2['devengados'],0));
                        if($longitud==7)                    $pdf->Text($x+115,$y,number_format($row2['devengados'],0));
                    }
                    
                    // Impresión de los descuentos
                    if(($row2['descuentos']>0)&&(($row2['conceptoid']!=6)&&($row2['conceptoid']!=9)&&($row2['conceptoid']!=43)&&($row2['conceptoid']!=58)))
                    {
                        // Alineación de los montos correspondientes
                        $longitud = strlen($row2['descuentos']);
                        if($longitud==4)                    $pdf->Text($x+149,$y,number_format($row2['descuentos'],0));
                        if($longitud==5)                    $pdf->Text($x+148,$y,number_format($row2['descuentos'],0));
                        if($longitud==6)                    $pdf->Text($x+146,$y,number_format($row2['descuentos'],0));
                    }
    
                    // Impresión del saldo/base
                    if($row2['saldo']>0)
                    {
                        // Alineación de los montos correspondientes
                        $longitud = strlen($row2['saldo']);
                        if($longitud==7)                    $pdf->Text($x+178,$y,number_format($row2['saldo'],0));
                        if($longitud==6)                    $pdf->Text($x+180,$y,number_format($row2['saldo'],0));
                    }
    
                    // Incremento los totales
                    $totdevengado += $row2['devengados'];
    
                    if(($row2['conceptoid']!=6)&&($row2['conceptoid']!=9)&&($row2['conceptoid']!=43)&&($row2['conceptoid']!=58))
                        $totdescuento += $row2['descuentos'];
                    
                    $y+=6;
                }
    
                // Imprimo los totales
                $lineatotales = $y;
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect($x-3,$y-3,195,8,'F');
    
                $pdf->SetFont('Arial','B',10);
                $pie= "TOTALES: ";                          $pdf->Text($x+70,$y+2,$pie);
    
                $pdf->SetFont('Arial','',8);
    
                // Alineación de los montos correspondientes
                $longitud = strlen($totdevengado);
                if($longitud==5)                        $pdf->Text($x+113,$y+2,number_format($totdevengado));
                if($longitud==6)                        $pdf->Text($x+117,$y+2,number_format($totdevengado));
                if($longitud==7)                        $pdf->Text($x+114,$y+2,number_format($totdevengado));
    
                // Alineación de los montos correspondientes
                $longitud = strlen($totdescuento);    
                if($longitud==5)                        $pdf->Text($x+148,$y+2,number_format($totdescuento));    
                if($longitud==6)                        $pdf->Text($x+146,$y+2,number_format($totdescuento));
    
                $totpagar = $totdevengado - $totdescuento;
    
                $pdf->SetFillColor(180,180,180);
                $pdf->Rect($x-3,$y+5,195,8,'F');
    
                $pdf->SetFont('Arial','B',10);
                $pie= "NETO A PAGAR: ";
                $pdf->Text($x+70,$y+10,$pie);
    
                $longitud = strlen($totpagar);
                if($longitud==6)                        $pdf->Text($x+144,$y+10,number_format($totpagar));    
                if($longitud==7)                        $pdf->Text($x+141,$y+10,number_format($totpagar));
    
                // Impresión del banco y cuenta a la cual se le consigna
                $pdf->SetFont('Arial','',8);
                $pie= "                                                                                                                                                                     __________________________";
                $pdf->Text($x,$y+26,$pie);
                $pie= "                                                                                                                                                                     RECIBI CONFORME";
                $pdf->Text($x,$y+31,$pie);
    
                if($extralegal=="CHECKED")
                    $pie= "CONSIGNADO EN: EFECTIVO                                                                                                                  C.C.";
                else
                {
                    if(($numcuenta=="")||($numcuenta==NULL))
                        $pie= "CONSIGNADO EN: EFECTIVO                                                                                                                  C.C.";
                    else
                        $pie= "CONSIGNADO EN: ".strtoupper($banco)."                      CUENTA NO. ".$numcuenta."                            C.C.";
                }
                
                $pdf->Text($x,$y+36,$pie);
            }
        }
        $pdf->Output();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: negativo
    // Creación: 28/08/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para imprimir el recibo de pago de un empleado con saldo negativo    
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "negativo")
    {
        $periodoid = $_GET['periodoid'];
        $dni = $_GET['dni'];

        // Inicializo las variables
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $vsqldatos = "";                        $terid = 0;                         $codvende = "";
        $nombreemp = "";                        $documento = "";                    $cargo = "";
        $basico = 0;                            $seccion = "";                      $fecingreso = "";
        $area = "";                             $banco = "";                        $lineatotales = 0;
        $epsid = 0;                             $eps = "";                          $nomconcepto = "";
        $pensiones = "";                        $longitud = 0;                      $fechoraimp = "";
        $mesimp = "";                           $extralegal = "";

        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');
        if($calculado=="CHECKED")
            $tabla = "tercerosactual";
        else
            $tabla = "terceros";
        
        // Obtengo las variables para el encabezado del recibo
        // $vsqldatos = "SELECT terid FROM tercerosactual WHERE dni = '".$dni."' AND pernominaid = ".$periodoid."";

        $vsqldatos = "SELECT terid FROM ".$tabla." WHERE dni = '".$dni."'";        

        $terid = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Valido la existencia del empleado en el periodo
        $vsqldatos = "SELECT COUNT(*) AS teridper FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        $teridper = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($teridper==0)
        {
            $clase->Aviso(3,"Este empleado no laboró en este periodo");
            header("Location: periodosnomina.php");
        }
        else
        {
            // El código del empleado
            $vsqldatos = "SELECT codvende FROM ".$tabla." WHERE terid = ".$terid;
            $codvende = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
    
            // El nombre del empleado
            $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM ".$tabla." WHERE terid = ".$terid;
            $nombreemp = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
            
            // Documento
            $documento = $dni;
    
            // El cargo
            $vsqldatos = "SELECT c.descripcioncargo 
                            FROM ".$tabla." t
                                    INNER JOIN cargos c ON (t.cargoid = c.cargoid) 
                            WHERE t.terid = ".$terid;
            $cargo = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // $basico = $clase->BDLockup($terid,'tercerosactual','terid','basico');
            $basico = $clase->BDLockup($terid,$tabla,'terid','basico');
    
            // La sección
            $vsqldatos = "SELECT s.descripcionsec 
                            FROM ".$tabla." t
                                    INNER JOIN seccion s ON (t.seccionid = s.seccionid) 
                            WHERE t.terid = ".$terid;
            $seccion = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
    
            // Fecha de ingreso
            $vsqldatos = "SELECT fecingreso FROM ".$tabla." WHERE terid = ".$terid;
            $fecingreso = $clase->SeleccionarUno($vsqldatos);
            $fecingreso = substr($fecingreso,8,2)."/".substr($fecingreso,5,2)."/".substr($fecingreso,0,4);
            $vsqldatos = "";
    
            // Determino si el empleado es de condición extralegal
            $extralegal = $clase->BDLockup($terid,$tabla,'terid','extralegal');
            $numcuenta = $clase->BDLockup($terid,$tabla,'terid','numcuenta');
    
            if($extralegal=="CHECKED")
                $area = "EXTRALEGALES";
            else
            {
                // El área
                $vsqldatos = "SELECT a.descripcionarea 
                                FROM ".$tabla." t
                                        INNER JOIN areanomina a ON (t.areaid = a.areaid) 
                                WHERE t.terid = ".$terid;
                $area = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";
            }
    
            // El banco
            $vsqldatos = "SELECT b.descripcion 
                            FROM ".$tabla." t
                                    INNER JOIN bancos b ON (t.bancoid = b.bancoid) 
                            WHERE t.terid = ".$terid;
            $banco = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
    
            // Número de cuenta bancaria
            $vsqldatos = "SELECT numcuenta FROM ".$tabla." WHERE terid = ".$terid;
            $numcuenta = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
    
            // EPS a la cual pertenece el empleado
            $vsqldatos = "SELECT e.descripcioneps 
                            FROM ".$tabla." t
                                    INNER JOIN eps e ON (t.epsid = e.epsid) 
                            WHERE t.terid = ".$terid;
            $eps = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
    
            // Fondo de pensiones al cual pertenece el empleado
            $vsqldatos = "SELECT p.descripcionafp 
                            FROM ".$tabla." t
                                    INNER JOIN pensiones p ON (t.pensionesid = p.pensionesid) 
                            WHERE t.terid = ".$terid;
            $pensiones = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // Procedo a construir el encabezado del recibo
            $clase = new Sistema();
            ini_set("memory_limit","200M");
            require('lib/fpdf/fpdf.php');
            $pdf=new FPDF('L','mm','A6');       // Recibo a media página
        
            // Página nueva
            $pdf->AddPage("");
            $pagina = 1;
    
            // Encabezado del recibo
            
            // Traducción al español del mes que devuelve la función date()
            $mesimp = date('F');
            if($mesimp=="January")       $mesimp = "Enero";
            if($mesimp=="February")      $mesimp = "Febrero";
            if($mesimp=="March")         $mesimp = "Marzo";
            if($mesimp=="April")         $mesimp = "Abril";
            if($mesimp=="May")           $mesimp = "Mayo";
            if($mesimp=="June")          $mesimp = "Junio";
            if($mesimp=="July")          $mesimp = "Julio";
            if($mesimp=="August")        $mesimp = "Agosto";
            if($mesimp=="September")     $mesimp = "Septiembre";
            if($mesimp=="October")       $mesimp = "Octubre";
            if($mesimp=="November")      $mesimp = "Noviembre";
            if($mesimp=="December")      $mesimp = "Diciembre";

            // Fecha y hora de impresión
            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
            $pdf->SetFont('Arial','',8);
            $pdf->Text(147,14,$fechoraimp);
    
            // Logo Dromedicas
            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');
    
            $x = 35;
            $y = 15;
            $pdf->SetFont('Arial','B',10);
            $enc= "COMPROBANTE DE PAGO";
            $pdf->Text($x,$y,$enc);
            $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
            $pdf->Text($x,$y+7,$enc);
            $enc= "NOMINA: ";
            $pdf->Text($x,$y+14,$enc);
    
            $pdf->SetFont('Arial','',10);
            $enc=strtoupper($descripcion);
            $pdf->Text($x+18,$y+14,$enc);
    
            $x = 10;
            $y = 40;
            $pdf->SetFont('Arial','B',10);
    
            // Datos del empleado
            $enc= "CODIGO: ";
            $pdf->Text($x,$y,$enc);
    
            $pdf->SetFont('Arial','',10);
            $enc=$codvende;
            $pdf->Text($x+28,$y,$enc);
    
            $pdf->SetFont('Arial','B',10);
            $enc= "NOMBRE: ";
            $pdf->Text($x+60,$y,$enc);
    
            $pdf->SetFont('Arial','',10);
            $enc=strtoupper($nombreemp);
            $pdf->Text($x+80,$y,$enc);
    
            $pdf->SetFont('Arial','B',10);
            $enc= "DOCUMENTO: ";
            $pdf->Text($x,$y+7,$enc);
    
            $pdf->SetFont('Arial','',10);
            $enc=$documento;
            $pdf->Text($x+28,$y+7,$enc);
    
            $pdf->SetFont('Arial','B',10);
            $enc= "CARGO: ";
            $pdf->Text($x+60,$y+7,$enc);
    
            $pdf->SetFont('Arial','',10);
            $enc=strtoupper($cargo);
            $pdf->Text($x+80,$y+7,$enc);
    
            $pdf->SetFont('Arial','B',10);
            $enc= "BASICO: ";
            $pdf->Text($x,$y+14,$enc);
    
            $pdf->SetFont('Arial','',10);
            $enc=number_format($basico,2);
            $pdf->Text($x+28,$y+14,$enc);
    
            // $pdf->SetFont('Arial','B',10);
            // $enc= "SECCION: ";
            // $pdf->Text($x+60,$y+14,$enc);
    
            // $pdf->SetFont('Arial','',10);
            // $enc=strtoupper($seccion);
            // $pdf->Text($x+80,$y+14,$enc);
    
            // $pdf->SetFont('Arial','B',10);
            // $enc= "FEC INGRESO: ";
            // $pdf->Text($x,$y+21,$enc);
    
            // $pdf->SetFont('Arial','',10);
            // $enc=$fecingreso;
            // $pdf->Text($x+28,$y+21,$enc);
    
            $pdf->SetFont('Arial','B',10);
            $enc= "AREA: ";
            $pdf->Text($x+60,$y+14,$enc);
    
            $pdf->SetFont('Arial','',10);
            $enc=strtoupper($area);
            $pdf->Text($x+80,$y+14,$enc);
    
            // Títulos del detalle
            $x = 10;
            $y = 68;
            $pdf->SetFillColor(220,220,220);
            $pdf->Rect(7,63,195,8,'F');
            $pdf->SetFont('Arial','B',9);
            $pdf->Text($x,$y,"CODIGO");
            $pdf->Text($x+20,$y,"CONCEPTO");
            $pdf->Text($x+75,$y,"CANTIDAD");
            $pdf->Text($x+105,$y,"DEVENGADOS");
            $pdf->Text($x+135,$y,"DESCUENTOS");
            $pdf->Text($x+170,$y,"SALDO/BASE");

            // $vsql = "SELECT c.codconcepto, c.nomconcepto, d.valor, d.devengados, d.descuentos, 
            //                 d.saldo, d.conceptoid
            //            FROM detallenomina d
            //                 INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
            //           WHERE d.pernominaid = ".$periodoid." 
            //                 AND d.terid = ".$terid." 
            //        ORDER BY c.tipodc, c.codconcepto";

            $vsql = "SELECT c.codconcepto, c.nomconcepto, IF(d.conceptoid NOT IN (53,54),SUM(d.valor),COUNT(*)) valor, SUM(d.devengados) devengados, SUM(d.descuentos) descuentos, d.saldo, d.conceptoid 
                       FROM detallenomina d 
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                      WHERE d.pernominaid = ".$periodoid." 
                            AND d.terid = ".$terid." 
                   GROUP BY d.conceptoid         
                   ORDER BY c.tipodc, c.codconcepto";
    
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $i = 0;
            $x = 10;
            $y = 76;
            $totdevengado = 0;
            $totdescuento = 0;
            $totpagar = 0;
            while($row = mysql_fetch_array($result))
            {
                // Imprimo los conceptos con sus respectivos montos
                $pdf->SetFont('Arial','',8);
                $pdf->Text($x,$y,$row['codconcepto']);
    
                if(($row['conceptoid']==4)||($row['conceptoid']==5))
                {
                    if($row['conceptoid']==4)
                        $nomconcepto = $pensiones;
    
                    if($row['conceptoid']==5)
                        $nomconcepto = $eps;
    
                    if($nomconcepto=="")
                        $nomconcepto = "NO ESPECIFICA";
                
                    $pdf->Text($x+20,$y,$nomconcepto);
                }
                else
                {
                    $nomconcepto = substr($row['nomconcepto'],0,33);
                    $pdf->Text($x+20,$y,$nomconcepto);
                }
    
                // Impresión de los días
                if($row['valor']>0)
                {
                    // Alineación de los montos correspondientes
                    $longitud = strlen($row['valor']);
    
                    if($longitud==1)
                        $pdf->Text($x+81,$y,number_format($row['valor'],2));
    
                    if($longitud==2)
                        $pdf->Text($x+80,$y,number_format($row['valor'],2));
                }
    
                // Impresión de los devengados
                if($row['devengados']>0)
                {
                    // Alineación de los montos correspondientes
                    $longitud = strlen($row['devengados']);

                    if($longitud==4)
                        $pdf->Text($x+120,$y,number_format($row['devengados'],0));                        

                    if($longitud==5)
                        $pdf->Text($x+118,$y,number_format($row['devengados'],0));
    
                    if($longitud==6)
                        $pdf->Text($x+117,$y,number_format($row['devengados'],0));
    
                    if($longitud==7)
                        $pdf->Text($x+115,$y,number_format($row['devengados'],0));
                }
                
                // Impresión de los descuentos
                if(($row['descuentos']>0)&&(($row['conceptoid']!=6)&&($row['conceptoid']!=9)&&($row['conceptoid']!=43)&&($row['conceptoid']!=58)))                    
                {
                    // Alineación de los montos correspondientes
                    $longitud = strlen($row['descuentos']);

                    if($longitud==1)
                        $pdf->Text($x+155,$y,number_format($row['descuentos'],0));

                    if($longitud==2)
                        $pdf->Text($x+151,$y,number_format($row['descuentos'],0));

                    if($longitud==3)
                        $pdf->Text($x+150,$y,number_format($row['descuentos'],0));                        

                    if($longitud==4)
                        $pdf->Text($x+149,$y,number_format($row['descuentos'],0));
    
                    if($longitud==5)
                        $pdf->Text($x+148,$y,number_format($row['descuentos'],0));
    
                    if($longitud==6)
                        $pdf->Text($x+146,$y,number_format($row['descuentos'],0));
                }
    
                // Impresión del saldo/base
                if($row['saldo']>0)
                {
                    // Alineación de los montos correspondientes
                    $longitud = strlen($row['saldo']);
    
                    if($longitud==7)
                        $pdf->Text($x+178,$y,number_format($row['saldo'],0));
    
                    if($longitud==6)
                        $pdf->Text($x+180,$y,number_format($row['saldo'],0));
                }
    
                // Incremento los totales
                $totdevengado += $row['devengados'];
    
                if(($row['conceptoid']!=6)&&($row['conceptoid']!=9)&&($row['conceptoid']!=43)&&($row['conceptoid']!=58))
                    $totdescuento += $row['descuentos'];
    
                $i++;
                $y+=6;
            }
    
            // Imprimo los totales
            $lineatotales = $y;
            $pdf->SetFillColor(220,220,220);
            $pdf->Rect(7,$lineatotales,195,8,'F');
    
            $pdf->SetFont('Arial','B',10);
            $pie= "TOTALES: ";
            $pdf->Text($x+70,$y+5,$pie);
    
            $pdf->SetFont('Arial','',8);
    
            // Alineación de los montos correspondientes
            $longitud = strlen($totdevengado);
    
            if($longitud==5)
                $pdf->Text($x+113,$y+5,number_format($totdevengado));
    
            if($longitud==6)
                $pdf->Text($x+117,$y+5,number_format($totdevengado));
    
            if($longitud==7)
                $pdf->Text($x+114,$y+5,number_format($totdevengado));
    
            // Alineación de los montos correspondientes
            $longitud = strlen($totdescuento);
    
            if($longitud==6)
                $pdf->Text($x+146,$y+5,number_format($totdescuento));                

            if($longitud==5)
                $pdf->Text($x+148,$y+5,number_format($totdescuento));
    
            if($longitud==4)
                $pdf->Text($x+149,$y+5,number_format($totdescuento));
    
            $totpagar = $totdevengado - $totdescuento;
    
            $pdf->SetFillColor(180,180,180);
            $pdf->Rect(7,$lineatotales+8,195,8,'F');
    
            $pdf->SetFont('Arial','B',10);
            $pie= "NETO A PAGAR: ";
            $pdf->Text($x+70,$y+13,$pie);

            $longitud = strlen($totpagar);

            if($longitud==3)
                $pdf->Text($x+153,$y+13,number_format($totpagar));

            if($longitud==4)
                $pdf->Text($x+150,$y+13,number_format($totpagar));

            if($longitud==5)
                $pdf->Text($x+147,$y+13,number_format($totpagar));

            if($longitud==6)
                $pdf->Text($x+144,$y+13,number_format($totpagar));

            if($longitud==7)
                $pdf->Text($x+141,$y+13,number_format($totpagar));

            // Impresión del banco y cuenta a la cual se le consigna
            $pdf->SetFont('Arial','',8);
            $pie= "                                                                                                                                                                     __________________________";
            $pdf->Text($x,$y+35,$pie);
            $pie= "                                                                                                                                                                     RECIBI CONFORME";
            $pdf->Text($x,$y+40,$pie);

            if($extralegal=="CHECKED")
                $pie= "CONSIGNADO EN: EFECTIVO                                                                                                                  C.C.";
            else
            {
                if(($numcuenta=="")||($numcuenta==NULL))
                    $pie= "CONSIGNADO EN: EFECTIVO                                                                                                                  C.C.";
                else
                    $pie= "CONSIGNADO EN: ".strtoupper($banco)."                      CUENTA NO. ".$numcuenta."                            C.C.";            
            }
            
            $pdf->Text($x,$y+45,$pie);
            $pdf->Output();
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaperiodospdf
    // Creación: 29/12/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para seleccionar los filtros por los cuales 
    //              se van a  generar los recios de pago
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaperiodospdf")
    {
        // consulta para el combo de periodos
        $vsqlcomboperiodo  = "SELECT codigo, CONCAT(codigo,' - ',descripcion) 
                                FROM periodosnomina 
                               WHERE cerrado = 'CHECKED' OR 
                                     calculado = 'CHECKED'
                            ORDER BY periodoid ASC";

        // pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/pdf.png" width="32" height="32" border="0"> </td> 
                  <td width="840"> <b> Generar recibos de pago </b> </td>
                  <td> &nbsp; </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';

        // filtros para generar los recibos
        $cont.='<form action="recibodepago.php?opcion=generarrecibopdf" method="POST" name="x" target="_blank">                 
                <center>
                <table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="220"> &nbsp; </td>
                  <td width="20"> Periodo: </td>
                  <td width="120"> '.$clase->CrearComboBuscar("codigo",$vsqlcomboperiodo,"descripcion","codigo","","N",$params,400).' </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="220"> &nbsp; </td>
                  <td width="20"> Tipo: </td>
                  <td width="120"> 
                   <select name="tiponomina" id="tiponomina" style="width:120px;height:25px">
                    <option value="todos" selected> Todos </option>               
                    <option value="empleados"> Empleados </option>               
                    <option value="extralegal"> Extralegal </option>
                   </select> 
                  </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                </table>';

        // botón de aceptar
        $cont.='<table width="100%">
                <tr class="BarraDocumentos"> 
                 <td width="260"> &nbsp; </td> 
                 <td width="100" alling="center">
                  <input type="submit" value="aceptar" class="button blue">
                  </form>
                 </td> 
                 <td width="220"> &nbsp; </td>
                </tr>
               </table>';

        // pie de página
        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                </table>';
        echo $cont.$clase->PiePagina();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: generarrecibopdf
    // Creación: 29/12/2023		última modificación: 09/05/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que determina cuales serán los empleados a los cuales se les 
    //              generarán los recibos de pago
    // Última modificación: Limpieza de la tabla recibospdf (30/12/2023)
    //                      Hoja de Excel con la información de los recibos de pago
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "generarrecibopdf")
    {
        // Recibo los parámetros con los cuales filtraré el recibo
        $codigo = $_POST['codigo'];
        $tiponomina = $_POST['tiponomina'];

        // Variable del periodo
        $periodoid = $clase->BDLockup($codigo,'periodosnomina','codigo','periodoid');
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $cerrado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','cerrado');

        if($cerrado=="CHECKED")
        {
            $tabla = "periodoterceros";
            $tabladet = "hisdetallenomina";
            $nomnreemp = "t.nombre AS nombreemp ";
        }
        else
        {
            $tabladet = "detallenomina";
            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado=="CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";

            $nomnreemp = "CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp ";
        }

        // Inicializo las variables
        $vsqldatos = "";                    $terid = 0;                 $codvende = "";                 $nombreemp = "";                    $documento = "";
        $cargo = "";                        $basico = 0;                $seccion = "";                  $fecingreso = "";                   $area = "";
        $banco = "";                        $lineatotales = 0;          $epsid = 0;                     $eps = "";                          $nomconcepto = "";
        $pensiones = "";                    $longitud = 0;              $fechoraimp = "";               $mesimp = "";                       $extralegal = "";
        $consulta = "";                     $pagina = 0;

        // construyo el nombre del archivo
        $codigo = $clase->BDLockup($periodoid,'periodosnomina','periodoid','codigo');
        $codigo = str_replace('.','',$codigo);        

        // Traducción al español del mes que devuelve la función date()
        $mesimp = date('F');
        if($mesimp=="January")       $mesimp = "Enero";
        if($mesimp=="February")      $mesimp = "Febrero";
        if($mesimp=="March")         $mesimp = "Marzo";
        if($mesimp=="April")         $mesimp = "Abril";
        if($mesimp=="May")           $mesimp = "Mayo";
        if($mesimp=="June")          $mesimp = "Junio";
        if($mesimp=="July")          $mesimp = "Julio";
        if($mesimp=="August")        $mesimp = "Agosto";
        if($mesimp=="September")     $mesimp = "Septiembre";
        if($mesimp=="October")       $mesimp = "Octubre";
        if($mesimp=="November")      $mesimp = "Noviembre";
        if($mesimp=="December")      $mesimp = "Diciembre";

        // Limpio la tabla recibospdf
        $vsql6 = "DELETE FROM recibospdf";
        $clase->EjecutarSQL($vsql6);

        // Procedo a construir el encabezado del recibo
        $clase = new Sistema();
        ini_set("memory_limit","200M");
        require('lib/fpdf/fpdf.php');
        $pdf=new FPDF('L','mm','A6');       // Recibo a media página

        // Página nueva
        $pdf->AddPage("");
        $pagina = 1;

        // Consulta para los empleados
        $consulta = "SELECT t.terid, t.codvende, t.dni, ".$nomnreemp.",  
                            t.basico, t.fecingreso, c.descripcioncargo, s.descripcionsec, t.extralegal, b.descripcion, t.numcuenta, e.descripcioneps, 
                            p.descripcionafp, a.descripcionarea
                       FROM ".$tabla." t
                            INNER JOIN cargos c ON (t.cargoid = c.cargoid) 
                            INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                            INNER JOIN bancos b ON (t.bancoid = b.bancoid)
                            INNER JOIN eps e ON (t.epsid = e.epsid) 
                            INNER JOIN pensiones p ON (t.pensionesid = p.pensionesid)  
                            INNER JOIN areanomina a ON (t.areaid = a.areaid) ";

        // Aquí filtro la consulta por tipo de nómina
        if($tiponomina=="todos")
            $consulta.= " WHERE t.esempleadoactivo = 'CHECKED'";

        if($tiponomina=="empleados")
            $consulta.= " WHERE t.esempleadoactivo = 'CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL)";

        if($tiponomina=="extralegal")
            $consulta.= " WHERE t.extralegal = 'CHECKED'";

        // Filtro del salario básico y el periodo
        $consulta.= " AND t.pernominaid = ".$periodoid." AND t.basico > 0 ";

        $vsql = $consulta;

        // Variable para la salida a Excel
        $_SESSION['SQL_TIRASDEPAGOXLS'] = $vsql;

        $i = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {   
            $terid = $row['terid'];                 // El id del empleado
            generarreciboenpdf($terid,$periodoid);
        }

        // ----------------------------------------------------------------------------------------------------------------------- //
        // Hoja de Excel con la información de los recibos generados
        $vsql = $_SESSION['SQL_TIRASDEPAGOXLS'];

        // Preparo el entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");
        
        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("tiras de pago - DROPOS")
                                     ->setSubject("tiras de pago - DROPOS")
                                     ->setDescription("tiras de pago - DROPOS")
                                     ->setKeywords("tiras de pago - DROPOS")
                                     ->setCategory("Categoria General");
                                     
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'TIRAS DE PAGO DEL PERIODO')
                    ->setCellValue('A2', $descripcion)
                    ->setCellValue('A3', 'DOCUMENTO')
                    ->setCellValue('B3', 'NOMBRE')
                    ->setCellValue('C3', 'RUTA');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,4);
        
        $ruta = "";
        $i = 4;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        $cant   = @mysql_num_rows($result);
        while($row = @mysql_fetch_array($result))
        {
            $ruta = "nomina/05/01/".trim($row['dni']).".pdf";
            
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['dni'])
                        ->setCellValue('B'.$i, $row['nombreemp'])
                        ->setCellValue('C'.$i, $ruta);
            $i++;
        }

        $rangoEncabezado = 'A3:C3';
        $rangoCeldas     = 'A3:C'.($i-1);

        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('tiras de pago');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // ------------------------------------------------------------------------------ //
        $nombrearcexcel = "tiras de pago del periodo ".strtolower($descripcion).".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // ------------------------------------------------------------------------------ //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
        // ----------------------------------------------------------------------------------------------------------------------- //

        $clase->Aviso(3,"Recibos generados satisfactoriamente");

        // Redirecciono el formulario
        header("Location: recibodepago.php?opcion=ventanaperiodospdf");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función numtoletras
    // Parámetro de entrada:    $xcifra --> número que se traducirá a letras    
    // Valor de retorno:        $xcadena --> cadena con el valor en letras
    // Descripción: Función que convierte un número en letras
    ////////////////////////////////////////////////////////////////////////////////////////
    function numtoletras($xcifra)
    {
        $xarray = array(0 => "Cero",
            1 => "UN", "DOS", "TRES", "CUATRO", "CINCO", "SEIS", "SIETE", "OCHO", "NUEVE",
            "DIEZ", "ONCE", "DOCE", "TRECE", "CATORCE", "QUINCE", "DIECISEIS", "DIECISIETE", "DIECIOCHO", "DIECINUEVE",
            "VEINTI", 30 => "TREINTA", 40 => "CUARENTA", 50 => "CINCUENTA", 60 => "SESENTA", 70 => "SETENTA", 80 => "OCHENTA", 90 => "NOVENTA",
            100 => "CIENTO", 200 => "DOSCIENTOS", 300 => "TRESCIENTOS", 400 => "CUATROCIENTOS", 500 => "QUINIENTOS", 600 => "SEISCIENTOS", 700 => "SETECIENTOS", 800 => "OCHOCIENTOS", 900 => "NOVECIENTOS"
        );
    //
        $xcifra = trim($xcifra);
        $xlength = strlen($xcifra);
        $xpos_punto = strpos($xcifra, ".");
        $xaux_int = $xcifra;
        $xdecimales = "00";
        if (!($xpos_punto === false)) 
        {
            if ($xpos_punto == 0) 
            {
                $xcifra = "0" . $xcifra;
                $xpos_punto = strpos($xcifra, ".");
            }
            $xaux_int = substr($xcifra, 0, $xpos_punto); // obtengo el entero de la cifra a covertir
            $xdecimales = substr($xcifra . "00", $xpos_punto + 1, 2); // obtengo los valores decimales
        }
    
        $XAUX = str_pad($xaux_int, 18, " ", STR_PAD_LEFT); // ajusto la longitud de la cifra, para que sea divisible por centenas de miles (grupos de 6)
        $xcadena = "";
        for ($xz = 0; $xz < 3; $xz++) 
        {
            $xaux = substr($XAUX, $xz * 6, 6);
            $xi = 0;
            $xlimite = 6; // inicializo el contador de centenas xi y establezco el límite a 6 dígitos en la parte entera
            $xexit = true; // bandera para controlar el ciclo del While
            while ($xexit) 
            {
                if ($xi == $xlimite) 
                { // si ya llegó al límite máximo de enteros
                    break; // termina el ciclo
                }
    
                $x3digitos = ($xlimite - $xi) * -1; // comienzo con los tres primeros digitos de la cifra, comenzando por la izquierda
                $xaux = substr($xaux, $x3digitos, abs($x3digitos)); // obtengo la centena (los tres dígitos)
                for ($xy = 1; $xy < 4; $xy++) { // ciclo para revisar centenas, decenas y unidades, en ese orden
                    switch ($xy) {
                        case 1: // checa las centenas
                            if (substr($xaux, 0, 3) < 100) { // si el grupo de tres dígitos es menor a una centena ( < 99) no hace nada y pasa a revisar las decenas
                                
                            } else {
                                $key = (int) substr($xaux, 0, 3);
                                if (TRUE === array_key_exists($key, $xarray)){  // busco si la centena es número redondo (100, 200, 300, 400, etc..)
                                    $xseek = $xarray[$key];
                                    $xsub = subfijo($xaux); // devuelve el subfijo correspondiente (Millón, Millones, Mil o nada)
                                    if (substr($xaux, 0, 3) == 100)
                                        $xcadena = " " . $xcadena . " CIEN " . $xsub;
                                    else
                                        $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                                    $xy = 3; // la centena fue redonda, entonces termino el ciclo del for y ya no reviso decenas ni unidades
                                }
                                else { // entra aquí si la centena no fue numero redondo (101, 253, 120, 980, etc.)
                                    $key = (int) substr($xaux, 0, 1) * 100;
                                    $xseek = $xarray[$key]; // toma el primer caracter de la centena y lo multiplica por cien y lo busca en el arreglo (para que busque 100,200,300, etc)
                                    $xcadena = " " . $xcadena . " " . $xseek;
                                } // ENDIF ($xseek)
                            } // ENDIF (substr($xaux, 0, 3) < 100)
                            break;
                        case 2: // checa las decenas (con la misma lógica que las centenas)
                            if (substr($xaux, 1, 2) < 10) {
                                
                            } else {
                                $key = (int) substr($xaux, 1, 2);
                                if (TRUE === array_key_exists($key, $xarray)) {
                                    $xseek = $xarray[$key];
                                    $xsub = subfijo($xaux);
                                    if (substr($xaux, 1, 2) == 20)
                                        $xcadena = " " . $xcadena . " VEINTE " . $xsub;
                                    else
                                        $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                                    $xy = 3;
                                }
                                else {
                                    $key = (int) substr($xaux, 1, 1) * 10;
                                    $xseek = $xarray[$key];
                                    if (20 == substr($xaux, 1, 1) * 10)
                                        $xcadena = " " . $xcadena . " " . $xseek;
                                    else
                                        $xcadena = " " . $xcadena . " " . $xseek . " Y ";
                                } // ENDIF ($xseek)
                            } // ENDIF (substr($xaux, 1, 2) < 10)
                            break;
                        case 3: // checa las unidades
                            if (substr($xaux, 2, 1) < 1) { // si la unidad es cero, ya no hace nada
                                
                            } else {
                                $key = (int) substr($xaux, 2, 1);
                                $xseek = $xarray[$key]; // obtengo directamente el valor de la unidad (del uno al nueve)
                                $xsub = subfijo($xaux);
                                $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                            } // ENDIF (substr($xaux, 2, 1) < 1)
                            break;
                    } // END SWITCH
                } // END FOR
                $xi = $xi + 3;
            } // ENDDO
    
            if (substr(trim($xcadena), -5, 5) == "ILLON") // si la cadena obtenida termina en MILLON o BILLON, entonces le agrega al final la conjuncion DE
                $xcadena.= " DE";
    
            if (substr(trim($xcadena), -7, 7) == "ILLONES") // si la cadena obtenida en MILLONES o BILLONES, entoncea le agrega al final la conjuncion DE
                $xcadena.= " DE";
    
            // ----------- esta línea la puedes cambiar de acuerdo a tus necesidades o a tu país -------
            if (trim($xaux) != "") {
                switch ($xz) {
                    case 0:
                        if (trim(substr($XAUX, $xz * 6, 6)) == "1")
                            $xcadena.= "UN BILLON ";
                        else
                            $xcadena.= " BILLONES ";
                        break;
                    case 1:
                        if (trim(substr($XAUX, $xz * 6, 6)) == "1")
                            $xcadena.= "UN MILLON ";
                        else
                            $xcadena.= " MILLONES ";
                        break;
                    case 2:
                        if ($xcifra < 1) {
                            $xcadena = "CERO PESOS CON $xdecimales/100";
                        }
                        if ($xcifra >= 1 && $xcifra < 2) {
                            $xcadena = "UN PESO CON $xdecimales/100";
                        }
                        if ($xcifra >= 2) {
                            $xcadena.= " PESOS CON $xdecimales/100"; //
                        }
                        break;
                } // endswitch ($xz)
            } // ENDIF (trim($xaux) != "")
            // ------------------      en este caso, para México se usa esta leyenda     ----------------
            $xcadena = str_replace("VEINTI ", "VEINTI", $xcadena); // quito el espacio para el VEINTI, para que quede: VEINTICUATRO, VEINTIUN, VEINTIDOS, etc
            $xcadena = str_replace("  ", " ", $xcadena); // quito espacios dobles
            $xcadena = str_replace("UN UN", "UN", $xcadena); // quito la duplicidad
            $xcadena = str_replace("  ", " ", $xcadena); // quito espacios dobles
            $xcadena = str_replace("BILLON DE MILLONES", "BILLON DE", $xcadena); // corrigo la leyenda
            $xcadena = str_replace("BILLONES DE MILLONES", "BILLONES DE", $xcadena); // corrigo la leyenda
            $xcadena = str_replace("DE UN", "UN", $xcadena); // corrigo la leyenda
        } // ENDFOR ($xz)
        return trim($xcadena);
    }

    function subfijo($xx)
    { // esta función regresa un subfijo para la cifra
        $xx = trim($xx);
        $xstrlen = strlen($xx);
        if ($xstrlen == 1 || $xstrlen == 2 || $xstrlen == 3)
            $xsub = "";
        //
        if ($xstrlen == 4 || $xstrlen == 5 || $xstrlen == 6)
            $xsub = "MIL";
        //
        return $xsub;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función generarreciboenpdf
    // Parámetro de entrada:    $terid     --> ID del empleado
    //                          $periodoid --> ID del periodo    
    // Valor de retorno:        ninguno
    // Descripción: Función que genera el recibo de pago de un empleado y lo almacena 
    //              físicamente en formato pdf además de llenar la tabla recibospdf
    ////////////////////////////////////////////////////////////////////////////////////////
    function generarreciboenpdf($terid,$periodoid)
    {
        // Procedo a construir el encabezado del recibo        
        $clase2 = new Sistema();
        $clase2->Nombredb = $_SESSION['DBNOMBRE'];

        ini_set("memory_limit","200M");        
        $pdf=new FPDF('L','mm','A6');       // Recibo a media página

        // Inicializo las variables
        $descripcion  = $clase2->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        $vsqldatos = "";                $codvende = "";             $nombreemp = "";                $documento = "";
        $cargo = "";                    $basico = 0;                $seccion = "";                  $fecingreso = "";
        $area = "";                     $banco = "";                $lineatotales = 0;              $epsid = 0;
        $eps = "";                      $nomconcepto = "";          $pensiones = "";                $longitud = 0;
        $fechoraimp = "";               $mesimp = "";               $extralegal = "";               $tipoimpresion = "recibo";

        // construyo el nombre del archivo
        $codigo = $clase2->BDLockup($periodoid,'periodosnomina','periodoid','codigo');
        $codigo = str_replace('.','',$codigo);        

        // Variable para determinar si el periodo está abierto o cerrado
        $cerrado = $clase2->BDLockup($periodoid,'periodosnomina','periodoid','cerrado');

        if($cerrado=="CHECKED")
        {
            $tabla = "periodoterceros";
            $tabla2 = "hisdetallenomina";
        }
        else
        {
            $tabla = "tercerosactual";       
            $tabla2 = "detallenomina";
        }        

        // Valido la existencia del empleado en el periodo        
        $vsqldatos = "SELECT COUNT(*) AS teridper FROM ".$tabla2." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        $teridper = $clase2->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($cerrado=="CHECKED")
        {
            // El código del empleado
            $vsqldatos = "SELECT codvende FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
            $codvende = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // El nombre del empleado
            $vsqldatos = "SELECT nombre AS nombreemp FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
            $nombreemp = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // Documento
            $vsqldatos = "SELECT dni FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
            $dni = $clase2->SeleccionarUno($vsqldatos);
            $documento = $dni;                
            
            // El cargo
            $vsqldatos = "SELECT c.descripcioncargo AS cargo 
                            FROM ".$tabla." p
                                 INNER JOIN cargos c ON (p.cargoid = c.cargoid) 
                           WHERE p.terid = ".$terid."
                                 AND p.pernominaid = ".$periodoid."";
            $cargo = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // Sueldo básico
            $vsqldatos = "SELECT basico FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
            $basico = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";                

            // La sección
            $vsqldatos = "SELECT s.descripcionsec 
                            FROM ".$tabla." p
                                 INNER JOIN seccion s ON (p.seccionid = s.seccionid) 
                           WHERE p.terid = ".$terid."
                                 AND p.pernominaid = ".$periodoid."";
            $seccion = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // Fecha de ingreso
            $vsqldatos = "SELECT fecingreso FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
            $fecingreso = $clase2->SeleccionarUno($vsqldatos);
            $fecingreso = substr($fecingreso,8,2)."/".substr($fecingreso,5,2)."/".substr($fecingreso,0,4);
            $vsqldatos = "";

            $vsqldatos = "SELECT extralegal FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
            $extralegal = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            $vsqldatos = "SELECT numcuenta FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
            $numcuenta = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            if($extralegal=="CHECKED")
                $area = "EXTRALEGALES";
            else
            {
                // El área
                $vsqldatos = "SELECT a.descripcionarea 
                                FROM ".$tabla." p
                                     INNER JOIN areanomina a ON (p.areaid = a.areaid) 
                               WHERE p.terid = ".$terid."
                                     AND p.pernominaid = ".$periodoid."";
                $area = $clase2->SeleccionarUno($vsqldatos);
                $vsqldatos = "";
            }

            // El banco
            $vsqldatos = "SELECT b.descripcion 
                            FROM ".$tabla." p
                                 INNER JOIN bancos b ON (p.bancoid = b.bancoid) 
                           WHERE p.terid = ".$terid."
                                 AND p.pernominaid = ".$periodoid."";
            $banco = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // Número de cuenta bancaria
            $vsqldatos = "SELECT numcuenta FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
            $numcuenta = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // EPS a la cual pertenece el empleado
            $vsqldatos = "SELECT e.descripcioneps 
                            FROM ".$tabla." p
                                 INNER JOIN eps e ON (p.epsid = e.epsid) 
                           WHERE p.terid = ".$terid."
                                 AND p.pernominaid = ".$periodoid."";
            $eps = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // Fondo de pensiones al cual pertenece el empleado
            $vsqldatos = "SELECT p.descripcionafp 
                            FROM ".$tabla." t
                                 INNER JOIN pensiones p ON (t.pensionesid = p.pensionesid) 
                           WHERE t.terid = ".$terid."
                                 AND t.pernominaid = ".$periodoid."";
            $pensiones = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
        }
        else
        {
            // El código del empleado
            $vsqldatos = "SELECT codvende FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
            $codvende = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
    
            // El nombre del empleado
            $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
            $nombreemp = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
            
            // Documento
            $vsqldatos = "SELECT dni FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
            $dni = $clase2->SeleccionarUno($vsqldatos);                
            $documento = $dni;
    
            // El cargo
            $vsqldatos = "SELECT c.descripcioncargo 
                            FROM ".$tabla." t
                                 INNER JOIN cargos c ON (t.cargoid = c.cargoid) 
                           WHERE t.terid = ".$terid."
                                 AND pernominaid = ".$periodoid."";
            $cargo = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            $basico = $clase2->BDLockup($terid,$tabla,'terid','basico');
    
            // La sección
            $vsqldatos = "SELECT s.descripcionsec 
                            FROM ".$tabla." t
                                 INNER JOIN seccion s ON (t.seccionid = s.seccionid) 
                           WHERE t.terid = ".$terid."
                                 AND pernominaid = ".$periodoid."";
            $seccion = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
    
            // Fecha de ingreso
            $vsqldatos = "SELECT fecingreso FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
            $fecingreso = $clase2->SeleccionarUno($vsqldatos);
            $fecingreso = substr($fecingreso,8,2)."/".substr($fecingreso,5,2)."/".substr($fecingreso,0,4);
            $vsqldatos = "";
    
            // Determino si el empleado es de condición extralegal
            $extralegal = $clase2->BDLockup($terid,$tabla,'terid','extralegal');
            $numcuenta = $clase2->BDLockup($terid,$tabla,'terid','numcuenta');
    
            if($extralegal=="CHECKED")
                $area = "EXTRALEGALES";
            else
            {
                // El área
                $vsqldatos = "SELECT a.descripcionarea 
                                FROM ".$tabla." t
                                     INNER JOIN areanomina a ON (t.areaid = a.areaid) 
                               WHERE t.terid = ".$terid." AND pernominaid = ".$periodoid."";
                $area = $clase2->SeleccionarUno($vsqldatos);
                $vsqldatos = "";
            }
    
            // El banco
            $vsqldatos = "SELECT b.descripcion 
                            FROM ".$tabla." t
                                 INNER JOIN bancos b ON (t.bancoid = b.bancoid) 
                           WHERE t.terid = ".$terid." AND pernominaid = ".$periodoid."";
            $banco = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
    
            // Número de cuenta bancaria
            $vsqldatos = "SELECT numcuenta FROM ".$tabla." WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
            $numcuenta = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
    
            // EPS a la cual pertenece el empleado
            $vsqldatos = "SELECT e.descripcioneps 
                            FROM ".$tabla." t
                                 INNER JOIN eps e ON (t.epsid = e.epsid) 
                           WHERE t.terid = ".$terid." AND pernominaid = ".$periodoid."";
            $eps = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
    
            // Fondo de pensiones al cual pertenece el empleado
            $vsqldatos = "SELECT p.descripcionafp 
                            FROM ".$tabla." t
                                 INNER JOIN pensiones p ON (t.pensionesid = p.pensionesid) 
                           WHERE t.terid = ".$terid." AND pernominaid = ".$periodoid."";
            $pensiones = $clase2->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
        }

        // Procedo a construir el encabezado del recibo            
        ini_set("memory_limit","200M");
        $pdf=new FPDF('L','mm','A6');       // Recibo a media página            
    
        // Página nueva            
        $pdf->AddPage("");
        $pagina = 1;

        // Encabezado del recibo
        
        // Traducción al español del mes que devuelve la función date()
        $mesimp = date('F');
        if($mesimp=="January")       $mesimp = "Enero";
        if($mesimp=="February")      $mesimp = "Febrero";
        if($mesimp=="March")         $mesimp = "Marzo";
        if($mesimp=="April")         $mesimp = "Abril";
        if($mesimp=="May")           $mesimp = "Mayo";
        if($mesimp=="June")          $mesimp = "Junio";
        if($mesimp=="July")          $mesimp = "Julio";
        if($mesimp=="August")        $mesimp = "Agosto";
        if($mesimp=="September")     $mesimp = "Septiembre";
        if($mesimp=="October")       $mesimp = "Octubre";
        if($mesimp=="November")      $mesimp = "Noviembre";
        if($mesimp=="December")      $mesimp = "Diciembre";            

        // Fecha y hora de impresión
        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
        $pdf->SetFont('Arial','',8);
        $pdf->Text(147,14,$fechoraimp);

        // Logo Dromedicas
        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

        $x = 35;
        $y = 15;
        $pdf->SetFont('Arial','B',10);
        $enc= "COMPROBANTE DE PAGO";
        $pdf->Text($x,$y,$enc);
        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
        $pdf->Text($x,$y+7,$enc);
        $enc= "NOMINA: ";
        $pdf->Text($x,$y+14,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=strtoupper($descripcion);
        $pdf->Text($x+18,$y+14,$enc);

        $x = 10;
        $y = 40;
        $pdf->SetFont('Arial','B',10);

        // Datos del empleado
        $enc= "CODIGO: ";
        $pdf->Text($x,$y,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=$codvende;
        $pdf->Text($x+28,$y,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "NOMBRE: ";
        $pdf->Text($x+60,$y,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=strtoupper($nombreemp);
        $pdf->Text($x+80,$y,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "DOCUMENTO: ";
        $pdf->Text($x,$y+7,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=$documento;
        $pdf->Text($x+28,$y+7,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "CARGO: ";
        $pdf->Text($x+60,$y+7,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=strtoupper($cargo);
        $pdf->Text($x+80,$y+7,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "BASICO: ";
        $pdf->Text($x,$y+14,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=number_format($basico,2);
        $pdf->Text($x+28,$y+14,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "SECCION: ";
        $pdf->Text($x+60,$y+14,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=strtoupper($seccion);
        $pdf->Text($x+80,$y+14,$enc);
    
        $pdf->SetFont('Arial','B',10);
        $enc= "AREA: ";
        $pdf->Text($x+60,$y+21,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=strtoupper($area);
        $pdf->Text($x+80,$y+21,$enc);

        // Títulos del detalle
        $x = 10;
        $y = 68;
        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(7,63,195,8,'F');
        $pdf->SetFont('Arial','B',9);
        $pdf->Text($x,$y,"CODIGO");
        $pdf->Text($x+20,$y,"CONCEPTO");
        $pdf->Text($x+75,$y,"CANTIDAD");
        $pdf->Text($x+105,$y,"DEVENGADOS");
        $pdf->Text($x+135,$y,"DESCUENTOS");
        $pdf->Text($x+170,$y,"SALDO/BASE");            

        // $vsql = "SELECT c.codconcepto, c.nomconcepto, d.valor, d.devengados, d.descuentos, 
        //                 d.saldo, d.conceptoid
        //            FROM detallenomina d
        //                 INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
        //           WHERE d.pernominaid = ".$periodoid." 
        //                 AND d.terid=".$terid."
        //        ORDER BY c.tipodc, c.codconcepto";

        $vsql = "SELECT SELECT c.codconcepto, c.nomconcepto, IF(d.conceptoid NOT IN (53,54),SUM(d.valor),COUNT(*)) valor, SUM(d.devengados) devengados, SUM(d.descuentos) descuentos, d.saldo, d.conceptoid 
                   FROM detallenomina d 
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                  WHERE d.pernominaid = ".$periodoid." 
                        AND d.terid = ".$terid." 
               GROUP BY d.conceptoid 
               ORDER BY c.tipodc, c.codconcepto";

        $conex  = $clase2->Conectar();
        $result = mysql_query($vsql,$conex);
        $i = 0;
        $x = 10;
        $y = 76;
        $totdevengado = 0;
        $totdescuento = 0;
        $totpagar = 0;
        while($row = mysql_fetch_array($result))
        {
            // Imprimo los conceptos con sus respectivos montos
            $pdf->SetFont('Arial','',8);
            $pdf->Text($x,$y,$row['codconcepto']);

            if(($row['conceptoid']==4)||($row['conceptoid']==5))
            {
                if($row['conceptoid']==4)
                    $nomconcepto = $pensiones;

                if($row['conceptoid']==5)
                    $nomconcepto = $eps;

                if($nomconcepto=="")
                    $nomconcepto = "NO ESPECIFICA";
            
                $pdf->Text($x+20,$y,$nomconcepto);
            }
            else
            {
                $nomconcepto = substr($row['nomconcepto'],0,33);
                $pdf->Text($x+20,$y,$nomconcepto);
            }

            // Impresión de los días
            if($row['valor']>0)
            {
                // Alineación de los montos correspondientes
                $longitud = strlen($row['valor']);

                if($longitud==1)
                    $pdf->Text($x+81,$y,number_format($row['valor'],2));

                if($longitud==2)
                    $pdf->Text($x+80,$y,number_format($row['valor'],2));
            }

            // Impresión de los devengados
            if($row['devengados']>0)
            {
                // Alineación de los montos correspondientes
                $longitud = strlen($row['devengados']);

                if($longitud==4)
                    $pdf->Text($x+120,$y,number_format($row['devengados'],0));                        

                if($longitud==5)
                    $pdf->Text($x+118,$y,number_format($row['devengados'],0));

                if($longitud==6)
                    $pdf->Text($x+117,$y,number_format($row['devengados'],0));

                if($longitud==7)
                    $pdf->Text($x+115,$y,number_format($row['devengados'],0));
            }
            
            // Impresión de los descuentos
            if(($row['descuentos']>0)&&(($row['conceptoid']!=6)&&($row['conceptoid']!=9)&&($row['conceptoid']!=43)&&($row['conceptoid']!=58)))                    
            {
                // Alineación de los montos correspondientes
                $longitud = strlen($row['descuentos']);

                if($longitud==1)
                    $pdf->Text($x+155,$y,number_format($row['descuentos'],0));

                if($longitud==2)
                    $pdf->Text($x+151,$y,number_format($row['descuentos'],0));

                if($longitud==3)
                    $pdf->Text($x+150,$y,number_format($row['descuentos'],0));                        

                if($longitud==4)
                    $pdf->Text($x+149,$y,number_format($row['descuentos'],0));

                if($longitud==5)
                    $pdf->Text($x+148,$y,number_format($row['descuentos'],0));

                if($longitud==6)
                    $pdf->Text($x+146,$y,number_format($row['descuentos'],0));
            }

            // Impresión del saldo/base
            if($row['saldo']>0)
            {
                // Alineación de los montos correspondientes
                $longitud = strlen($row['saldo']);

                if($longitud==7)
                    $pdf->Text($x+178,$y,number_format($row['saldo'],0));

                if($longitud==6)
                    $pdf->Text($x+180,$y,number_format($row['saldo'],0));
            }

            // Incremento los totales
            $totdevengado += $row['devengados'];

            if(($row['conceptoid']!=6)&&($row['conceptoid']!=9)&&($row['conceptoid']!=43)&&($row['conceptoid']!=58))
                $totdescuento += $row['descuentos'];

            $i++;
            $y+=6;
        }            
    
        // Imprimo los totales
        $lineatotales = $y;
        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(7,$lineatotales,195,8,'F');

        $pdf->SetFont('Arial','B',10);
        $pie= "TOTALES: ";
        $pdf->Text($x+70,$y+5,$pie);

        $pdf->SetFont('Arial','',8);

        // Alineación de los montos correspondientes
        $longitud = strlen($totdevengado);

        if($longitud==5)
            $pdf->Text($x+113,$y+5,number_format($totdevengado));

        if($longitud==6)
            $pdf->Text($x+117,$y+5,number_format($totdevengado));

        if($longitud==7)
            $pdf->Text($x+114,$y+5,number_format($totdevengado));

        // Alineación de los montos correspondientes
        $longitud = strlen($totdescuento);

        if($longitud==6)
            $pdf->Text($x+146,$y+5,number_format($totdescuento));                

        if($longitud==5)
            $pdf->Text($x+148,$y+5,number_format($totdescuento));

        if($longitud==4)
            $pdf->Text($x+149,$y+5,number_format($totdescuento));

        $totpagar = $totdevengado - $totdescuento;

        $pdf->SetFillColor(180,180,180);
        $pdf->Rect(7,$lineatotales+8,195,8,'F');

        $pdf->SetFont('Arial','B',10);
        $pie= "NETO A PAGAR: ";
        $pdf->Text($x+70,$y+13,$pie);

        $longitud = strlen($totpagar);

        if($longitud==3)
            $pdf->Text($x+153,$y+13,number_format($totpagar));

        if($longitud==4)
            $pdf->Text($x+150,$y+13,number_format($totpagar));

        if($longitud==5)
            $pdf->Text($x+147,$y+13,number_format($totpagar));

        if($longitud==6)
            $pdf->Text($x+144,$y+13,number_format($totpagar));

        if($longitud==7)
            $pdf->Text($x+141,$y+13,number_format($totpagar));

        // Impresión del banco y cuenta a la cual se le consigna
        $pdf->SetFont('Arial','',8);
        $pie= "                                                                                                                                                                     __________________________";
        $pdf->Text($x,$y+35,$pie);
        $pie= "                                                                                                                                                                     RECIBI CONFORME";
        $pdf->Text($x,$y+40,$pie);

        if($extralegal=="CHECKED")
            $pie= "CONSIGNADO EN: EFECTIVO                                                                                                                  C.C.";
        else
        {
            if(($numcuenta=="")||($numcuenta==NULL))
                $pie= "CONSIGNADO EN: EFECTIVO                                                                                                                  C.C.";
            else
                $pie= "CONSIGNADO EN: ".strtoupper($banco)."                      CUENTA NO. ".$numcuenta."                            C.C.";            
        }
        
        $pdf->Text($x,$y+45,$pie);            

        // Genero el documento                
        // $nombrearchivo = $codigo."_".$documento;

        $nombrearchivo = $documento;
        $pdf->Output('recibostmp/'.$nombrearchivo.'.pdf','F');         // en físico

        // Almaceno en la tabla correspondiente
        $direccion = 'recibostmp/'.$nombrearchivo.'.pdf';
        $vsql4 = "INSERT INTO recibospdf (dni, direccion) VALUES ('".$dni."','".$direccion."')";
        $clase2->EjecutarSQL($vsql4);

        return;
    }
?>