<?php
include("../../../lib/Sistema.php");

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB(){
    $clase = new Sistema();
    $conexion = mysqli_connect($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion
////////////////////////////////////////////////////////////////////////////////////////////////////o
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    if($row = mysqli_fetch_row($result))
    {
        $retorno = $row[0];
        $i++;
    }
    return $retorno; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
///////////////////////////////////////////////////////////////////////////////////////////////////
function EjecutarSQL($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
    if(strtoupper(substr($sql,0,6)) == "INSERT")
        $retorno = mysqli_insert_id($conexion);
    disconnectDB($conexion); //desconectamos la base de datos
    return($retorno);
}

///// Registro el Uso de la API
$urlapi = $_SERVER['PHP_SELF'];
$vsql = "INSERT INTO estadisticasconsumosapi(urlapi,momento) VALUES('".$urlapi."',CURRENT_TIMESTAMP)";
EjecutarSQL($vsql);

//// Recibo los parametros segun el Caso
$ciudad    = @$_GET['ciudad'];              //// Ciudad del Pedido a Notificar para el Caso de Rappi
$codpedido = @$_GET['codpedido'];           //// Codigo de Pedido de Tienda Virtual


//////////////////////////////////////////////////
///// 1. Ciudad del Pedido
//////////////////////////////////////////////////
if(strlen($ciudad)>0)
{
    //// Busco la Sucursalid de la Zona Base
    $sucursalid = SeleccionarUno("SELECT Z.sucursalidprin FROM sucursales S INNER JOIN zonasbasetienda Z ON (Z.sucursalidprin = S.sucursalid) WHERE S.ciudadid = ".$ciudad);
    
    if($sucursalid != "")
    {
        $vsql = "INSERT INTO tareas_sucursal(sucursalid,tareaid,creador,momento,momentoinicio,permanente,retornarws,orden) VALUES('".$sucursalid."',16,'SYSTEM',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0,'16',1)";
        EjecutarSQL($vsql);
        $vsql = "INSERT INTO tareas_sucursal_log(sucursalid,tareaid,creador,momento,momentoinicio,permanente,retornarws,orden) VALUES('".$sucursalid."',16,'SYSTEM',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0,'16',1)";
        EjecutarSQL($vsql);
    }
}

//////////////////////////////////////////////////
///// 2. CodPedido Tienda
//////////////////////////////////////////////////
if(strlen($codpedido)>0)
{
    /// Traigo los datos de la Orden desde el Servicio Web
    $arrContextOptions=array(
        "ssl"=>array(
            "verify_peer"=>false,
            "verify_peer_name"=>false,
        ),
    ); 

    $respuestax = file_get_contents('https://plataforma.farmanorteonline.com/consulta-pedidos?codpedido='.$codpedido, false, stream_context_create($arrContextOptions));
    $datapedido = json_decode($respuestax,true);  
    $ciudad = $datapedido['codigo_ciudad'];

    //// Busco la Sucursalid de la Zona Base
    $zonabase = SeleccionarUno("SELECT zonabaseid FROM sucursales WHERE ciudadid = ".$ciudad);
    $sucursalid = SeleccionarUno("SELECT sucursalidprin FROM zonasbasetienda WHERE zonabaseid = ".$zonabase);

    if($sucursalid != "")
    {
        $vsql = "INSERT INTO tareas_sucursal(sucursalid,tareaid,creador,momento,permanente,retornarws,orden) VALUES('".$sucursalid."',16,'SYSTEM',CURRENT_TIMESTAMP,0,'16',1)";
        EjecutarSQL($vsql);
    }
}

/// Salida al Navegador
header('Content-type: application/json; charset=utf-8');
echo"200";
?>