<?php

include("../../lib/Sistema.php");

/**
 * Clase API del WebService
 * Permite hacer las 4 Actividades Básicas CRUD a la Tabla Existencias
 * Desde WebService
 * @author Said Rodriguez
 * @version 2017-01-28
 */

class api
{
	private $db;

	/**
	 * Constructor - Abre una conexion a la Base de Datos
	 *
	 * @param Vacío
	 * @return Conexion a la Base de Datos
	 */
	
	function __construct()
	{
		$clase = new Sistema();
		$this->db = new mysqli('192.168.14.252','root','d2218aa6664195','puntosfarmanorte');
	}

	/**
	 * Destructor - close DB connection
	 *
	 * @param Vacío
	 * @return Vacío
	 */

	function __destruct()
	{
		$this->db->close();
	}

	/**
	 * Obtiene la existencia en Sucursales del Producto consultado
	 * @param ID del Producto	 
	 * @return Lista de Existencia por Bodegas en Formato JSON
	 */
	function AfiliarPersona($params)
	{
		$query = "SELECT COUNT(*) existe FROM afiliado WHERE documento = '".$params['documento']."'";
		$list = array();
		$result = $this->db->query($query);
		while ($row = $result->fetch_assoc())
		    $existe  = $row['existe'];
        
        /// Si Existe - Devuelve Cod 99 - Persona ya Afiliada 
        if($existe>0)
          return(99);
        else
        {
        	/// En Caso de que no esté afiliado - Procede a Validar la Informacion
        	/// 1. Validacion - Cod 51 - Que se envie al menos un telefono
        	if((strlen($params['celular']) == 0)&&(strlen($params['telefonofijo']) == 0))
        		return(51);
            else
            {
	        	/// 2. Validacion - Cod 52 - Fecha de Nacimiento es Obligatorio
	        	if(strlen($params['fechanacimiento']) == 0)
	        		return(52);
	        	else
	        	{
                    /// Si los datos son Correctos se Inserta el Afiliado
                    $nom = strtoupper($params['nombres']);    	            $ape  = strtoupper($params['apellidos']);
		            $tip = strtoupper($params['tipodocumento']);            $doc  = strtoupper($params['documento']);
		            $sex = strtoupper($params['sexo']);        	            $fij  = strtoupper($params['telefonofijo']);
	                $cel = strtoupper($params['celular']);    	            $ciu  = strtoupper($params['ciudad']);
	                $fna = strtoupper($params['fechanacimiento']);  	    $ema  = strtolower($params['email']);
	                $dir = strtoupper($params['direccion']);                $bar  = strtoupper($params['barrio']);

	                /// Variables Fijas
	                $nac = "COL";                               $suc = 1;
	                $cre = "5";                                 $eda = (date("Y-n-d")-$fna);

	                /// 2. Inserto el Documento
					$vsql = "INSERT INTO afiliado(documento,nacionalidad,idsucursal,tipodocumento,nombres,apellidos,sexo,telefonofijo,celular,
						     departamento,ciudad,fechanacimiento,street,streetdos,email,creador,momento,edad) 
	                         VALUES('".$doc."','".$nac."','".$suc."','".$tip."','".$nom."','".$ape."','".$sex."','".$fij."','".$cel."','',
	                         '".$ciu."','".$fna."','".$dir."','".$bar."','".$ema."','".$cre."',CURRENT_TIMESTAMP,'".$eda."')";
					
					$stmt = $this->db->prepare($vsql);

		            //// Ejecuto la Consulta SQL
		            $r = $stmt->execute();
                    
                    /// Retorno 1 - Transaccion Exitosa 
 		            return(1);		            
	        	}	            	
            }	
        }	  
	}

} /// Fin de la Clase API
