<?php

include("../../lib/Sistema.php");
//require("../../libgeneral.php");

/**
 * Clase API del WebService
 * Permite hacer las 4 Actividades Básicas CRUD a la Tabla Transferencias
 * Desde WebService
 * @author Said Rodriguez
 * @version 2017-01-30
 */

class api
{
	private $db;

	/**
	 * Constructor - Abre una conexion a la Base de Datos
	 *
	 * @param Vacío
	 * @return Conexion a la Base de Datos
	 */
	
	function __construct()
	{
		$clase = new Sistema();
		$this->db = new mysqli($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
	}

	/**
	 * Destructor - close DB connection
	 *
	 * @param Vacío
	 * @return Vacío
	 */

	function __destruct()
	{
		$this->db->close();
	}

	/**
	 * Obtiene un Listado de Transferencias (Las Ultimas 200)
	 *
	 * @param Vacio	 
	 * @return Lista de Transferencias en Formato JSON
	 */
	function EjecutarComando($params)
	{
		$hecho = 0;

		//// Comando1 : Generar el archivo de Kardex Total
		if($params['comando'] == "KARDEXTOTAL")
		{
			$this->GenerarArchivoKardexTotal(date("mY"));
			$hecho++;
		}

		//// Comando2 : Recibir Globales
		
		//// Comando3 : Icono de la Familia

		return($hecho);
	}

	/////////////////////////////////////////////////////////
	//////  Envia el Archivo de Kardex Total  
	/////////////////////////////////////////////////////////
	function GenerarArchivoKardexTotal($periodo)
	{
		ini_set("memory_limit","300M");
		error_reporting(E_ALL);

		$archivo = "../../../Dropbox/".$_SESSION['G_SUCURSALPOS']."/todos/KARDEXTOTAL-".$_SESSION['G_SUCURSALPOS'].".sql";
		if(file_exists($archivo))
		unlink($archivo);
		
		///// Me conecto a la Base de Datos
		$clase = new Sistema();
		$bodegaid = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS'],'bodegas','codbodega','bodegaid');
		$bodegaid2 = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS']."B",'bodegas','codbodega','bodegaid');
		$wherebodegas = $bodegaid;
		if($bodegaid2 != "")  $wherebodegas.= ",".$bodegaid2;

		/// 1. Envio SOLO los siguientes Documentos : FVE - DVE - AJU - REN - RSA
		$anio = date("Y");   $anio--;
		$vsql   = "SELECT * FROM kardex WHERE fechadoc > '".$anio."-01-01' AND bodegaid IN (".$wherebodegas.") ORDER BY kardexid DESC";
		$conex  = $clase->Conectar();
		$result = @mysql_query($vsql,$conex);

		$fp = fopen($archivo,"w");
		$cont="";	 
		$i=0;      $j=0;
		while($row = @mysql_fetch_array($result))
		{ 
			if($i==0){
			$cont.="SET NAMES LATIN1;".Chr(13).Chr(10);	
			$cont.="DELETE LOW_PRIORITY FROM KARDEX WHERE fechadoc > '".$anio."-01-01' AND bodegaid IN (".$wherebodegas.");".Chr(13).Chr(10);	
			}
		
			if($j == 0)
			{ 
			if($i == 0)
				$cont.="INSERT LOW_PRIORITY IGNORE INTO kardex(tipodoc,prefijo,fechadoc,numero,productoid,periodo,bodegaid,sucursalid,cantidad,creador,momento) values('".$row['tipodoc']."','".$row['prefijo']."','".$row['fechadoc']."','".$row['numero']."',".$row['productoid'].",'".$row['periodo']."',".$bodegaid.",".$row['sucursalid'].",".$row['cantidad'].",'VENDEDOR','".$row['momento']."')";
			else
			{
				$cont.=";".Chr(13).Chr(10);	
				$cont.="INSERT LOW_PRIORITY IGNORE INTO kardex(tipodoc,prefijo,fechadoc,numero,productoid,periodo,bodegaid,sucursalid,cantidad,creador,momento) values('".$row['tipodoc']."','".$row['prefijo']."','".$row['fechadoc']."','".$row['numero']."',".$row['productoid'].",'".$row['periodo']."',".$bodegaid.",".$row['sucursalid'].",".$row['cantidad'].",'VENDEDOR','".$row['momento']."')";          
			}
			}
			else
			{
			$cont.=",('".$row['tipodoc']."','".$row['prefijo']."','".$row['fechadoc']."','".$row['numero']."',".$row['productoid'].",'".$row['periodo']."',".$row['bodegaid'].",".$row['sucursalid'].",".$row['cantidad'].",'VENDEDOR','".$row['momento']."')";
			}

			/// Solo 40 Registros mete por Linea
			if($j==40)
			$j = 0;           
			else
			$j++;
		
			$i++;		  
		} 

		
		fwrite($fp,$cont);
		fclose($fp);
		$clase->closeConnection();	 
	}  

        
} /// Fin de la Clase API
